/* 
 * :tabSize=8:indentSize=8:noTabs=false:
 * :folding=explicit:collapseFolds=1:
 *
 * MacOSPlugin.java - Main class Mac OS Plugin
 * Copyright (C) 2001, 2002 Kris Kopicki
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package macos;

//{{{ Imports
import java.util.Vector;
import javax.swing.*;
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.*;
import org.gjt.sp.jedit.msg.*;
import org.gjt.sp.util.Log;
import macos.menu.*;
import macos.script.*;
import com.apple.cocoa.application.*;
import com.apple.eawt.Application;
//}}}

public class MacOSPlugin extends EBPlugin
{
	//{{{ Variables
	static boolean started = false;
	private boolean osok;
	private Delegate delegate;
	//}}}
	
	//{{{ start() method
	public void start()
	{
		if(osok = osok())
		{
			delegate = new Delegate();
			NSApplication app = NSApplication.sharedApplication();
			
			Macros.registerHandler(new AppleScriptHandler());
			Application app2 = new Application();
			app2.addApplicationListener(delegate);
			app2.setEnabledPreferencesMenu(true);
			app2.setEnabledAboutMenu(true);
			
			app.setDelegate(delegate);
			//app.setServicesProvider(delegate);
		}
	} //}}}
	
	//{{{ handleMessage() method
	public void handleMessage(EBMessage message)
	{
		if (osok)
		{
			// Set type/creator codes for files
			if (message instanceof BufferUpdate)
				delegate.handleFileCodes((BufferUpdate)message);
			else if (message instanceof PropertiesChanged)
			{
				boolean b = jEdit.getBooleanProperty("MacOSPlugin.useSelection",
					jEdit.getBooleanProperty("MacOSPlugin.default.useSelection"));
				if (b)
					jEdit.setColorProperty("view.selectionColor",
						UIManager.getColor("textHighlight"));
			}
			// This is necessary to have a file opened from the Finder
			// before jEdit is running set as the currently active
			// buffer.
			else if (!started && message instanceof ViewUpdate)
				delegate.handleOpenFile((ViewUpdate)message);
		}
	}//}}}
	
	//{{{ osok() method
	private boolean osok()
	{
		final String osname = jEdit.getProperty("MacOSPlugin.depend.os.name");
		final String mrjversion = jEdit.getProperty("MacOSPlugin.depend.mrj.version");
		
		if (!System.getProperty("os.name").equals(osname))
		{
			// According to Slava this is better
			Log.log(Log.ERROR,this,jEdit.getProperty("MacOSPlugin.dialog.osname.message"));
			return false;
		}
		if (MiscUtilities.compareStrings(
			System.getProperty("mrj.version"),mrjversion,false) < 0)
		{
			SwingUtilities.invokeLater( new Runnable() { public void run() {
				GUIUtilities.error(null,"MacOSPlugin.dialog.mrjversion",new Object[] {mrjversion});
			}});
			return false;
		}

		return true;
	}//}}}
}
