<?
/* PHP Database Abstrated Trap Receiver (from snmptrapd)
 * Added by: Aaron Daubman <daubman@ll.mit.edu> 12/21/2003
 * Based on trap_receive.pl by Craig Small <csmall@small.dropbear.id.au>
 * Based on trap_reciever.php by Javier Szyszlican <javier@szysz.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTES - To receive traps:
 * snmptrapd.conf:
 * 	traphandle default cd /opt/jffnms/engine && php -q trap_receiver.php
 * command-line:
 *	snmptrapd -c /etc/snmp/snmptrapd.conf -f -P -On -n
 */

    $jffnms_functions_include="engine";
    include_once("../conf/config.php");
    
    $stdin = fopen('php://stdin', 'r');

    $hostname = trim(fgets($stdin,4096)) or die("Could not get hostname");
    $ipaddr = trim(fgets($stdin,4096)) or die("Could not get IP");

    //snmptrapd seems to prefer hostnames, and they become longer than 20 chars...
    if(strlen($ipaddr) > 20) $ipaddr = gethostbyname($ipaddr);

    $uptime = fgets($stdin,4096) or die("Could not get uptime");

    $trapoid = fgets($stdin,4096) or die("Could not get trapoid");

    $trapoid = preg_replace("/^\S+\s+(\S+)\s*$/", "$1", $trapoid);

    $output =  "------\nUptime: $uptime\nTrap OID: $trapoid\n";

    //prevent warnings:
    $varbinds = array();

    while($line=trim(fgets($stdin,4096)))
	if (preg_match ("/^(\S+)\s+\"?([^\" \t]+)\"?$/", $line, $matches)) 
	    $varbinds[$matches[1]] = $matches[2];
	else
	    $output .= "Not Matched: $line\n";

    fclose($stdin);
    
    foreach ($varbinds as $key=>$var)
	$output .= "Line ".(++$varnum)." is: $key ==> $var\n";

    logger ($output);

    // Insert into database:
    $now = date("Y-m-d H:i:s",time());
    $trap_id = db_insert ("traps",array("date"=>$now, "ip"=>$ipaddr, "trap_oid"=>$trapoid));
    
    logger ("New Trap ID: $trap_id\n");
    
    $oidid = 1;
    foreach ($varbinds as $key=>$var)
	db_insert("traps_varbinds",array("trapid"=>$trap_id, "oidid"=>$oidid++, "trap_oid"=>$key, "value"=>$var));

    db_close();
?>
