<?
    class jffnms_access_api { 
	var $session;
	
	function jffnms_access_api ($init_type = NULL) {
	    if (isset($init_type)) $this->init_type = $init_type;
	}
    
	function get($class_name) {
	    $new_class_name = "jffnms_remote_$class_name";
	    $obj = NULL;
	    
	    if (!class_exists($new_class_name)) {
	
		$methods = $this->_call($class_name,"get_methods",NULL);
	    	    
	        $class_code.=" class $new_class_name extends jffnms_access_api {\n";
		if (is_array($methods)) {
		    foreach ($methods as $meth) 
			if (!(($class_name=="jffnms") and ($meth=="get"))) { //don't overwrite the jffnms->get method
			    $class_code.=" function $meth() {\n";
		    	    $class_code.=" \$params = func_get_args();\n";
			    $class_code.=" return parent::_call('$class_name','$meth',\$params);\n";
		    	    $class_code.=" }\n";
			}
		    $class_code.=" }\n";

		    eval ($class_code);
		}
	    }
	    
	    if (class_exists($new_class_name)) { //class created
		$obj = new $new_class_name;
		$obj->session = &$this->session;
	    
		if ($class_name=="jffnms") { //special mail class
		    $jffnms_classes = $obj->jffnms ($this->init_type);
		
		    if ($this->init_type==1) //init all classes
			foreach ($jffnms_classes as $aux) 
			    if ($aux!="access_api")
				$obj->$aux = $this->get($aux);
		}
	    }
	    
	    return $obj;
	}
	
	function _call ($class,$method,$params) {
	    $server = get_config_option("jffnms_satellite_server_uri");
	    
	    if (empty($this->session)) $this->session = "get";
	        
	    $message = array(
		"sat_id"=>1,
		"class"=>$class,
		"method"=>$method,
		"params"=>$params,
		"session"=>$this->session
	    );

	    $ret = satellite_query ($server,$message,"GUIClient",0);
	    //debug (array(request=>$message,response=>$ret));

	    if (is_array($ret) && (isset($ret["session"]))) {
		$this->session = $ret["session"];
		unset ($ret["session"]);
	    }
	
	    return $ret;
	}
    }

    function alarms_get_status ($alarms) {
	$lower_alarm=256;
	$lower_alarm_id = 2;
	
	if (is_array($alarms))
	foreach ($alarms as $alarm_name=>$data) 
	    if ($data["alarm_level"] < $lower_alarm) {
		$lower_alarm = $data["alarm_level"];
		$lower_alarm_name = $alarm_name;
		$bgcolor = $data["bgcolor"];
		$fgcolor = $data["fgcolor"];
	    }
	    
	$alarms_parsed = array();
	$alarms_long = array();
	
	if (is_array($alarms))
	foreach($alarms as $key=>$alarm) {
	    if ($key=="total") $alarms_parsed[$key]="T=".$alarm[qty];
		else $alarms_parsed[$key]=strtoupper($key[0]).$alarm[qty];
	    
	    $alarms_long[$key]=$alarm["qty"];
	}
	$status = join("/",$alarms_parsed);

	return array($status,$bgcolor,$fgcolor,$alarms_long,$lower_alarm_name);
    }

    function profile ($tag) {
        $aux = $GLOBALS[jffnms]->get("profiles");
	$aux1 = $aux->get_value($tag,$GLOBALS[auth_user_id]);
	return $aux1;
    }

    function ImageStringCenter($im,$color,$y,$text,$big = 0) {

	if (!is_array($text)) $text = array($text);

	if ($big==0) {
	    $size = 2;
	    $charsize = 6;
	    $line_span = 9;
	}

	if ($big==1) {
	    $size = 4;
	    $charsize = 8;
	    $line_span = 13;
	}
	
	$len = (strlen($text)*$charsize);
	$sizex = imagesx($im);
	$sizey = imagesy($im);

	$cant_lines = count($text);
	$lines_space = ($cant_lines * $line_span);
	$space_left = ($sizey - $lines_space);
	$y_span = floor(($space_left/($cant_lines*2)));

	//echo "$sizey $lines_space $space_left $cant_lines $y_span ----";

	$line_number = 0;
	foreach ($text as $align=>$aux) {
	    $aux = substr($aux,0,($sizex/$charsize));
	    $len = (strlen($aux)*$charsize);

	    if (is_numeric($align)) $align = "center";
	    
	    switch ($align) {
		case "center" 	: $x=($sizex/2)-($len/2); break;
		case "left" 	: $x=($sizex-$len); break;
		case "right" 	: $x=0; break;
	    }
	    
	    ImageString ($im, $size, $x, $y+$y_span+($line_number*($line_span+$y_span)), $aux,$color);
	    $line_number++;
	}
    }

    function clean_url_array (&$list, $key,$value,$deep = 0) {
	if (is_array($value))
	    foreach ($value as $k=>$v) {
		//debug ("DEEP $deep - $key - $k - $v");
		$key_aux = (is_array($value)&&!empty($key))?"[$k]":$k;
		
		clean_url_array($list,$key.$key_aux,$v,$deep+1);
	    }
	else {
	    //debug ("VALUE $deep - $key - $value");
	    $list[] = urlencode($key)."=".urlencode($value);
	}
    }
    
    function clean_url($extra_vars = array(),$no_vars = array()) {
	if ($GLOBALS["_GET"]) $REQUEST_URI_VARS = array_merge($GLOBALS["_GET"],$GLOBALS["_POST"],$extra_vars); //suport for PHP 4.1.0 and older
    	    else $REQUEST_URI_VARS = array_merge($GLOBALS["HTTP_GET_VARS"],$GLOBALS["HTTP_POST_VARS"],$extra_vars);

	foreach ($no_vars as $delete)
	    unset($REQUEST_URI_VARS[$delete]);

	//$REQUEST_URI_VARS["pepe"]=array("pepe"=>array(1,2,3,3),"lalala","pepep",222333,array(1,2,"lala"=>array(5,"llaa"=>array(1,2,2))));
	
	$url_aux=array();
	clean_url_array($url_aux,"",$REQUEST_URI_VARS);
    
        $REQUEST_URI_CLEAN = $GLOBALS["SCRIPT_NAME"]."?".join("&",$url_aux);

	/*
        debug($GLOBALS["_GET"]);
        debug($url_aux);
	debug($REQUEST_URI_VARS);
	debug("B: ".$REQUEST_URI_CLEAN);
	debug("C: ".$GLOBALS["REQUEST_URI"]);
	*/
	$GLOBALS["REQUEST_URI"]=$REQUEST_URI_CLEAN; //cleaning up the URL
    }    

    function http_authenticate() {
	global $jffnms_version,$jffnms_real_path,$jffnms_rel_path;
	header( "WWW-Authenticate: Basic realm=\"JFFNMS $jffnms_version\"");
	header( "HTTP/1.0 401 Unauthorized");
	include("$jffnms_real_path/htdocs/logout.php");
	exit;
    }

    //This function creates the $filter array for interface_status, interface_list, etc. processed by interface_filter
    //from the URL from menu_reports
    function reports_make_interface_filter() {
	global $host_id, $interface_id, $map_id, $client_id, $view_all, $type_id, $use_interfaces;
    
	$filters = array();
	    
    	if ($interface_id) $filters["id"]=$interface_id;
	if ($client_id) $filters["client"]=$client_id;
	if ($type_id) $filters["type"]=$type_id;
	if ($host_id) $filters["host"]=$host_id;
	if ($map_id) $filters["map"]=$map_id;

	if (($view_all==1) || ((count($use_interfaces)==0) && (count($filters)==0))) { 
	    if (profile("REPORTS_VIEW_ALL_INTERFACES")) $filters=array("custom"=>array(array("1=1"))); //show all
		else $filters=array("custom"=>Array("1=2")); //show nothing
	} 

	return $filters;
    }

    function get_filter_option($name,$value,$field) {

	$fields = array (
	    "types.id"=>	array("function"=>"select_event_types",	"events_var"=>"type_id"),
	    "severity.level"=>	array("function"=>"select_severity_level","events_var"=>"severity_level"),
	    "hosts.id"=>	array("function"=>"select_hosts",	"events_var"=>"host_id"),
	    "zone.id"=>		array("function"=>"select_zones",	"events_var"=>"zone_id"),
	    "interfaces.id"=>	array("function"=>"select_interfaces",	"events_var"=>"interfaceid"),
	    "events.ack"=>	array("function"=>"checkbox",		"events_var"=>"ack")
	    );

	$aux = $fields[$field];

	if (is_array($aux)) {
	    if ($name) return call_user_func_array($aux["function"],array($name,$value));
	    else return $aux["events_var"];
	
	} else return $value;
    }



function reports_pass_options(){
    global $host_id, $interface_id, $client_id, $map_id, $use_interfaces,$view_all,$type_id;

    if ($host_id) echo hidden("host_id",$host_id);
    if ($client_id) echo hidden("client_id",$client_id);
    if ($interface_id) echo hidden("interface_id",$interface_id);
    if ($map_id) echo hidden("map_id",$map_id);
    if ($type_id) echo hidden("type_id",$type_id);
    if ($view_all) echo hidden("view_all",$view_all);

    if (is_array($use_interfaces)) foreach ($use_interfaces as $value) 
	echo hidden("use_interfaces[]",$value);
}

function adm_footer ($type = 1, $echo = 1) {

    if (isset($conexion)) $conexion = db_close();

    if ($type==1) {
	adm_table_row_close();
        adm_table_close();
    } 
    
    $result = "</BODY>\n</HTML>\n";
    if ($echo) echo $result;
    return $result;
}
    
function adm_control_option ($name,$frame,$url,$image = "bullet3.png",$colspan= "", $rowspan="", $width="",$control_rand = 1,$align = "center", $nojs = 0) { 
    global $normalColor,$jffnms_rel_path;

    if ($image=="") $image = "bullet3.png";

    //$control_name = $name;
    //if (($control_name=="") or ($control_rand==1)) 
    $control_name="control_".rand(1000,9999); 

    if ($nojs==0) {
	$js_over = "javascript: setPointer(this,false);";
	$js_out  = "javascript: setPointerOut(false);";
    } else {
	$js_over = "javascript: return true;";
	$js_out = "javascript: return true;";
    }
    
    $result = custom_table_cell_open("#$normalColor",
					$colspan,$rowspan,
					$align,"",
					$width,"",
					$js_over,$js_out,
					1,$control_name);
    
    
    $result1 = "";
    if ($image!="none") $result1 .= adm_image ("$jffnms_rel_path/images/$image");

    $result1 .= html_indenter();
    if ($name) $result1 .="&nbsp;$name";
    $result1.="\n";

    if ($url) $result .= linktext ($result1,$url,$frame,"{text-decoration: none;color: #0000ff;}","javascript: onClickControl('$control_name')");
    else $result .= $result1;
    
    $result .= custom_table_cell_close();
    
    echo $result;
}


function adm_image($src, $width ="", $height = "",$border = 0,$echo = 0, $alt = "",$custom="") {
    $result = "<img src='$src' border='$border'";
    
    if ($width) $result .=" width='$width'";
    if ($height) $result .=" height='$height'";
    if ($custom) $result .= " $custom";
        
    $result .= " alt='$alt'";
    
    //$result .= ">\n";
    $result .= ">";

    if ($echo) echo $result;
    return $result;
}

function table_header($title,$init,&$span,$cols, $total_items = -1) { 
    global $SCRIPT_NAME,$REQUEST_URI,$filter, $host_id, $client_id, $map_id, $use_interfaces, $interface_id;


    if (!$span) $span = 15;
    $option_width = "90";

    std_table_row("#D3DCE3");

    echo custom_table_cell_open("",$cols,"","left","","","",0);

    adm_table("700","","left",0,0,0);
    echo custom_table_row_open("",0,"center");

    if ($SCRIPT_NAME) $url= "$SCRIPT_NAME?";
	    
    $url = "$REQUEST_URI&action=&actionid=&filter=$filter";
	    
    adm_table_header_cell("<u>$title Administration</u>");

    if ($init > 0) adm_control_option("First","_self","$url&init=0","a-top.png","","",$option_width);
    else adm_control_option("&nbsp","","","none","","",$option_width);

    if ($init > 0) adm_control_option("Previous","_self","$url&init=".($init-$span),"a-left.png","","",$option_width);
    else adm_control_option("&nbsp","","","none","","",$option_width);

    if (($total_items == -1) || (($init+$span) < $total_items)) adm_control_option("Next","_self","$url&init=".($init+$span),"a-right.png","","",$option_width);
    else adm_control_option("&nbsp","","","none","","",$option_width);

    if (($total_items == -1) || (($init+($span*3)) < $total_items)) adm_control_option("3rd Next","_self","$url&init=".($init+($span*3)),"a-right.png","","",$option_width);
    else adm_control_option("&nbsp","","","none","","",$option_width);

    adm_control_option("More","_self","$url&span=".($span*2),"plus.png","","",$option_width);
    adm_control_option("Less","_self","$url&span=".($span/2),"minus.png","","",$option_width);
    adm_control_option("Add","_self","$url&action=add","new.png","","",$option_width);

    if ($filter || $host_id || $client_id || $map_id || $use_interfaces || $interface_id) 
	adm_control_option("<b><small>(Filtered)</small></b> View All","_self",
	    "$url&filter=&client_id=&host_id=&map_id=&use_interfaces=&interface_id=&","query.png");
    else adm_control_option("&nbsp","","","none","","",$option_width);
	    	
    adm_table_row_close();
    adm_table_close();
    
    adm_table_td_close();

    adm_table_row_close();
}     


function adm_form_close($echo =1) {
    $result .= html_indenter();
    $result .= "</form>\n";

    if ($echo==1) echo $result;
    return $result;
}

function adm_table_td_close() {
    echo custom_table_cell_close();
}

function adm_form($action = "",$method="POST",$target = "_self", $echo = 1) {
    global $SCRIPT_NAME, $id, $init, $filter, $span;

    $result .= html_indenter();
    $result .= "<form action='$SCRIPT_NAME?' method='$method' target='$target'>\n";

    $result .= hidden("actionid",$id);

    if ($action) $result .= hidden("action",$action);
 
    $result .= hidden("init",$init);
    $result .= hidden("span",$span);
    $result .= hidden("filter",$filter);
    $result .= hidden("admin_structure",$GLOBALS[admin_structure]);
    
    if ($echo) echo $result;
    return $result;
}

function show_license($title) {
?>
<!--
/* <? echo "$title\n" ?>
 * Copyright (C) <2002-2004> Javier Szyszlican <javier@szysz.com>
 *
 * This file is part of JFFNMS.
 *
 * JFFNMS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JFFNMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JFFNMS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
-->
<?
}

function adm_header($title,$bgcolor = "F5F5F5") {
    global $refresh,$REQUEST_URI;
    
    show_license($title);
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
    <TITLE><? echo $title ?></TITLE>
    <meta HTTP-EQUIV="Pragma" CONTENT="no-cache">
<? if ($refresh) { ?>
    <meta HTTP-EQUIV="Refresh" CONTENT="<? echo "$refresh;$REQUEST_URI" ?>">
<? } ?>
    <link rel="Shortcut Icon" href="<? echo $GLOBALS["jffnms_rel_path"]; ?>/images/favicon.ico">
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <meta http-equiv="Content-language" content="en">
    <meta http-equiv="Content-Style-Type" content="text/css">
    <meta http-equiv="Content-Script-Type" content="text/javascript">

<SCRIPT>
function setPointer(theCell,select) { }

function setRowPointer(theRow, thePointerColor) {
    if (typeof(theRow.style) == 'undefined' || typeof(theRow.cells) == 'undefined') return false;
    //var row_cells_cnt = theRow.cells.length;
    for (var c = 0; c < 2; c++)  theRow.cells[c].bgColor = thePointerColor;
    return true;
}

function setPointerOut(all) { }

function onClickControl(all) { }

function DeleteRow(id,url){
    if (confirm("Are your sure you want to delete this record (ID "+id+") ?")) window.location = url;
}
</SCRIPT>
</HEAD>
<BODY leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" bgcolor="<? echo "#$bgcolor" ?>">
<?
    html_indent_none();
}


function adm_table_header($title,$init,$span, $cols ,$total = -1) {
    adm_table("","","","",2,1);
    table_header($title,$init,$span,$cols ,$total); 
}

function adm_table($width="100%",$height="100%",$align="center",$border="0",$pad="0",$space="0",$valign="middle",$echo = 1) {
    if (!$width) $width="100%";
    if (!$height) $height="1";
    if (!$border) $border="0";
    if (!$align) $align="center";
    if (!$pad) $pad="0";
    if (!$space) $space="0";
    if (!$valign) $valign="middle";

    $result = html_indenter();
    $result .= "<table width='$width' height='$height' align='$align' valign='$valign' border='$border' cellpadding='$pad' cellspacing='$space'>\n";
    if ($echo) echo $result;
    
    //html_indent_more();
    
    return $result;

}

function html_indent_init () {
    if (!isset($GLOBALS["html_indent"]) || !isset($GLOBALS["html_indents"])) {
	$GLOBALS["html_indent"] = 0;
	$GLOBALS["html_indents"] = array($GLOBALS["html_indent"]=>0);
    }
}

function html_indent_more () {
    $GLOBALS["html_indent"]++;
    html_indent_none();
}

function html_indent_less () {
    $GLOBALS["html_indent"]--;
    html_indent_none();
}

function html_indent_none() {
    html_indent_init();
    $GLOBALS["html_indents"][$GLOBALS["html_indent"]]=0;
}

function html_indent_already() {
    html_indent_init();
    return $GLOBALS["html_indents"][$GLOBALS["html_indent"]];
}

function html_indenter ($verify = 0, $count = 1, $echo = 0) {
    if ((html_indent_already()==0) || (!$verify)) {
	$result = "";
	for ($i = 0; $i < $GLOBALS["html_indent"]; $i++) $result .= "\t";

	if ($count) $GLOBALS["html_indents"][$GLOBALS["html_indent"]]=1;

	if ($echo) echo $result;
	return $result;
    } else 
	echo "!";
}

function adm_table_close($echo=1) {
    $result = html_indenter();
    $result .= "</table>\n";
    if ($echo) echo $result;
    return $result;
}

function adm_table_row ($bgcolor = "") {
    echo custom_table_row_open($bgcolor,1);
}

function adm_table_row_close () {
    echo custom_table_row_close();
}

function std_table_row ($bgcolor = "") {
    echo custom_table_row_open($bgcolor,0);
}

function table_row($text ="&nbsp;",$align="",$colspan="",$rowspan="",$echo = 1) {
    
    $result.= custom_table_row_open ("",0);
    $result.= adm_table_cell($text,$align,$colspan,$rowspan,"",0);
    $result.= custom_table_row_close();

    if ($echo) echo $result;
    return $result;
}

function custom_table_row_open ($bgColor = "",$mark = 1,$align = "", $valign="",$height="", $id = "") {
    global $overColor, $normalColor;


    if ($bgColor=="") $bgColor = "#$normalColor";

    $result = html_indenter();
    $result .= "<tr";

    if ($id)  $result.=" id='$id'";
    if ($align)  $result.=" align='$align'";
    if ($valign) $result.=" valign='$valign'";
    if ($height) $result.=" height='$height'";

    if ($mark==1) $result.=" onmouseover=\"setRowPointer(this, '#$overColor')\" onmouseout=\"setRowPointer(this, '$bgColor')\"";
    $result .= " bgcolor=\"$bgColor\">\n";

    html_indent_more();
    
    return $result;
}

function custom_table_row_close () {

    html_indent_less();

    $result = html_indenter();
    $result .= "</tr>\n";

    return $result;
}

function custom_table_cell_close () {

    html_indent_less();
    
    $result = html_indenter();
    $result .= "</td>\n";

    return $result;
}


function custom_table_cell_open (   $bgcolor = "", 
				    $colspan = "", $rowspan = "", 
				    $align = "left", $valign ="",
				    $width = "", $height ="",
				    $mouse_over = "", $mouse_out = "",
				    $nowrap = 1 ,$id = "") {

    $result = html_indenter();

    $result .= "<td";
    if ($id) $result .= " id='$id'";
    if ($nowrap) $result .= " nowrap";
    if ($width) $result .= " width='$width'";
    if ($height) $result .= " height='$height'";
    if ($align) $result .= " align='$align'";
    if ($valign) $result .= " valign='$valign'";
    if ($colspan) $result .= " colspan='$colspan'";
    if ($rowspan) $result .= " rowspan='$rowspan'";
    if ($bgcolor) $result .= " bgcolor='$bgcolor'";

    if ($mouse_over) $result .= " onMouseOver=\"$mouse_over\"";
    if ($mouse_out) $result .= " onMouseOut=\"$mouse_out\"";

    $result .= ">\n";

    html_indent_more();
    
    return $result;
}    

function adm_table_header_cell ($text, $align = "left", $colspan = "", $rowspan = "", $echo = 1) {

    $result .= custom_table_cell_open ("",$colspan,$rowspan,$align);
    $result .= html_indenter();
    $result .= "<b>$text</b>\n";
    $result .= custom_table_cell_close();

    if ($echo) echo $result;
    return $result;
}

function adm_table_cell ($text, $align = "left", $colspan = "", $rowspan = "", $valign="middle", $echo = 1) {

    $result .= custom_table_cell_open ("",$colspan,$rowspan,$align,$valign);
    $result .= html_indenter();
    $result .= "$text\n";
    $result .= custom_table_cell_close();

    if ($echo) echo $result;
    return $result;
}

function adm_control_header($title) {
    global $REQUEST_URI,$refresh,$normalColor,$overColor,$selectedColor;

    show_license($title);
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
    <TITLE><? echo $title ?></TITLE>
    <meta HTTP-EQUIV="Pragma" CONTENT="no-cache">
<? if ($refresh) { ?>
    <meta HTTP-EQUIV="Refresh" CONTENT="<? echo "$refresh;$REQUEST_URI" ?>">
<? } ?>
    <link rel="Shortcut Icon" href="<? echo $GLOBALS[jffnms_rel_path]; ?>/images/favicon.ico">
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <meta http-equiv="Content-language" content="en">
    <meta http-equiv="Content-Style-Type" content="text/css">
    <meta http-equiv="Content-Script-Type" content="text/javascript">

<SCRIPT>
var normalColor = '#<? echo $normalColor ?>';
var overColor = '#<? echo $overColor ?>';
var selectedColor = '#<? echo $selectedColor ?>';

function setPointer(theCell,select) {
    if (select == true) {
	theCell.bgColor = selectedColor;
    } else if (theCell.bgColor.toUpperCase() == normalColor.toUpperCase()) 
	    theCell.bgColor = overColor;
    return true;
}

function setPointerOut(all) {
    theRow = document.getElementById("control_tr");
    for (var c = 0; c < theRow.cells.length; c++) 
	if ((theRow.cells[c].bgColor.toUpperCase() == overColor.toUpperCase()) || (all == true))
	    theRow.cells[c].bgColor = normalColor;

    return true;
}

function onClickControl(CellName) {
    setPointerOut(true);
    setPointer(document.getElementById(CellName),true);
    return true;
}
</SCRIPT>
</HEAD>
<BODY leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" bgcolor="<? echo "#$normalColor" ?>">
<? 
    //html_indent_more();

    adm_table("100%","100%","center",0,0,0); 
 
    $result = custom_table_row_open("",0,"","top");
    $result .= custom_table_cell_open("black", 30, "",	"","",	"","1");
    //$result .= "&nbsp";
    $result .= custom_table_cell_close();
    $result .= custom_table_row_close();
    $result .= custom_table_row_open("",0,"center","middle","","control_tr");
    
    echo $result;
} 

function news_get ($news_url) {
    $news = http_post_message($news_url,news_parse());
    if (!empty($news))
	return @explode("\n",$news);
    else 
	return false;
}

function javascript_refresh($url,$time) {
$time_usec = $time*1000;
if (($url) && ($time > 1)) $value = "<script> refresh_timeout = window.setTimeout ('$url',$time_usec); </script>\n";
return $value;
}

function play_sound($file) {
    global $jffnms_rel_path;
    
    if ($file) {
	$result .= html_indenter();
	$result .= "<embed src='$jffnms_rel_path/sounds/$file' autostart='true' type='audio/x-wav' height=0 width=0 hidden='true' loop='no'></embed>";
    }
    return $result;
}


function adm_standard_edit_delete($type = 1, $id_aux = NULL, $view_name = NULL) {
    global $id,$REQUEST_URI,$filter;

    if (empty($view_name)) $view_name = "View";

    if (isset($id_aux)) $id = $id_aux;
    
    adm_control_option ("Edit","_self","$REQUEST_URI&action=edit&actionid=$id&filter=$filter","edit.png");
    adm_control_option ("Del","_self","javascript: DeleteRow('$id','$REQUEST_URI&action=delete&actionid=$id&filter=$filter');","delete.png");
    if ($type==2) adm_control_option ($view_name,"_self","$REQUEST_URI&action=view&actionid=$id&filter=$filter","query.png");
}



function table_shift_color (&$color) {
    global $table_row_color1,$table_row_color2;
    
    if ($color == "#$table_row_color1") $color = "#$table_row_color2";
	else $color = "#$table_row_color1";
    return $color;
}

    //main GET Interfaces manual discovery code
    function host_interfaces($host_ip,$rocommunity,$hostid) {
	//JS for Checkboxes
	echo "<SCRIPT>

	function check(field_aux) {
	    field=document.forms[0].elements[field_aux];
	    for (i = 0; i < field.length; i++) { 
		if (field[i].checked==true) field[i].checked = false; 
		else	
		    field[i].checked = true; 
	    }
	    return true;
	}
	
	</SCRIPT>
	";
	adm_table("50%","0","left",0,0,3);

	$GLOBALS[SCRIPT_NAME]="adm_interfaces.php";
	$GLOBALS["init"]=0;
	adm_form("bulkadd","POST");

        $max_fields = 15;
	$found_interfaces = 0;
	
	$types_obj = $GLOBALS[jffnms]->get("interface_types");
	$types_fields_obj = $GLOBALS[jffnms]->get("interface_types_fields");
	$host_obj = $GLOBALS[jffnms]->get("hosts");

	//get host data
	$host_db_data = current($host_obj->get_all($hostid));
	
	$types_obj->get(); //get pointer to interface types list
	
	$bulk_add = Array();
	
	while ($record = $types_obj->fetch()) if ($record["id"] > 1) { //avoid no interface type
	    extract($record);
	    
	    unset($db);
	    unset($host);
	    unset($fields);
	    
    	    //get interfaces from the database
	    $db = $host_obj->interfaces($hostid,$id);

	    //do a discovery and get the interface list
	    $host = $host_obj->discovery($autodiscovery_function,$host_ip,$rocommunity,$hostid,$autodiscovery_parameters);

	    if (!is_array($db)) $db = array();
	    if (!is_array($host)) $host = array();
	    if (!is_array($fields)) $fields = array();
	    //debug ($db);
	    //debug ($host);

	    //merge all keys
	    $interface_ids_list = array_unique(array_merge(array_keys($db),array_keys($host)));
	    asort($interface_ids_list);
	    reset($interface_ids_list);

	    if ((count($interface_ids_list) > 0) || ($record["allow_manual_add"]==1)) { //key is valid 
	    
		$fields = $types_fields_obj->get_all(NULL,array("itype"=>$record["id"],"exclude_types"=>20));
		//debug ($fields);
		
		std_table_row($GLOBALS["selectedColor"]);
		adm_table_header_cell($description,"center",$max_fields);
		adm_table_row_close();

		std_table_row();
		adm_table_header_cell("Action","center");
		adm_table_header_cell("Index","center");
		adm_table_header_cell("Name","center");
		adm_table_header_cell("Status");

		$internal_fields = array("host","type","client","poll","sla","show_rootmap","make_sound","interface");
		foreach ($internal_fields as $fname)
		    $fields[]=array("name"=>$fname,"showable"=>0,"overwritable"=>1);
		unset ($internal_fields);


		$showable_fields = 4;
		
		foreach ($fields as $key=>$fdata)
		    if ($fdata["ftype"]==3) {
			$index_field = $fdata["name"];
			$fields[$key]["showable"]=0;
		    } else
			if (($fdata["showable"]==1) && ($fdata["ftype_handler"]!="bool")) {
	    		    adm_table_header_cell($fdata["description"],"center");
			    $showable_fields++;
			}

		$fields_left = $max_fields - $showable_fields;
		
		if ($fields_left > 0) 
		    adm_table_header_cell("&nbsp;","",$fields_left);
	    	
		adm_table_row_close();

		foreach ($interface_ids_list as $key) { //key is valid 
		    $found_interfaces++; //number of interfaces found on all  the host
		    
	    	    table_shift_color($color);
		    adm_table_row($color);
		    
		    if (is_array($host[$key])) {	//interface is in the host
			$value = $host[$key]; 		//get the value from the host returned data
			$value[$index_field]=$key; 	//put the KEY as the Index Field (for adding)
		    } else {
		        $value = $db[$key]; //get the value from the interfaces table in the DB
			$value["admin"] = "(Not Found in Host)";
		    }
		
		    ad_set_default (&$value["host"],$hostid);
		    ad_set_default (&$value["type"],$record["id"]);
		    ad_set_default (&$value["client"],$host_db_data["autodiscovery_default_customer"]);
		    ad_set_default (&$value["poll"],$record["autodiscovery_default_poller"]);
		    ad_set_default (&$value["sla"],$record["sla_default"]);

		    foreach ($value as $fname=>$data)
			$value[$fname] = str_replace("\"","",$value[$fname]);

		    //Update Handler
		    $update_function = $record["update_handler"];
		    $real_function = "handler_$update_function";
		    $function_file = get_config_option("jffnms_real_path")."/engine/handlers/$update_function.inc.php";
	
		    if (in_array($function_file,get_included_files()) || (file_exists($function_file) &&  (include_once($function_file)))) {
	    		if (function_exists($real_function))
	        	    call_user_func_array($real_function,array(false, &$value,$db[$key]));
	    		else
			    logger("ERROR: Calling Function '$real_function' doesn't exists.<br>\n");
		    } else
			logger ("ERROR Loading file $function_file.<br>\n");

		    //Show Field Values
		    
		    if (is_array($db[$key])) //if the interface is in the DB
			adm_table_cell (linktext("Edit","adm_interfaces.php?action=edit&interface_id=".$db[$key]["id"]),"center"); //put a edit link
		    else { //if its not, put an ADD link
			$bulk_add_id++;
		
			foreach ($fields as $fdata) 
			    if (($fdata["default_value"]!=$value[$fdata["name"]]) && (!empty($value[$fdata["name"]])))
				$bulk_add[$bulk_add_id][$fdata["name"]]=$value[$fdata["name"]]; //store value for multiple add
		
			adm_table_cell (checkbox_value("bulk_add_ids[]",$bulk_add_id,0),"center");
		    }
		
	    	    adm_table_cell($value[$index_field],"right");
		    adm_table_cell($value["interface"]);
		    
		    //Status
		    unset ($aux);
		    if (isset($value["admin"])) $aux[]=$value["admin"];
		    if (isset($value["oper"]))  $aux[]=$value["oper"];
		    
		    adm_table_cell(join(" / ",array_unique($aux)));

		    //other fields
		    foreach ($fields as $fdata) 
			if (($fdata["showable"]==1) && ($fdata["ftype_handler"]!="bool"))
	    		    adm_table_cell(substr($value[$fdata["name"]],0,40),(is_numeric($value[$fdata["name"]])?"right":"left"));

		    if ($fields_left > 0) 
			adm_table_cell("&nbsp;","",$fields_left);
		
		    adm_table_row_close();
		} //foreach found interface

		table_shift_color($color);
		std_table_row($color);

		if ($allow_manual_add==1) {
		    adm_table_cell(linktext("Manual Add","adm_interfaces.php?action=bulkadd".
			"&bulk_add_ids[]=0".
			"&bulk_add[0][host]=$hostid".
			"&bulk_add[0][type]=".$record["id"].
			"&bulk_add[0][client]=".$host_db_data["autodiscovery_default_customer"].
			"&bulk_add[0][poll]=".$record["autodiscovery_default_poller"].
			"&bulk_add[0][sla]=".$record["sla_default"].
			""),"center",2);
		    adm_table_cell("&nbsp","center",$max_fields-2);
		} 
		adm_table_row_close();
	
		table_shift_color($color);
		std_table_row($color);
		adm_table_row("&nbsp","center",$max_fields);
		adm_table_row_close();
	    } //count(host) > 0
	} //interface types while
	
	unset($host_obj);
	
	if ($found_interfaces==0) table_row("<b>No Interfaces Found</b>","center",$max_fields);
	else 	
	    if (is_array($bulk_add) && (count($bulk_add)>0)) {
	        while ( list($key,$data) = each ($bulk_add)) {
	    	    while ( list($field,$value) = each ($data)) 
	    		$html.=hidden("bulk_add[$key][$field]",$value,0);

		    $html.="\n";
		}
		echo $html;

	    	table_shift_color($color);
		std_table_row($color);
		adm_table_cell(adm_form_submit("Add Marked Interfaces"),"center",2);
		adm_table_cell("<input type=checkbox onClick=\"this.value=check('bulk_add_ids[]');\"> Mark All Interfaces ","center",1);
		adm_table_row_close();
	    }

	adm_form_close();
	adm_table_close();
	
    }	//function

    function adm_frame_menu_split ($adm_name,$standard = 0) { 

	if ($standard==1) 
	    $url = "adm/adm_standard.php?admin_structure=$adm_name&filter=".$GLOBALS["actionid"];
	else 
	    $url = "adm/adm_$adm_name.php?filter=".$GLOBALS["actionid"];

	adm_frame_menu (
	    "30%", urlencode("adm/".basename($_SERVER["SCRIPT_NAME"])."?".$_SERVER["QUERY_STRING"]."&action="),
	    "70%", urlencode($url));
    }

    function adm_frame_menu($size1,$url1,$size2,$url2) {
	global $jffnms_rel_path;

	$url = "$jffnms_rel_path/admin/menu_frame.php?size1=$size1&scroll1=yes&name1=$url1&size2=$size2&scroll2=yes&name2=$url2";

	echo "<SCRIPT> 

	if (parent.frames[0]) {
	    if (parent.frames[0].name.substr(0,4)=='menu')
		document.location = '$url';
	    else 
		parent.location = '$url';
	    
	} else
	    document.location = '$url';

	</SCRIPT>";
	die();
    }

    function show_event ($event,$color,$expand,$map_id,$filter_id) {
	global $REQUEST_URI,$express_filter,$jffnms_rel_path,$view_type,$journal_id;

	$image_ack = $jffnms_rel_path."/images/".(($event["ack"]>0)?"tickmark.png":"alert.gif");

	$filter_url = $_SERVER["SCRIPT_NAME"]."?filter_id=$filter_id";
	
	$date_unix = strtotime($event["date"]);
	$day = date ("j M",$date_unix);
	$hour = date ("H:i:s",$date_unix);
	$event_text = $event["text"];

	switch ($view_type) {

	    case "html":
		$day_filter = date ("Y-m-d",$date_unix-(60*60*24));
		$fgcolor = $event["fgcolor"];
		$bgcolor = $event["bgcolor"];
		$id = $event["id"];

		$summary_ids = (is_array($event["summary_ids"])?join(",",$event["summary_ids"]):$event["id"]);

		$output =
		"\n<tr id='event$id' align='center' bgcolor='$bgcolor'>\n".

		//Date + Hour
		"\t<td nowrap bgcolor='$color'>\n".
		"\t\t<a name='$id' href='$filter_url&express_filter=date,$day_filter'>\n".
		"\t\t$day</a> $hour</td>\n".
	
		// Checkbox + Detail		
		"\t<td nowrap bgcolor='$color'>\n".
		"\t\t<input type='checkbox' name='checkedid[]' value='$summary_ids'".((($event["ack"]!=0) && ($journal_id==$event["ack"]))?" checked":"").">\n".
		"\t\t<a href='$REQUEST_URI&expand=$id&refresh=0&journal_id=0#".($id+1)."'><img src='$image_ack' width='16' height='16'></a></td>\n".
	
		// Type
		"\t<td nowrap ".(($event["show_host"]==0)?" colspan=3":"").(($event["ack"]!=0)?" class='ack'":"").">\n".
		"\t\t<a style='color: $fgcolor;' href='$filter_url&express_filter=$express_filter^type,".$event["type_id"]."&map_id=$map_id'>\n".
		"\t\t".$event["type_description"]."</a></td>\n";
	
		if ($event["show_host"] == 1) //Host + Zone
		    $output .= 
		    "\t<td nowrap align='left'".(empty($event["zone_image"])?" colspan=2":"").(($event["ack"]!=0)?" class='ack'":"").">\n".
		    "\t\t<a style='color: $fgcolor;' href='$filter_url&express_filter=$express_filter^host,".$event["host_id"]."&map_id=$map_id'>\n".
		    "\t\t&nbsp;".$event["host_name"]." ".$event["zone"]."&nbsp;</a></td>\n".
		    (!empty($event["zone_image"])?
		    "\t<td nowrap width=1 align='center'>\n".
		    "\t\t<a style='color: $fgcolor;' href='$filter_url&express_filter=$express_filter^zone,".$event["zone_id"]."&map_id=$map_id'>\n".
		    "\t\t<img src='$jffnms_rel_path/images/".$event["zone_image"]."'></a>":"")."</td>\n";
	
		// Event Text
		$output .= 
		"\t<td align='left' nowrap style='color: $fgcolor; background-color: $bgcolor;'".(($event["ack"]!=0)?" class='ack'":"").">\n".
		"\t\t&nbsp;&nbsp;".$event_text."</td>\n".
		"</tr>\n";

		if ($expand == $id) {
		    $output .= 
		    "<tr bgcolor='$color'>\n".
		    "\t<td colspan=2>&nbsp;</td>\n".
	
	    	    "\t<td colspan=4>\n".
		    "\t\t<table>\n".
		    "\t\t\t<tr>\n".
		    "\t\t\t\t<td nowrap><u>Username:</u> <a href='$filter_url&express_filter=$express_filter^username,".$event["user"]."'>".$event["user"]."</a></td>\n".
		    "\t\t\t\t<td nowrap><u>Interface:</u> <a href='$filter_url&express_filter=$express_filter^interface,".$event["interface"]."^host,".$event["host_id"]."'>".$event["interface"]."</a></td>\n".
		    "\t\t\t\t<td nowrap><u>Severity:</u> ".$event["severity"]."</td>\n".
		    "\t\t\t\t<td nowrap><u>State:</u> ".$event["state"]."</td>\n".
		    "\t\t\t\t<td nowrap><u>Info:</u> ".$event["$info"]."</td>\n".
		    "\t\t\t</tr>\n";

	    	    if ($event["ack"] > 1) {
			$journal = $GLOBALS["jffnms"]->get("journal");
			$journal_data = current($journal->get_all($ack));
		
		        if ($journal_data["ticket"]) 
			    $ticket_url = linktext("Ticket ".$journal_data["ticket"],$journal->view_ticket_url($ack));
		
			$output .= table_row("<b>Journal:</b> ".$journal_data["subject"]. " $ticket_url","",5,"",0);
		    }
		
		    $output .= 
		    "\t\t</table>\n".
		    "\t</td>\n".
		    "</tr>\n";
		} 
	    break;

	    case "csv":
		$day_only = date ("Y-m-d",$date_unix);

		$fields = array($day_only,$hour,$event["host_name"],$event["zone_name"],$event["user"],$event["interface"],
		    $event["type_description"],$event["state"],$event["info"],$event["severity"]);
		
		foreach ($fields as $key=>$aux)
		    $fields[$key] = "\"".$aux."\"";
		
		$output = join(",",$fields)."\n";
	    break;
	
	    case "rdf":
    		$output .= "<item>\n\t<title>".$event["severity"]." - ".$event["host_name"]." ".$event["zone"].": ".$event_text."</title>\n</item>\n";
	    break;
	}

	echo $output;
    } //function show_event


    function time_hms ($unixtime) {
	return str_pad(floor($unixtime/(60*60)),2,"0",STR_PAD_LEFT).date(":i:s",$unixtime);
    }

    function interface_shortname_and_card ($interface,$type_description,$break_by_card) {

	$interface_len = strlen($interface);
	
	for ($pos = 0; ($pos < $interface_len) && (!is_numeric($interface[$pos])); $pos++);
	    
        $space_pos = strpos($interface," ");

	if ($interface_len > 9) {
	    if ($pos <= 0) $pos = 1;
	    if ($pos == $interface_len) $pos = 1; //if there was no numbers in the interface name
	    
	    if ($space_pos!==FALSE) { //if the interface has a space in it
		$int = substr($interface,0,$space_pos)." ".$interface[$space_pos+1]; // from Real Memory take Real M
		$pos = $space_pos;
	    } else 
		$int = $interface[0].substr($interface,$pos,$interface_len); //from Serial9/3/4 take S9/3/4
	} else $int = $interface;

	if (strpos($interface,"/")===FALSE) $pos--; //if the interface is not part of a card Serial3/4 | Tunnel0 then pos-- because card will not include the number
	

	if ($break_by_card==1) {
	    if (is_numeric($interface[$pos])) //Card Number Numeric Serial9 interface[pos]="9"
		$card = substr(substr($interface,0,$pos),0,8).$interface[$pos]; //use Serial9
	    else 
		$card = substr(substr($interface,0,$pos+1),0,9); //interface[pos] not numeric, use all 9 chars from interface name
	} else 
	    $card = substr($type_description,0,9);
	
	$int = trim($int);
	$card = trim ($card);
	
	//debug ("inter: $interface -- int: $int -- card: $card -- len: $interface_len -- pos: $pos -- pos1: $pos1");// continue;
	return Array ($int, $card);
    }

    //Get the Graph File from object and store it in a local (public) place
    function performance_graph ($interface_object, $id, $graph_filename, $graph_function, $sizex, $sizey, $title, $graph_time_start, $graph_time_stop,$aux = "") {
	list ($value, $graph_data) = $interface_object->graph($id, $graph_function, $sizex,$sizey, $title,$graph_time_start,$graph_time_stop,$aux);

	$graph_data = base64_decode ($graph_data);
	$fp = fopen ($graph_filename, "wb+");
	fputs($fp,$graph_data);
	fclose ($fp);

	return $value;
    }

    function news_parse () {
	return array(site=>$GLOBALS["jffnms_site"],version=>$GLOBALS["jffnms_version"],h=>$GLOBALS["info"]["hosts"]["data"],i=>$GLOBALS["info"]["interfaces"]["data"],f=>$_SERVER["REMOTE_ADDR"]);
    }

?>
