<?php
 /* Logfile Consolidator. This is part of JFFNMS
  * Copyright (c) 2008 Craig Small <csmall@small.dropbear.id.au>
  * This program is licensed under the GNU GPL, full terms in the LICENSE file
  */

function consolidate_logfiles() {
    $query_logfiles = 'SELECT id,filename,last_poll_date,offset FROM logfiles';
    $result_logfiles = db_query($query_logfiles) or die("Query failed - LF1 - ".db_error());
    while ($logfile_record = db_fetch_array($result_logfiles)) {
        $lfid = $logfile_record['id'];
        logger('LF '.$lfid.':='.$logfile_record['filename']."\n");
        if (!is_readable($logfile_record['filename'])) {
            logger("LF $lfid:= file no readable, skipping.\n");
            continue;
        }
        $stat = @stat($logfile_record['filename']);
        if(!$stat) {
            logger("LF $lfid:= Cannot stat logfile, skipping.\n");
            continue;
        }
        $logfile_offset = $logfile_record['offset'];
        // Has it changed, ie has the modtime changed
        if ($stat['mtime'] <= $logfile_record['last_poll_date']) {
            logger("LF $lfid:= Logfile hasn't change size last poll, skipping.\n");
            continue;
        }
        // New file?
        if ($stat['ctime'] > $logfile_record['last_poll_date']) {
            logger("LF $lfid:= Logfile new, resetting offset to 0.\n");
            $logfile_offset = 0;
        } elseif ($stat['size'] == $logfile_offset) {
            logger("LF $lfid:= Logfile hasn't grown, skipping.\n");
            continue;
        } elseif ($stat['size'] < $logfile_offset) {
            logger("LF $lfid:= Logfile has shrunk!! Resetting offset to 0.\n");
            $logfile_offset = 0;
        }
        if (($fp = fopen($logfile_record['filename'], 'r')) == NULL) {
            logger("LF $lfid:= Cannot open logfile for reading.\n");
            continue;
        }
        //Line up the matches
        $match_records = get_db_list(
            array('logfiles_match_items', 'logfiles_match_groups'),
            null,//ids
            array('logfiles_match_items.*'),
            array(
                array('logfiles_match_groups.logfile','=',$logfile_record['id']),
                array('logfiles_match_groups.match_item','=','logfiles_match_items.id'),
            ),
            array(
                array('logfiles_match_group.pos','asc'),
            )
        );
        fseek($fp, $logfile_offset);
        $lines_read=0;
        while(!feof($fp)) {
            $line = fread($fp, 4096);
            $lines_read++;
        }
        $logfile_offset = ftell($fp);
    }

}

/**
 * logilfe_parse_field - Extract a field from a logfile
 * @field_name : selects that the field will be
 * @line:   current logfile line
 * @regs:   matches from regular expressions
 */
function logile_parse_field($field_name, $line, $regs)
{
    switch($field_name) {
    case '*':  // complete message
        return $line;
    case 'D': // Only data
        return(join(' ',$regs));
    default:
        if (is_numeric($field_name)
            if (array_key_exists($regs,$field_name))
                return $regs["$field_name"];
            else
                return '';
    }
    // No parsing, so its a literal
    return $field_name;
}



