/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.hostchooser;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JLabel;
import net.sf.jftp.JFtp;
import net.sf.jftp.gui.framework.HButton;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HPasswordField;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.wrappers.WebdavConnection;

public class WebdavHostChooser
extends HFrame
implements ActionListener,
WindowListener {
    public static HTextField host = new HTextField("URL:", "http://localhost", 35);
    public static HTextField user = new HTextField("Username:", "guest");
    public static HPasswordField pass = new HPasswordField("Password:", "nopasswd");
    private HPanel okP = new HPanel();
    private HButton ok = new HButton("Connect");
    private ComponentListener listener = null;
    private boolean useLocal = false;

    public WebdavHostChooser(ComponentListener l, boolean local) {
        this.listener = l;
        this.useLocal = local;
        this.init();
    }

    public WebdavHostChooser(ComponentListener l) {
        this.listener = l;
        this.init();
    }

    public WebdavHostChooser() {
        this.init();
    }

    public void init() {
        this.setLocation(100, 150);
        this.setTitle("WebDAV Connection... (ALPHA STATE)");
        this.setBackground(this.okP.getBackground());
        host.setMinimumSize(new Dimension(500, 50));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("North", host);
        HPanel p = new HPanel();
        p.setLayout(new GridLayout(2, 2, 5, 3));
        p.add(user);
        p.add(pass);
        p.add(new JLabel(""));
        p.add(this.okP);
        this.okP.add(this.ok);
        this.getContentPane().add("South", p);
        this.ok.addActionListener(this);
        this.setDefaultCloseOperation(0);
        WebdavHostChooser.pass.text.addActionListener(this);
        this.setModal(false);
        this.setVisible(false);
        this.addWindowListener(this);
        host.setText("http://www.planetpdf.com/planetpdf/webdavdemo/");
        user.setText("guest");
        pass.setText("guest");
        this.pack();
    }

    public void update() {
        this.setVisible(true);
        this.toFront();
        host.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok || e.getSource() == WebdavHostChooser.pass.text) {
            this.setCursor(new Cursor(3));
            String htmp = host.getText().trim();
            String utmp = user.getText().trim();
            String ptmp = pass.getText();
            if (this.useLocal) {
                WebdavConnection con = new WebdavConnection(htmp, utmp, ptmp, (ConnectionListener)((Object)JFtp.localDir));
                JFtp.statusP.jftp.addLocalConnection("Webdav", con);
                con.chdir(htmp);
            } else {
                WebdavConnection con = new WebdavConnection(htmp, utmp, ptmp, (ConnectionListener)((Object)JFtp.remoteDir));
                JFtp.statusP.jftp.addConnection("Webdav", con);
                con.chdir(htmp);
            }
            this.setCursor(new Cursor(0));
            this.dispose();
            JFtp.mainFrame.setVisible(true);
            JFtp.mainFrame.toFront();
            if (this.listener != null) {
                this.listener.componentResized(new ComponentEvent(this, 0));
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

