/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.FtpHost;
import net.sf.jftp.system.StringUtils;

public class HostList
extends JDialog {
    private String promptHost = " Host : ";
    private String promptUser = " User : ";
    private String promptPass = " Password : ";
    private String promptName = " Name : ";
    private String promptPort = " Port : ";
    private String promptButtonCancel = "Cancel";
    private String promptButtonOk = "  Ok  ";
    private String promptButtonSave = " Apply ";
    private String promptButtonNew = " New  ";
    private String promptButtonDelete = "Delete";
    private String promptDialogTitle = " J-FTP Host Selection ";
    private JPanel jpHostInfo;
    private JTextField jtfHost;
    private JTextField jtfUser;
    private JPasswordField jtfPass;
    private JTextField jtfName;
    private JTextField jtfPort;
    private JLabel jlHost;
    private JLabel jlUser;
    private JLabel jlPass;
    private JLabel jlName;
    private JLabel jlPort;
    private JSplitPane jsplitpane;
    private JScrollPane jscrollpane;
    private JPanel jpbuttons;
    private JButton jbsave;
    private JButton jbcancel;
    private JButton jbok;
    private JButton jbnew;
    private JButton jbdelete;
    private JList hostList;
    private DefaultListModel hostListModel;
    private FtpHost selectedHostInfo = null;

    public HostList(JDialog parent) {
        super(parent);
        this.setTitle(this.promptDialogTitle);
        this.init();
        this.setSize(600, 300);
    }

    protected void initListeners() {
        this.hostList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                HostList.this.onSelectHost();
            }
        });
        this.jbsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HostList.this.onSave();
            }
        });
        this.jbok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HostList.this.onOk();
            }
        });
        this.jbcancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HostList.this.onCancel();
            }
        });
        this.jbnew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HostList.this.onNew();
            }
        });
        this.jbdelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HostList.this.onDelete();
            }
        });
    }

    public FtpHost getFtpHost() {
        this.selectedHostInfo = null;
        this.setVisible(true);
        return this.selectedHostInfo;
    }

    protected void init() {
        this.initPrompts();
        this.initHostInfoPanel();
        this.initButtonPanel();
        this.initHostListFrame();
        this.loadHostList();
        this.initListeners();
        if (this.hostListModel.size() > 0) {
            this.hostList.setSelectedIndex(0);
        } else {
            this.updateHostInfoPanel();
        }
        this.selectedHostInfo = this.getSelected();
        this.setModal(true);
    }

    protected void initPrompts() {
    }

    protected void initButtonPanel() {
        this.jpbuttons = new JPanel();
        this.jpbuttons.setLayout(new FlowLayout(2));
        this.jbcancel = new JButton(this.promptButtonCancel);
        this.jbok = new JButton(this.promptButtonOk);
        this.jbsave = new JButton(this.promptButtonSave);
        this.jbnew = new JButton(this.promptButtonNew);
        this.jbdelete = new JButton(this.promptButtonDelete);
        this.jpbuttons.add(this.jbsave);
        this.jpbuttons.add(this.jbok);
        this.jpbuttons.add(this.jbcancel);
    }

    protected void initHostInfoPanel() {
        this.jtfHost = new JTextField(20);
        this.jtfUser = new JTextField(20);
        this.jtfPass = new JPasswordField(20);
        this.jtfName = new JTextField(20);
        this.jtfPort = new JTextField(20);
        this.jlHost = new JLabel(this.promptHost);
        this.jlUser = new JLabel(this.promptUser);
        this.jlPass = new JLabel(this.promptPass);
        this.jlName = new JLabel(this.promptName);
        this.jlPort = new JLabel(this.promptPort);
        this.jpHostInfo = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.jpHostInfo.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbl.setConstraints(this.jlName, gbc);
        gbc.gridy = 1;
        gbl.setConstraints(this.jlHost, gbc);
        gbc.gridy = 2;
        gbl.setConstraints(this.jlUser, gbc);
        gbc.gridy = 3;
        gbl.setConstraints(this.jlPass, gbc);
        gbc.gridy = 4;
        gbl.setConstraints(this.jlPort, gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbl.setConstraints(this.jtfName, gbc);
        gbc.gridy = 1;
        gbl.setConstraints(this.jtfHost, gbc);
        gbc.gridy = 2;
        gbl.setConstraints(this.jtfUser, gbc);
        gbc.gridy = 3;
        gbl.setConstraints(this.jtfPass, gbc);
        gbc.gridy = 4;
        gbl.setConstraints(this.jtfPort, gbc);
        this.jpHostInfo.add(this.jlName);
        this.jpHostInfo.add(this.jlHost);
        this.jpHostInfo.add(this.jlUser);
        this.jpHostInfo.add(this.jlPass);
        this.jpHostInfo.add(this.jlPort);
        this.jpHostInfo.add(this.jtfName);
        this.jpHostInfo.add(this.jtfHost);
        this.jpHostInfo.add(this.jtfUser);
        this.jpHostInfo.add(this.jtfPass);
        this.jpHostInfo.add(this.jtfPort);
    }

    protected void initHostListFrame() {
        this.hostListModel = new DefaultListModel();
        this.hostList = new JList(this.hostListModel);
        this.jscrollpane = new JScrollPane(this.hostList);
        JPanel jptempleft = new JPanel(new BorderLayout());
        jptempleft.add((Component)this.jscrollpane, "Center");
        JPanel jptempbutt = new JPanel(new FlowLayout());
        jptempbutt.add(this.jbnew);
        jptempbutt.add(this.jbdelete);
        jptempleft.add((Component)jptempbutt, "South");
        JPanel jptemp = new JPanel(new BorderLayout());
        jptemp.add((Component)this.jpbuttons, "South");
        jptemp.add((Component)this.jpHostInfo, "Center");
        this.jsplitpane = new JSplitPane(1, jptempleft, jptemp);
        this.getContentPane().add(this.jsplitpane);
    }

    protected void loadHostList() {
        int i = 0;
        while (i >= 0) {
            String filename = Settings.login.concat(String.valueOf(i));
            String[] host_info = LoadSet.loadSet(filename);
            if (host_info == null || host_info.length == 1) {
                i = -1;
                continue;
            }
            FtpHost ftpHost = new FtpHost();
            try {
                ftpHost.hostname = host_info[0];
                ftpHost.username = host_info[1];
                ftpHost.password = host_info[2];
                ftpHost.name = host_info[3];
                ftpHost.port = host_info[4];
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                // empty catch block
            }
            this.hostListModel.addElement(ftpHost);
            ++i;
        }
    }

    public void onSelectHost() {
        this.updateHostInfoObject();
        this.selectedHostInfo = this.getSelected();
        this.updateHostInfoPanel();
    }

    public void onDelete() {
        Object selected = this.hostList.getSelectedValue();
        this.hostListModel.removeElement(selected);
        this.selectedHostInfo = null;
        if (this.hostListModel.size() > 0) {
            this.hostList.setSelectedIndex(0);
        } else {
            this.updateHostInfoPanel();
        }
        this.onSave();
        this.hostList.repaint();
    }

    public void onSave() {
        File f;
        this.updateHostInfoObject();
        int i = 0;
        while ((f = new File(Settings.login.concat(String.valueOf(i)))).exists()) {
            f.delete();
            ++i;
        }
        int len = this.hostListModel.size();
        for (i = 0; i < len; ++i) {
            FtpHost ftphost = (FtpHost)this.hostListModel.elementAt(i);
            String htmp = StringUtils.cut(ftphost.hostname, " ");
            String utmp = StringUtils.cut(ftphost.username, " ");
            String ptmp = StringUtils.cut(ftphost.password, " ");
            String ntmp = StringUtils.cut(ftphost.name, " ");
            String ttmp = StringUtils.cut(ftphost.port, " ");
            SaveSet s = new SaveSet(Settings.login.concat(String.valueOf(i)), htmp, utmp, ptmp, ntmp, ttmp);
        }
        this.hostList.repaint();
    }

    public void onOk() {
        this.selectedHostInfo = this.getSelected();
        this.onSave();
        this.dispose();
    }

    public void onCancel() {
        this.selectedHostInfo = null;
        this.dispose();
    }

    public void onNew() {
        FtpHost ftpHost = new FtpHost();
        ftpHost.name = "undefined";
        ftpHost.username = "undefined";
        ftpHost.hostname = "undefined";
        ftpHost.password = "undefined";
        ftpHost.port = "21";
        this.hostListModel.addElement(ftpHost);
        this.hostList.setSelectedValue(ftpHost, true);
        this.selectedHostInfo = ftpHost;
    }

    private FtpHost getSelected() {
        int sel = this.hostList.getSelectedIndex();
        if (sel < 0 || sel > this.hostListModel.size() - 1) {
            return null;
        }
        return (FtpHost)this.hostListModel.elementAt(this.hostList.getSelectedIndex());
    }

    private void updateHostInfoPanel() {
        if (this.selectedHostInfo == null) {
            this.jtfName.setText("");
            this.jtfUser.setText("");
            this.jtfPass.setText("");
            this.jtfHost.setText("");
            this.jtfPort.setText("");
            this.jtfName.setEnabled(false);
            this.jtfUser.setEnabled(false);
            this.jtfHost.setEnabled(false);
            this.jtfPass.setEnabled(false);
            this.jtfPort.setEnabled(false);
        } else {
            this.jtfName.setEnabled(true);
            this.jtfUser.setEnabled(true);
            this.jtfHost.setEnabled(true);
            this.jtfPass.setEnabled(true);
            this.jtfPort.setEnabled(true);
            this.jtfName.setText(this.selectedHostInfo.name);
            this.jtfUser.setText(this.selectedHostInfo.username);
            this.jtfPass.setText(this.selectedHostInfo.password);
            this.jtfHost.setText(this.selectedHostInfo.hostname);
            this.jtfPort.setText(this.selectedHostInfo.port);
        }
    }

    private void updateHostInfoObject() {
        if (this.selectedHostInfo == null) {
            return;
        }
        this.selectedHostInfo.hostname = this.jtfHost.getText();
        this.selectedHostInfo.name = this.jtfName.getText();
        this.selectedHostInfo.username = this.jtfUser.getText();
        this.selectedHostInfo.password = new String(this.jtfPass.getPassword());
        this.selectedHostInfo.port = this.jtfPort.getText();
    }
}

