/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.innerclass;

import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    private final Class<?> declaringClass;
    private final String innerClassName;

    Invoker(Class<?> declaringClass, String innerClassName) {
        this.declaringClass = declaringClass;
        this.innerClassName = innerClassName;
    }

    public Class<?> get() {
        String namespace = this.declaringClass.getName();
        for (Class<?> innerClass : this.declaringClass.getDeclaredClasses()) {
            if (!innerClass.getName().equals(this.expectedInnerClassName(namespace))) continue;
            return innerClass;
        }
        return null;
    }

    private String expectedInnerClassName(String namespace) {
        return Strings.concat((Object[])new Object[]{namespace, "$", this.innerClassName});
    }
}

