/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteArrayAssert
extends ArrayAssert<byte[]> {
    ByteArrayAssert(byte ... actual) {
        super(actual);
    }

    public ByteArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public ByteArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public ByteArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ByteArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public ByteArrayAssert contains(byte ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public ByteArrayAssert containsOnly(byte ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public ByteArrayAssert excludes(byte ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((byte[])this.actual);
    }

    private List<Object> list(byte[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (byte value : values) {
            list.add(value);
        }
        return list;
    }

    public ByteArrayAssert satisfies(Condition<byte[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ByteArrayAssert doesNotSatisfy(Condition<byte[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ByteArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public ByteArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public ByteArrayAssert isEqualTo(byte[] expected) {
        if (!Arrays.equals((byte[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public ByteArrayAssert isNotEqualTo(byte[] array) {
        if (Arrays.equals((byte[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public ByteArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((byte[])this.actual).length;
    }

    public ByteArrayAssert isSameAs(byte[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ByteArrayAssert isNotSameAs(byte[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

