/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Fail;

public final class PrimitiveFail {
    static void failIfEqual(String message, char actual, char value) {
        if (actual == value) {
            Fail.fail(Fail.errorMessageIfEqual(message, Character.valueOf(actual), Character.valueOf(value)));
        }
    }

    static void failIfEqual(String message, byte actual, byte value) {
        if (actual == value) {
            Fail.fail(Fail.errorMessageIfEqual(message, actual, value));
        }
    }

    static void failIfEqual(String message, short actual, short value) {
        if (actual == value) {
            Fail.fail(Fail.errorMessageIfEqual(message, actual, value));
        }
    }

    static void failIfEqual(String message, int actual, int value) {
        if (actual == value) {
            Fail.fail(Fail.errorMessageIfEqual(message, actual, value));
        }
    }

    static void failIfEqual(String message, long actual, long value) {
        if (actual == value) {
            Fail.fail(Fail.errorMessageIfEqual(message, actual, value));
        }
    }

    static void failIfEqual(String message, float actual, float value) {
        if (Float.compare(actual, value) == 0) {
            Fail.fail(Fail.errorMessageIfEqual(message, Float.valueOf(actual), Float.valueOf(value)));
        }
    }

    static void failIfEqual(String message, double actual, double value) {
        if (Double.compare(actual, value) == 0) {
            Fail.fail(Fail.errorMessageIfEqual(message, actual, value));
        }
    }

    static void failIfNotEqual(String message, char actual, char expected) {
        if (actual != expected) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, Character.valueOf(actual), Character.valueOf(expected)));
        }
    }

    static void failIfNotEqual(String message, byte actual, byte expected) {
        if (actual != expected) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, actual, expected));
        }
    }

    static void failIfNotEqual(String message, short actual, short expected) {
        if (actual != expected) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, actual, expected));
        }
    }

    static void failIfNotEqual(String message, int actual, int expected) {
        if (actual != expected) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, actual, expected));
        }
    }

    static void failIfNotEqual(String message, long actual, long expected) {
        if (actual != expected) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, actual, expected));
        }
    }

    static void failIfNotEqual(String message, float actual, float expected) {
        if (Float.compare(actual, expected) != 0) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, Float.valueOf(actual), Float.valueOf(expected)));
        }
    }

    static void failIfNotEqual(String message, double actual, double expected) {
        if (Double.compare(actual, expected) != 0) {
            Fail.fail(Fail.errorMessageIfNotEqual(message, actual, expected));
        }
    }

    static void failIfNotLessThan(String message, char actual, char value) {
        if (actual >= value) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, Character.valueOf(actual), Character.valueOf(value)));
        }
    }

    static void failIfNotLessThan(String message, byte actual, byte value) {
        if (actual >= value) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, actual, value));
        }
    }

    static void failIfNotLessThan(String message, short actual, short value) {
        if (actual >= value) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, actual, value));
        }
    }

    static void failIfNotLessThan(String message, int actual, int value) {
        if (actual >= value) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, actual, value));
        }
    }

    static void failIfNotLessThan(String message, long actual, long value) {
        if (actual >= value) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, actual, value));
        }
    }

    static void failIfNotLessThan(String message, float actual, float value) {
        if (Float.compare(actual, value) >= 0) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, Float.valueOf(actual), Float.valueOf(value)));
        }
    }

    static void failIfNotLessThan(String message, double actual, double value) {
        if (Double.compare(actual, value) >= 0) {
            Fail.fail(Fail.errorMessageIfNotLessThan(message, actual, value));
        }
    }

    static void failIfNotGreaterThan(String message, char actual, char value) {
        if (actual <= value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, Character.valueOf(actual), Character.valueOf(value)));
        }
    }

    static void failIfNotGreaterThan(String message, byte actual, byte value) {
        if (actual <= value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, actual, value));
        }
    }

    static void failIfNotGreaterThan(String message, short actual, short value) {
        if (actual <= value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, actual, value));
        }
    }

    static void failIfNotGreaterThan(String message, int actual, int value) {
        if (actual <= value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, actual, value));
        }
    }

    static void failIfNotGreaterThan(String message, long actual, long value) {
        if (actual <= value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, actual, value));
        }
    }

    static void failIfNotGreaterThan(String message, float actual, float value) {
        if (Float.compare(actual, value) <= 0) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, Float.valueOf(actual), Float.valueOf(value)));
        }
    }

    static void failIfNotGreaterThan(String message, double actual, double value) {
        if (Double.compare(actual, value) <= 0) {
            Fail.fail(Fail.errorMessageIfNotGreaterThan(message, actual, value));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, char actual, char value) {
        if (actual > value) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, Character.valueOf(actual), Character.valueOf(value)));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, byte actual, byte value) {
        if (actual > value) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, short actual, short value) {
        if (actual > value) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, int actual, int value) {
        if (actual > value) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, long actual, long value) {
        if (actual > value) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, float actual, float value) {
        if (Float.compare(actual, value) > 0) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, Float.valueOf(actual), Float.valueOf(value)));
        }
    }

    static void failIfNotLessThanOrEqualTo(String message, double actual, double value) {
        if (Double.compare(actual, value) > 0) {
            Fail.fail(Fail.errorMessageIfNotLessThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, char actual, char value) {
        if (actual < value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, Character.valueOf(actual), Character.valueOf(value)));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, byte actual, byte value) {
        if (actual < value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, short actual, short value) {
        if (actual < value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, int actual, int value) {
        if (actual < value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, long actual, long value) {
        if (actual < value) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, actual, value));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, float actual, float value) {
        if (Float.compare(actual, value) < 0) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, Float.valueOf(actual), Float.valueOf(value)));
        }
    }

    static void failIfNotGreaterThanOrEqualTo(String message, double actual, double value) {
        if (Double.compare(actual, value) < 0) {
            Fail.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(message, actual, value));
        }
    }

    private PrimitiveFail() {
    }
}

