/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.awt.Frame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameMatcher
extends NamedComponentMatcherTemplate<Frame> {
    private Object title;

    public static FrameMatcher withName(String name) {
        return new FrameMatcher(name, ANY);
    }

    public static FrameMatcher withTitle(String title) {
        return new FrameMatcher(ANY, (Object)title);
    }

    public static FrameMatcher any() {
        return new FrameMatcher(ANY, ANY);
    }

    private FrameMatcher(Object name, Object title) {
        super(Frame.class, name);
        this.title = title;
    }

    public FrameMatcher andTitle(String newTitle) {
        this.title = newTitle;
        return this;
    }

    public FrameMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(Frame frame) {
        if (!this.isNameMatching(frame.getName())) {
            return false;
        }
        return this.arePropertyValuesMatching(this.title, frame.getTitle());
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "name=", this.quotedName(), ", ", "title=", this.quoted(this.title), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]"});
    }
}

