/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import javax.swing.JToolBar;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JToolBarDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ContainerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JToolBarFixture
extends ContainerFixture<JToolBar>
implements CommonComponentFixture {
    private JToolBarDriver driver;

    public JToolBarFixture(Robot robot, JToolBar target) {
        super(robot, target);
        this.createDriver();
    }

    public JToolBarFixture(Robot robot, String toolbarName) {
        super(robot, toolbarName, JToolBar.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JToolBarDriver(this.robot));
    }

    void updateDriver(JToolBarDriver newDriver) {
        this.driver = newDriver;
    }

    public JToolBarFixture floatTo(Point point) {
        this.driver.floatTo((JToolBar)this.target, point.x, point.y);
        return this;
    }

    public JToolBarFixture unfloat() {
        this.driver.unfloat((JToolBar)this.target);
        return this;
    }

    public JToolBarFixture unfloat(UnfloatConstraint constraint) {
        this.driver.unfloat((JToolBar)this.target, constraint.value);
        return this;
    }

    @Override
    public JToolBarFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JToolBarFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JToolBarFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JToolBarFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JToolBarFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JToolBarFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JToolBarFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JToolBarFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JToolBarFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JToolBarFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JToolBarFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JToolBarFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JToolBarFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JToolBarFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JToolBarFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JToolBarFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnfloatConstraint {
        NORTH("North"),
        EAST("East"),
        SOUTH("South"),
        WEST("West");

        public final String value;

        private UnfloatConstraint(String value) {
            this.value = value;
        }
    }
}

