/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.fest.swing.keystroke.KeyStrokeMapping;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.keystroke.KeyStrokeMappingProvider_en;

public class KeyStrokeMap {
    private static final Map<Character, KeyStroke> CHAR_TO_KEY_STROKE = new HashMap<Character, KeyStroke>();
    private static final Map<KeyStroke, Character> KEY_STROKE_TO_CHAR = new HashMap<KeyStroke, Character>();

    private static void initialize() {
        KeyStrokeMap.addKeyStrokesFrom(new KeyStrokeMappingProvider_en());
    }

    public static synchronized void addKeyStrokesFrom(KeyStrokeMappingProvider provider) {
        for (KeyStrokeMapping entry : provider.keyStrokeMappings()) {
            KeyStrokeMap.add(Character.valueOf(entry.character()), entry.keyStroke());
        }
    }

    private static void add(Character character, KeyStroke keyStroke) {
        CHAR_TO_KEY_STROKE.put(character, keyStroke);
        KEY_STROKE_TO_CHAR.put(keyStroke, character);
    }

    public static synchronized void clearKeyStrokes() {
        CHAR_TO_KEY_STROKE.clear();
        KEY_STROKE_TO_CHAR.clear();
    }

    public static KeyStroke keyStrokeFor(char character) {
        return CHAR_TO_KEY_STROKE.get(Character.valueOf(character));
    }

    public static char charFor(KeyStroke keyStroke) {
        Character character = KEY_STROKE_TO_CHAR.get(keyStroke);
        if (character == null) {
            int mask = keyStroke.getModifiers() & 0xFFFFFFFE;
            character = KEY_STROKE_TO_CHAR.get(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), mask));
            if (character == null) {
                return '\uffff';
            }
        }
        return character.charValue();
    }

    private KeyStrokeMap() {
    }

    static {
        KeyStrokeMap.initialize();
    }
}

