/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.applet.Applet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.monitor.EventQueueMapping;
import org.fest.swing.monitor.WindowEventQueueMapping;
import org.fest.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class Context {
    @GuardedBy(value="lock")
    private final WindowEventQueueMapping windowEventQueueMapping;
    @GuardedBy(value="lock")
    private final EventQueueMapping eventQueueMapping;
    private final Object lock = new Object();

    Context(Toolkit toolkit) {
        this(toolkit, new WindowEventQueueMapping(), new EventQueueMapping());
    }

    Context(Toolkit toolkit, WindowEventQueueMapping windowEventQueueMapping, EventQueueMapping eventQueueMapping) {
        this.windowEventQueueMapping = windowEventQueueMapping;
        this.eventQueueMapping = eventQueueMapping;
        this.windowEventQueueMapping.addQueueFor(toolkit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Window> rootWindows() {
        HashSet<Window> rootWindows = new HashSet<Window>();
        Object object = this.lock;
        synchronized (object) {
            rootWindows.addAll(this.windowEventQueueMapping.windows());
        }
        rootWindows.addAll(Collections.list((Object[])Frame.getFrames()));
        return rootWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventQueue storedQueueFor(Component c) {
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.storedQueueFor(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextFor(Component component) {
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.removeMappingFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContextFor(Component component) {
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.addQueueFor(component);
            this.eventQueueMapping.addQueueFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    EventQueue eventQueueFor(Component c) {
        Component component = Context.topParentOf(c);
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.queueFor(component);
        }
    }

    @RunsInEDT
    private static Component topParentOf(final Component c) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                Component parent = c;
                while (!(parent instanceof Applet) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                return parent;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<EventQueue> allEventQueues() {
        HashSet<EventQueue> eventQueues = new HashSet<EventQueue>();
        Object object = this.lock;
        synchronized (object) {
            eventQueues.addAll(this.windowEventQueueMapping.eventQueues());
            eventQueues.addAll(this.eventQueueMapping.eventQueues());
        }
        return eventQueues;
    }
}

