/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import java.util.concurrent.TimeUnit;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public final class Pause {
    private static final int DEFAULT_DELAY = 30000;
    private static final int SLEEP_INTERVAL = 10;

    public static void pause(Condition condition) {
        Pause.pause(condition, 30000L);
    }

    public static void pause(Condition condition, Timeout timeout) {
        if (timeout == null) {
            throw new NullPointerException("The given timeout should not be null");
        }
        Pause.pause(condition, timeout.duration());
    }

    public static void pause(Condition condition, long timeout) {
        if (condition == null) {
            throw new NullPointerException("The condition to verify should not be null");
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!condition.test()) {
            if (watch.isTimeOut()) {
                condition.done();
                throw new WaitTimedOutError(Strings.concat((Object[])new Object[]{"Timed out waiting for ", condition}));
            }
            Pause.pause(10L);
        }
        condition.done();
    }

    public static void pause(Condition[] conditions) {
        Pause.pause(conditions, 30000L);
    }

    public static void pause(Condition[] conditions, Timeout timeout) {
        Pause.pause(conditions, timeout.duration());
    }

    public static void pause(Condition[] conditions, long timeout) {
        Pause.validate(conditions);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!Pause.areSatisfied(conditions)) {
            if (watch.isTimeOut()) {
                Pause.done(conditions);
                throw new WaitTimedOutError(Strings.concat((Object[])new Object[]{"Timed out waiting for ", Arrays.format((Object)conditions)}));
            }
            Pause.pause(10L);
        }
        Pause.done(conditions);
    }

    private static void validate(Condition[] conditions) {
        if (conditions == null) {
            throw new NullPointerException("The array of conditions to verify should not be null");
        }
        if (Arrays.isEmpty((Object[])conditions)) {
            throw new IllegalArgumentException("The array of conditions to verify should not be empty");
        }
        for (Condition condition : conditions) {
            if (condition != null) continue;
            throw new NullPointerException(Strings.concat((Object[])new Object[]{"The array of conditions <", Arrays.format((Object)conditions), "> contains null value(s)"}));
        }
    }

    private static boolean areSatisfied(Condition[] conditions) {
        for (Condition condition : conditions) {
            if (condition.test()) continue;
            return false;
        }
        return true;
    }

    private static void done(Condition[] conditions) {
        for (Condition condition : conditions) {
            condition.done();
        }
    }

    public static void pause(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("Time unit cannot be null");
        }
        Pause.pause(unit.toMillis(timeout));
    }

    public static void pause(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void pause() {
        Pause.pause(10L);
    }

    private Pause() {
    }
}

