#ifndef PYTYPE_BASICS_H
#define PYTYPE_BASICS_H
#include <Python.h>
#include <mx/mxDateTime.h>
#include "../jpilot_src/libplugin.h"
#include <pi-buffer.h>
#include <vobject.h>

#define PyObject_JPTYPE				\
  buf_rec saved_br;				\
  PCRecType rt;					\
  unsigned int unique_id;			\
  int deleted;					\
  int modified;					\
  int busy;					\
  int secret;					\
  int archived;					\
  int category;					\
  int unsaved_changes;				\
  int (*packer)(void *, pi_buffer_t *, void *);

typedef struct {
  PyObject_HEAD
  PyObject_JPTYPE
  void *a;
} PyPiBase;


void SetBasicRecordObjectAttributeDefaults(PyObject *self, int (*packer)( ));

void SetSavedBrAndRTandUniqueIDandAttribs(PCRecType rt, unsigned int unique_id, 
					  unsigned char attrib, int size, 
					  void *buf, PyObject *self);

char *FriendlyNameForRecordType(PCRecType rt);

PyObject *Attribute_Repr(PyObject *self);
PyObject *PyPi_Getbool(PyObject *self, void *closure);
int       PyPi_Setbool(PyObject *self, PyObject *value, void *closure);
PyObject *PyPi_GetCategory(PyObject *self, void *closure);
int       PyPi_SetCategory(PyObject *self, PyObject *value, void *closure);

VObject *safeAddPropValue(VObject *o, const char *id, char *val);
VObject *safeAddPropValuePart(VObject *o, const char *id, char *val);

#define PALMOSCHARENCODING "palmos"
/* was "cp1252", pre Python 2.3. Backport of palmos to 2.2 via cp works too.*/


#define FREE_SAVEDBUFFERS_AND_DEL_OBJECT(self) {		\
    if (self->saved_br.size > 0 && self->saved_br.buf) {	\
      free(self->saved_br.buf);					\
    }								\
    PyObject_Del(self);						\
  }

#define pyint_strcpy(topointer, frmpointer) {			\
    if (frmpointer != NULL) {					\
      if((topointer = malloc(strlen(frmpointer)+1)) == NULL) {	\
	PyErr_SetString(PyExc_MemoryError,"Not enough memory");	\
	return -1;						\
      } else {							\
	strcpy(topointer,frmpointer);				\
      }								\
    } else {							\
      topointer = NULL;						\
    }};

#define pyp_strcpy(topointer, frmpointer) {			\
    if (frmpointer != NULL) {					\
      if((topointer = malloc(strlen(frmpointer)+1)) == NULL) {	\
	PyErr_SetString(PyExc_MemoryError,"Not enough memory");	\
	return NULL;						\
      } else {							\
	strcpy(topointer,frmpointer);				\
      }								\
    } else {							\
      topointer = NULL;						\
    }};


/* Use PyUnicode_FromEncodedObject in case we got passed a string, say,
   instead of a unicode object */

/* Should I DECREF on value before I remove it ? (via value = PyUni(value) */

#define SET_STRING_ATTR(request,attrib_name,object_attribute,value, max_len) { \
    {									\
      PyObject *value_str, *value_uni = NULL;				\
      char     *value_c_str = NULL;					\
      									\
      if (strcasecmp(request,attrib_name) == 0) {			\
	if (PyUnicode_Check(value)) {					\
	  value_uni = value;						\
	  Py_INCREF(value_uni);						\
	} else {							\
	  Py_INCREF(value);						\
	  value_uni = PyUnicode_FromEncodedObject(value,NULL,NULL);	\
	  Py_DECREF(value);						\
	}								\
	if (value_uni == NULL) {					\
	  Py_DECREF(key);						\
	  return -1;							\
	}								\
	value_str = PyUnicode_AsEncodedString(value_uni, PALMOSCHARENCODING, NULL); \
	if (value_str == NULL) {					\
	  Py_DECREF(value_uni);						\
	  Py_DECREF(key);						\
	  return -1;							\
	}								\
	value_c_str = PyString_AsString(value_str);			\
	if (strlen(value_c_str) > max_len) {				\
	  PyErr_SetString(PyExc_ValueError,"Attribute cannot hold value this large"); \
	  Py_DECREF(value_uni);						\
	  Py_DECREF(value_str);						\
	  Py_DECREF(key);						\
	  return -1;							\
	}								\
	self->object_attribute = realloc(self->object_attribute, strlen(value_c_str)+1); \
	if(self->object_attribute != NULL) {				\
	  strcpy(self->object_attribute,value_c_str);			\
	  self->unsaved_changes = 1;					\
	} else {							\
	  PyErr_SetString(PyExc_MemoryError,"Unable to save attribute, out of memory (realloc failed)!"); \
	  Py_DECREF(value_str);						\
	  Py_DECREF(value_uni);						\
	  Py_DECREF(key);						\
	  return -1;							\
	};								\
	Py_DECREF(value_str);						\
	Py_DECREF(value_uni);						\
	Py_DECREF(key);							\
	return 0;							\
      }									\
    }									\
  }

#define SET_BOUNDED_INT_ATTR(request,attrib_name,entry,value,low,high,buffer,buffersize) { \
    if (strcasecmp(request,attrib_name) == 0) {				\
      if (!PyInt_Check(value) || (PyInt_AS_LONG(value) > high || PyInt_AS_LONG(value) < low)) { \
	snprintf(buffer,buffersize,"%s must be an int where %d<=x<=%d", attrib_name, low, high); \
	PyErr_SetString(PyExc_ValueError,buffer);			\
	Py_DECREF(key);							\
	return -1;							\
      };								\
      self->entry = PyInt_AsLong(value);				\
      self->unsaved_changes = 1;					\
      Py_DECREF(key);							\
      return 0;								\
    }									\
  }

#define SET_BOUNDED_INT_OR_NONE_ATTR(request,attrib_name,entry,value,low,high,buffer,buffersize) { \
    if (strcasecmp(request,attrib_name) == 0) {				\
      if (value == Py_None)  {						\
	self->entry = -1;						\
	self->unsaved_changes = 1;					\
	Py_DECREF(key);							\
	return 0;							\
      };								\
      if (!PyInt_Check(value) || (PyInt_AS_LONG(value) > high || PyInt_AS_LONG(value) < low)) { \
	snprintf(buffer,buffersize,"%s must be an int where %d<=x<=%d", attrib_name, low, high); \
	PyErr_SetString(PyExc_ValueError,buffer);			\
	Py_DECREF(key);							\
	return -1;							\
      };								\
      self->entry = PyInt_AsLong(value);				\
      self->unsaved_changes = 1;					\
      Py_DECREF(key);							\
      return 0;								\
    }									\
  }

#define SET_DATE_AND_INVERSE_FLAG_ATTR(request, attrib_name, entry, ifset, value) { \
    SETATTR_ON_OBJECT_BY_STRING_TO_DATE_(request, attrib_name, entry, ifset, 1, value) \
  }

#define SET_DATE_AND_FLAG_ATTR(request, attrib_name, entry, ifnone, value) { \
    SETATTR_ON_OBJECT_BY_STRING_TO_DATE_(request, attrib_name, entry, ifnone, 0, value) \
  }

#define SETATTR_ON_OBJECT_BY_STRING_TO_DATE_(request, attrib_name, entry, ifflag, invert, value) { \
    if (strcasecmp(request,attrib_name) == 0) {				\
      if (mxDateTime_Check(value)) {					\
	mxDateTime.DateTime_AsTmStruct((mxDateTimeObject *)value, &(self->entry));		\
	if (invert) {						        \
	  self->ifflag = (1);						\
	} else {							\
	  self->ifflag = (0);						\
	}								\
	self->unsaved_changes = 1;					\
	Py_DECREF(key);							\
	return 0;							\
      } else if (value == Py_None) {					\
	if (invert) {							\
	  self->ifflag = (0);						\
	} else {							\
	  self->ifflag = (1);						\
	}								\
	self->unsaved_changes = 1;					\
	Py_DECREF(key);							\
	return 0;							\
      } else {								\
	PyErr_SetString(PyExc_TypeError,"Date must be an mxDateTime or None"); \
	Py_DECREF(key);							\
	return -1;							\
      }									\
    }									\
  } 


#define SET_STANDARD_ATTRS(name,buffer,buffersize) { \
    SET_BOUNDED_INT_ATTR(name,"secret",secret,value,0,1,buffer,buffersize); \
    SET_BOUNDED_INT_ATTR(name,"category",category,value,0,15,buffer,buffersize); \
    SET_BOUNDED_INT_ATTR(name,"unsaved_changes",unsaved_changes,value,0,1,buffer,buffersize); \
  }

#define GET_STRING_ATTR(request,attrib,object_attribute) { \
    if (strcasecmp(request,attrib) == 0) {				\
      if (self->object_attribute) {					\
	Py_DECREF(key);							\
	return PyUnicode_Decode(self->object_attribute,			\
				strlen(self->object_attribute),		\
				PALMOSCHARENCODING,			\
				NULL);					\
      } else {								\
	Py_DECREF(key);							\
	return PyUnicode_Decode("",					\
				0,					\
				PALMOSCHARENCODING,			\
				NULL);					\
      }									\
    }									\
  }

#define GET_INT_ATTR(request,attrib,object_attribute) { \
    if (strcasecmp(request,attrib) == 0) {					\
      Py_DECREF(key);							\
      return PyInt_FromLong(self->object_attribute);			\
    };									\
  }

#define GET_INT_OR_NONE_ATTR(request,attrib,object_attribute) { \
    if (strcasecmp(request,attrib) == 0) {					\
      if (self->object_attribute < 0) {					\
	Py_INCREF(Py_None);						\
	Py_DECREF(key);							\
	return Py_None;							\
      } else {								\
	Py_DECREF(key);							\
	return PyInt_FromLong(self->object_attribute);			\
      };								\
    }									\
  }

#define GET_DATE_AND_INVERSE_FLAG_ATTR(request, attrib, object_attribute, ifunset) { \
    GETATTR_ON_OBJECT_BY_STRING_TO_DATE_(request,attrib,object_attribute,ifunset,0) \
      }

#define GET_DATE_AND_FLAG(request, attrib, object_attribute, ifunset) { \
    GETATTR_ON_OBJECT_BY_STRING_TO_DATE_(request,attrib,object_attribute,ifunset,1) \
      }

#define GETATTR_ON_OBJECT_BY_STRING_TO_DATE_(request,attrib,object_attribute,ifflag, invert) { \
    if (strcasecmp(request,attrib) == 0) {					\
      if (self->ifflag == invert) {					\
	Py_INCREF(Py_None);						\
	Py_DECREF(key);							\
	return Py_None;							\
      } else {								\
	Py_DECREF(key);							\
	return mxDateTime.DateTime_FromTmStruct(&(self->object_attribute)); \
      }									\
    }									\
  }

#define GET_STANDARD_ATTRS(name) {			  \
    GET_INT_ATTR(name,"unique_id",unique_id);		  \
    GET_INT_ATTR(name,"deleted",deleted);		  \
    GET_INT_ATTR(name,"modified",modified);		  \
    GET_INT_ATTR(name,"busy",busy);			  \
    GET_INT_ATTR(name,"secret",secret);			  \
    GET_INT_ATTR(name,"archived",archived);		  \
    GET_INT_ATTR(name,"category",category);		  \
    GET_INT_ATTR(name,"unsaved_changes",unsaved_changes); \
  }


#define PYPI_MEMBERS_HEAD {"unique_id", T_UINT, offsetof(PyPiBase, unique_id), READONLY, "Record Unique ID"}

#define PYPI_GETSETERS_HEAD   {"deleted", (getter)PyPi_Getbool, NULL,     \
                                  "Deleted flag",  (void *)offsetof(PyPiBase, deleted)},  \
                              {"modified", (getter)PyPi_Getbool, NULL,    \
				  "Modified flag", (void *)offsetof(PyPiBase, modified)}, \
                              {"busy", (getter)PyPi_Getbool, NULL,        \
                                  "Busy flag",  (void *)offsetof(PyPiBase, busy)},        \
                              {"secret", (getter)PyPi_Getbool, (setter)PyPi_Setbool,      \
                                  "Secret flag",  (void *)offsetof(PyPiBase, secret)},    \
                              {"archived", (getter)PyPi_Getbool, NULL,    \
                                  "Archived flag",  (void *)offsetof(PyPiBase, archived)},\
                              {"unsaved_changes", (getter)PyPi_Getbool, NULL,             \
                                  "Unsaved_Changes flag",  (void *)offsetof(PyPiBase, unsaved_changes)}, \
                              {"category", (getter)PyPi_GetCategory, (setter)PyPi_SetCategory,           \
                                  "Category number",  (void *)offsetof(PyPiBase, category)}

#endif
