import re
import types
import datetime
import pytz

class databaseAccessor:
    showModified   = 0
    showDeleted    = 0
    showPrivates   = 0
    showCategories = []
    showSorted     = 1
    searchString   = ""
    
    def __init__(self):
        self._metadata = self._appInfoFunction(self._database)

        if not hasattr(self,'_database') or self._database is None:
            raise RuntimeError("please call setProvider() before using jppy")

    def __iter__(self):
        return iter(self.records())

    def __getitem__(self, key):
        return self.records()[key]

    def _recordPromotion(self, records):
        return records

    def records(self,
                search=None,
                sort=None,
                modified=None,
                deleted=None,
                privates=None,
                categories=None):
        if search == None: search  = re.compile(self.searchString)
        if sort   == None: sort    = self.showSorted
        if modified==None: modified= self.showModified
        if deleted== None: deleted = self.showDeleted
        if categories==None: categories = self.showCategories[:]
        if privates==None: privates= self.showPrivates
        if not hasattr(search,'search'):
            search = re.compile(str(search),re.I)
        return self._recordPromotion(
            self._readDatabaseFunction(search,0,sort,modified,
                                       deleted,privates,categories,
                                       self._database,self._metadata['_storageversion']))
            
    def fetch(self,uid):
        return self._recordPromotion(
            self._readDatabaseFunction(None,uid,1,0,0,1,[],
                                       self._database,self._metadata['_storageversion']))

    def getCategories(self):
        return self._metadata['categories']

    def save(self, record):
        return self._writeDatabaseFunction(record, self._database,self._metadata['_storageversion'])

    def delete(self, record):
        return self._deleteFromDatabaseFunction(record, self._database)

# do not declare __init__ methods here:
# derived classes will not call them, as these are just mixin classes
class addressBook(databaseAccessor):
    def getLabels(self):
        return self._metadata['customlabels']

    def getContactLabels(self):
        return self._metadata['contactlabels']

    def getPhoneLabels(self):
        return self._metadata['phonelabels']

    def getIMLabels(self):
        return self._metadata['imlabels']

    def getAddressTypeLabels(self):
        return self._metadata['addresstypelabels']

    def getAddressLabels(self):
        return self._metadata['addresslabels']

class memoList(databaseAccessor):
    pass

class memo32List(databaseAccessor):
    pass

class taskList(databaseAccessor):
    pass

class calendar(databaseAccessor):
    def eventsFromDate(self, date, **kwargs):
        events = list()
        bandSize = datetime.timedelta(**kwargs)
        startBound_tz = date.replace(hour=0,
                                     minute=0,
                                     second=0,
                                     microsecond=0,
                                     tzinfo=pytz.utc)
        startBound_tz = startBound_tz - datetime.timedelta(seconds=1)
        endBound_tz = (date + bandSize).replace(hour=0,
                                                minute=0,
                                                second=0,
                                                microsecond=0,
                                                tzinfo=pytz.utc)
        startBound = startBound_tz.replace(tzinfo=None)
        endBound   = endBound_tz.replace(tzinfo=None)
        #print "Finding between %s and %s" % (startBound, endBound)
        for e in self:
            if e['dates'][0].tzinfo is None:
                for hit in e['dates'].between(startBound, endBound, inc=False):
                    hit = hit.replace(tzinfo=pytz.utc)
                    events.append((hit,e))
            else:
                for hit in e['dates'].between(startBound_tz, endBound_tz, inc=False):
                    hit = hit.replace(tzinfo=pytz.utc)
                    events.append((hit,e))
        events.sort()
        return events

    def eventsToday(self):
        return self.eventsOnDay(datetime.datetime.now())

    def eventsThisWeek(self):
        startOfWeek = datetime.datetime.now()-datetime.timedelta(
            days=datetime.datetime.now().weekday())
        return self.eventsFromDate(startOfWeek, days=7)

    def eventsOnDay(self, day):
        return self.eventsFromDate(day,days=1)

def installFile(filename):
    pass
