import base
import pygtk
pygtk.require("2.0")
import gtk
import gnome.ui
import random
import os.path
import mx.DateTime


import jppy
from jppy.printers import todos_printer
from jppy.printers import contact_printer, contact_label
from jppy.latex import letter

from gtk_models import TasksModel




class pane(base.pane):
    def __init__(self, env, glade_path):
        
        gladefile = os.path.join(glade_path, "tasks.glade")
        wTree     = gtk.glade.XML(gladefile,"vpanedTasks")
        wTreeMenu = gtk.glade.XML(gladefile,"tasksMoveMenu")

        self.name = "Tasks"
        self.model = TasksModel(env)
        self.view = wTree.get_widget("TasksTreeView")
        #print self.view
        self.main_vpaned = wTree.get_widget("vpanedTasks")        
        self.recordCategoryComboBox = wTree.get_widget("CategoryComboBox")
        self.categoryFilterVBox = wTree.get_widget("TasksCategoryVBox")

        wTree.get_widget("TasksFilterWanted").set_active(0)
        wTree.get_widget("TasksFilterEntry").set_data('searchType', 'full')
        
        # date widgets that need a checkbox to say if they are valid or not
        cb= wTree.get_widget("TasksDatedCheckButton")
        w = wTree.get_widget("TasksDateDue")
        self.joinValidCheckboxToWidget(cb, w, self.on_dateedit_change)

        
        # unsupported fields
        wTree.get_widget("TasksPrivateCheckButton").set_sensitive(False)
        #self.wTree.get_widget("TasksDateDue").set_sensitive(False)
        #self.wTree.get_widget("TasksDatedCheckButton").set_sensitive(False)
        #self.wTree.get_widget("TasksAlarm").set_sensitive(False)
        #self.wTree.get_widget("TasksAdvance").set_sensitive(False)        

        base.pane.__init__(self, env, gladefile, wTree)

        wTree.get_widget("tasksMoveToWaitingButton").set_menu(
            wTreeMenu.get_widget("tasksMoveMenu"))

        self.deleteButton = wTree.get_widget("tasksDeleteButton")

        # prepare for bringing up UI
        dic = {
            "on_TasksTreeView_button_press_event": (self.on_TreeView_button_press_event,
                                                       self.rightClickColumnMenu),
            "on_TasksFilterButton_clicked": (self.on_FilterButton, "TasksFilterEntry"),
            "on_TasksFilterWanted_changed": (self.on_FilterTypeCombo, "TasksFilterEntry"),
            "on_TasksFilterEntry_keyrelease": (self.on_FilterEntry_keyrelease, self.model),
            
            "on_tasksRevertButton_clicked": (self.on_RevertButton, self.model),
            "on_tasksNewButton_clicked": (self.on_NewButton, self.model,
                                             self.view, "TasksDescription"),
            "on_tasksDeleteButton_clicked": (self.on_DeleteButton),
            "on_tasksFilterDone_toggled": (self.on_FilterDoneToggled),
            "on_tasksWeeklyReviewButton_clicked": (self.on_tasksWeeklyReviewButton),

            "on_tasksMoveToWaitingButton_clicked": (self.on_tasksMoveToXButton,
                                                    "@Waiting",True),
            "on_tasksQuickAddButton_clicked": (self.on_tasksQuickAddButton),
            "on_tasksRandomNAButton_clicked": (self.on_tasksRandomNAButton)
            }
        
        wTree.signal_autoconnect(dic)

        dic = {
            "on_tasksMoveToProjectListButton_clicked": (self.on_tasksMoveToXButton,
                                                        "Project List",True),
            "on_tasksMoveToSomedayMaybe_clicked": (self.on_tasksMoveToXButton,
                                                   "Maybe/Someday",True),
            }
        wTreeMenu.signal_autoconnect(dic)

    def on_FilterDoneToggled(self, widget):
        self.model.setFilter('hide_completed', widget.get_active())
        self.model.rescan_database()
        self.clearDetailsView()

    def findCategory(self, categoryname):
        try:
            return self.model.available_categories().index(categoryname)
        except ValueError:
            dialog = gtk.MessageDialog(self.wTree.get_widget("mainwindow"),
                                       gtk.DIALOG_DESTROY_WITH_PARENT,
                                       gtk.MESSAGE_ERROR,
                                       gtk.BUTTONS_CLOSE,
                                       "You don't have a category called\n%s" % repr(categoryname))
            dialog.run()
            dialog.destroy()            
            return None        

    def on_tasksWeeklyReviewButton(self, widget):

        projectlistcat = self.findCategory("Project List")
        msomedaycat = self.findCategory("Maybe/Someday")        

        dialog = gtk.glade.XML(self.gladefile,"weeklyReviewDialog")
        w = dialog.get_widget("weeklyReviewDialog")
        w.connect("response", self.on_tasksWeeklyReviewResponse, projectlistcat, msomedaycat)

    def on_tasksWeeklyReviewResponse(self, dialog, response, projectlistcat, msomedaycat):
        dialog.destroy()
        
        if response == gtk.RESPONSE_CANCEL:
            return

        cats = range(0,16)
        cats.remove(projectlistcat)
        cats.remove(msomedaycat)

        printer = todos_printer(self.env)

        NAs_filename = printer.render(self.env.taskList,
                                      self.env.taskList.records(categories=cats) + \
                                      self.env.taskList.records(categories=[msomedaycat]))
        Projects_filename = printer.render(self.env.taskList,
                                           self.env.taskList.records(categories=[projectlistcat]))

        if response == 2:
            command = self.env.config.get("core","pdfviewer")
        elif response == 1:
            command = self.env.config.get("core","printercommand")
        else:
            command = None

        if command:
            os.system("%s %s" % (command, NAs_filename))
            os.system("%s %s" % (command, Projects_filename))

        os.unlink(NAs_filename)
        os.unlink(Projects_filename)

    def on_tasksRandomNAButton(self, widget):
        picked = random.randrange(0,self.model.record_count())
        path = (picked,)
        iter = self.model.get_iter(path)
        self.view.scroll_to_cell(path)
        selection = self.view.get_selection()
        selection.select_iter(iter)
        self.updateDetailsView(iter)

    def moveCurrentTaskToCategory(self, catname):
        cat = self.findCategory(catname)
        category_attr = self.model.findAttributeNumberByName("category")
        old = self.model.get_value(self.iter, category_attr)        
        self.model.set_value(self.iter, category_attr, cat)
        self.updateDetailsView(self.iter)
        return self.model.available_categories()[old]
            
    def on_tasksMoveToXButton(self, widget, categoryname, log=False):
        old = self.moveCurrentTaskToCategory(categoryname)
        if log:
            base_template1 = "\n\n%s %s -> %s\nReason: " % (mx.DateTime.now().strftime("%c"),
                                                           old, categoryname)

            textview = self.wTree.get_widget("TasksNote")
            buffer = textview.get_buffer()
            
            buffer.insert(buffer.get_end_iter(),base_template1)
            mark = buffer.create_mark(None,buffer.get_end_iter(),left_gravity=True)
            buffer.place_cursor(buffer.get_iter_at_mark(mark))
            buffer.delete_mark(mark)
            
            textview.scroll_mark_onscreen(buffer.get_insert())
            textview.grab_focus()

    def on_tasksQuickAddButton(self, widget):
        dialog = gtk.glade.XML(self.gladefile,"taskQuickAdd")

        w = dialog.get_widget("categoryVBox")

        buffer = dialog.get_widget("textView").get_buffer()        
        
        radios = []
        w.hide()
        radio = None
        for category,n in self.model.available_categories_indexed():
            radio = gtk.RadioButton(group=radio, label=category)
            radio.set_data("category_number", n)
            radios.append(radio)
            w.pack_start(radio)
            radio.show()
        w.show()

        dw = dialog.get_widget("taskQuickAdd")
        dw.connect("response", self.on_tasksQuickAddResponse, radios, buffer)

        
    def on_tasksQuickAddResponse(self, dialog, response, radios, buffer):
        self.env.log.debug("%s %s %s %s" % (dialog, response, radios, buffer))

        if response == gtk.RESPONSE_CANCEL:
            dialog.destroy()
            return

        begin  = buffer.get_start_iter()
        end    = buffer.get_end_iter()
        text   = buffer.get_text(begin,end,True)        

        iter = self.model.append()
        self.view.scroll_to_cell(self.model.get_path(iter))
        selection = self.view.get_selection()
        selection.select_iter(iter)

        attr = self.model.findAttributeNumberByName("description")
        self.model.set_value(iter, attr, text)

        for radio in radios:
            if radio.get_active():
                category = radio.get_data("category_number")
                break

        attr = self.model.findAttributeNumberByName("category")
        self.model.set_value(iter, attr, category)
        
        self.updateDetailsView(iter)

        dialog.destroy()
