/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.DefaultNativeGroup;
import org.jruby.ext.posix.DefaultNativeTimeval;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.Timeval;

public abstract class BaseNativePOSIX
implements POSIX {
    protected String libraryName;
    protected LibC libc;
    protected POSIXHandler handler;
    protected JavaLibCHelper helper;
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new DefaultNativeGroup((Pointer)arg) : null;
        }
    };

    public BaseNativePOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        this.libc = libc;
        this.handler = handler;
        this.libraryName = libraryName;
        this.helper = new JavaLibCHelper(handler);
    }

    public int chmod(String filename, int mode) {
        return this.libc.chmod(filename, mode);
    }

    public int chown(String filename, int user, int group) {
        return this.libc.chown(filename, user, group);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (this.libc.fstat(fd, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat;
    }

    public int getegid() {
        return this.libc.getegid();
    }

    public int geteuid() {
        return this.libc.geteuid();
    }

    public int getgid() {
        return this.libc.getgid();
    }

    public String getlogin() {
        return this.libc.getlogin();
    }

    public int getpgid() {
        return this.libc.getpgid();
    }

    public int getpgrp() {
        return this.libc.getpgrp();
    }

    public int getpid() {
        return this.libc.getpid();
    }

    public int getppid() {
        return this.libc.getppid();
    }

    public Passwd getpwent() {
        return this.libc.getpwent();
    }

    public Passwd getpwuid(int which) {
        return this.libc.getpwuid(which);
    }

    public Passwd getpwnam(String which) {
        return this.libc.getpwnam(which);
    }

    public Group getgrent() {
        return this.libc.getgrent();
    }

    public Group getgrgid(int which) {
        return this.libc.getgrgid(which);
    }

    public Group getgrnam(String which) {
        return this.libc.getgrnam(which);
    }

    public int setpwent() {
        return this.libc.setpwent();
    }

    public int endpwent() {
        return this.libc.endpwent();
    }

    public int setgrent() {
        return this.libc.setgrent();
    }

    public int endgrent() {
        return this.libc.endgrent();
    }

    public int getuid() {
        return this.libc.getuid();
    }

    public int setegid(int egid) {
        return this.libc.setegid(egid);
    }

    public int seteuid(int euid) {
        return this.libc.seteuid(euid);
    }

    public int setgid(int gid) {
        return this.libc.setgid(gid);
    }

    public int getfd(FileDescriptor descriptor) {
        return this.helper.getfd(descriptor);
    }

    public int getpgid(int pid) {
        return this.libc.getpgid(pid);
    }

    public int setpgid(int pid, int pgid) {
        return this.libc.setpgid(pid, pgid);
    }

    public int setpgrp(int pid, int pgrp) {
        return this.libc.setpgrp(pid, pgrp);
    }

    public int setsid() {
        return this.libc.setsid();
    }

    public int setuid(int uid) {
        return this.libc.setuid(uid);
    }

    public int kill(int pid, int signal) {
        return this.libc.kill(pid, signal);
    }

    public int lchmod(String filename, int mode) {
        return this.libc.lchmod(filename, mode);
    }

    public int lchown(String filename, int user, int group) {
        return this.libc.lchown(filename, user, group);
    }

    public int link(String oldpath, String newpath) {
        return this.libc.link(oldpath, newpath);
    }

    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.lstat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public int mkdir(String path, int mode) {
        return this.libc.mkdir(path, mode);
    }

    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.stat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public int symlink(String oldpath, String newpath) {
        return this.libc.symlink(oldpath, newpath);
    }

    public String readlink(String oldpath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        int result = this.libc.readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public int umask(int mask) {
        return this.libc.umask(mask);
    }

    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        Timeval[] times = null;
        if (atimeval != null && mtimeval != null) {
            times = (Timeval[])new DefaultNativeTimeval().toArray(2);
            times[0].setTime(atimeval);
            times[1].setTime(mtimeval);
        }
        return this.libc.utimes(path, times);
    }

    public int fork() {
        return this.libc.fork();
    }

    public int waitpid(int pid, int[] status, int flags) {
        return this.libc.waitpid(pid, status, pid);
    }

    public int wait(int[] status) {
        return this.libc.wait(status);
    }

    public int getpriority(int which, int who) {
        return this.libc.getpriority(which, who);
    }

    public int setpriority(int which, int who, int prio) {
        return this.libc.setpriority(which, who, prio);
    }

    public boolean isatty(FileDescriptor fd) {
        return this.libc.isatty(this.helper.getfd(fd)) != 0;
    }

    public abstract FileStat allocateStat();

    protected boolean hasMethod(String name) {
        try {
            NativeLibrary.getInstance((String)this.libraryName).getFunction(name);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        return true;
    }

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

