#!/usr/bin/env python
#
#

target = "jsb" # BHJTW change this to /var/cache/jsb on debian

import os

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

print "TARGET IS %s" % target

upload = []

def uploadfiles(dir):
    upl = []
    if not os.path.isdir(dir): print "%s does not exist" % dir ; os._exit(1)
    for file in os.listdir(dir):
        if not file or file.startswith('.'):
            continue
        d = dir + os.sep + file
        if not os.path.isdir(d):
            if file.endswith(".pyc"):
                continue
            upl.append(d)

    return upl

def uploadlist(dir):
    upl = []

    for file in os.listdir(dir):
        if not file or file.startswith('.'):
            continue
        d = dir + os.sep + file
        if os.path.isdir(d):   
            upl.extend(uploadlist(d))
        else:
            if file.endswith(".pyc"):
                continue
            upl.append(d)

    return upl

setup(
    name='jsb',
    version='0.7.1.2',
    url='http://jsonbot.googlecode.com/',
    download_url="http://code.google.com/p/jsonbot/downloads", 
    author='Bart Thate',
    author_email='bthate@gmail.com',
    description='The bot for you!',
    license='MIT',
    scripts=['bin/jsb',
             'bin/jsb-convore',
             'bin/jsb-init',
             'bin/jsb-irc', 
             'bin/jsb-fleet', 
             #'bin/jsb-gozerimport',
             'bin/jsb-xmpp', 
             'bin/jsb-release',
             'bin/jsb-rollback',
             'bin/jsb-run',
             'bin/jsb-sed',
             'bin/jsb-stop',
             'bin/jsb-udp',
             'bin/jsb-upgrade',
             'bin/jsb-upload',
             'bin/jsb-uploadall'],
    packages=['jsb',
              'jsb.lib', 
              'jsb.lib.rest',
              'jsb.lib.gae',
              'jsb.drivers',
              'jsb.drivers.console',
              'jsb.drivers.irc',
              'jsb.drivers.xmpp',
              'jsb.drivers.convore',
              'jsb.drivers.gae',
              'jsb.drivers.gae.web',
              'jsb.drivers.gae.wave',
              'jsb.drivers.gae.xmpp',
              'jsb.utils',
              'jsb.utils.gae', 
              'jsb.plugs',
              'jsb.plugs.core',
              'jsb.plugs.wave',
              'jsb.plugs.common',
              'jsb.plugs.socket', 
              'jsb.plugs.gae',
              'jsb.plugs.myplugs',
              'jsb.plugs.myplugs.socket',
              'jsb.plugs.myplugs.gae',
              'jsb.plugs.myplugs.common',
              'jsb.contrib',
              'jsb.contrib.dns',
              'jsb.contrib.simplejson',
              'jsb.contrib.tweepy',
              'jsb.contrib.requests',
              'jsb.contrib.requests.packages',
              'jsb.contrib.requests.packages.poster'],
    long_description = """ JSONBOT is a remote event-driven framework for building bots that talk JSON to each other over XMPP. IRC/Console/XMPP (shell) Wave/Web/XMPP (GAE) implementations provided. """,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Environment :: Other Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Operating System :: Other OS',
        'Programming Language :: Python',
        'Topic :: Communications :: Chat',
        'Topic :: Software Development :: Libraries :: Python Modules'],
    data_files=[(target + os.sep + 'data', uploadlist('jsb' + os.sep + 'data')),
                (target + os.sep + 'data' + os.sep + 'examples', uploadfiles('jsb' + os.sep + 'data' + os.sep + 'examples')),
                (target + os.sep + 'upload', uploadfiles('jsb' + os.sep + 'upload')),
                (target + os.sep + 'upload' + os.sep + 'webapp2', uploadlist('jsb' + os.sep + 'upload' + os.sep + 'webapp2')),
                (target + os.sep + 'upload' + os.sep + 'assets', uploadlist('jsb' + os.sep + 'upload' + os.sep + 'assets')),
                (target + os.sep + 'upload' + os.sep + 'templates', uploadlist('jsb' + os.sep + 'upload' + os.sep +'templates')),
                (target + os.sep + 'upload' + os.sep + 'waveapi', uploadlist('jsb' + os.sep + 'upload' + os.sep + 'waveapi')),
                (target + os.sep + 'upload' + os.sep + 'waveapi' + os.sep + 'oauth', uploadlist('jsb' + os.sep + 'upload' + os.sep + 'waveapi' + os.sep + 'oauth')),
                (target + os.sep + 'upload' + os.sep + 'waveapi' + os.sep + 'simplejson', uploadlist('jsb' + os.sep + 'upload' + os.sep + 'waveapi' + os.sep + 'simplejson')),
                (target + os.sep + 'upload' + os.sep + 'gadgets', uploadlist('jsb' + os.sep + 'upload' + os.sep + 'gadgets'))],
)
