/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.wikiwizard.FlashSplash;
import org.wikiwizard.WikiWizardApplet;

public class AttachmentsLoaderThread
extends Thread {
    private WikiWizardApplet m_wiki;
    private String m_attachments;
    private JPanel m_attsPanel;
    private String m_loading;
    private String m_resource_ico;

    public AttachmentsLoaderThread(WikiWizardApplet wiki, String attachments, JPanel attsPanel, String loading, String resource_ico) {
        this.m_attachments = attachments;
        this.m_wiki = wiki;
        this.m_attsPanel = attsPanel;
        this.m_loading = loading;
        this.m_resource_ico = resource_ico;
    }

    public void run() {
        try {
            StringTokenizer str = new StringTokenizer(this.m_attachments, ";");
            int numFiles = str.countTokens();
            int fileCount = 0;
            Toolkit tk = Toolkit.getDefaultToolkit();
            JLabel loadProgress = new JLabel(this.m_loading + " " + ++fileCount + "/" + numFiles, new ImageIcon(tk.getImage(FlashSplash.class.getResource(this.m_resource_ico + "/wait30trans.gif"))), 2);
            this.m_attsPanel.add((Component)loadProgress, "South");
            while (str.hasMoreElements()) {
                try {
                    String item = (String)str.nextElement();
                    String param = this.m_wiki.getParameter("page") + "/" + item;
                    param = URLEncoder.encode(param, "UTF-8");
                    param = param.replaceAll("\\+", "%20");
                    if (this.m_wiki.isImageFile(item)) {
                        URL url = new URL(this.m_wiki.getParameter("attachURL") + "/" + param);
                        try {
                            Image thumbnail = this.m_wiki.createThumbnail(ImageIO.read(url));
                            this.m_wiki.images.put(item, thumbnail);
                            loadProgress.setText(this.m_loading + ++fileCount + "/" + numFiles);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_wiki.setAttachmentsList();
            }
            this.m_attsPanel.repaint();
            this.m_attsPanel.remove(loadProgress);
            this.m_attsPanel.revalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

