/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.wikiwizard.CopyAndPastePopup;
import org.wikiwizard.ImageLoader;
import org.wikiwizard.PicturePreview;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.observeModul;

public class PictureDialog
extends JDialog
implements KeyListener,
ItemListener,
ActionListener,
FocusListener,
MouseListener {
    private observeModul obsable;
    public JTextField title;
    public JTextField httpLink;
    public JComboBox name;
    private JComboBox adx;
    private JButton insertButton;
    private JButton cancelButton;
    private JPanel tabbedPane;
    private JPanel advancedTabPane;
    public HashMap images;
    private JApplet owner;
    private JTabbedPane tablist;
    public PicturePreview picturePreview = new PicturePreview();
    WikiWizardApplet wiki;
    ImageLoader t;
    public JComboBox imageWidth = new JComboBox();
    private ResourceBundle bundle = null;
    private boolean replace;
    private boolean table;
    public String width;
    Font menuFontSize = new Font("Dialog", 0, 12);
    private CopyAndPastePopup popupMenu = new CopyAndPastePopup();

    public PictureDialog(JDialog d, boolean table, Object obs, String caption, String pictureName, String appendix, String width, String httpLinkText) {
        super((Dialog)d, true);
        this.init(table, obs, caption, pictureName, appendix, width, httpLinkText);
    }

    public PictureDialog(JApplet d, boolean table, Object obs, String caption, String pictureName, String appendix, String width, String httpLinkText) {
        super(JOptionPane.getFrameForComponent(d), true);
        this.init(table, obs, caption, pictureName, appendix, width, httpLinkText);
    }

    public void init(boolean table, Object obs, String caption, String pictureName, String appendix, String width, String httpLinkText) {
        this.table = table;
        this.width = width;
        if (pictureName != "") {
            this.replace = true;
        }
        this.bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);
        this.wiki = (WikiWizardApplet)obs;
        this.t = new ImageLoader(this, this.wiki.attach);
        this.t.start();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        this.tablist = new JTabbedPane();
        pane.add((Component)this.tablist, c);
        this.tabbedPane = new JPanel();
        this.advancedTabPane = new JPanel();
        this.tablist.add(this.bundle.getString("standardTabTitle"), this.tabbedPane);
        this.tablist.add(this.bundle.getString("advancedTabTitle"), this.advancedTabPane);
        this.owner = (JApplet)obs;
        this.setModal(true);
        this.setLocationRelativeTo(this.owner);
        this.setTitle(this.bundle.getString("pictureDialogTitle"));
        this.obsable = new observeModul();
        this.obsable.addObserver((Observer)obs);
        JPanel left = new JPanel();
        JPanel left2 = new JPanel();
        JPanel right = new JPanel();
        left.setLayout(new GridBagLayout());
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(2, 1, 2, 2);
        JLabel label = new JLabel("  " + this.bundle.getString("pictureName") + " ");
        label.setFont(this.menuFontSize);
        left.add((Component)label, c);
        StringTokenizer str = new StringTokenizer(this.wiki.attach, ";");
        this.name = new JComboBox();
        this.name.getEditor().getEditorComponent().addKeyListener(this);
        this.name.getEditor().getEditorComponent().addMouseListener(this);
        this.name.setEditable(true);
        this.name.addItem(pictureName);
        while (str.hasMoreElements()) {
            String item = (String)str.nextElement();
            if (pictureName.equals(item) || !PictureDialog.isImageFile(item)) continue;
            this.name.addItem(item);
        }
        this.name.addItemListener(this);
        this.name.addFocusListener(this);
        this.name.setFont(this.menuFontSize);
        left.add((Component)this.name, c);
        c.gridy = 1;
        label = new JLabel("  " + this.bundle.getString("pictureInfo") + " ");
        label.setFont(this.menuFontSize);
        left.add((Component)label, c);
        this.title = new JTextField(caption, 20);
        this.title.addKeyListener(this);
        this.title.setFont(this.menuFontSize);
        this.title.addFocusListener(this);
        this.title.addMouseListener(this);
        left.add((Component)this.title, c);
        this.adx = new JComboBox();
        this.adx.getEditor().getEditorComponent().addKeyListener(this);
        this.adx.getEditor().getEditorComponent().addMouseListener(this);
        this.adx.setFont(this.menuFontSize);
        this.adx.setEditable(true);
        if (!appendix.equals("")) {
            this.adx.addItem("");
            try {
                this.adx.addItem(this.wiki.getParameter("page"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(2, 1, 2, 2);
        left2.setLayout(new GridBagLayout());
        c.gridy = 1;
        label = new JLabel(" " + this.bundle.getString("pictureAppendix") + " ");
        label.setFont(this.menuFontSize);
        left2.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 1;
        left2.add((Component)this.adx, c);
        this.adx.addFocusListener(this);
        c.gridx = 0;
        c.gridy = 2;
        label = new JLabel(" " + this.bundle.getString("pictureImageWidth") + " ");
        int w = 0;
        if (!width.equals("")) {
            try {
                w = Integer.valueOf(width);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        left2.add((Component)label, c);
        label.setFont(this.menuFontSize);
        c.gridx = 1;
        c.gridy = 2;
        if (this.wiki.imageWidth.size() == 0) {
            this.imageWidth.addItem("");
        } else {
            this.createComboBox(width);
        }
        this.imageWidth.setEditable(true);
        this.imageWidth.setFont(this.menuFontSize);
        this.imageWidth.getEditor().getEditorComponent().addMouseListener(this);
        left2.add((Component)this.imageWidth, c);
        c.gridy = 4;
        c.gridx = 0;
        c.gridy = 3;
        JLabel httpLinkLabel = new JLabel(" " + this.bundle.getString("pictureHttpLink"));
        httpLinkLabel.setFont(this.menuFontSize);
        left2.add((Component)httpLinkLabel, c);
        c.gridx = 1;
        this.httpLink = new JTextField(httpLinkText, 20);
        this.httpLink.setFont(this.menuFontSize);
        this.httpLink.addMouseListener(this);
        left2.add((Component)this.httpLink, c);
        right.setLayout(new GridBagLayout());
        this.insertButton = new JButton(this.bundle.getString("pictureDialogInsertButton"));
        this.insertButton.setFont(this.menuFontSize);
        c.gridx = 0;
        c.gridy = 0;
        right.add((Component)this.insertButton, c);
        this.cancelButton = new JButton(this.bundle.getString("pictureDialogCancelButton"));
        this.cancelButton.setFont(this.menuFontSize);
        c.gridx = 0;
        c.gridy = 1;
        right.add((Component)this.cancelButton, c);
        this.picturePreview.setPreferredSize(new Dimension(100, 100));
        this.picturePreview.setLocation(100, 100);
        c.gridy = 2;
        right.add((Component)this.picturePreview, c);
        this.advancedTabPane.setLayout(new GridBagLayout());
        this.tabbedPane.setLayout(new GridBagLayout());
        c.insets = new Insets(1, 15, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.tabbedPane.add((Component)left, c);
        this.advancedTabPane.add((Component)left2, c);
        c.gridx = 1;
        pane.add((Component)right, c);
        this.insertButton.addActionListener(this);
        this.insertButton.addKeyListener(this);
        this.insertButton.getRootPane().setDefaultButton(this.insertButton);
        this.insertButton.setDefaultCapable(true);
        this.cancelButton.addActionListener(this);
        this.title.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        TravPolicyPictureDialog policyPictureDialog = new TravPolicyPictureDialog();
        this.setFocusTraversalPolicy(policyPictureDialog);
    }

    public static boolean isImageFile(String fileName) {
        fileName = fileName.toLowerCase();
        int dotIndex = fileName.lastIndexOf(".");
        int fileLength = fileName.length();
        if (dotIndex == -1 || dotIndex == fileLength) {
            return false;
        }
        String extension = fileName.substring(dotIndex + 1, fileName.length());
        return extension.equals("png") || extension.equals("gif") || extension.equals("jpg") || extension.equals("jpeg") || extension.equals("bmp");
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.t.stop();
            this.hide();
            this.wiki.getTextWindow().requestFocus();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        Object source = evt.getSource();
        if (arg.equals(this.bundle.getString("pictureDialogInsertButton"))) {
            if (this.name.getSelectedItem().toString().equals("") && !this.httpLink.getText().equals("")) {
                JOptionPane.showMessageDialog(null, this.bundle.getString("httpWithoutName"));
                this.tablist.setSelectedIndex(0);
                this.name.requestFocusInWindow();
            } else {
                if (!this.table) {
                    this.obsable.input("Insert pictureDialog");
                } else {
                    this.obsable.input("Insert pictureDialog in table");
                }
                this.hide();
            }
        }
        if (arg.equals(this.bundle.getString("pictureDialogCancelButton"))) {
            if (!this.table) {
                this.obsable.input("Beende pictureDialog");
            } else {
                this.obsable.input("Beende pictureDialog in table");
            }
            this.hide();
        }
    }

    public boolean getReplace() {
        return this.replace;
    }

    public void createComboBox(Object input) {
        this.imageWidth.removeAllItems();
        this.imageWidth.addItem(input);
        Enumeration e = this.wiki.imageWidth.elements();
        while (e.hasMoreElements()) {
            this.imageWidth.addItem(e.nextElement());
        }
    }

    public String getCaption() {
        try {
            return this.title.getText();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getAppendix() {
        return (String)this.adx.getSelectedItem();
    }

    public int getImageWidth() {
        try {
            return Integer.valueOf(this.imageWidth.getSelectedItem() + "");
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getPictureName() {
        try {
            return (String)this.name.getSelectedItem();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void show() {
        super.show();
        this.setLocationRelativeTo(this.owner);
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void itemStateChanged(ItemEvent arg0) {
        try {
            if (this.images.get(URLEncoder.encode("" + this.name.getSelectedItem(), "UTF-8")) != null) {
                if (((Image)this.images.get(URLEncoder.encode("" + this.name.getSelectedItem(), "UTF-8"))).getWidth(null) > this.wiki.imagewidthmax) {
                    this.createComboBox("" + this.wiki.imagewidthmax);
                } else {
                    this.createComboBox("");
                }
                this.picturePreview.showImage((Image)this.images.get(URLEncoder.encode("" + this.name.getSelectedItem(), "UTF-8")));
            } else {
                this.picturePreview.refresh();
                this.createComboBox("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    class TravPolicyPictureDialog
    extends FocusTraversalPolicy {
        TravPolicyPictureDialog() {
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return PictureDialog.this.name;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return PictureDialog.this.name;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return PictureDialog.this.tablist;
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == PictureDialog.this.name.getEditor().getEditorComponent()) {
                return PictureDialog.this.title;
            }
            if (aComponent == PictureDialog.this.title) {
                return PictureDialog.this.insertButton;
            }
            if (aComponent == PictureDialog.this.httpLink) {
                return PictureDialog.this.insertButton;
            }
            if (aComponent == PictureDialog.this.insertButton) {
                return PictureDialog.this.cancelButton;
            }
            if (aComponent == PictureDialog.this.cancelButton) {
                return PictureDialog.this.tablist;
            }
            if (aComponent == PictureDialog.this.adx.getEditor().getEditorComponent()) {
                return PictureDialog.this.imageWidth;
            }
            if (aComponent == PictureDialog.this.imageWidth.getEditor().getEditorComponent()) {
                return PictureDialog.this.httpLink;
            }
            if (aComponent == PictureDialog.this.httpLink) {
                return PictureDialog.this.insertButton;
            }
            if (aComponent == PictureDialog.this.tablist) {
                if (PictureDialog.this.tablist.getSelectedComponent() == PictureDialog.this.tabbedPane) {
                    return PictureDialog.this.name;
                }
                if (PictureDialog.this.tablist.getSelectedComponent() == PictureDialog.this.advancedTabPane) {
                    return PictureDialog.this.adx;
                }
            }
            return PictureDialog.this.name;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == PictureDialog.this.tablist) {
                return PictureDialog.this.cancelButton;
            }
            if (aComponent == PictureDialog.this.cancelButton) {
                return PictureDialog.this.insertButton;
            }
            if (aComponent == PictureDialog.this.insertButton) {
                if (PictureDialog.this.tablist.getSelectedComponent() == PictureDialog.this.tabbedPane) {
                    return PictureDialog.this.title;
                }
                if (PictureDialog.this.tablist.getSelectedComponent() == PictureDialog.this.advancedTabPane) {
                    return PictureDialog.this.httpLink;
                }
            } else {
                if (aComponent == PictureDialog.this.httpLink) {
                    return PictureDialog.this.imageWidth;
                }
                if (aComponent == PictureDialog.this.imageWidth.getEditor().getEditorComponent()) {
                    return PictureDialog.this.adx;
                }
                if (aComponent == PictureDialog.this.adx.getEditor().getEditorComponent()) {
                    return PictureDialog.this.tablist;
                }
                if (aComponent == PictureDialog.this.title) {
                    return PictureDialog.this.name;
                }
                if (aComponent == PictureDialog.this.name.getEditor().getEditorComponent()) {
                    return PictureDialog.this.tablist;
                }
            }
            return PictureDialog.this.name;
        }
    }
}

