/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.wikiwizard.WikiWizardApplet;

class PicturePreview
extends JPanel {
    private Image theImage;
    private boolean blank = false;
    ResourceBundle bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);

    PicturePreview() {
    }

    public void showImage(Image theImage) {
        this.theImage = theImage;
        this.paintImmediately(0, 0, 100, 100);
    }

    public void refresh() {
        this.blank = true;
        this.paintImmediately(0, 0, 100, 100);
        this.blank = false;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 100, 100);
        if (this.theImage != null && !this.blank) {
            int height = this.theImage.getHeight(this);
            int width = this.theImage.getWidth(this);
            int x = 0;
            int y = 0;
            if (width > 100 || height > 100) {
                if (height > 100 && width > 100) {
                    if (Math.abs(width - 100) >= Math.abs(height - 100)) {
                        x = 100;
                        y = (int)(100.0 / (double)width * (double)height);
                    } else {
                        x = (int)(100.0 / (double)height * (double)width);
                        y = 100;
                    }
                } else if (height > 100) {
                    x = (int)(100.0 / (double)height * (double)width);
                    y = 100;
                } else {
                    x = 100;
                    y = (int)(100.0 / (double)width * (double)height);
                }
            } else {
                x = width;
                y = height;
            }
            int lx = (int)((double)(100 - x) / 2.0);
            int ly = (int)((double)(100 - y) / 2.0);
            g.drawImage(this.theImage, 0 + lx, 0 + ly, x, y, null);
        } else {
            g.setColor(Color.BLACK);
            g.setFont(new Font("Arial", 0, 9));
            g.drawString(this.bundle.getString("noPicture"), 30, 50);
        }
    }
}

