/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import org.wikiwizard.WikiWizardApplet;

public class SpellingInstaller
extends JDialog {
    private JProgressBar bar = null;
    private InputStream src = null;
    private File dst = null;
    private JDialog own;
    private JButton download;
    private ResourceBundle bundle = null;

    public SpellingInstaller(JApplet applet, InputStream srcIn, File dstIn) {
        super(JOptionPane.getFrameForComponent(applet), true);
        this.src = srcIn;
        this.dst = dstIn;
        this.own = this;
        this.setSize(300, 200);
        this.bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);
        this.setLocationRelativeTo(applet);
        try {
            this.bar = new JProgressBar(0, this.src.available());
            this.bar.setStringPainted(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.bar, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.download = new JButton(this.bundle.getString("spellingDownloadButton"));
        JButton cancel = new JButton(this.bundle.getString("spellingCancelButton"));
        JTextPane text = new JTextPane();
        text.setEditable(false);
        text.setText(this.bundle.getString("spellingText"));
        JPanel top = new JPanel();
        top.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        JLabel icon = new JLabel(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource("/org/wikiwizard/resources/stock_3d-light-on-16.png"))));
        JLabel info = new JLabel(this.bundle.getString("spellingLabel"));
        JPanel iconBar = new JPanel();
        iconBar.setLayout(new GridBagLayout());
        iconBar.add(icon);
        iconBar.add(info);
        c.insets = new Insets(10, 0, 0, 0);
        top.add((Component)iconBar, c);
        c.gridy = 1;
        c.insets = new Insets(10, 10, 10, 10);
        top.add((Component)text, c);
        JPanel buttons = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        buttons.setLayout(new GridBagLayout());
        c2.insets = new Insets(10, 10, 10, 10);
        buttons.add((Component)this.download, c2);
        buttons.add((Component)cancel, c2);
        c.gridy = 2;
        top.add((Component)this.bar, c);
        c.gridy = 3;
        c.insets = new Insets(0, 5, 5, 5);
        top.add((Component)buttons, c);
        this.getContentPane().add((Component)top, "North");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SpellingInstaller.this.own.dispose();
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    SpellingInstaller.this.copy(SpellingInstaller.this.src, SpellingInstaller.this.dst);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SpellingInstaller.this.download.removeActionListener(this);
                SpellingInstaller.this.download.setText(SpellingInstaller.this.bundle.getString("spellingGoOn"));
                SpellingInstaller.this.download.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        SpellingInstaller.this.own.dispose();
                    }
                });
            }
        });
    }

    void copy(InputStream src, File dst) throws IOException {
        int len;
        InputStream in = src;
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
            this.bar.setValue(this.bar.getValue() + 1024);
        }
        in.close();
        ((OutputStream)out).close();
    }
}

