/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.wikiwizard.SingleLineHighlighterPainter;
import org.wikiwizard.WikiWizardApplet;

class WikiWizardTextPane
extends JTextPane {
    private boolean mode = true;
    private ArrayList blocks;
    private WikiWizardApplet applet;
    private boolean drawing = false;
    public JTextField txt;
    private DefaultHighlighter high;
    private DefaultHighlighter collector = new DefaultHighlighter();
    private int time;
    private boolean first = true;

    public WikiWizardTextPane(WikiWizardApplet w, DefaultHighlighter high) {
        this.high = high;
        high.setDrawsLayeredHighlights(false);
        this.setHighlighter(high);
        this.applet = w;
        this.blocks = new ArrayList();
        this.setBackground(Color.WHITE);
        this.setDragEnabled(true);
    }

    public void refreshBlocks() {
        this.high.removeAllHighlights();
    }

    public void refreshBlocks(int hstart, int hend, int difference, int caret) {
        Highlighter.Highlight[] h = this.high.getHighlights();
        DefaultHighlighter copy = new DefaultHighlighter();
        this.setHighlighter(copy);
        copy.setDrawsLayeredHighlights(false);
        for (int i = 0; i < h.length; ++i) {
            if (!(h[i].getPainter() instanceof SingleLineHighlighterPainter) || ((SingleLineHighlighterPainter)h[i].getPainter()).zeile >= hstart - 3 && ((SingleLineHighlighterPainter)h[i].getPainter()).zeile <= hstart + hend + 3 || ((SingleLineHighlighterPainter)h[i].getPainter()).zeile1 >= hstart - 3 && ((SingleLineHighlighterPainter)h[i].getPainter()).zeile1 <= hstart + hend + 3) continue;
            SingleLineHighlighterPainter painter = (SingleLineHighlighterPainter)h[i].getPainter();
            if (painter.zeile >= caret) {
                painter.zeile += difference;
                painter.zeile1 += difference;
            }
            try {
                copy.addHighlight(h[i].getStartOffset(), h[i].getEndOffset(), new SingleLineHighlighterPainter(this, painter.zeile, painter.zeile1, painter.col));
                continue;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.high = copy;
        this.repaint();
    }

    public void createRect(int zeile, int zeile2, Color col) {
        try {
            this.high.addHighlight(0, 0, new SingleLineHighlighterPainter(this, zeile, zeile2, col));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void setSize(Dimension d) {
        if (d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.mode;
    }

    public void setWrapMode(boolean mode) {
        this.mode = mode;
    }
}

