/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.outlookClasses;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.AbstractBorder;

public class ButtonBorder
extends AbstractBorder {
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean isPressed = model.isPressed() && model.isArmed();
            boolean isRollover = b.isRolloverEnabled() && model.isRollover();
            boolean isEnabled = b.isEnabled();
            if (!isEnabled) {
                this.paintDisabled(b, g, x, y, width, height);
            } else if (isPressed) {
                this.paintPressed(b, g, x, y, width, height);
            } else if (isRollover) {
                this.paintRollover(b, g, x, y, width, height);
            } else {
                this.paintNormal(b, g, x, y, width, height);
            }
        }
    }

    protected void paintNormal(AbstractButton b, Graphics g, int x, int y, int width, int height) {
    }

    protected void paintDisabled(AbstractButton b, Graphics g, int x, int y, int width, int height) {
    }

    protected void paintRollover(AbstractButton b, Graphics g, int x, int y, int width, int height) {
    }

    protected void paintPressed(AbstractButton b, Graphics g, int x, int y, int width, int height) {
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return insets;
    }
}

