/* 
    JSPWiki - a JSP-based WikiWiki clone.

    Copyright (C) 2001-2002 Janne Jalkanen (Janne.Jalkanen@iki.fi)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.*;
import java.util.*;

/**
 * Plugin for displaying pages that are not linked to in other pages.
 * Uses the ReferenceManager.
 * <p>
 * Parameters: none. <BR>
 * From AbstractReferralPlugin:<BR>
 * separator: How to separate generated links; default is a wikitext line break,
 *            producing a vertical list.<BR>
 * maxwidth: maximum width, in chars, of generated links.
 *
 *  @author Janne Jalkanen
 */
public class UnusedPagesPlugin
    extends AbstractReferralPlugin
{
    /**
     *  If set to "true", attachments are excluded from display.  Value is {@value}.
     */
    public static final String PARAM_EXCLUDEATTS = "excludeattachments";

    /**
     *  {@inheritDoc}
     */
    public String execute( WikiContext context, Map params )
        throws PluginException
    {
        ReferenceManager refmgr = context.getEngine().getReferenceManager();
        Collection links = refmgr.findUnreferenced();
        //
        // filter out attachments if "excludeattachments" was requested:
        //
        String prop = (String) params.get( PARAM_EXCLUDEATTS );
        if( TextUtil.isPositive(prop) ) 
        {
            //  remove links to attachments (recognizable by a slash in it)
            //  FIXME: In 3.0, this assumption is going to fail. FIXME3.0
            Iterator iterator = links.iterator();
            while( iterator.hasNext() ) 
            {
                String link = (String) iterator.next();
                if (link.indexOf("/")!=-1) 
                {
                    iterator.remove();
                }
            }
        }

        super.initialize( context, params );

        TreeSet sortedSet = new TreeSet();

        sortedSet.addAll( links );

        filterCollection( links );
        String wikitext = wikitizeCollection( sortedSet, m_separator, ALL_ITEMS );
        
        return makeHTML( context, wikitext );
    }

}

