/*
    JSPWiki - a JSP-based WikiWiki clone.

    Copyright (C) 2001-2004 Janne Jalkanen (Janne.Jalkanen@iki.fi)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.ecyrd.jspwiki.workflow;

import com.ecyrd.jspwiki.WikiException;

/**
 * Exception thrown when an activity -- that would otherwise complete silently --
 * cannot complete because a workflow {@link Decision} is required. The message
 * string should be a human-readable, internationalized String explaining why
 * the activity could not complete, or that the activity has been queued for 
 * review.
 *
 * @author Andrew Jaquith
 */
public class DecisionRequiredException extends WikiException
{

    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new exception.
     * @param message the message
     */
    public DecisionRequiredException(String message)
    {
        super(message);
    }
}
