/* Version 0.82rc9 */
/*
    Copyright 2008-2010
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with JSXGraph.  If not, see <http://www.gnu.org/licenses/>.
*/
    var JXG={};(function(){var d,e;JXG.countDrawings=0;JXG.countTime=0;JXG.require=function(f){};JXG.rendererFiles=[];JXG.rendererFiles.svg="SVGRenderer";JXG.rendererFiles.vml="VMLRenderer";JXG.rendererFiles.canvas="CanvasRenderer";JXG.baseFiles=null;JXG.requirePath="";for(d=0;d<document.getElementsByTagName("script").length;d++){e=document.getElementsByTagName("script")[d];if(e.src&&e.src.match(/loadjsxgraphInOneFile\.js(\?.*)?$/)){JXG.requirePath=e.src.replace(/loadjsxgraphInOneFile\.js(\?.*)?$/,"")}}JXG.serverBase=JXG.requirePath+"server/"})();JXG.Math=(function(e,d,f){var g=function(j){var h,k;if(j.memo){return j.memo}h={};k=Array.prototype.join;return(j.memo=function(){var l=k.call(arguments);return(h[l]!==f)?h[l]:h[l]=j.apply(this,arguments)})};return{eps:0.000001,vector:function(l,k){var j,h;k=k||0;j=new Array(d.ceil(l));for(h=0;h<l;h++){j[h]=k}return j},matrix:function(t,h,s){var q,l,k;s=s||0;h=h||t;q=new Array(d.ceil(t));for(l=0;l<t;l++){q[l]=new Array(d.ceil(h));for(k=0;k<h;k++){q[l][k]=s}}return q},identity:function(l,h){var k,j;if((h===f)&&(typeof h!=="number")){h=l}k=this.matrix(l,h);for(j=0;j<d.min(l,h);j++){k[j][j]=1}return k},matVecMult:function(t,r){var h=t.length,v=r.length,q=[],l,u,j;if(v===3){for(l=0;l<h;l++){q[l]=t[l][0]*r[0]+t[l][1]*r[1]+t[l][2]*r[2]}}else{for(l=0;l<h;l++){u=0;for(j=0;j<v;j++){u+=t[l][j]*r[j]}q[l]=u}}return q},matMatMult:function(l,h){var r=l.length,q=r>0?h[0].length:0,x=h.length,w=this.matrix(r,q),v,u,y,t;for(v=0;v<r;v++){for(u=0;u<q;u++){y=0;for(t=0;t<x;t++){y+=l[v][t]*h[t][u]}w[v][u]=y}}return w},transpose:function(s){var l,q,k,h,r;h=s.length;r=s.length>0?s[0].length:0;l=this.matrix(r,h);for(q=0;q<r;q++){for(k=0;k<h;k++){l[q][k]=s[k][q]}}return l},inverse:function(y){var v,u,t,B,z,h,x,q=y.length,m=[],l=[],w=[];for(v=0;v<q;v++){m[v]=[];for(u=0;u<q;u++){m[v][u]=y[v][u]}l[v]=v}for(u=0;u<q;u++){z=d.abs(m[u][u]);h=u;for(v=u+1;v<q;v++){if(d.abs(m[v][u])>z){z=d.abs(m[v][u]);h=v}}if(z<=e.Math.eps){return false}if(h>u){for(t=0;t<q;t++){x=m[u][t];m[u][t]=m[h][t];m[h][t]=x}x=l[u];l[u]=l[h];l[h]=x}B=1/m[u][u];for(v=0;v<q;v++){m[v][u]*=B}m[u][u]=B;for(t=0;t<q;t++){if(t!=u){for(v=0;v<q;v++){if(v!=u){m[v][t]-=m[v][u]*m[u][t]}}m[u][t]=-B*m[u][t]}}}for(v=0;v<q;v++){for(t=0;t<q;t++){w[l[t]]=m[v][t]}for(t=0;t<q;t++){m[v][t]=w[t]}}return m},innerProduct:function(j,h,m){var k,l=0;if((m===f)||(typeof m!=="number")){m=j.length}for(k=0;k<m;k++){l+=j[k]*h[k]}return l},crossProduct:function(j,h){return[j[1]*h[2]-j[2]*h[1],j[2]*h[0]-j[0]*h[2],j[0]*h[1]-j[1]*h[0]]},factorial:g(function(h){if(h<0){return NaN}h=d.floor(h);if(h===0||h===1){return 1}return h*arguments.callee(h-1)}),binomial:g(function(m,j){var h,l;if(j>m||j<0){return NaN}j=d.floor(j);m=d.floor(m);if(j===0||j===m){return 1}h=1;for(l=0;l<j;l++){h*=(m-l);h/=(l+1)}return h}),cosh:function(h){return(d.exp(h)+d.exp(-h))*0.5},sinh:function(h){return(d.exp(h)-d.exp(-h))*0.5},pow:function(j,h){if(j===0){if(h===0){return 1}else{return 0}}if(d.floor(h)===h){return d.pow(j,h)}else{if(j>0){return d.exp(h*d.log(d.abs(j)))}else{return NaN}}},squampow:function(k,j){var h;if(d.floor(j)===j){h=1;if(j<0){k=1/k;j*=-1}while(j!=0){if(j&1){h*=k}j>>=1;k*=k}return h}else{return this.pow(k,j)}},normalize:function(k){var h=2*k[3],l=k[4]/(h),m,j;k[5]=l;k[6]=-k[1]/h;k[7]=-k[2]/h;if(l===Infinity||isNaN(l)){m=d.sqrt(k[1]*k[1]+k[2]*k[2]);k[0]/=m;k[1]/=m;k[2]/=m;k[3]=0;k[4]=1}else{if(d.abs(l)>=1){k[0]=(k[6]*k[6]+k[7]*k[7]-l*l)/(2*l);k[1]=-k[6]/l;k[2]=-k[7]/l;k[3]=1/(2*l);k[4]=1}else{j=(l<=0)?(-1):(1);k[0]=j*(k[6]*k[6]+k[7]*k[7]-l*l)*0.5;k[1]=-j*k[6];k[2]=-j*k[7];k[3]=j/2;k[4]=j*l}}return k}}})(JXG,Math);JXG.Math.Numerics=(function(e,d){var f={rk4:{s:4,A:[[0,0,0,0],[0.5,0,0,0],[0,0.5,0,0],[0,0,1,0]],b:[1/6,1/3,1/3,1/6],c:[0,0.5,0.5,1]},heun:{s:2,A:[[0,0],[1,0]],b:[0.5,0.5],c:[0,1]},euler:{s:1,A:[[0]],b:[1],c:[0]}};return{Gauss:function(g,t){var v=e.Math.eps,h=g.length>0?g[0].length:0,r,u,s,q,m,l=function(w,n){var k=this[w];this[w]=this[n];this[n]=k};if((h!==t.length)||(h!==g.length)){throw new Error("JXG.Math.Numerics.Gauss: Dimensions don't match. A must be a square matrix and b must be of the same length as A.")}r=new Array(h);u=t.slice(0,h);for(s=0;s<h;s++){r[s]=g[s].slice(0,h)}for(q=0;q<h;q++){for(s=h-1;s>q;s--){if(d.abs(r[s][q])>v){if(d.abs(r[q][q])<v){l.apply(r,[s,q]);l.apply(u,[s,q])}else{r[s][q]/=r[q][q];u[s]-=r[s][q]*u[q];for(m=q+1;m<h;m++){r[s][m]-=r[s][q]*r[q][m]}}}}if(d.abs(r[q][q])<v){throw new Error("JXG.Math.Numerics.Gauss(): The given matrix seems to be singular.")}}this.backwardSolve(r,u,true);return u},backwardSolve:function(s,k,r){var h,g,t,q,l;if(r){h=k}else{h=k.slice(0,k.length)}g=s.length;t=s.length>0?s[0].length:0;for(q=g-1;q>=0;q--){for(l=t-1;l>q;l--){h[q]-=s[q][l]*h[l]}h[q]/=s[q][q]}return h},Jacobi:function(z){var t,r,q,g,u,y,x,B=e.Math.eps,w=0,v,s,l=z.length,m=[[0,0,0],[0,0,0],[0,0,0]],h=[[0,0,0],[0,0,0],[0,0,0]];for(t=0;t<l;t++){for(r=0;r<l;r++){m[t][r]=0;h[t][r]=z[t][r];w+=d.abs(h[t][r])}m[t][t]=1}if(l==1){return[h,m]}if(w<=0){return[h,m]}w/=(l*l);do{v=0;s=0;for(r=1;r<l;r++){for(t=0;t<r;t++){g=d.abs(h[t][r]);if(g>s){s=g}v+=g;if(g>=B){g=d.atan2(2*h[t][r],h[t][t]-h[r][r])*0.5;u=d.sin(g);y=d.cos(g);for(q=0;q<l;q++){x=h[q][t];h[q][t]=y*x+u*h[q][r];h[q][r]=-u*x+y*h[q][r];x=m[q][t];m[q][t]=y*x+u*m[q][r];m[q][r]=-u*x+y*m[q][r]}h[t][t]=y*h[t][t]+u*h[r][t];h[r][r]=-u*h[t][r]+y*h[r][r];h[t][r]=0;for(q=0;q<l;q++){h[t][q]=h[q][t];h[r][q]=h[q][r]}}}}}while(d.abs(v)/w>B);return[h,m]},NewtonCotes:function(g,k,h){var l=0,r=h&&typeof h.number_of_nodes==="number"?h.number_of_nodes:28,n={trapez:true,simpson:true,milne:true},s=h&&h.integration_type&&n.hasOwnProperty(h.integration_type)&&n[h.integration_type]?h.integration_type:"milne",q=(g[1]-g[0])/r,m,j,t;switch(s){case"trapez":l=(k(g[0])+k(g[1]))*0.5;m=g[0];for(j=0;j<r-1;j++){m+=q;l+=k(m)}l*=q;break;case"simpson":if(r%2>0){throw new Error("JSXGraph:  INT_SIMPSON requires config.number_of_nodes dividable by 2.")}t=r/2;l=k(g[0])+k(g[1]);m=g[0];for(j=0;j<t-1;j++){m+=2*q;l+=2*k(m)}m=g[0]-q;for(j=0;j<t;j++){m+=2*q;l+=4*k(m)}l*=q/3;break;default:if(r%4>0){throw new Error("JSXGraph: Error in INT_MILNE: config.number_of_nodes must be a multiple of 4")}t=r*0.25;l=7*(k(g[0])+k(g[1]));m=g[0];for(j=0;j<t-1;j++){m+=4*q;l+=14*k(m)}m=g[0]-3*q;for(j=0;j<t;j++){m+=4*q;l+=32*(k(m)+k(m+2*q))}m=g[0]-2*q;for(j=0;j<t;j++){m+=4*q;l+=12*k(m)}l*=2*q/45}return l},I:function(g,h){return this.NewtonCotes(g,h,{number_of_nodes:16,integration_type:"milne"})},Newton:function(n,g,j){var k=0,l=e.Math.eps,m=n.apply(j,[g]),q;while(k<50&&d.abs(m)>l){q=this.D(n,j)(g);if(d.abs(q)>l){g-=m/q}else{g+=(d.random()*0.2-1)}m=n.apply(j,[g]);k++}return g},root:function(j,g,h){return this.Newton(j,g,h)},Neville:function(l){var h=[],g=function(m){return function(y,n){var r,x,z,A=e.Math.binomial,w=l.length,q=w-1,u=0,v=0;if(!n){z=1;for(r=0;r<w;r++){h[r]=A(q,r)*z;z*=(-1)}}x=y;for(r=0;r<w;r++){if(x===0){return l[r][m]()}else{z=h[r]/x;x--;u+=l[r][m]()*z;v+=z}}return u/v}},k=g("X"),j=g("Y");return[k,j,0,function(){return l.length-1}]},splineDef:function(t,s){var g=d.min(t.length,s.length),j,m,h,q=[],r=[],k=[],w=[],u=[],v=[];if(g===2){return[0,0]}for(m=0;m<g;m++){j={X:t[m],Y:s[m]};k.push(j)}k.sort(function(n,l){return n.X-l.X});for(m=0;m<g;m++){t[m]=k[m].X;s[m]=k[m].Y}for(m=0;m<g-1;m++){w.push(t[m+1]-t[m])}for(m=0;m<g-2;m++){u.push(6*(s[m+2]-s[m+1])/(w[m+1])-6*(s[m+1]-s[m])/(w[m]))}q.push(2*(w[0]+w[1]));r.push(u[0]);for(m=0;m<g-3;m++){h=w[m+1]/q[m];q.push(2*(w[m+1]+w[m+2])-h*w[m+1]);r.push(u[m+1]-h*r[m])}v[g-3]=r[g-3]/q[g-3];for(m=g-4;m>=0;m--){v[m]=(r[m]-(w[m+1]*v[m+1]))/q[m]}for(m=g-3;m>=0;m--){v[m+1]=v[m]}v[0]=0;v[g-1]=0;return v},splineEval:function(h,A,w,C){var k=d.min(A.length,w.length),q=1,m=false,B=[],s,r,z,v,u,t,g;if(e.isArray(h)){q=h.length;m=true}else{h=[h]}for(s=0;s<q;s++){if((h[s]<A[0])||(A[s]>A[k-1])){return NaN}for(r=1;r<k;r++){if(h[s]<=A[r]){break}}r--;z=w[r];v=(w[r+1]-w[r])/(A[r+1]-A[r])-(A[r+1]-A[r])/6*(C[r+1]+2*C[r]);u=C[r]/2;t=(C[r+1]-C[r])/(6*(A[r+1]-A[r]));g=h[s]-A[r];B.push(z+(v+(u+t*g)*g)*g)}if(m){return B}else{return B[0]}},generatePolynomialTerm:function(g,m,h,j){var l=[],k;for(k=m;k>=0;k--){l=l.concat(["(",g[k].toPrecision(j),")"]);if(k>1){l=l.concat(["*",h,"<sup>",k,"<","/sup> + "])}else{if(k===1){l=l.concat(["*",h," + "])}}}return l.join("")},lagrangePolynomial:function(j){var g=[],h=function(y,l){var q,m,u,w,z,r=0,t=0,v,n;u=j.length;if(!l){for(q=0;q<u;q++){g[q]=1;w=j[q].X();for(m=0;m<u;m++){if(m!=q){g[q]*=(w-j[m].X())}}g[q]=1/g[q]}v=[];for(n=0;n<u;n++){v.push([1])}}for(q=0;q<u;q++){w=j[q].X();if(y===w){return j[q].Y()}else{z=g[q]/(y-w);t+=z;r+=z*j[q].Y()}}return r/t};h.getTerm=function(){return""};return h},regressionPolynomial:function(l,r,q){var g,h,n,m,j,s,k="";if(e.isPoint(l)&&typeof l.Value=="function"){h=l.Value}else{if(e.isFunction(l)){h=l}else{if(e.isNumber(l)){h=function(){return l}}else{throw new Error("JSXGraph: Can't create regressionPolynomial from degree of type'"+(typeof l)+"'.")}}}if(arguments.length==3&&e.isArray(r)&&e.isArray(q)){j=0}else{if(arguments.length==2&&e.isArray(r)&&r.length>0&&e.isPoint(r[0])){j=1}else{throw new Error("JSXGraph: Can't create regressionPolynomial. Wrong parameters.")}}s=function(G,t){var w,v,D,A,F,u,E,H,C,z=r.length;C=d.floor(h());if(!t){if(j===1){n=[];m=[];for(w=0;w<z;w++){n[w]=r[w].X();m[w]=r[w].Y()}}if(j===0){n=[];m=[];for(w=0;w<z;w++){if(e.isFunction(r[w])){n.push(r[w]())}else{n.push(r[w])}if(e.isFunction(q[w])){m.push(q[w]())}else{m.push(q[w])}}}D=[];for(v=0;v<z;v++){D.push([1])}for(w=1;w<=C;w++){for(v=0;v<z;v++){D[v][w]=D[v][w-1]*n[v]}}F=m;A=e.Math.transpose(D);u=e.Math.matMatMult(A,D);E=e.Math.matVecMult(A,F);g=e.Math.Numerics.Gauss(u,E);k=e.Math.Numerics.generatePolynomialTerm(g,C,"x",3)}H=g[C];for(w=C-1;w>=0;w--){H=(H*G+g[w])}return H};s.getTerm=function(){return k};return s},bezier:function(j){var g,h=function(k){return function(m,l){var r=d.floor(m)*3,q=m%1,n=1-q;if(!l){g=d.floor(j.length/3)}if(m<0){return j[0][k]()}if(m>=g){return j[j.length-1][k]()}if(isNaN(m)){return NaN}return n*n*(n*j[r][k]()+3*q*j[r+1][k]())+(3*n*j[r+2][k]()+q*j[r+3][k]())*q*q}};return[h("X"),h("Y"),0,function(){return d.floor(j.length/3)}]},bspline:function(k,g){var l,n=[],m=function(t,q){var r,s=[];for(r=0;r<t+q+1;r++){if(r<q){s[r]=0}else{if(r<=t){s[r]=r-q+1}else{s[r]=t-q+2}}}return s},j=function(A,C,q,r,B){var v,u,y,x,z,w=[];if(C[B]<=A&&A<C[B+1]){w[B]=1}else{w[B]=0}for(v=2;v<=r;v++){for(u=B-v+1;u<=B;u++){if(u<=B-v+1||u<0){y=0}else{y=w[u]}if(u>=B){x=0}else{x=w[u+1]}z=C[u+v-1]-C[u];if(z==0){w[u]=0}else{w[u]=(A-C[u])/z*y}z=C[u+v]-C[u+1];if(z!=0){w[u]+=(C[u+v]-A)/z*x}}}return w},h=function(q){return function(x,u){var r=k.length,B,w,z,A=r-1,v=g;if(A<=0){return NaN}if(A+2<=v){v=A+1}if(x<=0){return k[0][q]()}if(x>=A-v+2){return k[A][q]()}l=m(A,v);z=d.floor(x)+v-1;n=j(x,l,A,v,z);B=0;for(w=z-v+1;w<=z;w++){if(w<r&&w>=0){B+=k[w][q]()*n[w]}}return B}};return[h("X"),h("Y"),0,function(){return k.length-1}]},D:function(k,l){var j=0.00001,g=1/(j*2);if(arguments.length==1||(arguments.length>1&&arguments[1]===e.undefined)){return function(h,m){return(k(h+j,m)-k(h-j,m))*g}}else{return function(h,m){return(k.apply(l,[h+j,m])-k.apply(l,[h-j,m]))*g}}},riemann:function(t,m,u,k,q){var l=[],B=[],s,r=0,A,z=k,v,h,w,g;m=d.floor(m);l[r]=z;B[r]=0;if(m>0){A=(q-k)/m;g=A*0.01;for(s=0;s<m;s++){if(u==="right"){v=t(z+A)}else{if(u==="middle"){v=t(z+A*0.5)}else{if((u==="left")||(u==="trapezodial")){v=t(z)}else{if(u==="lower"){v=t(z);for(h=z+g;h<=z+A;h+=g){w=t(h);if(w<v){v=w}}}else{v=t(z);for(h=z+g;h<=z+A;h+=g){w=t(h);if(w>v){v=w}}}}}}r++;l[r]=z;B[r]=v;r++;z+=A;if(u==="trapezodial"){v=t(z)}l[r]=z;B[r]=v;r++;l[r]=z;B[r]=0}}return[l,B]},riemannsum:function(q,k,s,j,l){var r=0,m,w,v=j,t,h,u,g;k=d.floor(k);if(k>0){w=(l-j)/k;g=w*0.01;for(m=0;m<k;m++){if(s==="right"){t=q(v+w)}else{if(s==="middle"){t=q(v+w*0.5)}else{if(s==="trapezodial"){t=0.5*(q(v+w)+q(v))}else{if(s==="left"){t=q(v)}else{if(s==="lower"){t=q(v);for(h=v+g;h<=v+w;h+=g){u=q(h);if(u<t){t=u}}}else{t=q(v);for(h=v+g;h<=v+w;h+=g){u=q(h);if(u>t){t=u}}}}}}}r+=w*t;v+=w}}return r},rungeKutta:function(g,J,q,m,H){var u=[],n=[],G=(q[1]-q[0])/m,w=q[0],K,F,E,C,B,D=J.length,z,v=[],A=0;if(e.isString(g)){g=f[g]||f.euler}z=g.s;for(K=0;K<D;K++){u[K]=J[K]}for(F=0;F<m;F++){v[A]=[];for(K=0;K<D;K++){v[A][K]=u[K]}A++;C=[];for(E=0;E<z;E++){for(K=0;K<D;K++){n[K]=0}for(B=0;B<E;B++){for(K=0;K<D;K++){n[K]+=(g.A[E][B])*G*C[B][K]}}for(K=0;K<D;K++){n[K]+=u[K]}C.push(H(w+g.c[E]*G,n))}for(K=0;K<D;K++){n[K]=0}for(B=0;B<z;B++){for(K=0;K<D;K++){n[K]+=g.b[B]*C[B][K]}}for(K=0;K<D;K++){u[K]=u[K]+G*n[K]}w+=G}return v}}})(JXG,Math);JXG.Math.Statistics={};JXG.Math.Statistics.sum=function(e){var g,d,f=0;for(g=0,d=e.length;g<d;g++){f+=e[g]}return f};JXG.Math.Statistics.prod=function(e){var g,d,f=1;for(g=0,d=e.length;g<d;g++){f*=e[g]}return f};JXG.Math.Statistics.mean=function(d){if(d.length>0){return this.sum(d)/d.length}else{return 0}};JXG.Math.Statistics.median=function(e){var f,d;if(e.length>0){f=e.slice(0,e.length);f.sort(function(h,g){return h-g});d=f.length;if(d%2==1){return f[parseInt(d*0.5)]}else{return(f[d*0.5-1]+f[d*0.5])*0.5}}else{return 0}};JXG.Math.Statistics.variance=function(f){var e,h,g,d;if(f.length>1){e=this.mean(f);h=0;for(g=0,d=f.length;g<d;g++){h+=(f[g]-e)*(f[g]-e)}return h/(f.length-1)}else{return 0}};JXG.Math.Statistics.sd=function(d){return Math.sqrt(this.variance(d))};JXG.Math.Statistics.weightedMean=function(d,e){if(d.length!=e.length){return}if(d.length>0){return this.mean(this.multiply(d,e))}else{return 0}};JXG.Math.Statistics.max=function(e){var g,f,d;if(e.length==0){return NaN}g=e[0];for(f=1,d=e.length;f<d;f++){g=(e[f]>g)?(e[f]):g}return g};JXG.Math.Statistics.min=function(e){var g,f,d;if(e.length==0){return NaN}g=e[0];for(f=1,d=e.length;f<d;f++){g=(e[f]<g)?(e[f]):g}return g};JXG.Math.Statistics.range=function(d){return[this.min(d),this.max(d)]};JXG.Math.Statistics.diff=function(d){return d};JXG.Math.Statistics.min=function(e){var g,f,d;if(e.length==0){return NaN}g=e[0];for(f=1,d=e.length;f<d;f++){g=(e[f]<g)?(e[f]):g}return g};JXG.Math.Statistics.abs=function(e){var g,d,f=[];if(typeof JXG.isArray(arr1)){for(g=0,d=e.length;g<d;g++){f[g]=Math.abs(e[g])}}else{if(typeof e=="number"){return Math.abs(e)}else{f=null}}return f};JXG.Math.Statistics.add=function(f,e){var h,d,g=[];if(typeof JXG.isArray(f)&&typeof e=="number"){for(h=0,d=f.length;h<d;h++){g[h]=f[h]+e}}else{if(typeof f=="number"&&typeof JXG.isArray(e)){for(h=0,d=e.length;h<d;h++){g[h]=f+e[h]}}else{if(typeof JXG.isArray(f)&&typeof JXG.isArray(e)){for(h=0,d=Math.min(f.length,e.length);h<d;h++){g[h]=f[h]+e[h]}}else{if(typeof f=="number"&&typeof e=="number"){g=f+e}else{g=null}}}}return g};JXG.Math.Statistics.divide=function(f,e){var h,d,g=[];if(typeof JXG.isArray(f)&&typeof e=="number"){for(h=0,d=f.length;h<d;h++){g[h]=f[h]/e}}else{if(typeof f=="number"&&typeof JXG.isArray(e)){for(h=0,d=e.length;h<d;h++){g[h]=f/e[h]}}else{if(typeof JXG.isArray(f)&&typeof JXG.isArray(e)){for(h=0,d=Math.min(f.length,e.length);h<d;h++){g[h]=f[h]/e[h]}}else{if(typeof f=="number"&&typeof e=="number"){g=f/e}else{g=null}}}}return g};JXG.Math.Statistics.mod=function(f,e){var h,d,g=[];if(typeof JXG.isArray(f)&&typeof e=="number"){for(h=0,d=f.length;h<d;h++){g[h]=f[h]%e}}else{if(typeof f=="number"&&typeof JXG.isArray(e)){for(h=0,d=e.length;h<d;h++){g[h]=f%e[h]}}else{if(typeof JXG.isArray(f)&&typeof JXG.isArray(e)){for(h=0,d=Math.min(f.length,e.length);h<d;h++){g[h]=f[h]%e[h]}}else{if(typeof f=="number"&&typeof e=="number"){g=f%e}else{g=null}}}}return g};JXG.Math.Statistics.multiply=function(f,e){var h,d,g=[];if(typeof JXG.isArray(f)&&typeof e=="number"){for(h=0,d=f.length;h<d;h++){g[h]=f[h]*e}}else{if(typeof f=="number"&&typeof JXG.isArray(e)){for(h=0,d=e.length;h<d;h++){g[h]=f*e[h]}}else{if(typeof JXG.isArray(f)&&typeof JXG.isArray(e)){for(h=0,d=Math.min(f.length,e.length);h<d;h++){g[h]=f[h]*e[h]}}else{if(typeof f=="number"&&typeof e=="number"){g=f*e}else{g=null}}}}return g};JXG.Math.Statistics.subtract=function(f,e){var h,d,g=[];if(typeof JXG.isArray(f)&&typeof e=="number"){for(h=0,d=f.length;h<d;h++){g[h]=f[h]-e}}else{if(typeof f=="number"&&typeof JXG.isArray(e)){for(h=0,d=e.length;h<d;h++){g[h]=f-e[h]}}else{if(typeof JXG.isArray(f)&&typeof JXG.isArray(e)){for(h=0,d=Math.min(f.length,e.length);h<d;h++){g[h]=f[h]-e[h]}}else{if(typeof f=="number"&&typeof e=="number"){g=f-e}else{g=null}}}}return g};JXG.Math.Symbolic=function(d,e){return{generateSymbolicCoordinatesPartial:function(r,l,j,g){var f=function(k){var t;if(g==="underscore"){t=""+j+"_{"+k+"}"}else{if(g=="brace"){t=""+j+"["+k+"]"}else{t=""+j+""+k}}return t},n=l.ancestors,m=0,q,s,h;r.listOfFreePoints=[];r.listOfDependantPoints=[];for(s in n){q=0;if(d.isPoint(n[s])){for(h in n[s].ancestors){q++}if(q===0){n[s].symbolic.x=n[s].coords.usrCoords[1];n[s].symbolic.y=n[s].coords.usrCoords[2];r.listOfFreePoints.push(n[s])}else{m++;n[s].symbolic.x=f(m);m++;n[s].symbolic.y=f(m);r.listOfDependantPoints.push(n[s])}}}if(d.isPoint(l)){l.symbolic.x="x";l.symbolic.y="y"}return m},clearSymbolicCoordinates:function(g){var f=function(k){var j,h=(k&&k.length)||0;for(j=0;j<h;j++){if(d.isPoint(k[j])){k[j].symbolic.x="";k[j].symbolic.y=""}}};f(g.listOfFreePoints);f(g.listOfDependantPoints);delete (g.listOfFreePoints);delete (g.listOfDependantPoints)},generatePolynomials:function(n,h,j){var m=h.ancestors,q,l=[],s=[],r,f,g;if(j){this.generateSymbolicCoordinatesPartial(n,h,"u","brace")}m[h.id]=h;for(r in m){q=0;l=[];if(d.isPoint(m[r])){for(f in m[r].ancestors){q++}if(q>0){l=m[r].generatePolynomial();for(g=0;g<l.length;g++){s.push(l[g])}}}}if(j){this.clearSymbolicCoordinates(n)}return s},geometricLocusByGroebnerBase:function(n,B){var l=this.generateSymbolicCoordinatesPartial(n,B,"u","brace"),m,h,t,f={},x=new d.Coords(d.COORDS_BY_USR,[0,0],n),v=new d.Coords(d.COORDS_BY_USR,[n.canvasWidth,n.canvasHeight],n),k,j,E,H=1,w=0,u=0,q=0,F,y,G,r,A,C,g,D=function(I,J){var s;for(s=0;s<J.length;s++){if(J[s].id===I){return true}}return false},z=n.options.locus;if(d.Server.modules.geoloci===e){d.Server.loadModule("geoloci")}if(d.Server.modules.geoloci===e){throw new Error("JSXGraph: Unable to load JXG.Server module 'geoloci.py'.")}r=x.usrCoords[1];A=v.usrCoords[1];C=v.usrCoords[2];g=x.usrCoords[2];if(z.translateToOrigin&&(n.listOfFreePoints.length>0)){if((z.toOrigin!==e)&&(z.toOrigin!=null)&&D(z.toOrigin.id,n.listOfFreePoints)){k=z.toOrigin}else{k=n.listOfFreePoints[0]}w=k.symbolic.x;u=k.symbolic.y;for(E=0;E<n.listOfFreePoints.length;E++){n.listOfFreePoints[E].symbolic.x-=w;n.listOfFreePoints[E].symbolic.y-=u}r-=w;A-=w;C-=u;g-=u;if(z.translateTo10&&(n.listOfFreePoints.length>1)){if((z.to10!==e)&&(z.to10!=null)&&(z.to10.id!=z.toOrigin.id)&&D(z.to10.id,n.listOfFreePoints)){j=z.to10}else{if(n.listOfFreePoints[0].id==k.id){j=n.listOfFreePoints[1]}else{j=n.listOfFreePoints[0]}}q=d.Math.Geometry.rad([1,0],[0,0],[j.symbolic.x,j.symbolic.y]);F=Math.cos(-q);y=Math.sin(-q);for(E=0;E<n.listOfFreePoints.length;E++){G=n.listOfFreePoints[E].symbolic.x;n.listOfFreePoints[E].symbolic.x=F*n.listOfFreePoints[E].symbolic.x-y*n.listOfFreePoints[E].symbolic.y;n.listOfFreePoints[E].symbolic.y=y*G+F*n.listOfFreePoints[E].symbolic.y}j.symbolic.y=0;G=r;r=F*r-y*C;C=y*G+F*C;G=A;A=F*A-y*g;g=y*G+F*g;if(z.stretch&&(Math.abs(j.symbolic.x)>d.Math.eps)){H=j.symbolic.x;for(E=0;E<n.listOfFreePoints.length;E++){n.listOfFreePoints[E].symbolic.x/=H;n.listOfFreePoints[E].symbolic.y/=H}for(E in n.objects){if((n.objects[E].elementClass==d.OBJECT_CLASS_CIRCLE)&&(n.objects[E].method=="pointRadius")){f[E]=n.objects[E].radius;n.objects[E].radius/=H}}r/=H;A/=H;C/=H;g/=H;j.symbolic.x=1}}for(E=0;E<n.listOfFreePoints.length;E++){G=n.listOfFreePoints[E].symbolic.x;if(Math.abs(G)<d.Math.eps){n.listOfFreePoints[E].symbolic.x=0}if(Math.abs(G-Math.round(G))<d.Math.eps){n.listOfFreePoints[E].symbolic.x=Math.round(G)}G=n.listOfFreePoints[E].symbolic.y;if(Math.abs(G)<d.Math.eps){n.listOfFreePoints[E].symbolic.y=0}if(Math.abs(G-Math.round(G))<d.Math.eps){n.listOfFreePoints[E].symbolic.y=Math.round(G)}}}m=this.generatePolynomials(n,B);h=m.join(",");this.cbp=function(s){t=s};this.cb=d.bind(this.cbp,this);d.Server.modules.geoloci.lociCoCoA(r,A,C,g,l,h,H,q,w,u,this.cb,true);this.clearSymbolicCoordinates(n);for(E in f){n.objects[E].radius=f[E]}return t}}}(JXG);JXG.Math.Geometry={};JXG.Math.Geometry.angle=function(f,e,d){var j=[],h=[],g=[],l,k,n,m;if(f.coords==null){j[0]=f[0];j[1]=f[1]}else{j[0]=f.coords.usrCoords[1];j[1]=f.coords.usrCoords[2]}if(e.coords==null){h[0]=e[0];h[1]=e[1]}else{h[0]=e.coords.usrCoords[1];h[1]=e.coords.usrCoords[2]}if(d.coords==null){g[0]=d[0];g[1]=d[1]}else{g[0]=d.coords.usrCoords[1];g[1]=d.coords.usrCoords[2]}l=j[0]-h[0];k=j[1]-h[1];n=g[0]-h[0];m=g[1]-h[1];return Math.atan2(l*m-k*n,l*n+k*m)};JXG.Math.Geometry.trueAngle=function(d,f,e){return this.rad(d,f,e)*57.29577951308232};JXG.Math.Geometry.rad=function(s,r,q){var l,h,y,x,f,e,k,j,n,m,g,v,u,z,t,w,d=0;if(s.coords==null){l=s[0];h=s[1]}else{l=s.coords.usrCoords[1];h=s.coords.usrCoords[2]}if(r.coords==null){y=r[0];x=r[1]}else{y=r.coords.usrCoords[1];x=r.coords.usrCoords[2]}if(q.coords==null){f=q[0];e=q[1]}else{f=q.coords.usrCoords[1];e=q.coords.usrCoords[2]}n=f-y;m=e-x;k=l-y;j=h-x;w=n*k+m*j;g=k*m-j*n;v=Math.sqrt(k*k+j*j);u=Math.sqrt(n*n+m*m);z=w/(v*u);if(z>1){z=1}else{if(z<-1){z=-1}}t=Math.acos(z);if((Math.sin(t)*g)<0){d=6.283185307179586-t}else{d=t}return d};JXG.Math.Geometry.angleBisector=function(j,h,f,m){var g=j.coords.usrCoords,r=h.coords.usrCoords,k=f.coords.usrCoords,s=g[1]-r[1],q=g[2]-r[2],n=Math.sqrt(s*s+q*q),e,t,l;if(typeof m=="undefined"){m=j.board}s/=n;q/=n;e=Math.acos(s);if(q<0){e*=-1}if(e<0){e+=2*Math.PI}s=k[1]-r[1];q=k[2]-r[2];n=Math.sqrt(s*s+q*q);s/=n;q/=n;t=Math.acos(s);if(q<0){t*=-1}if(t<0){t+=2*Math.PI}l=(e+t)*0.5;if(e>t){l+=Math.PI}s=Math.cos(l)+r[1];q=Math.sin(l)+r[2];return new JXG.Coords(JXG.COORDS_BY_USER,[s,q],m)};JXG.Math.Geometry.reflection=function(r,m,f){var h=m.coords.usrCoords,s=r.point1.coords.usrCoords,g=r.point2.coords.usrCoords,e,l,d,j,n,k,q;if(typeof f=="undefined"){f=m.board}n=g[1]-s[1];k=g[2]-s[2];e=h[1]-s[1];l=h[2]-s[2];q=(n*l-k*e)/(n*n+k*k);d=h[1]+2*q*k;j=h[2]-2*q*n;return new JXG.Coords(JXG.COORDS_BY_USER,[d,j],f)};JXG.Math.Geometry.rotation=function(d,q,h,j){var l=q.coords.usrCoords,e=d.coords.usrCoords,g,n,k,r,f,m;if(typeof j=="undefined"){j=q.board}g=l[1]-e[1];n=l[2]-e[2];k=Math.cos(h);r=Math.sin(h);f=g*k-n*r+e[1];m=g*r+n*k+e[2];return new JXG.Coords(JXG.COORDS_BY_USER,[f,m],j)};JXG.Math.Geometry.perpendicular=function(t,r,j){var h=t.point1.coords.usrCoords,g=t.point2.coords.usrCoords,e=r.coords.usrCoords,n,m,l,s,k,f,d,q;if(typeof j=="undefined"){j=r.board}if(r==t.point1){n=h[1]+g[2]-h[2];m=h[2]-g[1]+h[1];l=true}else{if(r==t.point2){n=g[1]+h[2]-g[2];m=g[2]-h[1]+g[1];l=false}else{if(((Math.abs(h[1]-g[1])>JXG.Math.eps)&&(Math.abs(e[2]-(h[2]-g[2])*(e[1]-h[1])/(h[1]-g[1])-h[2])<JXG.Math.eps))||((Math.abs(h[1]-g[1])<=JXG.Math.eps)&&(Math.abs(h[1]-e[1])<JXG.Math.eps))){n=e[1]+g[2]-e[2];m=e[2]-g[1]+e[1];l=true;if(Math.abs(n-e[1])<JXG.Math.eps&&Math.abs(m-e[2])<JXG.Math.eps){n=e[1]+h[2]-e[2];m=e[2]-h[1]+e[1];l=false}}else{s=h[2]-g[2];k=h[1]-g[1];f=g[1]*s-g[2]*k;d=e[1]*k+e[2]*s;q=s*s+k*k;if(Math.abs(q)<JXG.Math.eps){q=JXG.Math.eps}n=(f*s+d*k)/q;m=(d*s-f*k)/q;l=true}}}return[new JXG.Coords(JXG.COORDS_BY_USER,[n,m],j),l]};JXG.Math.Geometry.circumcenterMidpoint=function(l,j,h,g){var f=l.coords.usrCoords,e=j.coords.usrCoords,d=h.coords.usrCoords,r,q,n,m,k;if(typeof g=="undefined"){g=l.board}r=((f[1]-e[1])*(f[1]+e[1])+(f[2]-e[2])*(f[2]+e[2]))*0.5;q=((e[1]-d[1])*(e[1]+d[1])+(e[2]-d[2])*(e[2]+d[2]))*0.5;n=(f[1]-e[1])*(e[2]-d[2])-(e[1]-d[1])*(f[2]-e[2]);if(Math.abs(n)<JXG.Math.eps){n=JXG.Math.eps}m=(r*(e[2]-d[2])-q*(f[2]-e[2]))/n;k=(q*(f[1]-e[1])-r*(e[1]-d[1]))/n;return new JXG.Coords(JXG.COORDS_BY_USER,[m,k],g)};JXG.Math.Geometry.distance=function(h,g){var f=0,e,d;if(h.length!=g.length){return}d=h.length;for(e=0;e<d;e++){f+=(h[e]-g[e])*(h[e]-g[e])}return Math.sqrt(f)};JXG.Math.Geometry.affineDistance=function(f,e){var g;if(f.length!=e.length){return}g=this.distance(f,e);if(g>JXG.Math.eps&&(Math.abs(f[0])<JXG.Math.eps||Math.abs(e[0])<JXG.Math.eps)){return Infinity}else{return g}};JXG.Math.Geometry.intersectLineLine=function(r,q,k){var j=r.point1.coords.usrCoords,g=r.point2.coords.usrCoords,f=q.point1.coords.usrCoords,d=q.point2.coords.usrCoords,h,e,n,m,l;if(typeof k=="undefined"){k=r.board}h=j[1]*g[2]-j[2]*g[1];e=f[1]*d[2]-f[2]*d[1];n=(g[2]-j[2])*(f[1]-d[1])-(j[1]-g[1])*(d[2]-f[2]);if(Math.abs(n)<JXG.Math.eps){n=JXG.Math.eps}m=(h*(f[1]-d[1])-e*(j[1]-g[1]))/n;l=(e*(g[2]-j[2])-h*(d[2]-f[2]))/n;return new JXG.Coords(JXG.COORDS_BY_USER,[m,l],k)};JXG.Math.Geometry.intersectCircleLine=function(m,A,n){var M=A.point1.coords.usrCoords,K=A.point2.coords.usrCoords,g=m.midpoint.coords.usrCoords,E,e,L,J,C,H,F,q,D,B,k,j,G,v,t,f,z,u,I;if(typeof n=="undefined"){n=A.board}E=A.point1.Dist(A.point2);if(E>0){e=m.midpoint.Dist(A.point1);L=m.midpoint.Dist(A.point2);J=((e*e)+(E*E)-(L*L))/(2*E);C=(e*e)-(J*J);C=(C<0)?0:C;H=Math.sqrt(C);F=m.Radius();q=Math.sqrt((F*F)-H*H);D=K[1]-M[1];B=K[2]-M[2];k=g[1]+(H/E)*B;j=g[2]-(H/E)*D;e=(K[1]*B)-(K[2]*D);L=(k*D)+(j*B);G=(B*B)+(D*D);if(Math.abs(G)<JXG.Math.eps){G=JXG.Math.eps}v=((e*B)+(L*D))/G;t=((L*B)-(e*D))/G;f=q/E;z=new JXG.Coords(JXG.COORDS_BY_USER,[v+f*D,t+f*B],n);u=new JXG.Coords(JXG.COORDS_BY_USER,[v-f*D,t-f*B],n);I=m.midpoint.coords.distance(JXG.COORDS_BY_USER,z);if((F<(I-1))||isNaN(I)){return[0]}else{return[2,z,u]}}return[0]};JXG.Math.Geometry.intersectCircleCircle=function(m,l,q){var e={},j=m.Radius(),g=l.Radius(),f=m.midpoint.coords.usrCoords,d=l.midpoint.coords.usrCoords,t,k,w,v,u,r,n;if(typeof q=="undefined"){q=m.board}t=j+g;k=Math.abs(j-g);w=m.midpoint.coords.distance(JXG.COORDS_BY_USER,l.midpoint.coords);if(w>t){return[0]}else{if(w<k){return[0]}else{if(w!=0){e[0]=1;v=d[1]-f[1];u=d[2]-f[2];r=(w*w-g*g+j*j)/(2*w);n=Math.sqrt(j*j-r*r);e[1]=new JXG.Coords(JXG.COORDS_BY_USER,[f[1]+(r/w)*v+(n/w)*u,f[2]+(r/w)*u-(n/w)*v],q);e[2]=new JXG.Coords(JXG.COORDS_BY_USER,[f[1]+(r/w)*v-(n/w)*u,f[2]+(r/w)*u+(n/w)*v],q)}else{return[0]}return e}}};JXG.Math.Geometry.meet=function(g,e,f,h){var d=JXG.Math.eps;if(Math.abs(g[3])<d&&Math.abs(e[3])<d){return this.meetLineLine(g,e,f,h)}else{if(Math.abs(g[3])>=d&&Math.abs(e[3])<d){return this.meetLineCircle(e,g,f,h)}else{if(Math.abs(g[3])<d&&Math.abs(e[3])>=d){return this.meetLineCircle(g,e,f,h)}else{return this.meetCircleCircle(g,e,f,h)}}}};JXG.Math.Geometry.meetLineLine=function(e,d,f,h){var g=JXG.Math.crossProduct(e,d);if(Math.abs(g[0])>JXG.Math.eps){g[1]/=g[0];g[2]/=g[0];g[0]=1}return new JXG.Coords(JXG.COORDS_BY_USER,g,h)};JXG.Math.Geometry.meetLineCircle=function(j,e,q,r){var w,v,u,s,l,h,g,f,m,x;if(e[4]<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(1,3),r)}u=e[0];v=e.slice(1,3);w=e[3];s=j[0];l=j.slice(1,3);h=w;g=(v[0]*l[1]-v[1]*l[0]);f=w*s*s-(v[0]*l[0]+v[1]*l[1])*s+u;m=g*g-4*h*f;if(m>=0){m=Math.sqrt(m);x=[(-g+m)/(2*h),(-g-m)/(2*h)];return((q==0)?new JXG.Coords(JXG.COORDS_BY_USER,[-x[0]*(-l[1])-s*l[0],-x[0]*l[0]-s*l[1]],r):new JXG.Coords(JXG.COORDS_BY_USER,[-x[1]*(-l[1])-s*l[0],-x[1]*l[0]-s*l[1]],r))}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],r)}};JXG.Math.Geometry.meetCircleCircle=function(f,d,e,g){var h;if(f[4]<JXG.Math.eps){if(this.distance(f.slice(1,3),d.slice(1,3))==d[4]){return new JXG.Coords(JXG.COORDS_BY_USER,f.slice(1,3),g)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],g)}}if(d[4]<JXG.Math.eps){if(this.distance(d.slice(1,3),f.slice(1,3))==f[4]){return new JXG.Coords(JXG.COORDS_BY_USER,d.slice(1,3),g)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],g)}}h=[d[3]*f[0]-f[3]*d[0],d[3]*f[1]-f[3]*d[1],d[3]*f[2]-f[3]*d[2],0,1,Infinity,Infinity,Infinity];h=JXG.Math.normalize(h);return this.meetLineCircle(h,f,e,g)};JXG.Math.Geometry.meetCurveCurve=function(u,t,h,l,n){var m=0,r,q,C,A,y,x,g,w,v,s,B,z,k,j;if(typeof n=="undefined"){n=u.board}if(arguments.callee.t1memo){r=arguments.callee.t1memo;q=arguments.callee.t2memo}else{r=h;q=l}w=u.X(r)-t.X(q);v=u.Y(r)-t.Y(q);s=w*w+v*v;B=u.board.D(u.X,u);z=t.board.D(t.X,t);k=u.board.D(u.Y,u);j=t.board.D(t.Y,t);while(s>JXG.Math.eps&&m<10){C=B(r);A=-z(q);y=k(r);x=-j(q);g=C*x-A*y;r-=(x*w-A*v)/g;q-=(C*v-y*w)/g;w=u.X(r)-t.X(q);v=u.Y(r)-t.Y(q);s=w*w+v*v;m++}arguments.callee.t1memo=r;arguments.callee.t2memo=q;if(Math.abs(r)<Math.abs(q)){return(new JXG.Coords(JXG.COORDS_BY_USER,[u.X(r),u.Y(r)],n))}else{return(new JXG.Coords(JXG.COORDS_BY_USER,[t.X(q),t.Y(q)],n))}};JXG.Math.Geometry.meetCurveLine=function(f,d,u,n){var x,j,h,k,w,e,r,g,s,v,q,m,l;if(typeof n=="undefined"){n=f.board}for(h=0;h<=1;h++){if(arguments[h].elementClass==JXG.OBJECT_CLASS_CURVE){k=arguments[h]}else{if(arguments[h].elementClass==JXG.OBJECT_CLASS_LINE){w=arguments[h]}else{throw new Error("JSXGraph: Can't call meetCurveLine with parent class "+(arguments[h].elementClass)+".")}}}e=function(y){return w.stdform[0]*1+w.stdform[1]*k.X(y)+w.stdform[2]*k.Y(y)};if(arguments.callee.t1memo){q=arguments.callee.t1memo}else{q=k.minX()}x=JXG.Math.Numerics.root(e,q);arguments.callee.t1memo=x;m=k.X(x);l=k.Y(x);if(u==1){if(arguments.callee.t2memo){q=arguments.callee.t2memo;j=JXG.Math.Numerics.root(e,q)}if(!(Math.abs(j-x)>0.1&&Math.abs(m-k.X(j))>0.1&&Math.abs(l-k.Y(j))>0.1)){s=20;v=(k.maxX()-k.minX())/s;g=k.minX();for(h=0;h<s;h++){j=JXG.Math.Numerics.root(e,g);if(Math.abs(j-x)>0.1&&Math.abs(m-k.X(j))>0.1&&Math.abs(l-k.Y(j))>0.1){break}g+=v}}x=j;arguments.callee.t2memo=x}if(Math.abs(e(x))>JXG.Math.eps){r=0}else{r=1}return(new JXG.Coords(JXG.COORDS_BY_USER,[r,k.X(x),k.Y(x)],n))};JXG.Math.Geometry.projectPointToCircle=function(m,d,f){var j=m.coords.distance(JXG.COORDS_BY_USER,d.midpoint.coords),e=m.coords.usrCoords,g=d.midpoint.coords.usrCoords,l,k,h;if(typeof f=="undefined"){f=m.board}if(Math.abs(j)<JXG.Math.eps){j=JXG.Math.eps}h=d.Radius()/j;l=g[1]+h*(e[1]-g[1]);k=g[2]+h*(e[2]-g[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[l,k],f)};JXG.Math.Geometry.projectPointToLine=function(d,e,g){var f=[0,e.stdform[1],e.stdform[2]];if(typeof g=="undefined"){g=d.board}f=JXG.Math.crossProduct(f,d.coords.usrCoords);return this.meetLineLine(f,e.stdform,0,g)};JXG.Math.Geometry.projectPointToCurve=function(f,j,h){if(typeof h=="undefined"){h=f.board}var e=f.X(),k=f.Y(),g=f.position||0,d=this.projectCoordsToCurve(e,k,g,j,h);f.position=d[1];return d[0]};JXG.Math.Geometry.projectCoordsToCurve=function(n,l,r,s,h){var D,B,e,A,d,k,w,C,u,g,v,q=1000000,m,G,E,f,F,z;if(typeof h=="undefined"){h=s.board}if(s.curveType=="parameter"||s.curveType=="polar"){m=function(y){var x=n-s.X(y),j=l-s.Y(y);return x*x+j*j};f=m(r);z=20;F=(s.maxX()-s.minX())/z;G=s.minX();for(v=0;v<z;v++){E=m(G);if(E<f){r=G;f=E}G+=F}r=JXG.Math.Numerics.root(JXG.Math.Numerics.D(m),r);if(r<s.minX()){r=s.maxX()+r-s.minX()}if(r>s.maxX()){r=s.minX()+r-s.maxX()}D=new JXG.Coords(JXG.COORDS_BY_USER,[s.X(r),s.Y(r)],h)}else{if(s.curveType=="plot"){C=q;for(w=0;w<s.numberPoints;w++){B=n-s.X(w);e=l-s.Y(w);u=Math.sqrt(B*B+e*e);if(u<C){C=u;r=w}if(w==s.numberPoints-1){continue}A=s.X(w+1)-s.X(w);d=s.Y(w+1)-s.Y(w);k=A*A+d*d;if(k>=JXG.Math.eps){g=(B*A+e*d)/k;u=Math.sqrt(B*B+e*e-g*(B*A+e*d))}else{g=0;u=Math.sqrt(B*B+e*e)}if(g>=0&&g<=1&&u<C){r=w+g;C=u}}w=Math.floor(r);g=r-w;if(w<s.numberPoints-1){n=g*s.X(w+1)+(1-g)*s.X(w);l=g*s.Y(w+1)+(1-g)*s.Y(w)}else{n=s.X(w);l=s.Y(w)}D=new JXG.Coords(JXG.COORDS_BY_USER,[n,l],h)}else{r=n;n=r;l=s.Y(r);D=new JXG.Coords(JXG.COORDS_BY_USER,[n,l],h)}}return[s.updateTransform(D),r]};JXG.Math.Geometry.projectPointToTurtle=function(q,u,k){var s,v,n,m,f,r=0,j=0,g=1000000,l,d,e,h=u.objects.length;if(typeof k=="undefined"){k=q.board}for(f=0;f<h;f++){d=u.objects[f];if(d.elementClass==JXG.OBJECT_CLASS_CURVE){s=this.projectPointToCurve(q,d);l=this.distance(s.usrCoords,q.coords.usrCoords);if(l<g){n=s.usrCoords[1];m=s.usrCoords[2];v=q.position;g=l;e=d;j=r}r+=d.numberPoints}}s=new JXG.Coords(JXG.COORDS_BY_USER,[n,m],k);q.position=v+j;return e.updateTransform(s)};JXG.Complex=function(d,e){this.isComplex=true;if(typeof d=="undefined"){d=0}if(typeof e=="undefined"){e=0}if(d.isComplex){e=d.imaginary;d=d.real}this.real=d;this.imaginary=e;this.absval=0;this.angle=0};JXG.Complex.prototype.toString=function(){return""+this.real+" + "+this.imaginary+"i"};JXG.Complex.prototype.add=function(d){if(typeof d=="number"){this.real+=d}else{this.real+=d.real;this.imaginary+=d.imaginary}};JXG.Complex.prototype.sub=function(d){if(typeof d=="number"){this.real-=d}else{this.real-=d.real;this.imaginary-=d.imaginary}};JXG.Complex.prototype.mult=function(d){if(typeof d=="number"){this.real*=d;this.imaginary*=d}else{this.real=this.real*d.real-this.imaginary*d.imaginary;this.imaginary=this.real*d.imaginary+this.imaginary*d.real}};JXG.Complex.prototype.div=function(e){var d;if(typeof e=="number"){if(Math.abs(e)<Math.eps){this.real=Infinity;this.imaginary=Infinity;return}this.real/=e;this.imaginary/=e}else{if((Math.abs(e.real)<Math.eps)&&(Math.abs(e.imaginary)<Math.eps)){this.real=Infinity;this.imaginary=Infinity;return}d=e.real*e.real+e.imaginary*e.imaginary;this.real=(this.real*e.real+this.imaginary*e.imaginary)/d;this.imaginary=(this.imaginary*e.real-this.real*e.imaginary)/d}};JXG.C={};JXG.C.add=function(e,d){var f=new JXG.Complex(e);f.add(d);return f};JXG.C.sub=function(e,d){var f=new JXG.Complex(e);f.sub(d);return f};JXG.C.mult=function(e,d){var f=new JXG.Complex(e);f.mult(d);return f};JXG.C.div=function(e,d){var f=new JXG.Complex(e);f.div(d);return f};JXG.AbstractRenderer=function(){this.vOffsetText=8;this.enhancedRendering=true};JXG.AbstractRenderer.prototype.drawPoint=function(d){var e,g=d.visProp.face;if(g=="cross"||g=="x"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}else{if(g=="circle"||g=="o"){e=this.createPrim("circle",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"circle")}else{if(g=="square"||g=="[]"){e=this.createPrim("rect",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"rect")}else{if(g=="plus"||g=="+"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}else{if(g=="diamond"||g=="<>"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}else{if(g=="triangleup"||g=="a"||g=="^"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}else{if(g=="triangledown"||g=="v"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}else{if(g=="triangleleft"||g=="<"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}else{if(g=="triangleright"||g==">"){e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")}}}}}}}}}this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity);this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity);this.updatePoint(d)};JXG.AbstractRenderer.prototype.updatePoint=function(e){var d=e.visProp.size,g=e.visProp.face;if(isNaN(e.coords.scrCoords[2])||isNaN(e.coords.scrCoords[1])){return}if(this.enhancedRendering){if(!e.visProp.draft){this.setObjectStrokeWidth(e,e.visProp.strokeWidth);this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setObjectFillColor(e,e.visProp.fillColor,e.visProp.fillOpacity)}else{this.setDraft(e)}}d*=((!e.board||!e.board.options.point.zoom)?1:Math.sqrt(e.board.zoomX*e.board.zoomY));if(g=="cross"||g=="x"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,"x"),e.board)}else{if(g=="circle"||g=="o"){this.updateCirclePrim(e.rendNode,e.coords.scrCoords[1],e.coords.scrCoords[2],d+1)}else{if(g=="square"||g=="[]"){this.updateRectPrim(e.rendNode,e.coords.scrCoords[1]-d,e.coords.scrCoords[2]-d,d*2,d*2)}else{if(g=="plus"||g=="+"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,"+"),e.board)}else{if(g=="diamond"||g=="<>"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,"diamond"),e.board)}else{if(g=="triangleup"||g=="a"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,"A"),e.board)}else{if(g=="triangledown"||g=="v"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,"v"),e.board)}else{if(g=="triangleleft"||g=="<"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,"<"),e.board)}else{if(g=="triangleright"||g==">"){this.updatePathPrim(e.rendNode,this.updatePathStringPoint(e,d,">"),e.board)}}}}}}}}}this.setShadow(e)};JXG.AbstractRenderer.prototype.changePointStyle=function(d){var e=this.getElementById(d.id);if(e!=null){this.remove(e)}this.drawPoint(d);JXG.clearVisPropOld(d);if(!d.visProp.visible){this.hide(d)}if(d.visProp.draft){this.setDraft(d)}};JXG.AbstractRenderer.prototype.drawLine=function(d){var e=this.createPrim("line",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"lines");this.updateLine(d)};JXG.AbstractRenderer.prototype.updateLine=function(e){var r=new JXG.Coords(JXG.COORDS_BY_USER,e.point1.coords.usrCoords,e.board),q=new JXG.Coords(JXG.COORDS_BY_USER,e.point2.coords.usrCoords,e.board),d,s,j,h,n,g,l,k,f;this.calcStraight(e,r,q);this.updateLinePrim(e.rendNode,r.scrCoords[1],r.scrCoords[2],q.scrCoords[1],q.scrCoords[2],e.board);if(e.image!=null){d=r.scrCoords[1];s=r.scrCoords[2];j=q.scrCoords[1];h=q.scrCoords[2];n=Math.atan2(h-s,j-d);l=250;k=256;f=[[1,0,0],[l*(1-Math.cos(n))+k*Math.sin(n),Math.cos(n),-Math.sin(n)],[k*(1-Math.cos(n))-l*Math.sin(n),Math.sin(n),Math.cos(n)]];e.imageTransformMatrix=f}this.makeArrows(e);if(this.enhancedRendering){if(!e.visProp.draft){this.setObjectStrokeWidth(e,e.visProp.strokeWidth);this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setDashStyle(e,e.visProp);this.setShadow(e)}else{this.setDraft(e)}}};JXG.AbstractRenderer.prototype.calcStraight=function(g,r,q){var e,d,m,k,t,f,n,w,l,h,v,u;t=g.visProp.straightFirst;f=g.visProp.straightLast;if(Math.abs(r.scrCoords[0])<JXG.Math.eps){t=true}if(Math.abs(q.scrCoords[0])<JXG.Math.eps){f=true}if(!t&&!f){return}n=[];n[0]=g.stdform[0]-g.stdform[1]*g.board.origin.scrCoords[1]/g.board.stretchX+g.stdform[2]*g.board.origin.scrCoords[2]/g.board.stretchY;n[1]=g.stdform[1]/g.board.stretchX;n[2]=g.stdform[2]/(-g.board.stretchY);if(isNaN(n[0]+n[1]+n[2])){return}w=[];w[0]=JXG.Math.crossProduct(n,[0,0,1]);w[1]=JXG.Math.crossProduct(n,[0,1,0]);w[2]=JXG.Math.crossProduct(n,[-g.board.canvasHeight,0,1]);w[3]=JXG.Math.crossProduct(n,[-g.board.canvasWidth,1,0]);for(l=0;l<4;l++){if(Math.abs(w[l][0])>JXG.Math.eps){for(h=2;h>0;h--){w[l][h]/=w[l][0]}w[l][0]=1}}e=false;d=false;if(!t&&r.scrCoords[1]>=0&&r.scrCoords[1]<=g.board.canvasWidth&&r.scrCoords[2]>=0&&r.scrCoords[2]<=g.board.canvasHeight){e=true}if(!f&&q.scrCoords[1]>=0&&q.scrCoords[1]<=g.board.canvasWidth&&q.scrCoords[2]>=0&&q.scrCoords[2]<=g.board.canvasHeight){d=true}if(Math.abs(w[1][0])<JXG.Math.eps){m=w[0];k=w[2]}else{if(Math.abs(w[0][0])<JXG.Math.eps){m=w[1];k=w[3]}else{if(w[1][2]<0){m=w[0];if(w[3][2]>g.board.canvasHeight){k=w[2]}else{k=w[3]}}else{if(w[1][2]>g.board.canvasHeight){m=w[2];if(w[3][2]<0){k=w[0]}else{k=w[3]}}else{m=w[1];if(w[3][2]<0){k=w[0]}else{if(w[3][2]>g.board.canvasHeight){k=w[2]}else{k=w[3]}}}}}}m=new JXG.Coords(JXG.COORDS_BY_SCREEN,m.slice(1),g.board);k=new JXG.Coords(JXG.COORDS_BY_SCREEN,k.slice(1),g.board);if(!e&&!d){if(!t&&f&&!this.isSameDirection(r,q,m)&&!this.isSameDirection(r,q,k)){return}else{if(t&&!f&&!this.isSameDirection(q,r,m)&&!this.isSameDirection(q,r,k)){return}}}if(!e){if(!d){if(this.isSameDirection(r,q,m)){if(!this.isSameDirection(r,q,k)){u=m;v=k}else{if(JXG.Math.Geometry.affineDistance(q.usrCoords,m.usrCoords)<JXG.Math.Geometry.affineDistance(q.usrCoords,k.usrCoords)){v=m;u=k}else{u=m;v=k}}}else{if(this.isSameDirection(r,q,k)){v=m;u=k}else{if(JXG.Math.Geometry.affineDistance(q.usrCoords,m.usrCoords)<JXG.Math.Geometry.affineDistance(q.usrCoords,k.usrCoords)){u=m;v=k}else{v=m;u=k}}}}else{if(this.isSameDirection(q,r,m)){v=m}else{v=k}}}else{if(!d){if(this.isSameDirection(r,q,m)){u=m}else{u=k}}}if(v){r.setCoordinates(JXG.COORDS_BY_USER,v.usrCoords.slice(1))}if(u){q.setCoordinates(JXG.COORDS_BY_USER,u.usrCoords.slice(1))}};JXG.AbstractRenderer.prototype.isSameDirection=function(k,g,f){var e,d,j,h;e=g.usrCoords[1]-k.usrCoords[1];d=g.usrCoords[2]-k.usrCoords[2];j=f.usrCoords[1]-k.usrCoords[1];h=f.usrCoords[2]-k.usrCoords[2];if(Math.abs(e)<JXG.Math.eps){e=0}if(Math.abs(d)<JXG.Math.eps){d=0}if(Math.abs(j)<JXG.Math.eps){j=0}if(Math.abs(h)<JXG.Math.eps){h=0}if(e>=0&&j>=0){if((d>=0&&h>=0)||(d<=0&&h<=0)){return true}}else{if(e<=0&&j<=0){if((d>=0&&h>=0)||(d<=0&&h<=0)){return true}}}return false};JXG.AbstractRenderer.prototype.updateTicks=function(e,g,d,h,f){};JXG.AbstractRenderer.prototype.removeTicks=function(d){var e=this.getElementById(d.id+"_ticks");this.remove(e)};JXG.AbstractRenderer.prototype.drawCurve=function(d){var e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path");this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity);this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity);this.setDashStyle(d,d.visProp);this.updateCurve(d)};JXG.AbstractRenderer.prototype.updateCurve=function(d){if(this.enhancedRendering){if(!d.visProp.draft){this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity);this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity);this.setDashStyle(d,d.visProp);this.setShadow(d)}else{this.setDraft(d)}}this.updatePathPrim(d.rendNode,this.updatePathStringPrim(d),d.board);this.makeArrows(d)};JXG.AbstractRenderer.prototype.drawCircle=function(d){var e=this.createPrim("ellipse",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"ellipse");this.updateCircle(d)};JXG.AbstractRenderer.prototype.updateCircle=function(e){if(this.enhancedRendering){if(!e.visProp.draft){this.setObjectStrokeWidth(e,e.visProp.strokeWidth);this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setObjectFillColor(e,e.visProp.fillColor,e.visProp.fillOpacity);this.setDashStyle(e,e.visProp);this.setShadow(e)}else{this.setDraft(e)}}var d=e.Radius();if(d>0&&!isNaN(e.midpoint.coords.scrCoords[1]+e.midpoint.coords.scrCoords[2])){this.updateEllipsePrim(e.rendNode,e.midpoint.coords.scrCoords[1],e.midpoint.coords.scrCoords[2],(d*e.board.stretchX),(d*e.board.stretchY))}};JXG.AbstractRenderer.prototype.drawPolygon=function(d){var e=this.createPrim("polygon",d.id);if(d.visProp.fillOpacity==JXG.undefined){d.visProp.fillOpacity=0.3}this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"polygon");this.updatePolygon(d)};JXG.AbstractRenderer.prototype.updatePolygon=function(d){if(this.enhancedRendering){if(!d.visProp.draft){this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity);this.setShadow(d)}else{this.setDraft(d)}}this.updatePolygonePrim(d.rendNode,d)};JXG.AbstractRenderer.prototype.drawText=function(d){var e;if(d.display=="html"){e=this.container.ownerDocument.createElement("div");e.style.position="absolute";e.style.color=d.visProp.strokeColor;e.className="JXGtext";e.style.zIndex="10";this.container.appendChild(e);e.setAttribute("id",this.container.id+"_"+d.id)}else{e=this.drawInternalText(d)}e.style.fontSize=d.board.options.text.fontSize+"px";d.rendNode=e;d.htmlStr="";this.updateText(d)};JXG.AbstractRenderer.prototype.drawInternalText=function(d){};JXG.AbstractRenderer.prototype.updateText=function(d){if(d.visProp.visible==false){return}if(isNaN(d.coords.scrCoords[1]+d.coords.scrCoords[2])){return}this.updateTextStyle(d);if(d.display=="html"){d.rendNode.style.left=(d.coords.scrCoords[1])+"px";d.rendNode.style.top=(d.coords.scrCoords[2]-this.vOffsetText)+"px";d.updateText();if(d.htmlStr!=d.plaintextStr){d.rendNode.innerHTML=d.plaintextStr;if(d.board.options.text.useASCIIMathML){AMprocessNode(d.rendNode,false)}d.htmlStr=d.plaintextStr}}else{this.updateInternalText(d)}};JXG.AbstractRenderer.prototype.updateInternalText=function(d){};JXG.AbstractRenderer.prototype.updateTextStyle=function(e){var d;if(e.visProp.fontSize){if(typeof e.visProp.fontSize=="function"){d=e.visProp.fontSize();e.rendNode.style.fontSize=(d>0?d:0)}else{e.rendNode.style.fontSize=(e.visProp.fontSize)}}};JXG.AbstractRenderer.prototype.drawImage=function(d){};JXG.AbstractRenderer.prototype.updateImageURL=function(d){};JXG.AbstractRenderer.prototype.updateImage=function(d){this.updateRectPrim(d.rendNode,d.coords.scrCoords[1],d.coords.scrCoords[2]-d.size[1],d.size[0],d.size[1]);this.updateImageURL(d);if(d.parent!=null){this.transformImageParent(d,d.parent.imageTransformMatrix)}else{this.transformImageParent(d)}this.transformImage(d,d.transformations)};JXG.AbstractRenderer.prototype.drawGrid=function(h){var z=h.gridX,x=h.gridY,v=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],h),m=new JXG.Coords(JXG.COORDS_BY_SCREEN,[h.canvasWidth,h.canvasHeight],h),A=Math.ceil(v.usrCoords[1]),w=0,y,d,t,u,r,q,s,n,e,f,g;h.hasGrid=true;for(y=0;y<=z+1;y++){if(A-y/z<v.usrCoords[1]){w=y-1;break}}A=Math.floor(m.usrCoords[1]);d=0;for(y=0;y<=z+1;y++){if(A+y/z>m.usrCoords[1]){d=y-1;break}}A=Math.ceil(m.usrCoords[2]);u=0;for(y=0;y<=x+1;y++){if(A-y/x<m.usrCoords[2]){u=y-1;break}}A=Math.floor(v.usrCoords[2]);t=0;for(y=0;y<=x+1;y++){if(A+y/x>v.usrCoords[2]){t=y-1;break}}r=Math.round((1/z)*h.stretchX);q=Math.round((1/x)*h.stretchY);s=new JXG.Coords(JXG.COORDS_BY_USER,[Math.ceil(v.usrCoords[1])-w/z,Math.floor(v.usrCoords[2])+t/x],h);n=new JXG.Coords(JXG.COORDS_BY_USER,[Math.floor(m.usrCoords[1])+d/z,Math.ceil(m.usrCoords[2])-u/x],h);e=this.drawVerticalGrid(s,n,r,h);this.appendChildPrim(e,h.options.layer.grid);if(!h.snapToGrid){f=new Object();f.visProp={};f.rendNode=e;f.elementClass=JXG.OBJECT_CLASS_LINE;f.id="gridx";JXG.clearVisPropOld(f);this.setObjectStrokeColor(f,h.gridColor,h.gridOpacity)}else{f=new Object();f.visProp={};f.rendNode=e;f.elementClass=JXG.OBJECT_CLASS_LINE;f.id="gridx";JXG.clearVisPropOld(f);this.setObjectStrokeColor(f,"#FF8080",0.5)}this.setPropertyPrim(e,"stroke-width","0.4px");if(h.gridDash){this.setGridDash("gridx")}e=this.drawHorizontalGrid(s,n,q,h);this.appendChildPrim(e,h.options.layer.grid);if(!h.snapToGrid){f=new Object();f.visProp={};f.rendNode=e;f.elementClass=JXG.OBJECT_CLASS_LINE;f.id="gridy";JXG.clearVisPropOld(f);this.setObjectStrokeColor(f,h.gridColor,h.gridOpacity)}else{f=new Object();f.visProp={};f.rendNode=e;f.elementClass=JXG.OBJECT_CLASS_LINE;f.id="gridy";JXG.clearVisPropOld(f);this.setObjectStrokeColor(f,"#FF8080",0.5)}this.setPropertyPrim(e,"stroke-width","0.4px");if(h.gridDash){this.setGridDash("gridy")}};JXG.AbstractRenderer.prototype.removeGrid=function(d){var e=this.getElementById("gridx");this.remove(e);e=this.getElementById("gridy");this.remove(e);d.hasGrid=false};JXG.AbstractRenderer.prototype.hide=function(d){};JXG.AbstractRenderer.prototype.show=function(d){};JXG.AbstractRenderer.prototype.setObjectStrokeWidth=function(e,d){};JXG.AbstractRenderer.prototype.setObjectStrokeColor=function(f,d,e){};JXG.AbstractRenderer.prototype.setObjectFillColor=function(f,d,e){};JXG.AbstractRenderer.prototype.setDraft=function(e){if(!e.visProp.draft){return}var d=e.board.options.elements.draft.color,f=e.board.options.elements.draft.opacity;if(e.type==JXG.OBJECTT_TYPE_POLYGON){this.setObjectFillColor(e,d,f)}else{if(e.elementClass==JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(e,d,f)}else{this.setObjectFillColor(e,"none",0)}this.setObjectStrokeColor(e,d,f);this.setObjectStrokeWidth(e,e.board.options.elements.draft.strokeWidth)}};JXG.AbstractRenderer.prototype.removeDraft=function(d){if(d.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillColorOpacity)}else{if(d.type==JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillColorOpacity)}this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeColorOpacity);this.setObjectStrokeWidth(d,d.visProp.strokeWidth)}};JXG.AbstractRenderer.prototype.highlight=function(e){var d;if(e.visProp.draft==false){if(e.type==JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(e,e.visProp.highlightStrokeColor,e.visProp.highlightStrokeOpacity);this.setObjectFillColor(e,e.visProp.highlightStrokeColor,e.visProp.highlightStrokeOpacity)}else{if(e.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(e,e.visProp.highlightFillColor,e.visProp.highlightFillOpacity);for(d=0;d<e.borders.length;d++){this.setObjectStrokeColor(e.borders[d],e.borders[d].visProp.highlightStrokeColor,e.visProp.highlightStrokeOpacity)}}else{this.setObjectStrokeColor(e,e.visProp.highlightStrokeColor,e.visProp.highlightStrokeOpacity);this.setObjectFillColor(e,e.visProp.highlightFillColor,e.visProp.highlightFillOpacity)}}if(e.visProp.highlightStrokeWidth){this.setObjectStrokeWidth(e,e.visProp.highlightStrokeWidth)}}};JXG.AbstractRenderer.prototype.noHighlight=function(e){var d;if(e.visProp.draft==false){if(e.type==JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setObjectFillColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity)}else{if(e.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(e,e.visProp.fillColor,e.visProp.fillOpacity);for(d=0;d<e.borders.length;d++){this.setObjectStrokeColor(e.borders[d],e.borders[d].visProp.strokeColor,e.visProp.strokeOpacity)}}else{this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setObjectFillColor(e,e.visProp.fillColor,e.visProp.fillOpacity)}}this.setObjectStrokeWidth(e,e.visProp.strokeWidth)}};JXG.AbstractRenderer.prototype.remove=function(d){};JXG.AbstractRenderer.prototype.suspendRedraw=function(){};JXG.AbstractRenderer.prototype.unsuspendRedraw=function(){};JXG.AbstractRenderer.prototype.drawZoomBar=function(k){var m,f,j,h,e,n,l,d,g;m=this.container.ownerDocument;f=m.createElement("div");f.className="JXGtext";f.style.color="#aaaaaa";f.style.backgroundColor="#f5f5f5";f.style.padding="2px";f.style.position="absolute";f.style.fontSize="10px";f.style.cursor="pointer";f.style.zIndex="100";this.container.appendChild(f);f.style.right="5px";f.style.bottom="5px";j=m.createElement("span");f.appendChild(j);j.innerHTML="&nbsp;&ndash;&nbsp;";JXG.addEvent(j,"click",k.zoomOut,k);h=m.createElement("span");f.appendChild(h);h.innerHTML="&nbsp;o&nbsp;";JXG.addEvent(h,"click",k.zoom100,k);e=m.createElement("span");f.appendChild(e);e.innerHTML="&nbsp;+&nbsp;";JXG.addEvent(e,"click",k.zoomIn,k);n=m.createElement("span");f.appendChild(n);n.innerHTML="&nbsp;&larr;&nbsp;";JXG.addEvent(n,"click",k.clickLeftArrow,k);l=m.createElement("span");f.appendChild(l);l.innerHTML="&nbsp;&uarr;&nbsp;";JXG.addEvent(l,"click",k.clickUpArrow,k);d=m.createElement("span");f.appendChild(d);d.innerHTML="&nbsp;&darr;&nbsp;";JXG.addEvent(d,"click",k.clickDownArrow,k);g=m.createElement("span");f.appendChild(g);g.innerHTML="&nbsp;&rarr;&nbsp;";JXG.addEvent(g,"click",k.clickRightArrow,k)};JXG.AbstractRenderer.prototype.getElementById=function(d){return document.getElementById(this.container.id+"_"+d)};JXG.AbstractRenderer.prototype.findSplit=function(y,n,m){var s=0,q=n,r,l,z,x,w,h,v,g,t,u,e;if(m-n<2){return[-1,0]}z=y[n].scrCoords;x=y[m].scrCoords;if(isNaN(z[1]+z[2]+x[1]+x[2])){return[NaN,m]}for(l=n+1;l<m;l++){w=y[l].scrCoords;h=w[1]-z[1];v=w[2]-z[2];g=x[1]-z[1];t=x[2]-z[2];u=g*g+t*t;if(u>=JXG.Math.eps){e=(h*g+v*t)/u;r=h*h+v*v-e*(h*g+v*t)}else{e=0;r=h*h+v*v}if(e<0){r=h*h+v*v}else{if(e>1){h=w[1]-x[1];v=w[2]-x[2];r=h*h+v*v}}if(r>s){s=r;q=l}}return[Math.sqrt(s),q]};JXG.AbstractRenderer.prototype.RDP=function(k,h,g,e,f){var d=this.findSplit(k,h,g);if(d[0]>e){this.RDP(k,h,d[1],e,f);this.RDP(k,d[1],g,e,f)}else{f.push(k[g])}};JXG.AbstractRenderer.prototype.RamenDouglasPeuker=function(j,e){var g=[],h,f,d;d=j.length;h=0;while(h<d&&isNaN(j[h].scrCoords[1]+j[h].scrCoords[2])){h++}f=d-1;while(f>h&&isNaN(j[f].scrCoords[1]+j[f].scrCoords[2])){f--}if(h>f||h==d){return[]}g[0]=j[h];this.RDP(j,h,f,e,g);return g};JXG.AbstractRenderer.prototype.setShadow=function(d){};JXG.AbstractRenderer.prototype.updatePathStringPoint=function(f,d,e){};JXG.AbstractRenderer.prototype.eval=function(d){if(typeof d=="function"){return d()}else{return d}};JXG.FileReader=new function(){this.parseFileContent=function(d,f,h){this.request=false;var g;try{this.request=new XMLHttpRequest();if(h.toLowerCase()=="raw"){this.request.overrideMimeType("text/plain; charset=iso-8859-1")}else{this.request.overrideMimeType("text/xml; charset=iso-8859-1")}}catch(g){try{this.request=new ActiveXObject("Msxml2.XMLHTTP")}catch(g){try{this.request=new ActiveXObject("Microsoft.XMLHTTP")}catch(g){this.request=false}}}if(!this.request){alert("AJAX not activated!");return}this.request.open("GET",d,true);if(h.toLowerCase()=="raw"){this.cbp=function(){var e=this.request;if(e.readyState==4){f(e.responseText)}}}else{this.cbp=function(){var e=this.request;if(e.readyState==4){var j="";if(typeof e.responseStream!="undefined"&&(e.responseText.slice(0,2)=="PK"||JXG.Util.asciiCharCodeAt(e.responseText.slice(0,1),0)==31)){j=JXG.Util.Base64.decode(BinFileReader(e))}else{j=e.responseText}this.parseString(j,f,h,false)}}}this.cb=JXG.bind(this.cbp,this);this.request.onreadystatechange=this.cb;try{this.request.send(null)}catch(g){throw new Error("JSXGraph: problems opening "+d+" !")}};this.cleanWhitespace=function(d){var e=d.firstChild;while(e!=null){if(e.nodeType==3&&!/\S/.test(e.nodeValue)){d.removeChild(e)}else{if(e.nodeType==1){this.cleanWhitespace(e)}}e=e.nextSibling}};this.stringToXMLTree=function(e){if(typeof DOMParser=="undefined"){DOMParser=function(){};DOMParser.prototype.parseFromString=function(h,j){if(typeof ActiveXObject!="undefined"){var g=new ActiveXObject("MSXML.DomDocument");g.loadXML(h);return g}}}var f=new DOMParser();var d=f.parseFromString(e,"text/xml");this.cleanWhitespace(d);return d};this.parseString=function(h,f,j,e){var d,g;if(j.toLowerCase()=="cdy"||j.toLowerCase()=="cinderella"){if(e){h=JXG.Util.Base64.decode(h)}h=JXG.CinderellaReader.readCinderella(h,f);f.xmlString=h;f.afterLoad();return}if(j.toLowerCase()=="graph"){h=JXG.GraphReader.readGraph(h,f,false);f.afterLoad();return}if(j.toLowerCase()=="digraph"){h=JXG.GraphReader.readGraph(h,f,true);f.afterLoad();return}if(j.toLowerCase()=="geonext"){h=JXG.GeonextReader.prepareString(h)}if(j.toLowerCase()=="geogebra"){e=true;if(h.slice(0,2)==="PK"){e=false}h=JXG.GeogebraReader.prepareString(h,e)}if(j.toLowerCase()=="intergeo"){if(e){h=JXG.Util.Base64.decode(h)}h=JXG.IntergeoReader.prepareString(h)}f.xmlString=h;d=this.stringToXMLTree(h);this.readElements(d,f,j)};this.readElements=function(d,e,f){if(f.toLowerCase()=="geonext"){e.suspendUpdate();if(d.getElementsByTagName("GEONEXT").length!=0){JXG.GeonextReader.readGeonext(d,e)}e.unsuspendUpdate()}else{if(d.getElementsByTagName("geogebra").length!=0){JXG.GeogebraReader.readGeogebra(d,e)}else{if(f.toLowerCase()=="intergeo"){JXG.IntergeoReader.readIntergeo(d,e)}}}e.afterLoad()}};if(/msie/i.test(navigator.userAgent)&&!/opera/i.test(navigator.userAgent)){document.write('<script type="text/vbscript">\nFunction Base64Encode(inData)\n  Const Base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"\n  Dim cOut, sOut, I\n  For I = 1 To LenB(inData) Step 3\n    Dim nGroup, pOut, sGroup\n    nGroup = &H10000 * AscB(MidB(inData, I, 1)) + _\n      &H100 * MyASC(MidB(inData, I + 1, 1)) + MyASC(MidB(inData, I + 2, 1))\n    nGroup = Oct(nGroup)\n    nGroup = String(8 - Len(nGroup), "0") & nGroup\n    pOut = Mid(Base64, CLng("&o" & Mid(nGroup, 1, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 3, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 5, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 7, 2)) + 1, 1)\n    sOut = sOut + pOut\n  Next\n  Select Case LenB(inData) Mod 3\n    Case 1: \'8 bit final\n      sOut = Left(sOut, Len(sOut) - 2) + "=="\n    Case 2: \'16 bit final\n      sOut = Left(sOut, Len(sOut) - 1) + "="\n  End Select\n  Base64Encode = sOut\nEnd Function\n\nFunction MyASC(OneChar)\n  If OneChar = "" Then MyASC = 0 Else MyASC = AscB(OneChar)\nEnd Function\n\nFunction BinFileReader(xhr)\n    Dim byteString\n    Dim b64String\n    Dim i\n    byteString = xhr.responseBody\n    ReDim byteArray(LenB(byteString))\n    For i = 1 To LenB(byteString)\n        byteArray(i-1) = AscB(MidB(byteString, i, 1))\n    Next\n    b64String = Base64Encode(byteString)\n    BinFileReader = b64String\nEnd Function\n<\/script>\n')}JXG.GeonextParser={};JXG.GeonextParser.replacePow=function(f){var k,n,l,j,m,g,d,e,h,r,q;f=f.replace(/(\s*)\^(\s*)/g,"^");h=f.indexOf("^");while(h>=0){e=f.slice(0,h);if(e.charAt(e.length-1)==")"){k=1;n=e.length-2;while(n>=0&&k>0){l=e.charAt(n);if(l==")"){k++}else{if(l=="("){k--}}n--}if(k==0){j="";g=e.substring(0,n+1);d=n;while(d>=0&&g.substr(d,1).match(/(\w+)/)){j=RegExp.$1+j;d--}j+=e.substring(n+1,e.length);j=j.replace(/([\(\)\+\*\%\^\-\/\]\[])/g,"\\$1")}}else{j="[\\w\\.\\(\\)\\+\\*\\%\\^\\-\\/\\[\\]]+"}r=f.slice(h+1);if(r.match(/^([\w\.]*\()/)){k=1;n=RegExp.$1.length;while(n<r.length&&k>0){l=r.charAt(n);if(l==")"){k--}else{if(l=="("){k++}}n++}if(k==0){m=r.substring(0,n);m=m.replace(/([\(\)\+\*\%\^\-\/\[\]])/g,"\\$1")}}else{m="[\\w\\.\\(\\)\\+\\*\\%\\^\\-\\/\\[\\]]+"}q=new RegExp("("+j+")\\^("+m+")");f=f.replace(q,"JXG.Math.pow($1,$2)");h=f.indexOf("^")}return f};JXG.GeonextParser.replaceIf=function(e){var u="",f,t,h=null,d=null,l=null,g,r,j,m,k,n,q;g=e.indexOf("If(");if(g<0){return e}e=e.replace(/""/g,"0");while(g>=0){f=e.slice(0,g);t=e.slice(g+3);j=1;r=0;m=-1;k=-1;while(r<t.length&&j>0){n=t.charAt(r);if(n==")"){j--}else{if(n=="("){j++}else{if(n==","&&j==1){if(m<0){m=r}else{k=r}}}}r++}q=t.slice(0,r-1);t=t.slice(r);if(m<0){return""}if(k<0){return""}h=q.slice(0,m);d=q.slice(m+1,k);l=q.slice(k+1);h=this.replaceIf(h);d=this.replaceIf(d);l=this.replaceIf(l);u+=f+"(("+h+")?("+d+"):("+l+"))";e=t;h=null;d=null;g=e.indexOf("If(")}u+=t;return u};JXG.GeonextParser.replaceSub=function(f){if(f.indexOf){}else{return f}var e=f.indexOf("_{"),d;while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/_\{/,"<sub>");d=f.substr(e).indexOf("}");if(d>=0){f=f.substr(0,d)+f.substr(d).replace(/\}/,"</sub>")}e=f.indexOf("_{")}e=f.indexOf("_");while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/_(.?)/,"<sub>$1</sub>");e=f.indexOf("_")}return f};JXG.GeonextParser.replaceSup=function(f){if(f.indexOf){}else{return f}var e=f.indexOf("^{"),d;while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/\^\{/,"<sup>");d=f.substr(e).indexOf("}");if(d>=0){f=f.substr(0,d)+f.substr(d).replace(/\}/,"</sup>")}e=f.indexOf("^{")}e=f.indexOf("^");while(e>=0){f=f.substr(0,e)+f.substr(e).replace(/\^(.?)/,"<sup>$1</sup>");e=f.indexOf("^")}return f};JXG.GeonextParser.replaceNameById=function(g,j){var l=0,d,k,h,f,e=["X","Y","L","V"];for(f=0;f<e.length;f++){l=g.indexOf(e[f]+"(");while(l>=0){if(l>=0){d=g.indexOf(")",l+2);if(d>=0){k=g.slice(l+2,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+2)+h.id+g.slice(d)}}d=g.indexOf(")",l+2);l=g.indexOf(e[f]+"(",d)}}l=g.indexOf("Dist(");while(l>=0){if(l>=0){d=g.indexOf(",",l+5);if(d>=0){k=g.slice(l+5,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+5)+h.id+g.slice(d)}}d=g.indexOf(",",l+5);l=g.indexOf(",",d);d=g.indexOf(")",l+1);if(d>=0){k=g.slice(l+1,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+1)+h.id+g.slice(d)}d=g.indexOf(")",l+1);l=g.indexOf("Dist(",d)}e=["Deg","Rad"];for(f=0;f<e.length;f++){l=g.indexOf(e[f]+"(");while(l>=0){if(l>=0){d=g.indexOf(",",l+4);if(d>=0){k=g.slice(l+4,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+4)+h.id+g.slice(d)}}d=g.indexOf(",",l+4);l=g.indexOf(",",d);d=g.indexOf(",",l+1);if(d>=0){k=g.slice(l+1,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+1)+h.id+g.slice(d)}d=g.indexOf(",",l+1);l=g.indexOf(",",d);d=g.indexOf(")",l+1);if(d>=0){k=g.slice(l+1,d);k=k.replace(/\\(['"])?/g,"$1");h=j.elementsByName[k];g=g.slice(0,l+1)+h.id+g.slice(d)}d=g.indexOf(")",l+1);l=g.indexOf(e[f]+"(",d)}}return g};JXG.GeonextParser.replaceIdByObj=function(d){var e=/(X|Y|L)\(([\w_]+)\)/g;d=d.replace(e,'this.board.objects["$2"].$1()');e=/(V)\(([\w_]+)\)/g;d=d.replace(e,'this.board.objects["$2"].Value()');e=/(Dist)\(([\w_]+),([\w_]+)\)/g;d=d.replace(e,'this.board.objects["$2"].Dist(this.board.objects["$3"])');e=/(Deg)\(([\w_]+),([ \w\[\w_]+),([\w_]+)\)/g;d=d.replace(e,'JXG.Math.Geometry.trueAngle(this.board.objects["$2"],this.board.objects["$3"],this.board.objects["$4"])');e=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g;d=d.replace(e,'JXG.Math.Geometry.rad(this.board.objects["$1"],this.board.objects["$2"],this.board.objects["$3"])');return d};JXG.GeonextParser.geonext2JS=function(e,g){var h,f,d,k=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Floor","Log","Max","Min","Random","Round","Sin","Sqrt","Tan","Trunc"],j=["Math.abs","Math.acos","Math.asin","Math.atan","Math.ceil","Math.cos","Math.exp","Math.floor","Math.log","Math.max","Math.min","Math.random","this.board.round","Math.sin","Math.sqrt","Math.tan","Math.ceil"];e=e.replace(/&lt;/g,"<");e=e.replace(/&gt;/g,">");e=e.replace(/&amp;/g,"&");f=e;f=this.replaceNameById(f,g);f=this.replaceIf(f);f=this.replacePow(f);f=this.replaceIdByObj(f);for(d=0;d<k.length;d++){h=new RegExp(k[d],"ig");f=f.replace(h,j[d])}f=f.replace(/True/g,"true");f=f.replace(/False/g,"false");f=f.replace(/fasle/g,"false");f=f.replace(/Pi/g,"Math.PI");return f};JXG.GeonextParser.findDependencies=function(h,e,g){if(typeof g=="undefined"){g=h.board}var j=g.elementsByName,f,k,d;for(f in j){if(f!=h.name){if(j[f].type==JXG.OBJECT_TYPE_TEXT){if(!j[f].isLabel){d=f.replace(/\[/g,"\\[");d=d.replace(/\]/g,"\\]");k=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+d+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(e.search(k)>=0){j[f].addChild(h)}}}else{d=f.replace(/\[/g,"\\[");d=d.replace(/\]/g,"\\]");k=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+d+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(e.search(k)>=0){j[f].addChild(h)}}}}};JXG.Board=function(d,j,e,q,n,m,l,k,f,g,h){this.BOARD_MODE_NONE=0;this.BOARD_MODE_DRAG=1;this.BOARD_MODE_CONSTRUCT=16;this.BOARD_MODE_MOVE_ORIGIN=2;this.BOARD_QUALITY_LOW=1;this.BOARD_QUALITY_HIGH=2;this.CONSTRUCTION_TYPE_POINT=1129599060;this.CONSTRUCTION_TYPE_CIRCLE=1129595724;this.CONSTRUCTION_TYPE_LINE=1129598030;this.CONSTRUCTION_TYPE_GLIDER=1129596740;this.CONSTRUCTION_TYPE_MIDPOINT=1129598288;this.CONSTRUCTION_TYPE_PERPENDICULAR=1129599044;this.CONSTRUCTION_TYPE_PARALLEL=1129599052;this.CONSTRUCTION_TYPE_INTERSECTION=1129597267;this.container=d;this.containerObj=document.getElementById(this.container);if(this.containerObj==null){throw new Error("\nJSXGraph: HTML container element '"+(d)+"' not found.")}this.renderer=j;this.options=JXG.deepCopy(JXG.Options);this.dimension=2;this.origin={};this.origin.usrCoords=[1,0,0];this.origin.scrCoords=[1,q[0],q[1]];this.zoomX=n;this.zoomY=m;this.unitX=l;this.unitY=k;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.canvasWidth=f;this.canvasHeight=g;this.fontSize=this.options.text.fontSize;if((e!="")&&(e!=null)&&(typeof document.getElementById(e)!="undefined")){this.id=e}else{this.id=this.generateId()}this.hooks=[];this.dependentBoards=[];this.objects={};this.animationObjects={};this.highlightedObjects={};this.numObjects=0;this.elementsByName={};this.mode=this.BOARD_MODE_NONE;this.updateQuality=this.BOARD_QUALITY_HIGH;this.isSuspendedRedraw=false;this.snapToGrid=this.options.grid.snapToGrid;this.gridX=this.options.grid.gridX;this.gridY=this.options.grid.gridY;this.gridColor=this.options.grid.gridColor;this.gridOpacity=this.options.grid.gridOpacity;this.gridDash=this.options.grid.gridDash;this.snapSizeX=this.options.grid.snapSizeX;this.snapSizeY=this.options.grid.snapSizeY;this.calculateSnapSizes();this.hasGrid=this.options.grid.hasGrid;this.drag_dx=0;this.drag_dy=0;this.mousePosAbs=[0,0];this.mousePosRel=[0,0];this.drag_obj=[];this.last_click={time:0,posX:0,posY:0};this.xmlString="";this.showCopyright=false;if((h!=null&&h)||(h==null&&this.options.showCopyright)){this.renderer.displayCopyright(JXG.JSXGraph.licenseText,this.fontSize);this.showCopyright=true}this.needsFullUpdate=false;this.reducedUpdate=false;this.currentCBDef="none";this.geonextCompatibilityMode=false;if(this.options.text.useASCIIMathML){if(typeof translateASCIIMath!="undefined"){init()}else{this.options.text.useASCIIMathML=false}}JXG.addEvent(document,"mousedown",this.mouseDownListener,this);JXG.addEvent(this.containerObj,"mousemove",this.mouseMoveListener,this);JXG.addEvent(this.containerObj,"touchstart",this.touchStartListener,this);JXG.addEvent(this.containerObj,"touchmove",this.touchMoveListener,this);JXG.addEvent(this.containerObj,"touchend",this.touchEndListener,this);this.containerObj.oncontextmenu=function(r){if(r!==JXG.undefined){r.preventDefault()}return false}};JXG.Board.prototype.generateName=function(f){if(f.type==JXG.OBJECT_TYPE_TICKS){return""}var m;if(f.elementClass==JXG.OBJECT_CLASS_POINT){m=["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]}else{m=["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]}var h=3;var e="";var q="";var n="";if(f.elementClass==JXG.OBJECT_CLASS_POINT||f.elementClass==JXG.OBJECT_CLASS_LINE){}else{if(f.type==JXG.OBJECT_TYPE_POLYGON){e="P_{";n="}"}else{if(f.type==JXG.OBJECT_TYPE_CIRCLE){e="k_{";n="}"}else{if(f.type==JXG.OBJECT_TYPE_ANGLE){e="W_{";n="}"}else{e="s_{";n="}"}}}}var r=[];var d="";var l="";var k=0;var g=0;for(k=0;k<h;k++){r[k]=0}while(r[h-1]<m.length){for(r[0]=1;r[0]<m.length;r[0]++){d=e;for(k=h;k>0;k--){d+=m[r[k-1]]}if(this.elementsByName[d+n]==null){return d+n}}r[0]=m.length;for(k=1;k<h;k++){if(r[k-1]==m.length){r[k-1]=1;r[k]++}}}return""};JXG.Board.prototype.generateId=function(){var d=1;while(JXG.JSXGraph.boards["gxtBoard"+d]!=null){d=Math.round(Math.random()*33)}return("gxtBoard"+d)};JXG.Board.prototype.setId=function(g,f){var e=this.numObjects,d=g.id;this.numObjects++;if((d=="")||(d==null)){d=this.id+f+e}g.id=d;this.objects[d]=g;if(g.hasLabel){g.label.content.id=d+"Label";this.addText(g.label.content)}return d};JXG.Board.prototype.getRelativeMouseCoordinates=function(d){var f=this.containerObj,e=JXG.getOffset(f),g;g=parseInt(JXG.getStyle(f,"borderLeftWidth"));if(isNaN(g)){g=0}e[0]+=g;g=parseInt(JXG.getStyle(f,"borderTopWidth"));if(isNaN(g)){g=0}e[1]+=g;g=parseInt(JXG.getStyle(f,"paddingLeft"));if(isNaN(g)){g=0}e[0]+=g;g=parseInt(JXG.getStyle(f,"paddingTop"));if(isNaN(g)){g=0}e[1]+=g;return e};JXG.Board.prototype.clickLeftArrow=function(d){this.origin.scrCoords[1]+=this.canvasWidth*0.1;this.moveOrigin();return this};JXG.Board.prototype.clickRightArrow=function(d){this.origin.scrCoords[1]-=this.canvasWidth*0.1;this.moveOrigin();return this};JXG.Board.prototype.clickUpArrow=function(d){this.origin.scrCoords[2]+=this.canvasHeight*0.1;this.moveOrigin();return this};JXG.Board.prototype.clickDownArrow=function(d){this.origin.scrCoords[2]-=this.canvasHeight*0.1;this.moveOrigin();return this};JXG.Board.prototype.touchStartListener=function(f){f.preventDefault();var h=document.createEvent("MouseEvents"),g,d=false;this.drag_obj=[];if((f.targetTouches.length==2)&&(JXG.Math.Geometry.distance([f.targetTouches[0].screenX,f.targetTouches[0].screenY],[f.targetTouches[1].screenX,f.targetTouches[1].screenY])<80)){f.targetTouches.length=1;d=true}this.options.precision.hasPoint=this.options.precision.touch;for(g=0;g<f.targetTouches.length;g++){h.initMouseEvent("mousedown",true,false,this.containerObj,0,f.targetTouches[g].screenX,f.targetTouches[g].screenY,f.targetTouches[g].clientX,f.targetTouches[g].clientY,false,false,d,false,0,null);this.mouseDownListener(h)}};JXG.Board.prototype.touchMoveListener=function(d){d.preventDefault();var h=document.createEvent("MouseEvents"),g,f;for(g=0;g<d.targetTouches.length;g++){f={pageX:d.targetTouches[g].pageX,pageY:d.targetTouches[g].pageY,clientX:d.targetTouches[g].clientX,clientY:d.targetTouches[g].clientY};this.mouseMoveListener(f,g)}};JXG.Board.prototype.touchEndListener=function(d){var g=document.createEvent("MouseEvents"),f;for(f=0;f<d.targetTouches.length;f++){g.initMouseEvent("mouseup",true,false,this.containerObj,0,0,0,0,0,false,false,false,false,0,null);this.mouseUpListener(g)}this.options.precision.hasPoint=this.options.precision.mouse};JXG.Board.prototype.mouseUpListener=function(d){this.updateQuality=this.BOARD_QUALITY_HIGH;JXG.removeEvent(document,"mouseup",this.mouseUpListener,this);this.mode=this.BOARD_MODE_NONE;if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.moveOrigin()}else{this.update()}this.drag_obj=[];this.updateHooks("mouseup")};JXG.Board.prototype.mouseDownListener=function(j){var g,k,h,d,f,e;if(document.selection){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}h=this.getRelativeMouseCoordinates(j);d=JXG.getPosition(j);f=d[0]-h[0];e=d[1]-h[1];this.mousePosAbs=d;this.mousePosRel=[f,e];if(j.shiftKey){this.drag_dx=f-this.origin.scrCoords[1];this.drag_dy=e-this.origin.scrCoords[2];this.mode=this.BOARD_MODE_MOVE_ORIGIN;JXG.addEvent(document,"mouseup",this.mouseUpListener,this);return}if(this.mode==this.BOARD_MODE_CONSTRUCT){return}if(((new Date()).getTime()-this.last_click.time<500)&&(JXG.Math.Geometry.distance(d,[this.last_click.posX,this.last_click.posY])<30)){this.zoom100()}this.last_click.time=(new Date()).getTime();this.last_click.posX=d[0];this.last_click.posY=d[1];this.mode=this.BOARD_MODE_DRAG;if(this.mode==this.BOARD_MODE_DRAG){for(g in this.objects){k=this.objects[g];if((typeof k.hasPoint!="undefined")&&((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER))&&(k.visProp.visible)&&(!k.fixed)&&(!k.frozen)&&(k.hasPoint(f,e))){if((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER)){this.drag_obj.push(this.objects[g]);if(this.options.takeFirst){break}}}}}if(this.drag_obj.length==0){this.mode=this.BOARD_MODE_NONE;return true}if(j&&j.preventDefault){j.preventDefault()}else{window.event.returnValue=false}this.updateHooks("mousedown");this.dragObjCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[f,e],this);JXG.addEvent(document,"mouseup",this.mouseUpListener,this);return false};JXG.Board.prototype.mouseMoveListener=function(l,f){var e,h,n,d,j,q,m,g=false;if(typeof f=="undefined"){f=0;g=true}n=this.getRelativeMouseCoordinates(l);d=JXG.getPosition(l);q=d[0]-n[0];m=d[1]-n[1];this.mousePosAbs=d;this.mousePosRel=[q,m];this.updateQuality=this.BOARD_QUALITY_LOW;this.dehighlightAll(q,m);if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.origin.scrCoords[1]=q-this.drag_dx;this.origin.scrCoords[2]=m-this.drag_dy;this.moveOrigin()}else{if(this.mode==this.BOARD_MODE_DRAG){j=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(q,m),this);if(this.drag_obj[f].type==JXG.OBJECT_TYPE_POINT||this.drag_obj[f].type==JXG.OBJECT_TYPE_LINE||this.drag_obj[f].type==JXG.OBJECT_TYPE_CIRCLE||this.drag_obj[f].elementClass==JXG.OBJECT_CLASS_CURVE){this.drag_obj[f].setPositionDirectly(JXG.COORDS_BY_USER,j.usrCoords[1],j.usrCoords[2]);this.update(this.drag_obj[f])}else{if(this.drag_obj[f].type==JXG.OBJECT_TYPE_GLIDER){var k=this.drag_obj[f].coords;this.drag_obj[f].setPositionDirectly(JXG.COORDS_BY_USER,j.usrCoords[1],j.usrCoords[2]);if(this.drag_obj[f].slideObject.type==JXG.OBJECT_TYPE_CIRCLE){this.drag_obj[f].coords=JXG.Math.Geometry.projectPointToCircle(this.drag_obj[f],this.drag_obj[f].slideObject,this)}else{if(this.drag_obj[f].slideObject.type==JXG.OBJECT_TYPE_LINE){this.drag_obj[f].coords=JXG.Math.Geometry.projectPointToLine(this.drag_obj[f],this.drag_obj[f].slideObject,this)}}if(this.drag_obj[f].group.length!=0){this.drag_obj[f].group[this.drag_obj[f].group.length-1].dX=this.drag_obj[f].coords.scrCoords[1]-k.scrCoords[1];this.drag_obj[f].group[this.drag_obj[f].group.length-1].dY=this.drag_obj[f].coords.scrCoords[2]-k.scrCoords[2];this.drag_obj[f].group[this.drag_obj[f].group.length-1].update(this)}else{this.update(this.drag_obj[f])}}}this.updateInfobox(this.drag_obj[f])}else{for(e in this.objects){h=this.objects[e];if(h.hasPoint!=undefined&&h.visProp.visible&&h.hasPoint(q,m)){this.updateInfobox(h);if(this.highlightedObjects[e]==null){this.highlightedObjects[e]=h;h.highlight()}}}}}this.updateQuality=this.BOARD_QUALITY_HIGH};JXG.Board.prototype.updateInfobox=function(e){var d,h,f,g;if(!e.showInfobox){return this}if(e.elementClass==JXG.OBJECT_CLASS_POINT){f=e.coords.usrCoords[1]*1;g=e.coords.usrCoords[2]*1;this.infobox.setCoords(f+this.infobox.distanceX/(this.stretchX),g+this.infobox.distanceY/(this.stretchY));if(typeof(e.infoboxText)!="string"){d=Math.abs(f);if(d>0.1){d=f.toFixed(2)}else{if(d>=0.01){d=f.toFixed(4)}else{if(d>=0.0001){d=f.toFixed(6)}else{d=f}}}h=Math.abs(g);if(h>0.1){h=g.toFixed(2)}else{if(h>=0.01){h=g.toFixed(4)}else{if(h>=0.0001){h=g.toFixed(6)}else{h=g}}}this.highlightInfobox(d,h,e)}else{this.highlightCustomInfobox(e.infoboxText,e)}this.renderer.show(this.infobox);this.renderer.updateText(this.infobox)}return this};JXG.Board.prototype.highlightCustomInfobox=function(e,d){this.infobox.setText('<span style="color:#bbbbbb;">'+e+"</span>");return this};JXG.Board.prototype.highlightInfobox=function(d,f,e){this.highlightCustomInfobox("("+d+", "+f+")");return this};JXG.Board.prototype.dehighlightAll=function(d,h){var f,g,e=false;for(f in this.highlightedObjects){g=this.highlightedObjects[f];if((g.hasPoint==undefined)||(!g.hasPoint(d,h))||(!g.visProp.visible)){g.noHighlight();delete (this.highlightedObjects[f]);e=true}}if(this.options.renderer=="canvas"&&e){this.prepareUpdate();this.renderer.suspendRedraw();this.updateRenderer();this.renderer.unsuspendRedraw()}return this};JXG.Board.prototype.getScrCoordsOfMouse=function(d,f){if(this.snapToGrid){var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,f],this);e.setCoordinates(JXG.COORDS_BY_USER,[Math.round((e.usrCoords[1])*this.snapSizeX)/this.snapSizeX,Math.round((e.usrCoords[2])*this.snapSizeY)/this.snapSizeY]);return[e.scrCoords[1],e.scrCoords[2]]}else{return[d,f]}};JXG.Board.prototype.getUsrCoordsOfMouse=function(h){var f=this.getRelativeMouseCoordinates(h);var e=JXG.getPosition(h);var d=e[0]-f[0];var j=e[1]-f[1];var g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,j],this);if(this.snapToGrid){g.setCoordinates(JXG.COORDS_BY_USER,[Math.round((g.usrCoords[1])*this.snapSizeX)/this.snapSizeX,Math.round((g.usrCoords[2])*this.snapSizeY)/this.snapSizeY])}return[g.usrCoords[1],g.usrCoords[2]]};JXG.Board.prototype.getAllUnderMouse=function(e){var d=this.getAllObjectsUnderMouse(e);d.push(this.getUsrCoordsOfMouse(e));return d};JXG.Board.prototype.getAllObjectsUnderMouse=function(k){var j=this.getRelativeMouseCoordinates(k);var d=JXG.getPosition(k);var f=d[0]-j[0];var e=d[1]-j[1];var g=[];for(var h in this.objects){if(this.objects[h].visProp.visible&&this.objects[h].hasPoint(f,e)){g.push(this.objects[h])}}return g};JXG.Board.prototype.setBoardMode=function(d){this.mode=d;return this};JXG.Board.prototype.moveOrigin=function(){var e,d;for(d in this.objects){e=this.objects[d];if(!e.frozen&&(e.elementClass==JXG.OBJECT_CLASS_POINT||e.elementClass==JXG.OBJECT_CLASS_CURVE||e.type==JXG.OBJECT_TYPE_AXIS||e.type==JXG.OBJECT_TYPE_TEXT)){if(e.elementClass!=JXG.OBJECT_CLASS_CURVE&&e.type!=JXG.OBJECT_TYPE_AXIS){e.coords.usr2screen()}}}this.clearTraces();this.fullUpdate();if(this.hasGrid){this.renderer.removeGrid(this);this.renderer.drawGrid(this)}return this};JXG.Board.prototype.finalizeAdding=function(d){if(d.hasLabel){this.renderer.drawText(d.label.content)}if(!d.visProp.visible){this.renderer.hide(d)}if(d.hasLabel&&!d.label.content.visProp.visible){this.renderer.hide(d.label.content)}};JXG.Board.prototype.addPoint=function(d){var e=this.setId(d,"P");this.renderer.drawPoint(d);this.finalizeAdding(d);return e};JXG.Board.prototype.addLine=function(d){var e=this.setId(d,"L");this.renderer.drawLine(d);this.finalizeAdding(d);return e};JXG.Board.prototype.addCircle=function(d){var e=this.setId(d,"C");this.renderer.drawCircle(d);this.finalizeAdding(d);return e};JXG.Board.prototype.addPolygon=function(d){var e=this.setId(d,"Py");this.renderer.drawPolygon(d);this.finalizeAdding(d);return e};JXG.Board.prototype.addCurve=function(d){var e=this.setId(d,"G");this.renderer.drawCurve(d);this.finalizeAdding(d);return e};JXG.Board.prototype.addChart=function(d){return this.setId(d,"Chart")};JXG.Board.prototype.addIntersection=function(f){var e=this.numObjects;this.numObjects++;var d=f.id;if((d=="")||(d==null)){d=this.id+"I"+e}this.objects[d]=f;f.id=d;f.intersect1.addChild(f);f.intersect2.addChild(f);return d};JXG.Board.prototype.addText=function(f){var e=this.numObjects;this.numObjects++;var d=f.id;if((d=="")||(d==null)){d=this.id+"T"+e}this.objects[d]=f;f.id=d;if(!f.isLabel){this.renderer.drawText(f);if(!f.visProp.visible){this.renderer.hide(f)}}return d};JXG.Board.prototype.addConditions=function(r){var q=null;var e="var el,x,y,c;\n";var n=r.indexOf("<data>");var l=r.indexOf("</data>");if(n<0){return}while(n>=0){var k=r.slice(n+6,l);var h=k.indexOf("=");var g=k.slice(0,h);var t=k.slice(h+1);h=g.indexOf(".");var d=g.slice(0,h);var f=this.elementsByName[JXG.unescapeHTML(d)];var s=g.slice(h+1).replace(/\s+/g,"").toLowerCase();t=JXG.GeonextParser.geonext2JS(t,this);t=t.replace(/this\.board\./g,"this.");if(typeof this.elementsByName[d]=="undefined"){alert("debug conditions: |"+d+"| undefined")}e+='el = this.objects["'+f.id+'"];\n';switch(s){case"x":e+="var y=el.coords.usrCoords[2];\n";e+="el.setPositionDirectly(JXG.COORDS_BY_USER,"+(t)+",y);\n";e+="el.update();\n";break;case"y":e+="var x=el.coords.usrCoords[1];\n";e+="el.coords=new JXG.Coords(JXG.COORDS_BY_USER,[x,"+(t)+"],this);\n";break;case"visible":e+="var c="+(t)+";\n";e+="if (c) {el.showElement();} else {el.hideElement();}\n";break;case"position":e+="el.position = "+(t)+";\n";e+="el.update();\n";break;case"stroke":e+="el.strokeColor = "+(t)+";\n";break;case"style":e+="el.setStyle("+(t)+");\n";break;case"strokewidth":e+="el.strokeWidth = "+(t)+";\n";break;case"fill":e+="var f="+(t)+";\n";e+="el.setProperty({fillColor:f})\n";break;case"label":break;default:alert("property '"+s+"' in conditions not yet implemented:"+t);break}r=r.slice(l+7);n=r.indexOf("<data>");l=r.indexOf("</data>")}e+="this.prepareUpdate();\n";e+="this.updateElements();\n";e+="return true;\n";this.updateConditions=new Function(e);this.updateConditions()};JXG.Board.prototype.updateConditions=function(){return false};JXG.Board.prototype.addImage=function(f){var e=this.numObjects;this.numObjects++;var d=f.id;if((d=="")||(d==null)){d=this.id+"Im"+e}this.objects[d]=f;this.elementsByName[f.name]=f;f.id=d;this.renderer.drawImage(f);if(!f.visProp.visible){this.renderer.hide(f)}return d};JXG.Board.prototype.calculateSnapSizes=function(){var f=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this),e=new JXG.Coords(JXG.COORDS_BY_USER,[1/this.gridX,1/this.gridY],this),d=f.scrCoords[1]-e.scrCoords[1],g=f.scrCoords[2]-e.scrCoords[2];this.snapSizeX=this.gridX;while(Math.abs(d)>25){this.snapSizeX*=2;d/=2}this.snapSizeY=this.gridY;while(Math.abs(g)>25){this.snapSizeY*=2;g/=2}return this};JXG.Board.prototype.applyZoom=function(){var e,d;for(d in this.objects){e=this.objects[d];if(!e.frozen&&(e.elementClass==JXG.OBJECT_CLASS_POINT||e.elementClass==JXG.OBJECT_CLASS_CURVE||e.type==JXG.OBJECT_TYPE_AXIS||e.type==JXG.OBJECT_TYPE_TEXT)){if(e.elementClass!=JXG.OBJECT_CLASS_CURVE&&e.type!=JXG.OBJECT_TYPE_AXIS){e.coords.usr2screen()}}}this.calculateSnapSizes();this.clearTraces();this.fullUpdate();if(this.hasGrid){this.renderer.removeGrid(this);this.renderer.drawGrid(this)}return this};JXG.Board.prototype.zoomIn=function(){var e,d;this.zoomX*=this.options.zoom.factor;this.zoomY*=this.options.zoom.factor;e=this.origin.scrCoords[1]*this.options.zoom.factor;d=this.origin.scrCoords[2]*this.options.zoom.factor;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,d],this);this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.zoomOut=function(){var e,d;this.zoomX/=this.options.zoom.factor;this.zoomY/=this.options.zoom.factor;e=this.origin.scrCoords[1]/this.options.zoom.factor;d=this.origin.scrCoords[2]/this.options.zoom.factor;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,d],this);this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.zoom100=function(){var g,e,f,d;f=this.zoomX;d=this.zoomY;this.zoomX=1;this.zoomY=1;g=this.origin.scrCoords[1]/f;e=this.origin.scrCoords[2]/d;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[g,e],this);this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.zoomAllPoints=function(){var q,l,g,k,e,j,m,u,t,s,r,n,h,f,d,v;q=this.zoomX/this.zoomY;l=0;g=0;k=0;e=0;for(j in this.objects){if((this.objects[j].elementClass==JXG.OBJECT_CLASS_POINT)&&this.objects[j].visProp.visible){if(this.objects[j].coords.usrCoords[1]<l){l=this.objects[j].coords.usrCoords[1]}else{if(this.objects[j].coords.usrCoords[1]>g){g=this.objects[j].coords.usrCoords[1]}}if(this.objects[j].coords.usrCoords[2]>e){e=this.objects[j].coords.usrCoords[2]}else{if(this.objects[j].coords.usrCoords[2]<k){k=this.objects[j].coords.usrCoords[2]}}}}m=50;u=m/(this.unitX*this.zoomX);t=m/(this.unitY*this.zoomY);s=g-l+2*u;r=e-k+2*t;n=Math.min(this.canvasWidth/(this.unitX*s),this.canvasHeight/(this.unitY*r));f=n;h=n*q;d=-(l-u)*this.unitX*h;v=(e+t)*this.unitY*f;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,v],this);this.zoomX=h;this.zoomY=f;this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.applyZoom();return this};JXG.Board.prototype.removeObject=function(d){var g,f;if(JXG.isArray(d)){for(f=0;f<d.length;f++){this.removeObject(d[f])}}d=JXG.getReference(this,d);if(d==undefined){return this}try{for(g in d.childElements){d.childElements[g].board.removeObject(d.childElements[g])}for(g in this.objects){if(typeof this.objects[g].childElements!="undefined"){delete (this.objects[g].childElements[d.id])}}delete (this.objects[d.id]);delete (this.elementsByName[d.name]);if(d.remove!=undefined){d.remove()}}catch(h){}return this};JXG.Board.prototype.initGeonextBoard=function(){var h,g,f,e,d;h=new JXG.Point(this,[0,0],this.id+"gOOe0","Ursprung",false);h.fixed=true;g=new JXG.Point(this,[1,0],this.id+"gXOe0","Punkt_1_0",false);g.fixed=true;f=new JXG.Point(this,[0,1],this.id+"gYOe0","Punkt_0_1",false);f.fixed=true;e=new JXG.Line(this,this.id+"gOOe0",this.id+"gXOe0",this.id+"gXLe0","X-Achse",false);e.hideElement();d=new JXG.Line(this,this.id+"gOOe0",this.id+"gYOe0",this.id+"gYLe0","Y-Achse",false);d.hideElement();return this};JXG.Board.prototype.initInfobox=function(){this.infobox=new JXG.Text(this,"0,0","",[0,0],this.id+"__infobox",null,null,false,"html");this.infobox.distanceX=-20;this.infobox.distanceY=25;this.renderer.hide(this.infobox);return this};JXG.Board.prototype.resizeContainer=function(d,e){this.canvasWidth=1*d;this.canvasHeight=1*e;this.containerObj.style.width=(this.canvasWidth)+"px";this.containerObj.style.height=(this.canvasHeight)+"px";return this};JXG.Board.prototype.showDependencies=function(){var g,e,j,h,d;e="<p>\n";for(g in this.objects){d=0;for(j in this.objects[g].childElements){d++}if(d>=0){e+="<b>"+this.objects[g].id+":</b> "}for(j in this.objects[g].childElements){e+=this.objects[g].childElements[j].id+"("+this.objects[g].childElements[j].name+"), "}e+="<p>\n"}e+="</p>\n";h=window.open();h.document.open();h.document.write(e);h.document.close();return this};JXG.Board.prototype.showXML=function(){var d=window.open("");d.document.open();d.document.write("<pre>"+JXG.escapeHTML(this.xmlString)+"</pre>");d.document.close();return this};JXG.Board.prototype.prepareUpdate=function(e){var d;for(d in this.objects){this.objects[d].needsUpdate=true}return this};JXG.Board.prototype.updateElements=function(e){var d,g,f=true;e=JXG.getReference(this,e);if(e==null){f=false}for(d in this.objects){g=this.objects[d];if(e!=null&&g.id!=e.id){f=false}if(!f&&!this.needsFullUpdate&&!g.needsRegularUpdate){continue}if(e==null||g.id!=e.id){g.update(true)}else{g.update(false)}}return this};JXG.Board.prototype.updateRenderer=function(e){var d,f;e=JXG.getReference(this,e);for(d in this.objects){f=this.objects[d];if(!this.needsFullUpdate&&!f.needsRegularUpdate&&this.options.renderer!="canvas"){continue}if(e==null||f.id!=e.id){f.updateRenderer()}else{f.updateRenderer()}}return this};JXG.Board.prototype.addHook=function(e,d){if(typeof d=="undefined"){d="update"}this.hooks.push({fn:e,mode:d});if(d=="update"){e(this)}return(this.hooks.length-1)};JXG.Board.prototype.removeHook=function(d){this.hooks[d]=null;return this};JXG.Board.prototype.updateHooks=function(d){var e;if(typeof d=="undefined"){d="update"}for(e=0;e<this.hooks.length;e++){if((this.hooks[e]!=null)&&(this.hooks[e].mode==d)){this.hooks[e].fn(this)}}return this};JXG.Board.prototype.addChild=function(d){this.dependentBoards.push(d);this.update();return this};JXG.Board.prototype.removeChild=function(e){var d;for(d=this.dependentBoards.length-1;d>=0;d--){if(this.dependentBoards[d]==e){this.dependentBoards.splice(d,1)}}return this};JXG.Board.prototype.update=function(g){var f,e,h,d;if(this.isSuspendedUpdate){return this}this.prepareUpdate(g).updateElements(g).updateConditions();this.renderer.suspendRedraw();this.updateRenderer(g);this.renderer.unsuspendRedraw();this.updateHooks();e=this.dependentBoards.length;for(f=0;f<e;f++){h=this.dependentBoards[f].id;d=JXG.JSXGraph.boards[h];if(d!=this){d.updateQuality=this.updateQuality;d.prepareUpdate(g).updateElements(g).updateConditions();d.renderer.suspendRedraw();d.updateRenderer(g);d.renderer.unsuspendRedraw();d.updateHooks()}}return this};JXG.Board.prototype.fullUpdate=function(){this.needsFullUpdate=true;this.update();this.needsFullUpdate=false;return this};JXG.Board.prototype.createElement=function(e,f,d){var j,g,h;if(e!="turtle"&&(f==null||f.length==0)){return null}if(f==null){f=[]}e=e.toLowerCase();if(d==null){d={}}for(g=0;g<f.length;g++){f[g]=JXG.getReference(this,f[g])}if(JXG.JSXGraph.elements[e]!=null){if(typeof JXG.JSXGraph.elements[e]=="function"){j=JXG.JSXGraph.elements[e](this,f,d)}else{j=JXG.JSXGraph.elements[e].creator(this,f,d)}}else{throw new Error("JSXGraph: JXG.createElement: Unknown element type given: "+e)}if(typeof j=="undefined"){return j}if(JXG.isArray(d)){d=d[0]}if(j.multipleElements){for(h in j){if(typeof j[h].setProperty!="undefined"){j[h].setProperty(d)}}}else{if(typeof j.setProperty!="undefined"){j.setProperty(d)}}this.update(j);return j};JXG.Board.prototype.create=JXG.Board.prototype.createElement;JXG.Board.prototype.clearTraces=function(){var d;for(d in this.objects){if(this.objects[d].traced){this.objects[d].clearTrace()}}return this};JXG.Board.prototype.beforeLoad=function(){};JXG.Board.prototype.afterLoad=function(){};JXG.Board.prototype.suspendUpdate=function(){this.isSuspendedUpdate=true;return this};JXG.Board.prototype.unsuspendUpdate=function(){this.isSuspendedUpdate=false;this.update();return this};JXG.Board.prototype.setBoundingBox=function(l,g){if(!JXG.isArray(l)){return}var j,f,e,d,k;k=JXG.getDimensions(this.container);this.canvasWidth=parseInt(k.width);this.canvasHeight=parseInt(k.height);f=this.canvasWidth;j=this.canvasHeight;if(g){this.unitX=f/(l[2]-l[0]);this.unitY=j/(-l[3]+l[1]);if(this.unitX<this.unitY){this.unitY=this.unitX}else{this.unitX=this.unitY}}else{this.unitX=f/(l[2]-l[0]);this.unitY=j/(-l[3]+l[1])}e=-this.unitX*l[0]*this.zoomX;d=this.unitY*l[1]*this.zoomY;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,d],this);this.stretchX=this.zoomX*this.unitX;this.stretchY=this.zoomY*this.unitY;this.moveOrigin();return this};JXG.Board.prototype.addAnimation=function(d){this.animationObjects[d.id]=d;if(!this.animationIntervalCode){this.animationIntervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.id+"'].animate();",35)}return this};JXG.Board.prototype.stopAllAnimation=function(){var d;for(d in this.animationObjects){if(this.animationObjects[d]===null){continue}this.animationObjects[d]=null;delete (this.animationObjects[d])}window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode)};JXG.Board.prototype.animate=function(){var f=0,d,k,j,e,h,l,g=null;for(d in this.animationObjects){if(this.animationObjects[d]===null){continue}f++;k=this.animationObjects[d];if(k.animationPath){if(JXG.isFunction(k.animationPath)){j=k.animationPath(new Date().getTime()-k.animationStart)}else{j=k.animationPath.pop()}if((j===JXG.undefined)||(!JXG.isArray(j)&&isNaN(j))){delete (k.animationPath)}else{k.setPositionDirectly(JXG.COORDS_BY_USER,j[0],j[1]);k.prepareUpdate().update().updateRenderer();g=k}}if(k.animationData){l=0;for(e in k.animationData){h=k.animationData[e].pop();if(typeof h=="undefined"){delete (k.animationData[h])}else{l++;k.setProperty(e+":"+h)}}if(l==0){delete (k.animationData)}}if(typeof k.animationData=="undefined"&&typeof k.animationPath=="undefined"){this.animationObjects[d]=null;delete (this.animationObjects[d])}}if(f==0){window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode)}else{this.update(g)}};JXG.Board.prototype.emulateColorblindness=function(d){var f,g,h=this;if(typeof d=="undefined"){d="none"}if(this.currentCBDef==d){return}for(f in h.objects){g=h.objects[f];if(d!="none"){if(this.currentCBDef=="none"){g.visPropOriginal=JXG.deepCopy(g.visProp)}g.setProperty({strokeColor:JXG.rgb2cb(g.visPropOriginal.strokeColor,d),fillColor:JXG.rgb2cb(g.visPropOriginal.fillColor,d),highlightStrokeColor:JXG.rgb2cb(g.visPropOriginal.highlightStrokeColor,d),highlightFillColor:JXG.rgb2cb(g.visPropOriginal.highlightFillColor,d)})}else{if(typeof g.visPropOriginal!="undefined"){g.visProp=JXG.deepCopy(g.visPropOriginal)}}}this.currentCBDef=d;this.update()};JXG.Board.prototype.construct=function(d,A,J,E,m){var t,F,s,v,D,u={},w,g,y,h,e,I,q,C,B,H,G,x,n,f,z,r;if(typeof(A)=="undefined"){A="normal"}else{G=[]}u.lines=[];u.circles=[];u.points=[];u.intersections=[];u.angles=[];u.macros=[];u.functions=[];u.texts=[];u.polygons=[];if(d.search(/\{/)!=-1){I=d.match(/\{/);I=I.length;B=0;for(D=0;D<I;D++){C=d.slice(B).search(/\{/);n=d.slice(C);n=n.slice(0,n.search(/\}/)+1);n=n.replace(/;/g,"?");d=d.slice(0,C)+n+d.slice(C+n.length);B=C+1}}t=d.split(";");for(F=0;F<t.length;F++){t[F]=t[F].replace(/^\s+/,"").replace(/\s+$/,"");if(t[F].search(/\{/)!=-1){t[F]=t[F].replace(/\?/g,";")}if(t[F].search(/Macro/)!=-1){this.addMacro(t[F])}else{if(t[F].length>0){f=false;if(t[F].search(/=/)!=-1){w=t[F].split("=");r=w[1];r=r.replace(/^\s+/,"").replace(/\s+$/,"");if(w[0].search(/\./)!=-1){f=true;w=w[0].split(".");z=w[w.length-1];z=z.replace(/^\s+/,"").replace(/\s+$/,"");w.pop();w=w.join(".");if(A=="macro"){for(D=0;D<J.length;D++){if(w==J[D]){w=E[D]}}}JXG.getReference(this,w).setProperty(z+":"+r)}}if(!f){if(t[F].search(/=/)!=-1){w=t[F].split("=");t[F]=w[1].replace(/^\s+/,"");w=w[0].replace(/\s+$/,"")}else{w=""}attributes={};x=true;while(x){if(t[F].search(/(.*)draft$/)!=-1){attributes.draft=true;t[F]=RegExp.$1;t[F]=t[F].replace(/\s+$/,"")}if(t[F].search(/(.*)invisible$/)!=-1){attributes.visible=false;t[F]=RegExp.$1;t[F]=t[F].replace(/\s+$/,"")}if(t[F].search(/(.*)nolabel$/)!=-1){attributes.withLabel=false;t[F]=RegExp.$1;t[F]=t[F].replace(/\s+$/,"")}if(t[F].search(/nolabel|invisible|draft/)==-1){x=false}}q=true;if(this.definedMacros){for(D=0;D<this.definedMacros.macros.length;D++){H=new RegExp("^"+this.definedMacros.macros[D][0]+"\\s*\\(");if(t[F].search(H)!=-1){q=false;t[F].match(/\((.*)\)/);I=RegExp.$1;I=I.split(",");for(C=0;C<I.length;C++){I[C].match(/\s*(\S*)\s*/);I[C]=RegExp.$1}u[w]=this.construct(this.definedMacros.macros[D][2],"macro",this.definedMacros.macros[D][1],I,w);u.macros.push(u[w]);break}}}if(q){if(t[F].search(/^[\[\]].*[\[\]]$/)!=-1){t[F].match(/([\[\]])(.*)([\[\]])/);attributes.straightFirst=(RegExp.$1!="[");attributes.straightLast=(RegExp.$3=="[");g=(RegExp.$2).replace(/^\s+/,"").replace(/\s+$/,"");if(g.search(/ /)!=-1){g.match(/(\S*) +(\S*)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2}if(w!=""){if(attributes.withLabel==undefined){attributes.withLabel=true}attributes.name=w;if(A=="macro"){G.push(w)}}if(A=="macro"){if(m!=""){for(D=0;D<G.length;D++){if(g[0]==G[D]){g[0]=m+"."+g[0]}if(g[1]==G[D]){g[1]=m+"."+g[1]}}}for(D=0;D<J.length;D++){if(g[0]==J[D]){g=[E[D],g[1]]}if(g[1]==J[D]){g=[g[0],E[D]]}}if(m!=""){attributes.id=m+"."+w}}if(typeof g=="string"){g=[JXG.getReference(this,g.charAt(0)),JXG.getReference(this,g.charAt(1))]}else{g=[JXG.getReference(this,g[0]),JXG.getReference(this,g[1])]}u.lines.push(this.createElement("line",g,attributes));if(w!=""){u[w]=u.lines[u.lines.length-1]}}else{if(t[F].search(/k\s*\(.*/)!=-1){t[F].match(/k\s*\(\s*(\S.*\S|\S)\s*,\s*(\S.*\S|\S)\s*\)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2;for(D=0;D<=1;D++){if(g[D].search(/[\[\]]/)!=-1){g[D].match(/^[\[\]]\s*(\S.*\S)\s*[\[\]]$/);g[D]=RegExp.$1;if(g[D].search(/ /)!=-1){g[D].match(/(\S*) +(\S*)/);g[D]=[];g[D][0]=RegExp.$1;g[D][1]=RegExp.$2}if(A=="macro"){if(m!=""){for(C=0;C<G.length;C++){if(g[D][0]==G[C]){g[D][0]=m+"."+g[D][0]}if(g[D][1]==G[C]){g[D][1]=m+"."+g[D][1]}}}for(C=0;C<J.length;C++){if(g[D][0]==J[C]){g[D]=[E[C],g[D][1]]}if(g[D][1]==J[C]){g[D]=[g[D][0],E[C]]}}}if(typeof g[D]=="string"){g[D]=(function(k,j){return function(){return JXG.getReference(j,k.charAt(0)).Dist(JXG.getReference(j,k.charAt(1)))}})(g[D],this)}else{g[D]=(function(k,j){return function(){return JXG.getReference(j,k[0]).Dist(JXG.getReference(j,k[1]))}})(g[D],this)}}else{if(g[D].search(/[0-9\.\s]+/)!=-1){g[D]=1*g[D]}else{if(A=="macro"){if(m!=""){for(C=0;C<G.length;C++){if(g[D]==G[C]){g[D]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[D]==J[C]){g[D]=E[C]}}}g[D]=JXG.getReference(this,g[D])}}}if(w!=""){if(attributes.withLabel==undefined){attributes.withLabel=true}attributes.name=w;if(A=="macro"){if(m!=""){attributes.id=m+"."+w}G.push(w)}}u.circles.push(this.createElement("circle",g,attributes));if(w!=""){u[w]=u.circles[u.circles.length-1]}}else{if(t[F].search(/^[A-Z]+.*\(\s*[0-9\.\-]+\s*[,\|]\s*[0-9\.\-]+\s*\)/)!=-1&&t[F].search(/Macro\((.*)\)/)==-1){t[F].match(/^([A-Z]+\S*)\s*\(\s*(.*)\s*[,\|]\s*(.*)\s*\)$/);w=RegExp.$1;attributes.name=w;if(A=="macro"){if(m!=""){attributes.id=m+"."+w}G.push(w)}u.points.push(this.createElement("point",[1*RegExp.$2,1*RegExp.$3],attributes));u[w]=u.points[u.points.length-1]}else{if(t[F].search(/^[A-Z]+.*\(.+(([,\|]\s*[0-9\.\-]+\s*){2})?/)!=-1&&t[F].search(/Macro\((.*)\)/)==-1){t[F].match(/([A-Z]+.*)\((.*)\)/);w=RegExp.$1;g=RegExp.$2;w=w.replace(/^\s+/,"").replace(/\s+$/,"");g=g.replace(/^\s+/,"").replace(/\s+$/,"");if(g.search(/[,\|]/)!=-1){g.match(/(\S*)\s*[,\|]\s*([0-9\.]+)\s*[,\|]\s*([0-9\.]+)\s*/);g=[];g[0]=RegExp.$1;g[1]=1*RegExp.$2;g[2]=1*RegExp.$3}else{y=g;g=[];g[0]=y;g[1]=0;g[2]=0}attributes.name=w;if(A=="macro"){if(m!=""){for(C=0;C<G.length;C++){if(g[0]==G[C]){g[0]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[0]==J[C]){g[0]=E[C]}}if(m!=""){attributes.id=m+"."+w}G.push(w)}u.points.push(this.createElement("glider",[g[1],g[2],JXG.getReference(this,g[0])],attributes));u[w]=u.points[u.points.length-1]}else{if(t[F].search(/&/)!=-1){t[F].match(/(.*)&(.*)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2;g[0]=g[0].replace(/\s+$/,"");g[1]=g[1].replace(/^\s+/,"");if(A=="macro"){for(D=0;D<=1;D++){if(m!=""){for(C=0;C<G.length;C++){if(g[D]==G[C]){g[D]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[D]==J[C]){g[D]=E[C]}}}}g[0]=JXG.getReference(this,g[0]);g[1]=JXG.getReference(this,g[1]);if((g[0].elementClass==JXG.OBJECT_CLASS_LINE||g[0].elementClass==JXG.OBJECT_CLASS_CURVE)&&(g[1].elementClass==JXG.OBJECT_CLASS_LINE||g[1].elementClass==JXG.OBJECT_CLASS_CURVE)){if(w!=""){attributes.name=w;if(A=="macro"){if(m!=""){attributes.id=m+"."+w}G.push(w)}}y=this.createElement("intersection",[g[0],g[1],0],attributes);u.intersections.push(y);if(w!=""){u[attributes.name]=y}}else{if(w!=""){attributes.name=w+"_1";if(A=="macro"){if(m!=""){attributes.id=m+"."+w+"_1"}G.push(w+"_1")}}y=this.createElement("intersection",[g[0],g[1],0],attributes);u.intersections.push(y);if(w!=""){u[attributes.name]=y}if(w!=""){attributes.name=w+"_2";if(A=="macro"){if(m!=""){attributes.id=m+"."+w+"_2"}G.push(w+"_2")}}y=this.createElement("intersection",[g[0],g[1],1],attributes);u.intersections.push(y);if(w!=""){u[attributes.name]=y}}}else{if(t[F].search(/\|[\|_]\s*\(/)!=-1){t[F].match(/\|([\|_])\s*\(\s*(\S*)\s*,\s*(\S*)\s*\)/);h=RegExp.$1;if(h=="|"){h="parallel"}else{h="normal"}g=[];g[0]=RegExp.$2;g[1]=RegExp.$3;if(A=="macro"){for(D=0;D<=1;D++){if(m!=""){for(C=0;C<G.length;C++){if(g[D]==G[C]){g[D]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[D]==J[C]){g[D]=E[C]}}}}if(w!=""){attributes.name=w;if(attributes.withLabel==undefined){attributes.withLabel=true}if(A=="macro"){if(m!=""){attributes.id=m+"."+w}G.push(w)}}u.lines.push(this.createElement(h,[JXG.getReference(this,g[0]),JXG.getReference(this,g[1])],attributes));if(w!=""){u[w]=u.lines[u.lines.length-1]}}else{if(t[F].search(/^</)!=-1){t[F].match(/<\s*\(\s*(\S*)\s*,\s*(\S*)\s*,\s*(\S*)\s*\)/);g=[];g[0]=RegExp.$1;g[1]=RegExp.$2;g[2]=RegExp.$3;if(A=="macro"){for(D=0;D<=2;D++){if(m!=""){for(C=0;C<G.length;C++){if(g[D]==G[C]){g[D]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[D]==J[C]){g[D]=E[C]}}}}if(w==""){u.lines.push(this.createElement("angle",[JXG.getReference(this,g[0]),JXG.getReference(this,g[1]),JXG.getReference(this,g[2])],attributes))}else{e=["alpha","beta","gamma","delta","epsilon","zeta","eta","theta","iota","kappa","lambda","mu","nu","xi","omicron","pi","rho","sigmaf","sigma","tau","upsilon","phi","chi","psi","omega"];h="";for(D=0;D<e.length;D++){if(w==e[D]){attributes.text="&"+w+";";attributes.name="&"+w+";";h="greek";break}else{if(D==e.length-1){attributes.text=w;attributes.name=w}}}if(attributes.withLabel==undefined){attributes.withLabel=true}if(A=="macro"){if(m!=""){attributes.id=m+"."+w}G.push(w)}u.angles.push(this.createElement("angle",[JXG.getReference(this,g[0]),JXG.getReference(this,g[1]),JXG.getReference(this,g[2])],attributes));u[w]=u.angles[u.angles.length-1]}}else{if(t[F].search(/([0-9]+)\/([0-9]+)\(\s*(\S*)\s*,\s*(\S*)\s*\)/)!=-1){g=[];g[0]=1*(RegExp.$1)/(1*(RegExp.$2));g[1]=RegExp.$3;g[2]=RegExp.$4;if(A=="macro"){for(D=1;D<=2;D++){if(m!=""){for(C=0;C<G.length;C++){if(g[D]==G[C]){g[D]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[D]==J[C]){g[D]=E[C]}}}}g[1]=JXG.getReference(this,RegExp.$3);g[2]=JXG.getReference(this,RegExp.$4);y=[];y[0]=(function(k,j){return function(){return(1-k[0])*k[1].coords.usrCoords[1]+k[0]*k[2].coords.usrCoords[1]}})(g,this);y[1]=(function(k,j){return function(){return(1-k[0])*k[1].coords.usrCoords[2]+k[0]*k[2].coords.usrCoords[2]}})(g,this);if(w!=""){attributes.name=w;if(A=="macro"){if(m!=""){attributes.id=m+"."+w}G.push(w)}}u.points.push(this.createElement("point",[y[0],y[1]],attributes));if(w!=""){u[w]=u.points[u.points.length-1]}}else{if(t[F].search(/(\S*)\s*:\s*(.*)/)!=-1){w=RegExp.$1;I=JXG.GeonextParser.geonext2JS(RegExp.$2,this);g=[new Function("x","var y = "+I+"; return y;")];attributes.name=w;u.functions.push(this.create("functiongraph",g,attributes));u[w]=u.functions[u.functions.length-1]}else{if(t[F].search(/#(.*)\(\s*([0-9])\s*[,|]\s*([0-9])\s*\)/)!=-1){g=[];g[0]=RegExp.$1;g[1]=1*RegExp.$2;g[2]=1*RegExp.$3;g[0]=g[0].replace(/^\s+/,"").replace(/\s+$/,"");u.texts.push(this.createElement("text",[g[1],g[2],g[0]],attributes))}else{if(t[F].search(/(\S*)\s*\[(.*)\]/)!=-1){attributes.name=RegExp.$1;if(attributes.withLabel==undefined){attributes.withLabel=true}g=RegExp.$2;g=g.split(",");for(D=0;D<g.length;D++){g[D]=g[D].replace(/^\s+/,"").replace(/\s+$/,"");if(A=="macro"){if(m!=""){for(C=0;C<G.length;C++){if(g[D]==G[C]){g[D]=m+"."+G[C]}}}for(C=0;C<J.length;C++){if(g[D]==J[C]){g[D]=E[C]}}}g[D]=JXG.getReference(this,g[D])}u.polygons.push(this.createElement("polygon",g,attributes));u[attributes.name]=u.polygons[u.polygons.length-1]}}}}}}}}}}}}}}}}this.update();return u};JXG.Board.prototype.addMacro=function(f){var h,d,e="",g;f.match(/(.*)\{(.*)\}/);h=RegExp.$1;d=RegExp.$2;if(h.search(/=/)!=-1){h.match(/\s*(\S*)\s*=.*/);e=RegExp.$1;h=(h.split("="))[1]}h.match(/Macro\((.*)\)/);h=RegExp.$1;h=h.split(",");for(g=0;g<h.length;g++){h[g].match(/\s*(\S*)\s*/);h[g]=RegExp.$1}if(this.definedMacros==null){this.definedMacros={};this.definedMacros.macros=[]}this.definedMacros.macros.push([e,h,d]);if(e!=""){this.definedMacros.defName=this.definedMacros.macros[this.definedMacros.macros.length-1]}};JXG.Options={showCopyright:true,showNavigation:true,takeSizeFromFile:false,renderer:"svg",takeFirst:false,grid:{hasGrid:false,gridX:1,gridY:1,gridColor:"#C0C0C0",gridOpacity:"0.5",gridDash:true,snapToGrid:false,snapSizeX:2,snapSizeY:2},zoom:{factor:1.25},elements:{strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",fillColor:"none",highlightFillColor:"none",strokeOpacity:1,highlightStrokeOpacity:1,fillOpacity:1,highlightFillOpacity:1,strokeWidth:"2px",withLabel:false,draft:{draft:false,color:"#565656",opacity:0.8,strokeWidth:"1px"}},point:{withLabel:true,style:5,face:"o",size:3,fillColor:"#ff0000",highlightFillColor:"#EEEEEE",strokeWidth:"2px",strokeColor:"#ff0000",highlightStrokeColor:"#C3D9FF",zoom:false},line:{firstArrow:false,lastArrow:false,straightFirst:true,straightLast:true,fillColor:"#000000",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#888888",ticks:{drawLabels:true,drawZero:false,insertTicks:false,minTicksDistance:50,maxTicksDistance:300,minorHeight:4,majorHeight:10,minorTicks:4,defaultDistance:1},labelOffsets:[10,10]},axis:{strokeColor:"#666666",highlightStrokeColor:"#888888"},circle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF"},conic:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF"},angle:{withLabel:true,radius:1,fillColor:"#FF7F00",highlightFillColor:"#FF7F00",strokeColor:"#FF7F00",textColor:"#0000FF",fillOpacity:0.3,highlightFillOpacity:0.3},arc:{firstArrow:false,lastArrow:false,fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF"},polygon:{fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3},sector:{fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3},text:{fontSize:12,strokeColor:"#000000",useASCIIMathML:false,defaultDisplay:"html"},curve:{strokeWidth:"1px",strokeColor:"#0000ff",RDPsmoothing:false,numberPointsHigh:1600,numberPointsLow:400,doAdvancedPlot:true},precision:{touch:30,mouse:4,epsilon:0.0001,hasPoint:4},layer:{numlayers:20,text:9,point:9,arc:8,line:7,circle:6,curve:5,polygon:4,sector:3,angle:3,grid:1,image:0},locus:{translateToOrigin:false,translateTo10:false,stretch:false,toOrigin:null,to10:null}};JXG.useStandardOptions=function(g){var h=JXG.Options,f=g.hasGrid,e,d;g.hasGrid=h.grid.hasGrid;g.gridX=h.grid.gridX;g.gridY=h.grid.gridY;g.gridColor=h.grid.gridColor;g.gridOpacity=h.grid.gridOpacity;g.gridDash=h.grid.gridDash;g.snapToGrid=h.grid.snapToGrid;g.snapSizeX=h.grid.SnapSizeX;g.snapSizeY=h.grid.SnapSizeY;g.takeSizeFromFile=h.takeSizeFromFile;for(e in g.objects){p=g.objects[e];if(p.elementClass==JXG.OBJECT_CLASS_POINT){p.visProp.fillColor=h.point.fillColor;p.visProp.highlightFillColor=h.point.highlightFillColor;p.visProp.strokeColor=h.point.strokeColor;p.visProp.highlightStrokeColor=h.point.highlightStrokeColor}else{if(p.elementClass==JXG.OBJECT_CLASS_LINE){p.visProp.fillColor=h.line.fillColor;p.visProp.highlightFillColor=h.line.highlightFillColor;p.visProp.strokeColor=h.line.strokeColor;p.visProp.highlightStrokeColor=h.line.highlightStrokeColor;for(d in p.ticks){d.majorTicks=h.line.ticks.majorTicks;d.minTicksDistance=h.line.ticks.minTicksDistance;d.minorHeight=h.line.ticks.minorHeight;d.majorHeight=h.line.ticks.majorHeight}}else{if(p.elementClass==JXG.OBJECT_CLASS_CIRCLE){p.visProp.fillColor=h.circle.fillColor;p.visProp.highlightFillColor=h.circle.highlightFillColor;p.visProp.strokeColor=h.circle.strokeColor;p.visProp.highlightStrokeColor=h.circle.highlightStrokeColor}else{if(p.type==JXG.OBJECT_TYPE_ANGLE){p.visProp.fillColor=h.angle.fillColor;p.visProp.highlightFillColor=h.angle.highlightFillColor;p.visProp.strokeColor=h.angle.strokeColor}else{if(p.type==JXG.OBJECT_TYPE_ARC){p.visProp.fillColor=h.arc.fillColor;p.visProp.highlightFillColor=h.arc.highlightFillColor;p.visProp.strokeColor=h.arc.strokeColor;p.visProp.highlightStrokeColor=h.arc.highlightStrokeColor}else{if(p.type==JXG.OBJECT_TYPE_POLYGON){p.visProp.fillColor=h.polygon.fillColor;p.visProp.highlightFillColor=h.polygon.highlightFillColor;p.visProp.fillOpacity=h.polygon.fillOpacity;p.visProp.highlightFillOpacity=h.polygon.highlightFillOpacity}else{if(p.type==JXG.OBJECT_TYPE_CONIC){p.visProp.fillColor=h.conic.fillColor;p.visProp.highlightFillColor=h.conic.highlightFillColor;p.visProp.strokeColor=h.conic.strokeColor;p.visProp.highlightStrokeColor=h.conic.highlightStrokeColor}else{if(p.type==JXG.OBJECT_TYPE_CURVE){p.visProp.strokeColor=h.curve.strokeColor}}}}}}}}}for(e in g.objects){p=g.objects[e];if(p.type==JXG.OBJECT_TYPE_SECTOR){p.arc.visProp.fillColor=h.sector.fillColor;p.arc.visProp.highlightFillColor=h.sector.highlightFillColor;p.arc.visProp.fillOpacity=h.sector.fillOpacity;p.arc.visProp.highlightFillOpacity=h.sector.highlightFillOpacity}}g.fullUpdate();if(f&&g.hasGrid){g.renderer.removeGrid(g);g.renderer.drawGrid(g)}else{if(f&&!g.hasGrid){g.renderer.removeGrid(g)}else{if(!f&&g.hasGrid){g.renderer.drawGrid(g)}}}};JXG.useBlackWhiteOptions=function(d){o=JXG.Options;o.point.fillColor=JXG.rgb2bw(o.point.fillColor);o.point.highlightFillColor=JXG.rgb2bw(o.point.highlightFillColor);o.point.strokeColor=JXG.rgb2bw(o.point.strokeColor);o.point.highlightStrokeColor=JXG.rgb2bw(o.point.highlightStrokeColor);o.line.fillColor=JXG.rgb2bw(o.line.fillColor);o.line.highlightFillColor=JXG.rgb2bw(o.line.highlightFillColor);o.line.strokeColor=JXG.rgb2bw(o.line.strokeColor);o.line.highlightStrokeColor=JXG.rgb2bw(o.line.highlightStrokeColor);o.circle.fillColor=JXG.rgb2bw(o.circle.fillColor);o.circle.highlightFillColor=JXG.rgb2bw(o.circle.highlightFillColor);o.circle.strokeColor=JXG.rgb2bw(o.circle.strokeColor);o.circle.highlightStrokeColor=JXG.rgb2bw(o.circle.highlightStrokeColor);o.arc.fillColor=JXG.rgb2bw(o.arc.fillColor);o.arc.highlightFillColor=JXG.rgb2bw(o.arc.highlightFillColor);o.arc.strokeColor=JXG.rgb2bw(o.arc.strokeColor);o.arc.highlightStrokeColor=JXG.rgb2bw(o.arc.highlightStrokeColor);o.polygon.fillColor=JXG.rgb2bw(o.polygon.fillColor);o.polygon.highlightFillColor=JXG.rgb2bw(o.polygon.highlightFillColor);o.sector.fillColor=JXG.rgb2bw(o.sector.fillColor);o.sector.highlightFillColor=JXG.rgb2bw(o.sector.highlightFillColor);o.curve.strokeColor=JXG.rgb2bw(o.curve.strokeColor);o.grid.gridColor=JXG.rgb2bw(o.grid.gridColor);JXG.useStandardOptions(d)};JXG.rgb2bw=function(f){if(f=="none"){return f}var e,h="0123456789ABCDEF",g,d;d=JXG.rgbParser(f);e=0.3*d[0]+0.59*d[1]+0.11*d[2];g=h.charAt((e>>4)&15)+h.charAt(e&15);f="#"+g+""+g+""+g;return f};JXG.simulateColorBlindness=function(e,d){o=JXG.Options;o.point.fillColor=JXG.rgb2cb(o.point.fillColor,d);o.point.highlightFillColor=JXG.rgb2cb(o.point.highlightFillColor,d);o.point.strokeColor=JXG.rgb2cb(o.point.strokeColor,d);o.point.highlightStrokeColor=JXG.rgb2cb(o.point.highlightStrokeColor,d);o.line.fillColor=JXG.rgb2cb(o.line.fillColor,d);o.line.highlightFillColor=JXG.rgb2cb(o.line.highlightFillColor,d);o.line.strokeColor=JXG.rgb2cb(o.line.strokeColor,d);o.line.highlightStrokeColor=JXG.rgb2cb(o.line.highlightStrokeColor,d);o.circle.fillColor=JXG.rgb2cb(o.circle.fillColor,d);o.circle.highlightFillColor=JXG.rgb2cb(o.circle.highlightFillColor,d);o.circle.strokeColor=JXG.rgb2cb(o.circle.strokeColor,d);o.circle.highlightStrokeColor=JXG.rgb2cb(o.circle.highlightStrokeColor,d);o.arc.fillColor=JXG.rgb2cb(o.arc.fillColor,d);o.arc.highlightFillColor=JXG.rgb2cb(o.arc.highlightFillColor,d);o.arc.strokeColor=JXG.rgb2cb(o.arc.strokeColor,d);o.arc.highlightStrokeColor=JXG.rgb2cb(o.arc.highlightStrokeColor,d);o.polygon.fillColor=JXG.rgb2cb(o.polygon.fillColor,d);o.polygon.highlightFillColor=JXG.rgb2cb(o.polygon.highlightFillColor,d);o.sector.fillColor=JXG.rgb2cb(o.sector.fillColor,d);o.sector.highlightFillColor=JXG.rgb2cb(o.sector.highlightFillColor,d);o.curve.strokeColor=JXG.rgb2cb(o.curve.strokeColor,d);o.grid.gridColor=JXG.rgb2cb(o.grid.gridColor,d);JXG.useStandardOptions(e)};JXG.rgb2cb=function(j,r){if(j=="none"){return j}var u,h,g,x,t,q,f,w,n,e,v,k;t=JXG.rgb2LMS(j);h=t.l;g=t.m;x=t.s;r=r.toLowerCase();switch(r){case"protanopia":f=-0.06150039994295001;w=0.08277001656812001;n=-0.013200141220000003;e=0.05858939668799999;v=-0.07934519995360001;k=0.013289415272000003;inflection=0.6903216543277437;q=x/g;if(q<inflection){h=-(w*g+n*x)/f}else{h=-(v*g+k*x)/e}break;case"tritanopia":f=-0.00058973116217;w=0.007690316482;n=-0.01011703519052;e=0.025495080838999994;v=-0.0422740347;k=0.017005316784;inflection=0.8349489908460004;q=g/h;if(q<inflection){x=-(f*h+w*g)/n}else{x=-(e*h+v*g)/k}break;default:f=-0.06150039994295001;w=0.08277001656812001;n=-0.013200141220000003;e=0.05858939668799999;v=-0.07934519995360001;k=0.013289415272000003;inflection=0.5763833686400911;q=x/h;if(q<inflection){g=-(f*h+n*x)/w}else{g=-(e*h+k*x)/v}break}u=JXG.LMS2rgb(h,g,x);var d="0123456789ABCDEF";q=d.charAt((u.r>>4)&15)+d.charAt(u.r&15);j="#"+q;q=d.charAt((u.g>>4)&15)+d.charAt(u.g&15);j+=q;q=d.charAt((u.b>>4)&15)+d.charAt(u.b&15);j+=q;return j};JXG.loadOptionsFromFile=function(e,f,d){this.cbp=function(g){this.parseString(g,f,d)};this.cb=JXG.bind(this.cbp,this);JXG.FileReader.parseFileContent(e,this.cb,"raw")};JXG.parseOptionsString=function(text,applyTo,board){var newOptions="";if(text!=""){newOptions=eval("("+text+")")}else{return}var maxDepth=10;var applyOption=function(base,option,depth){if(depth==10){return}depth++;for(var key in option){if((JXG.isNumber(option[key]))||(JXG.isArray(option[key]))||(JXG.isString(option[key]))||(option[key]==true)||(option[key]==false)){base[key]=option[key]}else{applyOption(base[key],option[key],depth)}}};applyOption(this,newOptions,0);if(applyTo&&typeof board!="undefined"){JXG.useStandardOptions(board)}};JXG.JSXGraph=new function(){var h,e,g,d;this.licenseText="JSXGraph v0.82rc9 Copyright (C) see http://jsxgraph.org";this.rendererType="";this.boards={};this.elements={};if((typeof forceRenderer=="undefined")||(forceRenderer==null)||(forceRenderer=="")){h=navigator.appVersion.match(/MSIE (\d\.\d)/);e=(navigator.userAgent.toLowerCase().indexOf("opera")!=-1);if((!h)||(e)||(h&&parseFloat(h[1])>=9)){if(navigator.appVersion.match(/Android.*AppleWebKit/)){JXG.Options.renderer="canvas"}else{JXG.Options.renderer="svg"}}else{JXG.Options.renderer="vml";function f(j){document.body.scrollLeft;document.body.scrollTop}document.onmousemove=f}}else{JXG.Options.renderer=forceRenderer}d=JXG.rendererFiles[JXG.Options.renderer].split(",");for(g=0;g<d.length;g++){(function(j){JXG.require(JXG.requirePath+j+".js")})(d[g])}this.initBoard=function(m,k){var s,C,B,v,t,y,l,j,A,z,x,u,r,n,q;j=JXG.getDimensions(m);if(typeof k=="undefined"){k={}}if(typeof k.boundingbox!="undefined"){A=k.boundingbox;y=parseInt(j.width);l=parseInt(j.height);if(k.keepaspectratio){v=y/(A[2]-A[0]);t=l/(-A[3]+A[1]);if(v<t){t=v}else{v=t}}else{v=y/(A[2]-A[0]);t=l/(-A[3]+A[1])}C=-v*A[0];B=t*A[1]}else{C=((typeof k.originX)=="undefined"?150:k.originX);B=((typeof k.originY)=="undefined"?150:k.originY);v=((typeof k.unitX)=="undefined"?50:k.unitX);t=((typeof k.unitY)=="undefined"?50:k.unitY)}z=((typeof k.zoom)=="undefined"?1:k.zoom);x=z*((typeof k.zoomX)=="undefined"?1:k.zoomX);u=z*((typeof k.zoomY)=="undefined"?1:k.zoomY);r=((typeof k.showCopyright)=="undefined"?JXG.Options.showCopyright:k.showCopyright);if(JXG.Options.renderer=="svg"){s=new JXG.SVGRenderer(document.getElementById(m))}else{if(JXG.Options.renderer=="vml"){s=new JXG.VMLRenderer(document.getElementById(m))}else{if(JXG.Options.renderer=="silverlight"){s=new JXG.SilverlightRenderer(document.getElementById(m),j.width,j.height)}else{s=new JXG.CanvasRenderer(document.getElementById(m))}}}q=new JXG.Board(m,s,"",[C,B],1,1,v,t,j.width,j.height,r);this.boards[q.id]=q;q.suspendUpdate();q.initInfobox();if((typeof k.axis!="undefined")&&k.axis){q.defaultAxes={};q.defaultAxes.x=q.create("axis",[[0,0],[1,0]],{});q.defaultAxes.y=q.create("axis",[[0,0],[0,1]],{})}if((typeof k.grid!="undefined")&&k.grid){q.renderer.drawGrid(q)}if(typeof k.shownavigation!="undefined"){k.showNavigation=k.shownavigation}n=((typeof k.showNavigation)=="undefined"?q.options.showNavigation:k.showNavigation);if(n){q.renderer.drawZoomBar(q)}q.unsuspendUpdate();return q};this.loadBoardFromFile=function(m,j,q){var n,k,l;if(JXG.Options.renderer=="svg"){n=new JXG.SVGRenderer(document.getElementById(m))}else{if(JXG.Options.renderer=="vml"){n=new JXG.VMLRenderer(document.getElementById(m))}else{if(JXG.Options.renderer=="silverlight"){n=new JXG.SilverlightRenderer(document.getElementById(m),l.width,l.height)}else{n=new JXG.CanvasRenderer(document.getElementById(m))}}}l=JXG.getDimensions(m);k=new JXG.Board(m,n,"",[150,150],1,1,50,50,l.width,l.height);k.initInfobox();k.beforeLoad();JXG.FileReader.parseFileContent(j,k,q);if(k.options.showNavigation){k.renderer.drawZoomBar(k)}this.boards[k.id]=k;return k};this.loadBoardFromString=function(m,j,q){var n,l,k;if(JXG.Options.renderer=="svg"){n=new JXG.SVGRenderer(document.getElementById(m))}else{if(JXG.Options.renderer=="vml"){n=new JXG.VMLRenderer(document.getElementById(m))}else{if(JXG.Options.renderer=="silverlight"){n=new JXG.SilverlightRenderer(document.getElementById(m),l.width,l.height)}else{n=new JXG.CanvasRenderer(document.getElementById(m))}}}l=JXG.getDimensions(m);k=new JXG.Board(m,n,"",[150,150],1,1,50,50,l.width,l.height);k.initInfobox();k.beforeLoad();JXG.FileReader.parseString(j,k,q,true);if(k.options.showNavigation){k.renderer.drawZoomBar(k)}this.boards[k.id]=k;return k};this.freeBoard=function(k){var j;if(typeof(k)=="string"){k=this.boards[k]}JXG.removeEvent(document,"mousedown",k.mouseDownListener,k);JXG.removeEvent(document,"mouseup",k.mouseUpListener,k);JXG.removeEvent(k.containerObj,"mousemove",k.mouseMoveListener,k);for(j in k.objects){k.removeObject(k.objects[j])}k.containerObj.innerHTML="";for(j in k.objects){delete (k.objects[j])}delete (k.renderer);delete (k.algebra);delete (this.boards[k.id])};this.registerElement=function(j,k){j=j.toLowerCase();this.elements[j]=k;if(JXG.Board.prototype["_"+j]){throw new Error("JSXGraph: Can't create wrapper method in JXG.Board because member '_"+j+"' already exists'")}JXG.Board.prototype["_"+j]=function(m,l){return this.create(j,m,l)}};this.unregisterElement=function(j){delete (this.elements[j.toLowerCase()]);delete (JXG.Board.prototype["_"+j.toLowerCase()])}};JXG.getReference=function(e,d){if(typeof(d)=="string"){if(e.objects[d]!=null){d=e.objects[d]}else{if(e.elementsByName[d]!=null){d=e.elementsByName[d]}}}return d};JXG.getRef=JXG.getReference;JXG.isString=function(d){return typeof d=="string"};JXG.isNumber=function(d){return typeof d=="number"};JXG.isFunction=function(d){return typeof d=="function"};JXG.isArray=function(d){return d!=null&&typeof d=="object"&&"splice" in d&&"join" in d};JXG.isPoint=function(d){if(typeof d=="object"){return(d.elementClass==JXG.OBJECT_CLASS_POINT)}return false};JXG.str2Bool=function(d){if(d==undefined||d==null){return true}if(typeof d=="boolean"){return d}if(d.toLowerCase()!="true"){return false}else{return true}};JXG._board=function(e,d){return JXG.JSXGraph.initBoard(e,d)};JXG.createEvalFunction=function(e,j,k){var g=[],d,h;for(d=0;d<k;d++){if(typeof j[d]=="string"){h=JXG.GeonextParser.geonext2JS(j[d],e);h=h.replace(/this\.board\./g,"board.");g[d]=new Function("","return "+(h)+";")}}return function(l){var f=j[l];if(typeof f=="string"){return g[l]()}else{if(typeof f=="function"){return f()}else{if(typeof f=="number"){return f}}}return 0}};JXG.createFunction=function(e,f,g,h){var d;if((h==null||h==true)&&JXG.isString(e)){d=JXG.GeonextParser.geonext2JS(e,f);return new Function(g,"return "+d+";")}else{if(JXG.isFunction(e)){return e}else{if(JXG.isNumber(e)){return function(){return e}}else{if(JXG.isString(e)){return function(){return e}}}}}return null};JXG.readOption=function(d,f,e){var g=d.elements[e];if(typeof d[f][e]!="undefined"){g=d[f][e]}return g};JXG.checkAttributes=function(f,e){var d;if(f==null){f={}}for(d in e){if(f[d]==null||typeof f[d]=="undefined"){f[d]=e[d]}}return f};JXG.getDimensions=function(j){var h,l,f,m,k,e,d,g;h=document.getElementById(j);if(h==null){throw new Error("\nJSXGraph: HTML container element '"+(j)+"' not found.")}l=h.style.display;if(l!="none"&&l!=null){return{width:h.offsetWidth,height:h.offsetHeight}}f=h.style;m=f.visibility;k=f.position;e=f.display;f.visibility="hidden";f.position="absolute";f.display="block";d=h.clientWidth;g=h.clientHeight;f.display=e;f.position=k;f.visibility=m;return{width:d,height:g}};JXG.addEvent=function(g,f,e,d){d["x_internal"+f]=function(){return e.apply(d,arguments)};if(typeof g.addEventListener!="undefined"){g.addEventListener(f,d["x_internal"+f],false)}else{g.attachEvent("on"+f,d["x_internal"+f])}};JXG.removeEvent=function(j,g,f,d){try{if(typeof j.addEventListener!="undefined"){j.removeEventListener(g,d["x_internal"+g],false)}else{j.detachEvent("on"+g,d["x_internal"+g])}}catch(h){}};JXG.bind=function(e,d){return function(){return e.apply(d,arguments)}};JXG.getPosition=function(e){var d=0,f=0,e;if(!e){e=window.event}if(e.pageX||e.pageY){d=e.pageX;f=e.pageY}else{if(e.clientX||e.clientY){d=e.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;f=e.clientY+document.body.scrollTop+document.documentElement.scrollTop}}return[d,f]};JXG.getOffset=function(f){var g=f,d=g.offsetLeft,e=g.offsetTop;while(g=g.offsetParent){d+=g.offsetLeft;e+=g.offsetTop;if(g.offsetParent){d+=g.clientLeft;e+=g.clientTop}}return[d,e]};JXG.getStyle=function(e,d){return e.style[d]};JXG.keys=function(d){var e=[],f;for(f in d){e.push(f)}return e};JXG.escapeHTML=function(d){return d.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")};JXG.unescapeHTML=function(d){return d.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")};JXG.clone=function(e){var d={};d.prototype=e;return d};JXG.deepCopy=function(f){var h,e,g,d;if(typeof f!=="object"||f==null){return f}if(this.isArray(f)){h=[];for(e=0;e<f.length;e++){g=f[e];if(typeof g=="object"){if(this.isArray(g)){h[e]=[];for(d=0;d<g.length;d++){if(typeof g[d]!="object"){h[e].push(g[d])}else{h[e].push(this.deepCopy(g[d]))}}}else{h[e]=this.deepCopy(g)}}else{h[e]=g}}}else{h={};for(e in f){g=f[e];if(typeof g=="object"){if(this.isArray(g)){h[e]=[];for(d=0;d<g.length;d++){if(typeof g[d]!="object"){h[e].push(g[d])}else{h[e].push(this.deepCopy(g[d]))}}}else{h[e]=this.deepCopy(g)}}else{h[e]=g}}}return h};JXG.cloneAndCopy=function(g,f){var d={},e;d.prototype=g;for(e in f){d[e]=f[e]}return d};JXG.toJSON=function(f){switch(typeof f){case"object":if(f){var e=[];if(f instanceof Array){for(var d=0;d<f.length;d++){e.push(JXG.toJSON(f[d]))}return"["+e.join(",")+"]"}else{for(var g in f){e.push('"'+g+'":'+JXG.toJSON(f[g]))}return"{"+e.join(",")+"}"}}else{return"null"}case"string":return'"'+f.replace(/(["'])/g,"\\$1")+'"';case"number":case"boolean":return new String(f)}};JXG.capitalize=function(d){return d.charAt(0).toUpperCase()+d.substring(1).toLowerCase()};JXG.timedChunk=function(e,g,f,h){var d=e.concat();setTimeout(function(){var j=+new Date();do{g.call(f,d.shift())}while(d.length>0&&(+new Date()-j<300));if(d.length>0){setTimeout(arguments.callee,1)}else{h(e)}},1)};JXG.trimNumber=function(d){d=d.replace(/^0+/,"");d=d.replace(/0+$/,"");if(d[d.length-1]=="."||d[d.length-1]==","){d=d.slice(0,-1)}if(d[0]=="."||d[0]==","){d="0"+d}return d};JXG.trim=function(d){d=d.replace(/^w+/,"");d=d.replace(/w+$/,"");return d};JXG.debug=function(d){if(typeof console!="undefined"&&console.log){if(typeof d==="string"){d=d.replace(/<\S[^><]*>/g,"")}console.log(d)}else{if(document.getElementById("debug")){document.getElementById("debug").innerHTML+=d+"<br/>"}}};JXG.addEvent(window,"load",function(e){var d=document.getElementsByTagName("script"),f,h,g;for(f=0;f<d.length;f++){if(d[f].getAttribute("type","none")=="text/jessiescript"){h=document.createElement("div");h.setAttribute("id","jessiescript_autgen_jxg_"+f);h.setAttribute("style","width:500px; height:500px; float:left");h.setAttribute("class","jxgbox");document.body.insertBefore(h,d[f]);g=JXG.JSXGraph.initBoard("jessiescript_autgen_jxg_"+f,{boundingbox:[-5,5,5,-5],keepaspectratio:true});g.construct(d[f].innerHTML)}}},window);(function(d){JXG.undefined=d})();JXG.OBJECT_TYPE_ARC=1330921795;JXG.OBJECT_TYPE_ARROW=1330921815;JXG.OBJECT_TYPE_AXIS=1330921816;JXG.OBJECT_TYPE_TICKS=1330926680;JXG.OBJECT_TYPE_CIRCLE=1330922316;JXG.OBJECT_TYPE_CONIC=1330922319;JXG.OBJECT_TYPE_CURVE=1330923344;JXG.OBJECT_TYPE_GLIDER=1330923340;JXG.OBJECT_TYPE_IMAGE=1330926157;JXG.OBJECT_TYPE_LINE=1330924622;JXG.OBJECT_TYPE_POINT=1330925652;JXG.OBJECT_TYPE_SLIDER=1330926404;JXG.OBJECT_TYPE_CAS=1330922320;JXG.OBJECT_TYPE_POLYGON=1330925657;JXG.OBJECT_TYPE_SECTOR=1330926403;JXG.OBJECT_TYPE_TEXT=1330926661;JXG.OBJECT_TYPE_ANGLE=1330921799;JXG.OBJECT_TYPE_INTERSECTION=1330926158;JXG.OBJECT_TYPE_TURTLE=5198933;JXG.OBJECT_TYPE_VECTOR=1330927188;JXG.OBJECT_CLASS_POINT=1;JXG.OBJECT_CLASS_LINE=2;JXG.OBJECT_CLASS_CIRCLE=3;JXG.OBJECT_CLASS_CURVE=4;JXG.OBJECT_CLASS_AREA=5;JXG.OBJECT_CLASS_OTHER=6;JXG.GeometryElement=function(){this.board=null;this.id="";this.needsUpdate=true;this.name="";this.visProp={};JXG.clearVisPropOld(this);this.isReal=true;this.visProp.dash=0;this.childElements={};this.hasLabel=false;this.layer=9;this.notExistingParents={};this.traced=false;this.fixed=false;this.frozen=false;this.traces={};this.numTraces=0;this.transformations=[];this.baseElement=null;this.descendants={};this.ancestors={};this.symbolic={};this.stdform=[1,0,0,0,1,1,0,0];this.quadraticform=[[1,0,0],[0,1,0],[0,0,1]];this.needsRegularUpdate=true};JXG.GeometryElement.prototype.init=function(e,f,d){if(typeof(e)=="string"){e=JXG.JSXGraph.boards[e]}this.board=e;this.id=f;if((d!=null)&&(typeof d!="undefined")){d=d}else{d=this.board.generateName(this)}this.board.elementsByName[d]=this;this.name=d;this.visProp.strokeColor=this.board.options.elements.strokeColor;this.visProp.highlightStrokeColor=this.board.options.elements.highlightStrokeColor;this.visProp.fillColor=this.board.options.elements.fillColor;this.visProp.highlightFillColor=this.board.options.elements.highlightFillColor;this.visProp.strokeWidth=this.board.options.elements.strokeWidth;this.visProp.highlightStrokeWidth=this.visProp.strokeWidth;this.visProp.strokeOpacity=this.board.options.elements.strokeOpacity;this.visProp.highlightStrokeOpacity=this.board.options.elements.highlightStrokeOpacity;this.visProp.fillOpacity=this.board.options.elements.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.elements.highlightFillOpacity;this.visProp.draft=this.board.options.elements.draft.draft;this.visProp.visible=true;this.visProp.shadow=false;this.visProp.gradient="none";this.visProp.gradientSecondColor="black";this.visProp.gradientAngle="270";this.visProp.gradientSecondOpacity=this.visProp.fillOpacity;this.visProp.gradientPositionX=0.5;this.visProp.gradientPositionY=0.5};JXG.GeometryElement.prototype.addChild=function(f){var e,d;this.childElements[f.id]=f;this.addDescendants(f);f.ancestors[this.id]=this;for(e in this.descendants){this.descendants[e].ancestors[this.id]=this;for(d in this.ancestors){this.descendants[e].ancestors[this.ancestors[d].id]=this.ancestors[d]}}for(e in this.ancestors){for(d in this.descendants){this.ancestors[e].descendants[this.descendants[d].id]=this.descendants[d]}}return this};JXG.GeometryElement.prototype.addDescendants=function(e){var d;this.descendants[e.id]=e;for(d in e.childElements){this.addDescendants(e.childElements[d])}return this};JXG.GeometryElement.prototype.generatePolynomial=function(){return[]};JXG.GeometryElement.prototype.animate=function(g,f){var d,e,j=35,k=Math.ceil(f/(j*1)),h,m=this;this.animationData={};var n=function(x,w,u){var v,t,s,r,q;v=JXG.rgb2hsv(x);t=JXG.rgb2hsv(w);s=(t[0]-v[0])/(1*k);r=(t[1]-v[1])/(1*k);q=(t[2]-v[2])/(1*k);m.animationData[u]=new Array(k);for(h=0;h<k;h++){m.animationData[u][k-h-1]=JXG.hsv2rgb(v[0]+(h+1)*s,v[1]+(h+1)*r,v[2]+(h+1)*q)}},l=function(u,q,t){u=parseFloat(u);q=parseFloat(q);if(isNaN(u)||isNaN(q)){return}var r=(q-u)/(1*k);m.animationData[t]=new Array(k);for(h=0;h<k;h++){m.animationData[t][k-h-1]=u+(h+1)*r}};for(d in g){e=d.toLowerCase();switch(e){case"strokecolor":n(this.visProp.strokeColor,g[d],"strokeColor");break;case"strokeopacity":l(this.visProp.strokeOpacity,g[d],"strokeOpacity");break;case"strokewidth":l(this.visProp.strokeWidth,g[d],"strokeWidth");break;case"fillcolor":n(this.visProp.fillColor,g[d],"fillColor");break;case"fillopacity":l(this.visProp.fillOpacity,g[d],"fillOpacity");break}}this.board.addAnimation(this);return this};JXG.GeometryElement.prototype.update=function(){if(this.traced){this.cloneToBackground(true)}return this};JXG.GeometryElement.prototype.updateRenderer=function(){};JXG.GeometryElement.prototype.hideElement=function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.label!=null&&this.hasLabel){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}return this};JXG.GeometryElement.prototype.showElement=function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.label!=null&&this.hasLabel&&this.label.hiddenByParent){this.label.hiddenByParent=false;if(this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}return this};JXG.GeometryElement.prototype.setProperty=function(){var j,h,f,e,g,k;for(j=0;j<arguments.length;j++){e=arguments[j];if(typeof e=="string"){k=e.split(":");k[0]=k[0].replace(/^\s+/,"").replace(/\s+$/,"");k[1]=k[1].replace(/^\s+/,"").replace(/\s+$/,"")}else{if(!JXG.isArray(e)){for(h in e){this.setProperty([h,e[h]])}return this}else{k=e}}if(k[1]==null){continue}switch(k[0].replace(/\s+/g).toLowerCase()){case"color":this.setProperty({strokeColor:k[1],fillColor:k[1]});break;case"opacity":this.setProperty({strokeOpacity:k[1],fillOpacity:k[1]});break;case"strokewidth":this.visProp.strokeWidth=k[1];this.visProp.highlightStrokeWidth=k[1];this.board.renderer.setObjectStrokeWidth(this,this.visProp.strokeWidth);break;case"strokecolor":f=k[1];if(f.length=="9"&&f.substr(0,1)=="#"){g=f.substr(7,2);f=f.substr(0,7)}else{g="FF"}this.visProp.strokeColor=f;this.visProp.strokeOpacity=parseInt(g.toUpperCase(),16)/255;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,this.visProp.strokeOpacity);break;case"fillcolor":f=k[1];if(f.length=="9"&&f.substr(0,1)=="#"){g=f.substr(7,2);f=f.substr(0,7)}else{g="FF"}this.visProp.fillColor=f;this.visProp.fillOpacity=parseInt(g.toUpperCase(),16)/255;this.board.renderer.setObjectFillColor(this,this.visProp.fillColor,this.visProp.fillOpacity);break;case"highlightstrokewidth":this.visProp.highlightStrokeWidth=k[1];break;case"highlightstrokecolor":f=k[1];if(f.length=="9"&&f.substr(0,1)=="#"){g=f.substr(7,2);f=f.substr(0,7)}else{g="FF"}this.visProp.highlightStrokeColor=f;this.visProp.highlightStrokeOpacity=parseInt(g.toUpperCase(),16)/255;break;case"highlightfillcolor":f=k[1];if(f.length=="9"&&f.substr(0,1)=="#"){g=f.substr(7,2);f=f.substr(0,7)}else{g="FF"}this.visProp.highlightFillColor=f;this.visProp.highlightFillOpacity=parseInt(g.toUpperCase(),16)/255;break;case"fillopacity":this.visProp.fillOpacity=k[1];this.board.renderer.setObjectFillColor(this,this.visProp.fillColor,this.visProp.fillOpacity);break;case"strokeopacity":this.visProp.strokeOpacity=k[1];this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,this.visProp.strokeOpacity);break;case"highlightfillopacity":this.visProp.highlightFillOpacity=k[1];break;case"highlightstrokeopacity":this.visProp.highlightStrokeOpacity=k[1];break;case"labelcolor":f=k[1];if(f.length=="9"&&f.substr(0,1)=="#"){g=f.substr(7,2);f=f.substr(0,7)}else{g="FF"}if(g=="00"){if(this.label!=null&&this.hasLabel){this.label.content.hideElement()}}if(this.label!=null&&this.hasLabel){this.label.color=f;this.board.renderer.setObjectStrokeColor(this.label.content,f,g)}if(this.type==JXG.OBJECT_TYPE_TEXT){this.visProp.strokeColor=f;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,1)}break;case"infoboxtext":if(typeof(k[1])=="string"){this.infoboxText=k[1]}else{this.infoboxText=false}break;case"showinfobox":if(k[1]=="false"||k[1]==false){this.showInfobox=false}else{if(k[1]=="true"||k[1]==true){this.showInfobox=true}}break;case"visible":if(k[1]=="false"||k[1]==false){this.visProp.visible=false;this.hideElement()}else{if(k[1]=="true"||k[1]==true){this.visProp.visible=true;this.showElement()}}break;case"dash":this.setDash(k[1]);break;case"trace":if(k[1]=="false"||k[1]==false){this.traced=false}else{if(k[1]=="true"||k[1]==true){this.traced=true}}break;case"style":this.setStyle(1*k[1]);break;case"face":if(this.elementClass==JXG.OBJECT_CLASS_POINT){this.setFace(k[1])}break;case"size":if(this.elementClass==JXG.OBJECT_CLASS_POINT){this.visProp.size=1*k[1];this.board.renderer.updatePoint(this)}break;case"fixed":this.fixed=((k[1]=="false")||(k[1]==false))?false:true;break;case"frozen":this.frozen=((k[1]=="false")||(k[1]==false))?false:true;break;case"shadow":if(k[1]=="false"||k[1]==false){this.visProp.shadow=false}else{if(k[1]=="true"||k[1]==true){this.visProp.shadow=true}}this.board.renderer.setShadow(this);break;case"gradient":this.visProp.gradient=k[1];this.board.renderer.setGradient(this);break;case"gradientsecondcolor":f=k[1];if(f.length=="9"&&f.substr(0,1)=="#"){g=f.substr(7,2);f=f.substr(0,7)}else{g="FF"}this.visProp.gradientSecondColor=f;this.visProp.gradientSecondOpacity=parseInt(g.toUpperCase(),16)/255;this.board.renderer.updateGradient(this);break;case"gradientsecondopacity":this.visProp.gradientSecondOpacity=k[1];this.board.renderer.updateGradient(this);break;case"draft":if(k[1]=="false"||k[1]==false){if(this.visProp.draft==true){this.visProp.draft=false;this.board.renderer.removeDraft(this)}}else{if(k[1]=="true"||k[1]==true){this.visProp.draft=true;this.board.renderer.setDraft(this)}}break;case"straightfirst":if(k[1]=="false"||k[1]==false){this.visProp.straightFirst=false}else{if(k[1]=="true"||k[1]==true){this.visProp.straightFirst=true}}this.setStraight(this.visProp.straightFirst,this.visProp.straightLast);break;case"straightlast":if(k[1]=="false"||k[1]==false){this.visProp.straightLast=false}else{if(k[1]=="true"||k[1]==true){this.visProp.straightLast=true}}this.setStraight(this.visProp.straightFirst,this.visProp.straightLast);break;case"firstarrow":if(k[1]=="false"||k[1]==false){this.visProp.firstArrow=false}else{if(k[1]=="true"||k[1]==true){this.visProp.firstArrow=true}}this.setArrow(this.visProp.firstArrow,this.visProp.lastArrow);break;case"lastarrow":if(k[1]=="false"||k[1]==false){this.visProp.lastArrow=false}else{if(k[1]=="true"||k[1]==true){this.visProp.lastArrow=true}}this.setArrow(this.visProp.firstArrow,this.visProp.lastArrow);break;case"curvetype":this.curveType=k[1];break;case"fontsize":this.visProp.fontSize=k[1];break;case"insertticks":if(this.type==JXG.OBJECT_TYPE_TICKS){var d=this.insertTicks;this.insertTicks=true;if(k[1]=="false"||k[1]==false){this.insertTicks=false}if(d!=this.insertTicks){this.calculateTicksCoordinates()}}break;case"drawlabels":if(this.type==JXG.OBJECT_TYPE_TICKS){var d=this.drawLabels;this.drawLabels=true;if(k[1]=="false"||k[1]==false){this.drawLabels=false}if(d!=this.drawLabels){this.calculateTicksCoordinates()}}break;case"drawzero":if(this.type==JXG.OBJECT_TYPE_TICKS){var d=this.drawZero;this.drawZero=true;if(k[1]=="false"||k[1]==false){this.drawZero=false}if(d!=this.drawZero){this.calculateTicksCoordinates()}}break;case"minorticks":if(this.type==JXG.OBJECT_TYPE_TICKS){var d=this.minorTicks;if((k[1]!=null)&&(k[1]>0)){this.minorTicks=k[1]}if(d!=this.minorTicks){this.calculateTicksCoordinates()}}break;case"majortickheight":if(this.type==JXG.OBJECT_TYPE_TICKS){var d=this.majorHeight;if((k[1]!=null)&&(k[1]>0)){this.majorHeight=k[1]}if(d!=this.majorHeight){this.calculateTicksCoordinates()}}break;case"minortickheight":if(this.type==JXG.OBJECT_TYPE_TICKS){var d=this.minorHeight;if((k[1]!=null)&&(k[1]>0)){this.minorHeight=k[1]}if(d!=this.minorHeight){this.calculateTicksCoordinates()}}break;case"snapwidth":if(this.type==JXG.OBJECT_TYPE_GLIDER){this.snapWidth=k[1]}break;case"withlabel":if(!k[1]){if(this.label!=null&&this.hasLabel){this.label.content.hideElement()}}else{if(this.label!=null&&this.hasLabel){if(this.visProp.visible){this.label.content.showElement()}}else{this.addLabelToElement();if(!this.visProp.visible){this.label.content.hideElement()}}}this.hasLabel=k[1]}}this.board.update(this);return this};JXG.GeometryElement.prototype.setDash=function(d){this.visProp.dash=d;this.board.renderer.setDashStyle(this,this.visProp);return this};JXG.GeometryElement.prototype.prepareUpdate=function(){this.needsUpdate=true;return this};JXG.GeometryElement.prototype.remove=function(){this.board.renderer.remove(this.board.renderer.getElementById(this.id));if(this.hasLabel){this.board.renderer.remove(this.board.renderer.getElementById(this.label.content.id))}return this};JXG.GeometryElement.prototype.getTextAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)};JXG.GeometryElement.prototype.getLabelAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)};JXG.GeometryElement.prototype.setStyle=function(d){return this};JXG.GeometryElement.prototype.setStraight=function(d,e){return this};JXG.GeometryElement.prototype.setArrow=function(e,d){this.visProp.firstArrow=e;this.visProp.lastArrow=d;this.prepareUpdate().update();return this};JXG.GeometryElement.prototype.createLabel=function(e,f){var d=false;if(typeof f=="undefined"||f==null){f=[10,10]}this.nameHTML=JXG.GeonextParser.replaceSup(JXG.GeonextParser.replaceSub(this.name));this.label={};if(typeof e=="undefined"||e==true){if(this.board.objects[this.id]==null){this.board.objects[this.id]=this;d=true}this.label.relativeCoords=f;this.label.content=new JXG.Text(this.board,this.nameHTML,this.id,[this.label.relativeCoords[0],-this.label.relativeCoords[1]],this.id+"Label","",null,true,this.board.options.text.defaultDisplay);if(d){delete (this.board.objects[this.id])}this.label.color="#000000";if(!this.visProp.visible){this.label.hiddenByParent=true;this.label.content.visProp.visible=false}this.hasLabel=true}return this};JXG.GeometryElement.prototype.addLabelToElement=function(){this.createLabel(true);this.label.content.id=this.id+"Label";this.board.addText(this.label.content);this.board.renderer.drawText(this.label.content);if(!this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}return this};JXG.GeometryElement.prototype.highlight=function(){this.board.renderer.highlight(this);return this};JXG.GeometryElement.prototype.noHighlight=function(){this.board.renderer.noHighlight(this);return this};JXG.GeometryElement.prototype.clearTrace=function(){var d;for(d in this.traces){this.board.renderer.remove(this.traces[d])}this.numTraces=0;return this};JXG.GeometryElement.prototype.cloneToBackground=function(d){return this};JXG.GeometryElement.prototype.normalize=function(){this.stdform=JXG.Math.normalize(this.stdform);return this};JXG.GeometryElement.prototype.toJSON=function(){var e='{"name":'+this.name;e+=', "id":'+this.id;var f=[];for(var d in this.visProp){if(this.visProp[d]!=null){f.push('"'+d+'":'+this.visProp[d])}}e+=', "visProp":{'+f.toString()+"}";e+="}";return e};JXG.GeometryElement.prototype.highlightStrokeColor=function(d){this.setProperty({highlightStrokeColor:d})};JXG.GeometryElement.prototype.strokeColor=function(d){this.setProperty({strokeColor:d})};JXG.GeometryElement.prototype.strokeWidth=function(d){this.setProperty({strokeWidth:d})};JXG.GeometryElement.prototype.fillColor=function(d){this.setProperty({fillColor:d})};JXG.GeometryElement.prototype.highlightFillColor=function(d){this.setProperty({highlightFillColor:d})};JXG.GeometryElement.prototype.labelColor=function(d){this.setProperty({labelColor:d})};JXG.GeometryElement.prototype.dash=function(e){this.setProperty({dash:e})};JXG.GeometryElement.prototype.visible=function(d){this.setProperty({visible:d})};JXG.GeometryElement.prototype.shadow=function(d){this.setProperty({shadow:d})};JXG.clearVisPropOld=function(d){d.visPropOld={};d.visPropOld.strokeColor="";d.visPropOld.strokeOpacity="";d.visPropOld.strokeWidth="";d.visPropOld.fillColor="";d.visPropOld.fillOpacity="";d.visPropOld.shadow=false;d.visPropOld.firstArrow=false;d.visPropOld.lastArrow=false};JXG.COORDS_BY_USER=1;JXG.COORDS_BY_SCREEN=2;JXG.Coords=function(f,e,d){this.board=d;this.usrCoords=[];this.scrCoords=[];if(f==JXG.COORDS_BY_USER){if(e.length<=2){this.usrCoords[0]=1;this.usrCoords[1]=e[0];this.usrCoords[2]=e[1]}else{this.usrCoords[0]=e[0];this.usrCoords[1]=e[1];this.usrCoords[2]=e[2];this.normalizeUsrCoords()}this.usr2screen()}else{this.scrCoords[0]=1;this.scrCoords[1]=e[0];this.scrCoords[2]=e[1];this.screen2usr()}};JXG.Coords.prototype.normalizeUsrCoords=function(){var d=0.000001;if(Math.abs(this.usrCoords[0])>d){this.usrCoords[1]/=this.usrCoords[0];this.usrCoords[2]/=this.usrCoords[0];this.usrCoords[0]=1}};JXG.Coords.prototype.usr2screen=function(h){var g=Math.round,d=this.board,f=this.usrCoords,e=d.origin.scrCoords;if(h==null||h){this.scrCoords[0]=g(f[0]);this.scrCoords[1]=g(f[0]*e[1]+f[1]*d.stretchX);this.scrCoords[2]=g(f[0]*e[2]-f[2]*d.stretchY)}else{this.scrCoords[0]=f[0];this.scrCoords[1]=f[0]*e[1]+f[1]*d.stretchX;this.scrCoords[2]=f[0]*e[2]-f[2]*d.stretchY}};JXG.Coords.prototype.screen2usr=function(){var f=this.board.origin.scrCoords,e=this.scrCoords,d=this.board;this.usrCoords[0]=1;this.usrCoords[1]=(e[1]-f[1])/d.stretchX;this.usrCoords[2]=(f[2]-e[2])/d.stretchY};JXG.Coords.prototype.distance=function(e,h){var g=0,l,d=this.usrCoords,k=this.scrCoords,j;if(e==JXG.COORDS_BY_USER){l=h.usrCoords;j=d[0]-l[0];g=j*j;j=d[1]-l[1];g+=j*j;j=d[2]-l[2];g+=j*j}else{l=h.scrCoords;j=k[0]-l[0];g=j*j;j=k[1]-l[1];g+=j*j;j=k[2]-l[2];g+=j*j}return Math.sqrt(g)};JXG.Coords.prototype.setCoordinates=function(h,f,e){var d=this.usrCoords,g=this.scrCoords;if(h==JXG.COORDS_BY_USER){if(f.length==2){d[0]=1;d[1]=f[0];d[2]=f[1]}else{d[0]=f[0];d[1]=f[1];d[2]=f[2];this.normalizeUsrCoords()}this.usr2screen(e)}else{g[1]=f[0];g[2]=f[1];this.screen2usr()}};JXG.POINT_STYLE_X_SMALL=0;JXG.POINT_STYLE_X=1;JXG.POINT_STYLE_X_BIG=2;JXG.POINT_STYLE_CIRCLE_TINY=3;JXG.POINT_STYLE_CIRCLE_SMALL=4;JXG.POINT_STYLE_CIRCLE=5;JXG.POINT_STYLE_CIRCLE_BIG=6;JXG.POINT_STYLE_SQUARE_SMALL=7;JXG.POINT_STYLE_SQUARE=8;JXG.POINT_STYLE_SQUARE_BIG=9;JXG.POINT_STYLE_PLUS_SMALL=10;JXG.POINT_STYLE_PLUS=11;JXG.POINT_STYLE_PLUS_BIG=12;JXG.Point=function(h,j,k,e,d,g,f){this.constructor();this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;this.init(h,k,e);if(j==null){j=[0,0]}this.coords=new JXG.Coords(JXG.COORDS_BY_USER,j,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,j,this.board);if(f==null){f=h.options.layer.point}this.layer=f;this.showInfobox=true;this.label={};this.label.relativeCoords=[10,-10];this.nameHTML=JXG.GeonextParser.replaceSup(JXG.GeonextParser.replaceSub(this.name));if(typeof g=="undefined"||g==true){this.board.objects[this.id]=this;this.label.content=new JXG.Text(this.board,this.nameHTML,this.id,this.label.relativeCoords,this.id+"Label","",null,true,this.board.options.text.defaultDisplay);delete (this.board.objects[this.id]);this.label.color="#000000";if(!d){this.label.hiddenByParent=true;this.label.content.visProp.visible=false}this.hasLabel=true}else{this.showInfobox=false}this.fixed=false;this.position=null;this.onPolygon=false;this.visProp.style=this.board.options.point.style;this.visProp.face=this.board.options.point.face;this.visProp.size=this.board.options.point.size;this.visProp.fillColor=this.board.options.point.fillColor;this.visProp.highlightFillColor=this.board.options.point.highlightFillColor;this.visProp.strokeColor=this.board.options.point.strokeColor;this.visProp.highlightStrokeColor=this.board.options.point.highlightStrokeColor;this.visProp.strokeWidth=this.board.options.point.strokeWidth;this.visProp.visible=d;this.slideObject=null;this.group=[];this.id=this.board.addPoint(this)};JXG.Point.prototype=new JXG.GeometryElement();JXG.Point.prototype.hasPoint=function(e,g){var d=this.coords.scrCoords,f;f=this.visProp.size;if(f<this.board.options.precision.hasPoint){f=this.board.options.precision.hasPoint}return((Math.abs(d[1]-e)<f+2)&&(Math.abs(d[2]-g))<f+2)};JXG.Point.prototype.updateConstraint=function(){return this};JXG.Point.prototype.update=function(h){if(!this.needsUpdate){return}if(typeof h=="undefined"){h=false}if(this.traced){this.cloneToBackground(true)}if(this.type==JXG.OBJECT_TYPE_GLIDER){if(this.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){if(h){this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.X()+Math.cos(this.position),this.slideObject.midpoint.Y()+Math.sin(this.position)]);this.coords=JXG.Math.Geometry.projectPointToCircle(this,this.slideObject,this.board)}else{this.coords=JXG.Math.Geometry.projectPointToCircle(this,this.slideObject,this.board);this.position=JXG.Math.Geometry.rad([this.slideObject.midpoint.X()+1,this.slideObject.midpoint.Y()],this.slideObject.midpoint,this)}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_LINE){this.coords=JXG.Math.Geometry.projectPointToLine(this,this.slideObject,this.board);var g=this.slideObject.point1.coords;var l=this.slideObject.point2.coords;if(h){if(Math.abs(g.usrCoords[0])>=JXG.Math.eps&&Math.abs(l.usrCoords[0])>=JXG.Math.eps){this.coords.setCoordinates(JXG.COORDS_BY_USER,[g.usrCoords[1]+this.position*(l.usrCoords[1]-g.usrCoords[1]),g.usrCoords[2]+this.position*(l.usrCoords[2]-g.usrCoords[2])])}}else{var m=1;var s=g.distance(JXG.COORDS_BY_USER,this.coords);var e=g.distance(JXG.COORDS_BY_USER,l);var k=l.distance(JXG.COORDS_BY_USER,this.coords);if(((s>e)||(k>e))&&(s<k)){m=-1}this.position=m*s/e;if(this.snapWidth!=null&&Math.abs(this._smax-this._smin)>=JXG.Math.eps){if(this.position<0){this.position=0}if(this.position>1){this.position=1}var t=this.position*(this._smax-this._smin)+this._smin;t=Math.round(t/this.snapWidth)*this.snapWidth;this.position=(t-this._smin)/(this._smax-this._smin);this.update(true)}}var f=this.slideObject.point1.coords.scrCoords;var r=this.slideObject.point2.coords.scrCoords;var j;if(this.slideObject.getSlope()==0){j=1}else{j=2}var n=this.coords.scrCoords[j];if(!this.slideObject.visProp.straightFirst){if(f[j]<r[j]){if(n<f[j]){this.coords=this.slideObject.point1.coords;this.position=0}}else{if(f[j]>r[j]){if(n>f[j]){this.coords=this.slideObject.point1.coords;this.position=0}}}}if(!this.slideObject.visProp.straightLast){if(f[j]<r[j]){if(n>r[j]){this.coords=this.slideObject.point2.coords;this.position=1}}else{if(f[j]>r[j]){if(n<r[j]){this.coords=this.slideObject.point2.coords;this.position=1}}}}if(this.onPolygon){var u=this.slideObject.point1.coords;var q=this.slideObject.point2.coords;if(Math.abs(this.coords.scrCoords[1]-u.scrCoords[1])<this.board.options.precision.hasPoint&&Math.abs(this.coords.scrCoords[2]-u.scrCoords[2])<this.board.options.precision.hasPoint){var d=this.slideObject.parentPolygon;for(var j=0;j<d.borders.length;j++){if(this.slideObject==d.borders[j]){this.slideObject=d.borders[(j-1+d.borders.length)%d.borders.length];break}}}else{if(Math.abs(this.coords.scrCoords[1]-q.scrCoords[1])<this.board.options.precision.hasPoint&&Math.abs(this.coords.scrCoords[2]-q.scrCoords[2])<this.board.options.precision.hasPoint){var d=this.slideObject.parentPolygon;for(var j=0;j<d.borders.length;j++){if(this.slideObject==d.borders[j]){this.slideObject=d.borders[(j+1+d.borders.length)%d.borders.length];break}}}}}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_TURTLE){this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToTurtle(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}}}}}if(this.type==JXG.OBJECT_TYPE_CAS){this.updateConstraint()}this.updateTransform();this.needsUpdate=false;return this};JXG.Point.prototype.updateRenderer=function(){if(this.visProp.visible){var d=this.isReal;this.isReal=(isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]))?false:true;this.isReal=(Math.abs(this.coords.usrCoords[0])>JXG.Math.eps)?this.isReal:false;if(this.isReal){if(d!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updatePoint(this)}else{if(d!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}return this};JXG.Point.prototype.X=function(){return this.coords.usrCoords[1]};JXG.Point.prototype.Y=function(){return this.coords.usrCoords[2]};JXG.Point.prototype.Z=function(){return this.coords.usrCoords[0]};JXG.Point.prototype.XEval=function(){return this.coords.usrCoords[1]};JXG.Point.prototype.YEval=function(){return this.coords.usrCoords[2]};JXG.Point.prototype.ZEval=function(){return this.coords.usrCoords[0]};JXG.Point.prototype.Dist=function(e){var g,j=e.coords.usrCoords,d=this.coords.usrCoords,h;h=d[0]-j[0];g=h*h;h=d[1]-j[1];g+=h*h;h=d[2]-j[2];g+=h*h;return Math.sqrt(g)};JXG.Point.prototype.setPositionDirectly=function(d,k,h){var g,m,l,f,e,j=this.coords;this.coords=new JXG.Coords(d,[k,h],this.board);if(this.group.length!=0){m=this.coords.usrCoords[1]-j.usrCoords[1];l=this.coords.usrCoords[2]-j.usrCoords[2];for(g=0;g<this.group.length;g++){for(f in this.group[g].objects){e=this.group[g].objects[f];e.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,[e.initialCoords.usrCoords[1]+m,e.initialCoords.usrCoords[2]+l],this.board)}}this.group[this.group.length-1].dX=this.coords.scrCoords[1]-j.scrCoords[1];this.group[this.group.length-1].dY=this.coords.scrCoords[2]-j.scrCoords[2];this.group[this.group.length-1].update(this)}else{for(g=this.transformations.length-1;g>=0;g--){this.initialCoords=new JXG.Coords(d,JXG.Math.matVecMult(JXG.Math.inverse(this.transformations[g].matrix),[1,k,h]),this.board)}this.update()}return this};JXG.Point.prototype.setPositionByTransform=function(h,d,g){var f=this.coords;var e=this.board.create("transform",[d,g],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(e)}else{this.addTransform(this,e)}if(this.group.length!=0){}else{this.update()}return this};JXG.Point.prototype.setPosition=function(f,d,e){this.setPositionDirectly(f,d,e);return this};JXG.Point.prototype.makeGlider=function(d){this.slideObject=JXG.getReference(this.board,d);this.type=JXG.OBJECT_TYPE_GLIDER;this.snapWidth=null;this.slideObject.addChild(this);this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)};this.needsUpdate=true;this.update();return this};JXG.Point.prototype.addConstraint=function(h){this.type=JXG.OBJECT_TYPE_CAS;var j=this.board.elementsByName;var k=[];var d;for(var g=0;g<h.length;g++){var e=h[g];if(typeof e=="string"){var f=JXG.GeonextParser.geonext2JS(e,this.board);k[g]=new Function("","return "+f+";")}else{if(typeof e=="function"){k[g]=e}else{if(typeof e=="number"){k[g]=function(l){return function(){return l}}(e)}else{if(typeof e=="object"&&typeof e.Value=="function"){k[g]=(function(l){return function(){return l.Value()}})(e)}}}}}if(h.length==1){this.updateConstraint=function(){var l=k[0]();if(JXG.isArray(l)){this.coords.setCoordinates(JXG.COORDS_BY_USER,l)}else{this.coords=l}}}else{if(h.length==2){this.XEval=k[0];this.YEval=k[1];d="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",d)}else{this.ZEval=k[0];this.XEval=k[1];this.YEval=k[2];d="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",d)}}if(!this.board.isSuspendedUpdate){this.update()}return this};JXG.Point.prototype.updateTransform=function(){if(this.transformations.length==0||this.baseElement==null){return}var e,d;if(this===this.baseElement){e=this.transformations[0].apply(this.baseElement,"self")}else{e=this.transformations[0].apply(this.baseElement)}this.coords.setCoordinates(JXG.COORDS_BY_USER,e);for(d=1;d<this.transformations.length;d++){this.coords.setCoordinates(JXG.COORDS_BY_USER,this.transformations[d].apply(this))}return this};JXG.Point.prototype.addTransform=function(g,e){var h,f,d;if(this.transformations.length==0){this.baseElement=g}if(JXG.isArray(e)){h=e}else{h=[e]}d=h.length;for(f=0;f<d;f++){this.transformations.push(h[f])}return this};JXG.Point.prototype.startAnimation=function(d,e){if((this.type==JXG.OBJECT_TYPE_GLIDER)&&(typeof this.intervalCode=="undefined")){this.intervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].objects['"+this.id+"']._anim("+d+", "+e+")",250);if(typeof this.intervalCount=="undefined"){this.intervalCount=0}}return this};JXG.Point.prototype.stopAnimation=function(){if(typeof this.intervalCode!="undefined"){window.clearInterval(this.intervalCode);delete (this.intervalCode)}return this};JXG.Point.prototype.moveAlong=function(m,e){var l=[],g=35,j=function(q,n){return function(){return m[q][n]}},d=[],f,h,k=e/g;if(JXG.isArray(m)){for(f=0;f<m.length;f++){if(JXG.isPoint(m[f])){d[f]=m[f]}else{d[f]={elementClass:JXG.OBJECT_CLASS_POINT,X:j(f,0),Y:j(f,1)}}}e=e||0;if(e===0){this.setPosition(JXG.COORDS_BY_USER,d[d.length-1].X(),d[d.length-1].Y());return this.board.update(this)}h=JXG.Math.Numerics.Neville(d);for(f=0;f<k;f++){l[f]=[];l[f][0]=h[0]((k-f)/k*h[3]());l[f][1]=h[1]((k-f)/k*h[3]())}this.animationPath=l}else{if(JXG.isFunction(m)){this.animationPath=m;this.animationStart=new Date().getTime()}}this.board.addAnimation(this);return this};JXG.Point.prototype.moveTo=function(k,f){if(typeof f=="undefined"||f==0){this.setPosition(JXG.COORDS_BY_USER,k[0],k[1]);return this.board.update(this)}var l=35,m=Math.ceil(f/(l*1)),n=new Array(m+1),e=this.coords.usrCoords[1],d=this.coords.usrCoords[2],h=(k[0]-e),g=(k[1]-d),j;if(Math.abs(h)<JXG.Math.eps&&Math.abs(g)<JXG.Math.eps){return this}for(j=m;j>=0;j--){n[m-j]=[e+h*Math.sin((j/(m*1))*Math.PI/2),d+g*Math.sin((j/(m*1))*Math.PI/2)]}this.animationPath=n;this.board.addAnimation(this);return this};JXG.Point.prototype.visit=function(n,g,e){if(arguments.length==2){e=1}var q=35,r=Math.ceil(g/(q*1)),s=new Array(e*(r+1)),f=this.coords.usrCoords[1],d=this.coords.usrCoords[2],l=(n[0]-f),h=(n[1]-d),m,k;for(k=0;k<e;k++){for(m=r;m>=0;m--){s[k*(r+1)+r-m]=[f+l*Math.pow(Math.sin((m/(r*1))*Math.PI),2),d+h*Math.pow(Math.sin((m/(r*1))*Math.PI),2)]}}this.animationPath=s;this.board.addAnimation(this);return this};JXG.Point.prototype._anim=function(q,j){var e,m,k,h,g,f,n=1,d,l;this.intervalCount++;if(this.intervalCount>j){this.intervalCount=0}if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){e=this.slideObject.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.slideObject.point2.coords);m=this.slideObject.getSlope();if(m!="INF"){g=Math.atan(m);k=Math.round((this.intervalCount/j)*e*Math.cos(g));h=Math.round((this.intervalCount/j)*e*Math.sin(g))}else{k=0;h=Math.round((this.intervalCount/j)*e)}if(q<0){f=this.slideObject.point2;if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]>0){n=-1}else{if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]==0){if(this.slideObject.point2.coords.scrCoords[2]-this.slideObject.point1.coords.scrCoords[2]>0){n=-1}}}}else{f=this.slideObject.point1;if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]>0){n=-1}else{if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]==0){if(this.slideObject.point1.coords.scrCoords[2]-this.slideObject.point2.coords.scrCoords[2]>0){n=-1}}}}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[f.coords.scrCoords[1]+n*k,f.coords.scrCoords[2]+n*h])}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){if(q>0){d=Math.round(this.intervalCount/j*this.board.canvasWidth)}else{d=Math.round((j-this.intervalCount)/j*this.board.canvasWidth)}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[d,0]);this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){if(q<0){g=this.intervalCount/j*2*Math.PI}else{g=(j-this.intervalCount)/j*2*Math.PI}l=this.slideObject.Radius();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.coords.usrCoords[1]+l*Math.cos(g),this.slideObject.midpoint.coords.usrCoords[2]+l*Math.sin(g)])}}}this.board.update(this);return this};JXG.Point.prototype.setStyle=function(d){if(d==0||d==1||d==2){this.visProp.face="cross";if(d==0){this.visProp.size=2}else{if(d==1){this.visProp.size=3}else{this.visProp.size=4}}}else{if(d==3||d==4||d==5||d==6){this.visProp.face="circle";if(d==3){this.visProp.size=1}else{if(d==4){this.visProp.size=2}else{if(d==5){this.visProp.size=3}else{this.visProp.size=4}}}}else{if(d==7||d==8||d==9){this.visProp.face="square";if(d==7){this.visProp.size=2}else{if(d==8){this.visProp.size=3}else{this.visProp.size=4}}}else{if(d==10||d==11||d==12){this.visProp.face="plus";if(d==10){this.visProp.size=2}else{if(d==11){this.visProp.size=3}else{this.visProp.size=4}}}}}}this.board.renderer.changePointStyle(this);return this};JXG.Point.prototype.setFace=function(d){d=d.toLowerCase();if(d=="cross"||d=="x"||d=="plus"||d=="+"||d=="circle"||d=="o"||d=="square"||d=="[]"||d=="diamond"||d=="<>"||d=="triangleup"||d=="a"||d=="triangledown"||d=="v"||d=="triangleleft"||d=="<"||d=="triangleright"||d==">"){this.visProp.face=d}else{this.visProp.face="circle"}this.board.renderer.changePointStyle(this);return this};JXG.Point.prototype.remove=function(){if(this.hasLabel){this.board.renderer.remove(this.board.renderer.getElementById(this.label.content.id))}this.board.renderer.remove(this.board.renderer.getElementById(this.id))};JXG.Point.prototype.getTextAnchor=function(){return this.coords};JXG.Point.prototype.getLabelAnchor=function(){return this.coords};JXG.Point.prototype.face=function(d){this.setProperty({face:d})};JXG.Point.prototype.size=function(d){this.setProperty({size:d})};JXG.Point.prototype.cloneToBackground=function(d){var e={};e.id=this.id+"T"+this.numTraces;this.numTraces++;e.coords=this.coords;e.visProp=this.visProp;e.elementClass=JXG.OBJECT_CLASS_POINT;JXG.clearVisPropOld(e);this.board.renderer.drawPoint(e);this.traces[e.id]=document.getElementById(e.id);delete e;return this};JXG.createPoint=function(j,f,k){var h,e=false,g,d;k=JXG.checkAttributes(k,{withLabel:JXG.readOption(j.options,"point","withLabel"),layer:null});d=(typeof k.visible=="undefined")||JXG.str2Bool(k.visible);for(g=0;g<f.length;g++){if(typeof f[g]=="function"||typeof f[g]=="string"){e=true}}if(!e){if((JXG.isNumber(f[0]))&&(JXG.isNumber(f[1]))){h=new JXG.Point(j,f,k.id,k.name,d,k.withLabel,k.layer);if(k.slideObject!=null){h.makeGlider(k.slideObject)}else{h.baseElement=h}}else{if((typeof f[0]=="object")&&(typeof f[1]=="object")){h=new JXG.Point(j,[0,0],k.id,k.name,d,k.withLabel,k.layer);h.addTransform(f[0],f[1])}else{throw new Error("JSXGraph: Can't create point with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [x,y], [z,x,y], [point,transformation]")}}}else{h=new JXG.Point(j,[0,0],k.id,k.name,d,k.withLabel,k.layer);h.addConstraint(f)}return h};JXG.createGlider=function(g,e,h){var f,d;h=JXG.checkAttributes(h,{withLabel:JXG.readOption(g.options,"point","withLabel"),layer:null});d=(typeof h.visible=="undefined")||JXG.str2Bool(h.visible);if(e.length==1){f=new JXG.Point(g,[0,0],h.id,h.name,d,h.withLabel)}else{f=g.create("point",e.slice(0,-1),h)}f.makeGlider(e[e.length-1]);return f};JXG.createIntersectionPoint=function(g,e,d){var f;if(e.length>=3){if(e.length==3){e.push(null)}f=g.create("point",[g.intersection(e[0],e[1],e[2],e[3])],d)}e[0].addChild(f);e[1].addChild(f);f.generatePolynomial=function(){var h=e[0].generatePolynomial(f);var j=e[1].generatePolynomial(f);if((h.length==0)||(j.length==0)){return[]}else{return[h[0],j[0]]}};return f};JXG.createOtherIntersectionPoint=function(g,e,d){var f;if(e.length!=3||!JXG.isPoint(e[2])||(e[0].elementClass!=JXG.OBJECT_CLASS_LINE&&e[0].elementClass!=JXG.OBJECT_CLASS_CIRCLE)||(e[1].elementClass!=JXG.OBJECT_CLASS_LINE&&e[1].elementClass!=JXG.OBJECT_CLASS_CIRCLE)){throw new Error("JSXGraph: Can't create 'other intersection point' with parent types '"+(typeof e[0])+"',  '"+(typeof e[1])+"'and  '"+(typeof e[2])+"'.\nPossible parent types: [circle|line,circle|line,point]")}else{f=g.create("point",[g.otherIntersection(e[0],e[1],e[2])],d)}e[0].addChild(f);e[1].addChild(f);f.generatePolynomial=function(){var h=e[0].generatePolynomial(f);var j=e[1].generatePolynomial(f);if((h.length==0)||(j.length==0)){return[]}else{return[h[0],j[0]]}};return f};JXG.JSXGraph.registerElement("point",JXG.createPoint);JXG.JSXGraph.registerElement("glider",JXG.createGlider);JXG.JSXGraph.registerElement("intersection",JXG.createIntersectionPoint);JXG.JSXGraph.registerElement("otherintersection",JXG.createOtherIntersectionPoint);JXG.Line=function(g,j,h,k,d,f,e){this.constructor();this.type=JXG.OBJECT_TYPE_LINE;this.elementClass=JXG.OBJECT_CLASS_LINE;this.init(g,k,d);if(e==null){e=g.options.layer.line}this.layer=e;this.point1=JXG.getReference(this.board,j);this.point2=JXG.getReference(this.board,h);this.image=null;this.imageTransformMatrix=[[1,0,0],[0,1,0],[0,0,1]];this.visProp.fillColor=this.board.options.line.fillColor;this.visProp.highlightFillColor=this.board.options.line.highlightFillColor;this.visProp.strokeColor=this.board.options.line.strokeColor;this.visProp.highlightStrokeColor=this.board.options.line.highlightStrokeColor;this.visProp.straightFirst=this.board.options.line.straightFirst;this.visProp.straightLast=this.board.options.line.straightLast;this.visProp.visible=true;this.visProp.firstArrow=this.board.options.line.firstArrow;this.visProp.lastArrow=this.board.options.line.lastArrow;this.ticks=[];this.defaultTicks=null;this.parentPolygon=null;this.labelOffsets=[].concat(this.board.options.line.labelOffsets);this.labelOffsets[0]=Math.abs(this.labelOffsets[0]);this.labelOffsets[1]=Math.abs(this.labelOffsets[1]);this.createLabel(f);this.id=this.board.addLine(this);this.point1.addChild(this);this.point2.addChild(this);this.needsUpdate=true;this.update()};JXG.Line.prototype=new JXG.GeometryElement;JXG.Line.prototype.hasPoint=function(l,j){var h=[],t,q=[1,l,j],m=[],u,f,k,e,n,r,g,d;h[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/this.board.stretchX+this.stdform[2]*this.board.origin.scrCoords[2]/this.board.stretchY;h[1]=this.stdform[1]/this.board.stretchX;h[2]=this.stdform[2]/(-this.board.stretchY);var m=[0,h[1],h[2]];m=JXG.Math.crossProduct(m,q);m=JXG.Math.crossProduct(m,h);m[1]/=m[0];m[2]/=m[0];m[0]=1;t=(q[0]-m[0])*(q[0]-m[0])+(q[1]-m[1])*(q[1]-m[1])+(q[2]-m[2])*(q[2]-m[2]);if(isNaN(t)||t>this.board.options.precision.hasPoint*this.board.options.precision.hasPoint){return false}if(this.visProp.straightFirst&&this.visProp.straightLast){return true}else{e=this.point1.coords.scrCoords;n=this.point2.coords.scrCoords;d=(n[1]-e[1])*(n[1]-e[1])+(n[2]-e[2])*(n[2]-e[2]);r=(m[1]-e[1])*(m[1]-e[1])+(m[2]-e[2])*(m[2]-e[2]);g=(m[1]-n[1])*(m[1]-n[1])+(m[2]-n[2])*(m[2]-n[2]);if((r>d)||(g>d)){if(r<g){if(!this.visProp.straightFirst){return false}}else{if(!this.visProp.straightLast){return false}}}return true}};JXG.Line.prototype.update=function(){var d,e;if(this.constrained){if(typeof this.funps!="undefined"){e=this.funps();this.point1=e[0];this.point2=e[1]}else{this.point1=this.funp1();this.point2=this.funp2()}}if(this.needsUpdate){if(true||!this.board.geonextCompatibilityMode){this.updateStdform()}for(d=0;d<this.ticks.length;d++){if(typeof this.ticks[d]!="undefined"){this.ticks[d].calculateTicksCoordinates()}}}if(this.traced){this.cloneToBackground(true)}};JXG.Line.prototype.updateStdform=function(){var d=JXG.Math.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=d[0];this.stdform[1]=d[1];this.stdform[2]=d[2];this.stdform[3]=0;this.normalize()};JXG.Line.prototype.updateRenderer=function(){var d,e;if(this.needsUpdate&&this.visProp.visible){d=this.isReal;this.isReal=(isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2]))?false:true;if(this.isReal){if(d!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateLine(this)}else{if(d!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Line.prototype.generatePolynomial=function(h){var g=this.point1.symbolic.x,f=this.point1.symbolic.y,k=this.point2.symbolic.x,j=this.point2.symbolic.y,e=h.symbolic.x,d=h.symbolic.y;return[["(",f,")*(",e,")-(",f,")*(",k,")+(",d,")*(",k,")-(",g,")*(",d,")+(",g,")*(",j,")-(",e,")*(",j,")"].join("")]};JXG.Line.prototype.getRise=function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[0]/this.stdform[2]}else{return Infinity}};JXG.Line.prototype.getSlope=function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[1]/this.stdform[2]}else{return Infinity}};JXG.Line.prototype.setStraight=function(d,e){this.visProp.straightFirst=d;this.visProp.straightLast=e;this.board.renderer.updateLine(this)};JXG.Line.prototype.getTextAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[this.point1.X()+0.5*(this.point2.X()-this.point1.X()),this.point1.Y()+0.5*(this.point2.Y()-this.point1.Y())],this.board)};JXG.Line.prototype.setLabelRelativeCoords=function(d){if(typeof this.label.content!="undefined"){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d[0],-d[1]],this.board)}};JXG.Line.prototype.getLabelAnchor=function(){var h,f,e,g,d,j=this.labelOffsets[0],k=this.labelOffsets[1];if(!this.visProp.straightFirst&&!this.visProp.straightLast){this.setLabelRelativeCoords(this.labelOffsets);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X()-0.5*(this.point2.X()-this.point1.X()),this.point2.Y()-0.5*(this.point2.Y()-this.point1.Y())],this.board)}else{f=new JXG.Coords(JXG.COORDS_BY_USER,this.point1.coords.usrCoords,this.board);e=new JXG.Coords(JXG.COORDS_BY_USER,this.point2.coords.usrCoords,this.board);this.board.renderer.calcStraight(this,f,e);if(this.visProp.straightFirst){h=f}else{h=e}if(this.label.content!=null){g=[0,0];d=this.getSlope();if(h.scrCoords[2]==0){if(d==Infinity){g=[j,-k]}else{if(d>=0){g=[j,-k]}else{g=[-j,-k]}}}else{if(h.scrCoords[2]==this.board.canvasHeight){if(d==Infinity){g=[j,k]}else{if(d>=0){g=[-j,k]}else{g=[j,k]}}}}if(h.scrCoords[1]==0){if(d==Infinity){g=[j,k]}else{if(d>=0){g=[j,-k]}else{g=[j,k]}}}else{if(h.scrCoords[1]==this.board.canvasWidth){if(d==Infinity){g=[-j,k]}else{if(d>=0){g=[-j,k]}else{g=[-j,-k]}}}}this.setLabelRelativeCoords(g)}return h}};JXG.Line.prototype.cloneToBackground=function(e){var g={},f,d;g.id=this.id+"T"+this.numTraces;this.numTraces++;g.point1=this.point1;g.point2=this.point2;g.stdform=this.stdform;JXG.clearVisPropOld(g);g.board={};g.board.unitX=this.board.unitX;g.board.unitY=this.board.unitY;g.board.zoomX=this.board.zoomX;g.board.zoomY=this.board.zoomY;g.board.stretchX=this.board.stretchX;g.board.stretchY=this.board.stretchY;g.board.origin=this.board.origin;g.board.canvasHeight=this.board.canvasHeight;g.board.canvasWidth=this.board.canvasWidth;g.board.dimension=this.board.dimension;g.board.algebra=this.board.algebra;g.visProp=this.visProp;d=this.getSlope();f=this.getRise();g.getSlope=function(){return d};g.getRise=function(){return f};this.board.renderer.enhancedRendering=true;this.board.renderer.drawLine(g);this.board.renderer.enhancedRendering=false;this.traces[g.id]=this.board.renderer.getElementById(g.id);delete g};JXG.Line.prototype.addTransform=function(d){var f,e;if(JXG.isArray(d)){f=d}else{f=[d]}for(e=0;e<f.length;e++){this.point1.transformations.push(f[e]);this.point2.transformations.push(f[e])}};JXG.Line.prototype.setPosition=function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});if(this.point1.transformations.length>0&&this.point1.transformations[this.point1.transformations.length-1].isNumericMatrix){this.point1.transformations[this.point1.transformations.length-1].melt(e)}else{this.point1.addTransform(this.point1,e)}if(this.point2.transformations.length>0&&this.point2.transformations[this.point2.transformations.length-1].isNumericMatrix){this.point2.transformations[this.point2.transformations.length-1].melt(e)}else{this.point2.addTransform(this.point2,e)}};JXG.Line.prototype.X=function(j){var m=this.stdform[1],l=this.stdform[2],k=this.stdform[0],g,f,d,e,h;j*=Math.PI;g=m*Math.cos(j)+l*Math.sin(j);f=k;d=Math.sqrt(g*g+f*f);e=-f/d;h=g/d;if(Math.abs(h)<JXG.Math.eps){h=1}return e*Math.cos(j)/h};JXG.Line.prototype.Y=function(j){var m=this.stdform[1],l=this.stdform[2],k=this.stdform[0],g,f,d,e,h;j*=Math.PI;g=m*Math.cos(j)+l*Math.sin(j);f=k;d=Math.sqrt(g*g+f*f);e=-f/d;h=g/d;if(Math.abs(h)<JXG.Math.eps){h=1}return e*Math.sin(j)/h};JXG.Line.prototype.Z=function(h){var f=this.stdform[1],e=this.stdform[2],l=this.stdform[0],d,k,g,j;h*=Math.PI;d=f*Math.cos(h)+e*Math.sin(h);k=l;g=Math.sqrt(d*d+k*k);j=d/g;if(Math.abs(j)>=JXG.Math.eps){return 1}else{return 0}};JXG.Line.prototype.minX=function(){return 0};JXG.Line.prototype.maxX=function(){return 1};JXG.Line.prototype.addTicks=function(d){if(d.id==""||typeof d.id=="undefined"){d.id=this.id+"_ticks_"+(this.ticks.length+1)}this.board.renderer.drawTicks(d);this.ticks.push(d);this.ticks[this.ticks.length-1].updateRenderer();return d.id};JXG.Line.prototype.removeAllTicks=function(){var d;for(d=this.ticks.length;d>0;d--){this.board.renderer.remove(this.ticks[d-1].rendNode)}this.ticks=new Array()};JXG.Line.prototype.removeTicks=function(f){var e,d;if(this.defaultTicks!=null&&this.defaultTicks==f){this.defaultTicks=null}for(e=this.ticks.length;e>0;e--){if(this.ticks[e-1]==f){this.board.renderer.remove(this.ticks[e-1].rendNode);for(d=0;d<this.ticks[e-1].ticks.length;d++){if(this.ticks[e-1].labels[d]!=null){if(this.ticks[e-1].labels[d].show){this.board.renderer.remove(this.ticks[e-1].labels[d].rendNode)}}}delete (this.ticks[e-1])}}};JXG.createLine=function(j,l,h){var e,n,m,g,k=[];h=JXG.checkAttributes(h,{withLabel:JXG.readOption(j.options,"line","withLabel"),layer:null,labelOffsets:JXG.readOption(j.options,"line","labelOffsets")});var f=false;if(l.length==2){if(l[0].length>1){n=j.create("point",l[0],{visible:false,fixed:true})}else{if(l[0].elementClass==JXG.OBJECT_CLASS_POINT){n=JXG.getReference(j,l[0])}else{if((typeof l[0]=="function")&&(l[0]().elementClass==JXG.OBJECT_CLASS_POINT)){n=l[0]();f=true}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}if(l[1].length>1){m=j.create("point",l[1],{visible:false,fixed:true})}else{if(l[1].elementClass==JXG.OBJECT_CLASS_POINT){m=JXG.getReference(j,l[1])}else{if((typeof l[1]=="function")&&(l[1]().elementClass==JXG.OBJECT_CLASS_POINT)){m=l[1]();f=true}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}e=new JXG.Line(j,n.id,m.id,h.id,h.name,h.withLabel,h.layer);if(f){e.constrained=true;e.funp1=l[0];e.funp2=l[1]}}else{if(l.length==3){for(g=0;g<3;g++){if(typeof l[g]=="number"){k[g]=function(q){return function(){return q}}(l[g])}else{if(typeof l[g]=="function"){k[g]=l[g]}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"' and '"+(typeof l[2])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");return}}}n=j.create("point",[function(){return(0+k[2]()*k[2]()+k[1]()*k[1]())*0.5},function(){return(k[2]()-k[1]()*k[0]()+k[2]())*0.5},function(){return(-k[1]()-k[2]()*k[0]()-k[1]())*0.5}],{visible:false,name:" "});m=j.create("point",[function(){return k[2]()*k[2]()+k[1]()*k[1]()},function(){return -k[1]()*k[0]()+k[2]()},function(){return -k[2]()*k[0]()-k[1]()}],{visible:false,name:" "});e=new JXG.Line(j,n.id,m.id,h.id,h.name,h.withLabel)}else{if((l.length==1)&&(typeof l[0]=="function")&&(l[0]().length==2)&&(l[0]()[0].elementClass==JXG.OBJECT_CLASS_POINT)&&(l[0]()[1].elementClass==JXG.OBJECT_CLASS_POINT)){var d=l[0]();e=new JXG.Line(j,d[0].id,d[1].id,h.id,h.name,h.withLabel,h.layer);e.constrained=true;e.funps=l[0]}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}e.labelOffsets=h.labelOffsets;return e};JXG.JSXGraph.registerElement("line",JXG.createLine);JXG.createSegment=function(f,d,g){var e;g=JXG.checkAttributes(g,{withLabel:JXG.readOption(f.options,"line","withLabel"),layer:null});g.straightFirst=false;g.straightLast=false;e=f.create("line",d,g);return e};JXG.JSXGraph.registerElement("segment",JXG.createSegment);JXG.createArrow=function(g,e,d){var f;d=JXG.checkAttributes(d,{withLabel:JXG.readOption(g.options,"line","withLabel"),layer:null});f=g.create("line",e,d);f.setStraight(false,false);f.setArrow(false,true);f.type=JXG.OBJECT_TYPE_VECTOR;return f};JXG.JSXGraph.registerElement("arrow",JXG.createArrow);JXG.createAxis=function(h,n,e){var l,k,q,j,f,d,g,m;if((JXG.isArray(n[0])||JXG.isPoint(n[0]))&&(JXG.isArray(n[1])||JXG.isPoint(n[1]))){if(JXG.isPoint(n[0])){l=n[0]}else{l=new JXG.Point(h,n[0],"","",false)}if(JXG.isPoint(n[1])){k=n[1]}else{k=new JXG.Point(h,n[1],"","",false)}l.fixed=true;k.fixed=true;e=JXG.checkAttributes(e,{lastArrow:true,straightFirst:true,straightLast:true,strokeWidth:1,withLabel:false,strokeColor:h.options.axis.strokeColor});e.highlightStrokeColor=e.highlightStrokeColor||e.strokeColor||h.options.axis.highlightStrokeColor;q=h.create("line",[l,k],e);q.needsRegularUpdate=false;e=JXG.checkAttributes(e,{minorTicks:4,insertTicks:true});if(e.ticksDistance!="undefined"&&e.ticksDistance!=null){j=e.ticksDistance}else{if(JXG.isArray(e.ticks)){j=e.ticks}else{f=new JXG.Coords(JXG.COORDS_BY_USER,[q.point1.coords.usrCoords.slice(1)],h);d=new JXG.Coords(JXG.COORDS_BY_USER,[q.point2.coords.usrCoords.slice(1)],h);h.renderer.calcStraight(q,f,d);g=f.distance(JXG.COORDS_BY_USER,d);j=1}}q.defaultTicks=h.create("ticks",[q,j],e);q.defaultTicks.needsRegularUpdate=false}else{throw new Error("JSXGraph: Can't create point with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]")}return q};JXG.JSXGraph.registerElement("axis",JXG.createAxis);JXG.createTangent=function(q,s,k){var d,r,m,n,l,h,e,t,u,v;if(s.length==1){d=s[0];r=d.slideObject}else{if(s.length==2){if(JXG.isPoint(s[0])){d=s[0];r=s[1]}else{if(JXG.isPoint(s[1])){r=s[0];d=s[1]}else{throw new Error("JSXGraph: Can't create tangent with parent types '"+(typeof s[0])+"' and '"+(typeof s[1])+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]")}}}else{throw new Error("JSXGraph: Can't create tangent with parent types '"+(typeof s[0])+"' and '"+(typeof s[1])+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]")}}k=JXG.checkAttributes(k,{withLabel:JXG.readOption(q.options,"line","withLabel"),layer:null});if(r.elementClass==JXG.OBJECT_CLASS_LINE){v=q.create("line",[r.point1,r.point2],k)}else{if(r.elementClass==JXG.OBJECT_CLASS_CURVE&&!(r.type==JXG.OBJECT_TYPE_CONIC)){if(r.curveType!="plot"){m=r.X;n=r.Y;v=q.create("line",[function(){return -d.X()*q.D(n)(d.position)+d.Y()*q.D(m)(d.position)},function(){return q.D(n)(d.position)},function(){return -q.D(m)(d.position)}],k);d.addChild(v);v.glider=d}else{v=q.create("line",[function(){l=Math.floor(d.position);if(l==r.numberPoints-1){l--}if(l<0){return 1}return r.Y(l)*r.X(l+1)-r.X(l)*r.Y(l+1)},function(){l=Math.floor(d.position);if(l==r.numberPoints-1){l--}if(l<0){return 0}return r.Y(l+1)-r.Y(l)},function(){l=Math.floor(d.position);if(l==r.numberPoints-1){l--}if(l<0){return 0}return r.X(l)-r.X(l+1)}],k);d.addChild(v);v.glider=d}}else{if(r.type==JXG.OBJECT_TYPE_TURTLE){v=q.create("line",[function(){l=Math.floor(d.position);for(h=0;h<r.objects.length;h++){e=r.objects[h];if(e.type==JXG.OBJECT_TYPE_CURVE){if(l<e.numberPoints){break}l-=e.numberPoints}}if(l==e.numberPoints-1){l--}if(l<0){return 1}return e.Y(l)*e.X(l+1)-e.X(l)*e.Y(l+1)},function(){l=Math.floor(d.position);for(h=0;h<r.objects.length;h++){e=r.objects[h];if(e.type==JXG.OBJECT_TYPE_CURVE){if(l<e.numberPoints){break}l-=e.numberPoints}}if(l==e.numberPoints-1){l--}if(l<0){return 0}return e.Y(l+1)-e.Y(l)},function(){l=Math.floor(d.position);for(h=0;h<r.objects.length;h++){e=r.objects[h];if(e.type==JXG.OBJECT_TYPE_CURVE){if(l<e.numberPoints){break}l-=e.numberPoints}}if(l==e.numberPoints-1){l--}if(l<0){return 0}return e.X(l)-e.X(l+1)}],k);d.addChild(v);v.glider=d}else{if(r.elementClass==JXG.OBJECT_CLASS_CIRCLE||r.type==JXG.OBJECT_TYPE_CONIC){v=q.create("line",[function(){return JXG.Math.matVecMult(r.quadraticform,d.coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(r.quadraticform,d.coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(r.quadraticform,d.coords.usrCoords)[2]}],k);d.addChild(v);v.glider=d}}}}return v};JXG.JSXGraph.registerElement("tangent",JXG.createTangent);JXG.JSXGraph.registerElement("polar",JXG.createTangent);JXG.Group=function(h,l,d){var j,g,e,k,f;this.board=h;this.objects={};j=this.board.numObjects;this.board.numObjects++;if((l=="")||(l==null)||(typeof l=="undefined")){this.id=this.board.id+"Group"+j}else{this.id=l}this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;if((d=="")||(d==null)||(typeof d=="undefined")){this.name="group_"+this.board.generateName(this)}else{this.name=d}delete (this.type);if((arguments.length==4)&&(JXG.isArray(arguments[3]))){g=arguments[3]}else{g=[];for(e=3;e<arguments.length;e++){g.push(arguments[e])}}for(e=0;e<g.length;e++){k=JXG.getReference(this.board,g[e]);if((!k.fixed)&&((k.type==JXG.OBJECT_TYPE_POINT)||(k.type==JXG.OBJECT_TYPE_GLIDER))){if(k.group.length!=0){this.addGroup(k.group[k.group.length-1])}else{this.addPoint(k)}}}for(f in this.objects){this.objects[f].group.push(this)}this.dX=0;this.dY=0};JXG.Group.prototype.ungroup=function(){var d;for(d in this.objects){if(this.objects[d].group[this.objects[d].group.length-1]==this){this.objects[d].group.pop()}delete (this.objects[d])}};JXG.Group.prototype.update=function(d){var f=null,e;for(e in this.objects){f=this.objects[e];if(f.id!=d.id){f.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[f.coords.scrCoords[1]+this.dX,f.coords.scrCoords[2]+this.dY],f.board)}}for(e in this.objects){if(this.board.objects[e]!=undefined){this.objects[e].update(false)}else{delete (this.objects[e])}}};JXG.Group.prototype.addPoint=function(d){this.objects[d.id]=d};JXG.Group.prototype.addPoints=function(d){var e;for(e in d){this.objects[e.id]=e}};JXG.Group.prototype.addGroup=function(e){var d;for(d in e.objects){this.addPoint(e.objects[d])}};JXG.createGroup=function(f,e,d){return new JXG.Group(f,d.id,d.name,e)};JXG.JSXGraph.registerElement("group",JXG.createGroup);JXG.Circle=function(j,l,h,e,k,d,g,f){this.constructor();this.type=JXG.OBJECT_TYPE_CIRCLE;this.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.init(j,k,d);if(f==null){f=j.options.layer.circle}this.layer=f;this.method=l;this.midpoint=JXG.getReference(this.board,h);this.midpoint.addChild(this);this.visProp.visible=true;this.visProp.fillColor=this.board.options.circle.fillColor;this.visProp.highlightFillColor=this.board.options.circle.highlightFillColor;this.visProp.strokeColor=this.board.options.circle.strokeColor;this.visProp.highlightStrokeColor=this.board.options.circle.highlightStrokeColor;this.point2=null;this.radius=0;this.line=null;this.circle=null;if(l=="twoPoints"){this.point2=JXG.getReference(j,e);this.point2.addChild(this);this.radius=this.Radius()}else{if(l=="pointRadius"){this.generateTerm(e);this.updateRadius()}else{if(l=="pointLine"){this.line=JXG.getReference(j,e);this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(l=="pointCircle"){this.circle=JXG.getReference(j,e);this.radius=this.circle.Radius()}}}}if(g!=null){this.createLabel(g)}if(l=="twoPoints"){this.id=this.board.addCircle(this)}else{if(l=="pointRadius"){this.id=this.board.addCircle(this);this.notifyParents(e)}else{if(l=="pointLine"){this.line.addChild(this);this.id=this.board.addCircle(this)}else{if(l=="pointCircle"){this.circle.addChild(this);this.id=this.board.addCircle(this)}}}}};JXG.Circle.prototype=new JXG.GeometryElement;JXG.Circle.prototype.hasPoint=function(d,k){var e=this.board.options.precision.hasPoint/(this.board.stretchX),g=this.midpoint.coords.usrCoords,h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d,k],this.board),f=this.Radius();var j=Math.sqrt((g[1]-h.usrCoords[1])*(g[1]-h.usrCoords[1])+(g[2]-h.usrCoords[2])*(g[2]-h.usrCoords[2]));return(Math.abs(j-f)<e)};JXG.Circle.prototype.generatePolynomial=function(k){var h=this.midpoint.symbolic.x;var g=this.midpoint.symbolic.y;var f=k.symbolic.x;var e=k.symbolic.y;var d=this.generateRadiusSquared();if(d==""){return[]}var j="(("+f+")-("+h+"))^2 + (("+e+")-("+g+"))^2 - ("+d+")";return[j]};JXG.Circle.prototype.generateRadiusSquared=function(){var e="";if(this.method=="twoPoints"){var g=this.midpoint.symbolic.x;var f=this.midpoint.symbolic.y;var j=this.point2.symbolic.x;var h=this.point2.symbolic.y;e="("+j+"-"+g+")^2 + ("+h+"-"+f+")^2"}else{if(this.method=="pointRadius"){if(typeof(this.radius)=="number"){e=""+this.radius*this.radius}}else{if(this.method=="pointLine"){var j=this.line.point1.symbolic.x;var h=this.line.point1.symbolic.y;var d=this.line.point2.symbolic.x;var k=this.line.point2.symbolic.y;e="("+j+"-"+d+")^2 + ("+h+"-"+k+")^2"}else{if(this.method=="pointCircle"){e=this.circle.Radius()}}}}return e};JXG.Circle.prototype.update=function(){if(this.traced){this.cloneToBackground(true)}if(this.needsUpdate){if(this.method=="pointLine"){this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(this.method=="pointCircle"){this.radius=this.circle.Radius()}else{if(this.method=="pointRadius"){this.radius=this.updateRadius()}}}if(!this.board.geonextCompatibilityMode){this.updateStdform();this.updateQuadraticform()}}};JXG.Circle.prototype.updateQuadraticform=function(){var d=this.midpoint,g=d.X(),f=d.Y(),e=this.Radius();this.quadraticform=[[g*g+f*f-e*e,-g,-f],[-g,1,0],[-f,0,1]]};JXG.Circle.prototype.updateStdform=function(){this.stdform[3]=0.5;this.stdform[4]=this.Radius();this.stdform[1]=-this.midpoint.coords.usrCoords[1];this.stdform[2]=-this.midpoint.coords.usrCoords[2];this.normalize()};JXG.Circle.prototype.updateRenderer=function(){if(this.needsUpdate&&this.visProp.visible){var d=this.isReal;this.isReal=(isNaN(this.midpoint.coords.usrCoords[1]+this.midpoint.coords.usrCoords[2]+this.Radius()))?false:true;if(this.isReal){if(d!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateCircle(this)}else{if(d!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Circle.prototype.generateTerm=function(e){if(typeof e=="string"){var f=this.board.elementsByName;var d=JXG.GeonextParser.geonext2JS(e+"",this.board);this.updateRadius=new Function("return "+d+";")}else{if(typeof e=="number"){this.updateRadius=function(){return e}}else{this.updateRadius=e}}};JXG.Circle.prototype.notifyParents=function(e){var d=null;var f=this.board.elementsByName;if(typeof e=="string"){JXG.GeonextParser.findDependencies(this,e+"",this.board)}};JXG.Circle.prototype.Radius=function(){if(this.method=="twoPoints"){return(Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))}else{if(this.method=="pointLine"||this.method=="pointCircle"){return this.radius}else{if(this.method=="pointRadius"){return this.updateRadius()}}}};JXG.Circle.prototype.getRadius=function(){return this.Radius()};JXG.Circle.prototype.getTextAnchor=function(){return this.midpoint.coords};JXG.Circle.prototype.getLabelAnchor=function(){if(this.method=="twoPoints"){var e=this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1];var d=this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2];return new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+e,this.midpoint.coords.usrCoords[2]+d],this.board)}else{if(this.method=="pointLine"||this.method=="pointCircle"||this.method=="pointRadius"){return new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]-this.Radius(),this.midpoint.coords.usrCoords[2]],this.board)}}};JXG.Circle.prototype.cloneToBackground=function(d){var f={};f.id=this.id+"T"+this.numTraces;this.numTraces++;f.midpoint={};f.midpoint.coords=this.midpoint.coords;var e=this.Radius();f.Radius=function(){return e};f.getRadius=function(){return e};f.board={};f.board.unitX=this.board.unitX;f.board.unitY=this.board.unitY;f.board.zoomX=this.board.zoomX;f.board.zoomY=this.board.zoomY;f.board.stretchX=this.board.stretchX;f.board.stretchY=this.board.stretchY;f.visProp=this.visProp;JXG.clearVisPropOld(f);this.board.renderer.drawCircle(f);this.traces[f.id]=this.board.renderer.getElementById(f.id);delete f};JXG.Circle.prototype.addTransform=function(d){var f;if(JXG.isArray(d)){f=d}else{f=[d]}for(var e=0;e<f.length;e++){this.midpoint.transformations.push(f[e]);if(this.method=="twoPoints"){this.point2.transformations.push(f[e])}}};JXG.Circle.prototype.setPosition=function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});this.addTransform(e)};JXG.Circle.prototype.X=function(d){d*=2*Math.PI;return this.Radius()*Math.cos(d)+this.midpoint.coords.usrCoords[1]};JXG.Circle.prototype.Y=function(d){d*=2*Math.PI;return this.Radius()*Math.sin(d)+this.midpoint.coords.usrCoords[2]};JXG.Circle.prototype.minX=function(){return 0};JXG.Circle.prototype.maxX=function(){return 1};JXG.Circle.prototype.Area=function(){var d=this.Radius();return d*d*Math.PI};JXG.createCircle=function(g,k,j){var f,h,e;j=JXG.checkAttributes(j,{withLabel:JXG.readOption(g.options,"circle","withLabel"),layer:null});h=[];for(e=0;e<k.length;e++){if(JXG.isPoint(k[e])){h[e]=k[e]}else{if(k[e].length>1){h[e]=g.create("point",k[e],{visible:false,fixed:true})}else{h[e]=k[e]}}}if(k.length==2&&JXG.isPoint(h[0])&&JXG.isPoint(h[1])){f=new JXG.Circle(g,"twoPoints",h[0],h[1],j.id,j.name,j.withLabel,j.layer)}else{if((JXG.isNumber(h[0])||JXG.isFunction(h[0])||JXG.isString(h[0]))&&JXG.isPoint(h[1])){f=new JXG.Circle(g,"pointRadius",h[1],h[0],j.id,j.name,j.withLabel,j.layer)}else{if((JXG.isNumber(h[1])||JXG.isFunction(h[1])||JXG.isString(h[1]))&&JXG.isPoint(h[0])){f=new JXG.Circle(g,"pointRadius",h[0],h[1],j.id,j.name,j.withLabel,j.layer)}else{if((h[0].type==JXG.OBJECT_TYPE_CIRCLE)&&JXG.isPoint(h[1])){f=new JXG.Circle(g,"pointCircle",h[1],h[0],j.id,j.name,j.withLabel,j.layer)}else{if((h[1].type==JXG.OBJECT_TYPE_CIRCLE)&&JXG.isPoint(h[0])){f=new JXG.Circle(g,"pointCircle",h[0],h[1],j.id,j.name,j.withLabel,j.layer)}else{if((h[0].type==JXG.OBJECT_TYPE_LINE)&&JXG.isPoint(h[1])){f=new JXG.Circle(g,"pointLine",h[1],h[0],j.id,j.name,j.withLabel,j.layer)}else{if((h[1].type==JXG.OBJECT_TYPE_LINE)&&JXG.isPoint(h[0])){f=new JXG.Circle(g,"pointLine",h[0],h[1],j.id,j.name,j.withLabel,j.layer)}else{if(k.length==3&&JXG.isPoint(h[0])&&JXG.isPoint(h[1])&&JXG.isPoint(h[2])){var d=JXG.createCircumcircle(g,h,j);d[0].setProperty({visible:false});return d[1]}else{throw new Error("JSXGraph: Can't create circle with parent types '"+(typeof k[0])+"' and '"+(typeof k[1])+"'.\nPossible parent types: [point,point], [point,number], [point,function], [point,circle], [point,point,point]")}}}}}}}}return f};JXG.JSXGraph.registerElement("circle",JXG.createCircle);JXG.createEllipse=function(l,n,k){var r=[],e,d,h,j;k=JXG.checkAttributes(k,{withLabel:JXG.readOption(l.options,"conic","withLabel"),layer:null});for(h=0;h<2;h++){if(n[h].length>1){r[h]=l.create("point",n[h],{visible:false,fixed:true})}else{if(JXG.isPoint(n[h])){r[h]=JXG.getReference(l,n[h])}else{if((typeof n[h]=="function")&&(n[h]().elementClass==JXG.OBJECT_CLASS_POINT)){r[h]=n[h]()}else{if(JXG.isString(n[h])){r[h]=JXG.getReference(l,n[h])}else{throw new Error("JSXGraph: Can't create Ellipse with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}}if(JXG.isNumber(n[2])){d=JXG.createFunction(n[2],l)}else{if((typeof n[2]=="function")&&(JXG.isNumber(n[2]()))){d=n[2]}else{if(JXG.isPoint(n[2])){e=JXG.getReference(l,n[2])}else{if(n[2].length>1){e=l.create("point",n[2],{visible:false,fixed:true})}else{if((typeof n[2]=="function")&&(n[2]().elementClass==JXG.OBJECT_CLASS_POINT)){e=n[2]()}else{if(JXG.isString(n[2])){e=JXG.getReference(l,n[2])}else{throw new Error("JSXGraph: Can't create Ellipse with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"' and '"+(typeof n[2])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}d=function(){return e.Dist(r[0])+e.Dist(r[1])}}}if(typeof n[4]=="undefined"){n[4]=1.0001*Math.PI}if(typeof n[3]=="undefined"){n[3]=-1.0001*Math.PI}k=JXG.checkAttributes(k,{curveType:"parameter"});var m=l.create("point",[function(){return(r[0].X()+r[1].X())*0.5},function(){return(r[0].Y()+r[1].Y())*0.5}],{visible:false,name:"",withLabel:false});var q=function(){var s=r[0].X(),A=r[0].Y(),x=r[1].X(),w=r[1].Y(),z,y,v;var u=(x-s>0)?1:-1;if(Math.abs(x-s)>1e-7){z=Math.atan2(w-A,x-s)+((u<0)?Math.PI:0)}else{z=((w-A>0)?0.5:-0.5)*Math.PI}y=Math.cos(z);v=Math.sin(z);var t=[[1,0,0],[m.X(),y,-v],[m.Y(),v,y]];return t};var f=l.create("curve",[function(s){return 0},function(s){return 0},n[3],n[4]],k);var g=function(v,t){var z=d()*0.5,s=z*z,u=r[1].Dist(r[0])*0.5,w=s-u*u,y=Math.sqrt(w),x=[[1,0,0],[0,1,0],[0,0,1]],B,A;if(!t){j=q();B=m.X();A=m.Y();x[0][0]=j[0][0];x[0][1]=0;x[0][2]=0;x[1][0]=B*(1-j[1][1])+A*j[1][2];x[1][1]=j[1][1];x[1][2]=j[2][1];x[2][0]=A*(1-j[1][1])-B*j[1][2];x[2][1]=j[1][2];x[2][2]=j[2][2];f.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(x),JXG.Math.matMatMult([[-1+B*B/(z*z)+A*A/w,-B/s,-B/w],[-B/s,1/s,0],[-A/w,0,1/w]],x))}return JXG.Math.matVecMult(j,[1,z*Math.cos(v),y*Math.sin(v)])};f.X=function(s,t){return g(s,t)[1]};f.Y=function(s,t){return g(s,t)[2]};f.midpoint=m;f.type=JXG.OBJECT_TYPE_CONIC;return f};JXG.createHyperbola=function(l,n,k){var r=[],e,d,h,j;k=JXG.checkAttributes(k,{withLabel:JXG.readOption(l.options,"conic","withLabel"),layer:null});for(h=0;h<2;h++){if(n[h].length>1){r[h]=l.create("point",n[h],{visible:false,fixed:true})}else{if(JXG.isPoint(n[h])){r[h]=JXG.getReference(l,n[h])}else{if((typeof n[h]=="function")&&(n[h]().elementClass==JXG.OBJECT_CLASS_POINT)){r[h]=n[h]()}else{if(JXG.isString(n[h])){r[h]=JXG.getReference(l,n[h])}else{throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}}if(JXG.isNumber(n[2])){d=JXG.createFunction(n[2],l)}else{if((typeof n[2]=="function")&&(JXG.isNumber(n[2]()))){d=n[2]}else{if(JXG.isPoint(n[2])){e=JXG.getReference(l,n[2])}else{if(n[2].length>1){e=l.create("point",n[2],{visible:false,fixed:true})}else{if((typeof n[2]=="function")&&(n[2]().elementClass==JXG.OBJECT_CLASS_POINT)){e=n[2]()}else{if(JXG.isString(n[2])){e=JXG.getReference(l,n[2])}else{throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"' and '"+(typeof n[2])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}d=function(){return e.Dist(r[0])-e.Dist(r[1])}}}if(typeof n[4]=="undefined"){n[4]=1.0001*Math.PI}if(typeof n[3]=="undefined"){n[3]=-1.0001*Math.PI}k=JXG.checkAttributes(k,{curveType:"parameter"});var m=l.create("point",[function(){return(r[0].X()+r[1].X())*0.5},function(){return(r[0].Y()+r[1].Y())*0.5}],{visible:false,name:"",withLabel:false});var q=function(){var u=r[0].X(),t=r[0].Y(),y=r[1].X(),w=r[1].Y(),v;var x=(y-u>0)?1:-1;if(Math.abs(y-u)>1e-7){v=Math.atan2(w-t,y-u)+((x<0)?Math.PI:0)}else{v=((w-t>0)?0.5:-0.5)*Math.PI}var s=[[1,0,0],[m.X(),Math.cos(v),-Math.sin(v)],[m.Y(),Math.sin(v),Math.cos(v)]];return s};var f=l.create("curve",[function(s){return 0},function(s){return 0},n[3],n[4]],k);var g=function(v,t){var z=d()*0.5,s=z*z,u=r[1].Dist(r[0])*0.5,y=Math.sqrt(-z*z+u*u),w=y*y,x=[[1,0,0],[0,1,0],[0,0,1]],B,A;if(!t){j=q();B=m.X();A=m.Y();x[0][0]=j[0][0];x[0][1]=0;x[0][2]=0;x[1][0]=B*(1-j[1][1])+A*j[1][2];x[1][1]=j[1][1];x[1][2]=j[2][1];x[2][0]=A*(1-j[1][1])-B*j[1][2];x[2][1]=j[1][2];x[2][2]=j[2][2];f.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(x),JXG.Math.matMatMult([[-1+B*B/s+A*A/w,-B/s,A/w],[-B/s,1/s,0],[A/w,0,-1/w]],x))}return JXG.Math.matVecMult(j,[1,z/Math.cos(v),y*Math.tan(v)])};f.X=function(s,t){return g(s,t)[1]};f.Y=function(s,t){return g(s,t)[2]};f.midpoint=m;f.type=JXG.OBJECT_TYPE_CONIC;return f};JXG.createParabola=function(k,n,j){var h=n[0],e=n[1],g;j=JXG.checkAttributes(j,{withLabel:JXG.readOption(k.options,"conic","withLabel"),layer:null});if(n[0].length>1){h=k.create("point",n[0],{visible:false,fixed:true})}else{if(JXG.isPoint(n[0])){h=JXG.getReference(k,n[0])}else{if((typeof n[0]=="function")&&(n[0]().elementClass==JXG.OBJECT_CLASS_POINT)){h=n[0]()}else{if(JXG.isString(n[0])){h=JXG.getReference(k,n[0])}else{throw new Error("JSXGraph: Can't create Parabola with parent types '"+(typeof n[0])+"' and '"+(typeof n[1])+"'.\nPossible parent types: [point,line]")}}}}if(typeof n[3]=="undefined"){n[3]=10}if(typeof n[2]=="undefined"){n[2]=-10}j=JXG.checkAttributes(j,{curveType:"parameter"});var m=k.create("point",[function(){var l=[0,e.stdform[1],e.stdform[2]];l=JXG.Math.crossProduct(l,h.coords.usrCoords);return JXG.Math.Geometry.meetLineLine(l,e.stdform,0,k).usrCoords}],{visible:false,name:"",withLabel:false});var q=function(){var s=Math.atan(e.getSlope()),r=(m.X()+h.X())*0.5,t=(m.Y()+h.Y())*0.5;s+=(h.Y()-m.Y()<0||(h.Y()==m.Y()&&h.X()>m.X()))?Math.PI:0;var l=[[1,0,0],[r*(1-Math.cos(s))+t*Math.sin(s),Math.cos(s),-Math.sin(s)],[t*(1-Math.cos(s))-r*Math.sin(s),Math.sin(s),Math.cos(s)]];return l};var d=k.create("curve",[function(l){return 0},function(l){return 0},n[2],n[3]],j);var f=function(u,v){var w=m.Dist(h)*0.5,s=[[1,0,0],[0,1,0],[0,0,1]],r=(m.X()+h.X())*0.5,l=(m.Y()+h.Y())*0.5;if(!v){g=q();s[0][0]=g[0][0];s[0][1]=0;s[0][2]=0;s[1][0]=r*(1-g[1][1])+l*g[1][2];s[1][1]=g[1][1];s[1][2]=g[2][1];s[2][0]=l*(1-g[1][1])-r*g[1][2];s[2][1]=g[1][2];s[2][2]=g[2][2];d.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(s),JXG.Math.matMatMult([[-l*4*w-r*r,r,2*w],[r,-1,0],[2*w,0,0]],s))}return JXG.Math.matVecMult(g,[1,u+r,u*u/(w*4)+l])};d.X=function(l,r){return f(l,r)[1]};d.Y=function(l,r){return f(l,r)[2]};d.type=JXG.OBJECT_TYPE_CONIC;return d};JXG.createConic=function(e,v,n){var g=[[1,0,0],[0,1,0],[0,0,1]],A,y,x,w,f=[[1,0,0],[0,1,0],[0,0,1]],q,m,s=[],t,r,z,l=[];if(v.length==5){z=true}else{if(v.length==6){z=false}else{throw new Error("JSXGraph: Can't create generic Conic with "+parent.length+" parameters.")}}n=JXG.checkAttributes(n,{withLabel:JXG.readOption(e.options,"conic","withLabel"),layer:null});if(z){for(t=0;t<5;t++){if(v[t].length>1){s[t]=e.create("point",v[t],{visible:false,fixed:true})}else{if(JXG.isPoint(v[t])){s[t]=JXG.getReference(e,v[t])}else{if((typeof v[t]=="function")&&(v[t]().elementClass==JXG.OBJECT_CLASS_POINT)){s[t]=v[t]()}else{if(JXG.isString(v[t])){s[t]=JXG.getReference(e,v[t])}else{throw new Error("JSXGraph: Can't create Conic section with parent types '"+(typeof v[t])+"'.\nPossible parent types: [point,point,point,point,point], [a00,a11,a22,a01,a02,a12]")}}}}}}else{r=[[0,0,0],[0,0,0],[0,0,0]];r[0][0]=(JXG.isFunction(v[2]))?function(){return v[2]()}:function(){return v[2]};r[0][1]=(JXG.isFunction(v[4]))?function(){return v[4]()}:function(){return v[4]};r[0][2]=(JXG.isFunction(v[5]))?function(){return v[5]()}:function(){return v[5]};r[1][1]=(JXG.isFunction(v[0]))?function(){return v[0]()}:function(){return v[0]};r[1][2]=(JXG.isFunction(v[3]))?function(){return v[3]()}:function(){return v[3]};r[2][2]=(JXG.isFunction(v[1]))?function(){return v[1]()}:function(){return v[1]}}var h=function(B){var D,C;for(D=0;D<3;D++){for(C=D;C<3;C++){B[D][C]+=B[C][D]}}for(D=0;D<3;D++){for(C=0;C<D;C++){B[D][C]=B[C][D]}}return B};var k=function(C,B){var F,D,E=[[0,0,0],[0,0,0],[0,0,0]];for(F=0;F<3;F++){for(D=0;D<3;D++){E[F][D]=C[F]*B[D]}}return h(E)};var u=function(F,D,E){var I,J,C,K=[[0,0,0],[0,0,0],[0,0,0]],H,G;C=JXG.Math.matVecMult(D,E);I=JXG.Math.innerProduct(E,C);C=JXG.Math.matVecMult(F,E);J=JXG.Math.innerProduct(E,C);for(H=0;H<3;H++){for(G=0;G<3;G++){K[H][G]=I*F[H][G]-J*D[H][G]}}return K};var j=e.create("curve",[function(B){return 0},function(B){return 0},0,2*Math.PI],n);var d=function(F,G){var E,D,B,C;if(!G){if(z){for(E=0;E<5;E++){l[E]=s[E].coords.usrCoords}q=k(JXG.Math.crossProduct(l[0],l[1]),JXG.Math.crossProduct(l[2],l[3]));m=k(JXG.Math.crossProduct(l[0],l[2]),JXG.Math.crossProduct(l[1],l[3]));f=u(q,m,l[4])}else{for(E=0;E<3;E++){for(D=E;D<3;D++){f[E][D]=r[E][D]();if(D>E){f[D][E]=f[E][D]}}}}j.quadraticform=f;A=JXG.Math.Numerics.Jacobi(f);if(A[0][0][0]<0){A[0][0][0]*=(-1);A[0][1][1]*=(-1);A[0][2][2]*=(-1)}for(E=0;E<3;E++){B=0;for(D=0;D<3;D++){B+=A[1][D][E]*A[1][D][E]}B=Math.sqrt(B);for(D=0;D<3;D++){}}g=A[1];w=Math.sqrt(Math.abs(A[0][0][0]));y=Math.sqrt(Math.abs(A[0][1][1]));x=Math.sqrt(Math.abs(A[0][2][2]))}if(A[0][1][1]<0&&A[0][2][2]<0){C=JXG.Math.matVecMult(g,[1/w,Math.cos(F)/y,Math.sin(F)/x])}else{if(A[0][1][1]<0&&A[0][2][2]>0){C=JXG.Math.matVecMult(g,[Math.cos(F)/w,1/y,Math.sin(F)/x])}else{if(A[0][2][2]<0){C=JXG.Math.matVecMult(g,[Math.sin(F)/w,Math.cos(F)/y,1/x])}}}C[1]/=C[0];C[2]/=C[0];C[0]=1;return C};j.X=function(B,C){return d(B,C)[1]};j.Y=function(B,C){return d(B,C)[2]};j.midpoint=e.create("point",[function(){var B=j.quadraticform;return[B[1][1]*B[2][2]-B[1][2]*B[1][2],B[1][2]*B[0][2]-B[2][2]*B[0][1],B[0][1]*B[1][2]-B[1][1]*B[0][2]]}],{name:"",visible:false});j.type=JXG.OBJECT_TYPE_CONIC;return j};JXG.JSXGraph.registerElement("ellipse",JXG.createEllipse);JXG.JSXGraph.registerElement("hyperbola",JXG.createHyperbola);JXG.JSXGraph.registerElement("parabola",JXG.createParabola);JXG.JSXGraph.registerElement("conic",JXG.createConic);JXG.Polygon=function(q,r,s,f,e,g,d,k,n){this.constructor();this.type=JXG.OBJECT_TYPE_POLYGON;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(q,f,e);if(n==null){n=q.options.layer.polygon}this.layer=n;if((typeof g=="undefined")||(g==null)){g=true}if((typeof k=="undefined")||(k==null)){k=false}this.withLines=g;this.vertices=[];for(var j=0;j<r.length;j++){var m=JXG.getReference(this.board,r[j]);this.vertices[j]=m}if((typeof s=="undefined")||(s==null)){s=[];for(var j=0;j<r.length-1;j++){s[j]={}}}if(this.vertices[this.vertices.length-1]!=this.vertices[0]){this.vertices.push(this.vertices[0]);s.push({})}this.visProp.fillColor=this.board.options.polygon.fillColor;this.visProp.highlightFillColor=this.board.options.polygon.highlightFillColor;this.visProp.fillOpacity=this.board.options.polygon.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.polygon.highlightFillOpacity;var h;this.borders=[];if(g){for(var j=0;j<this.vertices.length-1;j++){h=new JXG.Line(q,this.vertices[j],this.vertices[j+1],s[j].id,s[j].name,k,this.layer+1);h.setStraight(false,false);this.borders[j]=h;h.parentPolygon=this}}for(var j=0;j<this.vertices.length-1;j++){var m=JXG.getReference(this.board,this.vertices[j]);m.addChild(this)}this.createLabel(d,[0,0]);this.id=this.board.addPolygon(this)};JXG.Polygon.prototype=new JXG.GeometryElement;JXG.Polygon.prototype.hasPoint=function(d,e){return false};JXG.Polygon.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updatePolygon(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}};JXG.Polygon.prototype.getTextAnchor=function(){var f=0;var e=0;var d=0;var h=0;f=d=this.vertices[0].X();e=h=this.vertices[0].Y();for(var g=0;g<this.vertices.length;g++){if(this.vertices[g].X()<f){f=this.vertices[g].X()}if(this.vertices[g].X()>d){d=this.vertices[g].X()}if(this.vertices[g].Y()>e){e=this.vertices[g].Y()}if(this.vertices[g].Y()<h){h=this.vertices[g].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(f+d)*0.5,(e+h)*0.5],this.board)};JXG.Polygon.prototype.getLabelAnchor=function(){var f=0;var e=0;var d=0;var h=0;f=d=this.vertices[0].X();e=h=this.vertices[0].Y();for(var g=0;g<this.vertices.length;g++){if(this.vertices[g].X()<f){f=this.vertices[g].X()}if(this.vertices[g].X()>d){d=this.vertices[g].X()}if(this.vertices[g].Y()>e){e=this.vertices[g].Y()}if(this.vertices[g].Y()<h){h=this.vertices[g].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(f+d)*0.5,(e+h)*0.5],this.board)};JXG.Polygon.prototype.cloneToBackground=function(d){var e={};e.id=this.id+"T"+this.numTraces;this.numTraces++;e.vertices=this.vertices;e.visProp=this.visProp;JXG.clearVisPropOld(e);this.board.renderer.drawPolygon(e);this.traces[e.id]=$(e.id);delete e};JXG.createPolygon=function(g,d,h){var f,e;h=JXG.checkAttributes(h,{withLabel:JXG.readOption(g.options,"polygon","withLabel"),layer:null});for(e=0;e<d.length;e++){d[e]=JXG.getReference(g,d[e]);if(!JXG.isPoint(d[e])){throw new Error("JSXGraph: Can't create polygon with parent types other than 'point'.")}}f=new JXG.Polygon(g,d,h.borders,h.id,h.name,h.withLines,h.withLabel,h.lineLabels,h.layer);return f};JXG.JSXGraph.registerElement("polygon",JXG.createPolygon);JXG.Polygon.prototype.hideElement=function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.withLines){for(var d=0;d<this.borders.length;d++){this.borders[d].hideElement()}}if(this.hasLabel&&this.label!=null){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}};JXG.Polygon.prototype.showElement=function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.withLines){for(var d=0;d<this.borders.length;d++){this.borders[d].showElement()}}};JXG.Polygon.prototype.Area=function(){var e=0,d;for(d=0;d<this.vertices.length-1;d++){e+=(this.vertices[d].X()*this.vertices[d+1].Y()-this.vertices[d+1].X()*this.vertices[d].Y())}e/=2;return Math.abs(e)};JXG.createRegularPolygon=function(l,r,k){var f,h,g,d=[],e,q,j,m;k=JXG.checkAttributes(k,{withLabel:JXG.readOption(l.options,"polygon","withLabel"),layer:null});if(JXG.isNumber(r[r.length-1])&&r.length!=3){throw new Error("JSXGraph: A regular polygon needs two point and a number as input.")}j=r.length;g=r[j-1];if((!JXG.isNumber(g)&&!JXG.isPoint(JXG.getReference(l,g)))||g<3){throw new Error("JSXGraph: The third parameter has to be number greater than 2 or a point.")}if(JXG.isPoint(JXG.getReference(l,g))){g=j;m=true}else{j--;m=false}for(h=0;h<j;h++){r[h]=JXG.getReference(l,r[h]);if(!JXG.isPoint(r[h])){throw new Error("JSXGraph: Can't create regular polygon if the first two parameters aren't points.")}}d[0]=r[0];d[1]=r[1];for(h=2;h<g;h++){e=l.create("transform",[Math.PI*(2-(g-2)/g),d[h-1]],{type:"rotate"});if(m){d[h]=r[h];d[h].addTransform(r[h-2],e)}else{d[h]=l.create("point",[d[h-2],e],{name:"",withLabel:false,fixed:true,face:"o",size:1})}}f=l.create("polygon",d,k);return f};JXG.JSXGraph.registerElement("regularpolygon",JXG.createRegularPolygon);JXG.Curve=function(h,e,j,d,g,f){this.constructor();this.points=[];this.type=JXG.OBJECT_TYPE_CURVE;this.elementClass=JXG.OBJECT_CLASS_CURVE;this.init(h,j,d);if(f==null){f=h.options.layer.curve}this.layer=f;this.doAdvancedPlot=this.board.options.curve.doAdvancedPlot;this.numberPointsHigh=this.board.options.curve.numberPointsHigh;this.numberPointsLow=this.board.options.curve.numberPointsLow;this.numberPoints=this.numberPointsHigh;this.visProp.strokeWidth=this.board.options.curve.strokeWidth;this.visProp.highlightStrokeWidth=this.visProp.strokeWidth;this.visProp.visible=true;this.dataX=null;this.dataY=null;this.curveType=null;if(e[0]!=null){this.varname=e[0]}else{this.varname="x"}this.xterm=e[1];this.yterm=e[2];this.generateTerm(this.varname,this.xterm,this.yterm,e[3],e[4]);this.updateCurve();this.createLabel(g);this.id=this.board.addCurve(this);if(typeof this.xterm=="string"){this.notifyParents(this.xterm)}if(typeof this.yterm=="string"){this.notifyParents(this.yterm)}};JXG.Curve.prototype=new JXG.GeometryElement;JXG.Curve.prototype.minX=function(){if(this.curveType=="polar"){return 0}else{var d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board);return d.usrCoords[1]}};JXG.Curve.prototype.maxX=function(){var d;if(this.curveType=="polar"){return 2*Math.PI}else{d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.board.canvasWidth,0],this.board);return d.usrCoords[1]}};JXG.Curve.prototype.hasPoint=function(u,s){var v,C=Infinity,K,m,E,D,z,w,A,f,L,B,q,I,l,H,h,n,r,G=this.numberPointsLow,J=(this.maxX()-this.minX())/G,e=this.board.options.precision.hasPoint/(this.board.unitX*this.board.zoomX),g,F,k=true;e=e*e;g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[u,s],this.board);u=g.usrCoords[1];s=g.usrCoords[2];if(this.curveType=="parameter"||this.curveType=="polar"||this.curveType=="functiongraph"){F=this.transformations.length;for(E=0,v=this.minX();E<G;E++){z=this.X(v,k);w=this.Y(v,k);for(D=0;D<F;D++){m=this.transformations[D];m.update();K=JXG.Math.matVecMult(m.matrix,[1,z,w]);z=K[1];w=K[2]}C=(u-z)*(u-z)+(s-w)*(s-w);if(C<e){return true}v+=J}}else{if(this.curveType=="plot"){F=this.numberPoints;for(E=0;E<F-1;E++){A=this.X(E);f=this.X(E+1);L=this.Y(E);B=this.Y(E+1);H=f-A;h=B-L;I=u-A;l=s-L;r=H*H+h*h;if(r>=JXG.Math.eps){n=I*H+l*h;q=n/r;C=I*I+l*l-q*n}else{q=0;C=I*I+l*l}if(q>=0&&q<=1&&C<e){return true}}return false}}return(C<e)};JXG.Curve.prototype.allocatePoints=function(){var e,d;d=this.numberPoints;if(this.points.length<this.numberPoints){for(e=this.points.length;e<d;e++){this.points[e]=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)}}};JXG.Curve.prototype.update=function(){if(this.needsUpdate){this.updateCurve()}if(this.traced){this.cloneToBackground(true)}return this};JXG.Curve.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateCurve(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}return this};JXG.Curve.prototype.updateDataArray=function(){return this};JXG.Curve.prototype.updateCurve=function(){var e,f,k,d,j,g,h=false;this.updateDataArray();f=this.minX();k=this.maxX();if(this.dataX!=null){this.numberPoints=this.dataX.length;e=this.numberPoints;this.allocatePoints();for(g=0;g<e;g++){d=g;if(this.dataY!=null){j=g}else{j=this.X(d)}this.points[g].setCoordinates(JXG.COORDS_BY_USER,[this.X(d,h),this.Y(j,h)],false);this.updateTransform(this.points[g]);h=true}}else{if(this.doAdvancedPlot){this.updateParametricCurve(f,k,e)}else{if(this.board.updateQuality==this.board.BOARD_QUALITY_HIGH){this.numberPoints=this.numberPointsHigh}else{this.numberPoints=this.numberPointsLow}e=this.numberPoints;this.allocatePoints();this.updateParametricCurveNaive(f,k,e)}}this.getLabelAnchor();return this};JXG.Curve.prototype.updateParametricCurveNaive=function(f,k,e){var h,g,j=false,d=(k-f)/e;for(h=0;h<e;h++){g=f+h*d;this.points[h].setCoordinates(JXG.COORDS_BY_USER,[this.X(g,j),this.Y(g,j)],false);this.updateTransform(this.points[h]);j=true}return this};JXG.Curve.prototype.updateParametricCurve=function(E,d,A){var w,n,m,f=false,z=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board),l,k,C,e,q,G,F,s,h,v=[],g=[],D=[],B=[],r=false,u=0;if(this.board.updateQuality==this.board.BOARD_QUALITY_LOW){F=12;s=12;h=12}else{F=20;s=2;h=2}B[0]=d-E;for(w=1;w<F;w++){B[w]=B[w-1]*0.5}w=1;v[0]=1;g[0]=0;n=E;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(n,f),this.Y(n,f)],false);f=true;C=z.scrCoords[1];e=z.scrCoords[2];m=n;n=d;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(n,f),this.Y(n,f)],false);l=z.scrCoords[1];k=z.scrCoords[2];D[0]=[l,k];q=1;G=0;this.points=[];this.points[u++]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[C,e],this.board);do{r=this.isDistOK(C,e,l,k,s,h)||this.isSegmentOutside(C,e,l,k);while(G<F&&(!r||G<3)&&!(!this.isSegmentDefined(C,e,l,k)&&G>8)){v[q]=w;g[q]=G;D[q]=[l,k];q++;w=2*w-1;G++;n=E+w*B[G];z.setCoordinates(JXG.COORDS_BY_USER,[this.X(n,f),this.Y(n,f)],false);l=z.scrCoords[1];k=z.scrCoords[2];r=this.isDistOK(C,e,l,k,s,h)||this.isSegmentOutside(C,e,l,k)}this.points[u]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,k],this.board);this.updateTransform(this.points[u]);u++;C=l;e=k;m=n;q--;l=D[q][0];k=D[q][1];G=g[q]+1;w=v[q]*2}while(q!=0);this.numberPoints=this.points.length;return this};JXG.Curve.prototype.isSegmentOutside=function(e,g,d,f){if(g<0&&f<0){return true}else{if(g>this.board.canvasHeight&&f>this.board.canvasHeight){return true}else{if(e<0&&d<0){return true}else{if(e>this.board.canvasWidth&&d>this.board.canvasWidth){return true}}}}return false};JXG.Curve.prototype.isDistOK=function(g,j,f,h,e,d){if(isNaN(g+j+f+h)){return false}return(Math.abs(f-g)<d&&Math.abs(h-j)<d)};JXG.Curve.prototype.isSegmentDefined=function(e,g,d,f){if(isNaN(e+g)&&isNaN(d+f)){return false}return true};JXG.Curve.prototype.updateTransform=function(g){var f,h,e,d=this.transformations.length;if(d==0){return g}for(e=0;e<d;e++){f=this.transformations[e];f.update();h=JXG.Math.matVecMult(f.matrix,g.usrCoords);g.setCoordinates(JXG.COORDS_BY_USER,[h[1],h[2]])}return g};JXG.Curve.prototype.addTransform=function(e){var g,f,d;if(JXG.isArray(e)){g=e}else{g=[e]}d=g.length;for(f=0;f<d;f++){this.transformations.push(g[f])}return this};JXG.Curve.prototype.setPosition=function(g,d,f){var e=this.board.create("transform",[d,f],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(e)}else{this.addTransform(e)}return this};JXG.Curve.prototype.generateTerm=function(e,j,f,d,k){var h,g;if(JXG.isArray(j)){this.dataX=j;this.X=function(l){return this.dataX[l]};this.curveType="plot";this.numberPoints=this.dataX.length}else{this.X=JXG.createFunction(j,this.board,e);if(JXG.isString(j)){this.curveType="functiongraph"}else{if(JXG.isFunction(j)||JXG.isNumber(j)){this.curveType="parameter"}}}if(JXG.isArray(f)){this.dataY=f;this.Y=function(l){if(JXG.isFunction(this.dataY[l])){return this.dataY[l]()}else{return this.dataY[l]}}}else{this.Y=JXG.createFunction(f,this.board,e)}if(JXG.isFunction(j)&&JXG.isArray(f)){h=JXG.createFunction(f[0],this.board,"");g=JXG.createFunction(f[1],this.board,"");this.X=function(l){return(j)(l)*Math.cos(l)+h()};this.Y=function(l){return(j)(l)*Math.sin(l)+g()};this.curveType="polar"}if(d!=null){this.minX=JXG.createFunction(d,this.board,"")}if(k!=null){this.maxX=JXG.createFunction(k,this.board,"")}};JXG.Curve.prototype.notifyParents=function(d){JXG.GeonextParser.findDependencies(this,d,this.board)};JXG.Curve.prototype.getLabelAnchor=function(){var d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,this.board.canvasHeight*0.5],this.board);d=JXG.Math.Geometry.projectCoordsToCurve(d.usrCoords[1],d.usrCoords[2],0,this,this.board)[0];return d};JXG.Curve.prototype.cloneToBackground=function(f){var h={},g,e,d;h.id=this.id+"T"+this.numTraces;h.elementClass=JXG.OBJECT_CLASS_CURVE;this.numTraces++;h.points=this.points.slice(0);h.numberPoints=this.numberPoints;h.curveType=this.curveType;JXG.clearVisPropOld(h);h.board={};h.board.unitX=this.board.unitX;h.board.unitY=this.board.unitY;h.board.zoomX=this.board.zoomX;h.board.zoomY=this.board.zoomY;h.board.stretchX=this.board.stretchX;h.board.stretchY=this.board.stretchY;h.board.origin=this.board.origin;h.board.canvasHeight=this.board.canvasHeight;h.board.canvasWidth=this.board.canvasWidth;h.board.dimension=this.board.dimension;h.board.algebra=this.board.algebra;h.board.options=this.board.options;h.visProp=this.visProp;this.board.renderer.enhancedRendering=true;this.board.renderer.drawCurve(h);this.board.renderer.enhancedRendering=false;this.traces[h.id]=this.board.renderer.getElementById(h.id);delete h};JXG.createCurve=function(f,e,d){d=JXG.checkAttributes(d,{withLabel:JXG.readOption(f.options,"curve","withLabel"),layer:null});return new JXG.Curve(f,["x"].concat(e),d.id,d.name,d.withLabel,d.layer)};JXG.JSXGraph.registerElement("curve",JXG.createCurve);JXG.createFunctiongraph=function(g,e,d){var f=["x","x"].concat(e);d=JXG.checkAttributes(d,{withLabel:JXG.readOption(g.options,"curve","withLabel"),layer:null});d.curveType="functiongraph";return new JXG.Curve(g,f,d.id,d.name,d.withLabel,d.layer)};JXG.JSXGraph.registerElement("functiongraph",JXG.createFunctiongraph);JXG.createSpline=function(f,e,d){var g;d=JXG.checkAttributes(d,{withLabel:JXG.readOption(f.options,"curve","withLabel"),layer:null});g=function(){var k,h=[],l=[];var j=function(r,q){var n,m;if(!q){h=[];l=[];if(e.length==2&&JXG.isArray(e[0])&&JXG.isArray(e[1])&&e[0].length==e[1].length){for(n=0;n<e[0].length;n++){if(typeof e[0][n]=="function"){h.push(e[0][n]())}else{h.push(e[0][n])}if(typeof e[1][n]=="function"){l.push(e[1][n]())}else{l.push(e[1][n])}}}else{for(n=0;n<e.length;n++){if(JXG.isPoint(e[n])){h.push(e[n].X());l.push(e[n].Y())}else{if(JXG.isArray(e[n])&&e[n].length==2){for(n=0;n<e.length;n++){if(typeof e[n][0]=="function"){h.push(e[n][0]())}else{h.push(e[n][0])}if(typeof e[n][1]=="function"){l.push(e[n][1]())}else{l.push(e[n][1])}}}}}}k=JXG.Math.Numerics.splineDef(h,l)}return JXG.Math.Numerics.splineEval(r,h,l,k)};return j};return new JXG.Curve(f,["x","x",g()],d.id,d.name,d.withLabel,d.layer)};JXG.JSXGraph.registerElement("spline",JXG.createSpline);JXG.createRiemannsum=function(j,e,d){var m,h,k,g,l;d=JXG.checkAttributes(d,{withLabel:JXG.readOption(j.options,"curve","withLabel"),layer:null,fillOpacity:0.3,fillColor:"#ffff00",curveType:"plot"});k=e[0];m=JXG.createFunction(e[1],j,"");if(m==null){throw new Error("JSXGraph: JXG.createRiemannsum: argument '2' n has to be number or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]")}h=JXG.createFunction(e[2],j,"",false);if(h==null){throw new Error("JSXGraph: JXG.createRiemannsum: argument 3 'type' has to be string or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]")}g=["x",[0],[0]].concat(e.slice(3));l=new JXG.Curve(j,g,d.id,d.name,d.withLabel,d.layer);l.updateDataArray=function(){var f=JXG.Math.Numerics.riemann(k,m(),h(),this.minX(),this.maxX());this.dataX=f[0];this.dataY=f[1]};return l};JXG.JSXGraph.registerElement("riemannsum",JXG.createRiemannsum);JXG.createArc=function(j,f,d){var h,k,g,e;if(!(JXG.isPoint(f[0])&&JXG.isPoint(f[1])&&JXG.isPoint(f[2]))){throw new Error("JSXGraph: Can't create Arc with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.\nPossible parent types: [point,point,point]")}k={withLabel:JXG.readOption(j.options,"elements","withLabel"),layer:JXG.readOption(j.options,"layer","arc"),useDirection:false};k.strokeWidth=j.options.elements.strokeWidth;e=j.options.arc;for(g in e){k[g]=e[g]}d=JXG.checkAttributes(d,k);h=j.create("curve",[[0],[0]],d);h.type=JXG.OBJECT_TYPE_ARC;h.midpoint=JXG.getReference(j,f[0]);h.point2=JXG.getReference(j,f[1]);h.point3=JXG.getReference(j,f[2]);h.midpoint.addChild(h);h.point2.addChild(h);h.point3.addChild(h);h.useDirection=d.useDirection;h.updateDataArray=function(){var E=this.point2,D=this.midpoint,z=this.point3,J,r,L,G,l=JXG.Math.Geometry.rad(E,D,z),H,F=Math.ceil(l/Math.PI*90)+1,K=l/F,t=D.X(),s=D.Y(),u,q,m,w,I;if(this.useDirection){m=f[1].coords.usrCoords;w=f[3].coords.usrCoords;I=f[2].coords.usrCoords;q=(m[1]-I[1])*(m[2]-w[2])-(m[2]-I[2])*(m[1]-w[1]);if(q<0){this.point2=f[1];this.point3=f[2]}else{this.point2=f[2];this.point3=f[1]}}this.dataX=[E.X()];this.dataY=[E.Y()];for(J=K,H=1;H<=F;H++,J+=K){r=Math.cos(J);L=Math.sin(J);G=[[1,0,0],[t*(1-r)+s*L,r,-L],[s*(1-r)-t*L,L,r]];u=JXG.Math.matVecMult(G,E.coords.usrCoords);this.dataX.push(u[1]/u[0]);this.dataY.push(u[2]/u[0])}};h.Radius=function(){return this.point2.Dist(this.midpoint)};h.getRadius=function(){return this.Radius()};h.hasPoint=function(l,v){var n=this.board.options.precision.hasPoint/(this.board.stretchX),u=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,v],this.board),q=this.Radius(),t=this.midpoint.coords.distance(JXG.COORDS_BY_USER,u),m=(Math.abs(t-q)<n),s;if(m){s=JXG.Math.Geometry.rad(this.point2,this.midpoint,u.usrCoords.slice(1));if(s>JXG.Math.Geometry.rad(this.point2,this.midpoint,this.point3)){m=false}}return m};h.hasPointSector=function(l,u){var t=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,u],this.board),n=this.Radius(),s=this.midpoint.coords.distance(JXG.COORDS_BY_USER,t),m=(s<n),q;if(m){q=JXG.Math.Geometry.rad(this.point2,this.midpoint,t.usrCoords.slice(1));if(q>JXG.Math.Geometry.rad(this.point2,this.midpoint,this.point3)){m=false}}return m};h.getTextAnchor=function(){return this.midpoint.coords};h.getLabelAnchor=function(){var n=JXG.Math.Geometry.rad(this.point2,this.midpoint,this.point3),x=10/(this.board.stretchX),v=10/(this.board.stretchY),t=this.point2.coords.usrCoords,l=this.midpoint.coords.usrCoords,m=t[1]-l[1],w=t[2]-l[2],u,r,q,s;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}u=new JXG.Coords(JXG.COORDS_BY_USER,[l[1]+Math.cos(n*0.5)*m-Math.sin(n*0.5)*w,l[2]+Math.sin(n*0.5)*m+Math.cos(n*0.5)*w],this.board);r=u.usrCoords[1]-l[1];q=u.usrCoords[2]-l[2];s=Math.sqrt(r*r+q*q);r=r*(s+x)/s;q=q*(s+v)/s;return new JXG.Coords(JXG.COORDS_BY_USER,[l[1]+r,l[2]+q],this.board)};h.prepareUpdate().update();return h};JXG.JSXGraph.registerElement("arc",JXG.createArc);JXG.createSemicircle=function(g,e,d){var f,j,h="";d=JXG.checkAttributes(d,{});if(d.id!=null){h=d.id+"_mp"}if((JXG.isPoint(e[0]))&&(JXG.isPoint(e[1]))){j=g.create("midpoint",[e[0],e[1]],{id:h,withLabel:false,visible:false});f=g.create("arc",[j,e[1],e[0]],d)}else{throw new Error("JSXGraph: Can't create Semicircle with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,point]")}return f};JXG.JSXGraph.registerElement("semicircle",JXG.createSemicircle);JXG.createCircumcircleArc=function(g,e,d){var f,j,h;d=JXG.checkAttributes(d,{withLabel:JXG.readOption(g.options,"arc","withLabel"),layer:null});if(d.id!=null){h=d.id+"_mp"}if((JXG.isPoint(e[0]))&&(JXG.isPoint(e[1]))&&(JXG.isPoint(e[2]))){j=g.create("circumcirclemidpoint",[e[0],e[1],e[2]],{id:h,withLabel:false,visible:false});d.useDirection=true;f=g.create("arc",[j,e[0],e[2],e[1]],d)}else{throw new Error("JSXGraph: create Circumcircle Arc with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.\nPossible parent types: [point,point,point]")}return f};JXG.JSXGraph.registerElement("circumcirclearc",JXG.createCircumcircleArc);JXG.createSector=function(j,f,d){var h,k,g,e;if(!(JXG.isPoint(f[0])&&JXG.isPoint(f[1])&&JXG.isPoint(f[2]))){throw new Error("JSXGraph: Can't create Sector with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.")}k={withLabel:JXG.readOption(j.options,"elements","withLabel"),layer:JXG.readOption(j.options,"layer","sector"),useDirection:false};k.strokeWidth=j.options.elements.strokeWidth;e=j.options.sector;for(g in e){k[g]=e[g]}d=JXG.checkAttributes(d,k);h=j.create("curve",[[0],[0]],d);h.type=JXG.OBJECT_TYPE_SECTOR;h.point1=JXG.getReference(j,f[0]);h.midpoint=h.point1;h.point2=JXG.getReference(j,f[1]);h.point3=JXG.getReference(j,f[2]);h.point1.addChild(h);h.point2.addChild(h);h.point3.addChild(h);h.useDirection=d.useDirection;h.updateDataArray=function(){var E=this.point2,D=this.point1,z=this.point3,J,r,L,G,l=JXG.Math.Geometry.rad(E,D,z),H,F=Math.ceil(l/Math.PI*90)+1,K=l/F,t=D.X(),s=D.Y(),u,q,m,w,I;if(this.useDirection){var q,m=f[1].coords.usrCoords,w=f[3].coords.usrCoords,I=f[2].coords.usrCoords;q=(m[1]-I[1])*(m[2]-w[2])-(m[2]-I[2])*(m[1]-w[1]);if(q<0){this.point2=f[1];this.point3=f[2]}else{this.point2=f[2];this.point3=f[1]}}this.dataX=[D.X(),E.X()];this.dataY=[D.Y(),E.Y()];for(J=K,H=1;H<=F;H++,J+=K){r=Math.cos(J);L=Math.sin(J);G=[[1,0,0],[t*(1-r)+s*L,r,-L],[s*(1-r)-t*L,L,r]];u=JXG.Math.matVecMult(G,E.coords.usrCoords);this.dataX.push(u[1]/u[0]);this.dataY.push(u[2]/u[0])}this.dataX.push(D.X());this.dataY.push(D.Y())};h.Radius=function(){return this.point2.Dist(this.point1)};h.getRadius=function(){return this.Radius()};h.hasPointSector=function(l,u){var t=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,u],this.board),n=this.Radius(),s=this.point1.coords.distance(JXG.COORDS_BY_USER,t),m=(s<n),q;if(m){q=JXG.Math.Geometry.rad(this.point2,this.point1,t.usrCoords.slice(1));if(q>JXG.Math.Geometry.rad(this.point2,this.point1,this.point3)){m=false}}return m};h.getTextAnchor=function(){return this.point1.coords};h.getLabelAnchor=function(){var n=JXG.Math.Geometry.rad(this.point2,this.point1,this.point3),x=10/(this.board.stretchX),v=10/(this.board.stretchY),t=this.point2.coords.usrCoords,l=this.point1.coords.usrCoords,m=t[1]-l[1],w=t[2]-l[2],u,r,q,s;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}u=new JXG.Coords(JXG.COORDS_BY_USER,[l[1]+Math.cos(n*0.5)*m-Math.sin(n*0.5)*w,l[2]+Math.sin(n*0.5)*m+Math.cos(n*0.5)*w],this.board);r=u.usrCoords[1]-l[1];q=u.usrCoords[2]-l[2];s=Math.sqrt(r*r+q*q);r=r*(s+x)/s;q=q*(s+v)/s;return new JXG.Coords(JXG.COORDS_BY_USER,[l[1]+r,l[2]+q],this.board)};h.prepareUpdate().update();return h};JXG.JSXGraph.registerElement("sector",JXG.createSector);JXG.createCircumcircleSector=function(h,e,d){var g,k,j="",f;d=JXG.checkAttributes(d,{withLabel:JXG.readOption(h.options,"sector","withLabel"),layer:null});if(d.id!=null){j=d.id+"_mp"}if((JXG.isPoint(e[0]))&&(JXG.isPoint(e[1]))&&(JXG.isPoint(e[2]))){k=h.create("circumcirclemidpoint",[e[0],e[1],e[2]],{id:j,withLabel:false,visible:false});d.useDirection=true;g=h.create("sector",[k,e[0],e[2],e[1]],d)}else{throw new Error("JSXGraph: Can't create circumcircle sector with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.")}return g};JXG.JSXGraph.registerElement("circumcirclesector",JXG.createCircumcircleSector);JXG.createAngle=function(n,s,k){var e,d,g,y,u,v,r=["&alpha;","&beta;","&gamma;","&delta;","&epsilon;","&zeta;","&eta","&theta;","&iota;","&kappa;","&lambda;","&mu;","&nu;","&xi;","&omicron;","&pi;","&rho;","&sigmaf;","&sigma;","&tau;","&upsilon;","&phi;","&chi;","&psi;","&omega;"],m=0,l,h,q,f,t,w;g={withLabel:JXG.readOption(n.options,"elements","withLabel"),layer:JXG.readOption(n.options,"layer","angle"),radius:JXG.readOption(n.options,"angle","radius"),text:""};y=n.options.angle;for(u in y){g[u]=y[u]}k=JXG.checkAttributes(k,g);if((JXG.isPoint(s[0]))&&(JXG.isPoint(s[1]))&&(JXG.isPoint(s[2]))){v=k.text;if(v==""){while(m<r.length){h=m;q=r[m];for(e in n.objects){if(n.objects[e].type==JXG.OBJECT_TYPE_ANGLE){if(n.objects[e].text==q){m++;break}}}if(m==h){v=q;m=r.length+1}}if(m==r.length){f="&alpha;_{";t="}";w=false;h=0;while(!w){for(e in n.objects){if(n.objects[e].type==JXG.OBJECT_TYPE_ANGLE){if(n.objects[e].text==(f+h+t)){w=true;break}}}if(w){w=false}else{w=true;v=(f+h+t)}}}}d=n.create("point",[function(){var j=s[0],C=s[1],x=k.radius,z=C.Dist(j);return[C.X()+(j.X()-C.X())*x/z,C.Y()+(j.Y()-C.Y())*x/z]}],{withLabel:false,visible:false});for(m=0;m<3;m++){JXG.getReference(n,s[m]).addChild(d)}e=n.create("sector",[s[1],d,s[2]],k);e.type=JXG.OBJECT_TYPE_ANGLE;if(e.withLabel){e.label.content.setText(v)}JXG.getReference(n,s[0]).addChild(e);e.getLabelAnchor=function(){var z=JXG.Math.Geometry.rad(this.point2,this.point1,this.point3),H=10/(this.board.stretchX),F=10/(this.board.stretchY),D=this.point2.coords.usrCoords,j=this.point1.coords.usrCoords,x=D[1]-j[1],G=D[2]-j[2],E,B,A,C;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}E=new JXG.Coords(JXG.COORDS_BY_USER,[j[1]+Math.cos(z*0.5*1.125)*x-Math.sin(z*0.5*1.125)*G,j[2]+Math.sin(z*0.5*1.125)*x+Math.cos(z*0.5*1.125)*G],this.board);B=E.usrCoords[1]-j[1];A=E.usrCoords[2]-j[2];C=Math.sqrt(B*B+A*A);B=B*(C+H)/C;A=A*(C+F)/C;return new JXG.Coords(JXG.COORDS_BY_USER,[j[1]+B,j[2]+A],this.board)}}else{throw new Error("JSXGraph: Can't create angle with parent types '"+(typeof s[0])+"' and '"+(typeof s[1])+"' and '"+(typeof s[2])+"'.")}return e};JXG.JSXGraph.registerElement("angle",JXG.createAngle);JXG.Algebra=function(d){this.board=d;this.eps=JXG.Math.eps};JXG.Algebra.prototype.angle=function(d,f,e){return JXG.Math.Geometry.angle(d,f,e)};JXG.Algebra.prototype.trueAngle=function(d,f,e){return this.rad(d,f,e)*57.29577951308232};JXG.Algebra.prototype.rad=function(d,f,e){return JXG.Math.Geometry.rad(d,f,e)};JXG.Algebra.prototype.angleBisector=function(d,f,e){return JXG.Math.Geometry.angleBisector(d,f,e,this.board)};JXG.Algebra.prototype.reflection=function(e,d){return JXG.Math.Geometry.reflection(e,d,this.board)};JXG.Algebra.prototype.rotation=function(e,d,f){return JXG.Math.Geometry.rotation(e,d,f,this.board)};JXG.Algebra.prototype.perpendicular=function(e,d){return JXG.Math.Geometry.perpendicular(e,d,this.board)};JXG.Algebra.prototype.circumcenterMidpoint=function(f,e,d){return JXG.Math.Geometry.circumcenterMidpoint(f,e,d,this.board)};JXG.Algebra.prototype.intersectLineLine=function(e,d){return JXG.Math.Geometry.intersectLineLine(e,d,this.board)};JXG.Algebra.prototype.intersectCircleLine=function(e,d){return JXG.Math.Geometry.intersectCircleLine(e,d,this.board)};JXG.Algebra.prototype.intersectCircleCircle=function(e,d){return JXG.Math.Geometry.intersectCircleCircle(e,d,this.board)};JXG.Algebra.prototype.projectPointToCircle=function(d,e){return JXG.Math.Geometry.projectPointToCircle(d,e,this.board)};JXG.Algebra.prototype.projectPointToLine=function(d,e){return JXG.Math.Geometry.projectPointToLine(d,e,this.board)};JXG.Algebra.prototype.projectPointToCurve=function(d,e){return JXG.Math.Geometry.projectPointToCurve(d,e,this.board)};JXG.Algebra.prototype.projectCoordsToCurve=function(d,g,e,f){return JXG.Math.Geometry.projectCoordsToCurve(d,g,e,f,this.board)};JXG.Algebra.prototype.projectPointToTurtle=function(d,e){return JXG.Math.Geometry.projectPointToTurtle(d,e,this.board)};JXG.Algebra.prototype.replacePow=function(d){return JXG.GeonextParser.replacePow(d)};JXG.Algebra.prototype.replaceIf=function(d){return JXG.GeonextParser.replaceIf(d)};JXG.Algebra.prototype.replaceSub=function(d){return JXG.GeonextParser.replaceSub(d)};JXG.Algebra.prototype.replaceSup=function(d){return JXG.GeonextParser.replaceSup(d)};JXG.Algebra.prototype.replaceNameById=function(d){return JXG.GeonextParser.replaceNameById(d,this.board)};JXG.Algebra.prototype.replaceIdByObj=function(d){return JXG.GeonextParser.replaceIdByObj(d)};JXG.Algebra.prototype.geonext2JS=function(d){return JXG.GeonextParser.geonext2JS(d,this.board)};JXG.Algebra.prototype.findDependencies=function(e,d){JXG.GeonextParser.findDependencies(e,d,this.board)};JXG.Algebra.prototype.distance=function(e,d){return JXG.Math.Geometry.distance(e,d)};JXG.Algebra.prototype.affineDistance=function(e,d){return JXG.Math.Geometry.affineDistance(e,d)};JXG.Algebra.prototype.pow=function(e,d){return JXG.Math.pow(e,d)};JXG.Algebra.prototype.meet=function(f,d,e){return JXG.Math.Geometry.meet(f,d,e,this.board)};JXG.Algebra.prototype.meetLineLine=function(e,d,f){return JXG.Math.Geometry.meetLineLine(e,d,f,this.board)};JXG.Algebra.prototype.meetLineCircle=function(f,e,d){return JXG.Math.Geometry.meetLineCircle(f,e,d,this.board)};JXG.Algebra.prototype.meetCircleCircle=function(f,d,e){return JXG.Math.Geometry.meetCircleCircle(f,d,e,this.board)};JXG.Algebra.prototype.normalize=function(d){return JXG.Math.normalize(d)};JXG.Algebra.prototype.meetCurveCurve=function(f,e,d,g){return JXG.Math.Geometry.meetCurveCurve(f,e,d,g,this.board)};JXG.Algebra.prototype.meetCurveLine=function(e,d,f){return JXG.Math.Geometry.meetCurveLine(e,d,f,this.board)};JXG.Intersection=function(h,e,g,f,k,j,q,n){this.constructor();this.board=h;this.id=e;this.name=this.id;this.visProp={};this.visProp.visible=true;this.show=true;this.real=true;this.notExistingParents={};this.intersect1=JXG.getReference(this.board,g);this.intersect2=JXG.getReference(this.board,f);this.type=JXG.OBJECT_TYPE_INTERSECTION;if(((this.intersect1=="")||(this.intersect1==undefined))&&((this.intersect2=="")||(this.intersect2==undefined))){return}if(((this.intersect1.type==this.intersect2.type)&&(this.intersect1.type==JXG.OBJECT_TYPE_LINE||this.intersect1.type==JXG.OBJECT_TYPE_ARROW))||((this.intersect1.type==JXG.OBJECT_TYPE_LINE)&&(this.intersect2.type==JXG.OBJECT_TYPE_ARROW))||((this.intersect2.type==JXG.OBJECT_TYPE_LINE)&&(this.intersect1.type==JXG.OBJECT_TYPE_ARROW))){var l=JXG.Math.Geometry.intersectLineLine(this.intersect1,this.intersect2,this.board).usrCoords.slice(1);this.p=new JXG.Point(this.board,l,k,q,true);this.p.fixed=true;this.addChild(this.p);this.real=true;this.update=function(){if(this.needsUpdate){this.p.coords=JXG.Math.Geometry.intersectLineLine(this.intersect1,this.intersect2,this.board);this.needsUpdate=false}};this.hideElement=function(){this.visProp.visible=false;this.p.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p.showElement()};this.hideChild=function(s){this.notExistingParents[s]=this.board.objects[s];for(var r in this.descendants){if(this.descendants[r].visProp.visible&&this.descendants[r].type!=JXG.OBJECT_TYPE_INTERSECTION){if(this.descendants[r].type!=JXG.OBJECT_TYPE_TEXT){this.descendants[r].hideElement();this.descendants[r].visProp.visible=true}else{if(!this.descendants[r].isLabel){this.descendants[r].hideElement();this.descendants[r].visProp.visible=true}}}this.descendants[r].notExistingParents[s]=this.board.objects[s]}};this.showChild=function(s){for(var r in this.board.objects){delete (this.board.objects[r].notExistingParents[s]);if(this.board.objects[r].visProp.visible&&JXG.keys(this.board.objects[r].notExistingParents).length==0){if(this.board.objects[r].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[r].showElement()}}}}}else{if(((g.type==f.type)&&(g.type==JXG.OBJECT_TYPE_CIRCLE||g.type==JXG.OBJECT_TYPE_ARC))||(g.type==JXG.OBJECT_TYPE_CIRCLE&&f.type==JXG.OBJECT_TYPE_ARC)||(f.type==JXG.OBJECT_TYPE_CIRCLE&&g.type==JXG.OBJECT_TYPE_ARC)){this.p1=new JXG.Point(this.board,[0,0],k,q,false);this.p1.fixed=true;this.p1.label.content.visProp.visible=true;this.p2=new JXG.Point(this.board,[0,0],j,n,false);this.p2.fixed=true;this.p2.label.content.visProp.visible=true;this.addChild(this.p1);this.addChild(this.p2);var m=JXG.Math.Geometry.intersectCircleCircle(this.intersect1,this.intersect2,this.board);if(m[0]==1){this.p1.coords=m[1];this.p1.showElement();this.p1.updateRenderer();this.p2.coords=m[2];this.p2.showElement();this.p2.updateRenderer();this.real=true}else{this.real=false}this.update=function(){if(!this.needsUpdate){return}var t=JXG.Math.Geometry.intersectCircleCircle(this.intersect1,this.intersect2,this.board);var s=this.p1.visProp.visible;var r=this.p2.visProp.visible;if(t[0]==0){if(this.real){this.hideChild(this.id);this.p1.visProp.visible=s;this.p2.visProp.visible=r;this.real=false}}else{this.p1.coords=t[1];this.p2.coords=t[2];if(!this.real){this.showChild(this.id);this.real=true}}this.needsUpdate=false};this.hideElement=function(){this.visProp.visible=false;this.p1.hideElement();this.p2.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p1.showElement();this.p2.showElement()};this.hideChild=function(s){this.notExistingParents[s]=this.board.objects[s];for(var r in this.descendants){if(this.descendants[r].visProp.visible&&this.descendants[r].type!=JXG.OBJECT_TYPE_INTERSECTION){if(this.descendants[r].type!=JXG.OBJECT_TYPE_TEXT){this.descendants[r].hideElement();this.descendants[r].visProp.visible=true}else{if(!this.descendants[r].isLabel){this.descendants[r].hideElement();this.descendants[r].visProp.visible=true}}}this.descendants[r].notExistingParents[s]=this.board.objects[s]}};this.showChild=function(s){var r;for(r in this.board.objects){delete (this.board.objects[r].notExistingParents[s]);if(this.board.objects[r].visProp.visible&&JXG.keys(this.board.objects[r].notExistingParents).length==0){if(this.board.objects[r].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[r].showElement()}}}}}else{this.p1=new JXG.Point(this.board,[0,0],k,q,false);this.p1.fixed=true;this.p1.label.content.visProp.visible=true;this.p2=new JXG.Point(this.board,[0,0],j,n,false);this.p2.fixed=true;this.p2.label.content.visProp.visible=true;this.addChild(this.p1);this.addChild(this.p2);if(this.intersect1.type==JXG.OBJECT_TYPE_LINE||this.intersect1.type==JXG.OBJECT_TYPE_ARROW){var d=this.intersect1;this.intersect1=this.intersect2;this.intersect2=d}var m=JXG.Math.Geometry.intersectCircleLine(this.intersect1,this.intersect2,this.board);if(m[0]==1){this.p1.coords=m[1];this.p1.showElement();this.p1.update()}else{if(m[0]==2){this.p1.coords=m[1];this.p1.showElement();this.p2.coords=m[2];this.p2.showElement();this.p1.updateRenderer();this.p2.updateRenderer();this.real=true}else{this.real=false}}this.update=function(){if(!this.needsUpdate){return}var t=JXG.Math.Geometry.intersectCircleLine(this.intersect1,this.intersect2,this.board);var s=this.p1.visProp.visible;var r=this.p2.visProp.visible;if(t[0]==0){if(this.real){this.hideChild(this.id);this.p1.visProp.visible=s;this.p2.visProp.visible=r;this.real=false}}else{if(t[0]==2){this.p1.coords=t[1];this.p2.coords=t[2];if(!this.real){this.showChild(this.id);this.real=true}}}this.needsUpdate=false};this.hideElement=function(){this.visProp.visible=false;this.p1.hideElement();this.p2.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p1.showElement();this.p2.showElement()};this.hideChild=function(s){this.notExistingParents[s]=this.board.objects[s];for(var r in this.descendants){if(this.descendants[r].visProp.visible&&this.descendants[r].type!=JXG.OBJECT_TYPE_INTERSECTION){if(this.descendants[r].type!=JXG.OBJECT_TYPE_TEXT){this.descendants[r].hideElement();this.descendants[r].visProp.visible=true}else{if(!this.descendants[r].isLabel){this.descendants[r].hideElement();this.descendants[r].visProp.visible=true}}}this.descendants[r].notExistingParents[s]=this.board.objects[s]}};this.showChild=function(s){var r;for(r in this.board.objects){delete (this.board.objects[r].notExistingParents[s]);if(this.board.objects[r].visProp.visible&&JXG.keys(this.board.objects[r].notExistingParents).length==0){if(this.board.objects[r].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[r].showElement()}}}}}}this.id=this.board.addIntersection(this)};JXG.Intersection.prototype=new JXG.GeometryElement();JXG.Intersection.prototype.update=function(){return};JXG.Intersection.prototype.hasPoint=function(d,e){return false};JXG.Intersection.prototype.hideChild=function(d){};JXG.Intersection.prototype.showChild=function(d){};JXG.Intersection.prototype.remove=function(){if(this.p!=undefined){this.board.removeObject(this.p)}if(this.p1!=undefined){this.board.removeObject(this.p1)}if(this.p2!=undefined){this.board.removeObject(this.p2)}return};JXG.Intersection.prototype.updateRenderer=function(){};JXG.createPerpendicularPoint=function(f,j,h){var d,g,e;if(JXG.isPoint(j[0])&&j[1].type==JXG.OBJECT_TYPE_LINE){g=j[0];d=j[1]}else{if(JXG.isPoint(j[1])&&j[0].type==JXG.OBJECT_TYPE_LINE){g=j[1];d=j[0]}else{throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+(typeof j[0])+"' and '"+(typeof j[1])+"'.\nPossible parent types: [point,line]")}}e=JXG.createPoint(f,[function(){return JXG.Math.Geometry.perpendicular(d,g,f)[0]}],{fixed:true,name:h.name,id:h.id});g.addChild(e);d.addChild(e);e.update();e.generatePolynomial=function(){var l=d.point1.symbolic.x;var k=d.point1.symbolic.y;var t=d.point2.symbolic.x;var s=d.point2.symbolic.y;var v=g.symbolic.x;var u=g.symbolic.y;var q=e.symbolic.x;var m=e.symbolic.y;var r="("+k+")*("+q+")-("+k+")*("+t+")+("+m+")*("+t+")-("+l+")*("+m+")+("+l+")*("+s+")-("+q+")*("+s+")";var n="("+u+")*("+k+")-("+u+")*("+s+")-("+m+")*("+k+")+("+m+")*("+s+")+("+v+")*("+l+")-("+v+")*("+t+")-("+q+")*("+l+")+("+q+")*("+t+")";return[r,n]};return e};JXG.createPerpendicular=function(h,m,k){var j,d,e,g,f;m[0]=JXG.getReference(h,m[0]);m[1]=JXG.getReference(h,m[1]);if(JXG.isPoint(m[0])&&m[1].elementClass==JXG.OBJECT_CLASS_LINE){d=m[1];j=m[0]}else{if(JXG.isPoint(m[1])&&m[0].elementClass==JXG.OBJECT_CLASS_LINE){d=m[0];j=m[1]}else{throw new Error("JSXGraph: Can't create perpendicular with parent types '"+(typeof m[0])+"' and '"+(typeof m[1])+"'.\nPossible parent types: [line,point]")}}if(!JXG.isArray(k.id)){k.id=["",""]}if(!JXG.isArray(k.name)){k.name=["",""]}g=JXG.createPerpendicularPoint(h,[d,j],{fixed:true,name:k.name[1],id:k.id[1],visible:false});e=JXG.createSegment(h,[function(){return(JXG.Math.Geometry.perpendicular(d,j,h)[1]?[g,j]:[j,g])}],{name:k.name[0],id:k.id[0]});f=[e,g];f.line=e;f.point=g;f.multipleElements=true;return f};JXG.createMidpoint=function(g,j,h){var e,d,f;if(j.length==2&&JXG.isPoint(j[0])&&JXG.isPoint(j[1])){e=j[0];d=j[1]}else{if(j.length==1&&j[0].elementClass==JXG.OBJECT_CLASS_LINE){e=j[0].point1;d=j[0].point2}else{throw new Error("JSXGraph: Can't create midpoint.\nPossible parent types: [point,point], [line]")}}if(h){h.fixed=true}else{h={fixed:true}}f=g.create("point",[function(){return(e.coords.usrCoords[1]+d.coords.usrCoords[1])/2},function(){return(e.coords.usrCoords[2]+d.coords.usrCoords[2])/2}],h);e.addChild(f);d.addChild(f);f.update();f.generatePolynomial=function(){var m=e.symbolic.x;var l=e.symbolic.y;var q=d.symbolic.x;var n=d.symbolic.y;var s=f.symbolic.x;var r=f.symbolic.y;var k="("+l+")*("+s+")-("+l+")*("+q+")+("+r+")*("+q+")-("+m+")*("+r+")+("+m+")*("+n+")-("+s+")*("+n+")";var t="("+m+")^2 - 2*("+m+")*("+s+")+("+l+")^2-2*("+l+")*("+r+")-("+q+")^2+2*("+q+")*("+s+")-("+n+")^2+2*("+n+")*("+r+")";return[k,t]};if(JXG.nullAtts){h=null}return f};JXG.createParallelPoint=function(f,k,j){var e,d,h,g;if(k.length==3&&k[0].elementClass==JXG.OBJECT_CLASS_POINT&&k[1].elementClass==JXG.OBJECT_CLASS_POINT&&k[2].elementClass==JXG.OBJECT_CLASS_POINT){e=k[0];d=k[1];h=k[2]}else{if(k[0].elementClass==JXG.OBJECT_CLASS_POINT&&k[1].elementClass==JXG.OBJECT_CLASS_LINE){h=k[0];e=k[1].point1;d=k[1].point2}else{if(k[1].elementClass==JXG.OBJECT_CLASS_POINT&&k[0].elementClass==JXG.OBJECT_CLASS_LINE){h=k[1];e=k[0].point1;d=k[0].point2}else{throw new Error("JSXGraph: Can't create parallel point with parent types '"+(typeof k[0])+"', '"+(typeof k[1])+"' and '"+(typeof k[2])+"'.\nPossible parent types: [line,point], [point,point,point]")}}}g=f.create("point",[function(){return h.coords.usrCoords[1]+d.coords.usrCoords[1]-e.coords.usrCoords[1]},function(){return h.coords.usrCoords[2]+d.coords.usrCoords[2]-e.coords.usrCoords[2]}],j);e.addChild(g);d.addChild(g);h.addChild(g);g.update();g.generatePolynomial=function(){var m=e.symbolic.x;var l=e.symbolic.y;var w=d.symbolic.x;var v=d.symbolic.y;var q=h.symbolic.x;var n=h.symbolic.y;var t=g.symbolic.x;var r=g.symbolic.y;var u="("+v+")*("+t+")-("+v+")*("+q+")-("+l+")*("+t+")+("+l+")*("+q+")-("+r+")*("+w+")+("+r+")*("+m+")+("+n+")*("+w+")-("+n+")*("+m+")";var s="("+r+")*("+m+")-("+r+")*("+q+")-("+v+")*("+m+")+("+v+")*("+q+")-("+t+")*("+l+")+("+t+")*("+n+")+("+w+")*("+l+")-("+w+")*("+n+")";return[u,s]};return g};JXG.createParallel=function(h,f,m){var l,d,g,j;j={name:null,id:null,fixed:true,visible:false};if(JXG.isArray(m.name)&&m.name.length==2){j.name=m.name[1];m.name=m.name[0]}else{j.name=m.name+"p2"}if(JXG.isArray(m.id)&&m.id.length==2){j.id=m.id[1];m.id=m.id[0]}else{if(m.id!=JXG.undefined){j.id=m.id+"p2"}}try{d=JXG.createParallelPoint(h,f,j)}catch(k){throw new Error("JSXGraph: Can't create parallel with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [line,point], [point,point,point]")}l=null;if(f.length==3){l=f[2]}else{if(f[0].elementClass==JXG.OBJECT_CLASS_POINT){l=f[0]}else{if(f[1].elementClass==JXG.OBJECT_CLASS_POINT){l=f[1]}}}g=h.create("line",[l,d],m);return g};JXG.createArrowParallel=function(g,f,k){var d,h;try{d=JXG.createParallel(g,f,k)}catch(j){throw new Error("JSXGraph: Can't create arrowparallel with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [line,point], [point,point,point]")}d.setStraight(false,false);d.setArrow(false,true);return d};JXG.createNormal=function(h,e,d){var l;var m;if(e.length==1){l=e[0];m=l.slideObject}else{if(e.length==2){if(JXG.isPoint(e[0])){l=e[0];m=e[1]}else{if(JXG.isPoint(e[1])){m=e[0];l=e[1]}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}if(m.elementClass==JXG.OBJECT_CLASS_LINE){return h.create("line",[function(){return m.stdform[1]*l.Y()-m.stdform[2]*l.X()},function(){return m.stdform[2]*l.Z()},function(){return -m.stdform[1]*l.Z()}],d)}else{if(m.elementClass==JXG.OBJECT_CLASS_CIRCLE){return h.create("line",[m.midpoint,l],d)}else{if(m.elementClass==JXG.OBJECT_CLASS_CURVE){if(m.curveType!="plot"){var j=m.X;var k=m.Y;return h.create("line",[function(){return -l.X()*h.D(j)(l.position)-l.Y()*h.D(k)(l.position)},function(){return h.D(j)(l.position)},function(){return h.D(k)(l.position)}],d)}else{return h.create("line",[function(){var g=Math.floor(l.position);var f=l.position-g;if(g==m.numberPoints-1){g--;f=1}if(g<0){return 1}return(m.Y(g)+f*(m.Y(g+1)-m.Y(g)))*(m.Y(g)-m.Y(g+1))-(m.X(g)+f*(m.X(g+1)-m.X(g)))*(m.X(g+1)-m.X(g))},function(){var f=Math.floor(l.position);if(f==m.numberPoints-1){f--}if(f<0){return 0}return m.X(f+1)-m.X(f)},function(){var f=Math.floor(l.position);if(f==m.numberPoints-1){f--}if(f<0){return 0}return m.Y(f+1)-m.Y(f)}],d)}}else{if(m.type==JXG.OBJECT_TYPE_TURTLE){return h.create("line",[function(){var n=Math.floor(l.position);var f=l.position-n;var q,g;for(g=0;g<m.objects.length;g++){q=m.objects[g];if(q.type==JXG.OBJECT_TYPE_CURVE){if(n<q.numberPoints){break}n-=q.numberPoints}}if(n==q.numberPoints-1){n--;f=1}if(n<0){return 1}return(q.Y(n)+f*(q.Y(n+1)-q.Y(n)))*(q.Y(n)-q.Y(n+1))-(q.X(n)+f*(q.X(n+1)-q.X(n)))*(q.X(n+1)-q.X(n))},function(){var g=Math.floor(l.position);var n,f;for(f=0;f<m.objects.length;f++){n=m.objects[f];if(n.type==JXG.OBJECT_TYPE_CURVE){if(g<n.numberPoints){break}g-=n.numberPoints}}if(g==n.numberPoints-1){g--}if(g<0){return 0}return n.X(g+1)-n.X(g)},function(){var g=Math.floor(l.position);var n,f;for(f=0;f<m.objects.length;f++){n=m.objects[f];if(n.type==JXG.OBJECT_TYPE_CURVE){if(g<n.numberPoints){break}g-=n.numberPoints}}if(g==n.numberPoints-1){g--}if(g<0){return 0}return n.Y(g+1)-n.Y(g)}],d)}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}}}};JXG.createBisector=function(f,k,j){var h,d,g,e;if(k[0].elementClass==JXG.OBJECT_CLASS_POINT&&k[1].elementClass==JXG.OBJECT_CLASS_POINT&&k[2].elementClass==JXG.OBJECT_CLASS_POINT){g={name:"",id:null,fixed:true,visible:false};if(j){g=JXG.cloneAndCopy(j,g)}h=f.create("point",[function(){return JXG.Math.Geometry.angleBisector(k[0],k[1],k[2],f)}],g);for(e=0;e<3;e++){k[e].addChild(h)}if(typeof j.straightFirst=="undefined"){j.straightFirst=false}if(typeof j.straightLast=="undefined"){j.straightLast=true}d=JXG.createLine(f,[k[1],h],j);return d}else{throw new Error("JSXGraph: Can't create angle bisector with parent types '"+(typeof k[0])+"' and '"+(typeof k[1])+"'.\nPossible parent types: [point,point,point]")}};JXG.createAngularBisectorsOfTwoLines=function(k,m,g){var f=JXG.getReference(k,m[0]),e=JXG.getReference(k,m[1]),q="",n="",l="",h="",j;if(f.elementClass!=JXG.OBJECT_CLASS_LINE||e.elementClass!=JXG.OBJECT_CLASS_LINE){throw new Error("JSXGraph: Can't create angle bisectors of two lines with parent types '"+(typeof m[0])+"' and '"+(typeof m[1])+"'.\nPossible parent types: [line,line]")}g=JXG.checkAttributes(g,{});if(g.id!=null){if(JXG.isArray(g.id)){q=g.id[0];n=g.id[1]}else{q=g.id;n=g.id}}if(g.name!=null){if(JXG.isArray(g.name)){l=g.name[0];h=g.name[1]}else{l=g.name;h=g.name}}g.id=q;g.name=l;var d=k.create("line",[function(){var t=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var s=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[0]/t-e.stdform[0]/s},function(){var t=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var s=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[1]/t-e.stdform[1]/s},function(){var t=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var s=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[2]/t-e.stdform[2]/s}],g);g.id=n;g.name=h;var r=k.create("line",[function(){var t=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var s=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[0]/t+e.stdform[0]/s},function(){var t=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var s=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[1]/t+e.stdform[1]/s},function(){var t=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);var s=Math.sqrt(e.stdform[1]*e.stdform[1]+e.stdform[2]*e.stdform[2]);return f.stdform[2]/t+e.stdform[2]/s}],g);j=[d,r];j.lines=[d,r];j.line1=d;j.line2=r;j.multipleElements=true;return j};JXG.createCircumcircleMidpoint=function(e,h,g){var f,d;if(h[0].elementClass==JXG.OBJECT_CLASS_POINT&&h[1].elementClass==JXG.OBJECT_CLASS_POINT&&h[2].elementClass==JXG.OBJECT_CLASS_POINT){g.fixed=g.fixed||true;f=JXG.createPoint(e,[function(){return JXG.Math.Geometry.circumcenterMidpoint(h[0],h[1],h[2],e)}],g);for(d=0;d<3;d++){h[d].addChild(f)}f.generatePolynomial=function(){var k=a.symbolic.x;var j=a.symbolic.y;var u=b.symbolic.x;var t=b.symbolic.y;var m=c.symbolic.x;var l=c.symbolic.y;var r=f.symbolic.x;var n=f.symbolic.y;var s=["((",r,")-(",k,"))^2+((",n,")-(",j,"))^2-((",r,")-(",u,"))^2-((",n,")-(",t,"))^2"].join("");var q=["((",r,")-(",k,"))^2+((",n,")-(",j,"))^2-((",r,")-(",m,"))^2-((",n,")-(",l,"))^2"].join("");return[s,q]};return f}else{throw new Error("JSXGraph: Can't create circumcircle midpoint with parent types '"+(typeof h[0])+"', '"+(typeof h[1])+"' and '"+(typeof h[2])+"'.\nPossible parent types: [point,point,point]")}};JXG.createCircumcircle=function(f,m,l){var j,k,g,d;g=JXG.clone(l);if(l.name&&JXG.isArray(l.name)){g.name=l.name[0];l.name=l.name[1]}if(l.id&&JXG.isArray(l.id)){g.id=l.id[0];l.id=l.id[1]}try{j=JXG.createCircumcircleMidpoint(f,m,g);k=JXG.createCircle(f,[j,m[0]],l)}catch(h){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+(typeof m[0])+"', '"+(typeof m[1])+"' and '"+(typeof m[2])+"'.\nPossible parent types: [point,point,point]")}d=[j,k];d.point=j;d.circle=k;d.multipleElements=true;return d};JXG.createReflection=function(e,j,h){var d,g,f;if(j[0].elementClass==JXG.OBJECT_CLASS_POINT&&j[1].elementClass==JXG.OBJECT_CLASS_LINE){g=j[0];d=j[1]}else{if(j[1].elementClass==JXG.OBJECT_CLASS_POINT&&j[0].elementClass==JXG.OBJECT_CLASS_LINE){g=j[1];d=j[0]}else{throw new Error("JSXGraph: Can't create reflection point with parent types '"+(typeof j[0])+"' and '"+(typeof j[1])+"'.\nPossible parent types: [line,point]")}}f=JXG.createPoint(e,[function(){return JXG.Math.Geometry.reflection(d,g,e)}],h);g.addChild(f);d.addChild(f);f.update();f.generatePolynomial=function(){var l=d.point1.symbolic.x;var k=d.point1.symbolic.y;var t=d.point2.symbolic.x;var s=d.point2.symbolic.y;var v=g.symbolic.x;var u=g.symbolic.y;var n=f.symbolic.x;var m=f.symbolic.y;var r=["((",m,")-(",u,"))*((",k,")-(",s,"))+((",l,")-(",t,"))*((",n,")-(",v,"))"].join("");var q=["((",n,")-(",l,"))^2+((",m,")-(",k,"))^2-((",v,")-(",l,"))^2-((",u,")-(",k,"))^2"].join("");return[r,q]};return f};JXG.createMirrorPoint=function(d,g,f){var e;if(JXG.isPoint(g[0])&&JXG.isPoint(g[1])){f.fixed=f.fixed||true;e=JXG.createPoint(d,[function(){return JXG.Math.Geometry.rotation(g[0],g[1],Math.PI,d)}],f);for(i=0;i<2;i++){g[i].addChild(e)}}else{throw new Error("JSXGraph: Can't create mirror point with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,point]")}e.update();return e};JXG.createIntegral=function(j,z,n){var y,v,s={},g=0,f=0,e,d,m,l,u=1,x,q,h,A,k,r,w;if(!JXG.isArray(n.id)||(n.id.length!=5)){n.id=["","","","",""]}if(!JXG.isArray(n.name)||(n.name.length!=5)){n.name=["","","","",""]}if(JXG.isArray(z[0])&&z[1].elementClass==JXG.OBJECT_CLASS_CURVE){y=z[0];v=z[1]}else{if(JXG.isArray(z[1])&&z[0].elementClass==JXG.OBJECT_CLASS_CURVE){y=z[1];v=z[0]}else{throw new Error("JSXGraph: Can't create integral with parent types '"+(typeof z[0])+"' and '"+(typeof z[1])+"'.\nPossible parent types: [[number|function,number|function],curve]")}}if((typeof n!="undefined")&&(n!=null)){s=JXG.cloneAndCopy(n,{name:n.name[0],id:n.id[0]})}g=y[0];f=y[1];if(JXG.isFunction(g)){e=g;d=function(){return v.yterm(e())};g=e()}else{e=g;d=v.yterm(g)}if(JXG.isFunction(g)){m=f;l=function(){return v.yterm(m())};f=m()}else{m=f;l=v.yterm(f)}if(f<g){u=-1}x=j.create("glider",[e,d,v],s);if(JXG.isFunction(e)){x.hideElement()}s.name=n.name[1];s.id=n.id[1];s.visible=false;q=j.create("point",[function(){return x.X()},0],s);s.name=n.name[2];s.id=n.id[2];s.visible=n.visible||true;h=j.create("glider",[m,l,v],s);if(JXG.isFunction(m)){h.hideElement()}s.name=n.name[3];s.id=n.id[3];s.visible=false;A=j.create("point",[function(){return h.X()},0],s);k=JXG.Math.Numerics.I([g,f],v.yterm);r=j.create("text",[function(){return h.X()+0.2},function(){return h.Y()-0.8},function(){var t=JXG.Math.Numerics.I([q.X(),A.X()],v.yterm);return"&int; = "+(t).toFixed(4)}],{labelColor:n.labelColor});s.name=n.name[4];s.id=n.id[4];s.visible=n.visible||true;s.fillColor=s.fillColor||j.options.polygon.fillColor;s.highlightFillColor=s.highlightFillColor||j.options.polygon.highlightFillColor;s.fillOpacity=s.fillOpacity||j.options.polygon.fillOpacity;s.highlightFillOpacity=s.highlightFillOpacity||j.options.polygon.highlightFillOpacity;s.strokeWidth=0;s.highlightStrokeWidth=0;s.strokeOpacity=0;w=j.create("curve",[[0],[0]],s);w.updateDataArray=function(){var t,E,C,D,B;if(q.X()<A.X()){D=q.X();B=A.X()}else{D=A.X();B=q.X()}t=[D,D];E=[0,v.yterm(D)];for(C=0;C<v.numberPoints;C++){if((D<=v.points[C].usrCoords[1])&&(v.points[C].usrCoords[1]<=B)){t.push(v.points[C].usrCoords[1]);E.push(v.points[C].usrCoords[2])}}t.push(B);E.push(v.yterm(B));t.push(B);E.push(0);t.push(D);E.push(0);this.dataX=t;this.dataY=E};x.addChild(w);h.addChild(w);x.addChild(r);h.addChild(r);return w};JXG.createLocus=function(f,e,d){var h,g;if(JXG.isArray(e)&&e.length==1&&e[0].elementClass==JXG.OBJECT_CLASS_POINT){g=e[0]}else{throw new Error("JSXGraph: Can't create locus with parent of type other than point.\nPossible parent types: [point]")}h=f.create("curve",[[null],[null]],d);h.dontCallServer=false;h.updateDataArray=function(){if(h.board.mode>0){return}var k=JXG.Math.Symbolic.generatePolynomials(f,g,true).join("");if(k===h.spe){return}h.spe=k;var j=function(n,r,m,q){h.dataX=n;h.dataY=r;h.eq=m;h.ctime=q;h.generatePolynomial=(function(s){return function(u){var t="("+u.symbolic.x+")",z="("+u.symbolic.y+")",w=[],v;for(v=0;v<s.length;v++){w[v]=s[v].replace(/\*\*/g,"^").replace(/x/g,t).replace(/y/g,z)}return w}})(m)},l=JXG.Math.Symbolic.geometricLocusByGroebnerBase(f,g,j);j(l.datax,l.datay,l.polynomial,l.exectime)};return h};JXG.JSXGraph.registerElement("arrowparallel",JXG.createArrowParallel);JXG.JSXGraph.registerElement("bisector",JXG.createBisector);JXG.JSXGraph.registerElement("bisectorlines",JXG.createAngularBisectorsOfTwoLines);JXG.JSXGraph.registerElement("circumcircle",JXG.createCircumcircle);JXG.JSXGraph.registerElement("circumcirclemidpoint",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("circumcenter",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("integral",JXG.createIntegral);JXG.JSXGraph.registerElement("midpoint",JXG.createMidpoint);JXG.JSXGraph.registerElement("mirrorpoint",JXG.createMirrorPoint);JXG.JSXGraph.registerElement("normal",JXG.createNormal);JXG.JSXGraph.registerElement("parallel",JXG.createParallel);JXG.JSXGraph.registerElement("parallelpoint",JXG.createParallelPoint);JXG.JSXGraph.registerElement("perpendicular",JXG.createPerpendicular);JXG.JSXGraph.registerElement("perpendicularpoint",JXG.createPerpendicularPoint);JXG.JSXGraph.registerElement("reflection",JXG.createReflection);JXG.JSXGraph.registerElement("locus",JXG.createLocus);JXG.Text=function(m,s,j,r,f,d,g,q,n,l){this.constructor();this.type=JXG.OBJECT_TYPE_TEXT;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.init(m,f,d);this.contentStr=s;this.plaintextStr="";if(l==null){l=m.options.layer.text}this.layer=l;this.display=n||"html";if((typeof q!="undefined")&&(q!=null)){this.isLabel=q}else{this.isLabel=false}this.visProp.strokeColor=this.board.options.text.strokeColor;this.visProp.visible=true;if(g!=null){this.digits=g}else{this.digits=2}if((this.element=this.board.objects[j])){var h;if(!this.isLabel){h=this.element.getTextAnchor()}else{h=this.element.getLabelAnchor()}this.element.addChild(this);this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[parseFloat(r[0]),parseFloat(r[1])],this.board);this.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.relativeCoords.scrCoords[1]+h.scrCoords[1],this.relativeCoords.scrCoords[2]+h.scrCoords[2]],this.board)}else{this.X=JXG.createFunction(r[0],this.board,"");this.Y=JXG.createFunction(r[1],this.board,"");this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);var k="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);";this.updateCoords=new Function("",k)}if(typeof this.contentStr=="function"){this.updateText=function(){this.plaintextStr=this.contentStr()}}else{var e;if(typeof this.contentStr=="number"){e=(this.contentStr).toFixed(this.digits)}else{if(this.board.options.text.useASCIIMathML){e="'`"+this.contentStr+"`'"}else{e=this.generateTerm(this.contentStr)}}this.updateText=new Function("this.plaintextStr = "+e+";")}if(!this.isLabel){this.id=this.board.addText(this)}if(typeof this.contentStr=="string"){this.notifyParents(this.contentStr)}};JXG.Text.prototype=new JXG.GeometryElement();JXG.Text.prototype.hasPoint=function(d,e){return false};JXG.Text.prototype.setText=function(e){var d;if(typeof e=="number"){d=(e).toFixed(this.digits)}else{d=this.generateTerm(e)}this.updateText=new Function("this.plaintextStr = "+d+";");this.updateText();return this};JXG.Text.prototype.setCoords=function(d,e){this.X=function(){return d};this.Y=function(){return e};this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[d,e],this.board);return this};JXG.Text.prototype.update=function(){if(this.needsUpdate&&!this.frozen){if(this.relativeCoords){var d;if(!this.isLabel){d=this.element.getTextAnchor()}else{d=this.element.getLabelAnchor()}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[this.relativeCoords.scrCoords[1]+d.scrCoords[1],this.relativeCoords.scrCoords[2]+d.scrCoords[2]])}else{this.updateCoords()}}if(this.needsUpdate){this.updateText()}return this};JXG.Text.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateText(this);this.needsUpdate=false}return this};JXG.Text.prototype.generateTerm=function(h){var g=null;var l=this.board.elementsByName;var k='""';h=h.replace(/\r/g,"");h=h.replace(/\n/g,"");h=h.replace(/\"/g,'\\"');h=h.replace(/\'/g,"\\'");h=h.replace(/&amp;arc;/g,"&ang;");h=h.replace(/<arc\s*\/>/g,"&ang;");h=h.replace(/<sqrt\s*\/>/g,"&radic;");var f;f=h.indexOf("<value>");var d=h.indexOf("</value>");if(f>=0){while(f>=0){k+=' + "'+JXG.GeonextParser.replaceSub(JXG.GeonextParser.replaceSup(h.slice(0,f)))+'"';var e=h.slice(f+7,d);var g=JXG.GeonextParser.geonext2JS(e,this.board);g=g.replace(/\\"/g,'"');g=g.replace(/\\'/g,"'");if(g.indexOf("toFixed")<0){k+="+("+g+").toFixed("+(this.digits)+")"}else{k+="+("+g+")"}h=h.slice(d+8);f=h.indexOf("<value>");d=h.indexOf("</value>")}}k+=' + "'+JXG.GeonextParser.replaceSub(JXG.GeonextParser.replaceSup(h))+'"';k=k.replace(/<overline>/g,"<span style=text-decoration:overline>");k=k.replace(/<\/overline>/g,"</span>");k=k.replace(/<arrow>/g,"<span style=text-decoration:overline>");k=k.replace(/<\/arrow>/g,"</span>");k=k.replace(/&amp;/g,"&");return k};JXG.Text.prototype.notifyParents=function(f){var e=null;var g=this.board.elementsByName;do{var d=/<value>([\w\s\*\/\^\-\+\(\)\[\],<>=!]+)<\/value>/;e=d.exec(f);if(e!=null){JXG.GeonextParser.findDependencies(this,e[1],this.board);f=f.substr(e.index);f=f.replace(d,"")}}while(e!=null);return this};JXG.createText=function(d,f,e){e=JXG.checkAttributes(e,{layer:null,display:d.options.text.defaultDisplay,parent:null});if(e.parent!=null){e.parent=e.parent.id}return new JXG.Text(d,f[f.length-1],e.parent,f,e.id,e.name,e.digits,false,e.display,e.layer)};JXG.JSXGraph.registerElement("text",JXG.createText);JXG.Image=function(j,e,k,g,f,l,d,h){this.type=JXG.OBJECT_TYPE_IMAGE;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.transformations=[];this.init(j,l,d);this.coords=new JXG.Coords(JXG.COORDS_BY_USER,k,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,k,this.board);this.size=[g[0]*j.stretchX,g[1]*j.stretchY];this.url=e;if(f==null){f=j.options.layer.image}this.layer=f;this.parent=h;this.visProp.visible=true;this.id=this.board.addImage(this)};JXG.Image.prototype=new JXG.GeometryElement;JXG.Image.prototype.hasPoint=function(d,e){return false};JXG.Image.prototype.updateRenderer=function(){this.updateTransform();this.board.renderer.updateImage(this)};JXG.Image.prototype.updateTransform=function(){if(this.transformations.length==0){return}for(var d=0;d<this.transformations.length;d++){this.transformations[d].update()}};JXG.Image.prototype.addTransform=function(d){if(JXG.isArray(d)){for(var e=0;e<d.length;e++){this.transformations.push(d[e])}}else{this.transformations.push(d)}};JXG.createImage=function(f,e,g){var d;if(g==null){g={}}else{if(g.imageString!=null){d=g.imageString}}if(typeof g.layer=="undefined"){g.layer=null}return new JXG.Image(f,e[0],e[1],e[2],g.layer,false,false)};JXG.JSXGraph.registerElement("image",JXG.createImage);JXG.createSlider=function(r,B,x){var l,j,A,m,C,s,f,e,z,D,q,h,g,d,y,w,u,v,k;l=B[0];j=B[1];A=B[2][0];m=B[2][1];C=B[2][2];s=C-A;x=JXG.checkAttributes(x,{strokeColor:"#000000",fillColor:"#ffffff",withTicks:true});k=JXG.str2Bool(x.fixed);f=r.create("point",l,{visible:!k,fixed:k,name:"",withLabel:false,face:"<>",size:5,strokeColor:"#000000",fillColor:"#ffffff"});e=r.create("point",j,{visible:!k,fixed:k,name:"",withLabel:false,face:"<>",size:5,strokeColor:"#000000",fillColor:"#ffffff"});r.create("group",[f,e]);z=r.create("segment",[f,e],{strokewidth:1,name:"",withLabel:false,strokeColor:x.strokeColor});if(x.withTicks){D=2;q=r.create("ticks",[z,e.Dist(f)/D],{insertTicks:true,minorTicks:0,drawLabels:false,drawZero:true})}if(k){f.needsRegularUpdate=false;e.needsRegularUpdate=false;z.needsRegularUpdate=false}h=l[0]+(j[0]-l[0])*(m-A)/(C-A);g=l[1]+(j[1]-l[1])*(m-A)/(C-A);if(x.snapWidth!=null){v=x.snapWidth}if(x.snapwidth!=null){v=x.snapwidth}d=r.create("glider",[h,g,z],{style:6,strokeColor:x.strokeColor,fillColor:x.fillColor,showInfobox:false,name:x.name,withLabel:false,snapWidth:v});y=r.create("line",[f,d],{straightFirst:false,straightLast:false,strokewidth:3,strokeColor:x.strokeColor,name:"",withLabel:false});d.Value=function(){return this.position*s+A};d._smax=C;d._smin=A;if(typeof x.withLabel=="undefined"||x.withLabel==true){if(x.name&&x.name!=""){w=x.name+" = "}else{w=""}u=r.create("text",[function(){return(e.X()-f.X())*0.05+e.X()},function(){return(e.Y()-f.Y())*0.05+e.Y()},function(){return w+(d.Value()).toFixed(2)}],{name:""})}return d};JXG.JSXGraph.registerElement("slider",JXG.createSlider);JXG.Chart=function(k,n,g){this.constructor();if(n.length==0){return}this.elements=[];var f=g.id||"";var e=g.name||"";this.init(k,f,e);var q,m,h;if(n.length>0&&(typeof n[0]=="number")){m=n;q=[];for(h=0;h<m.length;h++){q[h]=h+1}}else{if(n.length==1){m=n[0];q=[];var j;if(JXG.isFunction(m)){j=m().length}else{j=m.length}for(h=0;h<j;h++){q[h]=h+1}}if(n.length==2){q=n[0];m=n[1]}}if(g==undefined){g={}}var d=g.chartStyle||"line";d=d.replace(/ /g,"");d=d.split(",");var l;for(h=0;h<d.length;h++){switch(d[h]){case"bar":l=this.drawBar(k,[q,m],g);break;case"line":l=this.drawLine(k,[q,m],g);break;case"fit":l=this.drawFit(k,[q,m],g);break;case"spline":l=this.drawSpline(k,[q,m],g);break;case"pie":l=this.drawPie(k,[m],g);break;case"point":l=this.drawPoints(k,[q,m],g);break;case"radar":l=this.drawRadar(k,n,g);break}this.elements.push(l)}this.id=this.board.addChart(this);return this.elements};JXG.Chart.prototype=new JXG.GeometryElement;JXG.Chart.prototype.drawLine=function(h,g,e){var f=g[0],d=g[1];e.fillColor="none";e.highlightFillColor="none";var j=h.create("curve",[f,d],e);this.rendNode=j.rendNode;return j};JXG.Chart.prototype.drawSpline=function(h,f,e){var d=f[0],k=f[1],g;e.fillColor="none";e.highlightFillColor="none";var j=h.create("spline",[d,k],e);this.rendNode=j.rendNode;return j};JXG.Chart.prototype.drawFit=function(h,g,f){var d=g[0],l=g[1],j=(((typeof f.degree=="undefined")||(parseInt(f.degree)==NaN)||(parseInt(f.degree)<1))?1:parseInt(f.degree));f.fillColor="none";f.highlightFillColor="none";var e=JXG.Math.Numerics.regressionPolynomial(j,d,l);var k=h.create("functiongraph",[e],f);this.rendNode=k.rendNode;return k};JXG.Chart.prototype.drawBar=function(l,n,j){var k,h=[],q=n[0],m=n[1],r,f,v,u,e,d,s,g=[],t;if(j.fillOpacity==undefined){j.fillOpacity=0.6}if(j&&j.width){r=j.width}else{if(q.length<=1){r=1}else{r=q[1]-q[0];for(k=1;k<q.length-1;k++){r=(q[k+1]-q[k]<r)?(q[k+1]-q[k]):r}}r*=0.8}t=j.fillColor;for(k=0;k<q.length;k++){if(JXG.isFunction(q[k])){f=function(){return q[k]()-r*0.5};v=function(){return q[k]()};u=function(){return q[k]()+r*0.5}}else{f=q[k]-r*0.5;v=q[k];u=q[k]+r*0.5}if(JXG.isFunction(m[k])){d=e}else{d=m[k]+0.2}e=m[k];if(j.dir=="horizontal"){g[0]=l.create("point",[0,f],{name:"",fixed:true,visible:false});g[1]=l.create("point",[e,f],{name:"",fixed:true,visible:false});g[2]=l.create("point",[e,u],{name:"",fixed:true,visible:false});g[3]=l.create("point",[0,u],{name:"",fixed:true,visible:false});if(j.labels&&j.labels[k]){l.create("text",[e,u,j.labels[k]],j)}}else{g[0]=l.create("point",[f,0],{name:"",fixed:true,visible:false});g[1]=l.create("point",[f,e],{name:"",fixed:true,visible:false});g[2]=l.create("point",[u,e],{name:"",fixed:true,visible:false});g[3]=l.create("point",[u,0],{name:"",fixed:true,visible:false});if(j.labels&&j.labels[k]){l.create("text",[u,e,j.labels[k]],j)}}j.withLines=false;if(!t){s=j.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];j.fillColor=s[k%s.length]}h[k]=l.create("polygon",g,j)}this.rendNode=h[0].rendNode;return h};JXG.Chart.prototype.drawPoints=function(k,g,f){var h;var j=[];f.fixed=true;f.name="";var e=JXG.isArray(f.infoboxArray)?f.infoboxArray||false:false;var d=g[0];var l=g[1];for(h=0;h<d.length;h++){f.infoboxtext=e?e[h%e.length]:false;j[h]=k.create("point",[d[h],l[h]],f)}this.rendNode=j[0].rendNode;return j};JXG.Chart.prototype.drawPie=function(g,x,j){var k=x[0];if(k.length<=0){return}var w;var t=[];var h=[];var l=JXG.Math.Statistics.sum(k);var f=j.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];var B=j.highlightColorArray||["#FF7400"];var u=new Array(k.length);for(w=0;w<k.length;w++){u[w]=""}var m=j.labelArray||u;var n=j.radius||4;var e;if(!JXG.isFunction(n)){e=function(){return n}}else{e=n}var A={};if(typeof j.highlightOnSector=="undefined"){j.highlightOnSector=false}A.name=j.name;A.id=j.id;A.strokeWidth=j.strokeWidth||1;A.strokeColor=j.strokeColor||"none";A.straightFirst=false;A.straightLast=false;A.fillColor=j.fillColor||"#FFFF88";A.fillOpacity=j.fillOpacity||0.6;A.highlightFillColor=j.highlightFillColor||"#FF7400";A.highlightStrokeColor=j.highlightStrokeColor||"#FFFFFF";A.gradient=j.gradient||"none";A.gradientSecondColor=j.gradientSecondColor||"black";var q=j.center||[0,0];var v=q[0];var d=q[1];var z=g.create("point",[v,d],{name:"",fixed:true,visible:false});t[0]=g.create("point",[function(){return e()+v},function(){return 0+d}],{name:"",fixed:true,visible:false});var C=0;for(w=0;w<k.length;w++){t[w+1]=g.create("point",[(function(r){return function(){var F=0,E=0,D;for(D=0;D<=r;D++){if(JXG.isFunction(k[D])){E+=parseFloat(k[D]())}else{E+=parseFloat(k[D])}}F=E;for(D=r+1;D<k.length;D++){if(JXG.isFunction(k[D])){F+=parseFloat(k[D]())}else{F+=parseFloat(k[D])}}var y=(F!=0)?(2*Math.PI*E/F):0;return e()*Math.cos(y)+v}})(w),(function(r){return function(){var F=0,E=0,D;for(D=0;D<=r;D++){if(JXG.isFunction(k[D])){E+=parseFloat(k[D]())}else{E+=parseFloat(k[D])}}F=E;for(D=r+1;D<k.length;D++){if(JXG.isFunction(k[D])){F+=parseFloat(k[D]())}else{F+=parseFloat(k[D])}}var y=(F!=0)?(2*Math.PI*E/F):0;return e()*Math.sin(y)+d}})(w)],{name:"",fixed:false,visible:false,withLabel:false});A.fillColor=f[w%f.length];A.name=m[w];if(A.name!=""){A.withLabel=true}else{A.withLabel=false}A.labelColor=f[w%f.length];A.highlightfillColor=B[w%B.length];h[w]=g.create("sector",[z,t[w],t[w+1]],A);if(j.highlightOnSector){h[w].hasPoint=h[w].hasPointSector}if(j.highlightBySize){h[w].highlight=function(){this.board.renderer.highlight(this);if(this.label.content!=null){this.label.content.rendNode.style.fontSize=(2*this.board.fontSize)+"px"}var s=-this.midpoint.coords.usrCoords[1]+this.point2.coords.usrCoords[1];var r=-this.midpoint.coords.usrCoords[2]+this.point2.coords.usrCoords[2];this.point2.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+s*1.1,this.midpoint.coords.usrCoords[2]+r*1.1],this.board);this.prepareUpdate().update().updateRenderer()};h[w].noHighlight=function(){this.board.renderer.noHighlight(this);if(this.label.content!=null){this.label.content.rendNode.style.fontSize=(this.board.fontSize)+"px"}var s=-this.midpoint.coords.usrCoords[1]+this.point2.coords.usrCoords[1];var r=-this.midpoint.coords.usrCoords[2]+this.point2.coords.usrCoords[2];this.point2.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1]+s/1.1,this.midpoint.coords.usrCoords[2]+r/1.1],this.board);this.prepareUpdate().update().updateRenderer()}}}this.rendNode=h[0].rendNode;return{arcs:h,points:t,midpoint:z}};JXG.Chart.prototype.drawRadar=function(n,Q,L){var Z,X,aa,N,ac,F,C=Q.length,K,u,f,M,D,z,E,B,g,Y,v,s,w,P,x,V,R,J,d,m,e,U,l,O,r,T,af,y,k,q,H,S,ae,A,h;if(C<=0){alert("No data");return}aa=L.paramArray;if(aa==undefined){alert("Need paramArray attribute");return}N=aa.length;if(N<=1){alert("Need more than 1 param");return}for(Z=0;Z<C;Z++){if(N!=Q[Z].length){alert("Use data length equal to number of params ("+Q[Z].length+" != "+N+")");return}}ac=new Array(N);F=new Array(N);for(X=0;X<N;X++){ac[X]=Q[0][X];F[X]=ac[X]}for(Z=1;Z<C;Z++){for(X=0;X<N;X++){if(Q[Z][X]>ac[X]){ac[X]=Q[Z][X]}if(Q[Z][X]<F[X]){F[X]=Q[Z][X]}}}K=new Array(C);u=new Array(C);for(Z=0;Z<C;Z++){K[Z]="";u[Z]=[]}f=new Array(N);M=new Array(N);D=L.startShiftRatio||0;z=L.endShiftRatio||0;for(Z=0;Z<N;Z++){f[Z]=(ac[Z]-F[Z])*D;M[Z]=(ac[Z]-F[Z])*z}E=L.startShiftArray||f;B=L.endShiftArray||M;g=L.startArray||F;if(L.start!=undefined){for(Z=0;Z<N;Z++){g[Z]=L.start}}Y=L.endArray||ac;if(L.end!=undefined){for(Z=0;Z<N;Z++){Y[Z]=L.end}}if(E.length!=N){alert("Start shifts length is not equal to number of parameters");return}if(B.length!=N){alert("End shifts length is not equal to number of parameters");return}if(g.length!=N){alert("Starts length is not equal to number of parameters");return}if(Y.length!=N){alert("Ends length is not equal to number of parameters");return}v=L.labelArray||K;s=L.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];w=L.highlightColorArray||["#FF7400"];P=L.radius||10;x={};if(L.highlightOnSector==JXG.undefined){L.highlightOnSector=false}x.name=L.name;x.id=L.id;x.strokeWidth=L.strokeWidth||1;x.polyStrokeWidth=L.polyStrokeWidth||2*x.strokeWidth;x.strokeColor=L.strokeColor||"black";x.straightFirst=false;x.straightLast=false;x.fillColor=L.fillColor||"#FFFF88";x.fillOpacity=L.fillOpacity||0.4;x.highlightFillColor=L.highlightFillColor||"#FF7400";x.highlightStrokeColor=L.highlightStrokeColor||"black";x.gradient=L.gradient||"none";V=L.center||[0,0];R=V[0];yc=V[1];d=n.createElement("point",[R,yc],{name:"",fixed:true,withlabel:false,visible:false});m=Math.PI/2-Math.PI/N;if(L.startAngle||L.startAngle===0){m=L.startAngle}e=m;U=[];l=[];var W=function(){var t,j,ah,ag,ai=[].concat(this.labelOffsets);t=this.point1.X();j=this.point2.X();ah=this.point1.Y();ag=this.point2.Y();if(j<t){ai[0]=-ai[0]}if(ag<ah){ai[1]=-ai[1]}this.setLabelRelativeCoords(ai);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)};var I=function(aj,ag){var j;var ai;var ah;j=n.createElement("transform",[-(g[ag]-E[ag]),0],{type:"translate"});ai=n.createElement("transform",[P/((Y[ag]+B[ag])-(g[ag]-E[ag])),1],{type:"scale"});j.melt(ai);ah=n.createElement("transform",[aj],{type:"rotate"});j.melt(ah);return j};for(Z=0;Z<N;Z++){e+=2*Math.PI/N;r=P*Math.cos(e)+R;T=P*Math.sin(e)+yc;U[Z]=n.createElement("point",[r,T],{name:"",fixed:true,withlabel:false,visible:false});l[Z]=n.createElement("line",[d,U[Z]],{name:aa[Z],strokeColor:x.strokeColor,strokeWidth:x.strokeWidth,strokeOpacity:1,straightFirst:false,straightLast:false,withLabel:true,highlightStrokeColor:x.highlightStrokeColor});l[Z].getLabelAnchor=W;O=I(e,Z);for(X=0;X<Q.length;X++){var ad=Q[X][Z];u[X][Z]=n.createElement("point",[ad,0],{name:"",fixed:true,withlabel:false,visible:false});u[X][Z].addTransform(u[X][Z],O)}}af=new Array(C);for(Z=0;Z<C;Z++){x.labelColor=s[Z%s.length];x.strokeColor=s[Z%s.length];x.fillColor=s[Z%s.length];af[Z]=n.createElement("polygon",u[Z],{withLines:true,withLabel:false,fillColor:x.fillColor,fillOpacity:x.fillOpacity});for(X=0;X<N;X++){af[Z].borders[X].setProperty("strokeColor:"+s[Z%s.length]);af[Z].borders[X].setProperty("strokeWidth:"+x.polyStrokeWidth)}}y=L.legendPosition||"none";switch(y){case"right":var G=L.legendLeftOffset||2;var ab=L.legendTopOffset||1;this.legend=n.createElement("legend",[R+P+G,yc+P-ab],{labelArray:v,colorArray:s});break;case"none":break;default:alert("Unknown legend position")}k=[];if(L.showCircles!=false){q=[];for(Z=0;Z<6;Z++){q[Z]=20*Z}q[0]="0";H=L.circleLabelArray||q;S=H.length;if(S<2){alert("Too less circles");return}ae=[];A=m+Math.PI/N;O=I(A,0);x.fillColor="none";x.highlightFillColor="none";x.strokeColor=L.strokeColor||"black";x.strokeWidth=L.circleStrokeWidth||0.5;h=(Y[0]-g[0])/(S-1);for(Z=0;Z<S;Z++){ae[Z]=n.createElement("point",[g[0]+Z*h,0],{name:H[Z],size:0,withLabel:true,visible:true});ae[Z].addTransform(ae[Z],O);k[Z]=n.createElement("circle",[d,ae[Z]],x)}}this.rendNode=af[0].rendNode;return{circles:k,lines:l,points:u,midpoint:d,polygons:af}};JXG.Chart.prototype.updateRenderer=function(){};JXG.Chart.prototype.update=function(){if(this.needsUpdate){this.updateDataArray()}};JXG.Chart.prototype.updateDataArray=function(){};JXG.createChart=function(h,y,k){if((y.length==1)&&(typeof y[0]=="string")){var v=document.getElementById(y[0]),C,g,s,r,f,d,u=[],m,l,B,A,D,n,e,q,z,t;if(typeof v!="undefined"){k=JXG.checkAttributes(k,{withHeader:true});v=(new JXG.DataSource()).loadFromTable(y[0],k.withHeader,k.withHeader);C=v.data;f=v.columnHeader;g=v.rowHeader;A=k.width;D=k.name;n=k.strokeColor;e=k.fillColor;q=k.highlightStrokeColor;z=k.highlightFillColor;h.suspendUpdate();t=C.length;B=[];if(k.rows&&JXG.isArray(k.rows)){for(s=0;s<t;s++){for(r=0;r<k.rows.length;r++){if((k.rows[r]==s)||(k.withHeaders&&k.rows[r]==g[s])){B.push(C[s]);break}}}}else{B=C}t=B.length;for(s=0;s<t;s++){l=[];if(k.chartStyle&&k.chartStyle.indexOf("bar")!=-1){if(A){m=A}else{m=0.8}l.push(1-m/2+(s+0.5)*m/(1*t));for(r=1;r<B[s].length;r++){l.push(l[r-1]+1)}k.width=m/(1*t)}if(D&&D.length==t){k.name=D[s]}else{if(k.withHeaders){k.name=f[s]}}if(n&&n.length==t){k.strokeColor=n[s]}else{k.strokeColor=JXG.hsv2rgb(((s+1)/(1*t))*360,0.9,0.6)}if(e&&e.length==t){k.fillColor=e[s]}else{k.fillColor=JXG.hsv2rgb(((s+1)/(1*t))*360,0.9,1)}if(q&&q.length==t){k.highlightStrokeColor=q[s]}else{k.highlightStrokeColor=JXG.hsv2rgb(((s+1)/(1*t))*360,0.9,1)}if(z&&z.length==t){k.highlightFillColor=z[s]}else{k.highlightFillColor=JXG.hsv2rgb(((s+1)/(1*t))*360,0.9,0.6)}if(k.chartStyle&&k.chartStyle.indexOf("bar")!=-1){u.push(new JXG.Chart(h,[l,B[s]],k))}else{u.push(new JXG.Chart(h,[B[s]],k))}}h.unsuspendUpdate()}return u}else{return new JXG.Chart(h,y,k)}};JXG.JSXGraph.registerElement("chart",JXG.createChart);JXG.Legend=function(f,g,d){this.constructor();this.board=f;this.coords=new JXG.Coords(JXG.COORDS_BY_USER,g,this.board);this.myAtts={};this.label_array=d.labelArray||["1","2","3","4","5","6","7","8"];this.color_array=d.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];var e;this.lines=[];this.myAtts.strokeWidth=d.strokeWidth||5;this.myAtts.straightFirst=false;this.myAtts.straightLast=false;this.myAtts.withLabel=true;this.style=d.legendStyle||"vertical";switch(this.style){case"vertical":this.drawVerticalLegend(d);break;default:alert("Unknown legend style"+this.style);break}};JXG.Legend.prototype=new JXG.GeometryElement;JXG.Legend.prototype.drawVerticalLegend=function(f){var e=f.lineLength||1;var d=(f.rowHeight||20)/this.board.stretchY;for(i=0;i<this.label_array.length;i++){this.myAtts.strokeColor=this.color_array[i];this.myAtts.highlightStrokeColor=this.color_array[i];this.myAtts.name=this.label_array[i];this.myAtts.labelOffsets=[10,0];this.lines[i]=board.createElement("line",[[this.coords.usrCoords[1],this.coords.usrCoords[2]-i*d],[this.coords.usrCoords[1]+e,this.coords.usrCoords[2]-i*d]],this.myAtts);this.lines[i].getLabelAnchor=function(){this.setLabelRelativeCoords(this.labelOffsets);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)}}};JXG.createLegend=function(f,e,d){var g=[0,0];if(e!=undefined){if(e.length==2){g=e}}return new JXG.Legend(f,g,d)};JXG.JSXGraph.registerElement("legend",JXG.createLegend);JXG.Transformation=function(e,d,f){this.elementClass=JXG.OBJECT_CLASS_OTHER;this.matrix=[[1,0,0],[0,1,0],[0,0,1]];this.board=e;this.isNumericMatrix=false;this.setMatrix(e,d,f)};JXG.Transformation.prototype={};JXG.Transformation.prototype.update=function(){};JXG.Transformation.prototype.setMatrix=function(f,e,g){var d;this.isNumericMatrix=true;for(d=0;d<g.length;d++){if(typeof g[d]!="number"){this.isNumericMatrix=false;break}}if(e=="translate"){this.evalParam=JXG.createEvalFunction(f,g,2);this.update=function(){this.matrix[1][0]=this.evalParam(0);this.matrix[2][0]=this.evalParam(1)}}else{if(e=="scale"){this.evalParam=JXG.createEvalFunction(f,g,2);this.update=function(){this.matrix[1][1]=this.evalParam(0);this.matrix[2][2]=this.evalParam(1)}}else{if(e=="reflect"){if(g.length<4){g[0]=JXG.getReference(f,g[0])}if(g.length==2){g[1]=JXG.getReference(f,g[1])}if(g.length==4){this.evalParam=JXG.createEvalFunction(f,g,4)}this.update=function(){var h,m,j,l,k;if(g.length==1){h=g[0].point2.X()-g[0].point1.X();m=g[0].point2.Y()-g[0].point1.Y();j=g[0].point1.X();l=g[0].point1.Y()}else{if(g.length==2){h=g[1].X()-g[0].X();m=g[1].Y()-g[0].Y();j=g[0].X();l=g[0].Y()}else{if(g.length==4){h=this.evalParam(2)-this.evalParam(0);m=this.evalParam(3)-this.evalParam(1);j=this.evalParam(0);l=this.evalParam(1)}}}k=h*h+m*m;this.matrix[1][1]=(h*h-m*m)/k;this.matrix[1][2]=2*h*m/k;this.matrix[2][1]=2*h*m/k;this.matrix[2][2]=(-h*h+m*m)/k;this.matrix[1][0]=j*(1-this.matrix[1][1])-l*this.matrix[1][2];this.matrix[2][0]=l*(1-this.matrix[2][2])-j*this.matrix[2][1]}}else{if(e=="rotate"){if(g.length==3){this.evalParam=JXG.createEvalFunction(f,g,3)}else{if(g.length<=2){this.evalParam=JXG.createEvalFunction(f,g,1);if(g.length==2){g[1]=JXG.getReference(f,g[1])}}}this.update=function(){var k=this.evalParam(0),h,m,l=Math.cos(k),j=Math.sin(k);this.matrix[1][1]=l;this.matrix[1][2]=-j;this.matrix[2][1]=j;this.matrix[2][2]=l;if(g.length>1){if(g.length==3){h=this.evalParam(1);m=this.evalParam(2)}else{h=g[1].X();m=g[1].Y()}this.matrix[1][0]=h*(1-l)+m*j;this.matrix[2][0]=m*(1-l)-h*j}}}else{if(e=="shear"){this.evalParam=JXG.createEvalFunction(f,g,1);this.update=function(){var h=this.evalParam(0);this.matrix[1][1]=Math.tan(h)}}else{if(e=="generic"){this.evalParam=JXG.createEvalFunction(f,g,9);this.update=function(){this.matrix[0][0]=this.evalParam(0);this.matrix[0][1]=this.evalParam(1);this.matrix[0][2]=this.evalParam(2);this.matrix[1][0]=this.evalParam(3);this.matrix[1][1]=this.evalParam(4);this.matrix[1][2]=this.evalParam(5);this.matrix[2][0]=this.evalParam(6);this.matrix[2][1]=this.evalParam(7);this.matrix[2][2]=this.evalParam(8)}}}}}}}};JXG.Transformation.prototype.apply=function(d){this.update();if(arguments[1]!=null){return JXG.Math.matVecMult(this.matrix,d.initialCoords.usrCoords)}else{return JXG.Math.matVecMult(this.matrix,d.coords.usrCoords)}};JXG.Transformation.prototype.applyOnce=function(f){var g,d,e;if(!JXG.isArray(f)){this.update();g=JXG.Math.matVecMult(this.matrix,f.coords.usrCoords);f.coords.setCoordinates(JXG.COORDS_BY_USER,[g[1],g[2]])}else{d=f.length;for(e=0;e<d;e++){this.update();g=JXG.Math.matVecMult(this.matrix,f[e].coords.usrCoords);f[e].coords.setCoordinates(JXG.COORDS_BY_USER,[g[1],g[2]])}}};JXG.Transformation.prototype.bindTo=function(f){var e,d;if(JXG.isArray(f)){d=f.length;for(e=0;e<d;e++){f[e].transformations.push(this)}}else{f.transformations.push(this)}};JXG.Transformation.prototype.setProperty=function(d){};JXG.Transformation.prototype.melt=function(m){var l=[],h,d,g,e,n,f;d=m.matrix.length;g=this.matrix[0].length;for(h=0;h<d;h++){l[h]=[]}this.update();m.update();for(h=0;h<d;h++){for(f=0;f<g;f++){n=0;for(e=0;e<d;e++){n+=m.matrix[h][e]*this.matrix[e][f]}l[h][f]=n}}this.update=function(){var j=this.matrix.length,k=this.matrix[0].length;for(h=0;h<j;h++){for(f=0;f<k;f++){this.matrix[h][f]=l[h][f]}}};return true};JXG.createTransform=function(d,f,e){return new JXG.Transformation(d,e.type,f)};JXG.JSXGraph.registerElement("transform",JXG.createTransform);JXG.Turtle=function(h,g,e){var d,j,f;this.type=JXG.OBJECT_TYPE_TURTLE;this.turtleIsHidden=false;this.board=h;this.attributes=JXG.checkAttributes(e,{withLabel:false,layer:null});this.attributes.straightFirst=false;this.attributes.straightLast=false;d=0;j=0;f=90;if(g.length!=0){if(g.length==3){d=g[0];j=g[1];f=g[2]}else{if(g.length==2){if(JXG.isArray(g[0])){d=g[0][0];j=g[0][1];f=g[1]}else{d=g[0];j=g[1]}}else{d=g[0][0];j=g[0][1]}}}this.init(d,j,f);return this};JXG.Turtle.prototype=new JXG.GeometryElement;JXG.Turtle.prototype.init=function(d,g,f){this.arrowLen=20/Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY);this.pos=[d,g];this.isPenDown=true;this.dir=90;this.stack=[];this.objects=[];this.attributes.curveType="plot";this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.turtle=this.board.create("point",this.pos,{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle);this.turtle2=this.board.create("point",[this.pos[0],this.pos[1]+this.arrowLen],{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle2);var e=this.attributes.strokeWidth||this.attributes.strokewidth||2;this.arrow=this.board.create("line",[this.turtle,this.turtle2],{strokeColor:"#ff0000",straightFirst:false,straightLast:false,strokeWidth:e,withLabel:false,lastArrow:true});this.objects.push(this.arrow);this.right(90-f);this.board.update()};JXG.Turtle.prototype.forward=function(d){if(d==0){return}var f=d*Math.cos(this.dir*Math.PI/180);var e=d*Math.sin(this.dir*Math.PI/180);if(!this.turtleIsHidden){var g=this.board.create("transform",[f,e],{type:"translate"});g.applyOnce(this.turtle);g.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]+=f;this.pos[1]+=e;if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update();return this};JXG.Turtle.prototype.back=function(d){return this.forward(-d)};JXG.Turtle.prototype.right=function(e){this.dir-=e;this.dir%=360;if(!this.turtleIsHidden){var d=this.board.create("transform",[-e*Math.PI/180,this.turtle],{type:"rotate"});d.applyOnce(this.turtle2)}this.board.update();return this};JXG.Turtle.prototype.left=function(d){return this.right(-d)};JXG.Turtle.prototype.penUp=function(){this.isPenDown=false;return this};JXG.Turtle.prototype.penDown=function(){this.isPenDown=true;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.clean=function(){for(var d=0;d<this.objects.length;d++){var e=this.objects[d];if(e.type==JXG.OBJECT_TYPE_CURVE){this.board.removeObject(e.id);this.objects.splice(d,1)}}this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this};JXG.Turtle.prototype.clearScreen=function(){for(var d=0;d<this.objects.length;d++){var e=this.objects[d];this.board.removeObject(e.id)}this.init(0,0,90);return this};JXG.Turtle.prototype.setPos=function(d,f){if(JXG.isArray(d)){this.pos=d}else{this.pos=[d,f]}if(!this.turtleIsHidden){this.turtle.setPositionDirectly(JXG.COORDS_BY_USER,d,f);this.turtle2.setPositionDirectly(JXG.COORDS_BY_USER,d,f+this.arrowLen);var e=this.board.create("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"});e.applyOnce(this.turtle2)}this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this};JXG.Turtle.prototype.setPenSize=function(d){this.attributes.strokeWidth=d;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setPenColor=function(d){this.attributes.strokeColor=d;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setHighlightPenColor=function(d){this.attributes.highlightStrokeColor=d;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setProperty=function(){var h;var d;var f,g;var e;for(f=0;f<arguments.length;f++){d=arguments[f];if(typeof d=="string"){h=d.split(":")}else{if(!JXG.isArray(d)){for(var e in d){this.setProperty([e,d[e]])}return this}else{h=d}}this.attributes[h[0]]=h[1]}for(f=0;f<this.objects.length;f++){g=this.objects[f];if(g.type==JXG.OBJECT_TYPE_CURVE){g.setProperty(this.attributes)}}return this};JXG.Turtle.prototype.showTurtle=function(){this.turtleIsHidden=false;this.arrow.setProperty("visible:true");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this};JXG.Turtle.prototype.hideTurtle=function(){this.turtleIsHidden=true;this.arrow.setProperty("visible:false");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this};JXG.Turtle.prototype.home=function(){this.pos=[0,0];this.setPos(this.pos[0],this.pos[1]);return this};JXG.Turtle.prototype.pushTurtle=function(){this.stack.push([this.pos[0],this.pos[1],this.dir]);return this};JXG.Turtle.prototype.popTurtle=function(){var d=this.stack.pop();this.pos[0]=d[0];this.pos[1]=d[1];this.dir=d[2];this.setPos(this.pos[0],this.pos[1]);return this};JXG.Turtle.prototype.lookTo=function(h){if(JXG.isArray(h)){var e=this.pos[0];var d=this.pos[1];var j=h[0];var g=h[1];var f;f=Math.atan2(g-d,j-e);this.right(this.dir-(f*180/Math.PI))}else{if(JXG.isNumber(h)){this.right(this.dir-(h))}}return this};JXG.Turtle.prototype.moveTo=function(g){if(JXG.isArray(g)){var e=g[0]-this.pos[0];var d=g[1]-this.pos[1];if(!this.turtleIsHidden){var f=this.board.create("transform",[e,d],{type:"translate"});f.applyOnce(this.turtle);f.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]=g[0];this.pos[1]=g[1];if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update()}return this};JXG.Turtle.prototype.fd=function(d){return this.forward(d)};JXG.Turtle.prototype.bk=function(d){return this.back(d)};JXG.Turtle.prototype.lt=function(d){return this.left(d)};JXG.Turtle.prototype.rt=function(d){return this.right(d)};JXG.Turtle.prototype.pu=function(){return this.penUp()};JXG.Turtle.prototype.pd=function(){return this.penDown()};JXG.Turtle.prototype.ht=function(){return this.hideTurtle()};JXG.Turtle.prototype.st=function(){return this.showTurtle()};JXG.Turtle.prototype.cs=function(){return this.clearScreen()};JXG.Turtle.prototype.push=function(){return this.pushTurtle()};JXG.Turtle.prototype.pop=function(){return this.popTurtle()};JXG.Turtle.prototype.X=function(d){return this.pos[0]};JXG.Turtle.prototype.Y=function(d){return this.pos[1]};JXG.Turtle.prototype.hasPoint=function(d,g){var e,f;for(e=0;e<this.objects.length;e++){f=this.objects[e];if(f.type==JXG.OBJECT_TYPE_CURVE){if(f.hasPoint(d,g)){return true}}}return false};JXG.createTurtle=function(f,e,d){if(e==null){e=[]}return new JXG.Turtle(f,e,d)};JXG.JSXGraph.registerElement("turtle",JXG.createTurtle);JXG.rgbParser=function(){if(arguments.length==0){return}if(arguments.length>=3){arguments[0]=[arguments[0],arguments[1],arguments[2]];arguments.length=1}var m=arguments[0];if(JXG.isArray(m)){var e=false,j;for(j=0;j<3;j++){e|=/\./.test(arguments[0][j].toString())}for(j=0;j<3;j++){e&=(arguments[0][j]>=0)&(arguments[0][j]<=1)}if(e){return[Math.ceil(arguments[0][0]*255),Math.ceil(arguments[0][1]*255),Math.ceil(arguments[0][2]*255)]}else{arguments[0].length=3;return arguments[0]}}else{if(typeof arguments[0]=="string"){m=arguments[0]}}var d,k,n;if(m.charAt(0)=="#"){m=m.substr(1,6)}m=m.replace(/ /g,"");m=m.toLowerCase();var h={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};for(var q in h){if(m==q){m=h[q]}}var l=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(g){return[parseInt(g[1]),parseInt(g[2]),parseInt(g[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(g){return[parseInt(g[1],16),parseInt(g[2],16),parseInt(g[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(g){return[parseInt(g[1]+g[1],16),parseInt(g[2]+g[2],16),parseInt(g[3]+g[3],16)]}}];for(var j=0;j<l.length;j++){var t=l[j].re;var f=l[j].process;var s=t.exec(m);if(s){channels=f(s);d=channels[0];k=channels[1];n=channels[2]}}d=(d<0||isNaN(d))?0:((d>255)?255:d);k=(k<0||isNaN(k))?0:((k>255)?255:k);n=(n<0||isNaN(n))?0:((n>255)?255:n);return[d,k,n]};JXG.rgb2css=function(){var f,e,d;f=JXG.rgbParser.apply(JXG.rgbParser,arguments);e=f[1];d=f[2];f=f[0];return"rgb("+f+", "+e+", "+d+")"};JXG.rgb2hex=function(){var f,e,d;f=JXG.rgbParser.apply(JXG.rgbParser,arguments);e=f[1];d=f[2];f=f[0];f=f.toString(16);e=e.toString(16);d=d.toString(16);if(f.length==1){f="0"+f}if(e.length==1){e="0"+e}if(d.length==1){d="0"+d}return"#"+f+e+d};JXG.hsv2rgb=function(r,k,j){var l,s,g,n,m,h,e,d,u;r=((r%360)+360)%360;if(k==0){if(isNaN(r)||r<JXG.Math.eps){l=j;s=j;g=j}else{return"#ffffff"}}else{if(r>=360){h=0}else{h=r}h=h/60;m=Math.floor(h);n=h-m;e=j*(1-k);d=j*(1-(k*n));u=j*(1-(k*(1-n)));switch(m){case 0:l=j;s=u;g=e;break;case 1:l=d;s=j;g=e;break;case 2:l=e;s=j;g=u;break;case 3:l=e;s=d;g=j;break;case 4:l=u;s=e;g=j;break;case 5:l=j;s=e;g=d;break}}l=Math.round(l*255).toString(16);l=(l.length==2)?l:((l.length==1)?"0"+l:"00");s=Math.round(s*255).toString(16);s=(s.length==2)?s:((s.length==1)?"0"+s:"00");g=Math.round(g*255).toString(16);g=(g.length==2)?g:((g.length==1)?"0"+g:"00");return["#",l,s,g].join("")};JXG.rgb2hsv=function(){var d,n,u,q,e,j,f,w,m,y,x,t,k,l;d=JXG.rgbParser.apply(JXG.rgbParser,arguments);n=d[1];u=d[2];d=d[0];l=JXG.Math.Statistics;q=d/255;e=n/255;j=u/255;t=l.max([d,n,u]);k=l.min([d,n,u]);f=t/255;w=k/255;x=f;y=0;if(x>0){y=(x-w)/(x*1)}m=1/(f-w);if(y>0){if(t==d){m=(e-j)*m}else{if(t==n){m=2+(j-q)*m}else{m=4+(q-e)*m}}}m*=60;if(m<0){m+=360}if(t==k){m=0}return[m,y,x]};JXG.rgb2LMS=function(){var n,k,e,f,d,j,h;matrix=[[0.05059983,0.08585369,0.0095242],[0.01893033,0.08925308,0.01370054],[0.00292202,0.00975732,0.07145979]];n=JXG.rgbParser.apply(JXG.rgbParser,arguments);k=n[1];e=n[2];n=n[0];n=Math.pow(n,0.476190476);k=Math.pow(k,0.476190476);e=Math.pow(e,0.476190476);f=n*matrix[0][0]+k*matrix[0][1]+e*matrix[0][2];d=n*matrix[1][0]+k*matrix[1][1]+e*matrix[1][2];j=n*matrix[2][0]+k*matrix[2][1]+e*matrix[2][2];h=[f,d,j];h.l=f;h.m=d;h.s=j;return h};JXG.LMS2rgb=function(f,e,j){var n,k,d,h;matrix=[[30.830854,-29.832659,1.610474],[-6.481468,17.715578,-2.532642],[-0.37569,-1.199062,14.273846]];n=f*matrix[0][0]+e*matrix[0][1]+j*matrix[0][2];k=f*matrix[1][0]+e*matrix[1][1]+j*matrix[1][2];d=f*matrix[2][0]+e*matrix[2][1]+j*matrix[2][2];lut_lookup=function(l){var m=127,g=64;while(g>0){if(Math.pow(m,0.476190476)>l){m-=g}else{if(Math.pow(m+1,0.476190476)>l){return m}m+=g}g/=2}if(m==254&&13.994955247<l){return 255}return m};n=lut_lookup(n);k=lut_lookup(k);d=lut_lookup(d);h=[n,k,d];h.r=n;h.g=k;h.b=d;return h};JXG.Board.prototype.angle=function(d,f,e){return JXG.Math.Geometry.angle(d,f,e)};JXG.Board.prototype.rad=function(d,f,e){return JXG.Math.Geometry.rad(d,f,e)};JXG.Board.prototype.distance=function(e,d){return JXG.Math.Geometry.distance(e,d)};JXG.Board.prototype.pow=function(e,d){return JXG.Math.pow(e,d)};JXG.Board.prototype.round=function(d,e){return(d).toFixed(e)};JXG.Board.prototype.cosh=function(d){return JXG.Math.cosh(d)};JXG.Board.prototype.sinh=function(d){return JXG.Math.sinh(d)};JXG.Board.prototype.sgn=function(d){return(d==0?0:d/(Math.abs(d)))};JXG.Board.prototype.D=function(d,e){return JXG.Math.Numerics.D(d,e)};JXG.Board.prototype.I=function(d,e){return JXG.Math.Numerics.I(d,e)};JXG.Board.prototype.root=function(e,d,g){return JXG.Math.Numerics.root(e,d,g)};JXG.Board.prototype.lagrangePolynomial=function(d){return JXG.Math.Numerics.lagrangePolynomial(d)};JXG.Board.prototype.neville=function(d){return JXG.Math.Numerics.Neville(d)};JXG.Board.prototype.riemannsum=function(g,j,e,h,d){return JXG.Math.Numerics.riemannsum(g,j,e,h,d)};JXG.Board.prototype.abs=Math.abs;JXG.Board.prototype.acos=Math.acos;JXG.Board.prototype.asin=Math.asin;JXG.Board.prototype.atan=Math.atan;JXG.Board.prototype.ceil=Math.ceil;JXG.Board.prototype.cos=Math.cos;JXG.Board.prototype.exp=Math.exp;JXG.Board.prototype.floor=Math.floor;JXG.Board.prototype.log=Math.log;JXG.Board.prototype.max=Math.max;JXG.Board.prototype.min=Math.min;JXG.Board.prototype.random=Math.random;JXG.Board.prototype.sin=Math.sin;JXG.Board.prototype.sqrt=Math.sqrt;JXG.Board.prototype.tan=Math.tan;JXG.Board.prototype.trunc=Math.ceil;JXG.Board.prototype.factorial=function(d){return JXG.Math.factorial(d)};JXG.Board.prototype.binomial=function(e,d){return JXG.Math.binomial(e,d)};JXG.Point.prototype.setPositionX=function(f,d){var e=(f==JXG.COORDS_BY_USER)?this.coords.usrCoords[2]:this.coords.scrCoords[2];this.setPosition(f,d,e)};JXG.Point.prototype.setPositionY=function(f,e){var d=(f==JXG.COORDS_BY_USER)?this.coords.usrCoords[1]:this.coords.scrCoords[1];this.setPosition(f,d,e)};JXG.Board.prototype.getElement=function(d){return JXG.getReference(this,d)};JXG.Board.prototype.intersectionOptions=["point",[[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_CIRCLE],[JXG.OBJECT_CLASS_CIRCLE,JXG.OBJECT_CLASS_CIRCLE]]];JXG.Board.prototype.intersection=function(g,e,f,d){g=JXG.getReference(this,g);e=JXG.getReference(this,e);if(g.elementClass==JXG.OBJECT_CLASS_CURVE&&e.elementClass==JXG.OBJECT_CLASS_CURVE){return function(){return JXG.Math.Geometry.meetCurveCurve(g,e,f,d,g.board)}}else{if((g.elementClass==JXG.OBJECT_CLASS_CURVE&&e.elementClass==JXG.OBJECT_CLASS_LINE)||(e.elementClass==JXG.OBJECT_CLASS_CURVE&&g.elementClass==JXG.OBJECT_CLASS_LINE)){return function(){return JXG.Math.Geometry.meetCurveLine(g,e,f,g.board)}}else{return function(){return JXG.Math.Geometry.meet(g.stdform,e.stdform,f,g.board)}}}};JXG.Board.prototype.intersectionFunc=function(g,e,f,d){return this.intersection(g,e,f,d)};JXG.Board.prototype.otherIntersection=function(e,d,f){e=JXG.getReference(this,e);d=JXG.getReference(this,d);return function(){var g=JXG.Math.Geometry.meet(e.stdform,d.stdform,0,e.board);if(Math.abs(f.X()-g.usrCoords[1])>JXG.Math.eps||Math.abs(f.Y()-g.usrCoords[2])>JXG.Math.eps||Math.abs(f.Z()-g.usrCoords[0])>JXG.Math.eps){return g}else{return JXG.Math.Geometry.meet(e.stdform,d.stdform,1,e.board)}}};JXG.Board.prototype.pointFunc=function(){return[null]};JXG.Board.prototype.pointOptions=["point",[[JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.lineFunc=function(){return arguments};JXG.Board.prototype.lineOptions=["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.linesegmentFunc=function(){return arguments};JXG.Board.prototype.linesegmentOptions=["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.linesegmentAtts={straightFirst:false,straightLast:false};JXG.Board.prototype.arrowFunc=function(){return arguments};JXG.Board.prototype.arrowOptions=["arrow",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circleFunc=function(){return arguments};JXG.Board.prototype.circleOptions=["circle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_CIRCLE]]];JXG.Board.prototype.arrowparallelOptions=["arrowparallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.arrowparallelFunc=function(){return arguments};JXG.Board.prototype.bisectorOptions=["bisector",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.bisectorFunc=function(){return arguments};JXG.Board.prototype.circumcircleOptions=["circumcircle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circumcircleFunc=function(){return arguments};JXG.Board.prototype.circumcirclemidpointOptions=["circumcirclemidpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circumcirclemidpointFunc=function(){return arguments};JXG.Board.prototype.integralOptions=["integral",[[]]];JXG.Board.prototype.integralFunc=function(){return arguments};JXG.Board.prototype.midpointOptions=["midpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.midpointFunc=function(){return arguments};JXG.Board.prototype.mirrorpointOptions=["mirrorpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.mirrorpointFunc=function(){return arguments};JXG.Board.prototype.normalOptions=["normal",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.normalFunc=function(){return arguments};JXG.Board.prototype.parallelOptions=["parallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.parallelFunc=function(){return arguments};JXG.Board.prototype.parallelpointOptions=["parallelpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.parallelpointFunc=function(){return arguments};JXG.Board.prototype.perpendicularOptions=["perpendicular",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.perpendicularFunc=function(){return arguments};JXG.Board.prototype.perpendicularpointOptions=["perpendicularpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.perpendicularpointFunc=function(){return arguments};JXG.Board.prototype.reflectionOptions=["reflection",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.reflectionFunc=function(){return arguments};JXG.Board.prototype.pstricks={};JXG.Board.prototype.pstricks.givePsTricksToDiv=function(d,e){JXG.PsTricks.givePsTricksToDiv(d,e)};JXG.Ticks=function(d,j,h,k,e,l,f,g){this.constructor();this.type=JXG.OBJECT_TYPE_TICKS;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.line=d;this.board=this.line.board;this.ticksFunction=null;this.fixedTicks=null;this.equidistant=false;if(JXG.isFunction(j)){this.ticksFunction=j;throw new Error("Function arguments are no longer supported.")}else{if(JXG.isArray(j)){this.fixedTicks=j}else{if(Math.abs(j)<JXG.Math.eps){j=this.board.options.line.ticks.defaultDistance}this.ticksFunction=function(m){return j};this.equidistant=true}}this.minorTicks=((h==null)?this.board.options.line.ticks.minorTicks:h);if(this.minorTicks<0){this.minorTicks=-this.minorTicks}this.majorHeight=((k==null)||(k==0)?this.board.options.line.ticks.majorHeight:k);if(this.majorHeight<0){this.majorHeight=-this.majorHeight}this.minorHeight=((e==null)||(e==0)?this.board.options.line.ticks.minorHeight:e);if(this.minorHeight<0){this.minorHeight=-this.minorHeight}this.minTicksDistance=this.board.options.line.ticks.minTicksDistance;this.maxTicksDistance=this.board.options.line.ticks.maxTicksDistance;this.insertTicks=this.board.options.line.ticks.insertTicks;this.drawZero=this.board.options.line.ticks.drawZero;this.drawLabels=this.board.options.line.ticks.drawLabels;this.labels=[];this.init(this.board,l,f);this.visProp.visible=true;this.visProp.fillColor=this.line.visProp.fillColor;this.visProp.highlightFillColor=this.line.visProp.highlightFillColor;this.visProp.strokeColor=this.line.visProp.strokeColor;this.visProp.highlightStrokeColor=this.line.visProp.highlightStrokeColor;this.visProp.strokeWidth=this.line.visProp.strokeWidth;this.id=this.line.addTicks(this)};JXG.Ticks.prototype=new JXG.GeometryElement;JXG.Ticks.prototype.hasPoint=function(d,e){return false};JXG.Ticks.prototype.calculateTicksCoordinates=function(){var N=this.line.point1,M=this.line.point2,g=N.coords.distance(JXG.COORDS_BY_USER,M.coords),m=(M.coords.usrCoords[1]-N.coords.usrCoords[1])/g,l=(M.coords.usrCoords[2]-N.coords.usrCoords[2])/g,v=N.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1]+m,N.coords.usrCoords[2]+l],this.board)),D=(this.equidistant?this.ticksFunction(1):1),J=5,y,w,O=1,n,t,A,s,K,E,Q=function(W,j,T,S,V){var U,R;U=W.toString();if(U.length>5){U=W.toPrecision(3).toString()}R=new JXG.Text(T,U,null,[j.usrCoords[1],j.usrCoords[2]],V+K+"Label","",null,true,T.options.text.defaultDisplay);R.distanceX=0;R.distanceY=-10;R.setCoords(j.usrCoords[1]*1+R.distanceX/(T.stretchX),j.usrCoords[2]*1+R.distanceY/(T.stretchY));if(S){R.visProp.visible=true}else{R.visProp.visible=false}return R},d=function(j){return Math.floor(j)-(Math.floor(j)%D)},z=JXG.Math.eps,u=-this.line.getSlope(),L=this.majorHeight/2,h=this.minorHeight/2,f=0,C=0,B=0,P=0;if(Math.abs(u)<z){f=0;C=L;B=0;P=h}else{if((Math.abs(u)>1/z)||(isNaN(u))){f=L;C=0;B=h;P=0}else{f=-L/Math.sqrt(1/(u*u)+1);C=f/u;B=-h/Math.sqrt(1/(u*u)+1);P=B/u}}if(this.ticks!=null){for(var I=0;I<this.ticks.length;I++){if(this.labels[I]!=null&&this.labels[I].visProp.visible){this.board.renderer.remove(this.labels[I].rendNode)}}}this.ticks=new Array();this.labels=new Array();y=new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1],N.coords.usrCoords[2]],this.board);w=new JXG.Coords(JXG.COORDS_BY_USER,[M.coords.usrCoords[1],M.coords.usrCoords[2]],this.board);this.board.renderer.calcStraight(this.line,y,w);if(!this.equidistant){var r=N.coords.usrCoords[1]-y.usrCoords[1];var q=N.coords.usrCoords[2]-y.usrCoords[2];var x=Math.sqrt(r*r+q*q);var k=N.coords.usrCoords[1]-w.usrCoords[1];var F=N.coords.usrCoords[2]-w.usrCoords[2];var e=Math.sqrt(k*k+F*F);var H=0;var G=0;for(var K=0;K<this.fixedTicks.length;K++){if((-x<=this.fixedTicks[K])&&(this.fixedTicks[K]<=e)){if(this.fixedTicks[K]<0){H=Math.abs(r)*this.fixedTicks[K]/x;G=Math.abs(q)*this.fixedTicks[K]/x}else{H=Math.abs(k)*this.fixedTicks[K]/e;G=Math.abs(F)*this.fixedTicks[K]/e}A=new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1]+H,N.coords.usrCoords[2]+G],this.board);this.ticks.push(A);this.ticks[this.ticks.length-1].major=true;this.labels.push(Q(this.fixedTicks[K],A,this.board,this.drawLabels,this.id))}}this.board.renderer.updateTicks(this,f,C,B,P);return}while(v>4*this.minTicksDistance){D/=10;m/=10;l/=10;v=N.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1]+m,N.coords.usrCoords[2]+l],this.board))}while(v<this.minTicksDistance){D*=J;m*=J;l*=J;J=(J==5?2:5);v=N.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1]+m,N.coords.usrCoords[2]+l],this.board))}if(this.board.renderer.isSameDirection(N.coords,y,w)){n=d(N.coords.distance(JXG.COORDS_BY_USER,y));t=N.coords.distance(JXG.COORDS_BY_USER,w);if(this.board.renderer.isSameDirection(N.coords,M.coords,y)){if(this.line.visProp.straightFirst){n-=2*D}}else{t=-1*t;n=-1*n;if(this.line.visProp.straightFirst){n-=2*D}}}else{if(!this.line.visProp.straightFirst){n=0}else{n=-d(N.coords.distance(JXG.COORDS_BY_USER,y))-2*D}if(!this.line.visProp.straightLast){t=g}else{t=N.coords.distance(JXG.COORDS_BY_USER,w)}}s=new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1]+n*m/D,N.coords.usrCoords[2]+n*l/D],this.board);A=new JXG.Coords(JXG.COORDS_BY_USER,[N.coords.usrCoords[1]+n*m/D,N.coords.usrCoords[2]+n*l/D],this.board);m/=this.minorTicks+1;l/=this.minorTicks+1;K=0;E=n;while(s.distance(JXG.COORDS_BY_USER,A)<Math.abs(t-n)+JXG.Math.eps){if(K%(this.minorTicks+1)==0){A.major=true;this.labels.push(Q(E,A,this.board,this.drawLabels,this.id));E+=D}else{A.major=false;this.labels.push(null)}K++;this.ticks.push(A);A=new JXG.Coords(JXG.COORDS_BY_USER,[A.usrCoords[1]+m,A.usrCoords[2]+l],this.board);if(!this.drawZero&&A.distance(JXG.COORDS_BY_USER,N.coords)<=JXG.Math.eps){K++;E+=D;A=new JXG.Coords(JXG.COORDS_BY_USER,[A.usrCoords[1]+m,A.usrCoords[2]+l],this.board)}}this.board.renderer.updateTicks(this,f,C,B,P);return};JXG.Ticks.prototype.updateRenderer=function(){if(this.needsUpdate){this.calculateTicksCoordinates();this.needsUpdate=false}};JXG.createTicks=function(g,e,d){var f;d=JXG.checkAttributes(d,{layer:null});if((e[0].elementClass==JXG.OBJECT_CLASS_LINE)&&(JXG.isFunction(e[1])||JXG.isArray(e[1])||JXG.isNumber(e[1]))){f=new JXG.Ticks(e[0],e[1],d.minorTicks,d.majHeight,d.minHeight,d.id,d.name,d.layer)}else{throw new Error("JSXGraph: Can't create Ticks with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.")}return f};JXG.JSXGraph.registerElement("ticks",JXG.createTicks);JXG.Util={};JXG.Util.Unzip=function(W){var s=[],J="",H=false,E,K=0,T=[],w,l=new Array(32768),ab=0,O=false,Y,L,aa=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255],ae=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],V=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99],P=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],D=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],t=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],A=W,e=0,k=0,af=1,d=0,ad=256,j=[],n;function g(){d+=8;if(e<A.length){return A[e++]}else{return -1}}function u(){af=1}function Z(){var ah;d++;ah=(af&1);af>>=1;if(af==0){af=g();ah=(af&1);af=(af>>1)|128}return ah}function X(ah){var aj=0,ai=ah;while(ai--){aj=(aj<<1)|Z()}if(ah){aj=aa[aj]>>(8-ah)}return aj}function f(){ab=0}function B(ah){L++;l[ab++]=ah;s.push(String.fromCharCode(ah));if(ab==32768){ab=0}}function r(){this.b0=0;this.b1=0;this.jump=null;this.jumppos=-1}var h=288;var z=new Array(h);var R=new Array(32);var M=0;var ac=null;var v=null;var Q=new Array(64);var N=new Array(64);var C=0;var G=new Array(17);G[0]=0;var S;var y;function m(){while(1){if(G[C]>=y){return -1}if(S[G[C]]==C){return G[C]++}G[C]++}}function I(){var ai=ac[M];var ah;if(H){document.write("<br>len:"+C+" treepos:"+M)}if(C==17){return -1}M++;C++;ah=m();if(H){document.write("<br>IsPat "+ah)}if(ah>=0){ai.b0=ah;if(H){document.write("<br>b0 "+ai.b0)}}else{ai.b0=32768;if(H){document.write("<br>b0 "+ai.b0)}if(I()){return -1}}ah=m();if(ah>=0){ai.b1=ah;if(H){document.write("<br>b1 "+ai.b1)}ai.jump=null}else{ai.b1=32768;if(H){document.write("<br>b1 "+ai.b1)}ai.jump=ac[M];ai.jumppos=M;if(I()){return -1}}C--;return 0}function q(al,aj,am,ai){var ak;if(H){document.write("currentTree "+al+" numval "+aj+" lengths "+am+" show "+ai)}ac=al;M=0;S=am;y=aj;for(ak=0;ak<17;ak++){G[ak]=0}C=0;if(I()){if(H){alert("invalid huffman tree\n")}return -1}if(H){document.write("<br>Tree: "+ac.length);for(var ah=0;ah<32;ah++){document.write("Places["+ah+"].b0="+ac[ah].b0+"<br>");document.write("Places["+ah+"].b1="+ac[ah].b1+"<br>")}}return 0}function F(ak){var ai,aj,am=0,al=ak[am],ah;while(1){ah=Z();if(H){document.write("b="+ah)}if(ah){if(!(al.b1&32768)){if(H){document.write("ret1")}return al.b1}al=al.jump;ai=ak.length;for(aj=0;aj<ai;aj++){if(ak[aj]===al){am=aj;break}}}else{if(!(al.b0&32768)){if(H){document.write("ret2")}return al.b0}am++;al=ak[am]}}if(H){document.write("ret3")}return -1}function ag(){var al,ay,ai,aw,ax;do{al=Z();ai=X(2);switch(ai){case 0:if(H){alert("Stored\n")}break;case 1:if(H){alert("Fixed Huffman codes\n")}break;case 2:if(H){alert("Dynamic Huffman codes\n")}break;case 3:if(H){alert("Reserved block type!!\n")}break;default:if(H){alert("Unexpected value %d!\n",ai)}break}if(ai==0){var au,ah;u();au=g();au|=(g()<<8);ah=g();ah|=(g()<<8);if(((au^~ah)&65535)){document.write("BlockLen checksum mismatch\n")}while(au--){ay=g();B(ay)}}else{if(ai==1){var av;while(1){av=(aa[X(7)]>>1);if(av>23){av=(av<<1)|Z();if(av>199){av-=128;av=(av<<1)|Z()}else{av-=48;if(av>143){av=av+136}}}else{av+=256}if(av<256){B(av)}else{if(av==256){break}else{var ax,aq;av-=256+1;ax=X(V[av])+ae[av];av=aa[X(5)]>>3;if(D[av]>8){aq=X(8);aq|=(X(D[av]-8)<<8)}else{aq=X(D[av])}aq+=P[av];for(av=0;av<ax;av++){var ay=l[(ab-aq)&32767];B(ay)}}}}}else{if(ai==2){var av,ar,aj,ao,ap;var an=new Array(288+32);aj=257+X(5);ao=1+X(5);ap=4+X(4);for(av=0;av<19;av++){an[av]=0}for(av=0;av<ap;av++){an[t[av]]=X(3)}ax=R.length;for(aw=0;aw<ax;aw++){R[aw]=new r()}if(q(R,19,an,0)){f();return 1}if(H){document.write("<br>distanceTree");for(var az=0;az<R.length;az++){document.write("<br>"+R[az].b0+" "+R[az].b1+" "+R[az].jump+" "+R[az].jumppos)}}ar=aj+ao;aw=0;var ak=-1;if(H){document.write("<br>n="+ar+" bits: "+d+"<br>")}while(aw<ar){ak++;av=F(R);if(H){document.write("<br>"+ak+" i:"+aw+" decode: "+av+"    bits "+d+"<br>")}if(av<16){an[aw++]=av}else{if(av==16){var at;av=3+X(2);if(aw+av>ar){f();return 1}at=aw?an[aw-1]:0;while(av--){an[aw++]=at}}else{if(av==17){av=3+X(3)}else{av=11+X(7)}if(aw+av>ar){f();return 1}while(av--){an[aw++]=0}}}}ax=z.length;for(aw=0;aw<ax;aw++){z[aw]=new r()}if(q(z,aj,an,0)){f();return 1}ax=z.length;for(aw=0;aw<ax;aw++){R[aw]=new r()}var am=new Array();for(aw=aj;aw<an.length;aw++){am[aw-aj]=an[aw]}if(q(R,ao,am,0)){f();return 1}if(H){document.write("<br>literalTree")}while(1){av=F(z);if(av>=256){var ax,aq;av-=256;if(av==0){break}av--;ax=X(V[av])+ae[av];av=F(R);if(D[av]>8){aq=X(8);aq|=(X(D[av]-8)<<8)}else{aq=X(D[av])}aq+=P[av];while(ax--){var ay=l[(ab-aq)&32767];B(ay)}}else{B(av)}}}}}}while(!al);f();u();return 0}JXG.Util.Unzip.prototype.unzipFile=function(ah){var ai;this.unzip();for(ai=0;ai<T.length;ai++){if(T[ai][1]==ah){return T[ai][0]}}};JXG.Util.Unzip.prototype.unzip=function(){if(H){alert(A)}x();return T};function x(){if(H){alert("NEXTFILE")}s=[];var al=[];O=false;al[0]=g();al[1]=g();if(H){alert("type: "+al[0]+" "+al[1])}if(al[0]==parseInt("78",16)&&al[1]==parseInt("da",16)){if(H){alert("GEONExT-GZIP")}ag();if(H){alert(s.join(""))}T[K]=new Array(2);T[K][0]=s.join("");T[K][1]="geonext.gxt";K++}if(al[0]==parseInt("1f",16)&&al[1]==parseInt("8b",16)){if(H){alert("GZIP")}U();if(H){alert(s.join(""))}T[K]=new Array(2);T[K][0]=s.join("");T[K][1]="file";K++}if(al[0]==parseInt("50",16)&&al[1]==parseInt("4b",16)){O=true;al[2]=g();al[3]=g();if(al[2]==parseInt("3",16)&&al[3]==parseInt("4",16)){al[0]=g();al[1]=g();if(H){alert("ZIP-Version: "+al[1]+" "+al[0]/10+"."+al[0]%10)}E=g();E|=(g()<<8);if(H){alert("gpflags: "+E)}var ah=g();ah|=(g()<<8);if(H){alert("method: "+ah)}g();g();g();g();var am=g();am|=(g()<<8);am|=(g()<<16);am|=(g()<<24);var ak=g();ak|=(g()<<8);ak|=(g()<<16);ak|=(g()<<24);var ap=g();ap|=(g()<<8);ap|=(g()<<16);ap|=(g()<<24);if(H){alert("local CRC: "+am+"\nlocal Size: "+ap+"\nlocal CompSize: "+ak)}var ai=g();ai|=(g()<<8);var ao=g();ao|=(g()<<8);if(H){alert("filelen "+ai)}aj=0;j=[];while(ai--){var an=g();if(an=="/"|an==":"){aj=0}else{if(aj<ad-1){j[aj++]=String.fromCharCode(an)}}}if(H){alert("nameBuf: "+j)}if(!n){n=j}var aj=0;while(aj<ao){an=g();aj++}Y=4294967295;L=0;if(ap=0&&fileOut.charAt(n.length-1)=="/"){if(H){alert("skipdir")}}if(ah==8){ag();if(H){alert(s.join(""))}T[K]=new Array(2);T[K][0]=s.join("");T[K][1]=j.join("");K++}U()}}}function U(){var am,aj=[],ak,ai,al,ah,an;if((E&8)){aj[0]=g();aj[1]=g();aj[2]=g();aj[3]=g();if(aj[0]==parseInt("50",16)&&aj[1]==parseInt("4b",16)&&aj[2]==parseInt("07",16)&&aj[3]==parseInt("08",16)){am=g();am|=(g()<<8);am|=(g()<<16);am|=(g()<<24)}else{am=aj[0]|(aj[1]<<8)|(aj[2]<<16)|(aj[3]<<24)}ak=g();ak|=(g()<<8);ak|=(g()<<16);ak|=(g()<<24);ai=g();ai|=(g()<<8);ai|=(g()<<16);ai|=(g()<<24);if(H){alert("CRC:")}}if(O){x()}aj[0]=g();if(aj[0]!=8){if(H){alert("Unknown compression method!")}return 0}E=g();if(H){if((E&~(parseInt("1f",16)))){alert("Unknown flags set!")}}g();g();g();g();g();al=g();if((E&4)){aj[0]=g();aj[2]=g();C=aj[0]+256*aj[1];if(H){alert("Extra field size: "+C)}for(ah=0;ah<C;ah++){g()}}if((E&8)){ah=0;j=[];while(an=g()){if(an=="7"||an==":"){ah=0}if(ah<ad-1){j[ah++]=an}}if(H){alert("original file name: "+j)}}if((E&16)){while(an=g()){}}if((E&2)){g();g()}ag();am=g();am|=(g()<<8);am|=(g()<<16);am|=(g()<<24);ai=g();ai|=(g()<<8);ai|=(g()<<16);ai|=(g()<<24);if(O){x()}}};JXG.Util.Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(f){var d=[],n,l,j,m,k,h,g,e=0;f=JXG.Util.Base64._utf8_encode(f);while(e<f.length){n=f.charCodeAt(e++);l=f.charCodeAt(e++);j=f.charCodeAt(e++);m=n>>2;k=((n&3)<<4)|(l>>4);h=((l&15)<<2)|(j>>6);g=j&63;if(isNaN(l)){h=g=64}else{if(isNaN(j)){g=64}}d.push([this._keyStr.charAt(m),this._keyStr.charAt(k),this._keyStr.charAt(h),this._keyStr.charAt(g)].join(""))}return d.join("")},decode:function(g,f){var d=[],q,m,k,n,l,j,h,e=0;g=g.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(e<g.length){n=this._keyStr.indexOf(g.charAt(e++));l=this._keyStr.indexOf(g.charAt(e++));j=this._keyStr.indexOf(g.charAt(e++));h=this._keyStr.indexOf(g.charAt(e++));q=(n<<2)|(l>>4);m=((l&15)<<4)|(j>>2);k=((j&3)<<6)|h;d.push(String.fromCharCode(q));if(j!=64){d.push(String.fromCharCode(m))}if(h!=64){d.push(String.fromCharCode(k))}}d=d.join("");if(f){d=JXG.Util.Base64._utf8_decode(d)}return d},_utf8_encode:function(e){e=e.replace(/\r\n/g,"\n");var d="";for(var g=0;g<e.length;g++){var f=e.charCodeAt(g);if(f<128){d+=String.fromCharCode(f)}else{if((f>127)&&(f<2048)){d+=String.fromCharCode((f>>6)|192);d+=String.fromCharCode((f&63)|128)}else{d+=String.fromCharCode((f>>12)|224);d+=String.fromCharCode(((f>>6)&63)|128);d+=String.fromCharCode((f&63)|128)}}}return d},_utf8_decode:function(d){var f=[],h=0,j=0,g=0,e=0;while(h<d.length){j=d.charCodeAt(h);if(j<128){f.push(String.fromCharCode(j));h++}else{if((j>191)&&(j<224)){g=d.charCodeAt(h+1);f.push(String.fromCharCode(((j&31)<<6)|(g&63)));h+=2}else{g=d.charCodeAt(h+1);e=d.charCodeAt(h+2);f.push(String.fromCharCode(((j&15)<<12)|((g&63)<<6)|(e&63)));h+=3}}}return f.join("")},_destrip:function(j,g){var e=[],h,f,d=[];if(g==null){g=76}j.replace(/ /g,"");h=j.length/g;for(f=0;f<h;f++){e[f]=j.substr(f*g,g)}if(h!=j.length/g){e[e.length]=j.substr(h*g,j.length-(h*g))}for(f=0;f<e.length;f++){d.push(e[f])}return d.join("\n")},decodeAsArray:function(e){var g=this.decode(e),d=[],f;for(f=0;f<g.length;f++){d[f]=g.charCodeAt(f)}return d},decodeGEONExT:function(d){return decodeAsArray(destrip(d),false)}};JXG.Util.asciiCharCodeAt=function(e,d){var f=e.charCodeAt(d);if(f>255){switch(f){case 8364:f=128;break;case 8218:f=130;break;case 402:f=131;break;case 8222:f=132;break;case 8230:f=133;break;case 8224:f=134;break;case 8225:f=135;break;case 710:f=136;break;case 8240:f=137;break;case 352:f=138;break;case 8249:f=139;break;case 338:f=140;break;case 381:f=142;break;case 8216:f=145;break;case 8217:f=146;break;case 8220:f=147;break;case 8221:f=148;break;case 8226:f=149;break;case 8211:f=150;break;case 8212:f=151;break;case 732:f=152;break;case 8482:f=153;break;case 353:f=154;break;case 8250:f=155;break;case 339:f=156;break;case 382:f=158;break;case 376:f=159;break;default:break}}return f};JXG.Util.utf8Decode=function(d){var e=[];var g=0;var j=0,h=0,f=0;if(d===JXG.undefined){return""}while(g<d.length){j=d.charCodeAt(g);if(j<128){e.push(String.fromCharCode(j));g++}else{if((j>191)&&(j<224)){f=d.charCodeAt(g+1);e.push(String.fromCharCode(((j&31)<<6)|(f&63)));g+=2}else{f=d.charCodeAt(g+1);c3=d.charCodeAt(g+2);e.push(String.fromCharCode(((j&15)<<12)|((f&63)<<6)|(c3&63)));g+=3}}}return e.join("")};JXG.Util.genUUID=function(){var h="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),f=new Array(36),e=0,g;for(var d=0;d<36;d++){if(d==8||d==13||d==18||d==23){f[d]="-"}else{if(d==14){f[d]="4"}else{if(e<=2){e=33554432+(Math.random()*16777216)|0}g=e&15;e=e>>4;f[d]=h[(d==19)?(g&3)|8:g]}}}return f.join("")};JXG.PsTricks=new function(){this.psTricksString=""};JXG.PsTricks.convertBoardToPsTricks=function(e){var g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e.canvasWidth,e.canvasHeight],e);var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],e);this.psTricksString="\\begin{pspicture*}("+f.usrCoords[1]+","+g.usrCoords[2]+")("+g.usrCoords[1]+","+f.usrCoords[2]+")\n";for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_ARC){if(h.visProp.visible){this.addSector(h)}}}for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_POLYGON){if(h.visProp.visible){this.addPolygon(h)}}}for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_ANGLE){if(h.visProp.visible){this.addAngle(h)}}}for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_CIRCLE){if(h.visProp.visible){this.addCircle(h)}}}for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_ARC){if(h.visProp.visible){this.addArc(h)}}}for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_LINE){if(h.visProp.visible){this.addLine(h)}}}for(var d in e.objects){var h=e.objects[d];if(h.type==JXG.OBJECT_TYPE_POINT){if(h.visProp.visible){this.addPoint(h)}}}this.psTricksString+="\\end{pspicture*}"};JXG.PsTricks.givePsTricksToDiv=function(d,e){this.convertBoardToPsTricks(e);document.getElementById(d).innerHTML=this.psTricksString};JXG.PsTricks.addPoint=function(d){this.psTricksString+="\\psdot";this.psTricksString+="[linecolor="+this.parseColor(d.visProp.strokeColor)+",";this.psTricksString+="dotstyle=";if(d.visProp.face=="cross"){this.psTricksString+="x, dotsize=";if(d.visProp.size==2){this.psTricksString+="2pt 2"}else{if(d.visProp.size==3){this.psTricksString+="5pt 2"}else{if(d.visProp.size>=4){this.psTricksString+="5pt 3"}}}}else{if(d.visProp.face=="circle"){this.psTricksString+="*, dotsize=";if(d.visProp.size==1){this.psTricksString+="2pt 2"}else{if(d.visProp.size==2){this.psTricksString+="4pt 2"}else{if(d.visProp.size==3){this.psTricksString+="6pt 2"}else{if(d.visProp.size>=4){this.psTricksString+="6pt 3"}}}}}else{if(d.visProp.face=="square"){this.psTricksString+="square*, dotsize=";if(d.visProp.size==2){this.psTricksString+="2pt 2"}else{if(d.visProp.size==3){this.psTricksString+="5pt 2"}else{if(d.visProp.size>=4){this.psTricksString+="5pt 3"}}}}else{if(d.visProp.face=="plus"){this.psTricksString+="+, dotsize=";if(d.visProp.size==2){this.psTricksString+="2pt 2"}else{if(d.visProp.size==3){this.psTricksString+="5pt 2"}else{if(d.visProp.size>=4){this.psTricksString+="5pt 3"}}}}}}}this.psTricksString+="]";this.psTricksString+="("+d.coords.usrCoords[1]+","+d.coords.usrCoords[2]+")\n";this.psTricksString+="\\rput("+(d.coords.usrCoords[1]+15/d.board.stretchY)+","+(d.coords.usrCoords[2]+15/d.board.stretchY)+"){\\small $"+d.name+"$}\n"};JXG.PsTricks.addLine=function(f){var e=new JXG.Coords(JXG.COORDS_BY_USER,f.point1.coords.usrCoords,f.board);var d=new JXG.Coords(JXG.COORDS_BY_USER,f.point2.coords.usrCoords,f.board);if(f.visProp.straightFirst||f.visProp.straightLast){f.board.renderer.calcStraight(f,e,d)}this.psTricksString+="\\psline";this.psTricksString+="[linecolor="+this.parseColor(f.visProp.strokeColor)+", linewidth="+f.visProp.strokeWidth+"px";this.psTricksString+="]";if(f.visProp.firstArrow){if(f.visProp.lastArrow){this.psTricksString+="{<->}"}else{this.psTricksString+="{<-}"}}else{if(f.visProp.lastArrow){this.psTricksString+="{->}"}}this.psTricksString+="("+e.usrCoords[1]+","+e.usrCoords[2]+")("+d.usrCoords[1]+","+d.usrCoords[2]+")\n"};JXG.PsTricks.addCircle=function(e){var d=e.Radius();this.psTricksString+="\\pscircle";this.psTricksString+="[linecolor="+this.parseColor(e.visProp.strokeColor)+", linewidth="+e.visProp.strokeWidth+"px";if(e.visProp.fillColor!="none"&&e.visProp.fillOpacity!=0){this.psTricksString+=", fillstyle=solid, fillcolor="+this.parseColor(e.visProp.fillColor)+", opacity="+e.visProp.fillOpacity.toFixed(5)}this.psTricksString+="]";this.psTricksString+="("+e.midpoint.coords.usrCoords[1]+","+e.midpoint.coords.usrCoords[2]+"){"+d+"}\n"};JXG.PsTricks.addPolygon=function(e){this.psTricksString+="\\pspolygon";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(e.visProp.fillColor)+", opacity="+e.visProp.fillOpacity.toFixed(5)+"]";for(var d=0;d<e.vertices.length;d++){this.psTricksString+="("+e.vertices[d].coords.usrCoords[1]+","+e.vertices[d].coords.usrCoords[2]+")"}this.psTricksString+="\n"};JXG.PsTricks.addArc=function(e){var d=e.Radius();var g={};g.coords=new JXG.Coords(JXG.COORDS_BY_USER,[e.board.canvasWidth/(e.board.stretchY),e.midpoint.coords.usrCoords[2]],e.board);var f=JXG.Math.Geometry.trueAngle(g,e.midpoint,e.point2).toFixed(4);var h=JXG.Math.Geometry.trueAngle(g,e.midpoint,e.point3).toFixed(4);this.psTricksString+="\\psarc";this.psTricksString+="[linecolor="+this.parseColor(e.visProp.strokeColor)+", linewidth="+e.visProp.strokeWidth+"px";this.psTricksString+="]";if(e.visProp.lastArrow){if(e.visProp.firstArrow){this.psTricksString+="{<->}"}else{this.psTricksString+="{<-}"}}else{if(e.visProp.firstArrow){this.psTricksString+="{->}"}}this.psTricksString+="("+e.midpoint.coords.usrCoords[1]+","+e.midpoint.coords.usrCoords[2]+"){"+d+"}{"+f+"}{"+h+"}\n"};JXG.PsTricks.addSector=function(e){var d=e.Radius();var g={};g.coords=new JXG.Coords(JXG.COORDS_BY_USER,[e.board.canvasWidth/(e.board.stretchY),e.midpoint.coords.usrCoords[2]],e.board);var f=JXG.Math.Geometry.trueAngle(g,e.midpoint,e.point2).toFixed(4);var h=JXG.Math.Geometry.trueAngle(g,e.midpoint,e.point3).toFixed(4);if(e.visProp.fillColor!="none"&&e.visProp.fillOpacity!=0){this.psTricksString+="\\pswedge";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(e.visProp.fillColor)+", opacity="+e.visProp.fillOpacity.toFixed(5)+"]";this.psTricksString+="("+e.midpoint.coords.usrCoords[1]+","+e.midpoint.coords.usrCoords[2]+"){"+d+"}{"+f+"}{"+h+"}\n"}};JXG.PsTricks.addAngle=function(e){var d=e.radius;var g={};g.coords=new JXG.Coords(JXG.COORDS_BY_USER,[e.board.canvasWidth/(e.board.stretchY),e.point2.coords.usrCoords[2]],e.board);var f=JXG.Math.Geometry.trueAngle(g,e.point2,e.point1).toFixed(4);var h=JXG.Math.Geometry.trueAngle(g,e.point2,e.point3).toFixed(4);if(e.visProp.fillColor!="none"&&e.visProp.fillOpacity!=0){this.psTricksString+="\\pswedge";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(e.visProp.fillColor)+", opacity="+e.visProp.fillOpacity.toFixed(5)+"]";this.psTricksString+="("+e.point2.coords.usrCoords[1]+","+e.point2.coords.usrCoords[2]+"){"+d+"}{"+f+"}{"+h+"}\n"}this.psTricksString+="\\psarc";this.psTricksString+="[linecolor="+this.parseColor(e.visProp.strokeColor)+", linewidth="+e.visProp.strokeWidth+"px";this.psTricksString+="]";this.psTricksString+="("+e.point2.coords.usrCoords[1]+","+e.point2.coords.usrCoords[2]+"){"+d+"}{"+f+"}{"+h+"}\n"};JXG.PsTricks.parseColor=function(e){var d=JXG.rgbParser(e);return"{[rgb]{"+d[0]/255+","+d[1]/255+","+d[2]/255+"}}"};JXG.Server=function(){};JXG.Server.modules=function(){};JXG.Server.runningCalls={};JXG.Server.handleError=function(d){alert("error occured, server says: "+d.message)};JXG.Server.callServer=function(h,r,j,n){var q,e,m,g,d,l,f;n=n||false;g="";for(f in j){g+="&"+escape(f)+"="+escape(j[f])}l=JXG.toJSON(j);do{d=h+Math.floor(Math.random()*4096)}while(typeof this.runningCalls[d]!="undefined");this.runningCalls[d]={action:h};if(typeof j.module!="undefined"){this.runningCalls[d].module=j.module}q=JXG.serverBase+"JXGServer.py";e="action="+escape(h)+"&id="+d+"&dataJSON="+escape(JXG.Util.Base64.encode(l));this.cbp=function(x){var z,t,u,w,y,k,v,s;z=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(x))).unzip();if(JXG.isArray(z)&&z.length>0){z=z[0][0]}if(typeof z!="string"){return}t=window.JSON&&window.JSON.parse?window.JSON.parse(z):(new Function("return "+z))();if(t.type=="error"){this.handleError(t)}else{if(t.type=="response"){k=t.id;for(v=0;v<t.fields.length;v++){u=t.fields[v];w=u.namespace+(typeof((new Function("return "+u.namespace))())=="object"?".":".prototype.")+u.name+" = "+u.value;(new Function(w))()}for(v=0;v<t.handler.length;v++){u=t.handler[v];y=[];for(s=0;s<u.parameters.length;s++){y[s]='"'+u.parameters[s]+'": '+u.parameters[s]}w="if(typeof JXG.Server.modules."+this.runningCalls[k].module+' == "undefined")JXG.Server.modules.'+this.runningCalls[k].module+" = {};";w+="JXG.Server.modules."+this.runningCalls[k].module+"."+u.name+"_cb = "+u.callback+";";w+="JXG.Server.modules."+this.runningCalls[k].module+"."+u.name+" = function ("+u.parameters.join(",")+', __JXGSERVER_CB__, __JXGSERVER_SYNC) {if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.'+this.runningCalls[k].module+"."+u.name+"_cb;var __JXGSERVER_PAR__ = {"+y.join(",")+', "module": "'+this.runningCalls[k].module+'", "handler": "'+u.name+'" };JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__, __JXGSERVER_SYNC);};';(new Function(w))()}delete this.runningCalls[k];r(t.data)}}};this.cb=JXG.bind(this.cbp,this);if(window.XMLHttpRequest){m=new XMLHttpRequest();m.overrideMimeType("text/plain; charset=iso-8859-1")}else{m=new ActiveXObject("Microsoft.XMLHTTP")}if(m){m.open("POST",q,!n);m.setRequestHeader("Content-type","application/x-www-form-urlencoded");if(!n){m.onreadystatechange=(function(k){return function(){switch(m.readyState){case 4:if(m.status!=200){}else{k(m.responseText)}break;default:return false;break}}})(this.cb)}m.send(e);if(n){this.cb(m.responseText)}}else{return false}};JXG.Server.loadModule_cb=function(e){var d;for(d=0;d<e.length;d++){alert(e[d].name+": "+e[d].value)}};JXG.Server.loadModule=function(d){return JXG.Server.callServer("load",JXG.Server.loadModule_cb,{module:d},true)};JXG.Server.load=JXG.Server.loadModule;JXG.DataSource=function(){this.data=[];this.columnHeaders=[];this.rowHeaders=[];return this};JXG.DataSource.prototype.loadFromArray=function(h,k,g){var f,e,d;if(typeof k=="undefined"){k=false}if(typeof g=="undefined"){g=false}if(JXG.isArray(k)){this.columnHeader=k;k=false}if(JXG.isArray(g)){this.rowHeader=g;g=false}this.data=[];if(k){this.columnHeader=[]}if(g){this.rowHeader=[]}if(typeof h!="undefined"){this.data=new Array(h.length);for(f=0;f<h.length;f++){this.data[f]=new Array(h[f].length);for(e=0;e<h[f].length;e++){d=h[f][e];if(""+parseFloat(d)==d){this.data[f][e]=parseFloat(d)}else{if(d!="-"){this.data[f][e]=d}else{this.data[f][e]=NaN}}}}if(k){this.columnHeader=this.data[0].slice(1);this.data=this.data.slice(1)}if(g){this.rowHeader=new Array();for(f=0;f<this.data.length;f++){this.rowHeader.push(this.data[f][0]);this.data[f]=this.data[f].slice(1)}}}return this};JXG.DataSource.prototype.loadFromTable=function(m,f,k){var n,h,g,e,l,d;if(typeof f=="undefined"){f=false}if(typeof k=="undefined"){k=false}if(JXG.isArray(f)){this.columnHeader=f;f=false}if(JXG.isArray(k)){this.rowHeader=k;k=false}this.data=[];if(f){this.columnHeader=[]}if(k){this.rowHeader=[]}m=document.getElementById(m);if(typeof m!="undefined"){n=m.getElementsByTagName("tr");this.data=new Array(n.length);for(h=0;h<n.length;h++){e=n[h].getElementsByTagName("td");this.data[h]=new Array(e.length);for(g=0;g<e.length;g++){l=e[g].innerHTML;if(""+parseFloat(l)==l){this.data[h][g]=parseFloat(l)}else{if(l!="-"){this.data[h][g]=l}else{this.data[h][g]=NaN}}}}if(f){this.columnHeader=this.data[0].slice(1);this.data=this.data.slice(1)}if(k){this.rowHeader=new Array();for(h=0;h<this.data.length;h++){this.rowHeader.push(this.data[h][0]);this.data[h]=this.data[h].slice(1)}}}return this};JXG.DataSource.prototype.addColumn=function(d,f,e){};JXG.DataSource.prototype.addRow=function(d,f,e){};JXG.DataSource.prototype.getColumn=function(e){var d=new Array(this.data.length),f;if(typeof e=="string"){for(f=0;f<this.columnHeader.length;f++){if(e==this.columnHeader[f]){e=f;break}}}for(f=0;f<this.data.length;f++){if(this.data[f].length>e){d[f]=this.data[f][e]}}return d};JXG.DataSource.prototype.getRow=function(f){var d,e;if(typeof f=="string"){for(e=0;e<this.rowHeader.length;e++){if(f==this.rowHeader[e]){f=e;break}}}d=new Array(this.data[f].length);for(e=0;e<this.data[f].length;e++){d[e]=this.data[f][e]}return d};JXG.SVGRenderer=function(d){var e;this.constructor();this.svgRoot=null;this.suspendHandle=null;this.svgNamespace="http://www.w3.org/2000/svg";this.xlinkNamespace="http://www.w3.org/1999/xlink";this.container=d;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position==""){this.container.style.position="relative"}this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg");this.svgRoot.style.overflow="hidden";this.svgRoot.style.width=this.container.style.width;this.svgRoot.style.height=this.container.style.height;this.container.appendChild(this.svgRoot);this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs");this.svgRoot.appendChild(this.defs);this.filter=this.container.ownerDocument.createElementNS(this.svgNamespace,"filter");this.filter.setAttributeNS(null,"id",this.container.id+"_f1");this.filter.setAttributeNS(null,"width","300%");this.filter.setAttributeNS(null,"height","300%");this.feOffset=this.container.ownerDocument.createElementNS(this.svgNamespace,"feOffset");this.feOffset.setAttributeNS(null,"result","offOut");this.feOffset.setAttributeNS(null,"in","SourceAlpha");this.feOffset.setAttributeNS(null,"dx","5");this.feOffset.setAttributeNS(null,"dy","5");this.filter.appendChild(this.feOffset);this.feGaussianBlur=this.container.ownerDocument.createElementNS(this.svgNamespace,"feGaussianBlur");this.feGaussianBlur.setAttributeNS(null,"result","blurOut");this.feGaussianBlur.setAttributeNS(null,"in","offOut");this.feGaussianBlur.setAttributeNS(null,"stdDeviation","3");this.filter.appendChild(this.feGaussianBlur);this.feBlend=this.container.ownerDocument.createElementNS(this.svgNamespace,"feBlend");this.feBlend.setAttributeNS(null,"in","SourceGraphic");this.feBlend.setAttributeNS(null,"in2","blurOut");this.feBlend.setAttributeNS(null,"mode","normal");this.filter.appendChild(this.feBlend);this.defs.appendChild(this.filter);this.layer=[];for(e=0;e<JXG.Options.layer.numlayers;e++){this.layer[e]=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.layer[e])}this.dashArray=["2, 2","5, 5","10, 10","20, 20","20, 10, 10, 10","20, 5, 10, 5"]};JXG.SVGRenderer.prototype=new JXG.AbstractRenderer;JXG.SVGRenderer.prototype.setShadow=function(d){if(d.visPropOld.shadow==d.visProp.shadow){return}if(d.rendNode!=null){if(d.visProp.shadow){d.rendNode.setAttributeNS(null,"filter","url(#"+this.container.id+"_f1)")}else{d.rendNode.removeAttributeNS(null,"filter")}}d.visPropOld.shadow=d.visProp.shadow};JXG.SVGRenderer.prototype.setGradient=function(f){var q=f.rendNode,g,j,h,n,m,e,d,l,k;if(typeof f.visProp.fillOpacity=="function"){j=f.visProp.fillOpacity()}else{j=f.visProp.fillOpacity}j=(j>0)?j:0;if(typeof f.visProp.fillColor=="function"){g=f.visProp.fillColor()}else{g=f.visProp.fillColor}if(f.visProp.gradient=="linear"){h=this.createPrim("linearGradient",f.id+"_gradient");e="0%";d="100%";l="0%";k="0%";h.setAttributeNS(null,"x1",e);h.setAttributeNS(null,"x2",d);h.setAttributeNS(null,"y1",l);h.setAttributeNS(null,"y2",k);n=this.createPrim("stop",f.id+"_gradient1");n.setAttributeNS(null,"offset","0%");n.setAttributeNS(null,"style","stop-color:"+g+";stop-opacity:"+j);m=this.createPrim("stop",f.id+"_gradient2");m.setAttributeNS(null,"offset","100%");m.setAttributeNS(null,"style","stop-color:"+f.visProp.gradientSecondColor+";stop-opacity:"+f.visProp.gradientSecondOpacity);h.appendChild(n);h.appendChild(m);this.defs.appendChild(h);q.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+f.id+"_gradient)");f.gradNode1=n;f.gradNode2=m}else{if(f.visProp.gradient=="radial"){h=this.createPrim("radialGradient",f.id+"_gradient");h.setAttributeNS(null,"cx","50%");h.setAttributeNS(null,"cy","50%");h.setAttributeNS(null,"r","50%");h.setAttributeNS(null,"fx",f.visProp.gradientPositionX*100+"%");h.setAttributeNS(null,"fy",f.visProp.gradientPositionY*100+"%");n=this.createPrim("stop",f.id+"_gradient1");n.setAttributeNS(null,"offset","0%");n.setAttributeNS(null,"style","stop-color:"+f.visProp.gradientSecondColor+";stop-opacity:"+f.visProp.gradientSecondOpacity);m=this.createPrim("stop",f.id+"_gradient2");m.setAttributeNS(null,"offset","100%");m.setAttributeNS(null,"style","stop-color:"+g+";stop-opacity:"+j);h.appendChild(n);h.appendChild(m);this.defs.appendChild(h);q.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+f.id+"_gradient)");f.gradNode1=n;f.gradNode2=m}else{q.removeAttributeNS(null,"style")}}};JXG.SVGRenderer.prototype.updateGradient=function(g){var e=g.gradNode1,d=g.gradNode2,f,h;if(e==null||d==0){return}if(typeof g.visProp.fillOpacity=="function"){h=g.visProp.fillOpacity()}else{h=g.visProp.fillOpacity}h=(h>0)?h:0;if(typeof g.visProp.fillColor=="function"){f=g.visProp.fillColor()}else{f=g.visProp.fillColor}if(g.visProp.gradient=="linear"){e.setAttributeNS(null,"style","stop-color:"+f+";stop-opacity:"+h);d.setAttributeNS(null,"style","stop-color:"+g.visProp.gradientSecondColor+";stop-opacity:"+g.visProp.gradientSecondOpacity)}else{if(g.visProp.gradient=="radial"){e.setAttributeNS(null,"style","stop-color:"+g.visProp.gradientSecondColor+";stop-opacity:"+g.visProp.gradientSecondOpacity);d.setAttributeNS(null,"style","stop-color:"+f+";stop-opacity:"+h)}}};JXG.SVGRenderer.prototype.displayCopyright=function(f,g){var e=this.createPrim("text","licenseText"),d;e.setAttributeNS(null,"x","20");e.setAttributeNS(null,"y",2+g);e.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+g+"px; fill:#356AA0;  opacity:0.3;");d=document.createTextNode(f);e.appendChild(d);this.appendChildPrim(e,0)};JXG.SVGRenderer.prototype.drawInternalText=function(d){var e=this.createPrim("text",d.id);e.setAttributeNS(null,"class","JXGtext");e.setAttributeNS(null,"style","'alignment-baseline:middle;");d.rendNodeText=document.createTextNode("");e.appendChild(d.rendNodeText);this.appendChildPrim(e,9);return e};JXG.SVGRenderer.prototype.updateInternalText=function(d){d.rendNode.setAttributeNS(null,"x",(d.coords.scrCoords[1])+"px");d.rendNode.setAttributeNS(null,"y",(d.coords.scrCoords[2])+"px");d.updateText();if(d.htmlStr!=d.plaintextStr){d.rendNodeText.data=d.plaintextStr;d.htmlStr=d.plaintextStr}};JXG.SVGRenderer.prototype.drawTicks=function(d){var e=this.createPrim("path",d.id);this.appendChildPrim(e,d.layer);this.appendNodesToElement(d,"path")};JXG.SVGRenderer.prototype.updateTicks=function(g,h,d,k,e){var j="",l,n,f,m=g.ticks.length;for(l=0;l<m;l++){n=g.ticks[l].scrCoords;if(g.ticks[l].major){if(g.labels[l].visProp.visible){this.drawText(g.labels[l])}j+="M "+(n[1]+h)+" "+(n[2]-d)+" L "+(n[1]-h)+" "+(n[2]+d)+" "}else{j+="M "+(n[1]+k)+" "+(n[2]-e)+" L "+(n[1]-k)+" "+(n[2]+e)+" "}}f=this.getElementById(g.id);if(f==null){f=this.createPrim("path",g.id);this.appendChildPrim(f,g.layer);this.appendNodesToElement(g,"path")}f.setAttributeNS(null,"stroke",g.visProp.strokeColor);f.setAttributeNS(null,"stroke-opacity",g.visProp.strokeOpacity);f.setAttributeNS(null,"stroke-width",g.visProp.strokeWidth);this.updatePathPrim(f,j,g.board)};JXG.SVGRenderer.prototype.drawImage=function(d){var e=this.createPrim("image",d.id);e.setAttributeNS(null,"preserveAspectRatio","none");this.appendChildPrim(e,d.layer);d.rendNode=e;this.updateImage(d)};JXG.SVGRenderer.prototype.updateImageURL=function(e){var d;if(JXG.isFunction(e.url)){d=e.url()}else{d=e.url}e.rendNode.setAttributeNS(this.xlinkNamespace,"xlink:href",d)};JXG.SVGRenderer.prototype.transformImage=function(e,d){var f=e.rendNode,g=f.getAttributeNS(null,"transform");g+=" "+this.joinTransforms(e,d);f.setAttributeNS(null,"transform",g)};JXG.SVGRenderer.prototype.joinTransforms=function(h,f){var j="",e,g,d=f.length;for(e=0;e<d;e++){g=f[e].matrix[1][1]+","+f[e].matrix[2][1]+","+f[e].matrix[1][2]+","+f[e].matrix[2][2]+","+f[e].matrix[1][0]+","+f[e].matrix[2][0];j+="matrix("+g+") "}return j};JXG.SVGRenderer.prototype.transformImageParent=function(f,d){var e,g;if(d!=null){e=d[1][1]+","+d[2][1]+","+d[1][2]+","+d[2][2]+","+d[1][0]+","+d[2][0];g="matrix("+e+")"}else{g=""}f.rendNode.setAttributeNS(null,"transform",g)};JXG.SVGRenderer.prototype.setArrowAtts=function(d,f,e){if(!d){return}d.setAttributeNS(null,"stroke",f);d.setAttributeNS(null,"stroke-opacity",e);d.setAttributeNS(null,"fill",f);d.setAttributeNS(null,"fill-opacity",e)};JXG.SVGRenderer.prototype.setObjectStrokeColor=function(el,color,opacity){var c=this.eval(color),o=this.eval(opacity),node;o=(o>0)?o:0;if(el.visPropOld.strokeColor==c&&el.visPropOld.strokeOpacity==o){return}node=el.rendNode;if(el.type==JXG.OBJECT_TYPE_TEXT){if(el.display=="html"){node.style.color=c}else{node.setAttributeNS(null,"style","fill:"+c)}}else{node.setAttributeNS(null,"stroke",c);node.setAttributeNS(null,"stroke-opacity",o)}if(el.type==JXG.OBJECT_TYPE_ARROW){this.setArrowAtts(el.rendNodeTriangle,c,o)}else{if(el.elementClass==JXG.OBJECT_CLASS_CURVE||el.elementClass==JXG.OBJECT_CLASS_LINE){if(el.visProp.firstArrow){this.setArrowAtts(el.rendNodeTriangleStart,c,o)}if(el.visProp.lastArrow){this.setArrowAtts(el.rendNodeTriangleEnd,c,o)}}}el.visPropOld.strokeColor=c;el.visPropOld.strokeOpacity=o};JXG.SVGRenderer.prototype.setObjectFillColor=function(el,color,opacity){var node,c=this.eval(color),o=this.eval(opacity);o=(o>0)?o:0;if(el.visPropOld.fillColor==c&&el.visPropOld.fillOpacity==o){return}node=el.rendNode;node.setAttributeNS(null,"fill",c);node.setAttributeNS(null,"fill-opacity",o);if(el.visProp.gradient!=null){this.updateGradient(el)}el.visPropOld.fillColor=c;el.visPropOld.fillOpacity=o};JXG.SVGRenderer.prototype.setObjectStrokeWidth=function(el,width){var w=this.eval(width),node;try{if(el.visPropOld.strokeWidth==w){return}}catch(e){}node=el.rendNode;this.setPropertyPrim(node,"stroked","true");if(w!=null){this.setPropertyPrim(node,"stroke-width",w)}el.visPropOld.strokeWidth=w};JXG.SVGRenderer.prototype.hide=function(d){var e;if(d==null){return}e=d.rendNode;e.setAttributeNS(null,"display","none");e.style.visibility="hidden"};JXG.SVGRenderer.prototype.show=function(d){var e=d.rendNode;e.setAttributeNS(null,"display","inline");e.style.visibility="inherit"};JXG.SVGRenderer.prototype.remove=function(d){if(d!=null&&d.parentNode!=null){d.parentNode.removeChild(d)}};JXG.SVGRenderer.prototype.suspendRedraw=function(){if(true){this.suspendHandle=this.svgRoot.suspendRedraw(10000)}};JXG.SVGRenderer.prototype.unsuspendRedraw=function(){if(true){this.svgRoot.unsuspendRedraw(this.suspendHandle);this.svgRoot.forceRedraw()}};JXG.SVGRenderer.prototype.setDashStyle=function(e,d){var g=e.visProp.dash,f=e.rendNode;if(e.visProp.dash>0){f.setAttributeNS(null,"stroke-dasharray",this.dashArray[g-1])}else{if(f.hasAttributeNS(null,"stroke-dasharray")){f.removeAttributeNS(null,"stroke-dasharray")}}};JXG.SVGRenderer.prototype.setGridDash=function(e){var d=this.getElementById(e);this.setPropertyPrim(d,"stroke-dasharray","5, 5")};JXG.SVGRenderer.prototype.createPrim=function(d,f){var e=this.container.ownerDocument.createElementNS(this.svgNamespace,d);e.setAttributeNS(null,"id",this.container.id+"_"+f);e.style.position="absolute";if(d=="path"){e.setAttributeNS(null,"stroke-linecap","butt");e.setAttributeNS(null,"stroke-linejoin","round")}return e};JXG.SVGRenderer.prototype.createArrowHead=function(f,h){var g=f.id+"Triangle",e,d;if(h!=null){g+=h}e=this.createPrim("marker",g);e.setAttributeNS(null,"viewBox","0 0 10 6");e.setAttributeNS(null,"refY","3");e.setAttributeNS(null,"markerUnits","strokeWidth");e.setAttributeNS(null,"markerHeight","12");e.setAttributeNS(null,"markerWidth","10");e.setAttributeNS(null,"orient","auto");e.setAttributeNS(null,"stroke",f.visProp.strokeColor);e.setAttributeNS(null,"stroke-opacity",f.visProp.strokeOpacity);e.setAttributeNS(null,"fill",f.visProp.strokeColor);e.setAttributeNS(null,"fill-opacity",f.visProp.strokeOpacity);d=this.container.ownerDocument.createElementNS(this.svgNamespace,"path");if(h=="End"){e.setAttributeNS(null,"refX","0");d.setAttributeNS(null,"d","M 0 3 L 10 6 L 10 0 z")}else{e.setAttributeNS(null,"refX","10");d.setAttributeNS(null,"d","M 0 0 L 10 3 L 0 6 z")}e.appendChild(d);return e};JXG.SVGRenderer.prototype.makeArrows=function(e){var d;if(e.visPropOld.firstArrow==e.visProp.firstArrow&&e.visPropOld.lastArrow==e.visProp.lastArrow){return}if(e.visProp.firstArrow){d=e.rendNodeTriangleStart;if(d==null){d=this.createArrowHead(e,"End");this.defs.appendChild(d);e.rendNodeTriangleStart=d;e.rendNode.setAttributeNS(null,"marker-start","url(#"+this.container.id+"_"+e.id+"TriangleEnd)")}}else{d=e.rendNodeTriangleStart;if(d!=null){this.remove(d)}}if(e.visProp.lastArrow){d=e.rendNodeTriangleEnd;if(d==null){d=this.createArrowHead(e,"Start");this.defs.appendChild(d);e.rendNodeTriangleEnd=d;e.rendNode.setAttributeNS(null,"marker-end","url(#"+this.container.id+"_"+e.id+"TriangleStart)")}}else{d=e.rendNodeTriangleEnd;if(d!=null){this.remove(d)}}e.visPropOld.firstArrow=e.visProp.firstArrow;e.visPropOld.lastArrow=e.visProp.lastArrow};JXG.SVGRenderer.prototype.updateLinePrim=function(h,e,d,g,f){h.setAttributeNS(null,"x1",e);h.setAttributeNS(null,"y1",d);h.setAttributeNS(null,"x2",g);h.setAttributeNS(null,"y2",f)};JXG.SVGRenderer.prototype.updateCirclePrim=function(f,d,g,e){f.setAttributeNS(null,"cx",(d));f.setAttributeNS(null,"cy",(g));f.setAttributeNS(null,"r",(e))};JXG.SVGRenderer.prototype.updateEllipsePrim=function(e,d,h,g,f){e.setAttributeNS(null,"cx",(d));e.setAttributeNS(null,"cy",(h));e.setAttributeNS(null,"rx",(g));e.setAttributeNS(null,"ry",(f))};JXG.SVGRenderer.prototype.updateRectPrim=function(g,d,j,e,f){g.setAttributeNS(null,"x",(d));g.setAttributeNS(null,"y",(j));g.setAttributeNS(null,"width",(e));g.setAttributeNS(null,"height",(f))};JXG.SVGRenderer.prototype.updatePathPrim=function(e,f,d){e.setAttributeNS(null,"d",f)};JXG.SVGRenderer.prototype.updatePathStringPrim=function(d){var f=" M ",g=" L ",e=f,n=5000,j="",h,l,m=(d.curveType!="plot"),k;if(d.numberPoints<=0){return""}if(m&&d.board.options.curve.RDPsmoothing){d.points=this.RamenDouglasPeuker(d.points,0.5)}k=Math.min(d.points.length,d.numberPoints);for(h=0;h<k;h++){l=d.points[h].scrCoords;if(isNaN(l[1])||isNaN(l[2])){e=f}else{if(l[1]>n){l[1]=n}else{if(l[1]<-n){l[1]=-n}}if(l[2]>n){l[2]=n}else{if(l[2]<-n){l[2]=-n}}j+=[e,l[1]," ",l[2]].join("");e=g}}return j};JXG.SVGRenderer.prototype.updatePathStringPoint=function(h,e,g){var f="",k=h.coords.scrCoords,j=e*Math.sqrt(3)*0.5,d=e*0.5;if(g=="x"){f="M "+(k[1]-e)+" "+(k[2]-e)+" L "+(k[1]+e)+" "+(k[2]+e)+" M "+(k[1]+e)+" "+(k[2]-e)+" L "+(k[1]-e)+" "+(k[2]+e)}else{if(g=="+"){f="M "+(k[1]-e)+" "+(k[2])+" L "+(k[1]+e)+" "+(k[2])+" M "+(k[1])+" "+(k[2]-e)+" L "+(k[1])+" "+(k[2]+e)}else{if(g=="diamond"){f="M "+(k[1]-e)+" "+(k[2])+" L "+(k[1])+" "+(k[2]+e)+" L "+(k[1]+e)+" "+(k[2])+" L "+(k[1])+" "+(k[2]-e)+" Z "}else{if(g=="A"){f="M "+(k[1])+" "+(k[2]-e)+" L "+(k[1]-j)+" "+(k[2]+d)+" L "+(k[1]+j)+" "+(k[2]+d)+" Z "}else{if(g=="v"){f="M "+(k[1])+" "+(k[2]+e)+" L "+(k[1]-j)+" "+(k[2]-d)+" L "+(k[1]+j)+" "+(k[2]-d)+" Z "}else{if(g==">"){f="M "+(k[1]+e)+" "+(k[2])+" L "+(k[1]-d)+" "+(k[2]-j)+" L "+(k[1]-d)+" "+(k[2]+j)+" Z "}else{if(g=="<"){f="M "+(k[1]-e)+" "+(k[2])+" L "+(k[1]+d)+" "+(k[2]-j)+" L "+(k[1]+d)+" "+(k[2]+j)+" Z "}}}}}}}return f};JXG.SVGRenderer.prototype.updatePolygonePrim=function(h,g){var j="",e,f,d=g.vertices.length;h.setAttributeNS(null,"stroke","none");for(f=0;f<d-1;f++){e=g.vertices[f].coords.scrCoords;j=j+e[1]+","+e[2];if(f<d-2){j+=" "}}h.setAttributeNS(null,"points",j)};JXG.SVGRenderer.prototype.appendChildPrim=function(d,e){if(typeof e=="undefined"){e=0}else{if(e>=JXG.Options.layer.numlayers){e=JXG.Options.layer.numlayers-1}}this.layer[e].appendChild(d)};JXG.SVGRenderer.prototype.setPropertyPrim=function(e,d,f){if(d=="stroked"){return}e.setAttributeNS(null,d,f)};JXG.SVGRenderer.prototype.drawVerticalGrid=function(g,e,j,f){var h=this.createPrim("path","gridx"),d="";while(g.scrCoords[1]<e.scrCoords[1]+j-1){d+=" M "+g.scrCoords[1]+" "+0+" L "+g.scrCoords[1]+" "+f.canvasHeight+" ";g.setCoordinates(JXG.COORDS_BY_SCREEN,[g.scrCoords[1]+j,g.scrCoords[2]])}this.updatePathPrim(h,d,f);return h};JXG.SVGRenderer.prototype.drawHorizontalGrid=function(g,e,j,f){var h=this.createPrim("path","gridy"),d="";while(g.scrCoords[2]<=e.scrCoords[2]+j-1){d+=" M "+0+" "+g.scrCoords[2]+" L "+f.canvasWidth+" "+g.scrCoords[2]+" ";g.setCoordinates(JXG.COORDS_BY_SCREEN,[g.scrCoords[1],g.scrCoords[2]+j])}this.updatePathPrim(h,d,f);return h};JXG.SVGRenderer.prototype.appendNodesToElement=function(d,e){d.rendNode=this.getElementById(d.id)};JXG.VMLRenderer=function(d){this.constructor();this.container=d;this.container.style.overflow="hidden";this.container.onselectstart=function(){return false};this.resolution=10;if(JXG.vmlStylesheet==null){d.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml");JXG.vmlStylesheet=this.container.ownerDocument.createStyleSheet();JXG.vmlStylesheet.addRule(".jxgvml","behavior:url(#default#VML)")}try{!d.ownerDocument.namespaces.jxgvml&&d.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml");this.createNode=function(e){return d.ownerDocument.createElement("<jxgvml:"+e+' class="jxgvml">')}}catch(f){this.createNode=function(e){return d.ownerDocument.createElement("<"+e+' xmlns="urn:schemas-microsoft.com:vml" class="jxgvml">')}}this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]};JXG.VMLRenderer.prototype=new JXG.AbstractRenderer;JXG.VMLRenderer.prototype.setAttr=function(g,d,j,f){try{if(document.documentMode==8){g[d]=j}else{g.setAttribute(d,j,f)}}catch(h){}};JXG.VMLRenderer.prototype.setShadow=function(d){var e=d.rendNodeShadow;if(!e){return}if(d.visPropOld.shadow==d.visProp.shadow){return}if(d.visProp.shadow){this.setAttr(e,"On","True");this.setAttr(e,"Offset","3pt,3pt");this.setAttr(e,"Opacity","60%");this.setAttr(e,"Color","#aaaaaa")}else{this.setAttr(e,"On","False")}d.visPropOld.shadow=d.visProp.shadow};JXG.VMLRenderer.prototype.setGradient=function(e){var d=e.rendNodeFill;if(e.visProp.gradient=="linear"){this.setAttr(d,"type","gradient");this.setAttr(d,"color2",e.visProp.gradientSecondColor);this.setAttr(d,"opacity2",e.visProp.gradientSecondOpacity);this.setAttr(d,"angle",e.visProp.gradientAngle)}else{if(e.visProp.gradient=="radial"){this.setAttr(d,"type","gradientradial");this.setAttr(d,"color2",e.visProp.gradientSecondColor);this.setAttr(d,"opacity2",e.visProp.gradientSecondOpacity);this.setAttr(d,"focusposition",e.visProp.gradientPositionX*100+"%,"+e.visProp.gradientPositionY*100+"%");this.setAttr(d,"focussize","0,0")}else{this.setAttr(d,"type","solid")}}};JXG.VMLRenderer.prototype.updateGradient=function(d){};JXG.VMLRenderer.prototype.addShadowToGroup=function(d,f){var e,g;if(d=="lines"){for(e in f.objects){g=f.objects[e];if(g.elementClass==JXG.OBJECT_CLASS_LINE){this.addShadowToElement(g)}}}else{if(d=="points"){for(e in f.objects){g=f.objects[e];if(g.elementClass==JXG.OBJECT_CLASS_POINT){this.addShadowToElement(g)}}}else{if(d=="circles"){for(e in f.objects){g=f.objects[e];if(g.elementClass==JXG.OBJECT_CLASS_CIRCLE){this.addShadowToElement(g)}}}}}f.fullUpdate()};JXG.VMLRenderer.prototype.displayCopyright=function(f,g){var e,d;e=this.createNode("textbox");e.style.position="absolute";this.setAttr(e,"id",this.container.id+"_licenseText");e.style.left=20;e.style.top=(2);e.style.fontSize=(g);e.style.color="#356AA0";e.style.fontFamily="Arial,Helvetica,sans-serif";this.setAttr(e,"opacity","30%");e.style.filter="alpha(opacity = 30)";d=document.createTextNode(f);e.appendChild(d);this.appendChildPrim(e,0)};JXG.VMLRenderer.prototype.drawInternalText=function(d){var e;e=this.createNode("textbox");e.style.position="absolute";if(document.documentMode==8){e.setAttribute("class","JXGtext")}else{e.setAttribute("className",9)}d.rendNodeText=document.createTextNode("");e.appendChild(d.rendNodeText);this.appendChildPrim(e,9);return e};JXG.VMLRenderer.prototype.updateInternalText=function(d){d.rendNode.style.left=(d.coords.scrCoords[1])+"px";d.rendNode.style.top=(d.coords.scrCoords[2]-this.vOffsetText)+"px";d.updateText();if(d.htmlStr!=d.plaintextStr){d.rendNodeText.data=d.plaintextStr;d.htmlStr=d.plaintextStr}};JXG.VMLRenderer.prototype.drawTicks=function(e){var d=this.createPrim("path",e.id);this.appendChildPrim(d,e.layer);this.appendNodesToElement(e,"path")};JXG.VMLRenderer.prototype.updateTicks=function(h,j,e,k,g){var f=[],l,m,n,q,d=this.resolution;m=h.ticks.length;for(l=0;l<m;l++){n=h.ticks[l].scrCoords;if(h.ticks[l].major){if(h.labels[l].visProp.visible){this.drawText(h.labels[l])}f.push(" m "+Math.round(d*(n[1]+j))+", "+Math.round(d*(n[2]-e))+" l "+Math.round(d*(n[1]-j))+", "+Math.round(d*(n[2]+e))+" ")}else{f.push(" m "+Math.round(d*(n[1]+k))+", "+Math.round(d*(n[2]-g))+" l "+Math.round(d*(n[1]-k))+", "+Math.round(d*(n[2]+g))+" ")}}q=this.getElementById(h.id);if(q==null){q=this.createPrim("path",h.id);this.appendChildPrim(q,h.layer);this.appendNodesToElement(h,"path")}this.setAttr(q,"stroked","true");this.setAttr(q,"strokecolor",h.visProp.strokeColor,1);this.setAttr(q,"strokeweight",h.visProp.strokeWidth);this.updatePathPrim(q,f,h.board)};JXG.VMLRenderer.prototype.drawImage=function(d){var e;e=this.container.ownerDocument.createElement("img");e.style.position="absolute";this.setAttr(e,"id",this.container.id+"_"+d.id);this.container.appendChild(e);this.appendChildPrim(e,d.layer);e.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand')";d.rendNode=e;this.updateImage(d)};JXG.VMLRenderer.prototype.updateImageURL=function(e){var d;if(JXG.isFunction(e.url)){d=e.url()}else{d=e.url}this.setAttr(e.rendNode,"src",d)};JXG.VMLRenderer.prototype.transformImage=function(f,e){var g=f.rendNode,d;d=this.joinTransforms(f,e);g.style.left=(f.coords.scrCoords[1]+d[1][0])+"px";g.style.top=(f.coords.scrCoords[2]-f.size[1]+d[2][0])+"px";g.filters.item(0).M11=d[1][1];g.filters.item(0).M12=d[1][2];g.filters.item(0).M21=d[2][1];g.filters.item(0).M22=d[2][2]};JXG.VMLRenderer.prototype.joinTransforms=function(h,g){var e=[[1,0,0],[0,1,0],[0,0,1]],f,d=g.length;for(f=0;f<d;f++){e=JXG.Math.matMatMult(g[f].matrix,e)}return e};JXG.VMLRenderer.prototype.transformImageParent=function(e,d){};JXG.VMLRenderer.prototype.hide=function(d){d.rendNode.style.visibility="hidden"};JXG.VMLRenderer.prototype.show=function(d){d.rendNode.style.visibility="inherit"};JXG.VMLRenderer.prototype.setDashStyle=function(e,d){var f;if(d.dash>=0){f=e.rendNodeStroke;this.setAttr(f,"dashstyle",this.dashArray[d.dash])}};JXG.VMLRenderer.prototype.setObjectStrokeColor=function(el,color,opacity){var c=this.eval(color),o=this.eval(opacity),node,nodeStroke;o=(o>0)?o:0;if(el.visPropOld.strokeColor==c&&el.visPropOld.strokeOpacity==o){return}if(el.type==JXG.OBJECT_TYPE_TEXT){el.rendNode.style.color=c}else{node=el.rendNode;this.setAttr(node,"stroked","true");this.setAttr(node,"strokecolor",c);if(el.id=="gridx"){nodeStroke=this.getElementById("gridx_stroke")}else{if(el.id=="gridy"){nodeStroke=this.getElementById("gridy_stroke")}else{nodeStroke=el.rendNodeStroke}}if(o!=undefined){this.setAttr(nodeStroke,"opacity",(o*100)+"%")}}el.visPropOld.strokeColor=c;el.visPropOld.strokeOpacity=o};JXG.VMLRenderer.prototype.setObjectFillColor=function(el,color,opacity){var c=this.eval(color),o=this.eval(opacity);o=(o>0)?o:0;if(el.visPropOld.fillColor==c&&el.visPropOld.fillOpacity==o){return}if(c=="none"){this.setAttr(el.rendNode,"filled","false")}else{this.setAttr(el.rendNode,"filled","true");this.setAttr(el.rendNode,"fillcolor",c);if(o!=undefined&&el.rendNodeFill){this.setAttr(el.rendNodeFill,"opacity",(o*100)+"%")}}el.visPropOld.fillColor=c;el.visPropOld.fillOpacity=o};JXG.VMLRenderer.prototype.remove=function(d){if(d!=null){d.removeNode(true)}};JXG.VMLRenderer.prototype.suspendRedraw=function(){this.container.style.display="none"};JXG.VMLRenderer.prototype.unsuspendRedraw=function(){this.container.style.display=""};JXG.VMLRenderer.prototype.setAttributes=function(node,props,vmlprops,visProp){var val,i,p;len=props.length;for(i=0;i<len;i++){p=props[i];if(visProp[p]!=null){val=this.eval(visProp[p]);val=(val>0)?val:0;this.setAttr(node,vmlprops[i],val)}}};JXG.VMLRenderer.prototype.setGridDash=function(e,d){var d=this.getElementById(e+"_stroke");this.setAttr(d,"dashstyle","Dash")};JXG.VMLRenderer.prototype.setObjectStrokeWidth=function(el,width){var w=this.eval(width),node;if(el.visPropOld.strokeWidth==w){return}node=el.rendNode;this.setPropertyPrim(node,"stroked","true");if(w!=null){this.setPropertyPrim(node,"stroke-width",w)}el.visPropOld.strokeWidth=w};JXG.VMLRenderer.prototype.createPrim=function(e,k){var f,d=this.createNode("fill"),j=this.createNode("stroke"),h=this.createNode("shadow"),g;this.setAttr(d,"id",this.container.id+"_"+k+"_fill");this.setAttr(j,"id",this.container.id+"_"+k+"_stroke");this.setAttr(h,"id",this.container.id+"_"+k+"_shadow");if(e=="circle"||e=="ellipse"){f=this.createNode("oval");f.appendChild(d);f.appendChild(j);f.appendChild(h)}else{if(e=="polygon"||e=="path"||e=="shape"||e=="line"){f=this.createNode("shape");f.appendChild(d);f.appendChild(j);f.appendChild(h);g=this.createNode("path");this.setAttr(g,"id",this.container.id+"_"+k+"_path");f.appendChild(g)}else{f=this.createNode(e);f.appendChild(d);f.appendChild(j);f.appendChild(h)}}f.style.position="absolute";this.setAttr(f,"id",this.container.id+"_"+k);return f};JXG.VMLRenderer.prototype.appendNodesToElement=function(d,e){if(e=="shape"||e=="path"||e=="polygon"){d.rendNodePath=this.getElementById(d.id+"_path")}d.rendNodeFill=this.getElementById(d.id+"_fill");d.rendNodeStroke=this.getElementById(d.id+"_stroke");d.rendNodeShadow=this.getElementById(d.id+"_shadow");d.rendNode=this.getElementById(d.id)};JXG.VMLRenderer.prototype.makeArrows=function(e){var d;if(e.visPropOld.firstArrow==e.visProp.firstArrow&&e.visPropOld.lastArrow==e.visProp.lastArrow){return}if(e.visProp.firstArrow){d=e.rendNodeStroke;this.setAttr(d,"startarrow","block");this.setAttr(d,"startarrowlength","long")}else{d=e.rendNodeStroke;if(d!=null){this.setAttr(d,"startarrow","none")}}if(e.visProp.lastArrow){d=e.rendNodeStroke;this.setAttr(d,"id",this.container.id+"_"+e.id+"stroke");this.setAttr(d,"endarrow","block");this.setAttr(d,"endarrowlength","long")}else{d=e.rendNodeStroke;if(d!=null){this.setAttr(d,"endarrow","none")}}e.visPropOld.firstArrow=e.visProp.firstArrow;e.visPropOld.lastArrow=e.visProp.lastArrow};JXG.VMLRenderer.prototype.updateLinePrim=function(l,e,d,g,f,j){var h,k=this.resolution;h=["m ",k*e,", ",k*d," l ",k*g,", ",k*f];this.updatePathPrim(l,h,j)};JXG.VMLRenderer.prototype.updateCirclePrim=function(f,d,g,e){f.style.left=(d-e)+"px";f.style.top=(g-e)+"px";f.style.width=(e*2)+"px";f.style.height=(e*2)+"px"};JXG.VMLRenderer.prototype.updateRectPrim=function(g,d,j,e,f){g.style.left=(d)+"px";g.style.top=(j)+"px";g.style.width=(e)+"px";g.style.height=(f)+"px"};JXG.VMLRenderer.prototype.updateEllipsePrim=function(e,d,h,g,f){e.style.left=(d-g)+"px";e.style.top=(h-f)+"px";e.style.width=(g*2)+"px";e.style.height=(f*2)+"px"};JXG.VMLRenderer.prototype.updatePathPrim=function(f,g,e){var d=e.canvasWidth,h=e.canvasHeight;f.style.width=d;f.style.height=h;this.setAttr(f,"coordsize",[(this.resolution*d),(this.resolution*h)].join(","));this.setAttr(f,"path",g.join(""))};JXG.VMLRenderer.prototype.updatePathStringPrim=function(e){var l=[],k,n,d=this.resolution,j=Math.round,g=" m ",h=" l ",f=g,q=(e.curveType!="plot"),m=Math.min(e.numberPoints,8192);if(e.numberPoints<=0){return""}if(q&&e.board.options.curve.RDPsmoothing){e.points=this.RamenDouglasPeuker(e.points,1)}m=Math.min(m,e.points.length);for(k=0;k<m;k++){n=e.points[k].scrCoords;if(isNaN(n[1])||isNaN(n[2])){f=g}else{if(n[1]>20000){n[1]=20000}else{if(n[1]<-20000){n[1]=-20000}}if(n[2]>20000){n[2]=20000}else{if(n[2]<-20000){n[2]=-20000}}l.push([f,j(d*n[1]),", ",j(d*n[2])].join(""));f=h}}l.push(" e");return l};JXG.VMLRenderer.prototype.updatePathStringPoint=function(h,e,g){var f=[],l=h.coords.scrCoords,k=e*Math.sqrt(3)*0.5,d=e*0.5,j=this.resolution;if(g=="x"){f.push(["m ",(j*(l[1]-e)),", ",(j*(l[2]-e))," l ",(j*(l[1]+e)),", ",(j*(l[2]+e))," m ",(j*(l[1]+e)),", ",(j*(l[2]-e))," l ",(j*(l[1]-e)),", ",(j*(l[2]+e))].join(""))}else{if(g=="+"){f.push(["m ",(j*(l[1]-e)),", ",(j*(l[2]))," l ",(j*(l[1]+e)),", ",(j*(l[2]))," m ",(j*(l[1])),", ",(j*(l[2]-e))," l ",(j*(l[1])),", ",(j*(l[2]+e))].join(""))}else{if(g=="diamond"){f.push(["m ",(j*(l[1]-e)),", ",(j*(l[2]))," l ",(j*(l[1])),", ",(j*(l[2]+e))," l ",(j*(l[1]+e)),", ",(j*(l[2]))," l ",(j*(l[1])),", ",(j*(l[2]-e))," x e "].join(""))}else{if(g=="A"){f.push(["m ",(j*(l[1])),", ",(j*(l[2]-e))," l ",Math.round(j*(l[1]-k)),", ",(j*(l[2]+d))," l ",Math.round(j*(l[1]+k)),", ",(j*(l[2]+d))," x e "].join(""))}else{if(g=="v"){f.push(["m ",(j*(l[1])),", ",(j*(l[2]+e))," l ",Math.round(j*(l[1]-k)),", ",(j*(l[2]-d))," l ",Math.round(j*(l[1]+k)),", ",(j*(l[2]-d))," x e "].join(""))}else{if(g==">"){f.push(["m ",(j*(l[1]+e)),", ",(j*(l[2]))," l ",(j*(l[1]-d)),", ",Math.round(j*(l[2]-k))," l ",(j*(l[1]-d)),", ",Math.round(j*(l[2]+k))," l ",(j*(l[1]+e)),", ",(j*(l[2]))].join(""))}else{if(g=="<"){f.push(["m ",(j*(l[1]-e)),", ",(j*(l[2]))," l ",(j*(l[1]+d)),", ",Math.round(j*(l[2]-k))," l ",(j*(l[1]+d)),", ",Math.round(j*(l[2]+k))," x e "].join(""))}}}}}}}return f};JXG.VMLRenderer.prototype.updatePolygonePrim=function(h,f){var j=f.vertices[0].coords.scrCoords[1],e=f.vertices[0].coords.scrCoords[1],g=f.vertices[0].coords.scrCoords[2],d=f.vertices[0].coords.scrCoords[2],k,m=f.vertices.length,n,r,q,l=[];this.setAttr(h,"stroked","false");for(k=1;k<m-1;k++){n=f.vertices[k].coords.scrCoords;if(n[1]<j){j=n[1]}else{if(n[1]>e){e=n[1]}}if(n[2]<g){g=n[2]}else{if(n[2]>d){d=n[2]}}}r=Math.round(e-j);q=Math.round(d-g);if(!isNaN(r)&&!isNaN(q)){h.style.width=r;h.style.height=q;this.setAttr(h,"coordsize",r+","+q)}n=f.vertices[0].coords.scrCoords;l.push(["m ",n[1],",",n[2]," l "].join(""));for(k=1;k<m-1;k++){n=f.vertices[k].coords.scrCoords;l.push(n[1]+","+n[2]);if(k<m-2){l.push(", ")}}l.push(" x e");this.setAttr(h,"path",l.join(""))};JXG.VMLRenderer.prototype.appendChildPrim=function(d,e){if(typeof e=="undefined"){e=0}d.style.zIndex=e;this.container.appendChild(d)};JXG.VMLRenderer.prototype.setPropertyPrim=function(node,key,val){var keyVml="",node2,v;switch(key){case"stroke":keyVml="strokecolor";break;case"stroke-width":keyVml="strokeweight";break;case"stroke-dasharray":keyVml="dashstyle";break}if(keyVml!=""){v=this.eval(val);this.setAttr(node,keyVml,v)}};JXG.VMLRenderer.prototype.drawVerticalGrid=function(g,e,j,f){var h=this.createPrim("path","gridx"),d=[];while(g.scrCoords[1]<e.scrCoords[1]+j-1){d.push(" m "+(this.resolution*g.scrCoords[1])+", "+0+" l "+(this.resolution*g.scrCoords[1])+", "+(this.resolution*f.canvasHeight)+" ");g.setCoordinates(JXG.COORDS_BY_SCREEN,[g.scrCoords[1]+j,g.scrCoords[2]])}this.updatePathPrim(h,d,f);return h};JXG.VMLRenderer.prototype.drawHorizontalGrid=function(g,e,j,f){var h=this.createPrim("path","gridy"),d=[];while(g.scrCoords[2]<=e.scrCoords[2]+j-1){d.push(" m "+0+", "+(this.resolution*g.scrCoords[2])+" l "+(this.resolution*f.canvasWidth)+", "+(this.resolution*g.scrCoords[2])+" ");g.setCoordinates(JXG.COORDS_BY_SCREEN,[g.scrCoords[1],g.scrCoords[2]+j])}this.updatePathPrim(h,d,f);return h};JXG.CanvasRenderer=function(d){var e;this.constructor();this.canvasRoot=null;this.suspendHandle=null;this.canvasId=JXG.Util.genUUID();this.canvasNamespace=null;this.container=d;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position==""){this.container.style.position="relative"}this.container.innerHTML='<canvas id="'+this.canvasId+'" width="'+this.container.style.width+'" height="'+this.container.style.height+'"></canvas>';this.canvasRoot=document.getElementById(this.canvasId);if(typeof xanvas!=="undefined"){this.context=xanvas(this.canvasRoot)}else{this.context=this.canvasRoot.getContext("2d")}this.dashArray=[[2,2],[5,5],[10,10],[20,20],[20,10,10,10],[20,5,10,5]]};JXG.CanvasRenderer.prototype=new JXG.AbstractRenderer;JXG.CanvasRenderer.prototype.updateStencilBuffer=function(e){var d;if(typeof e.board.highlightedObjects[e.id]!="undefined"&&e.board.highlightedObjects[e.id]!=null){if(e.visProp.strokeColor!="none"){this.context.strokeStyle=e.visProp.highlightStrokeColor}if(e.visProp.fillColor!="none"){this.context.fillStyle=e.visProp.highlightFillColor}this.context.lineWidth=parseFloat(e.visProp.strokeWidth);this.context.globalAlpha=e.visProp.highlightFillOpacity;d=true}else{if(e.visProp.strokeColor!="none"){this.context.strokeStyle=e.visProp.strokeColor}if(e.visProp.fillColor!="none"){this.context.fillStyle=e.visProp.fillColor}this.context.lineWidth=parseFloat(e.visProp.strokeWidth);this.context.globalAlpha=e.visProp.fillOpacity;d=false}return d};JXG.CanvasRenderer.prototype.setColor=function(e,d){var f=true;if(d=="fill"){if(typeof e.board.highlightedObjects[e.id]!="undefined"&&e.board.highlightedObjects[e.id]!=null){if(e.visProp.highlightFillColor!="none"){this.context.globalAlpha=e.visProp.highlightFillOpacity;this.context.fillStyle=e.visProp.highlightFillColor}else{f=false}}else{if(e.visProp.fillColor!="none"){this.context.globalAlpha=e.visProp.fillOpacity;this.context.fillStyle=e.visProp.fillColor}else{f=false}}}else{if(typeof e.board.highlightedObjects[e.id]!="undefined"&&e.board.highlightedObjects[e.id]!=null){if(e.visProp.highlightStrokeColor!="none"){this.context.globalAlpha=e.visProp.highlightStrokeOpacity;this.context.strokeStyle=e.visProp.highlightStrokeColor}else{f=false}}else{if(e.visProp.strokeColor!="none"){this.context.globalAlpha=e.visProp.strokeOpacity;this.context.strokeStyle=e.visProp.strokeColor}else{f=false}}this.context.lineWidth=parseFloat(e.visProp.strokeWidth)}return f};JXG.CanvasRenderer.prototype.fill=function(d){this.context.save();if(this.setColor(d,"fill")){this.context.fill()}this.context.restore()};JXG.CanvasRenderer.prototype.stroke=function(d){this.context.save();if(d.visProp.dash>0){}else{this.context.lineDashArray=[]}if(this.setColor(d,"stroke")){this.context.stroke()}this.context.restore()};JXG.CanvasRenderer.prototype.setShadow=function(d){if(d.visPropOld.shadow==d.visProp.shadow){return}d.visPropOld.shadow=d.visProp.shadow};JXG.CanvasRenderer.prototype.setGradient=function(f){var q=f.rendNode,g,j,h,n,m,e,d,l,k;if(typeof f.visProp.fillOpacity=="function"){j=f.visProp.fillOpacity()}else{j=f.visProp.fillOpacity}j=(j>0)?j:0;if(typeof f.visProp.fillColor=="function"){g=f.visProp.fillColor()}else{g=f.visProp.fillColor}if(f.visProp.gradient=="linear"){}else{if(f.visProp.gradient=="radial"){}else{}}};JXG.CanvasRenderer.prototype.updateGradient=function(d){};JXG.CanvasRenderer.prototype.displayCopyright=function(e,d){this.context.save();this.context.font=d+"px Arial";this.context.fillStyle="#aaa";this.context.lineWidth=0.5;this.context.fillText(e,10,2+d);this.context.restore()};JXG.CanvasRenderer.prototype.drawInternalText=function(d){this.context.save();if(this.setColor(d,"stroke")){if(typeof d.board.highlightedObjects[d.id]!="undefined"&&d.board.highlightedObjects[d.id]!=null){this.context.fillStyle=d.visProp.highlightStrokeColor}else{this.context.fillStyle=d.visProp.strokeColor}this.context.font=d.board.options.text.fontSize+"px Arial";this.context.fillText(d.plaintextStr,d.coords.scrCoords[1],d.coords.scrCoords[2])}this.context.restore();return null};JXG.CanvasRenderer.prototype.updateInternalText=function(d){this.drawInternalText(d)};JXG.CanvasRenderer.prototype.drawTicks=function(d){};JXG.CanvasRenderer.prototype.updateTicks=function(g,j,f,k,h){var e,l,d=g.ticks.length;this.context.beginPath();for(e=0;e<d;e++){l=g.ticks[e].scrCoords;if(g.ticks[e].major){if(g.labels[e].visProp.visible){this.drawText(g.labels[e])}this.context.moveTo(l[1]+j,l[2]-f);this.context.lineTo(l[1]-j,l[2]+f)}else{this.context.moveTo(l[1]+k,l[2]-h);this.context.lineTo(l[1]-k,l[2]+h)}}this.stroke(g)};JXG.CanvasRenderer.prototype.drawImage=function(e){var d=this.updateImage;e.rendNode=new Image();this.updateImage(e)};JXG.CanvasRenderer.prototype.updateImageURL=function(e){var d;if(JXG.isFunction(e.url)){d=e.url()}else{d=e.url}if(e.rendNode.src!=d){e.imgIsLoaded=false;e.rendNode.src=d;return true}else{return false}};JXG.CanvasRenderer.prototype.updateImage=function(e){var d=this.context,f=this.transformImageParent;transform=this.transformImage,paintImg=function(){d.save();if(e.parent!=null){f(e,e.parent.imageTransformMatrix,d)}else{f(e,null,d)}transform(e,e.transformations,d);d.drawImage(e.rendNode,e.coords.scrCoords[1],e.coords.scrCoords[2]-e.size[1],e.size[0],e.size[1]);d.restore();e.imgIsLoaded=true};if(this.updateImageURL(e)){e.rendNode.onload=paintImg}else{if(e.imgIsLoaded){paintImg()}}};JXG.CanvasRenderer.prototype.transformImage=function(j,h,f){var e,g,d=h.length;for(g=0;g<d;g++){e=h[g].matrix;f.transform(e[1][1],e[2][1],e[1][2],e[2][2],e[1][0],e[2][0])}};JXG.CanvasRenderer.prototype.joinTransforms=function(e,d){return""};JXG.CanvasRenderer.prototype.transformImageParent=function(f,d,e){if(d!=null){e.setTransform(d[1][1],d[2][1],d[1][2],d[2][2],d[1][0],d[2][0])}else{e.setTransform(1,0,0,1,0,0)}};JXG.CanvasRenderer.prototype.setArrowAtts=function(d,f,e){};JXG.CanvasRenderer.prototype.setObjectStrokeColor=function(f,d,e){};JXG.CanvasRenderer.prototype.setObjectFillColor=function(f,d,e){};JXG.CanvasRenderer.prototype.setObjectStrokeWidth=function(e,d){};JXG.CanvasRenderer.prototype.hide=function(d){};JXG.CanvasRenderer.prototype.show=function(d){};JXG.CanvasRenderer.prototype.remove=function(d){if(d!=null&&d.parentNode!=null){d.parentNode.removeChild(d)}};JXG.CanvasRenderer.prototype.suspendRedraw=function(){this.context.save();this.context.clearRect(0,0,this.canvasRoot.width,this.canvasRoot.height);this.displayCopyright(JXG.JSXGraph.licenseText,12)};JXG.CanvasRenderer.prototype.unsuspendRedraw=function(){this.context.restore()};JXG.CanvasRenderer.prototype.setDashStyle=function(e,d){};JXG.CanvasRenderer.prototype.setGridDash=function(d){};JXG.CanvasRenderer.prototype.createPrim=function(d,e){};JXG.CanvasRenderer.prototype.createArrowHead=function(d,e){};JXG.CanvasRenderer.prototype._drawFilledPolygon=function(e){var f,d=e.length;if(d<=0){return}this.context.beginPath();this.context.moveTo(e[0][0],e[0][1]);for(f=0;f<d;f++){if(f>0){this.context.lineTo(e[f][0],e[f][1])}}this.context.lineTo(e[0][0],e[0][1]);this.context.fill()};JXG.CanvasRenderer.prototype._translateShape=function(f,e,j){var g,h=[],d=f.length;if(d<=0){return f}for(g=0;g<d;g++){h.push([f[g][0]+e,f[g][1]+j])}return h};JXG.CanvasRenderer.prototype._rotateShape=function(e,f){var g,h=[],d=e.length;if(d<=0){return e}for(g=0;g<d;g++){h.push(this._rotatePoint(f,e[g][0],e[g][1]))}return h};JXG.CanvasRenderer.prototype._rotatePoint=function(e,d,f){return[(d*Math.cos(e))-(f*Math.sin(e)),(d*Math.sin(e))+(f*Math.cos(e))]};JXG.CanvasRenderer.prototype.makeArrows=function(g,l,j){var h;var e=[[2,0],[-10,-4],[-10,4]],n=[[-2,0],[10,-4],[10,4]],f,m,d,k,h;if(g.visProp.strokeColor!="none"&&(g.visProp.lastArrow||g.visProp.firstArrow)){if(g.elementClass==JXG.OBJECT_CLASS_LINE){f=l.scrCoords[1];m=l.scrCoords[2];d=j.scrCoords[1];k=j.scrCoords[2]}else{return}this.context.save();if(this.setColor(g,"stroke")){if(typeof g.board.highlightedObjects[g.id]!="undefined"&&g.board.highlightedObjects[g.id]!=null){this.context.fillStyle=g.visProp.highlightStrokeColor}else{this.context.fillStyle=g.visProp.strokeColor}var h=Math.atan2(k-m,d-f);if(g.visProp.lastArrow){this._drawFilledPolygon(this._translateShape(this._rotateShape(e,h),d,k))}if(g.visProp.firstArrow){this._drawFilledPolygon(this._translateShape(this._rotateShape(n,h),f,m))}}this.context.restore()}};JXG.CanvasRenderer.prototype.updateLinePrim=function(h,e,d,g,f){};JXG.CanvasRenderer.prototype.updateCirclePrim=function(f,d,g,e){};JXG.CanvasRenderer.prototype.updateEllipsePrim=function(e,d,h,g,f){};JXG.CanvasRenderer.prototype.updateRectPrim=function(g,d,j,e,f){};JXG.CanvasRenderer.prototype.updatePathPrim=function(e,f,d){};JXG.CanvasRenderer.prototype.updatePathStringPrim=function(d){var f="M",g="L",e=f,n=5000,j="",h,l,m=(d.curveType!="plot"),k;if(d.numberPoints<=0){return""}if(m&&d.board.options.curve.RDPsmoothing){d.points=this.RamenDouglasPeuker(d.points,0.5)}k=Math.min(d.points.length,d.numberPoints);this.context.beginPath();for(h=0;h<k;h++){l=d.points[h].scrCoords;if(isNaN(l[1])||isNaN(l[2])){e=f}else{if(l[1]>n){l[1]=n}else{if(l[1]<-n){l[1]=-n}}if(l[2]>n){l[2]=n}else{if(l[2]<-n){l[2]=-n}}if(e=="M"){this.context.moveTo(l[1],l[2])}else{this.context.lineTo(l[1],l[2])}e=g}}this.fill(d);this.stroke(d);return null};JXG.CanvasRenderer.prototype.updatePolygonePrim=function(e,d){};JXG.CanvasRenderer.prototype.appendChildPrim=function(d,e){};JXG.CanvasRenderer.prototype.setPropertyPrim=function(e,d,f){if(d=="stroked"){return}};JXG.CanvasRenderer.prototype.drawVerticalGrid=function(g,e,j,f){var h=this.createPrim("path","gridx"),d="";while(g.scrCoords[1]<e.scrCoords[1]+j-1){d+=" M "+g.scrCoords[1]+" "+0+" L "+g.scrCoords[1]+" "+f.canvasHeight+" ";g.setCoordinates(JXG.COORDS_BY_SCREEN,[g.scrCoords[1]+j,g.scrCoords[2]])}this.updatePathPrim(h,d,f);return h};JXG.CanvasRenderer.prototype.drawHorizontalGrid=function(g,e,j,f){var h=this.createPrim("path","gridy"),d="";while(g.scrCoords[2]<=e.scrCoords[2]+j-1){d+=" M "+0+" "+g.scrCoords[2]+" L "+f.canvasWidth+" "+g.scrCoords[2]+" ";g.setCoordinates(JXG.COORDS_BY_SCREEN,[g.scrCoords[1],g.scrCoords[2]+j])}this.updatePathPrim(h,d,f);return h};JXG.CanvasRenderer.prototype.appendNodesToElement=function(d,e){};JXG.CanvasRenderer.prototype.drawPoint=function(h){var j=h.visProp.face,g=h.visProp.size,l=h.coords.scrCoords,k=g*Math.sqrt(3)*0.5,d=g*0.5,e=parseFloat(h.visProp.strokeWidth)/2;if(g<=0){return}switch(j){case"cross":case"x":this.context.beginPath();this.context.moveTo(l[1]-g,l[2]-g);this.context.lineTo(l[1]+g,l[2]+g);this.context.moveTo(l[1]+g,l[2]-g);this.context.lineTo(l[1]-g,l[2]+g);this.context.closePath();this.stroke(h);break;case"circle":case"o":this.context.beginPath();this.context.arc(l[1],l[2],g+1+e,0,2*Math.PI,false);this.context.closePath();this.fill(h);this.stroke(h);break;case"square":case"[]":if(g<=0){break}this.context.save();if(this.setColor(h,"stroke")){if(typeof h.board.highlightedObjects[h.id]!="undefined"&&h.board.highlightedObjects[h.id]!=null){this.context.fillStyle=h.visProp.highlightStrokeColor}else{this.context.fillStyle=h.visProp.strokeColor}this.context.fillRect(l[1]-g-e,l[2]-g-e,g*2+3*e,g*2+3*e)}this.context.restore();this.context.save();this.setColor(h,"fill");this.context.fillRect(l[1]-g+e,l[2]-g+e,g*2-e,g*2-e);this.context.restore();break;case"plus":case"+":this.context.beginPath();this.context.moveTo(l[1]-g,l[2]);this.context.lineTo(l[1]+g,l[2]);this.context.moveTo(l[1],l[2]-g);this.context.lineTo(l[1],l[2]+g);this.context.closePath();this.stroke(h);break;case"diamond":case"<>":this.context.beginPath();this.context.moveTo(l[1]-g,l[2]);this.context.lineTo(l[1],l[2]+g);this.context.lineTo(l[1]+g,l[2]);this.context.lineTo(l[1],l[2]-g);this.context.closePath();this.fill(h);this.stroke(h);break;case"triangleup":case"a":case"^":this.context.beginPath();this.context.moveTo(l[1],l[2]-g);this.context.lineTo(l[1]-k,l[2]+d);this.context.lineTo(l[1]+k,l[2]+d);this.context.closePath();this.fill(h);this.stroke(h);break;case"triangledown":case"v":this.context.beginPath();this.context.moveTo(l[1],l[2]+g);this.context.lineTo(l[1]-k,l[2]-d);this.context.lineTo(l[1]+k,l[2]-d);this.context.closePath();this.fill(h);this.stroke(h);break;case"triangleleft":case"<":this.context.beginPath();this.context.moveTo(l[1]-g,l[2]);this.context.lineTo(l[1]+d,l[2]-k);this.context.lineTo(l[1]+d,l[2]+k);this.context.closePath();this.fill(h);this.stroke(h);break;case"triangleright":case">":this.context.beginPath();this.context.moveTo(l[1]+g,l[2]);this.context.lineTo(l[1]-d,l[2]-k);this.context.lineTo(l[1]-d,l[2]+k);this.context.closePath();this.fill(h);this.stroke(h);break}};JXG.CanvasRenderer.prototype.updatePoint=function(d){this.drawPoint(d)};JXG.CanvasRenderer.prototype.changePointStyle=function(d){this.drawPoint(d)};JXG.CanvasRenderer.prototype.drawText=function(d){var e;if(d.display=="html"){e=this.container.ownerDocument.createElement("div");e.style.position="absolute";e.style.color=d.visProp.strokeColor;e.className="JXGtext";e.style.zIndex="10";this.container.appendChild(e);e.setAttribute("id",this.container.id+"_"+d.id);e.style.fontSize=d.board.options.text.fontSize+"px"}else{e=this.drawInternalText(d)}d.rendNode=e;d.htmlStr="";this.updateText(d)};JXG.CanvasRenderer.prototype.updateText=function(d){if(d.visProp.visible==false){return}if(isNaN(d.coords.scrCoords[1]+d.coords.scrCoords[2])){return}this.updateTextStyle(d);if(d.display=="html"){d.rendNode.style.left=(d.coords.scrCoords[1])+"px";d.rendNode.style.top=(d.coords.scrCoords[2]-this.vOffsetText)+"px";d.updateText();if(d.htmlStr!=d.plaintextStr){d.rendNode.innerHTML=d.plaintextStr;if(d.board.options.text.useASCIIMathML){AMprocessNode(d.rendNode,false)}d.htmlStr=d.plaintextStr}}else{this.updateInternalText(d)}};JXG.CanvasRenderer.prototype.drawLine=function(e){var n=new JXG.Coords(JXG.COORDS_BY_USER,e.point1.coords.usrCoords,e.board),k=new JXG.Coords(JXG.COORDS_BY_USER,e.point2.coords.usrCoords,e.board),d,s,j,h,r,g,q,l,f;this.calcStraight(e,n,k);this.context.beginPath();this.context.moveTo(n.scrCoords[1],n.scrCoords[2]);this.context.lineTo(k.scrCoords[1],k.scrCoords[2]);this.stroke(e);if(e.image!=null){d=n.scrCoords[1];s=n.scrCoords[2];j=k.scrCoords[1];h=k.scrCoords[2];r=Math.atan2(h-s,j-d);q=250;l=256;f=[[1,0,0],[q*(1-Math.cos(r))+l*Math.sin(r),Math.cos(r),-Math.sin(r)],[l*(1-Math.cos(r))-q*Math.sin(r),Math.sin(r),Math.cos(r)]];e.imageTransformMatrix=f}this.makeArrows(e,n,k)};JXG.CanvasRenderer.prototype.updateLine=function(d){this.drawLine(d)};JXG.CanvasRenderer.prototype.drawCurve=function(d){this.updatePathStringPrim(d)};JXG.CanvasRenderer.prototype.updateCurve=function(d){this.drawCurve(d)};JXG.CanvasRenderer.prototype.drawEllipse=function(h,v,t,g,f,q,n){var r=q*g,s=n*f,m=v-r/2,l=t-s/2,u=(r/2)*0.5522848,e=(s/2)*0.5522848,d=m+r,w=l+s,k=m+r/2,j=l+s/2;if(q>0&&n>0&&!isNaN(v+t)){this.context.beginPath();this.context.moveTo(m,j);this.context.bezierCurveTo(m,j-e,k-u,l,k,l);this.context.bezierCurveTo(k+u,l,d,j-e,d,j);this.context.bezierCurveTo(d,j+e,k+u,w,k,w);this.context.bezierCurveTo(k-u,w,m,j+e,m,j);this.context.closePath();this.fill(h);this.stroke(h)}};JXG.CanvasRenderer.prototype.drawCircle=function(d){this.drawEllipse(d,d.midpoint.coords.scrCoords[1],d.midpoint.coords.scrCoords[2],d.board.stretchX,d.board.stretchY,2*d.Radius(),2*d.Radius())};JXG.CanvasRenderer.prototype.updateCircle=function(d){this.drawCircle(d)};JXG.CanvasRenderer.prototype.drawPolygon=function(d){};JXG.CanvasRenderer.prototype.updatePolygonePrim=function(h,g){var j="",e,f,d=g.vertices.length;if(d<=0){return}this.context.beginPath();e=g.vertices[0].coords.scrCoords;this.context.moveTo(e[1],e[2]);for(f=1;f<d;f++){e=g.vertices[f].coords.scrCoords;this.context.lineTo(e[1],e[2])}this.context.closePath();this.fill(g)};JXG.CanvasRenderer.prototype.highlight=function(d){d.board.prepareUpdate();d.board.renderer.suspendRedraw();d.board.updateRenderer();d.board.renderer.unsuspendRedraw();return this};JXG.CanvasRenderer.prototype.noHighlight=function(d){d.board.prepareUpdate();d.board.renderer.suspendRedraw();d.board.updateRenderer();d.board.renderer.unsuspendRedraw();return this};