/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;

public class HVector {
    HFunction vector;

    public HVector(HFunction hFunction) {
        this.vector = hFunction;
    }

    public final Object clone() {
        HVector hVector;
        try {
            hVector = (HVector)super.clone();
            hVector.vector = (HFunction)this.vector.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        return hVector;
    }

    public HObject get(int n) {
        return this.vector.get(n);
    }

    public final HFunction getFunction() {
        return this.vector;
    }

    public HObject set(int n, HObject hObject) {
        HObject hObject2 = this.vector.a[n];
        this.vector.a[n] = hObject;
        return hObject2;
    }

    public int size() {
        return this.vector.size();
    }

    public double[] toDoubleArray() {
        double[] dArray = new double[this.vector.len];
        for (int i = 0; i < this.vector.len; ++i) {
            HObject hObject = C.NEV(this.vector.a[i]);
            if (!(hObject instanceof HDouble)) {
                throw new HThrowException(C.Error, C.List, hObject);
            }
            dArray[i] = ((HDouble)hObject).value();
        }
        return dArray;
    }

    public HDoubleComplex[] toDoubleComplexArray() {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.len];
        for (int i = 0; i < this.vector.len; ++i) {
            HObject hObject = C.NEV(this.vector.a[i]);
            if (hObject instanceof HDouble) {
                hDoubleComplexArray[i] = new HDoubleComplex((HDouble)hObject);
                continue;
            }
            if (hObject instanceof HDoubleComplex) {
                hDoubleComplexArray[i] = (HDoubleComplex)hObject;
                continue;
            }
            throw new HThrowException(C.Error, C.List, new HString("only numerical values allowed."));
        }
        return hDoubleComplexArray;
    }
}

