/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.lib;

import com.hartmath.expression.HObject;
import com.hartmath.expression.HSignedNumber;
import com.hartmath.lib.C;
import com.hartmath.lib.HBreakException;
import com.hartmath.lib.HContinueException;
import com.hartmath.lib.HReturnException;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.OutputStringBuffer;
import com.hartmath.lib.Scanner;
import com.hartmath.lib.SessionData;
import com.hartmath.lib.SyntaxError;

public class ContextThread
extends Thread {
    private String inStr = null;
    private HObject outExpr = null;
    private OutputStringBuffer outBuf = null;
    private boolean evaluated = false;
    private HObject evalObject;

    public ContextThread() {
        this.evalObject = null;
    }

    public ContextThread(HObject hObject) {
        this.evalObject = hObject;
    }

    public String getOutput() {
        if (!this.evaluated) {
            this.outBuf.appendLine("maximum response-time exceeded!\n");
        }
        return this.outBuf.toString();
    }

    public HObject getResult() {
        return this.outExpr;
    }

    public void run() {
        try {
            this.outExpr = null;
            if (this.evalObject != null) {
                this.outExpr = C.EV(this.evalObject);
            } else {
                SessionData sessionData = SessionData.currentSessionData();
                sessionData.addHistory();
                Scanner scanner = new Scanner(this.inStr);
                HObject hObject = scanner.start();
                sessionData.setRecursionLimit(((HSignedNumber)((Object)C.EV(C.RecursionLimit))).intValue());
                sessionData.setIterationLimit(((HSignedNumber)((Object)C.EV(C.IterationLimit))).intValue());
                sessionData.changeCurrentInHistory(hObject);
                if (C.showInOut) {
                    this.outBuf.append("In[" + Integer.toString(sessionData.getCounter(), 10) + "]:\n");
                    if (hObject != null) {
                        this.outBuf.appendLine(hObject.toString());
                    }
                }
                sessionData.setNumericFlag(false);
                C.timeConstrained = 0;
                sessionData.setRecursionCounter(0);
                sessionData.setIterationCounter(0);
                this.outExpr = C.EV(hObject);
                if (C.showInOut) {
                    sessionData.changeCurrentInHistory(this.outExpr);
                    this.outBuf.append("Out[" + Integer.toString(sessionData.getCounter(), 10) + "]:\n");
                }
                this.outBuf.appendLine(this.outExpr.toString());
            }
        }
        catch (SyntaxError syntaxError) {
            this.outBuf.append("Syntax Error: " + syntaxError.getMessage());
        }
        catch (HBreakException hBreakException) {
            this.outBuf.appendLine("Break() occured outside For, While, Switch");
        }
        catch (HContinueException hContinueException) {
            this.outBuf.appendLine("Continue() occured outside For, While");
        }
        catch (HReturnException hReturnException) {
            this.outBuf.appendLine("Return() occured");
        }
        catch (HThrowException hThrowException) {
            this.outBuf.appendLine("Throw::" + hThrowException.why().toString());
        }
        catch (Throwable throwable) {
            this.outBuf.appendLine("Unknown Exception occured: " + throwable.getMessage());
        }
        this.evaluated = true;
    }

    public void setInput(String string) {
        this.inStr = string;
        this.outExpr = null;
        this.outBuf = new OutputStringBuffer();
        this.evaluated = false;
    }
}

