/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

public final class ExtraMath {
    private ExtraMath() {
    }

    public static double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double asinh(double d) {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double atanh(double d) {
        return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double tanh(double d) {
        return ExtraMath.sinh(d) / ExtraMath.cosh(d);
    }
}

