/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Line;
import geonext.Point;
import geonext.Text;
import java.awt.Color;
import java.awt.Graphics2D;

public class Arrow
extends Line {
    public int xx;

    public Arrow() {
        this.initArrow();
    }

    public Arrow(Point point, Point point2, int n, int n2) {
        super(point, point2, n, n2);
        this.initArrow();
    }

    public void initNameText(JBoardPane jBoardPane) {
        this.nameText = new Text();
        this.nameText.setUser(this.getTextAnchor());
        this.nameText.setText(jBoardPane.changeChar("<arrow>" + this.getName() + "</arrow>"));
        this.nameText.parseHTML(jBoardPane);
        this.nameText.evaluate(jBoardPane);
    }

    public Arrow(String string, int n, Point point, Point point2, int n2) {
        super(string, n, point, point2, n2);
        this.initArrow();
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("arrow_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        super.draw(graphics2D, jBoardPane);
        if (this.exists() && this.isVisible()) {
            this.drawTop(graphics2D, jBoardPane);
        }
    }

    public void drawTop(Graphics2D graphics2D, JBoardPane jBoardPane) {
        graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
        double d = this.getB().getScreenX() - this.getA().getScreenX();
        double d2 = this.getB().getScreenY() - this.getA().getScreenY();
        int[] nArray = new int[]{jBoardPane.round(this.getB().getScreenX()), jBoardPane.round(this.getB().getScreenX() - (d /= this.getA().screenDistance(this.getB())) * 10.0 + (d2 /= this.getA().screenDistance(this.getB())) * 5.0), jBoardPane.round(this.getB().getScreenX() - d * 10.0 - d2 * 5.0)};
        int[] nArray2 = new int[]{jBoardPane.round(this.getB().getScreenY()), jBoardPane.round(this.getB().getScreenY() - d2 * 10.0 - d * 5.0), jBoardPane.round(this.getB().getScreenY() - d2 * 10.0 + d * 5.0)};
        if (!this.isDraft()) {
            if (this.isMode() && jBoardPane.getModus() != 210260) {
                graphics2D.setColor(this.getLighting());
            } else {
                graphics2D.setColor(this.getStroke());
            }
        } else {
            graphics2D.setColor(this.getDraftColor());
        }
        graphics2D.fillPolygon(nArray, nArray2, 3);
    }

    public String getElementName() {
        return this.elementName;
    }

    public void initArrow() {
        this.setArrow(true);
        this.stroke = Color.blue;
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0, 0);
        this.typeString = "arrow";
        this.setElementName(Geonext.language.getString("arrow_element_name"));
        this.setEditable(false);
        this.textName = true;
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Point point = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "first")[1]);
            Point point2 = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "last")[1]);
            if (point == null || point2 == null || point.equals(point2)) {
                return false;
            }
            jBoardPane.createArrow(point, point2, string2, false);
            Arrow arrow = (Arrow)jBoardPane.element.arrow.lastElement();
            string = arrow.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = super.writeData(string);
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        return string2;
    }

    public String shortInfo() {
        if (this.getParent() != null) {
            return this.getParent().shortInfo();
        }
        return this.generateShort(Geonext.language.getString("arrow_short"));
    }
}

