/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Angle;
import geonext.Arc;
import geonext.CASPoint;
import geonext.Circle;
import geonext.Composition;
import geonext.Element;
import geonext.GeonetFileFilter;
import geonext.Geonext;
import geonext.Graph;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.JButton;
import geonext.JCheckBox;
import geonext.JContentColorChooser;
import geonext.JContentPanel;
import geonext.JDashListRenderer;
import geonext.JFileChooser;
import geonext.JFrameDialog;
import geonext.JObjectListRenderer;
import geonext.JPointStyleListRenderer;
import geonext.JViewPanel;
import geonext.Line;
import geonext.Point;
import geonext.Polygon;
import geonext.Slider;
import geonext.Text;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class JContentEdit
extends JContentPanel
implements ActionListener,
ListSelectionListener,
ItemListener,
ChangeListener {
    public JBoardPane board;
    public boolean pointStyleRefresh = false;
    public Vector elements;
    public JScrollPane scrollList;
    public Vector selectedElements = new Vector();
    public JContentColorChooser strokeChooser;
    public JContentColorChooser fillChooser;
    public JPanel linePanel;
    public JPanel pointPanel;
    public JPanel sliderPanel;
    public JPanel anglePanel;
    public BufferedImage pointImage;
    public JPanel stepPanel;
    public JTextField stepField;
    public JLabel stepLabel;
    public javax.swing.JButton stepButton;
    public JPanel nonePanel;
    public JPanel generalPanel;
    public JPanel imgPanel;
    public JPanel intersectionPanel;
    public JPanel textPanel;
    public JPanel boxPanel;
    public JPanel posPanel;
    public JPanel optionPanel;
    public JPanel dashPanel;
    public JPanel arcPanel;
    public JPanel casPointPanel;
    public JComboBox pointStyleCombo;
    public JComboBox[] pointStyleComboBoxes = new JComboBox[4];
    public JContentColorChooser labelChooser;
    public JList objectList;
    public JTextField typeField;
    public JCheckBox visibleBox;
    public JComboBox dashBox;
    public JCheckBox fullCircleBox;
    public JCheckBox firstArrowBox;
    public JCheckBox lastArrowBox;
    public JSlider dashSlider;
    public JCheckBox draftBox;
    public JCheckBox coordinatePointBox;
    public JCheckBox coordinateCASPointBox;
    public JCheckBox coordinateSliderBox;
    public JCheckBox animatedSliderBox;
    public JCheckBox directionSliderBox;
    public JCheckBox onPolygonSliderBox;
    public JCheckBox intersectionBox;
    public JComboBox textDigits;
    public JCheckBox fixBox;
    public JCheckBox traceBox;
    public JCheckBox freeSliderBox;
    public JCheckBox coordinateIntersectionBox;
    public JCheckBox textFixBox;
    public JTextField nameField;
    public JTextField angleUnitField;
    public JTextField pointPosXField;
    public JTextField textJSField;
    public JTextField pointPosYField;
    public JViewPanel textViewPanel;
    public JViewPanel angleTextViewPanel;
    public JTextArea infoField;
    public JTextField angleTextField;
    public JLabel nameLabel;
    public JLabel typeLabel;
    public JTabbedPane elementTabbed;
    public JLabel infoLabel;
    public boolean lastMode = false;
    public boolean firstMode = false;
    public Vector tabbed;
    javax.swing.JButton nameButton;

    public JContentEdit() {
    }

    public JContentEdit(JBoardPane jBoardPane) {
        this.initContentEdit(jBoardPane);
        this.validateTree();
    }

    public JContentEdit(JBoardPane jBoardPane, Object object) {
        this.initContentEdit(jBoardPane);
        try {
            this.selectedElements.addElement((Element)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selectList(this.selectedElements);
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = this.elementTabbed.getSelectedComponent();
        String string = actionEvent.getActionCommand();
        if (string.equals("setPointStyle")) {
            this.pointStyleCombo = (JComboBox)actionEvent.getSource();
        }
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.board.setSaved(false);
            this.board.getGeonextEditDialog().dispose();
        } else {
            if (string.equals("apply")) {
                this.board.setSaved(false);
                this.board.getGeonextEditDialog().dispose();
                this.board.repaint();
                return;
            }
            if (string.equals("cancel")) {
                this.board.getGeonextEditDialog().dispose();
            } else {
                try {
                    this.board.setSaved(false);
                    Method method = this.getClass().getMethod(string, null);
                    method.invoke((Object)this, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            ((JButton)actionEvent.getSource()).removeActionListener(this);
            this.refreshList();
            this.elementTabbed.setSelectedComponent(component);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.board.repaint();
        if (string.equals("rename")) {
            this.nameField.requestFocus();
        }
    }

    public JList createElementList() {
        this.elements = new Vector();
        Vector vector = new Vector();
        vector = this.generateListVector();
        JList<Object> jList = new JList<Object>(vector);
        jList.setCellRenderer(new JObjectListRenderer());
        jList.setFixedCellHeight(35);
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = new Vector();
            vector2.addElement(vector.get(i));
            vector2.addElement(this.elements.get(i));
            vector2.addElement(this.board);
            vector.setElementAt(vector2, i);
        }
        Object[] objectArray = vector.toArray();
        jList.setListData(objectArray);
        jList.addListSelectionListener(this);
        return jList;
    }

    public void delete() {
        this.board.deleteElements(this.selectedElements);
        try {
            this.refreshList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JPanel addPointStylePanel(JComboBox jComboBox) {
        for (int i = 0; i < 14; ++i) {
            jComboBox.addItem("" + (i - 1));
        }
        jComboBox.setActionCommand("setPointStyle");
        jComboBox.addActionListener(this);
        jComboBox.setRenderer(new JPointStyleListRenderer());
        javax.swing.JButton jButton = new javax.swing.JButton(Geonext.language.getString("jcontentbackground_load_image"));
        jButton.addActionListener(this);
        jButton.setActionCommand("loadImgButton");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("West", jComboBox);
        jPanel.add("Center", jButton);
        return jPanel;
    }

    public void editText() {
        if (this.board.geonextTextDialog != null) {
            this.board.geonextTextDialog.dispose();
        }
        this.board.geonextTextDialog = new JFrameDialog("", new Dimension(550, 400), 2, this.board, this.selectedElements.get(0), false, false, true, true);
        this.board.geonextTextDialog.pack();
        this.board.geonextTextDialog.setVisible(true);
        this.board.geonextTextDialog.show();
        this.board.geonextTextDialog.requestFocus();
    }

    public Vector generateListVector() {
        this.elements = new Vector();
        Vector<String> vector = new Vector<String>();
        for (int i = 5; i < this.board.element.elements.size(); ++i) {
            int n;
            Element element;
            if (this.board.element.elements.get(i) instanceof Composition) {
                element = (Composition)this.board.element.elements.get(i);
                for (n = 0; n < ((Composition)element).elements.size(); ++n) {
                    this.elements.addElement(((Composition)element).elements.get(n));
                    vector.addElement(((Element)((Composition)element).elements.get(n)).getElementName() + " " + this.board.changeChar(((Element)((Composition)element).elements.get(n)).getName()));
                }
                continue;
            }
            if (this.board.element.elements.get(i) instanceof Intersection) {
                element = (Intersection)this.board.element.elements.get(i);
                if (((Intersection)element).getType() == 0) {
                    this.elements.addElement(((Intersection)element).getA());
                    vector.addElement(((Intersection)element).getA().getElementName() + " " + this.board.changeChar(((Intersection)element).getA().getName()));
                    continue;
                }
                this.elements.addElement(((Intersection)element).getA());
                vector.addElement(((Intersection)element).getA().getElementName() + " " + this.board.changeChar(((Intersection)element).getA().getName()));
                this.elements.addElement(((Intersection)element).getB());
                vector.addElement(((Intersection)element).getB().getElementName() + " " + this.board.changeChar(((Intersection)element).getB().getName()));
                continue;
            }
            if (this.board.element.elements.get(i) instanceof Polygon) {
                element = (Polygon)this.board.element.elements.get(i);
                this.elements.addElement(element);
                vector.addElement(((Polygon)element).getElementName() + " " + this.board.changeChar(element.getName()));
                for (n = 0; n < ((Polygon)element).border.length; ++n) {
                    this.elements.addElement(((Polygon)element).border[n]);
                    vector.addElement(((Polygon)element).border[n].getElementName() + " " + this.board.changeChar(((Polygon)element).border[n].getName()));
                }
                continue;
            }
            if (this.board.element.elements.get(i) instanceof Angle) {
                element = (Angle)this.board.element.elements.get(i);
                this.elements.addElement(element);
                vector.addElement(element.getElementName() + " " + this.board.changeChar(((Angle)element).getText().getText()));
                continue;
            }
            this.elements.addElement(this.board.element.elements.get(i));
            vector.addElement(((Element)this.board.element.elements.get(i)).getElementName() + " " + this.board.changeChar(((Element)this.board.element.elements.get(i)).getName()));
        }
        return vector;
    }

    public boolean getMultipleValue(Vector vector, String string) {
        if (vector.size() > 0) {
            String string2 = "" + ((Element)vector.get(0)).get(string);
            for (int i = 0; i < vector.size(); ++i) {
                if (string2.equals(((Element)vector.get(i)).get(string))) continue;
                return true;
            }
        }
        return false;
    }

    public Vector getTabbed() {
        return this.tabbed;
    }

    public Vector getType() {
        Vector vector = new Vector();
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            if (vector.contains(this.selectedElements.get(i).getClass())) continue;
            vector.add(this.selectedElements.get(i).getClass());
        }
        return vector;
    }

    public void initContentEdit(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.selectedElements = new Vector();
        this.setLayout(new BorderLayout(15, 15));
        this.objectList = this.createElementList();
        this.scrollList = new JScrollPane(this.objectList);
        this.scrollList.setPreferredSize(new Dimension(150, 150));
        this.typeField = new JTextField(5);
        this.typeField.setBackground(this.getBackground());
        this.typeField.setBorder(new EtchedBorder(1));
        this.typeField.setEditable(false);
        this.nameField = new JTextField(5);
        this.nameField.addActionListener(this);
        this.nameField.setActionCommand("rename");
        this.nameButton = new javax.swing.JButton(" " + Geonext.language.getString("jcontentedit_rename") + " ");
        this.nameButton.addActionListener(this);
        this.nameButton.setActionCommand("rename");
        this.nameButton.setBorder(new EtchedBorder(1));
        this.infoField = new JTextArea(4, 3);
        this.infoField.setLineWrap(true);
        this.infoField.setWrapStyleWord(true);
        this.infoField.setBackground(this.getBackground());
        this.infoField.setBorder(new EtchedBorder(1));
        this.infoField.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("Center", this.nameField);
        jPanel.add("East", this.nameButton);
        this.typeLabel = new JLabel(Geonext.language.getString("jcontentedit_type"));
        this.typeLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.nameLabel = new JLabel(Geonext.language.getString("jcontentedit_name"));
        this.infoLabel = new JLabel(Geonext.language.getString("jcontentedit_info"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel2.add(this.typeLabel);
        jPanel2.add(this.nameLabel);
        jPanel2.add(this.infoLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("North", jPanel2);
        jPanel3.add("Center", new JPanel());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel4.add(this.typeField);
        jPanel4.add(jPanel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add("North", jPanel4);
        jPanel5.add("Center", this.infoField);
        javax.swing.JButton jButton = new javax.swing.JButton(new ImageIcon(this.getClass().getResource("24/mode_delete.gif")));
        jButton.addActionListener(this);
        jButton.setActionCommand("delete");
        jButton.setPreferredSize(new Dimension(24, 28));
        javax.swing.JButton jButton2 = new javax.swing.JButton(new ImageIcon(this.getClass().getResource("16/selectall.gif")));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("selectAll");
        jButton2.setPreferredSize(new Dimension(24, 28));
        javax.swing.JButton jButton3 = new javax.swing.JButton(new ImageIcon(this.getClass().getResource("16/deselect.gif")));
        jButton3.addActionListener(this);
        jButton3.setActionCommand("deselect");
        jButton3.setPreferredSize(new Dimension(24, 28));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel6.add(jButton3);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(5, 5));
        jPanel7.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel7.add("Center", this.scrollList);
        jPanel7.add("South", jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel8.setLayout(new BorderLayout(15, 15));
        jPanel8.add("West", jPanel3);
        jPanel8.add("Center", jPanel5);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel9.setLayout(new BorderLayout(5, 5));
        jPanel9.add("North", jPanel8);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentedit_objects") + " "));
        jPanel10.setLayout(new BorderLayout(15, 15));
        jPanel10.add("Center", jPanel7);
        this.setTabbed();
        this.elementTabbed = new JTabbedPane();
        this.elementTabbed.setTabLayoutPolicy(1);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentedit_object_info") + " "));
        jPanel11.add("North", jPanel9);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(0, 0));
        jPanel12.add("North", jPanel11);
        jPanel12.add("Center", new JLabel(""));
        jPanel12.add("South", this.elementTabbed);
        this.add("West", jPanel10);
        this.add("Center", jPanel12);
        this.setProperties();
    }

    public boolean isCorrectType(String string) {
        if (this.selectedElements == null || this.selectedElements.size() == 0) {
            return false;
        }
        if (string.equals("")) {
            return true;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken().toLowerCase(new Locale("en")));
        }
        if (vector.contains("intersection")) {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                if (((Element)this.selectedElements.get(i)).getParent() instanceof Intersection || vector.contains(("" + this.selectedElements.get(i).getClass()).substring(("" + this.selectedElements.get(i).getClass()).lastIndexOf(".") + 1, ("" + this.selectedElements.get(i).getClass()).length()).toLowerCase(new Locale("en")))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                if (((Element)this.selectedElements.get(i)).getParent() instanceof Intersection) {
                    return false;
                }
                if (vector.contains(("" + this.selectedElements.get(i).getClass()).substring(("" + this.selectedElements.get(i).getClass()).lastIndexOf(".") + 1, ("" + this.selectedElements.get(i).getClass()).length()).toLowerCase(new Locale("en")))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLineEditable() {
        try {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                if (((Line)this.selectedElements.get(i)).isEditable()) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void refreshList() {
        int[] nArray = this.objectList.getSelectedIndices();
        Vector vector = new Vector();
        vector = this.generateListVector();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = new Vector();
            vector2.addElement(vector.get(i));
            vector2.addElement(this.elements.get(i));
            vector2.addElement(this.board);
            vector.setElementAt(vector2, i);
        }
        this.objectList.setListData(vector);
        try {
            this.objectList.setSelectedIndices(nArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectAll() {
        this.objectList.setSelectionInterval(0, this.objectList.getModel().getSize() - 1);
    }

    public void deselect() {
        this.objectList.clearSelection();
    }

    public void rename() {
        if (!this.nameField.getText().equals("")) {
            this.board.setSaved(false);
            int[] nArray = this.objectList.getSelectedIndices();
            String string = this.nameField.getText();
            if (this.board.element.searchName(string) == null) {
                ((Element)this.selectedElements.get(0)).setName(string);
                ((Element)this.selectedElements.get(0)).initNameText(this.board);
            } else {
                Element element = this.board.element.searchName(string);
                ((Element)this.selectedElements.get(0)).setName(string);
                ((Element)this.selectedElements.get(0)).initNameText(this.board);
                if (element != (Element)this.selectedElements.get(0)) {
                    int n = 1;
                    while (this.board.element.searchName(string + "[" + n + "]") != null) {
                        ++n;
                    }
                    element.setName(string + "[" + n + "]");
                    element.initNameText(this.board);
                }
            }
            for (int i = 0; i < this.board.element.text.size(); ++i) {
                ((Text)this.board.element.text.get(i)).evaluate(this.board);
            }
        }
        this.refreshList();
    }

    public void reset() {
        this.strokeChooser.setBackView(this.board.getBackground());
        this.fillChooser.setBackView(this.board.getBackground());
        this.labelChooser.setBackView(this.board.getBackground());
    }

    public void selectList(Vector vector) {
        try {
            int[] nArray = this.objectList.getSelectedIndices();
            if (nArray != null && vector.size() != 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (vector.contains(this.elements.get(nArray[i]))) {
                        vector.remove(this.elements.get(nArray[i]));
                        continue;
                    }
                    vector.addElement(this.elements.get(nArray[i]));
                }
            }
            int[] nArray2 = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                nArray2[i] = this.elements.indexOf(vector.get(i));
            }
            this.objectList.setSelectedIndices(nArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateTree();
    }

    public void setAngleLabel() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Angle)this.selectedElements.get(i)).setText(new Text("", 0, this.angleTextField.getText(), 0));
        }
    }

    public void setAngleRadius() {
        double d = 0.0;
        try {
            d = new Double(this.angleUnitField.getText());
        }
        catch (Throwable throwable) {
            d = 1.0;
        }
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Angle)this.selectedElements.get(i)).setR(d);
        }
    }

    public void setArcFullCircle() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Arc)this.selectedElements.get(i)).setFullCircle(this.fullCircleBox.isSelected());
            ((Arc)this.selectedElements.get(i)).setChanged(true);
        }
        this.board.calculateElements();
    }

    public void setArcFirstArrow() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Arc)this.selectedElements.get(i)).setFirstArrow(this.firstArrowBox.isSelected());
        }
    }

    public void setArcLastArrow() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Arc)this.selectedElements.get(i)).setLastArrow(this.lastArrowBox.isSelected());
        }
    }

    public void setCASShowCoord() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((CASPoint)this.selectedElements.get(i)).setCoordinates(this.coordinateCASPointBox.isSelected());
        }
    }

    public void setCheckBox(JCheckBox jCheckBox, Vector vector, String string) {
        if (vector.size() > 0) {
            boolean bl = this.getMultipleValue(vector, string);
            jCheckBox.setMultiple(bl);
            if (bl) {
                jCheckBox.setSelected(true);
            } else {
                jCheckBox.setSelected(new Boolean(((Element)vector.get(0)).get(string)));
            }
        }
    }

    public void setCoord() {
        this.pointPosXField.setForeground(Color.black);
        this.pointPosYField.setForeground(Color.black);
        if (this.isCorrectType("Point;Slider")) {
            String string = this.pointPosXField.getText();
            String string2 = this.pointPosYField.getText();
            C.boardName = this.board.internalName;
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = true;
            try {
                d = new Double(C.NEV(new Scanner(string, false).start()).toString());
            }
            catch (Throwable throwable) {
                this.pointPosXField.setText(string);
                this.pointPosXField.setForeground(Color.red);
                bl = false;
            }
            if (bl) {
                for (int i = 0; i < this.selectedElements.size(); ++i) {
                    ((Point)this.selectedElements.get(i)).setUserX(d);
                    ((Point)this.selectedElements.get(i)).setChanged(true);
                }
            }
            bl = true;
            try {
                d2 = new Double(C.NEV(new Scanner(string2, false).start()).toString());
            }
            catch (Throwable throwable) {
                this.pointPosYField.setText(string2);
                this.pointPosYField.setForeground(Color.red);
                bl = false;
            }
            if (bl) {
                for (int i = 0; i < this.selectedElements.size(); ++i) {
                    ((Point)this.selectedElements.get(i)).setUserY(d2);
                    ((Point)this.selectedElements.get(i)).setChanged(true);
                }
            }
        }
        this.board.calculateElements();
    }

    public void setDash() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setDash(this.dashBox.getSelectedIndex());
        }
    }

    public void setDraft() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setDraft(this.draftBox.isSelected());
        }
    }

    public void setImage() {
        this.loadImg();
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setImage(this.pointImage);
        }
        this.pointImage = null;
    }

    public void setDeleteImage() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setImage(null);
        }
    }

    public void setFirstMode() {
        this.firstMode = !this.firstMode;
        this.setLine();
    }

    public void setFix() {
        if (this.isCorrectType("Point")) {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                ((Point)this.selectedElements.get(i)).setFix(this.fixBox.isSelected());
            }
        }
    }

    public void setFree() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Slider)this.selectedElements.get(i)).setFree(this.freeSliderBox.isSelected());
            ((Point)this.selectedElements.get(i)).setChanged(true);
        }
        this.board.calculateElements();
    }

    public void setInfoField() {
        this.infoField.setText("");
        if (this.selectedElements.size() == 1) {
            Element element = (Element)this.selectedElements.get(0);
            this.infoField.setText("" + element.shortInfo());
        } else if (this.selectedElements.size() == 0) {
            this.infoField.setText(Geonext.language.getString("jcontentedit_no_object"));
        } else {
            this.infoField.setText(Geonext.language.getString("jcontentedit_multi_object"));
        }
    }

    public void setIntersection() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            Intersection intersection = (Intersection)((Point)this.selectedElements.get(i)).getParent();
            intersection.setConstructionLine(this.intersectionBox.isSelected());
            if (!this.intersectionBox.isSelected()) continue;
            intersection.getE().setDraft(true);
            intersection.getF().setDraft(true);
        }
    }

    public void setIntersectionShowCoord() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Point)this.selectedElements.get(i)).setCoordinates(this.coordinateIntersectionBox.isSelected());
        }
    }

    public void setJSFunction() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Text)this.selectedElements.get(i)).setJavaScriptFunction(this.textJSField.getText());
        }
        this.board.javaScript();
    }

    public void setLastMode() {
        this.lastMode = !this.lastMode;
        this.setLine();
    }

    public void setLine() {
        if (this.isCorrectType("Line")) {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                if (this.firstMode) {
                    ((Line)this.selectedElements.get(i)).setFirst(true);
                } else {
                    ((Line)this.selectedElements.get(i)).setFirst(false);
                }
                if (this.lastMode) {
                    ((Line)this.selectedElements.get(i)).setLast(true);
                } else {
                    ((Line)this.selectedElements.get(i)).setLast(false);
                }
                ((Element)this.selectedElements.get(i)).setChanged(true);
            }
            this.board.calculateElements();
            this.board.setSaved(false);
        }
    }

    public void setLineFirstLast() {
        if (this.firstMode) {
            this.firstMode = false;
            this.lastMode = true;
        } else {
            this.firstMode = true;
            this.lastMode = false;
        }
        this.setLine();
        this.repaint();
    }

    public void setLineLine() {
        this.firstMode = false;
        this.lastMode = false;
        this.setLine();
        this.repaint();
    }

    public void setLineMode() {
        if (!this.firstMode && !this.lastMode) {
            this.firstMode = true;
            this.lastMode = true;
        } else {
            this.firstMode = false;
            this.lastMode = false;
        }
        this.setLine();
        this.repaint();
    }

    public void setLineStraight() {
        this.firstMode = true;
        this.lastMode = true;
        this.setLine();
        this.repaint();
    }

    public void setPointShowCoord() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Point)this.selectedElements.get(i)).setCoordinates(this.coordinatePointBox.isSelected());
        }
    }

    public void setPointStyle() {
        this.pointImage = null;
        if (!this.pointStyleRefresh) {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                Point point = (Point)this.selectedElements.get(i);
                if (this.pointStyleCombo.getSelectedIndex() == 0 && point.getImage() == null) {
                    if (this.pointImage == null) {
                        this.loadImg();
                    }
                    point.setImage(null);
                    Graphics2D graphics2D = point.getImage().createGraphics();
                    graphics2D.drawImage((Image)this.pointImage, 0, 0, null);
                    point.setImage(this.pointImage);
                }
                point.setStyle(this.pointStyleCombo.getSelectedIndex() - 1);
                point.draw((Graphics2D)this.board.jep.getGraphics(), this.board);
            }
        }
    }

    public void setProperties() {
        try {
            this.setTabbedPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInfoField();
        this.typeField.setText("");
        this.nameField.setBackground(this.getBackground());
        this.nameField.setText("");
        this.nameButton.setEnabled(false);
        switch (this.selectedElements.size()) {
            case 0: {
                this.setTabbedPane();
                break;
            }
            case 1: {
                Element element = (Element)this.selectedElements.get(0);
                this.typeField.setText(element.getElementName());
                this.nameField.setBackground(new JTextField().getBackground());
                this.nameField.setText(element.getName());
                this.nameButton.setEnabled(true);
                this.visibleBox.setSelected(!element.isVisible());
                this.draftBox.setSelected(element.isDraft());
                this.traceBox.setSelected(element.isTrace());
                this.visibleBox.setMultiple(false);
                this.draftBox.setMultiple(false);
                this.traceBox.setMultiple(false);
                this.strokeChooser.setElements(this.selectedElements);
                this.fillChooser.setElements(this.selectedElements);
                this.labelChooser.setElements(this.selectedElements);
                this.dashBox.removeActionListener(this);
                this.dashBox.setSelectedIndex(element.getDash());
                this.dashBox.addActionListener(this);
                this.dashSlider.removeChangeListener(this);
                this.dashSlider.setValue(element.getStrokeWidth());
                this.dashSlider.addChangeListener(this);
                try {
                    String string = "" + element.getClass();
                    if (element.getParent() instanceof Intersection) {
                        this.setPropertiesIntersection(this.selectedElements);
                        break;
                    }
                    if ((string = string.substring(string.lastIndexOf(".") + 1, string.length())).toLowerCase(new Locale("en")).equals("graphslider")) {
                        string = "Slider";
                    }
                    Class[] classArray = new Class[]{new Vector().getClass()};
                    Method method = this.getClass().getMethod("setProperties" + string, classArray);
                    Object[] objectArray = new Object[]{this.selectedElements};
                    method.invoke((Object)this, objectArray);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                Element element = (Element)this.selectedElements.get(0);
                boolean bl = this.getMultipleValue(this.selectedElements, "visible");
                this.visibleBox.setMultiple(bl);
                if (bl) {
                    this.visibleBox.setSelected(true);
                } else {
                    this.visibleBox.setSelected(new Boolean(element.get("visible")) == false);
                }
                this.setCheckBox(this.draftBox, this.selectedElements, "draft");
                this.setCheckBox(this.traceBox, this.selectedElements, "trace");
                this.strokeChooser.setElements(this.selectedElements);
                this.fillChooser.setElements(this.selectedElements);
                this.labelChooser.setElements(this.selectedElements);
                this.dashBox.removeActionListener(this);
                if (this.getMultipleValue(this.selectedElements, "dash")) {
                    this.dashBox.setSelectedIndex(0);
                } else {
                    this.dashBox.setSelectedIndex(element.getDash());
                }
                this.dashBox.addActionListener(this);
                this.dashSlider.removeChangeListener(this);
                if (this.getMultipleValue(this.selectedElements, "strokewidth")) {
                    this.dashSlider.setValue(2);
                } else {
                    this.dashSlider.setValue(element.getStrokeWidth());
                }
                this.dashSlider.addChangeListener(this);
                try {
                    String string = "" + element.getClass();
                    if (element.getParent() instanceof Intersection) {
                        this.setPropertiesIntersection(this.selectedElements);
                        break;
                    }
                    string = string.substring(string.lastIndexOf(".") + 1, string.length());
                    Class[] classArray = new Class[]{new Vector().getClass()};
                    Method method = this.getClass().getMethod("setProperties" + string, classArray);
                    Object[] objectArray = new Object[]{this.selectedElements};
                    method.invoke((Object)this, objectArray);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setPropertiesAngle(Vector vector) {
        Angle angle = (Angle)vector.get(0);
        if (this.getMultipleValue(vector, "textvalue")) {
            this.angleTextField.setText("");
        } else {
            this.angleTextField.setText(angle.getTextvalue());
        }
        if (this.getMultipleValue(vector, "r")) {
            this.angleUnitField.setText("");
        } else {
            this.angleUnitField.setText("" + angle.getR());
        }
    }

    public void setPropertiesArc(Vector vector) {
        this.setCheckBox(this.fullCircleBox, vector, "fullcircle");
        this.setCheckBox(this.firstArrowBox, vector, "firstarrow");
        this.setCheckBox(this.lastArrowBox, vector, "lastarrow");
    }

    public void setPropertiesCASPoint(Vector vector) {
        this.setCheckBox(this.coordinateCASPointBox, vector, "coordinates");
        Point point = (Point)vector.get(0);
        this.pointStyleRefresh = true;
        this.pointStyleComboBoxes[1].setSelectedIndex(point.getStyle() + 1);
        this.pointStyleRefresh = false;
    }

    public void setPropertiesIntersection(Vector vector) {
        this.setCheckBox(this.coordinateIntersectionBox, vector, "coordinates");
        this.setCheckBox(this.intersectionBox, vector, "constructionline");
        Point point = (Point)vector.get(0);
        this.pointStyleRefresh = true;
        this.pointStyleComboBoxes[2].setSelectedIndex(point.getStyle() + 1);
        this.pointStyleRefresh = false;
    }

    public void setPropertiesLine(Vector vector) {
        Line line = (Line)vector.get(0);
        this.firstMode = this.getMultipleValue(vector, "first") ? false : line.isFirst();
        this.lastMode = this.getMultipleValue(vector, "last") ? false : line.isLast();
    }

    public void setPropertiesPoint(Vector vector) {
        this.boxPanel.remove(this.fixBox);
        this.optionPanel.remove(this.posPanel);
        Point point = (Point)vector.get(0);
        this.pointStyleRefresh = true;
        this.pointStyleComboBoxes[0].setSelectedIndex(point.getStyle() + 1);
        this.pointStyleRefresh = false;
        this.setCheckBox(this.coordinatePointBox, vector, "coordinates");
        boolean bl = false;
        int n = -1;
        while (++n < vector.size() && !bl) {
            if (((Point)vector.get(n)).getParent() == null || !(((Point)vector.get(n)).getParent() instanceof Composition)) continue;
            bl = true;
        }
        if (!bl) {
            this.boxPanel.add(this.fixBox);
            this.setCheckBox(this.fixBox, vector, "fix");
            this.optionPanel.add(this.posPanel);
            if (this.getMultipleValue(vector, "x")) {
                this.pointPosXField.setText("");
            } else {
                this.pointPosXField.setText("" + point.getUserX());
            }
            if (this.getMultipleValue(vector, "y")) {
                this.pointPosYField.setText("");
            } else {
                this.pointPosYField.setText("" + point.getUserY());
            }
        }
        this.pointPanel.updateUI();
    }

    public void setPropertiesSlider(Vector vector) {
        Slider slider = (Slider)vector.get(0);
        this.pointStyleRefresh = true;
        this.pointStyleComboBoxes[3].setSelectedIndex(slider.getStyle() + 1);
        this.pointStyleRefresh = false;
        this.setCheckBox(this.freeSliderBox, vector, "free");
        this.setCheckBox(this.coordinateSliderBox, vector, "coordinates");
        this.setCheckBox(this.animatedSliderBox, vector, "animated");
        this.setCheckBox(this.directionSliderBox, vector, "direction");
        this.setCheckBox(this.onPolygonSliderBox, vector, "OnPolygon");
        this.stepPanel.setVisible(true);
        this.animatedSliderBox.setVisible(true);
        this.directionSliderBox.setVisible(true);
        this.onPolygonSliderBox.setVisible(true);
        if (slider.getE() instanceof Circle) {
            this.freeSliderBox.setEnabled(true);
            this.onPolygonSliderBox.setVisible(false);
            this.stepLabel.setText(Geonext.language.getString("jcontentedit_circle_step_unit"));
            this.directionSliderBox.setText(Geonext.language.getString("jcontentedit_circle_direction"));
        }
        if (slider.getE() instanceof Line) {
            this.freeSliderBox.setEnabled(true);
            this.stepLabel.setText(Geonext.language.getString("jcontentedit_line_steps"));
            this.directionSliderBox.setText(Geonext.language.getString("jcontentedit_line_direction"));
            if (!((Line)slider.getE()).isEditable()) {
                this.stepPanel.setVisible(false);
                this.animatedSliderBox.setVisible(false);
                this.directionSliderBox.setVisible(false);
            }
            if (!(((Line)slider.getE()).getParent() instanceof Polygon)) {
                this.onPolygonSliderBox.setVisible(false);
            }
        }
        if (slider.getE() instanceof Graph) {
            this.freeSliderBox.setEnabled(false);
            this.onPolygonSliderBox.setVisible(false);
            this.stepLabel.setText(Geonext.language.getString("jcontentedit_graph_step_unit"));
            this.directionSliderBox.setText(Geonext.language.getString("jcontentedit_graph_direction"));
        }
        this.stepField.setText("" + slider.getSpeed());
    }

    public void setPropertiesText(Vector vector) {
        Text text = (Text)vector.get(0);
        this.textFixBox.setSelected(text.isFix());
        this.textJSField.setText(text.getJavaScriptFunction());
        this.textViewPanel.setText(text);
        if (text.isAutoDigits()) {
            this.textDigits.setSelectedIndex(0);
        } else {
            this.textDigits.setSelectedIndex(text.getDigits() + 1);
        }
    }

    public void setSliderShowCoord() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Slider)this.selectedElements.get(i)).setCoordinates(this.coordinateSliderBox.isSelected());
        }
    }

    public void setSliderAnimated() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Slider)this.selectedElements.get(i)).setAnimated(this.animatedSliderBox.isSelected());
        }
    }

    public void setSliderDirection() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Slider)this.selectedElements.get(i)).setDirection(this.directionSliderBox.isSelected());
        }
    }

    public void setSliderOnPolygon() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Slider)this.selectedElements.get(i)).setOnPolygon(this.onPolygonSliderBox.isSelected());
            ((Point)this.selectedElements.get(i)).setChanged(true);
        }
        this.board.calculateElements();
    }

    public void setStep() {
        double d = 1.0;
        Slider slider = (Slider)this.selectedElements.get(0);
        try {
            d = new Double(this.stepField.getText());
            if (slider.getE() instanceof Circle) {
                slider.setSpeed(d % 360.0);
                d = slider.getSpeed();
            }
        }
        catch (Exception exception) {
            d = slider.getSpeed();
        }
        this.stepField.setText("" + d);
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Slider)this.selectedElements.get(i)).setSpeed(d);
        }
    }

    public void setStrokeWidth() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setStrokeWidth(this.dashSlider.getValue());
        }
    }

    public Vector setTab(JPanel jPanel, String string, String string2, String string3) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(jPanel);
        vector.addElement(string);
        if (string2.equals("")) {
            vector.addElement(null);
        } else {
            vector.addElement(new ImageIcon(this.getClass().getResource(string2)));
        }
        if (string3.equals("")) {
            vector.addElement("");
        } else {
            vector.addElement(string3);
        }
        return vector;
    }

    public void setTabbed() {
        this.tabNone();
        this.tabGeneral();
        this.tabStroke();
        this.tabLabel();
        this.tabFill();
        this.tabAngle();
        this.tabArc();
        this.tabCASPoint();
        this.tabIntersection();
        this.tabLine();
        this.tabPoint();
        this.tabSlider();
        this.tabText();
        this.tabDash();
        this.tabImage();
        this.tabbed = new Vector();
        this.tabbed.addElement(this.setTab(this.generalPanel, Geonext.language.getString("jcontentedit_tab_common"), "12/preferences.gif", ""));
        this.tabbed.addElement(this.setTab(this.strokeChooser, Geonext.language.getString("jcontentedit_tab_stroke"), "12/color.gif", ""));
        this.tabbed.addElement(this.setTab(this.labelChooser, Geonext.language.getString("jcontentedit_tab_label"), "12/color.gif", ""));
        this.tabbed.addElement(this.setTab(this.fillChooser, Geonext.language.getString("jcontentedit_tab_fill"), "12/color.gif", "Polygon;Circle;Angle;Arc;Group"));
        this.tabbed.addElement(this.setTab(this.anglePanel, Geonext.language.getString("jcontentedit_tab_object"), "12/angle.gif", "Angle"));
        this.tabbed.addElement(this.setTab(this.arcPanel, Geonext.language.getString("jcontentedit_tab_object"), "12/arc.gif", "Arc"));
        this.tabbed.addElement(this.setTab(this.casPointPanel, Geonext.language.getString("jcontentedit_tab_object"), "12/caspoint.gif", "CASPoint"));
        this.tabbed.addElement(this.setTab(this.intersectionPanel, Geonext.language.getString("jcontentedit_tab_object"), "12/intersection.gif", "Intersection"));
        this.tabbed.addElement(this.setTab(this.linePanel, Geonext.language.getString("jcontentedit_tab_object"), "12/line.gif", "Line"));
        this.tabbed.addElement(this.setTab(this.pointPanel, Geonext.language.getString("jcontentedit_tab_object"), "12/point.gif", "Point"));
        this.tabbed.addElement(this.setTab(this.sliderPanel, Geonext.language.getString("jcontentedit_tab_object"), "12/slider.gif", "Slider;GraphSlider"));
        this.tabbed.addElement(this.setTab(this.textPanel, Geonext.language.getString("jcontentedit_tab_object"), "12/text.gif", "Text"));
        this.tabbed.addElement(this.setTab(this.dashPanel, Geonext.language.getString("jcontentedit_tab_line"), "12/dash.gif", "Line;Circle;Arc;Arrow;Polygon;Graph;ParameterCurve"));
        this.tabbed.addElement(this.setTab(this.imgPanel, "", "12/image.gif", "Line;Circle"));
    }

    public void setTabbed(Vector vector) {
        this.tabbed = vector;
    }

    public void setTabbedPane() {
        int n;
        String string = "";
        try {
            string = this.elementTabbed.getTitleAt(this.elementTabbed.getSelectedIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.elementTabbed.removeAll();
        for (n = 0; n < this.tabbed.size(); ++n) {
            if (!this.isCorrectType((String)((Vector)this.tabbed.get(n)).get(3))) continue;
            this.elementTabbed.addTab((String)((Vector)this.tabbed.get(n)).get(1), (ImageIcon)((Vector)this.tabbed.get(n)).get(2), (JPanel)((Vector)this.tabbed.get(n)).get(0));
        }
        if (this.elementTabbed.indexOfComponent(this.textPanel) > -1 && this.selectedElements.size() > 1) {
            this.elementTabbed.remove(this.textPanel);
        }
        if (this.elementTabbed.indexOfComponent(this.sliderPanel) > -1 && this.selectedElements.size() > 1) {
            this.elementTabbed.remove(this.sliderPanel);
        }
        if (this.elementTabbed.getTabCount() > 0) {
            n = this.elementTabbed.indexOfTab(string);
            if (n < 0) {
                n = 0;
            }
            this.elementTabbed.setSelectedIndex(n);
        } else {
            this.elementTabbed.addTab(Geonext.language.getString("jcontentedit_hint"), null, this.nonePanel);
        }
        this.elementTabbed.updateUI();
    }

    public void setTextFix() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Text)this.selectedElements.get(i)).setFix(this.textFixBox.isSelected());
        }
    }

    public void setDigits() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            Text text = (Text)this.selectedElements.get(i);
            int n = this.textDigits.getSelectedIndex();
            if (n == 0) {
                text.setDigits(2);
                text.setAutoDigits(true);
            } else {
                text.setDigits(n - 1);
                text.setAutoDigits(false);
            }
            text.evaluate(this.board);
        }
    }

    public void setTrace() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setTrace(this.traceBox.isSelected());
        }
    }

    public void setVisible() {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            ((Element)this.selectedElements.get(i)).setVisible(!this.visibleBox.isSelected());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setStrokeWidth();
        this.board.repaint();
    }

    public void tabAngle() {
        this.angleTextViewPanel = new JViewPanel(this.board, "");
        javax.swing.JButton jButton = new javax.swing.JButton(" " + Geonext.language.getString("jcontentedit_apply") + " ");
        jButton.setBorder(new EtchedBorder(1));
        jButton.addActionListener(this);
        jButton.setActionCommand("setAngleLabel");
        javax.swing.JButton jButton2 = new javax.swing.JButton(" " + Geonext.language.getString("jcontentedit_apply") + " ");
        jButton2.setBorder(new EtchedBorder(1));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("setAngleRadius");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.angleTextField = new JTextField("");
        this.angleTextField.addActionListener(this);
        this.angleTextField.setActionCommand("setAngleLabel");
        this.angleUnitField = new JTextField("");
        this.angleUnitField.addActionListener(this);
        this.angleUnitField.setActionCommand("setAngleRadius");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel2.add(this.angleTextField);
        jPanel2.add(this.angleUnitField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 10, 10));
        jPanel3.add(new JLabel(Geonext.language.getString("jcontentedit_angle_label") + " "));
        jPanel3.add(new JLabel(Geonext.language.getString("jcontentedit_angle_radius") + " "));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add("West", jPanel3);
        jPanel4.add("Center", jPanel2);
        jPanel4.add("East", jPanel);
        this.anglePanel = new JPanel();
        this.anglePanel.setLayout(new BorderLayout(0, 0));
        this.anglePanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.anglePanel.add("North", jPanel4);
        this.anglePanel.add("Center", this.angleTextViewPanel);
    }

    public void tabArc() {
        this.fullCircleBox = new JCheckBox(Geonext.language.getString("jcontentedit_arc_full"));
        this.fullCircleBox.addActionListener(this);
        this.fullCircleBox.setActionCommand("setArcFullCircle");
        this.firstArrowBox = new JCheckBox(Geonext.language.getString("jcontentedit_arc_arrow"));
        this.firstArrowBox.addActionListener(this);
        this.firstArrowBox.setActionCommand("setArcFirstArrow");
        this.lastArrowBox = new JCheckBox(Geonext.language.getString("jcontentedit_arc_anit_arrow"));
        this.lastArrowBox.addActionListener(this);
        this.lastArrowBox.setActionCommand("setArcLastArrow");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel.add(this.fullCircleBox);
        jPanel.add(this.firstArrowBox);
        jPanel.add(this.lastArrowBox);
        this.arcPanel = new JPanel();
        this.arcPanel.setLayout(new BorderLayout(10, 10));
        this.arcPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.arcPanel.add("North", jPanel);
        this.arcPanel.add("Center", new JPanel());
    }

    public void tabCASPoint() {
        this.coordinateCASPointBox = new JCheckBox(Geonext.language.getString("jcontentedit_show_coord"));
        this.coordinateCASPointBox.addActionListener(this);
        this.coordinateCASPointBox.setActionCommand("setCASShowCoord");
        this.pointStyleComboBoxes[1] = new JComboBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel.add(this.coordinateCASPointBox);
        jPanel.add(this.addPointStylePanel(this.pointStyleComboBoxes[1]));
        this.casPointPanel = new JPanel();
        this.casPointPanel.setLayout(new BorderLayout(10, 10));
        this.casPointPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.casPointPanel.add("North", jPanel);
    }

    public void tabDash() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("North", new JLabel(Geonext.language.getString("jcontentedit_dash_width")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(30, 30));
        jPanel2.add("North", new JLabel(Geonext.language.getString("jcontentedit_dash_style")));
        jPanel2.add("Center", jPanel);
        Vector<BasicStroke> vector = new Vector<BasicStroke>();
        vector.addElement(new BasicStroke(2.0f));
        int n = 0;
        while (true) {
            if (n >= JBoardPane.dashArray.length) break;
            vector.addElement(new BasicStroke(2.0f, 0, 2, 8.0f, JBoardPane.dashArray[n], 0.0f));
            ++n;
        }
        this.dashBox = new JComboBox(vector);
        this.dashBox.setEditable(false);
        this.dashBox.setRenderer(new JDashListRenderer());
        this.dashBox.setActionCommand("setDash");
        this.dashBox.addActionListener(this);
        this.dashSlider = new JSlider(0, 0, 10, 0);
        this.dashSlider.setMajorTickSpacing(5);
        this.dashSlider.setMinorTickSpacing(1);
        this.dashSlider.setSnapToTicks(true);
        this.dashSlider.setPaintTicks(true);
        this.dashSlider.setPaintLabels(true);
        this.dashSlider.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.dashSlider.addChangeListener(this);
        this.dashSlider.setPreferredSize(new Dimension(10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel3.setBorder(new EtchedBorder(1));
        jPanel3.add(this.dashSlider);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(20, 20));
        jPanel4.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel4.add("North", this.dashBox);
        jPanel4.add("Center", jPanel3);
        this.dashPanel = new JPanel();
        this.dashPanel.setLayout(new BorderLayout(5, 20));
        this.dashPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.dashPanel.add("West", jPanel2);
        this.dashPanel.add("Center", jPanel4);
    }

    public void tabFill() {
        this.fillChooser = new JContentColorChooser(this.board.getBackground(), Color.red, 1, this.board);
        this.fillChooser.setBorder(new EmptyBorder(15, 15, 15, 15));
    }

    public void tabImage() {
        javax.swing.JButton jButton = new javax.swing.JButton(Geonext.language.getString("jcontentbackground_load_image"));
        jButton.addActionListener(this);
        jButton.setActionCommand("setImage");
        javax.swing.JButton jButton2 = new javax.swing.JButton(Geonext.language.getString("jconfigtoolbar_delete"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("setDeleteImage");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 10, 10));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(new JPanel());
        this.imgPanel = new JPanel();
        this.imgPanel.setLayout(new BorderLayout(10, 10));
        this.imgPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.imgPanel.add("North", jPanel);
        this.imgPanel.add("Center", new JPanel());
    }

    public void tabGeneral() {
        this.visibleBox = new JCheckBox(Geonext.language.getString("jcontentedit_object_visible"));
        this.visibleBox.addActionListener(this);
        this.visibleBox.setActionCommand("setVisible");
        this.visibleBox.setMultiple(true);
        this.draftBox = new JCheckBox(Geonext.language.getString("jcontentedit_object_draft"));
        this.draftBox.addActionListener(this);
        this.draftBox.setActionCommand("setDraft");
        this.traceBox = new JCheckBox(Geonext.language.getString("jcontentedit_object_trace"));
        this.traceBox.addActionListener(this);
        this.traceBox.setActionCommand("setTrace");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 10, 10));
        jPanel.add(this.visibleBox);
        jPanel.add(this.traceBox);
        jPanel.add(this.draftBox);
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new BorderLayout(10, 10));
        this.generalPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.generalPanel.add("North", jPanel);
        this.generalPanel.add("Center", new JPanel());
    }

    public void tabIntersection() {
        this.intersectionBox = new JCheckBox(Geonext.language.getString("jcontentedit_intersection_show"));
        this.intersectionBox.addActionListener(this);
        this.intersectionBox.setActionCommand("setIntersection");
        this.coordinateIntersectionBox = new JCheckBox(Geonext.language.getString("jcontentedit_show_coord"));
        this.coordinateIntersectionBox.addActionListener(this);
        this.coordinateIntersectionBox.setActionCommand("setIntersectionShowCoord");
        this.pointStyleComboBoxes[2] = new JComboBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2, 10, 10));
        jPanel.add(this.coordinateIntersectionBox);
        jPanel.add(this.addPointStylePanel(this.pointStyleComboBoxes[2]));
        jPanel.add(this.intersectionBox);
        this.intersectionPanel = new JPanel();
        this.intersectionPanel.setLayout(new BorderLayout(10, 10));
        this.intersectionPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.intersectionPanel.add("North", jPanel);
        this.intersectionPanel.add("Center", new JPanel());
    }

    public void tabLabel() {
        this.labelChooser = new JContentColorChooser(this.board.getBackground(), Color.red, 2, this.board);
        this.labelChooser.setBorder(new EmptyBorder(15, 15, 15, 15));
    }

    public void tabLine() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 0, 0));
        jPanel.setBorder(new EtchedBorder(1));
        javax.swing.JButton jButton = new javax.swing.JButton(""){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (JContentEdit.this.firstMode) {
                    graphics.setColor(Color.blue);
                } else {
                    graphics.setColor(new Color(176, 176, 212));
                }
                graphics.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                Point point = new Point();
                point.setScreen(this.getWidth(), this.getHeight() / 2);
                point.setStroke(Color.darkGray);
                point.draw((Graphics2D)graphics, JContentEdit.this.board);
            }
        };
        jButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton.setActionCommand("setFirstMode");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        javax.swing.JButton jButton2 = new javax.swing.JButton(""){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setColor(Color.blue);
                graphics.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                Point point = new Point();
                point.setScreen(this.getWidth(), this.getHeight() / 2);
                point.setStroke(Color.darkGray);
                point.draw((Graphics2D)graphics, JContentEdit.this.board);
                point.setScreen(0.0, this.getHeight() / 2);
                point.draw((Graphics2D)graphics, JContentEdit.this.board);
            }
        };
        jButton2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton2.setActionCommand("setLineMode");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        javax.swing.JButton jButton3 = new javax.swing.JButton(""){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (JContentEdit.this.lastMode) {
                    graphics.setColor(Color.blue);
                } else {
                    graphics.setColor(new Color(176, 176, 212));
                }
                graphics.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                Point point = new Point();
                point.setScreen(0.0, this.getHeight() / 2);
                point.setStroke(Color.darkGray);
                point.draw((Graphics2D)graphics, JContentEdit.this.board);
            }
        };
        jButton3.setBorder(new EmptyBorder(0, 0, 0, 0));
        jButton3.setActionCommand("setLastMode");
        jButton3.addActionListener(this);
        jPanel.add(jButton3);
        JPanel jPanel2 = new JPanel();
        javax.swing.JButton jButton4 = new javax.swing.JButton(Geonext.language.getString("MODE_LINE_SEGMENT"));
        jButton4.addActionListener(this);
        jButton4.setActionCommand("setLineLine");
        javax.swing.JButton jButton5 = new javax.swing.JButton(Geonext.language.getString("MODE_LINE_RAY"));
        jButton5.addActionListener(this);
        jButton5.setActionCommand("setLineFirstLast");
        javax.swing.JButton jButton6 = new javax.swing.JButton(Geonext.language.getString("MODE_LINE_STRAIGHT"));
        jButton6.addActionListener(this);
        jButton6.setActionCommand("setLineStraight");
        jPanel2.setLayout(new GridLayout(1, 4, 5, 5));
        jPanel2.add(jButton4);
        jPanel2.add(jButton5);
        jPanel2.add(jButton6);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.add("North", jPanel2);
        jPanel3.add("Center", jPanel);
        this.linePanel = new JPanel();
        this.linePanel.setLayout(new BorderLayout(10, 10));
        this.linePanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.linePanel.add("Center", jPanel3);
    }

    public void tabNone() {
        this.nonePanel = new JPanel();
        this.nonePanel.setLayout(new GridLayout(5, 1, 10, 10));
        this.nonePanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.nonePanel.add(new JLabel(Geonext.language.getString("jcontentedit_no_object")));
    }

    public void loadImg() {
        block4: {
            this.pointImage = null;
            try {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setCurrentDirectory(new File(this.board.geonext.lastPath));
                jFileChooser.addChoosableFileFilter(new GeonetFileFilter("png", "PNG"));
                jFileChooser.addChoosableFileFilter(new GeonetFileFilter("jpg", "JPG"));
                jFileChooser.addChoosableFileFilter(new GeonetFileFilter("gif", "GIF"));
                int n = jFileChooser.showDialog(this, Geonext.language.getString("common_open"));
                if (n != 0) break block4;
                Image image = this.board.getToolkit().createImage(jFileChooser.getSelectedFile().getPath());
                MediaTracker mediaTracker = new MediaTracker(this.board);
                mediaTracker.addImage(image, 1);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pointImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D graphics2D = this.pointImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadImgButton() {
        this.loadImg();
        if (this.pointImage != null) {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                Point point = (Point)this.selectedElements.get(i);
                point.setImage(this.pointImage);
                point.setImageName("intern");
                point.setStyle(-1);
                point.draw((Graphics2D)this.board.jep.getGraphics(), this.board);
            }
            this.pointStyleCombo.setSelectedIndex(0);
        }
    }

    public void loadImgList() {
        this.loadImg();
        if (this.pointImage != null) {
            for (int i = 0; i < this.selectedElements.size(); ++i) {
                Point point = (Point)this.selectedElements.get(i);
                point.setImage(this.pointImage);
                point.setImageName("intern");
                point.setStyle(-1);
                point.draw((Graphics2D)this.board.jep.getGraphics(), this.board);
            }
            this.pointStyleCombo.setSelectedIndex(0);
        }
    }

    public void tabPoint() {
        this.coordinatePointBox = new JCheckBox(Geonext.language.getString("jcontentedit_show_coord"));
        this.coordinatePointBox.addActionListener(this);
        this.coordinatePointBox.setActionCommand("setPointShowCoord");
        this.fixBox = new JCheckBox(Geonext.language.getString("jcontentedit_point_fix"));
        this.fixBox.addActionListener(this);
        this.fixBox.setActionCommand("setFix");
        this.pointStyleComboBoxes[0] = new JComboBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel.add(new JLabel("x ="));
        jPanel.add(new JLabel("y ="));
        this.pointPosXField = new JTextField(8);
        this.pointPosXField.addActionListener(this);
        this.pointPosXField.setActionCommand("setCoord");
        this.pointPosYField = new JTextField(8);
        this.pointPosYField.addActionListener(this);
        this.pointPosYField.setActionCommand("setCoord");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel2.add(this.pointPosXField);
        jPanel2.add(this.pointPosYField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        javax.swing.JButton jButton = new javax.swing.JButton(Geonext.language.getString("jcontentedit_apply"));
        jButton.addActionListener(this);
        jButton.setActionCommand("setCoord");
        this.posPanel = new JPanel();
        this.posPanel.setLayout(new BorderLayout(10, 10));
        this.posPanel.add("Center", jPanel3);
        this.posPanel.add("East", jButton);
        this.boxPanel = new JPanel();
        this.boxPanel.setLayout(new GridLayout(2, 2, 10, 10));
        this.boxPanel.add(this.coordinatePointBox);
        this.boxPanel.add(this.addPointStylePanel(this.pointStyleComboBoxes[0]));
        this.boxPanel.add(this.fixBox);
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new BorderLayout(5, 5));
        this.optionPanel.add("North", this.boxPanel);
        this.optionPanel.add("South", this.posPanel);
        this.pointPanel = new JPanel();
        this.pointPanel.setLayout(new BorderLayout(0, 0));
        this.pointPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.pointPanel.add("North", this.optionPanel);
    }

    public void tabSlider() {
        this.freeSliderBox = new JCheckBox(Geonext.language.getString("jcontentedit_slider_free"));
        this.freeSliderBox.addActionListener(this);
        this.freeSliderBox.setActionCommand("setFree");
        this.coordinateSliderBox = new JCheckBox(Geonext.language.getString("jcontentedit_show_coord"));
        this.coordinateSliderBox.addActionListener(this);
        this.coordinateSliderBox.setActionCommand("setSliderShowCoord");
        this.animatedSliderBox = new JCheckBox(Geonext.language.getString("jcontentedit_slider_animate"));
        this.animatedSliderBox.addActionListener(this);
        this.animatedSliderBox.setActionCommand("setSliderAnimated");
        this.directionSliderBox = new JCheckBox(Geonext.language.getString("jcontentedit_slider_direction"));
        this.directionSliderBox.addActionListener(this);
        this.directionSliderBox.setActionCommand("setSliderDirection");
        this.onPolygonSliderBox = new JCheckBox(Geonext.language.getString("jcontentedit_slider_onpolygon"));
        this.onPolygonSliderBox.addActionListener(this);
        this.onPolygonSliderBox.setActionCommand("setSliderOnPolygon");
        this.stepField = new JTextField();
        this.stepField.addActionListener(this);
        this.stepField.setActionCommand("setStep");
        this.stepButton = new javax.swing.JButton(" " + Geonext.language.getString("jcontentedit_apply") + " ");
        this.stepButton.setBorder(new EtchedBorder(1));
        this.stepButton.addActionListener(this);
        this.stepButton.setActionCommand("setStep");
        this.stepLabel = new JLabel("");
        this.stepPanel = new JPanel();
        this.stepPanel.setLayout(new BorderLayout(10, 10));
        this.stepPanel.add("West", this.stepLabel);
        this.stepPanel.add("Center", this.stepField);
        this.stepPanel.add("East", this.stepButton);
        this.pointStyleComboBoxes[3] = new JComboBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2, 0, 0));
        jPanel.add(this.coordinateSliderBox);
        jPanel.add(this.animatedSliderBox);
        jPanel.add(this.freeSliderBox);
        jPanel.add(this.directionSliderBox);
        jPanel.add(this.onPolygonSliderBox);
        jPanel.add(this.addPointStylePanel(this.pointStyleComboBoxes[3]));
        this.sliderPanel = new JPanel();
        this.sliderPanel.setLayout(new BorderLayout(10, 10));
        this.sliderPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.sliderPanel.add("North", jPanel);
        this.sliderPanel.add("South", this.stepPanel);
        this.sliderPanel.add("Center", new JPanel());
    }

    public void tabStroke() {
        this.strokeChooser = new JContentColorChooser(this.board.getBackground(), Color.red, 0, this.board);
        this.strokeChooser.setBorder(new EmptyBorder(15, 15, 15, 15));
    }

    public void tabText() {
        this.textFixBox = new JCheckBox(Geonext.language.getString("jcontentedit_text_fix"));
        this.textFixBox.addActionListener(this);
        this.textFixBox.setActionCommand("setTextFix");
        javax.swing.JButton jButton = new javax.swing.JButton(Geonext.language.getString("jcontentedit_text_edit"));
        jButton.addActionListener(this);
        jButton.setActionCommand("editText");
        String[] stringArray = new String[]{Geonext.language.getString("jcontentedit_text_digits_auto"), Geonext.language.getString("jcontentedit_text_digits_0"), Geonext.language.getString("jcontentedit_text_digits_1"), Geonext.language.getString("jcontentedit_text_digits_2"), Geonext.language.getString("jcontentedit_text_digits_3"), Geonext.language.getString("jcontentedit_text_digits_4"), Geonext.language.getString("jcontentedit_text_digits_5")};
        this.textDigits = new JComboBox<String>(stringArray);
        this.textDigits.setActionCommand("setDigits");
        this.textDigits.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("West", new JLabel(Geonext.language.getString("jcontentedit_text_digits_label")));
        jPanel.add("Center", this.textDigits);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(15, 15));
        jPanel2.add("North", jButton);
        jPanel2.add("Center", jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(15, 15));
        jPanel3.add("North", this.textFixBox);
        jPanel3.add("Center", jPanel2);
        this.textViewPanel = new JViewPanel(this.board, "");
        this.textViewPanel.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentedit_text_preview") + " "));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(10, 10));
        javax.swing.JButton jButton2 = new javax.swing.JButton(" " + Geonext.language.getString("jcontentedit_apply") + " ");
        jButton2.setBorder(new EtchedBorder(1));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("setJSFunction");
        this.textJSField = new JTextField();
        this.textJSField.addActionListener(this);
        this.textJSField.setActionCommand("setJSFunction");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add("West", new JLabel(Geonext.language.getString("jcontentedit_text_javascript")));
        jPanel5.add("Center", this.textJSField);
        jPanel5.add("East", jButton2);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BorderLayout(10, 10));
        this.textPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.textPanel.add("West", jPanel3);
        this.textPanel.add("Center", this.textViewPanel);
        this.textPanel.add("South", jPanel5);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = ((JList)listSelectionEvent.getSource()).getSelectedIndices();
        this.selectedElements = new Vector();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.selectedElements.addElement(this.elements.get(nArray[i]));
            }
            this.validateTree();
        }
        this.objectList.repaint();
        this.setProperties();
    }
}

