/*
 * Decompiled with CFR 0.152.
 */
package gifwriter;

import gifwriter.GIFEncoderHashitem;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class GIFWriter
implements ImageObserver {
    private Image img;
    private int width;
    private int height;
    private boolean loadingdata;
    private boolean loadingstarted;
    private IOException iox;
    private Hashtable colorHash;
    private int defaultcolorkey;
    private int[] rgbPixels;
    private boolean gotwidthheight;
    private boolean gotcolormap;
    private boolean gotdata;
    int curx;
    int cury;
    int CountDown;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public void setImage(Image image) {
        this.img = image;
        this.gotdata = false;
        this.gotcolormap = false;
        this.gotwidthheight = false;
        this.height = image.getHeight(this);
        this.width = image.getWidth(this);
        if (this.height != -1 && this.width != -1) {
            this.gotwidthheight = true;
        }
    }

    public synchronized int getWidth() throws IOException {
        while (!this.gotwidthheight) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
        return this.width;
    }

    public synchronized int getHeight() throws IOException {
        while (!this.gotwidthheight) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
        return this.height;
    }

    public void writeGIF(OutputStream outputStream) throws IOException {
        if (!this.gotdata) {
            this.loadData();
        }
        this.writeHeader(outputStream);
        this.writeBody(outputStream);
        GIFWriter.writeTrailer(outputStream);
    }

    public synchronized void loadData() throws IOException {
        this.gotdata = false;
        if (!this.gotwidthheight) {
            this.getWidth();
        }
        this.rgbPixels = null;
        this.rgbPixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, 0, 0, this.width, this.height, this.rgbPixels, 0, this.width);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new IOException("grabPixels() unsuccessful");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("grabPixels() interrupted");
        }
        this.gotdata = true;
        this.img.getSource().removeConsumer(pixelGrabber);
    }

    public void flushPixels() throws IOException {
        this.rgbPixels = null;
        this.gotdata = false;
        this.img.flush();
    }

    public void doColorMap() throws IOException {
        if (!this.gotdata) {
            throw new IOException("Don't have image data");
        }
        if (this.colorHash == null) {
            this.colorHash = new Hashtable();
        }
        int n = this.colorHash.size();
        for (int i = 0; i < this.height; ++i) {
            int n2 = i * this.width;
            for (int j = 0; j < this.width; ++j) {
                int n3 = this.rgbPixels[n2 + j] & 0xFFFFFF;
                GIFEncoderHashitem gIFEncoderHashitem = (GIFEncoderHashitem)this.colorHash.get(n3);
                if (gIFEncoderHashitem == null) {
                    if (n >= 256) continue;
                    gIFEncoderHashitem = new GIFEncoderHashitem(n3, null, 1, n);
                    ++n;
                    this.colorHash.put(n3, gIFEncoderHashitem);
                    continue;
                }
                ++gIFEncoderHashitem.count;
            }
        }
        this.gotcolormap = true;
    }

    public Hashtable getColorMap() {
        return this.colorHash;
    }

    public void setColorMap(Hashtable hashtable, int n) {
        this.colorHash = hashtable;
        this.defaultcolorkey = n;
        this.gotcolormap = hashtable != null;
    }

    public void writeHeader(OutputStream outputStream) throws IOException {
        GIFWriter.writeHeader(this.colorHash, this.width, this.height, outputStream);
    }

    public static void writeHeader(Hashtable hashtable, int n, int n2, OutputStream outputStream) throws IOException {
        int n3 = hashtable.size();
        int n4 = n3 <= 2 ? 1 : (n3 <= 4 ? 2 : (n3 <= 16 ? 4 : 8));
        int n5 = 1 << n4;
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            GIFEncoderHashitem gIFEncoderHashitem = (GIFEncoderHashitem)enumeration.nextElement();
            byArray[gIFEncoderHashitem.index] = (byte)(gIFEncoderHashitem.rgb >> 16 & 0xFF);
            byArray2[gIFEncoderHashitem.index] = (byte)(gIFEncoderHashitem.rgb >> 8 & 0xFF);
            byArray3[gIFEncoderHashitem.index] = (byte)(gIFEncoderHashitem.rgb & 0xFF);
        }
        GIFWriter.Putbyte((byte)71, outputStream);
        GIFWriter.Putbyte((byte)73, outputStream);
        GIFWriter.Putbyte((byte)70, outputStream);
        GIFWriter.Putbyte((byte)56, outputStream);
        GIFWriter.Putbyte((byte)57, outputStream);
        GIFWriter.Putbyte((byte)97, outputStream);
        GIFWriter.Putword(n, outputStream);
        GIFWriter.Putword(n2, outputStream);
        byte by = -128;
        by = (byte)(by | 0x70);
        by = (byte)(by | (byte)(n4 - 1));
        GIFWriter.Putbyte(by, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
        for (int i = 0; i < n5; ++i) {
            GIFWriter.Putbyte(byArray[i], outputStream);
            GIFWriter.Putbyte(byArray2[i], outputStream);
            GIFWriter.Putbyte(byArray3[i], outputStream);
        }
    }

    public void writeBody(OutputStream outputStream) throws IOException {
        if (!this.gotdata) {
            throw new IOException("Don't have image data");
        }
        if (!this.gotcolormap) {
            throw new IOException("Don't have a colormap");
        }
        int n = this.colorHash.size();
        int n2 = n <= 2 ? 1 : (n <= 4 ? 2 : (n <= 16 ? 4 : 8));
        if (!this.gotwidthheight) {
            this.getWidth();
        }
        this.CountDown = this.width * this.height;
        int n3 = n2 <= 1 ? 2 : n2;
        GIFWriter.Putbyte((byte)44, outputStream);
        GIFWriter.Putword(0, outputStream);
        GIFWriter.Putword(0, outputStream);
        GIFWriter.Putword(this.width, outputStream);
        GIFWriter.Putword(this.height, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
        GIFWriter.Putbyte((byte)n3, outputStream);
        this.curx = 0;
        this.cury = 0;
        this.compress(n3 + 1, outputStream);
        GIFWriter.Putbyte((byte)0, outputStream);
    }

    public static void writeTrailer(OutputStream outputStream) throws IOException {
        GIFWriter.Putbyte((byte)59, outputStream);
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        if ((n & 0x80) != 0) {
            this.iox = new IOException("Image aborted");
            this.gotwidthheight = true;
            return false;
        }
        if ((n & 1) != 0) {
            this.width = n4;
        } else {
            bl = true;
        }
        if ((n & 2) != 0) {
            this.height = n5;
        } else {
            bl = true;
        }
        boolean bl2 = this.gotwidthheight = !bl;
        if (this.gotwidthheight) {
            this.notifyAll();
        }
        return bl;
    }

    byte GetPixel(int n, int n2) throws IOException {
        GIFEncoderHashitem gIFEncoderHashitem = (GIFEncoderHashitem)this.colorHash.get(this.rgbPixels[n2 * this.width + n] & 0xFFFFFF);
        if (gIFEncoderHashitem == null) {
            gIFEncoderHashitem = (GIFEncoderHashitem)this.colorHash.get(this.defaultcolorkey);
        }
        return (byte)gIFEncoderHashitem.index;
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        if (++this.curx == this.width) {
            this.curx = 0;
            ++this.cury;
        }
        return by & 0xFF;
    }

    public static void Putword(int n, OutputStream outputStream) throws IOException {
        GIFWriter.Putbyte((byte)(n & 0xFF), outputStream);
        GIFWriter.Putbyte((byte)(n >> 8 & 0xFF), outputStream);
    }

    public static void Putbyte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        int n3;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n4 = this.GIFNextPixel();
        int n5 = 0;
        for (n3 = this.hsize; n3 < 65536; n3 *= 2) {
            ++n5;
        }
        n5 = 8 - n5;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.GIFNextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outputStream);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n4, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

