/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.core.VersionSpecific;
import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.Renderer;
import jugglinglab.renderer.Renderer2D;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JLMath;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class Animator
extends JPanel
implements Runnable {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    protected Thread engine;
    protected boolean engineStarted = false;
    protected boolean enginePaused = false;
    protected boolean engineRunning = false;
    public boolean writingGIF = false;
    public JuggleException exception;
    public String message;
    protected JMLPattern pat;
    protected AnimatorPrefs jc;
    protected Renderer ren1 = null;
    protected Renderer ren2 = null;
    protected Coordinate overallmax = null;
    protected Coordinate overallmin = null;
    protected int[] animpropnum = null;
    protected int[] temppropnum = null;
    protected Permutation invpathperm = null;
    protected int num_frames;
    protected double sim_time;
    protected double sim_interval_secs;
    protected long real_interval_millis;
    protected static AudioClip catchclip = null;
    protected static AudioClip bounceclip = null;
    protected boolean waspaused;
    protected boolean outside;
    protected boolean outside_valid;
    protected boolean cameradrag = false;
    protected int startx;
    protected int starty;
    protected int lastx;
    protected int lasty;
    protected double[] camangle;
    protected double[] actualcamangle;
    protected double[] actualcamangle1;
    protected double[] actualcamangle2;
    protected static final double snapangle = JLMath.toRad(15.0);
    protected Dimension prefsize;

    public Animator() {
        this.initHandlers();
        this.camangle = new double[2];
        this.camangle[0] = JLMath.toRad(0.0);
        this.camangle[1] = JLMath.toRad(90.0);
        this.actualcamangle1 = new double[2];
        this.actualcamangle2 = new double[2];
        this.jc = new AnimatorPrefs();
        this.outside = true;
        this.outside_valid = false;
        this.waspaused = false;
        this.setOpaque(true);
    }

    public void setJAPreferredSize(Dimension dimension) {
        this.prefsize = dimension;
    }

    public Dimension getPreferredSize() {
        if (this.prefsize != null) {
            return new Dimension(this.prefsize);
        }
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public static void setAudioClips(AudioClip[] audioClipArray) {
        catchclip = audioClipArray[0];
        bounceclip = audioClipArray[1];
    }

    protected void initHandlers() {
        this.addMouseListener(new MouseAdapter(){
            long lastpress = 0L;
            long lastenter = 1L;

            public void mousePressed(MouseEvent mouseEvent) {
                this.lastpress = mouseEvent.getWhen();
                if (Animator.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (Animator.this.exception != null) {
                    return;
                }
                if (!Animator.this.engineStarted) {
                    return;
                }
                Animator.this.startx = mouseEvent.getX();
                Animator.this.starty = mouseEvent.getY();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Animator.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (Animator.this.exception != null) {
                    return;
                }
                Animator.this.cameradrag = false;
                if (!Animator.this.engineStarted && Animator.this.engine != null && Animator.this.engine.isAlive()) {
                    Animator.this.setPaused(!Animator.this.enginePaused);
                    return;
                }
                if (mouseEvent.getX() == Animator.this.startx && mouseEvent.getY() == Animator.this.starty && Animator.this.engine != null && Animator.this.engine.isAlive()) {
                    Animator.this.setPaused(!Animator.this.enginePaused);
                }
                if (Animator.this.getPaused()) {
                    Animator.this.repaint();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                this.lastenter = mouseEvent.getWhen();
                if (Animator.this.jc.mousePause) {
                    Animator.this.setPaused(Animator.this.waspaused);
                }
                Animator.this.outside = false;
                Animator.this.outside_valid = true;
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (Animator.this.jc.mousePause) {
                    Animator.this.waspaused = Animator.this.getPaused();
                    Animator.this.setPaused(true);
                }
                Animator.this.outside = true;
                Animator.this.outside_valid = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Animator.this.exception != null) {
                    return;
                }
                if (!Animator.this.engineStarted) {
                    return;
                }
                if (!Animator.this.cameradrag) {
                    Animator.this.cameradrag = true;
                    Animator.this.lastx = Animator.this.startx;
                    Animator.this.lasty = Animator.this.starty;
                    Animator.this.camangle = Animator.this.ren1.getCameraAngle();
                }
                int n = mouseEvent.getX() - Animator.this.lastx;
                int n2 = mouseEvent.getY() - Animator.this.lasty;
                Animator.this.lastx = mouseEvent.getX();
                Animator.this.lasty = mouseEvent.getY();
                double[] dArray = Animator.this.camangle;
                dArray[0] = dArray[0] + (double)n * 0.02;
                dArray[1] = dArray[1] - (double)n2 * 0.02;
                if (dArray[1] < 1.0E-6) {
                    dArray[1] = 1.0E-6;
                }
                if (dArray[1] > JLMath.toRad(90.0)) {
                    dArray[1] = JLMath.toRad(90.0);
                }
                while (dArray[0] < 0.0) {
                    dArray[0] = dArray[0] + JLMath.toRad(360.0);
                }
                while (dArray[0] >= JLMath.toRad(360.0)) {
                    dArray[0] = dArray[0] - JLMath.toRad(360.0);
                }
                Animator.this.setCameraAngle(dArray);
                if (Animator.this.getPaused()) {
                    Animator.this.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Animator.this.exception != null) {
                    return;
                }
                if (!Animator.this.engineStarted) {
                    return;
                }
                Animator.this.syncRenderer();
                Animator.this.repaint();
            }
        });
    }

    protected double[] snapCamera(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[1]};
        if (dArray2[1] < snapangle) {
            dArray2[1] = 1.0E-6;
        }
        if (dArray2[1] > JLMath.toRad(90.0) - snapangle) {
            dArray2[1] = JLMath.toRad(90.0);
        }
        return dArray2;
    }

    protected void setCameraAngle(double[] dArray) {
        this.actualcamangle = this.snapCamera(dArray);
        while (this.actualcamangle[0] < 0.0) {
            this.actualcamangle[0] = this.actualcamangle[0] + JLMath.toRad(360.0);
        }
        while (this.actualcamangle[0] >= JLMath.toRad(360.0)) {
            this.actualcamangle[0] = this.actualcamangle[0] - JLMath.toRad(360.0);
        }
        if (this.jc.stereo) {
            this.actualcamangle1[0] = this.actualcamangle[0] - 0.05;
            this.actualcamangle1[1] = this.actualcamangle[1];
            this.ren1.setCameraAngle(this.actualcamangle1);
            this.actualcamangle2[0] = this.actualcamangle[0] + 0.05;
            this.actualcamangle2[1] = this.actualcamangle[1];
            this.ren2.setCameraAngle(this.actualcamangle2);
        } else {
            this.ren1.setCameraAngle(this.actualcamangle);
        }
    }

    public void restartJuggle(JMLPattern jMLPattern, AnimatorPrefs animatorPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (jMLPattern != null && !jMLPattern.isLaidout()) {
            jMLPattern.layoutPattern();
        }
        this.killAnimationThread();
        if (jMLPattern != null) {
            this.pat = jMLPattern;
        }
        if (animatorPrefs != null) {
            this.jc = animatorPrefs;
        }
        if (this.pat == null) {
            return;
        }
        this.ren1 = new Renderer2D();
        if (this.jc.stereo) {
            this.ren2 = new Renderer2D();
        }
        this.ren1.setPattern(this.pat);
        if (this.jc.stereo) {
            this.ren2.setPattern(this.pat);
        }
        if (this.pat.getNumberOfJugglers() == 1) {
            this.camangle[0] = JLMath.toRad(0.0);
            this.camangle[1] = JLMath.toRad(90.0);
        } else {
            this.camangle[0] = JLMath.toRad(340.0);
            this.camangle[1] = JLMath.toRad(70.0);
        }
        this.setCameraAngle(this.camangle);
        this.setBackground(this.ren1.getBackground());
        this.syncToPattern();
        this.engine = new Thread(this);
        this.engine.start();
    }

    public void restartJuggle() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.restartJuggle(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        this.engineStarted = false;
        if (this.jc.mousePause) {
            this.waspaused = this.jc.startPause;
        }
        try {
            this.engineRunning = true;
            if (this.jc.startPause) {
                this.message = guistrings.getString("Message_click_to_start");
                this.repaint();
                this.enginePaused = true;
                while (this.enginePaused && this.engineRunning) {
                    Animator animator = this;
                    synchronized (animator) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.message = null;
            long l = System.currentTimeMillis();
            if (this.jc.mousePause) {
                if (this.outside_valid) {
                    this.setPaused(this.outside);
                } else {
                    this.setPaused(true);
                }
                this.waspaused = false;
            }
            while (this.engineRunning) {
                this.setTime(this.pat.getLoopStartTime());
                this.engineStarted = true;
                int n = 0;
                while (this.engineRunning && this.getTime() < this.pat.getLoopEndTime() - 0.5 * this.sim_interval_secs) {
                    this.repaint();
                    try {
                        long l2 = this.real_interval_millis - (System.currentTimeMillis() - l);
                        if (l2 > 0L) {
                            Thread.sleep(l2);
                        }
                        l = System.currentTimeMillis();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new JuggleExceptionInternal("Animator was interrupted");
                    }
                    while (this.enginePaused && this.engineRunning) {
                        Animator animator = this;
                        synchronized (animator) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    double d = this.getTime();
                    this.setTime(this.getTime() + this.sim_interval_secs);
                    double d2 = this.getTime();
                    if (this.jc.catchSound && catchclip != null) {
                        for (int i = 1; i <= this.pat.getNumberOfPaths(); ++i) {
                            if (!(this.pat.getPathCatchVolume(i, d, d2) > 0.0)) continue;
                            catchclip.play();
                        }
                    }
                    if (this.jc.bounceSound && bounceclip != null) {
                        for (int i = 1; i <= this.pat.getNumberOfPaths(); ++i) {
                            if (!(this.pat.getPathBounceVolume(i, d, d2) > 0.0)) continue;
                            bounceclip.play();
                        }
                    }
                    ++n;
                }
                this.advanceProps(this.animpropnum);
            }
        }
        catch (JuggleException juggleException) {
            this.exception = juggleException;
            this.repaint();
        }
        finally {
            this.enginePaused = false;
            this.engineRunning = false;
            this.engineStarted = false;
            this.engine = null;
        }
        Animator animator = this;
        synchronized (animator) {
            this.notify();
        }
    }

    protected synchronized void killAnimationThread() {
        while (this.engine != null && this.engine.isAlive()) {
            this.setPaused(false);
            this.engineRunning = false;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.engine = null;
        this.engineStarted = false;
        this.enginePaused = false;
        this.engineRunning = false;
        this.exception = null;
        this.message = null;
    }

    public boolean getPaused() {
        return this.enginePaused;
    }

    public synchronized void setPaused(boolean bl) {
        if (this.enginePaused && !bl) {
            this.notify();
        }
        this.enginePaused = bl;
    }

    public double getTime() {
        return this.sim_time;
    }

    public void setTime(double d) {
        this.sim_time = d;
    }

    public void paintComponent(Graphics graphics) {
        if (this.exception != null) {
            this.drawString(this.exception.getMessage(), graphics);
        } else if (this.message != null) {
            this.drawString(this.message, graphics);
        } else if (this.engineRunning && !this.writingGIF) {
            try {
                this.drawFrame(this.getTime(), this.animpropnum, graphics);
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                this.killAnimationThread();
                System.out.println(juggleExceptionInternal.getMessage());
                System.exit(0);
            }
        }
    }

    protected void drawFrame(double d, int[] nArray, Graphics graphics) throws JuggleExceptionInternal {
        Object object;
        if (this.jc.stereo) {
            object = this.getSize();
            this.ren1.drawFrame(d, nArray, graphics.create(0, 0, ((Dimension)object).width / 2, ((Dimension)object).height), this);
            this.ren2.drawFrame(d, nArray, graphics.create(((Dimension)object).width / 2, 0, ((Dimension)object).width / 2, ((Dimension)object).height), this);
        } else {
            this.ren1.drawFrame(d, nArray, graphics, this);
        }
        if (!this.cameradrag) {
            return;
        }
        VersionSpecific.getVersionSpecific().setAntialias(graphics);
        object = this.ren1.getCameraAngle();
        Object object2 = object[0];
        Object object3 = object[1];
        double d2 = 30.0;
        double d3 = d2 * Math.sin(1.5707963267460001 - object3);
        double d4 = d2 * Math.cos(1.5707963267460001 - object3);
        int n = 38;
        int n2 = 45;
        int n3 = n + (int)(0.5 - d2 * Math.cos((double)object2));
        int n4 = n2 + (int)(0.5 + d3 * Math.sin((double)object2));
        int n5 = n + (int)(0.5 - d2 * Math.cos((double)(object2 + 1.5707963267460001)));
        int n6 = n2 + (int)(0.5 + d3 * Math.sin((double)(object2 + 1.5707963267460001)));
        int n7 = n;
        int n8 = n2 - (int)(0.5 + d4);
        graphics.setColor(Color.green);
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n, n2, n5, n6);
        graphics.drawLine(n, n2, n7, n8);
        graphics.fillOval(n3 - 2, n4 - 2, 5, 5);
        graphics.fillOval(n5 - 2, n6 - 2, 5, 5);
        graphics.fillOval(n7 - 2, n8 - 2, 5, 5);
        graphics.drawString("x", n3 - 2, n4 - 4);
        graphics.drawString("y", n5 - 2, n6 - 4);
        graphics.drawString("z", n7 - 2, n8 - 4);
        if (this.jc.stereo) {
            object = this.ren2.getCameraAngle();
            object2 = object[0];
            object3 = object[1];
            d2 = 30.0;
            d3 = d2 * Math.sin(1.5707963267460001 - object3);
            d4 = d2 * Math.cos(1.5707963267460001 - object3);
            n = 38 + this.getSize().width / 2;
            n2 = 45;
            n3 = n + (int)(0.5 - d2 * Math.cos((double)object2));
            n4 = n2 + (int)(0.5 + d3 * Math.sin((double)object2));
            n5 = n + (int)(0.5 - d2 * Math.cos((double)(object2 + 1.5707963267460001)));
            n6 = n2 + (int)(0.5 + d3 * Math.sin((double)(object2 + 1.5707963267460001)));
            n7 = n;
            n8 = n2 - (int)(0.5 + d4);
            graphics.setColor(Color.green);
            graphics.drawLine(n, n2, n3, n4);
            graphics.drawLine(n, n2, n5, n6);
            graphics.drawLine(n, n2, n7, n8);
            graphics.fillOval(n3 - 2, n4 - 2, 5, 5);
            graphics.fillOval(n5 - 2, n6 - 2, 5, 5);
            graphics.fillOval(n7 - 2, n8 - 2, 5, 5);
            graphics.drawString("x", n3 - 2, n4 - 4);
            graphics.drawString("y", n5 - 2, n6 - 4);
            graphics.drawString("z", n7 - 2, n8 - 4);
        }
    }

    protected void drawString(String string, Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = n > n3 ? (n - n3) / 2 : 0;
        int n5 = (n2 + fontMetrics.getHeight()) / 2;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.black);
        graphics.drawString(string, n4, n5);
    }

    protected void advanceProps(int[] nArray) {
        int n;
        for (n = 0; n < this.pat.getNumberOfPaths(); ++n) {
            this.temppropnum[this.invpathperm.getMapping((int)(n + 1)) - 1] = nArray[n];
        }
        for (n = 0; n < this.pat.getNumberOfPaths(); ++n) {
            nArray[n] = this.temppropnum[n];
        }
    }

    public void syncToPattern() {
        this.findMaxMin();
        this.syncRenderer();
        this.num_frames = (int)(0.5 + (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) * this.jc.slowdown * this.jc.fps);
        this.sim_interval_secs = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)this.num_frames;
        this.real_interval_millis = (long)(1000.0 * this.sim_interval_secs * this.jc.slowdown);
        this.animpropnum = new int[this.pat.getNumberOfPaths()];
        for (int i = 1; i <= this.pat.getNumberOfPaths(); ++i) {
            this.animpropnum[i - 1] = this.pat.getPropAssignment(i);
        }
        this.temppropnum = new int[this.pat.getNumberOfPaths()];
        this.invpathperm = this.pat.getPathPermutation().getInverse();
    }

    protected void findMaxMin() {
        double d;
        int n;
        Coordinate coordinate = null;
        Coordinate coordinate2 = null;
        Coordinate coordinate3 = null;
        Coordinate coordinate4 = null;
        Coordinate coordinate5 = null;
        Coordinate coordinate6 = null;
        for (n = 1; n <= this.pat.getNumberOfPaths(); ++n) {
            coordinate = Coordinate.max(coordinate, this.pat.getPathMax(n));
            coordinate2 = Coordinate.min(coordinate2, this.pat.getPathMin(n));
        }
        for (n = 1; n <= this.pat.getNumberOfJugglers(); ++n) {
            coordinate3 = Coordinate.max(coordinate3, this.pat.getHandMax(n, 1));
            coordinate4 = Coordinate.min(coordinate4, this.pat.getHandMin(n, 1));
            coordinate3 = Coordinate.max(coordinate3, this.pat.getHandMax(n, 2));
            coordinate4 = Coordinate.min(coordinate4, this.pat.getHandMin(n, 2));
        }
        for (n = 1; n <= this.pat.getNumberOfProps(); ++n) {
            coordinate5 = Coordinate.max(coordinate5, this.pat.getProp(n).getMax());
            coordinate6 = Coordinate.min(coordinate6, this.pat.getProp(n).getMin());
        }
        coordinate = Coordinate.add(coordinate, coordinate5);
        coordinate2 = Coordinate.add(coordinate2, coordinate6);
        coordinate3 = Coordinate.add(coordinate3, this.ren1.getHandWindowMax());
        coordinate4 = Coordinate.add(coordinate4, this.ren1.getHandWindowMin());
        this.overallmax = Coordinate.max(coordinate3, this.ren1.getJugglerWindowMax());
        this.overallmax = Coordinate.max(this.overallmax, coordinate);
        this.overallmin = Coordinate.min(coordinate4, this.ren1.getJugglerWindowMin());
        this.overallmin = Coordinate.min(this.overallmin, coordinate2);
        if (this.pat.getNumberOfJugglers() == 1) {
            this.overallmin.z -= 0.3 * Math.max(Math.abs(this.overallmin.y), Math.abs(this.overallmax.y));
            this.overallmax.z += 5.0;
        } else {
            d = Math.max(Math.abs(this.overallmin.x), Math.abs(this.overallmax.x));
            double d2 = Math.max(Math.abs(this.overallmin.y), Math.abs(this.overallmax.y));
            this.overallmin.z -= 0.4 * Math.max(d, d2);
            this.overallmax.z += 0.4 * Math.max(d, d2);
        }
        d = Math.max(Math.abs(this.overallmin.x), Math.abs(this.overallmax.x));
        this.overallmin.x = -d;
        this.overallmax.x = d;
    }

    protected void syncRenderer() {
        Dimension dimension = this.getSize();
        if (this.jc.stereo) {
            dimension.width /= 2;
            this.ren1.initDisplay(dimension, this.jc.border, this.overallmax, this.overallmin);
            this.ren2.initDisplay(dimension, this.jc.border, this.overallmax, this.overallmin);
        } else {
            this.ren1.initDisplay(dimension, this.jc.border, this.overallmax, this.overallmin);
        }
    }

    public boolean isAnimInited() {
        return this.engineStarted;
    }

    public JMLPattern getPattern() {
        return this.pat;
    }

    public AnimatorPrefs getAnimatorPrefs() {
        return this.jc;
    }

    public int[] getAnimPropNum() {
        return this.animpropnum;
    }

    public void dispose() {
        this.killAnimationThread();
    }

    public void writeGIFAnim() {
        try {
            Class<?> clazz = Class.forName("jugglinglab.core.AnimatorGIFWriter");
            Method method = clazz.getMethod("setup", Animator.class, Renderer.class, Renderer.class, Integer.TYPE, Double.TYPE, Long.TYPE);
            Object obj = clazz.newInstance();
            method.invoke(obj, this, this.ren1, this.ren2, new Integer(this.num_frames), new Double(this.sim_interval_secs), new Long(this.real_interval_millis));
            this.writingGIF = true;
            Thread thread = (Thread)obj;
            thread.start();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (InstantiationException instantiationException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
    }
}

