/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class AnimatorPrefs {
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    public static final boolean stereo_def = false;
    public static final boolean startPause_def = false;
    public static final boolean mousePause_def = false;
    public static final boolean catchSound_def = false;
    public static final boolean bounceSound_def = true;
    public static final double fps_def = 30.0;
    public static final double slowdown_def = 2.0;
    public static final int border_def = 0;
    public boolean stereo = false;
    public boolean startPause = false;
    public boolean mousePause = false;
    public boolean catchSound = false;
    public boolean bounceSound = true;
    public double fps = 30.0;
    public double slowdown = 2.0;
    public int border = 0;

    public AnimatorPrefs() {
    }

    public AnimatorPrefs(AnimatorPrefs animatorPrefs) {
        if (animatorPrefs.slowdown >= 0.0) {
            this.slowdown = animatorPrefs.slowdown;
        }
        if (animatorPrefs.fps >= 0.0) {
            this.fps = animatorPrefs.fps;
        }
        if (animatorPrefs.border >= 0) {
            this.border = animatorPrefs.border;
        }
        this.startPause = animatorPrefs.startPause;
        this.mousePause = animatorPrefs.mousePause;
        this.stereo = animatorPrefs.stereo;
        this.catchSound = animatorPrefs.catchSound;
        this.bounceSound = animatorPrefs.bounceSound;
    }

    public void parseInput(String string) throws JuggleExceptionUser {
        double d;
        String string2 = null;
        ParameterList parameterList = new ParameterList(string);
        string2 = parameterList.getParameter("stereo");
        if (string2 != null) {
            this.stereo = Boolean.valueOf(string2);
        }
        if ((string2 = parameterList.getParameter("startpaused")) != null) {
            this.startPause = Boolean.valueOf(string2);
        }
        if ((string2 = parameterList.getParameter("mousepause")) != null) {
            this.mousePause = Boolean.valueOf(string2);
        }
        if ((string2 = parameterList.getParameter("catchsound")) != null) {
            this.catchSound = Boolean.valueOf(string2);
        }
        if ((string2 = parameterList.getParameter("bouncesound")) != null) {
            this.bounceSound = Boolean.valueOf(string2);
        }
        if ((string2 = parameterList.getParameter("fps")) != null) {
            try {
                this.fps = d = Double.valueOf(string2).doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"fps"};
                throw new JuggleExceptionUser(MessageFormat.format(string3, objectArray));
            }
        }
        if ((string2 = parameterList.getParameter("slowdown")) != null) {
            try {
                this.slowdown = d = Double.valueOf(string2).doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"slowdown"};
                throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
            }
        }
        if ((string2 = parameterList.getParameter("border")) != null) {
            try {
                int n;
                this.border = n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"border"};
                throw new JuggleExceptionUser(MessageFormat.format(string5, objectArray));
            }
        }
    }

    public String toString() {
        String string = "";
        if (this.stereo) {
            string = string + "stereo=" + this.stereo + ";";
        }
        if (this.startPause) {
            string = string + "startpaused=" + this.startPause + ";";
        }
        if (this.mousePause) {
            string = string + "mousepause=" + this.mousePause + ";";
        }
        if (this.catchSound) {
            string = string + "catchsound=" + this.catchSound + ";";
        }
        if (!this.bounceSound) {
            string = string + "bouncesound=" + this.bounceSound + ";";
        }
        if (this.fps != 30.0) {
            string = string + "fps=" + JMLPattern.toStringTruncated(this.fps, 2) + ";";
        }
        if (this.slowdown != 2.0) {
            string = string + "slowdown=" + JMLPattern.toStringTruncated(this.slowdown, 2) + ";";
        }
        if (this.border != 0) {
            string = string + "border=" + this.border + ";";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

