/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;

public class AnimatorPrefsDialog
extends JDialog {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected JTextField tf1;
    protected JTextField tf2;
    protected JTextField tf3;
    protected JCheckBox cb2;
    protected JCheckBox cb3;
    protected JCheckBox cb4;
    protected JCheckBox cb5;
    protected JCheckBox cb6;
    protected JButton but1;
    protected JButton but2;
    protected AnimatorPrefs newjc;
    protected static final int border = 10;

    public AnimatorPrefsDialog(JFrame jFrame) {
        super(jFrame, guistrings.getString("Animation_Preferences"), true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(guistrings.getString("Frames_per_second"));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, AnimatorPrefsDialog.make_constraints(21, 1, 0, new Insets(0, 3, 0, 0)));
        this.tf1 = new JTextField(4);
        jPanel.add(this.tf1);
        gridBagLayout.setConstraints(this.tf1, AnimatorPrefsDialog.make_constraints(21, 0, 0, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel(guistrings.getString("Slowdown_factor"));
        jPanel.add(jLabel2);
        gridBagLayout.setConstraints(jLabel2, AnimatorPrefsDialog.make_constraints(21, 1, 1, new Insets(0, 3, 0, 0)));
        this.tf2 = new JTextField(4);
        jPanel.add(this.tf2);
        gridBagLayout.setConstraints(this.tf2, AnimatorPrefsDialog.make_constraints(21, 0, 1, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel(guistrings.getString("Border_(pixels)"));
        jPanel.add(jLabel3);
        gridBagLayout.setConstraints(jLabel3, AnimatorPrefsDialog.make_constraints(21, 1, 2, new Insets(0, 3, 0, 0)));
        this.tf3 = new JTextField(4);
        jPanel.add(this.tf3);
        gridBagLayout.setConstraints(this.tf3, AnimatorPrefsDialog.make_constraints(21, 0, 2, new Insets(0, 0, 0, 0)));
        this.cb2 = new JCheckBox(guistrings.getString("Start_paused"));
        this.cb6 = new JCheckBox(guistrings.getString("Pause_on_mouse_away"));
        this.cb3 = new JCheckBox(guistrings.getString("Stereo_display"));
        this.cb4 = new JCheckBox(guistrings.getString("Catch_sounds"));
        this.cb5 = new JCheckBox(guistrings.getString("Bounce_sounds"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        this.but1 = new JButton(guistrings.getString("Cancel"));
        this.but1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnimatorPrefsDialog.this.setVisible(false);
            }
        });
        jPanel2.add(this.but1);
        gridBagLayout.setConstraints(this.but1, AnimatorPrefsDialog.make_constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        this.but2 = new JButton(guistrings.getString("OK"));
        this.but2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray;
                String string;
                double d;
                AnimatorPrefsDialog.this.setVisible(false);
                AnimatorPrefsDialog.this.newjc = new AnimatorPrefs(AnimatorPrefsDialog.this.newjc);
                try {
                    d = Double.valueOf(AnimatorPrefsDialog.this.tf1.getText());
                    if (d > 0.0) {
                        AnimatorPrefsDialog.this.newjc.fps = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"fps"};
                    new ErrorDialog(AnimatorPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                try {
                    d = Double.valueOf(AnimatorPrefsDialog.this.tf2.getText());
                    if (d > 0.0) {
                        AnimatorPrefsDialog.this.newjc.slowdown = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"slowdown"};
                    new ErrorDialog(AnimatorPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                try {
                    int n = Integer.parseInt(AnimatorPrefsDialog.this.tf3.getText());
                    if (n >= 0) {
                        AnimatorPrefsDialog.this.newjc.border = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = errorstrings.getString("Error_number_format");
                    objectArray = new Object[]{"border"};
                    new ErrorDialog(AnimatorPrefsDialog.this, MessageFormat.format(string, objectArray));
                }
                AnimatorPrefsDialog.this.newjc.startPause = AnimatorPrefsDialog.this.cb2.isSelected();
                AnimatorPrefsDialog.this.newjc.mousePause = AnimatorPrefsDialog.this.cb6.isSelected();
                AnimatorPrefsDialog.this.newjc.stereo = AnimatorPrefsDialog.this.cb3.isSelected();
                AnimatorPrefsDialog.this.newjc.catchSound = AnimatorPrefsDialog.this.cb4.isSelected();
                AnimatorPrefsDialog.this.newjc.bounceSound = AnimatorPrefsDialog.this.cb5.isSelected();
            }
        });
        jPanel2.add(this.but2);
        gridBagLayout.setConstraints(this.but2, AnimatorPrefsDialog.make_constraints(22, 1, 0, new Insets(0, 10, 0, 0)));
        this.getContentPane().add(this.cb3);
        gridBagLayout.setConstraints(this.cb3, AnimatorPrefsDialog.make_constraints(21, 0, 0, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb2);
        gridBagLayout.setConstraints(this.cb2, AnimatorPrefsDialog.make_constraints(21, 0, 1, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb6);
        gridBagLayout.setConstraints(this.cb6, AnimatorPrefsDialog.make_constraints(21, 0, 2, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb4);
        gridBagLayout.setConstraints(this.cb4, AnimatorPrefsDialog.make_constraints(21, 0, 3, new Insets(0, 10, 0, 10)));
        this.getContentPane().add(this.cb5);
        gridBagLayout.setConstraints(this.cb5, AnimatorPrefsDialog.make_constraints(21, 0, 4, new Insets(0, 10, 3, 10)));
        this.getContentPane().add(jPanel);
        gridBagLayout.setConstraints(jPanel, AnimatorPrefsDialog.make_constraints(21, 0, 5, new Insets(3, 10, 10, 10)));
        this.getContentPane().add(jPanel2);
        gridBagLayout.setConstraints(jPanel2, AnimatorPrefsDialog.make_constraints(22, 0, 6, new Insets(0, 10, 10, 10)));
        this.getRootPane().setDefaultButton(this.but2);
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        this.pack();
        this.setResizable(false);
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }

    public AnimatorPrefs getPrefs(AnimatorPrefs animatorPrefs) {
        this.newjc = animatorPrefs;
        this.tf1.setText(Double.toString(animatorPrefs.fps));
        this.tf2.setText(Double.toString(animatorPrefs.slowdown));
        this.tf3.setText(Integer.toString(animatorPrefs.border));
        this.cb2.setSelected(animatorPrefs.startPause);
        this.cb6.setSelected(animatorPrefs.mousePause);
        this.cb3.setSelected(animatorPrefs.stereo);
        this.cb4.setSelected(animatorPrefs.catchSound);
        this.cb5.setSelected(animatorPrefs.bounceSound);
        this.setVisible(true);
        return this.newjc;
    }
}

