/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jugglinglab.core.ApplicationWindow;

public class PlatformSpecific {
    protected static PlatformSpecific ps = null;
    protected ApplicationWindow jlw = null;
    protected JFileChooser jfc = null;

    public static PlatformSpecific getPlatformSpecific() {
        if (ps == null && System.getProperty("jugglinglab.macosxapp") != null) {
            try {
                Object obj = Class.forName("jugglinglab.MacOS.PlatformSpecificMacOS").newInstance();
                ps = (PlatformSpecific)obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ps = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                ps = null;
            }
            catch (InstantiationException instantiationException) {
                ps = null;
            }
        }
        if (ps == null) {
            ps = new PlatformSpecific();
        }
        return ps;
    }

    public void registerParent(ApplicationWindow applicationWindow) {
        this.jlw = applicationWindow;
    }

    public boolean isMacOS() {
        return false;
    }

    public void setupPlatform() {
    }

    public int showOpenDialog(Component component) {
        return this.showOpenDialog(component, null);
    }

    public int showOpenDialog(Component component, FileFilter fileFilter) {
        if (this.jfc == null) {
            this.jfc = new JFileChooser(System.getProperty("user.dir"));
        }
        this.jfc.setFileFilter(fileFilter);
        return this.jfc.showOpenDialog(component);
    }

    public int showSaveDialog(Component component) {
        if (this.jfc == null) {
            this.jfc = new JFileChooser(System.getProperty("user.dir"));
        }
        return this.jfc.showSaveDialog(component);
    }

    public File getSelectedFile() {
        if (this.jfc == null) {
            return null;
        }
        return this.jfc.getSelectedFile();
    }
}

