/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.text.MessageFormat;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.siteswapGeneratorControl;
import jugglinglab.util.JLMath;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionUser;

public class siteswapGenerator
extends Generator {
    protected static final int ASYNCH = 0;
    protected static final int SYNCH = 1;
    private static final int MP_EMPTY = 0;
    private static final int MP_THROW = 1;
    private static final int MP_LOWER_BOUND = 2;
    private static final int TYPE = 0;
    private static final int FROM = 1;
    private static final int VALUE = 2;
    private static final int CHARS_PER_THROW = 50;
    protected static final int[][] asynch_rhythm_repunit = new int[][]{{1}};
    protected static final int[][] synch_rhythm_repunit = new int[][]{{1, 0}, {1, 0}};
    protected int[][][] pattern_rhythm;
    protected int[][][] pattern_state;
    protected int[][] pattern_throwcount;
    protected int[][][] pattern_holes;
    protected int[][][] pattern_throw_to;
    protected int[][][] pattern_throw_value;
    protected int[][][][] pattern_filter;
    protected boolean pattern_printx;
    protected int hands;
    protected int max_occupancy;
    protected int leader_person;
    protected int[][] rhythm_repunit;
    protected int rhythm_period;
    protected int[] holdthrow;
    protected int[] person_number;
    protected int[] scratch1;
    protected int[] scratch2;
    protected int[][] ground_state;
    protected int ground_state_length;
    protected int n;
    protected int ht;
    protected int l;
    protected int llow;
    protected int lhigh;
    protected Vector exclude;
    protected Vector include;
    protected char[] output;
    protected int outputpos;
    protected int numflag;
    protected int groundflag;
    protected int rotflag;
    protected int fullflag;
    protected int mp_filter;
    protected int delaytime;
    protected boolean mp_clustered;
    protected boolean lameflag;
    protected boolean sequenceflag;
    protected boolean connected_patterns;
    protected boolean[] connections;
    protected boolean juggler_permutations;
    protected boolean[] perm_scratch1;
    protected boolean[] perm_scratch2;
    protected int mode;
    protected int jugglers;
    protected int slot_size;
    protected char[] starting_seq;
    protected char[] ending_seq;
    protected int starting_seq_length;
    protected int ending_seq_length;
    protected GeneratorTarget target;
    protected int max_num;
    protected double max_time;
    protected long max_time_millis;
    protected long start_time_millis;
    protected int loop_counter;
    protected static final int loop_counter_max = 20000;
    protected siteswapGeneratorControl control;

    public String getStartupMessage() {
        return "Welcome to the J2 Siteswap Generator";
    }

    public JPanel getGeneratorControls() {
        if (this.control == null) {
            this.control = new siteswapGeneratorControl();
        }
        return this.control;
    }

    public void resetGeneratorControls() {
        if (this.control != null) {
            this.control.resetControl();
        }
    }

    public void initGenerator() throws JuggleExceptionUser {
        if (this.control == null) {
            this.initGenerator("5 7 5");
        } else {
            this.initGenerator(this.control.getParams());
        }
    }

    public void initGenerator(String[] stringArray) throws JuggleExceptionUser {
        int n;
        int n2;
        int n3;
        int n4 = 1;
        boolean bl = false;
        if (stringArray.length < 3) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_insufficient_input"));
        }
        this.max_occupancy = 0;
        this.leader_person = 1;
        this.numflag = 0;
        this.groundflag = 0;
        this.rotflag = 0;
        this.mp_filter = 1;
        this.fullflag = 1;
        this.mp_clustered = true;
        this.delaytime = 0;
        this.lameflag = false;
        this.connected_patterns = false;
        this.juggler_permutations = false;
        this.sequenceflag = true;
        this.mode = 0;
        this.jugglers = 1;
        this.target = null;
        this.exclude = new Vector();
        this.include = new Vector();
        for (n3 = 3; n3 < stringArray.length; ++n3) {
            String string;
            if (stringArray[n3].equals("-n")) {
                this.numflag = 1;
                continue;
            }
            if (stringArray[n3].equals("-no")) {
                this.numflag = 2;
                continue;
            }
            if (stringArray[n3].equals("-g")) {
                this.groundflag = 1;
                continue;
            }
            if (stringArray[n3].equals("-ng")) {
                this.groundflag = 2;
                continue;
            }
            if (stringArray[n3].equals("-f")) {
                this.fullflag = 0;
                continue;
            }
            if (stringArray[n3].equals("-prime")) {
                this.fullflag = 2;
                continue;
            }
            if (stringArray[n3].equals("-rot")) {
                this.rotflag = 1;
                continue;
            }
            if (stringArray[n3].equals("-jp")) {
                this.juggler_permutations = true;
                continue;
            }
            if (stringArray[n3].equals("-lame")) {
                this.lameflag = true;
                continue;
            }
            if (stringArray[n3].equals("-se")) {
                this.sequenceflag = false;
                continue;
            }
            if (stringArray[n3].equals("-s")) {
                this.mode = 1;
                continue;
            }
            if (stringArray[n3].equals("-cp")) {
                this.connected_patterns = true;
                continue;
            }
            if (stringArray[n3].equals("-mf")) {
                this.mp_filter = 0;
                continue;
            }
            if (stringArray[n3].equals("-mc")) {
                this.mp_clustered = false;
                continue;
            }
            if (stringArray[n3].equals("-mt")) {
                bl = true;
                continue;
            }
            if (stringArray[n3].equals("-m")) {
                if (n3 >= stringArray.length - 1 || stringArray[n3 + 1].charAt(0) == '-') continue;
                try {
                    n4 = Integer.parseInt(stringArray[n3 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = errorstrings.getString("Error_number_format");
                    String string3 = guistrings.getString("simultaneous_throws");
                    Object[] objectArray = new Object[]{string3};
                    throw new JuggleExceptionUser(MessageFormat.format(string2, objectArray));
                }
                ++n3;
                continue;
            }
            if (stringArray[n3].equals("-j")) {
                if (n3 >= stringArray.length - 1 || stringArray[n3 + 1].charAt(0) == '-') continue;
                try {
                    this.jugglers = Integer.parseInt(stringArray[n3 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = errorstrings.getString("Error_number_format");
                    String string5 = guistrings.getString("Jugglers");
                    Object[] objectArray = new Object[]{string5};
                    throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
                }
                ++n3;
                continue;
            }
            if (stringArray[n3].equals("-d")) {
                if (n3 >= stringArray.length - 1 || stringArray[n3 + 1].charAt(0) == '-') continue;
                try {
                    this.delaytime = Integer.parseInt(stringArray[n3 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string6 = errorstrings.getString("Error_number_format");
                    String string7 = guistrings.getString("Passing_communication_delay");
                    Object[] objectArray = new Object[]{string7};
                    throw new JuggleExceptionUser(MessageFormat.format(string6, objectArray));
                }
                this.groundflag = 1;
                ++n3;
                continue;
            }
            if (stringArray[n3].equals("-l")) {
                if (n3 >= stringArray.length - 1 || stringArray[n3 + 1].charAt(0) == '-') continue;
                try {
                    this.leader_person = Integer.parseInt(stringArray[n3 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string8 = errorstrings.getString("Error_number_format");
                    String string9 = guistrings.getString("Error_passing_leader_number");
                    Object[] objectArray = new Object[]{string9};
                    throw new JuggleExceptionUser(MessageFormat.format(string8, objectArray));
                }
                ++n3;
                continue;
            }
            if (stringArray[n3].equals("-x")) {
                ++n3;
                while (n3 < stringArray.length && stringArray[n3].charAt(0) != '-') {
                    try {
                        string = this.make_standard_RE(stringArray[n3]);
                        if (string.indexOf("^") < 0) {
                            string = ".*" + string + ".*";
                        }
                        this.exclude.add(Pattern.compile(string));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_excluded_throws"));
                    }
                    ++n3;
                }
                --n3;
                continue;
            }
            if (stringArray[n3].equals("-i")) {
                ++n3;
                while (n3 < stringArray.length && stringArray[n3].charAt(0) != '-') {
                    try {
                        string = this.make_standard_RE(stringArray[n3]);
                        if (string.indexOf("^") < 0) {
                            string = ".*" + string;
                        }
                        if (string.indexOf("$") < 0) {
                            string = string + ".*";
                        }
                        this.include.add(Pattern.compile(string));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_included_throws"));
                    }
                    ++n3;
                }
                --n3;
                continue;
            }
            string = errorstrings.getString("Error_unrecognized_option");
            Object[] objectArray = new Object[]{stringArray[n3]};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.initialize();
        try {
            this.n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            String string = errorstrings.getString("Error_number_format");
            String string10 = guistrings.getString("balls");
            Object[] objectArray = new Object[]{string10};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        try {
            this.ht = stringArray[1].equals("-") ? -1 : Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string = errorstrings.getString("Error_number_format");
            String string11 = guistrings.getString("max._throw");
            Object[] objectArray = new Object[]{string11};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        try {
            if (stringArray[2].equals("-")) {
                this.llow = this.rhythm_period;
                this.lhigh = -1;
            } else {
                int n5 = stringArray[2].indexOf(45);
                if (n5 == 0) {
                    this.llow = this.rhythm_period;
                    this.lhigh = Integer.parseInt(stringArray[2].substring(1));
                } else if (n5 == stringArray[2].length() - 1) {
                    this.llow = Integer.parseInt(stringArray[2].substring(0, n5));
                    this.lhigh = -1;
                } else if (n5 > 0) {
                    this.llow = Integer.parseInt(stringArray[2].substring(0, n5));
                    this.lhigh = Integer.parseInt(stringArray[2].substring(n5 + 1));
                } else {
                    this.llow = this.lhigh = Integer.parseInt(stringArray[2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string = errorstrings.getString("Error_number_format");
            String string12 = guistrings.getString("period");
            Object[] objectArray = new Object[]{string12};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        if (this.n < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_too_few_balls"));
        }
        if (this.lhigh == -1) {
            if (this.fullflag != 2) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_generator_must_be_prime_mode"));
            }
            if (this.ht == -1) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_generator_underspecified"));
            }
            this.lhigh = JLMath.choose(this.ht * this.hands, this.n);
            this.lhigh -= this.lhigh % this.rhythm_period;
        }
        if (this.ht == -1) {
            this.ht = this.n * this.lhigh;
        }
        if (this.ht < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_height_too_small"));
        }
        if (this.llow < 1 || this.lhigh < 1 || this.llow > this.lhigh) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_period_problem"));
        }
        this.output = new char[this.lhigh * 50];
        this.outputpos = 0;
        if (this.jugglers > 1 && !this.juggler_permutations && this.groundflag != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_permutations"));
        }
        if (this.llow % this.rhythm_period != 0 || this.lhigh % this.rhythm_period != 0) {
            String string = errorstrings.getString("Error_period_multiple");
            Object[] objectArray = new Object[]{new Integer(this.rhythm_period)};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.find_ground();
        this.slot_size = this.ht > this.lhigh ? this.ht : this.lhigh;
        this.slot_size += this.rhythm_period - this.slot_size % this.rhythm_period;
        for (n3 = 0; n3 < this.hands; ++n3) {
            for (n2 = 0; n2 < this.rhythm_period; ++n2) {
                n = this.rhythm_repunit[n3][n2];
                if (n <= this.max_occupancy) continue;
                this.max_occupancy = n;
            }
        }
        this.max_occupancy *= n4;
        if (this.max_occupancy == 1) {
            this.mp_filter = 0;
        }
        this.pattern_state = new int[this.lhigh + 1][this.hands][this.ground_state_length];
        this.pattern_holes = new int[this.lhigh][this.hands][this.ht];
        this.pattern_throw_to = new int[this.slot_size][this.hands][this.max_occupancy];
        this.pattern_throw_value = new int[this.slot_size][this.hands][this.max_occupancy];
        this.pattern_rhythm = new int[this.slot_size + 1][this.hands][this.ht];
        for (n3 = 0; n3 < this.slot_size + 1; ++n3) {
            for (n2 = 0; n2 < this.hands; ++n2) {
                for (n = 0; n < this.ht; ++n) {
                    this.pattern_rhythm[n3][n2][n] = n4 * this.rhythm_repunit[n2][(n + n3) % this.rhythm_period];
                }
            }
        }
        if (this.mp_filter != 0) {
            this.pattern_filter = new int[this.lhigh + 1][this.hands][this.slot_size][3];
        }
        this.pattern_throwcount = new int[this.lhigh][this.hands];
        if (this.jugglers > 1) {
            this.scratch1 = new int[this.hands];
            this.scratch2 = new int[this.hands];
        }
        if (bl) {
            String string = null;
            if (this.jugglers == 1) {
                if (this.mode == 0) {
                    string = ".*\\[[^2]*\\].*";
                } else if (this.mode == 1) {
                    string = ".*\\[([^2\\]]*2x)*[^2\\]]*\\].*";
                }
            } else if (this.mode == 0) {
                string = ".*\\[([^2\\]]*(2p|.p2|2p.))*[^2\\]]*\\].*";
            } else if (this.mode == 1) {
                string = ".*\\[([^2\\]]*(2p|.p2|2p.|2x|2xp|.xp2|2xp.))*[^2\\]]*\\].*";
            }
            if (string != null) {
                this.include.add(Pattern.compile(string));
            }
        }
        if (this.connected_patterns) {
            this.connections = new boolean[this.jugglers];
        }
        if (this.jugglers > 1 && !this.juggler_permutations) {
            this.perm_scratch1 = new boolean[this.lhigh];
            this.perm_scratch2 = new boolean[this.lhigh];
        }
    }

    protected String make_standard_RE(String string) {
        String string2 = Pattern.compile("\\\\\\[").matcher(string).replaceAll("@");
        string2 = Pattern.compile("\\[").matcher(string2).replaceAll("\\\\[");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("[");
        string2 = Pattern.compile("\\\\\\]").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\]").matcher(string2).replaceAll("\\\\]");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("]");
        string2 = Pattern.compile("\\\\\\(").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\(").matcher(string2).replaceAll("\\\\(");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("(");
        string2 = Pattern.compile("\\\\\\)").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\)").matcher(string2).replaceAll("\\\\)");
        string2 = Pattern.compile("@").matcher(string2).replaceAll(")");
        string2 = Pattern.compile("\\\\\\|").matcher(string2).replaceAll("@");
        string2 = Pattern.compile("\\|").matcher(string2).replaceAll("\\\\|");
        string2 = Pattern.compile("@").matcher(string2).replaceAll("|");
        return string2;
    }

    public int runGenerator(GeneratorTarget generatorTarget) {
        try {
            return this.runGenerator(generatorTarget, -1, -1.0);
        }
        catch (JuggleException juggleException) {
            return 0;
        }
    }

    public int runGenerator(GeneratorTarget generatorTarget, int n, double d) throws JuggleExceptionUser {
        if (this.groundflag == 1 && this.ground_state_length > this.ht) {
            return 0;
        }
        this.target = generatorTarget;
        this.max_num = n;
        this.max_time = d;
        this.max_time_millis = (long)(1000.0 * d);
        this.start_time_millis = System.currentTimeMillis();
        this.loop_counter = 0;
        int n2 = 0;
        this.l = this.llow;
        while (this.l <= this.lhigh) {
            n2 += this.gen_patterns(0, 0, 0, 0);
            this.l += this.rhythm_period;
        }
        if (this.numflag != 0) {
            if (n2 == 1) {
                this.target.setStatus(guistrings.getString("Generator_patterns_1"));
            } else {
                String string = guistrings.getString("Generator_patterns_ne1");
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.target.setStatus(MessageFormat.format(string, objectArray));
            }
        }
        return n2;
    }

    protected void initialize() {
        switch (this.mode) {
            case 0: {
                this.rhythm_repunit = new int[this.jugglers][1];
                this.holdthrow = new int[this.jugglers];
                this.person_number = new int[this.jugglers];
                this.hands = this.jugglers;
                this.rhythm_period = 1;
                this.pattern_printx = false;
                for (int i = 0; i < this.hands; ++i) {
                    this.rhythm_repunit[i][0] = asynch_rhythm_repunit[0][0];
                    this.holdthrow[i] = 2;
                    this.person_number[i] = i + 1;
                }
                break;
            }
            case 1: {
                this.rhythm_repunit = new int[2 * this.jugglers][2];
                this.holdthrow = new int[2 * this.jugglers];
                this.person_number = new int[2 * this.jugglers];
                this.hands = 2 * this.jugglers;
                this.rhythm_period = 2;
                this.pattern_printx = true;
                for (int i = 0; i < this.hands; ++i) {
                    for (int j = 0; j < this.rhythm_period; ++j) {
                        this.rhythm_repunit[i][j] = synch_rhythm_repunit[i % 2][j];
                    }
                    this.holdthrow[i] = 2;
                    this.person_number[i] = i / 2 + 1;
                }
                break;
            }
        }
    }

    protected boolean valid_throw(int n) {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.exclude.size(); ++n4) {
            Pattern pattern = (Pattern)this.exclude.elementAt(n4);
            if (!pattern.matcher(new String(this.output, 0, this.outputpos)).matches()) continue;
            return false;
        }
        for (n4 = 0; n4 < this.hands; ++n4) {
            if (this.pattern_rhythm[n][n4][0] == 0) continue;
            for (n3 = 0; n3 < this.max_occupancy && (n2 = this.pattern_throw_value[n][n4][n3]) != 0; ++n3) {
                if (this.mp_clustered) continue;
                for (int i = 0; i < n3; ++i) {
                    if (this.pattern_throw_value[n][n4][n3] != this.pattern_throw_value[n][n4][i] || this.pattern_throw_to[n][n4][n3] != this.pattern_throw_to[n][n4][i]) continue;
                    return false;
                }
            }
        }
        if (this.jugglers > 1 && n < this.delaytime) {
            int n5 = 0;
            for (n4 = 0; n4 < this.hands; ++n4) {
                if (this.pattern_rhythm[n][n4][0] == 0) continue;
                ++n5;
                if (this.pattern_state[n][n4][0] == 1 || this.person_number[n4] == this.leader_person) continue;
                return false;
            }
            int n6 = this.n;
            for (n4 = 0; n4 < this.ht && n6 != 0; ++n4) {
                for (n3 = 0; n3 < this.hands && n6 != 0; ++n3) {
                    if (this.pattern_rhythm[n + 1][n3][n4] == 0 || --n6 >= n5) continue;
                    this.scratch1[n6] = n3;
                    this.scratch2[n6] = n4 + 1;
                }
            }
            if (n6 != 0) {
                return false;
            }
            for (n4 = 0; n4 < this.hands; ++n4) {
                if (this.pattern_state[n][n4][0] == 0 || this.person_number[n4] == this.leader_person) continue;
                n2 = 1;
                for (n3 = 0; n3 < n5 && n2 != 0; ++n3) {
                    if (this.scratch1[n3] != this.pattern_throw_to[n][n4][0] || this.scratch2[n3] != this.pattern_throw_value[n][n4][0]) continue;
                    n2 = 0;
                    this.scratch2[n3] = 0;
                }
                if (n2 == 0) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean valid_pattern() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.include.size(); ++n4) {
            Pattern pattern = (Pattern)this.include.elementAt(n4);
            if (pattern.matcher(new String(this.output, 0, this.outputpos)).matches()) continue;
            return false;
        }
        if (this.mode == 0 && this.lameflag && this.max_occupancy == 1) {
            for (n4 = 0; n4 < this.l - 1; ++n4) {
                for (n3 = 0; n3 < this.hands; ++n3) {
                    if (this.pattern_throw_value[n4][n3][0] != 1 || this.person_number[this.pattern_throw_to[n4][n3][0]] != this.person_number[n3] || this.pattern_throw_value[n4 + 1][n3][0] != 1 || this.person_number[this.pattern_throw_to[n4 + 1][n3][0]] != this.person_number[n3]) continue;
                    return false;
                }
            }
        }
        if (this.fullflag == 0 && this.rotflag == 0) {
            for (n4 = 1; n4 < this.l; ++n4) {
                if (n4 % this.rhythm_period != 0 || this.compare_states(this.pattern_state[0], this.pattern_state[n4]) != 0 || this.compare_rotations(0, n4) >= 0) continue;
                return false;
            }
        }
        if (this.connected_patterns) {
            for (n4 = 0; n4 < this.jugglers; ++n4) {
                this.connections[n4] = false;
            }
            this.connections[0] = true;
            boolean bl = true;
            while (bl) {
                bl = false;
                for (n4 = 0; n4 < this.l; ++n4) {
                    for (n3 = 0; n3 < this.hands; ++n3) {
                        if (this.connections[this.person_number[n3] - 1]) continue;
                        for (n2 = 0; n2 < this.max_occupancy && this.pattern_throw_value[n4][n3][n2] > 0; ++n2) {
                            n = this.person_number[this.pattern_throw_to[n4][n3][n2]];
                            if (!this.connections[n - 1]) continue;
                            this.connections[this.person_number[n3] - 1] = true;
                            bl = true;
                        }
                    }
                }
            }
            for (n4 = 0; n4 < this.jugglers; ++n4) {
                if (this.connections[n4]) continue;
                return false;
            }
        }
        if (this.jugglers > 1 && !this.juggler_permutations) {
            block10: for (n = 1; n <= this.jugglers - 1; ++n) {
                for (n4 = 0; n4 < this.l; ++n4) {
                    this.perm_scratch2[n4] = false;
                    this.perm_scratch1[n4] = false;
                }
                for (int i = 0; i < this.l; ++i) {
                    int n5 = -1;
                    int n6 = -1;
                    int n7 = 0;
                    int n8 = 0;
                    for (n4 = 0; n4 < this.l; ++n4) {
                        int n9;
                        if (!this.perm_scratch1[n4]) {
                            n9 = 0;
                            for (n3 = 0; n3 < this.hands; ++n3) {
                                if (this.person_number[n3] != n) continue;
                                for (n2 = 0; n2 < this.max_occupancy && this.pattern_throw_value[n4][n3][n2] > 0; ++n2) {
                                    n9 += 4 * this.pattern_throw_value[n4][n3][n2] * (2 * this.max_occupancy) * (2 * this.max_occupancy);
                                    if (this.pattern_throw_to[n4][n3][n2] == n3) continue;
                                    n9 += 2 * (2 * this.max_occupancy);
                                    if (this.person_number[this.pattern_throw_to[n4][n3][n2]] == n) continue;
                                    ++n9;
                                }
                            }
                            if (n9 > n5) {
                                n5 = n9;
                                n7 = n4;
                            }
                        }
                        if (this.perm_scratch2[n4]) continue;
                        n9 = 0;
                        for (n3 = 0; n3 < this.hands; ++n3) {
                            if (this.person_number[n3] != n + 1) continue;
                            for (n2 = 0; n2 < this.max_occupancy && this.pattern_throw_value[n4][n3][n2] > 0; ++n2) {
                                n9 += 4 * this.pattern_throw_value[n4][n3][n2] * (2 * this.max_occupancy) * (2 * this.max_occupancy);
                                if (this.pattern_throw_to[n4][n3][n2] == n3) continue;
                                n9 += 2 * (2 * this.max_occupancy);
                                if (this.person_number[this.pattern_throw_to[n4][n3][n2]] == n + 1) continue;
                                ++n9;
                            }
                        }
                        if (n9 <= n6) continue;
                        n6 = n9;
                        n8 = n4;
                    }
                    if (n6 > n5) {
                        return false;
                    }
                    if (n6 < n5) continue block10;
                    this.perm_scratch2[n8] = true;
                    this.perm_scratch1[n7] = true;
                }
            }
        }
        return true;
    }

    protected int compare_rotations(int n, int n2) {
        int n3 = 0;
        while (n3 < this.l) {
            int n4 = this.compare_loops((n + n3) % this.l, (n2 + n3) % this.l);
            if (n4 > 0) {
                return 1;
            }
            if (n4 < 0) {
                return -1;
            }
            ++n3;
            while (n3 < this.l && this.compare_states(this.pattern_state[n], this.pattern_state[(n + n3) % this.l]) != 0) {
                ++n3;
            }
        }
        return 0;
    }

    protected int compare_loops(int n, int n2) {
        int[][] nArray = this.pattern_state[n];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            ++n4;
            if (n3 == 0) {
                n3 = this.compare_throws(n, n2);
            }
            if (n4 % this.rhythm_period == 0) {
                int n5 = this.compare_states(this.pattern_state[n + 1], nArray);
                int n6 = this.compare_states(this.pattern_state[n2 + 1], nArray);
                if (n5 == 0) {
                    if (n6 == 0) {
                        return n3;
                    }
                    return -1;
                }
                if (n6 == 0) {
                    return 1;
                }
            }
            ++n;
            ++n2;
        }
    }

    protected int compare_throws(int n, int n2) {
        int[][] nArray = this.pattern_throw_value[n];
        int[][] nArray2 = this.pattern_throw_to[n];
        int[][] nArray3 = this.pattern_throw_value[n2];
        int[][] nArray4 = this.pattern_throw_to[n2];
        int[][] nArray5 = this.pattern_rhythm[n];
        for (int i = 0; i < this.hands; ++i) {
            for (int j = 0; j < nArray5[i][0]; ++j) {
                if (nArray[i][j] > nArray3[i][j]) {
                    return 1;
                }
                if (nArray[i][j] < nArray3[i][j]) {
                    return -1;
                }
                if (nArray2[i][j] > nArray4[i][j]) {
                    return 1;
                }
                if (nArray2[i][j] >= nArray4[i][j]) continue;
                return -1;
            }
        }
        return 0;
    }

    protected int compare_states(int[][] nArray, int[][] nArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.hands; ++n2) {
            for (n = 0; n < this.ht; ++n) {
                if (nArray[n2][n] > n3) {
                    n3 = nArray[n2][n];
                }
                if (nArray2[n2][n] <= n4) continue;
                n4 = nArray2[n2][n];
            }
        }
        if (n3 > n4) {
            return 1;
        }
        if (n3 < n4) {
            return -1;
        }
        for (n = this.ht - 1; n >= 0; --n) {
            for (n2 = this.hands - 1; n2 >= 0; --n2) {
                n3 = nArray[n2][n];
                n4 = nArray2[n2][n];
                if (n3 > n4) {
                    return 1;
                }
                if (n3 >= n4) continue;
                return -1;
            }
        }
        return 0;
    }

    protected char convert_number(int n) {
        return Character.toLowerCase(Character.forDigit(n, 36));
    }

    protected int print_throw(char[] cArray, int n, int[][] nArray, int[][] nArray2, int[][] nArray3) {
        int n2;
        for (n2 = 0; n2 < nArray3.length && nArray3[n2][0] == 0; ++n2) {
        }
        if (n2 == nArray3.length) {
            return n;
        }
        if (this.jugglers > 1) {
            cArray[n++] = 60;
        }
        for (n2 = 1; n2 <= this.jugglers; ++n2) {
            int n3;
            int n4;
            int n5 = 0;
            while (this.person_number[n5] != n2) {
                ++n5;
            }
            for (n4 = n5; n4 < this.hands && this.person_number[n4] == n2; ++n4) {
            }
            int n6 = 0;
            for (n3 = n5; n3 < n4; ++n3) {
                if (nArray3[n3][0] == 0) continue;
                ++n6;
            }
            if (n6 > 0) {
                boolean bl;
                if (n6 > 1) {
                    cArray[n++] = 40;
                    bl = true;
                } else {
                    bl = false;
                }
                for (n3 = n5; n3 < n4; ++n3) {
                    boolean bl2;
                    if (nArray3[n3][0] == 0) continue;
                    if (this.max_occupancy > 1 && nArray[n3][1] > 0) {
                        cArray[n++] = 91;
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                    for (n6 = 0; n6 < this.max_occupancy && nArray[n3][n6] > 0; ++n6) {
                        int n7 = nArray[n3][n6];
                        cArray[n++] = this.convert_number(n7);
                        if (this.hands > 1) {
                            n7 = this.person_number[nArray2[n3][n6]];
                            if (this.pattern_printx) {
                                int n8 = nArray2[n3][n6] - 1;
                                int n9 = 0;
                                while (n8 >= 0 && this.person_number[n8] == n7) {
                                    --n8;
                                    ++n9;
                                }
                                if (n9 != n3 - n5) {
                                    cArray[n++] = 120;
                                }
                            }
                            if (n7 != n2) {
                                cArray[n++] = 112;
                                if (this.jugglers > 2) {
                                    cArray[n++] = this.convert_number(n7);
                                }
                            }
                        }
                        if (!bl2 || this.jugglers <= 1 || n6 == this.max_occupancy - 1 || nArray[n3][n6 + 1] <= 0) continue;
                        cArray[n++] = 47;
                    }
                    if (n6 == 0) {
                        cArray[n++] = 48;
                    }
                    if (bl2) {
                        cArray[n++] = 93;
                    }
                    if (n3 >= n4 - 1 || !bl) continue;
                    cArray[n++] = 44;
                }
                if (bl) {
                    cArray[n++] = 41;
                }
            }
            if (n2 >= this.jugglers) continue;
            cArray[n++] = 124;
        }
        if (this.jugglers > 1) {
            cArray[n++] = 62;
        }
        return n;
    }

    protected void print_pattern() {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(this.hands * (2 * this.ground_state_length + this.l) * 50 + 10);
        StringBuffer stringBuffer2 = new StringBuffer(this.hands * (2 * this.ground_state_length + this.l) * 50 + 10);
        if (this.groundflag != 1) {
            if (this.sequenceflag) {
                if (this.mode == 0) {
                    for (n = this.n - this.starting_seq_length; n > 0; --n) {
                        stringBuffer.append(" ");
                    }
                }
                stringBuffer.append(this.starting_seq, 0, this.starting_seq_length);
                stringBuffer.append("  ");
            } else {
                n2 = this.compare_states(this.ground_state, this.pattern_state[0]);
                if (n2 != 0) {
                    stringBuffer.append("* ");
                } else {
                    stringBuffer.append("  ");
                }
            }
        }
        stringBuffer.append(this.output, 0, this.outputpos);
        stringBuffer2.append(this.output, 0, this.outputpos);
        if (this.groundflag != 1) {
            if (this.sequenceflag) {
                stringBuffer.append("  ");
                stringBuffer.append(this.ending_seq, 0, this.ending_seq_length);
                if (this.mode == 0) {
                    for (n = this.n - this.ending_seq_length; n > 0; --n) {
                        stringBuffer.append(" ");
                    }
                }
            } else if (n2 != 0) {
                stringBuffer.append(" *");
            } else {
                stringBuffer.append("  ");
            }
        }
        this.target.writePattern(stringBuffer.toString(), "siteswap", stringBuffer2.toString().trim());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int mp_addthrow(int[] nArray, int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 2: {
                if (nArray[0] != 0) return 0;
                nArray[0] = 2;
                nArray[2] = n3;
                nArray[1] = n4;
                return 0;
            }
            case 1: {
                if (n4 == n && n3 == this.holdthrow[n]) {
                    return 0;
                }
                switch (nArray[0]) {
                    case 0: {
                        nArray[0] = 1;
                        nArray[2] = n3;
                        nArray[1] = n4;
                        return 0;
                    }
                    case 2: {
                        if (nArray[2] > n3 && nArray[2] > this.holdthrow[n]) return 1;
                        nArray[0] = 1;
                        nArray[2] = n3;
                        nArray[1] = n4;
                        return 0;
                    }
                    case 1: {
                        if (nArray[1] != n4 || nArray[2] != n3) return 1;
                        return 0;
                    }
                }
                return 1;
            }
        }
        return 1;
    }

    protected int gen_loops(int n, int n2, int n3, int n4, int n5) throws JuggleExceptionUser {
        int n6;
        int n7;
        int n8 = this.outputpos;
        if (this.max_time > 0.0 && this.loop_counter++ > 20000) {
            this.loop_counter = 0;
            if (System.currentTimeMillis() - this.start_time_millis > this.max_time_millis) {
                String string = guistrings.getString("Generator_timeout");
                Object[] objectArray = new Object[]{new Integer((int)this.max_time)};
                throw new JuggleExceptionDone(MessageFormat.format(string, objectArray));
            }
        }
        if (n == this.l) {
            if (this.compare_states(this.pattern_state[0], this.pattern_state[this.l]) == 0 && this.valid_pattern()) {
                if (this.numflag != 2) {
                    this.print_pattern();
                }
                if (n5++ == this.max_num) {
                    String string = guistrings.getString("Generator_spacelimit");
                    Object[] objectArray = new Object[]{new Integer(this.max_num)};
                    throw new JuggleExceptionDone(MessageFormat.format(string, objectArray));
                }
            }
            this.outputpos = n8;
            return n5;
        }
        if (n2 == 0) {
            for (n7 = 0; n7 < this.hands; ++n7) {
                this.pattern_throwcount[n][n7] = this.pattern_state[n][n7][0];
                for (n6 = 0; n6 < this.ht; ++n6) {
                    this.pattern_holes[n][n7][n6] = this.pattern_rhythm[n + 1][n7][n6];
                    if (n6 == this.ht - 1) continue;
                    int[] nArray = this.pattern_holes[n][n7];
                    int n9 = n6;
                    nArray[n9] = nArray[n9] - this.pattern_state[n][n7][n6 + 1];
                }
                for (n6 = 0; n6 < this.max_occupancy; ++n6) {
                    this.pattern_throw_to[n][n7][n6] = n7;
                    this.pattern_throw_value[n][n7][n6] = 0;
                }
            }
        }
        for (n7 = 0; n7 < this.hands && this.pattern_throwcount[n][n7] == 0; ++n7) {
        }
        if (n7 == this.hands) {
            int n10;
            int n11;
            this.outputpos = this.print_throw(this.output, this.outputpos, this.pattern_throw_value[n], this.pattern_throw_to[n], this.pattern_rhythm[n]);
            if (!this.valid_throw(n)) {
                this.outputpos = n8;
                return n5;
            }
            for (n6 = 0; n6 < this.hands; ++n6) {
                for (n11 = 0; n11 < this.ht; ++n11) {
                    this.pattern_state[n + 1][n6][n11] = n11 == this.ht - 1 ? 0 : this.pattern_state[n][n6][n11 + 1];
                }
            }
            for (n6 = 0; n6 < this.hands; ++n6) {
                for (n11 = 0; n11 < this.max_occupancy && (n10 = this.pattern_throw_value[n][n6][n11]) != 0; ++n11) {
                    int[] nArray = this.pattern_state[n + 1][this.pattern_throw_to[n][n6][n11]];
                    int n12 = n10 - 1;
                    nArray[n12] = nArray[n12] + 1;
                }
            }
            for (n6 = 0; n6 < this.hands; ++n6) {
                for (n11 = 0; n11 < this.ht; ++n11) {
                    for (int i = n11; i < this.ht - this.l; i += this.l) {
                        if (this.pattern_state[n + 1][n6][i + this.l] <= this.pattern_state[n + 1][n6][i]) continue;
                        this.outputpos = n8;
                        return n5;
                    }
                }
            }
            if ((n + 1) % this.rhythm_period == 0) {
                n6 = this.compare_states(this.pattern_state[0], this.pattern_state[n + 1]);
                if (this.fullflag != 0 && n != this.l - 1 && n6 == 0) {
                    this.outputpos = n8;
                    return n5;
                }
                if (this.rotflag == 0 && n6 == 1) {
                    this.outputpos = n8;
                    return n5;
                }
            }
            if (this.fullflag == 2) {
                for (n6 = 1; n6 <= n; ++n6) {
                    if ((n + 1 - n6) % this.rhythm_period != 0 || this.compare_states(this.pattern_state[n6], this.pattern_state[n + 1]) != 0) continue;
                    this.outputpos = n8;
                    return n5;
                }
            }
            if (this.mp_filter != 0) {
                for (n6 = 0; n6 < this.hands; ++n6) {
                    for (n11 = 0; n11 < this.slot_size - 1; ++n11) {
                        this.pattern_filter[n + 1][n6][n11][0] = this.pattern_filter[n][n6][n11 + 1][0];
                        this.pattern_filter[n + 1][n6][n11][1] = this.pattern_filter[n][n6][n11 + 1][1];
                        this.pattern_filter[n + 1][n6][n11][2] = this.pattern_filter[n][n6][n11 + 1][2];
                    }
                    this.pattern_filter[n + 1][n6][this.slot_size - 1][0] = 0;
                    if (this.mp_addthrow(this.pattern_filter[n + 1][n6][this.l - 1], n6, this.pattern_filter[n][n6][0][0], this.pattern_filter[n][n6][0][2], this.pattern_filter[n][n6][0][1]) == 0) continue;
                    this.outputpos = n8;
                    return n5;
                }
                for (n6 = 0; n6 < this.hands; ++n6) {
                    for (n11 = 0; n11 < this.max_occupancy && (n10 = this.pattern_throw_value[n][n6][n11]) != 0; ++n11) {
                        if (this.mp_addthrow(this.pattern_filter[n + 1][this.pattern_throw_to[n][n6][n11]][n10 - 1], this.pattern_throw_to[n][n6][n11], 1, n10, n6) == 0) continue;
                        this.outputpos = n8;
                        return n5;
                    }
                }
            }
            n5 = this.gen_loops(n + 1, 0, 1, 0, n5);
        } else {
            int[] nArray = this.pattern_throwcount[n];
            int n13 = n7;
            int n14 = nArray[n13] - 1;
            nArray[n13] = n14;
            int n15 = n14;
            int n16 = n4;
            for (n6 = n3; n6 <= this.ht; ++n6) {
                while (n16 < this.hands) {
                    if (this.pattern_holes[n][n16][n6 - 1] != 0) {
                        int[] nArray2 = this.pattern_holes[n][n16];
                        int n17 = n6 - 1;
                        nArray2[n17] = nArray2[n17] - 1;
                        this.pattern_throw_to[n][n7][n15] = n16;
                        this.pattern_throw_value[n][n7][n15] = n6;
                        n5 = n15 != 0 ? this.gen_loops(n, n2 + 1, n6, n16, n5) : this.gen_loops(n, n2 + 1, 1, 0, n5);
                        int[] nArray3 = this.pattern_holes[n][n16];
                        int n18 = n6 - 1;
                        nArray3[n18] = nArray3[n18] + 1;
                    }
                    ++n16;
                }
                n16 = 0;
            }
            int[] nArray4 = this.pattern_throwcount[n];
            int n19 = n7;
            nArray4[n19] = nArray4[n19] + 1;
        }
        this.outputpos = n8;
        return n5;
    }

    protected void find_start_end() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        while (true) {
            block1: for (n4 = 0; n4 < this.hands; ++n4) {
                for (n3 = 0; n3 < this.ht; ++n3) {
                    this.pattern_state[1][n4][n3] = n3 + n5 < this.ground_state_length ? this.ground_state[n4][n3 + n5] : 0;
                    if (this.pattern_state[1][n4][n3] > this.pattern_state[0][n4][n3]) {
                        n5 += this.rhythm_period;
                        continue block1;
                    }
                    this.pattern_state[1][n4][n3] = this.pattern_state[0][n4][n3] - this.pattern_state[1][n4][n3];
                }
            }
            break;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            block4: for (n4 = 0; n4 < this.hands; ++n4) {
                for (n3 = 0; n3 < this.max_occupancy; ++n3) {
                    this.pattern_throw_value[n2][n4][n3] = 0;
                    this.pattern_throw_to[n2][n4][n3] = n4;
                }
                if (n2 >= this.ground_state_length || this.ground_state[n4][n2] == 0) continue;
                for (n3 = 0; n3 < this.ht; ++n3) {
                    for (n = 0; n < this.hands; ++n) {
                        if (this.pattern_state[1][n][n3] <= 0) continue;
                        int[] nArray = this.pattern_state[1][n];
                        int n6 = n3;
                        nArray[n6] = nArray[n6] - 1;
                        this.pattern_throw_value[n2][n4][0] = n3 + n5 - n2;
                        this.pattern_throw_to[n2][n4][0] = n;
                        continue block4;
                    }
                }
            }
        }
        this.starting_seq = new char[this.hands * n5 * 50];
        this.starting_seq_length = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            this.starting_seq_length = this.print_throw(this.starting_seq, this.starting_seq_length, this.pattern_throw_value[n2], this.pattern_throw_to[n2], this.pattern_rhythm[n2]);
        }
        int n7 = 0;
        while (true) {
            block10: for (n4 = 0; n4 < this.hands; ++n4) {
                for (n3 = 0; n3 < this.ground_state_length; ++n3) {
                    this.pattern_state[1][n4][n3] = n3 + n7 < this.ht ? this.pattern_state[0][n4][n3 + n7] : 0;
                    if (this.pattern_state[1][n4][n3] > this.ground_state[n4][n3]) {
                        n7 += this.rhythm_period;
                        continue block10;
                    }
                    this.pattern_state[1][n4][n3] = this.ground_state[n4][n3] - this.pattern_state[1][n4][n3];
                }
            }
            break;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            for (n4 = 0; n4 < this.hands; ++n4) {
                for (n3 = 0; n3 < this.max_occupancy; ++n3) {
                    this.pattern_throw_value[n2][n4][n3] = 0;
                    this.pattern_throw_to[n2][n4][n3] = n4;
                }
                if (n2 >= this.ht) continue;
                block15: for (int i = 0; i < this.pattern_state[0][n4][n2]; ++i) {
                    for (n3 = 0; n3 < this.ground_state_length; ++n3) {
                        for (n = 0; n < this.hands; ++n) {
                            if (this.pattern_state[1][n][n3] <= 0) continue;
                            int[] nArray = this.pattern_state[1][n];
                            int n8 = n3;
                            nArray[n8] = nArray[n8] - 1;
                            this.pattern_throw_value[n2][n4][i] = n3 + n7 - n2;
                            this.pattern_throw_to[n2][n4][i] = n;
                            continue block15;
                        }
                    }
                }
            }
        }
        this.ending_seq = new char[this.hands * n7 * 50];
        this.ending_seq_length = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            this.ending_seq_length = this.print_throw(this.ending_seq, this.ending_seq_length, this.pattern_throw_value[n4], this.pattern_throw_to[n4], this.pattern_rhythm[n4]);
        }
    }

    protected int gen_patterns(int n, int n2, int n3, int n4) throws JuggleExceptionUser {
        int n5;
        int n6;
        if (n == this.n || this.groundflag == 1) {
            int n7;
            int n8;
            if (this.groundflag == 1) {
                for (n8 = 0; n8 < this.hands; ++n8) {
                    for (n7 = 0; n7 < this.ht; ++n7) {
                        this.pattern_state[0][n8][n7] = this.ground_state[n8][n7];
                    }
                }
            } else if (this.groundflag == 2 && this.compare_states(this.pattern_state[0], this.ground_state) == 0) {
                return n4;
            }
            for (n8 = 0; n8 < this.hands; ++n8) {
                for (n7 = 0; n7 < this.ht; ++n7) {
                    int n9 = this.pattern_state[0][n8][n7];
                    if (this.mp_filter != 0 && n9 == 0) {
                        this.pattern_filter[0][n8][n7][0] = 0;
                        continue;
                    }
                    if (this.mp_filter != 0) {
                        this.pattern_filter[0][n8][n7][2] = n7 + 1;
                        this.pattern_filter[0][n8][n7][1] = n8;
                        this.pattern_filter[0][n8][n7][0] = 2;
                    }
                    int n10 = n7;
                    while ((n10 += this.l) < this.ht) {
                        int n11 = this.pattern_state[0][n8][n10];
                        if (n11 > n9) {
                            return n4;
                        }
                        if (this.mp_filter == 0 || n11 == 0) continue;
                        if (n11 < n9 && n7 > this.holdthrow[n8]) {
                            return n4;
                        }
                        this.pattern_filter[0][n8][n7][2] = n10 + 1;
                    }
                }
                if (this.mp_filter == 0) continue;
                while (n7 < this.slot_size) {
                    this.pattern_filter[0][n8][n7][0] = 0;
                    ++n7;
                }
            }
            if (this.numflag != 2 && this.sequenceflag) {
                this.find_start_end();
            }
            return this.gen_loops(0, 0, 1, 0, n4);
        }
        if (n == 0) {
            for (n6 = 0; n6 < this.hands; ++n6) {
                for (n5 = 0; n5 < this.ht; ++n5) {
                    this.pattern_state[0][n6][n5] = 0;
                }
            }
        }
        n5 = n3;
        for (n6 = n2; n6 < this.ht; ++n6) {
            while (n5 < this.hands) {
                if (this.pattern_state[0][n5][n6] < this.pattern_rhythm[0][n5][n6]) {
                    int[] nArray = this.pattern_state[0][n5];
                    int n12 = n6;
                    nArray[n12] = nArray[n12] + 1;
                    n4 = this.gen_patterns(n + 1, n6, n5, n4);
                    int[] nArray2 = this.pattern_state[0][n5];
                    int n13 = n6;
                    nArray2[n13] = nArray2[n13] - 1;
                }
                ++n5;
            }
            n5 = 0;
        }
        return n4;
    }

    protected void find_ground() {
        int n;
        int n2 = this.n;
        int n3 = 0;
        while (n2 != 0) {
            for (n = 0; n < this.hands && n2 != 0; ++n) {
                if (this.rhythm_repunit[n][n3 % this.rhythm_period] == 0 || --n2 != 0) continue;
                this.ground_state_length = n3 + 1;
            }
            ++n3;
        }
        if (this.ground_state_length < this.ht) {
            this.ground_state_length = this.ht;
        }
        this.ground_state = new int[this.hands][this.ground_state_length];
        for (n3 = 0; n3 < this.hands; ++n3) {
            for (n = 0; n < this.ground_state_length; ++n) {
                this.ground_state[n3][n] = 0;
            }
        }
        n2 = this.n;
        n3 = 0;
        while (n2 != 0) {
            for (n = 0; n < this.hands && n2 != 0; ++n) {
                if (this.rhythm_repunit[n][n3 % this.rhythm_period] == 0) continue;
                this.ground_state[n][n3] = 1;
                --n2;
            }
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            String string = guistrings.getString("Version");
            Object[] objectArray = new Object[]{"0.6.2"};
            String string2 = "Juggling Lab " + MessageFormat.format(string, objectArray).toLowerCase() + "\n";
            string = guistrings.getString("Copyright_message");
            Object[] objectArray2 = new Object[]{"2014"};
            string2 = string2 + MessageFormat.format(string, objectArray2) + "\n\n";
            string2 = string2 + guistrings.getString("GPL_message") + "\n\n";
            string2 = string2 + guistrings.getString("Generator_intro");
            System.out.println(string2);
        } else {
            siteswapGenerator siteswapGenerator2 = new siteswapGenerator();
            try {
                siteswapGenerator2.initGenerator(stringArray);
                siteswapGenerator2.runGenerator(new GeneratorTarget(System.out));
            }
            catch (Exception exception) {
                System.out.println(errorstrings.getString("Error") + ": " + exception.getMessage());
            }
        }
    }
}

