/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import jugglinglab.jml.PathLink;

public class JMLTransition {
    protected int path;
    protected String type;
    protected String mod;
    protected PathLink ipl;
    protected PathLink opl;
    protected int transitiontype;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_THROW = 1;
    public static final int TRANS_CATCH = 2;
    public static final int TRANS_SOFTCATCH = 3;
    public static final int TRANS_HOLDING = 4;
    public static final int TRANS_ANY = 5;

    public JMLTransition(int n, int n2, String string, String string2) {
        this.transitiontype = n;
        this.type = string;
        this.mod = string2;
        this.opl = null;
        this.ipl = null;
        this.path = n2;
    }

    public int getType() {
        return this.transitiontype;
    }

    public void setType(int n) {
        this.transitiontype = n;
    }

    public int getPath() {
        return this.path;
    }

    public void setPath(int n) {
        this.path = n;
    }

    public String getThrowType() {
        return this.type;
    }

    public void setThrowType(String string) {
        this.type = string;
    }

    public String getMod() {
        return this.mod;
    }

    public void setMod(String string) {
        this.mod = string;
    }

    public void setIncomingPathLink(PathLink pathLink) {
        this.ipl = pathLink;
    }

    public PathLink getIncomingPathLink() {
        return this.ipl;
    }

    public void setOutgoingPathLink(PathLink pathLink) {
        this.opl = pathLink;
    }

    public PathLink getOutgoingPathLink() {
        return this.opl;
    }

    public JMLTransition duplicate() {
        JMLTransition jMLTransition = new JMLTransition(this.transitiontype, this.path, this.type, this.mod);
        return jMLTransition;
    }

    public void writeJML(PrintWriter printWriter) throws IOException {
        switch (this.getType()) {
            case 1: {
                String string = "<throw path=\"" + Integer.toString(this.getPath()) + "\"";
                if (this.getThrowType() != null) {
                    string = string + " type=\"" + this.getThrowType() + "\"";
                }
                if (this.getMod() != null) {
                    string = string + " mod=\"" + this.getMod() + "\"";
                }
                printWriter.println(string + "/>");
                break;
            }
            case 2: {
                printWriter.println("<catch path=\"" + Integer.toString(this.getPath()) + "\"/>");
                break;
            }
            case 3: {
                printWriter.println("<softcatch path=\"" + Integer.toString(this.getPath()) + "\"/>");
                break;
            }
            case 4: {
                printWriter.println("<holding path=\"" + Integer.toString(this.getPath()) + "\"/>");
            }
        }
    }
}

