/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;

public abstract class Prop {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected String initString;
    public static final String[] builtinProps = new String[]{"Ball", "Image", "Ring"};

    public static Prop getProp(String string) throws JuggleExceptionUser {
        String string2;
        try {
            string2 = Class.forName("jugglinglab.prop." + string.toLowerCase() + "Prop").newInstance();
            if (string2 instanceof Prop) {
                return (Prop)((Object)string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        string2 = errorstrings.getString("Error_prop_type");
        Object[] objectArray = new Object[]{string};
        throw new JuggleExceptionUser(MessageFormat.format(string2, objectArray));
    }

    public abstract String getName();

    public abstract Color getEditorColor();

    public abstract ParameterDescriptor[] getParameterDescriptors();

    public void initProp(String string) throws JuggleExceptionUser {
        this.initString = string;
        this.init(string);
    }

    protected abstract void init(String var1) throws JuggleExceptionUser;

    public abstract Coordinate getMax();

    public abstract Coordinate getMin();

    public abstract Image getProp2DImage(Component var1, double var2, double[] var4);

    public abstract Dimension getProp2DSize(Component var1, double var2);

    public abstract Dimension getProp2DCenter(Component var1, double var2);

    public abstract Dimension getProp2DGrip(Component var1, double var2);
}

