/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;
import jugglinglab.core.VersionSpecific;
import jugglinglab.jml.JMLPattern;
import jugglinglab.prop.Prop;
import jugglinglab.renderer.JLMatrix;
import jugglinglab.renderer.JLVector;
import jugglinglab.renderer.Juggler;
import jugglinglab.renderer.Renderer;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLMath;
import jugglinglab.util.JuggleExceptionInternal;

public class Renderer2D
extends Renderer {
    public static final int RENDER_POINT_FIELD = 0;
    public static final int RENDER_WIRE_FRAME = 1;
    public static final int RENDER_FLAT_SOLID = 2;
    protected int render_type = 2;
    protected Color background = Color.white;
    protected Coordinate left = null;
    protected Coordinate right = null;
    protected JLVector cameracenter;
    protected double[] cameraangle = new double[2];
    protected double cameradistance;
    protected JLMatrix m;
    protected int width;
    protected int height;
    protected JMLPattern pat = null;
    protected double zoom;
    protected int originx;
    protected int originz;
    protected int polysides = 40;
    protected double[] headcos = new double[this.polysides];
    protected double[] headsin = new double[this.polysides];
    protected int[] headx = new int[this.polysides];
    protected int[] heady = new int[this.polysides];
    protected DrawObject2D[] obj = null;
    protected DrawObject2D[] obj2 = null;
    protected JLVector[][] jugglervec = null;
    protected Coordinate tempc = null;
    protected JLVector tempv = null;

    public Renderer2D() {
        for (int i = 0; i < this.polysides; ++i) {
            this.headcos[i] = Math.cos((double)i * JLMath.toRad(360.0) / (double)this.polysides);
            this.headsin[i] = Math.sin((double)i * JLMath.toRad(360.0) / (double)this.polysides);
        }
        this.tempc = new Coordinate();
        this.tempv = new JLVector();
    }

    public void setPattern(JMLPattern jMLPattern) {
        this.pat = jMLPattern;
        int n = 5 * jMLPattern.getNumberOfJugglers() + jMLPattern.getNumberOfPaths();
        this.obj = new DrawObject2D[n];
        for (int i = 0; i < n; ++i) {
            this.obj[i] = new DrawObject2D(n);
        }
        this.obj2 = new DrawObject2D[n];
        this.jugglervec = new JLVector[jMLPattern.getNumberOfJugglers()][12];
    }

    public Color getBackground() {
        return this.background;
    }

    public void initDisplay(Dimension dimension, int n, Coordinate coordinate, Coordinate coordinate2) {
        this.width = dimension.width;
        this.height = dimension.height;
        Rectangle rectangle = new Rectangle(n, n, this.width - 2 * n, this.height - 2 * n);
        this.calcScaling(rectangle, coordinate, coordinate2);
        this.cameradistance = 1000.0;
        this.cameracenter = new JLVector(0.5 * (coordinate.x + coordinate2.x), 0.5 * (coordinate.z + coordinate2.z), 0.5 * (coordinate.y + coordinate2.y));
        this.setCameraAngle(this.cameraangle);
    }

    public void setCameraAngle(double[] dArray) {
        this.cameraangle[0] = dArray[0];
        this.cameraangle[1] = dArray[1];
        if (this.cameracenter == null) {
            return;
        }
        this.m = JLMatrix.shiftMatrix(-this.cameracenter.x, -this.cameracenter.y, -this.cameracenter.z);
        this.m.transform(JLMatrix.rotateMatrix(0.0, JLMath.toRad(180.0) - this.cameraangle[0], 0.0));
        this.m.transform(JLMatrix.rotateMatrix(JLMath.toRad(90.0) - this.cameraangle[1], 0.0, 0.0));
        this.m.transform(JLMatrix.shiftMatrix(this.cameracenter.x, this.cameracenter.y, this.cameracenter.z));
        this.m.transform(JLMatrix.scaleMatrix(1.0, -1.0, 1.0));
        this.m.transform(JLMatrix.scaleMatrix(this.zoom));
        this.m.transform(JLMatrix.shiftMatrix(this.originx, this.originz, 0.0));
    }

    public double[] getCameraAngle() {
        double[] dArray = new double[]{this.cameraangle[0], this.cameraangle[1]};
        return dArray;
    }

    public int[] getXY(Coordinate coordinate) {
        return this.getXY(new JLVector(coordinate.x, coordinate.z, coordinate.y));
    }

    protected int[] getXY(JLVector jLVector) {
        JLVector jLVector2 = jLVector.transform(this.m);
        int[] nArray = new int[]{(int)(jLVector2.x + 0.5), (int)(jLVector2.y + 0.5)};
        return nArray;
    }

    protected JLVector getXYZ(JLVector jLVector, JLVector jLVector2) {
        jLVector2.x = jLVector.x * this.m.m00 + jLVector.y * this.m.m01 + jLVector.z * this.m.m02 + this.m.m03;
        jLVector2.y = jLVector.x * this.m.m10 + jLVector.y * this.m.m11 + jLVector.z * this.m.m12 + this.m.m13;
        jLVector2.z = jLVector.x * this.m.m20 + jLVector.y * this.m.m21 + jLVector.z * this.m.m22 + this.m.m23;
        return jLVector2;
    }

    public Coordinate getScreenTranslatedCoordinate(Coordinate coordinate, int n, int n2) {
        JLVector jLVector = new JLVector(coordinate.x, coordinate.z, coordinate.y);
        JLVector jLVector2 = jLVector.transform(this.m);
        JLVector jLVector3 = JLVector.add(jLVector2, new JLVector(n, n2, 0.0));
        JLVector jLVector4 = jLVector3.transform(this.m.inverse());
        return new Coordinate(jLVector4.x, jLVector4.z, jLVector4.y);
    }

    public void drawFrame(double d, int[] nArray, Graphics graphics, JPanel jPanel) throws JuggleExceptionInternal {
        int n;
        int n2;
        int n3;
        int n4;
        VersionSpecific.getVersionSpecific().setAntialias(graphics);
        int n5 = 5 * this.pat.getNumberOfJugglers() + this.pat.getNumberOfPaths();
        for (n4 = 0; n4 < n5; ++n4) {
            this.obj[n4].covering.removeAllElements();
        }
        n4 = 0;
        for (n3 = 1; n3 <= this.pat.getNumberOfPaths(); ++n3) {
            this.obj[n4].type = 1;
            this.obj[n4].number = n3;
            this.pat.getPathCoordinate(n3, d, this.tempc);
            if (!this.tempc.isValid()) {
                this.tempc.setCoordinate(0.0, 0.0, 0.0);
            }
            this.getXYZ(Renderer.toVector(this.tempc, this.tempv), this.obj[n4].coord[0]);
            n2 = (int)(0.5 + this.obj[n4].coord[0].x);
            n = (int)(0.5 + this.obj[n4].coord[0].y);
            Prop prop = this.pat.getProp(nArray[n3 - 1]);
            if (prop.getProp2DImage(jPanel, this.zoom, this.cameraangle) != null) {
                Dimension dimension = prop.getProp2DCenter(jPanel, this.zoom);
                Dimension dimension2 = prop.getProp2DSize(jPanel, this.zoom);
                this.obj[n4].boundingbox.x = n2 - dimension.width;
                this.obj[n4].boundingbox.y = n - dimension.height;
                this.obj[n4].boundingbox.width = dimension2.width;
                this.obj[n4].boundingbox.height = dimension2.height;
            }
            ++n4;
        }
        Juggler.findJugglerCoordinates(this.pat, d, this.jugglervec);
        for (n3 = 1; n3 <= this.pat.getNumberOfJugglers(); ++n3) {
            int n6;
            int n7;
            int n8;
            int n9;
            this.obj[n4].type = 2;
            this.obj[n4].number = n3;
            this.getXYZ(this.jugglervec[n3 - 1][2], this.obj[n4].coord[0]);
            this.getXYZ(this.jugglervec[n3 - 1][3], this.obj[n4].coord[1]);
            this.getXYZ(this.jugglervec[n3 - 1][7], this.obj[n4].coord[2]);
            this.getXYZ(this.jugglervec[n3 - 1][6], this.obj[n4].coord[3]);
            this.getXYZ(this.jugglervec[n3 - 1][8], this.obj[n4].coord[4]);
            this.getXYZ(this.jugglervec[n3 - 1][9], this.obj[n4].coord[5]);
            this.getXYZ(this.jugglervec[n3 - 1][10], this.obj[n4].coord[6]);
            this.getXYZ(this.jugglervec[n3 - 1][11], this.obj[n4].coord[7]);
            n2 = n = (int)(0.5 + this.obj[n4].coord[0].x);
            int n10 = n9 = (int)(0.5 + this.obj[n4].coord[0].y);
            for (n8 = 1; n8 < 8; ++n8) {
                n7 = (int)(0.5 + this.obj[n4].coord[n8].x);
                n6 = (int)(0.5 + this.obj[n4].coord[n8].y);
                if (n7 < n2) {
                    n2 = n7;
                }
                if (n7 > n) {
                    n = n7;
                }
                if (n6 < n10) {
                    n10 = n6;
                }
                if (n6 <= n9) continue;
                n9 = n6;
            }
            this.obj[n4].boundingbox.x = n2 + 1;
            this.obj[n4].boundingbox.y = n10 + 1;
            this.obj[n4].boundingbox.width = n - n2 - 1;
            this.obj[n4].boundingbox.height = n9 - n10 - 1;
            ++n4;
            for (n8 = 0; n8 < 2; ++n8) {
                int n11;
                int n12;
                if (this.jugglervec[n3 - 1][4 + n8] == null) {
                    this.obj[n4].type = 3;
                    this.obj[n4].number = n3;
                    this.getXYZ(this.jugglervec[n3 - 1][2 + n8], this.obj[n4].coord[0]);
                    this.getXYZ(this.jugglervec[n3 - 1][0 + n8], this.obj[n4].coord[1]);
                    n7 = Math.min((int)(0.5 + this.obj[n4].coord[0].x), (int)(0.5 + this.obj[n4].coord[1].x));
                    n6 = Math.min((int)(0.5 + this.obj[n4].coord[0].y), (int)(0.5 + this.obj[n4].coord[1].y));
                    n12 = Math.abs((int)(0.5 + this.obj[n4].coord[0].x) - (int)(0.5 + this.obj[n4].coord[1].x)) + 1;
                    n11 = Math.abs((int)(0.5 + this.obj[n4].coord[0].y) - (int)(0.5 + this.obj[n4].coord[1].y)) + 1;
                    this.obj[n4].boundingbox.x = n7;
                    this.obj[n4].boundingbox.y = n6;
                    this.obj[n4].boundingbox.width = n12;
                    this.obj[n4].boundingbox.height = n11;
                    ++n4;
                    continue;
                }
                this.obj[n4].type = 3;
                this.obj[n4].number = n3;
                this.getXYZ(this.jugglervec[n3 - 1][2 + n8], this.obj[n4].coord[0]);
                this.getXYZ(this.jugglervec[n3 - 1][4 + n8], this.obj[n4].coord[1]);
                n7 = Math.min((int)(0.5 + this.obj[n4].coord[0].x), (int)(0.5 + this.obj[n4].coord[1].x));
                n6 = Math.min((int)(0.5 + this.obj[n4].coord[0].y), (int)(0.5 + this.obj[n4].coord[1].y));
                n12 = Math.abs((int)(0.5 + this.obj[n4].coord[0].x) - (int)(0.5 + this.obj[n4].coord[1].x)) + 1;
                n11 = Math.abs((int)(0.5 + this.obj[n4].coord[0].y) - (int)(0.5 + this.obj[n4].coord[1].y)) + 1;
                this.obj[n4].boundingbox.x = n7;
                this.obj[n4].boundingbox.y = n6;
                this.obj[n4].boundingbox.width = n12;
                this.obj[n4].boundingbox.height = n11;
                this.obj[++n4].type = 3;
                this.obj[n4].number = n3;
                this.getXYZ(this.jugglervec[n3 - 1][4 + n8], this.obj[n4].coord[0]);
                this.getXYZ(this.jugglervec[n3 - 1][0 + n8], this.obj[n4].coord[1]);
                n7 = Math.min((int)(0.5 + this.obj[n4].coord[0].x), (int)(0.5 + this.obj[n4].coord[1].x));
                n6 = Math.min((int)(0.5 + this.obj[n4].coord[0].y), (int)(0.5 + this.obj[n4].coord[1].y));
                n12 = Math.abs((int)(0.5 + this.obj[n4].coord[0].x) - (int)(0.5 + this.obj[n4].coord[1].x)) + 1;
                n11 = Math.abs((int)(0.5 + this.obj[n4].coord[0].y) - (int)(0.5 + this.obj[n4].coord[1].y)) + 1;
                this.obj[n4].boundingbox.x = n7;
                this.obj[n4].boundingbox.y = n6;
                this.obj[n4].boundingbox.width = n12;
                this.obj[n4].boundingbox.height = n11;
                ++n4;
            }
        }
        n5 = n4;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (n2 == n3 || !this.obj[n3].isCovering(this.obj[n2])) continue;
                this.obj[n3].covering.addElement(this.obj[n2]);
            }
            this.obj[n3].drawn = false;
        }
        n4 = 0;
        n3 = 1;
        while (n3 != 0) {
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (this.obj[n2].drawn) continue;
                n = 1;
                for (int i = 0; i < this.obj[n2].covering.size(); ++i) {
                    DrawObject2D drawObject2D = (DrawObject2D)this.obj[n2].covering.elementAt(i);
                    if (drawObject2D.drawn) continue;
                    n = 0;
                    break;
                }
                if (n == 0) continue;
                this.obj2[n4] = this.obj[n2];
                this.obj[n2].drawn = true;
                ++n4;
                n3 = 1;
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (this.obj[n2].drawn) continue;
            this.obj2[n4] = this.obj[n2];
            this.obj[n2].drawn = true;
            ++n4;
        }
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, this.width, this.height);
        block16: for (n2 = 0; n2 < n5; ++n2) {
            DrawObject2D drawObject2D = this.obj2[n2];
            switch (drawObject2D.type) {
                case 1: {
                    Prop prop = this.pat.getProp(nArray[drawObject2D.number - 1]);
                    int n13 = (int)(0.5 + drawObject2D.coord[0].x);
                    int n14 = (int)(0.5 + drawObject2D.coord[0].y);
                    Image image = prop.getProp2DImage(jPanel, this.zoom, this.cameraangle);
                    if (image == null) continue block16;
                    Object object = prop.getProp2DGrip(jPanel, this.zoom);
                    graphics.drawImage(image, n13 - object.width, n14 - object.height, jPanel);
                    continue block16;
                }
                case 2: {
                    int n15;
                    Object object = new int[4];
                    int[] nArray2 = new int[4];
                    for (int i = 0; i < 4; ++i) {
                        object[i] = (int)(0.5 + drawObject2D.coord[i].x);
                        nArray2[i] = (int)(0.5 + drawObject2D.coord[i].y);
                    }
                    graphics.setColor(this.background);
                    graphics.fillPolygon((int[])object, nArray2, 4);
                    graphics.setColor(Color.black);
                    graphics.drawPolygon((int[])object, nArray2, 4);
                    double d2 = drawObject2D.coord[4].x;
                    double d3 = drawObject2D.coord[4].y;
                    double d4 = drawObject2D.coord[5].x;
                    double d5 = drawObject2D.coord[5].y;
                    double d6 = drawObject2D.coord[6].x;
                    double d7 = drawObject2D.coord[6].y;
                    double d8 = drawObject2D.coord[7].x;
                    double d9 = drawObject2D.coord[7].y;
                    for (n15 = 0; n15 < this.polysides; ++n15) {
                        this.headx[n15] = (int)(0.5 + 0.5 * (d2 + d6 + this.headcos[n15] * (d6 - d2)));
                        this.heady[n15] = (int)(0.5 + 0.5 * (d3 + d5 + this.headsin[n15] * (d3 - d5)) + ((double)this.headx[n15] - d2) * (d7 - d3) / (d6 - d2));
                    }
                    graphics.setColor(this.background);
                    graphics.fillPolygon(this.headx, this.heady, this.polysides);
                    graphics.setColor(Color.black);
                    graphics.drawPolygon(this.headx, this.heady, this.polysides);
                    continue block16;
                }
                case 3: {
                    graphics.setColor(Color.black);
                    int n15 = (int)(0.5 + drawObject2D.coord[0].x);
                    int n16 = (int)(0.5 + drawObject2D.coord[0].y);
                    int n17 = (int)(0.5 + drawObject2D.coord[1].x);
                    int n18 = (int)(0.5 + drawObject2D.coord[1].y);
                    graphics.drawLine(n15, n16, n17, n18);
                }
            }
        }
    }

    public Coordinate getHandWindowMax() {
        return new Coordinate(5.0, 0.0, 1.0);
    }

    public Coordinate getHandWindowMin() {
        return new Coordinate(-5.0, 0.0, -1.0);
    }

    public Coordinate getJugglerWindowMax() {
        Coordinate coordinate = this.pat.getJugglerMax(1);
        for (int i = 2; i <= this.pat.getNumberOfJugglers(); ++i) {
            coordinate = Coordinate.max(coordinate, this.pat.getJugglerMax(i));
        }
        coordinate = Coordinate.add(coordinate, new Coordinate(23.0, 23.0, 71.0));
        return coordinate;
    }

    public Coordinate getJugglerWindowMin() {
        Coordinate coordinate = this.pat.getJugglerMin(1);
        for (int i = 2; i <= this.pat.getNumberOfJugglers(); ++i) {
            coordinate = Coordinate.min(coordinate, this.pat.getJugglerMin(i));
        }
        coordinate = Coordinate.add(coordinate, new Coordinate(-23.0, -23.0, 40.0));
        return coordinate;
    }

    protected void calcScaling(Rectangle rectangle, Coordinate coordinate, Coordinate coordinate2) {
        double d = coordinate.x - coordinate2.x;
        double d2 = coordinate.z - coordinate2.z;
        this.zoom = Math.min((double)rectangle.width / d, (double)rectangle.height / d2);
        this.originx = rectangle.x + (int)(0.5 + 0.5 * ((double)rectangle.width - this.zoom * (coordinate.x + coordinate2.x)));
        this.originz = rectangle.y + (int)(0.5 + 0.5 * ((double)rectangle.height + this.zoom * (coordinate.z + coordinate2.z)));
    }

    class DrawObject2D {
        public static final int TYPE_PROP = 1;
        public static final int TYPE_BODY = 2;
        public static final int TYPE_LINE = 3;
        protected static final double slop = 3.0;
        public int type;
        public int number;
        public JLVector[] coord = new JLVector[8];
        public Rectangle boundingbox = null;
        public Vector covering = null;
        public boolean drawn = false;
        public JLVector tempv = null;

        public DrawObject2D(int n) {
            for (int i = 0; i < 8; ++i) {
                this.coord[i] = new JLVector();
            }
            this.boundingbox = new Rectangle();
            this.covering = new Vector(n);
            this.tempv = new JLVector();
        }

        public boolean isCovering(DrawObject2D drawObject2D) {
            if (!this.boundingbox.intersects(drawObject2D.boundingbox)) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    switch (drawObject2D.type) {
                        case 1: {
                            return this.coord[0].z < drawObject2D.coord[0].z;
                        }
                        case 2: {
                            this.vectorProduct(drawObject2D.coord[0], drawObject2D.coord[1], drawObject2D.coord[2], this.tempv);
                            if (this.tempv.z == 0.0) {
                                return false;
                            }
                            double d = drawObject2D.coord[0].z - (this.tempv.x * (this.coord[0].x - drawObject2D.coord[0].x) + this.tempv.y * (this.coord[0].y - drawObject2D.coord[0].y)) / this.tempv.z;
                            return this.coord[0].z < d;
                        }
                        case 3: {
                            return this.isBoxCoveringLine(this, drawObject2D) == 1;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (drawObject2D.type) {
                        case 1: {
                            this.vectorProduct(this.coord[0], this.coord[1], this.coord[2], this.tempv);
                            if (this.tempv.z == 0.0) {
                                return false;
                            }
                            double d = this.coord[0].z - (this.tempv.x * (drawObject2D.coord[0].x - this.coord[0].x) + this.tempv.y * (drawObject2D.coord[0].y - this.coord[0].y)) / this.tempv.z;
                            return d < drawObject2D.coord[0].z;
                        }
                        case 2: {
                            double d = 0.0;
                            for (int i = 0; i < 4; ++i) {
                                d += this.coord[i].z - drawObject2D.coord[i].z;
                            }
                            return d < 0.0;
                        }
                        case 3: {
                            return this.isBoxCoveringLine(this, drawObject2D) == 1;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (drawObject2D.type) {
                        case 1: 
                        case 2: {
                            return this.isBoxCoveringLine(drawObject2D, this) == -1;
                        }
                        case 3: {
                            return false;
                        }
                    }
                }
            }
            return false;
        }

        protected int isBoxCoveringLine(DrawObject2D drawObject2D, DrawObject2D drawObject2D2) {
            double d;
            int n;
            int n2;
            double d2;
            double d3;
            int n3;
            if (drawObject2D.type == 2) {
                this.vectorProduct(drawObject2D.coord[0], drawObject2D.coord[1], drawObject2D.coord[2], this.tempv);
            } else {
                this.tempv.x = 0.0;
                this.tempv.y = 0.0;
                this.tempv.z = 1.0;
            }
            if (this.tempv.z == 0.0) {
                return 0;
            }
            boolean bl = false;
            for (n3 = 0; n3 < 2; ++n3) {
                double d4 = drawObject2D2.coord[n3].x;
                d3 = drawObject2D2.coord[n3].y;
                if (!drawObject2D.boundingbox.contains((int)(d4 + 0.5), (int)(d3 + 0.5))) continue;
                d2 = drawObject2D.coord[0].z - (this.tempv.x * (d4 - drawObject2D.coord[0].x) + this.tempv.y * (d3 - drawObject2D.coord[0].y)) / this.tempv.z;
                if (drawObject2D2.coord[n3].z < d2 - 3.0) {
                    return -1;
                }
                bl = true;
            }
            if (bl) {
                return 1;
            }
            n3 = 0;
            for (n2 = 0; n2 < 2; ++n2) {
                int n4 = n = n2 == 0 ? drawObject2D.boundingbox.x : drawObject2D.boundingbox.x + drawObject2D.boundingbox.width - 1;
                if ((double)n < Math.min(drawObject2D2.coord[0].x, drawObject2D2.coord[1].x) || (double)n > Math.max(drawObject2D2.coord[0].x, drawObject2D2.coord[1].x) || drawObject2D2.coord[1].x == drawObject2D2.coord[0].x || (d3 = drawObject2D2.coord[0].y + (drawObject2D2.coord[1].y - drawObject2D2.coord[0].y) * ((double)n - drawObject2D2.coord[0].x) / (drawObject2D2.coord[1].x - drawObject2D2.coord[0].x)) < (double)drawObject2D.boundingbox.y || d3 > (double)(drawObject2D.boundingbox.y + drawObject2D.boundingbox.height - 1)) continue;
                n3 = 1;
                d = drawObject2D2.coord[0].z + (drawObject2D2.coord[1].z - drawObject2D2.coord[0].z) * ((double)n - drawObject2D2.coord[0].x) / (drawObject2D2.coord[1].x - drawObject2D2.coord[0].x);
                d2 = drawObject2D.coord[0].z - (this.tempv.x * ((double)n - drawObject2D.coord[0].x) + this.tempv.y * (d3 - drawObject2D.coord[0].y)) / this.tempv.z;
                if (!(d < d2 - 3.0)) continue;
                return -1;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                int n5 = n = n2 == 0 ? drawObject2D.boundingbox.y : drawObject2D.boundingbox.y + drawObject2D.boundingbox.height - 1;
                if ((double)n < Math.min(drawObject2D2.coord[0].y, drawObject2D2.coord[1].y) || (double)n > Math.max(drawObject2D2.coord[0].y, drawObject2D2.coord[1].y) || drawObject2D2.coord[1].y == drawObject2D2.coord[0].y || (d3 = drawObject2D2.coord[0].x + (drawObject2D2.coord[1].x - drawObject2D2.coord[0].x) * ((double)n - drawObject2D2.coord[0].y) / (drawObject2D2.coord[1].y - drawObject2D2.coord[0].y)) < (double)drawObject2D.boundingbox.x || d3 > (double)(drawObject2D.boundingbox.x + drawObject2D.boundingbox.width - 1)) continue;
                n3 = 1;
                d = drawObject2D2.coord[0].z + (drawObject2D2.coord[1].z - drawObject2D2.coord[0].z) * (d3 - drawObject2D2.coord[0].x) / (drawObject2D2.coord[1].x - drawObject2D2.coord[0].x);
                d2 = drawObject2D.coord[0].z - (this.tempv.x * (d3 - drawObject2D.coord[0].x) + this.tempv.y * ((double)n - drawObject2D.coord[0].y)) / this.tempv.z;
                if (!(d < d2 - 3.0)) continue;
                return -1;
            }
            return n3 != 0 ? 1 : 0;
        }

        public JLVector vectorProduct(JLVector jLVector, JLVector jLVector2, JLVector jLVector3, JLVector jLVector4) {
            double d = jLVector2.x - jLVector.x;
            double d2 = jLVector2.y - jLVector.y;
            double d3 = jLVector2.z - jLVector.z;
            double d4 = jLVector3.x - jLVector.x;
            double d5 = jLVector3.y - jLVector.y;
            double d6 = jLVector3.z - jLVector.z;
            jLVector4.x = d2 * d6 - d5 * d3;
            jLVector4.y = d3 * d4 - d6 * d;
            jLVector4.z = d * d5 - d4 * d2;
            return jLVector4;
        }
    }
}

