/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jugglinglab.core.Animator;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JMLView
extends View {
    protected boolean isdirty = false;
    protected Animator ja = null;
    protected JTextArea ta = null;
    protected JButton compile = null;
    protected JButton revert = null;
    protected JLabel lab = null;

    public JMLView(Dimension dimension) {
        this.setLayout(new BorderLayout());
        this.ja = new Animator();
        this.ja.setJAPreferredSize(dimension);
        this.ta = new JTextArea();
        ChangeListener changeListener = new ChangeListener();
        this.ta.getDocument().addDocumentListener(changeListener);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setPreferredSize(new Dimension(400, 1));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        JSplitPane jSplitPane = new JSplitPane(1, true, this.ja, jScrollPane);
        this.add((Component)jSplitPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        this.compile = new JButton(guistrings.getString("JMLView_compile_button"));
        this.compile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JMLView.this.compilePattern();
                }
                catch (Exception exception) {
                    ErrorDialog.handleException(exception);
                }
            }
        });
        jPanel.add(this.compile);
        this.revert = new JButton(guistrings.getString("JMLView_revert_button"));
        this.revert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JMLView.this.revertPattern();
                }
                catch (Exception exception) {
                    ErrorDialog.handleException(exception);
                }
            }
        });
        jPanel.add(this.revert);
        this.lab = new JLabel("");
        jPanel.add(this.lab);
        this.add((Component)jPanel, "Last");
    }

    public void restartView() {
        try {
            this.ja.restartJuggle();
        }
        catch (JuggleException juggleException) {
            this.lab.setText(juggleException.getMessage());
        }
    }

    public void restartView(JMLPattern jMLPattern, AnimatorPrefs animatorPrefs) {
        try {
            this.ja.restartJuggle(jMLPattern, animatorPrefs);
            this.updateTextArea();
            this.lab.setText("");
            this.setDirty(false);
            if (jMLPattern != null) {
                this.parent.setTitle(jMLPattern.getTitle());
            }
        }
        catch (JuggleException juggleException) {
            this.lab.setText(juggleException.getMessage());
            this.setDirty(true);
        }
        catch (IOException iOException) {
            this.lab.setText(iOException.getMessage());
            this.setDirty(true);
        }
    }

    public Dimension getAnimatorSize() {
        return this.ja.getSize(new Dimension());
    }

    public void dispose() {
        this.ja.dispose();
    }

    public JMLPattern getPattern() {
        return this.ja.getPattern();
    }

    public boolean getPaused() {
        return this.ja.getPaused();
    }

    public void setPaused(boolean bl) {
        if (this.ja.message == null) {
            this.ja.setPaused(bl);
        }
    }

    protected void compilePattern() {
        if (this.isdirty) {
            try {
                JMLPattern jMLPattern = new JMLPattern(new StringReader(this.ta.getText()));
                this.ja.restartJuggle(jMLPattern, null);
                this.lab.setText("");
                this.parent.setTitle(jMLPattern.getTitle());
                this.updateTextArea();
                this.setDirty(false);
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                this.lab.setText(juggleExceptionUser.getMessage());
                this.setDirty(true);
            }
            catch (JuggleExceptionInternal juggleExceptionInternal) {
                ErrorDialog.handleException(juggleExceptionInternal);
                this.setDirty(true);
            }
            catch (SAXParseException sAXParseException) {
                String string = errorstrings.getString("Error_parsing");
                Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
                this.lab.setText(MessageFormat.format(string, objectArray));
                this.setDirty(true);
            }
            catch (SAXException sAXException) {
                this.lab.setText(sAXException.getMessage());
                this.setDirty(true);
            }
            catch (IOException iOException) {
                ErrorDialog.handleException(iOException);
                this.setDirty(true);
            }
        }
    }

    protected void revertPattern() {
        if (this.isdirty) {
            try {
                this.updateTextArea();
                this.lab.setText("");
                this.setDirty(false);
            }
            catch (IOException iOException) {
                this.lab.setText(iOException.getMessage());
            }
        }
    }

    protected void updateTextArea() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.ja.getPattern().writeJML(stringWriter, true);
        stringWriter.close();
        this.ta.setText(stringWriter.toString());
        this.ta.setCaretPosition(0);
    }

    protected void setDirty(boolean bl) {
        this.isdirty = bl;
        this.compile.setEnabled(bl);
        this.revert.setEnabled(bl);
    }

    class ChangeListener
    implements DocumentListener {
        ChangeListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JMLView.this.setDirty(true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JMLView.this.setDirty(true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            JMLView.this.setDirty(true);
        }
    }
}

