/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import jugglinglab.core.Animator;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.core.AnimatorPrefsDialog;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.view.EditView;
import jugglinglab.view.JMLView;
import jugglinglab.view.NormalView;
import jugglinglab.view.SelectionView;

public class View
extends JPanel
implements ActionListener {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected JFrame parent = null;
    protected Dimension animsize = null;
    protected AnimatorPrefs jc = null;
    protected JMLPattern pat = null;
    protected View subview = null;
    protected static final String[] fileItems = new String[]{"Close", null, "Save JML As...", "Save Animated GIF As...", "Save HTML As..."};
    protected static final String[] fileCommands = new String[]{"close", null, "saveas", "savegifanim", "savehtml"};
    protected static final char[] fileShortcuts = new char[]{'W', ' ', 'S', ' ', ' '};
    protected static final String[] viewItems = new String[]{"Simple", "Visual editor", "JML editor", null, "Restart", "Animation Preferences..."};
    protected static final String[] viewCommands = new String[]{"simple", "edit", "jml", null, "restart", "prefs"};
    protected static final char[] viewShortcuts = new char[]{'1', '2', '3', ' ', ' ', 'P'};
    public static final int FILE_NONE = 0;
    public static final int FILE_CLOSE = 1;
    public static final int FILE_SAVE = 2;
    public static final int FILE_GIFSAVE = 3;
    public static final int FILE_HTMLSAVE = 4;
    public static final int VIEW_RESTART = 5;
    public static final int VIEW_ANIMPREFS = 6;
    public static final int VIEW_NONE = 0;
    public static final int VIEW_SIMPLE = 1;
    public static final int VIEW_EDIT = 2;
    public static final int VIEW_SELECTION = 3;
    public static final int VIEW_JML = 4;

    public View() {
    }

    public View(JFrame jFrame, Dimension dimension) {
        this.setParent(jFrame);
        this.animsize = dimension;
        this.jc = new AnimatorPrefs();
    }

    protected void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        if (this.subview != null) {
            this.subview.restartView();
        }
    }

    public void restartView(JMLPattern jMLPattern, AnimatorPrefs animatorPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (jMLPattern != null) {
            this.pat = jMLPattern;
        }
        if (animatorPrefs != null) {
            this.jc = animatorPrefs;
        }
        if (this.subview != null) {
            this.subview.restartView(jMLPattern, animatorPrefs);
        }
    }

    public Dimension getAnimatorSize() {
        if (this.subview != null) {
            return this.subview.getAnimatorSize();
        }
        return null;
    }

    public void dispose() {
        if (this.subview != null) {
            this.subview.dispose();
        }
        this.subview = null;
    }

    public JMLPattern getPattern() {
        return this.pat;
    }

    public boolean getPaused() {
        if (this.subview != null) {
            return this.subview.getPaused();
        }
        return false;
    }

    public void setPaused(boolean bl) {
        if (this.subview != null) {
            this.subview.setPaused(bl);
        }
    }

    public JMenu createFileMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < fileItems.length; ++i) {
            if (fileItems[i] == null) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            jMenuItem.setActionCommand(fileCommands[i]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public JMenu createViewMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("View"));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = true;
        for (int i = 0; i < viewItems.length; ++i) {
            JMenuItem jMenuItem;
            if (viewItems[i] == null) {
                jMenu.addSeparator();
                bl = false;
                continue;
            }
            if (bl) {
                jMenuItem = new JRadioButtonMenuItem(guistrings.getString(viewItems[i].replace(' ', '_')));
                if (viewShortcuts[i] != ' ') {
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                }
                jMenuItem.setActionCommand(viewCommands[i]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                buttonGroup.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenuItem(guistrings.getString(viewItems[i].replace(' ', '_')));
            if (viewShortcuts[i] != ' ') {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            jMenuItem.setActionCommand(viewCommands[i]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("close")) {
                this.doMenuCommand(1);
            } else if (string.equals("saveas")) {
                this.doMenuCommand(2);
            } else if (string.equals("savegifanim")) {
                this.doMenuCommand(3);
            } else if (string.equals("savehtml")) {
                this.doMenuCommand(4);
            } else if (string.equals("restart")) {
                this.doMenuCommand(5);
            } else if (string.equals("prefs")) {
                this.doMenuCommand(6);
            } else if (string.equals("simple")) {
                if (this.getViewMode() != 1) {
                    this.setViewMode(1);
                    if (this.parent != null) {
                        this.parent.pack();
                    }
                    this.restartView(this.pat, this.jc);
                }
            } else if (string.equals("edit")) {
                if (this.getViewMode() != 2) {
                    this.setViewMode(2);
                    if (this.parent != null) {
                        this.parent.pack();
                    }
                    this.restartView(this.pat, this.jc);
                }
            } else if (string.equals("jml")) {
                if (this.getViewMode() != 4) {
                    this.setViewMode(4);
                    if (this.parent != null) {
                        this.parent.pack();
                    }
                    this.restartView(this.pat, this.jc);
                }
            } else if (string.equals("selection") && this.getViewMode() != 3) {
                this.setViewMode(3);
                if (this.parent != null) {
                    this.parent.pack();
                }
                this.restartView(this.pat, this.jc);
            }
        }
        catch (JuggleExceptionUser juggleExceptionUser) {
            new ErrorDialog(this, juggleExceptionUser.getMessage());
        }
        catch (Exception exception) {
            ErrorDialog.handleException(exception);
        }
    }

    public void doMenuCommand(int n) throws JuggleExceptionInternal {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.parent.dispose();
                break;
            }
            case 2: {
                if (this.getPattern().isValid()) {
                    try {
                        int n2 = PlatformSpecific.getPlatformSpecific().showSaveDialog(this);
                        if (n2 != 0 || PlatformSpecific.getPlatformSpecific().getSelectedFile() == null) break;
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        FileWriter fileWriter = new FileWriter(PlatformSpecific.getPlatformSpecific().getSelectedFile());
                        PrintWriter printWriter = new PrintWriter(fileWriter);
                        this.getPattern().writeJML(fileWriter, true);
                        fileWriter.close();
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new JuggleExceptionInternal("FileNotFound: " + fileNotFoundException.getMessage());
                    }
                    catch (IOException iOException) {
                        throw new JuggleExceptionInternal("IOException: " + iOException.getMessage());
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                new ErrorDialog(this, "Could not save: pattern is not valid");
                break;
            }
            case 3: {
                if (this.getViewMode() == 1) {
                    NormalView normalView = (NormalView)this.subview;
                    Animator animator = normalView.getAnimator();
                    if (!animator.isAnimInited()) break;
                    animator.writeGIFAnim();
                    break;
                }
                new LabelDialog(this, "Not available", "Switch to Simple view to save an animated GIF");
                break;
            }
            case 4: {
                if (this.getPattern().isValid()) {
                    try {
                        int n3 = PlatformSpecific.getPlatformSpecific().showSaveDialog(this);
                        if (n3 != 0 || PlatformSpecific.getPlatformSpecific().getSelectedFile() == null) break;
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        FileWriter fileWriter = new FileWriter(PlatformSpecific.getPlatformSpecific().getSelectedFile());
                        PrintWriter printWriter = new PrintWriter(fileWriter);
                        String string = null;
                        Dimension dimension = null;
                        if (this.getViewMode() == 2) {
                            string = "entry=none;view=edit";
                            dimension = this.getSize();
                        } else {
                            string = "entry=none;view=simple";
                            dimension = this.getAnimatorSize();
                        }
                        String string2 = this.jc.toString();
                        int n4 = dimension.width;
                        int n5 = dimension.height;
                        JMLPattern jMLPattern = this.getPattern();
                        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
                        printWriter.println("<html>");
                        printWriter.println("<head>");
                        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
                        printWriter.println("<title>" + JMLNode.xmlescape(jMLPattern.getTitle()) + "</title>");
                        printWriter.println("</head>");
                        printWriter.println("<body>");
                        printWriter.println("<applet archive=\"JugglingLab.jar\" code=\"JugglingLab\" width=\"" + n4 + "\" height=\"" + n5 + "\">");
                        printWriter.println("<param name=\"config\" value=\"" + JMLNode.xmlescape(string) + "\">");
                        if (string2.length() != 0) {
                            printWriter.println("<param name=\"animprefs\" value=\"" + JMLNode.xmlescape(string2) + "\">");
                        }
                        printWriter.println("<param name=\"notation\" value=\"jml\">");
                        printWriter.println("<param name=\"pattern\" value=\"");
                        printWriter.println(JMLNode.xmlescape(jMLPattern.toString()));
                        printWriter.println("\">");
                        printWriter.println("Java not available");
                        printWriter.println("</applet>");
                        printWriter.println("</body>");
                        printWriter.println("</html>");
                        printWriter.flush();
                        fileWriter.close();
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new JuggleExceptionInternal("FileNotFound: " + fileNotFoundException.getMessage());
                    }
                    catch (IOException iOException) {
                        throw new JuggleExceptionInternal("IOException: " + iOException.getMessage());
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                new ErrorDialog(this, "Could not save: pattern is not valid");
                break;
            }
            case 5: {
                try {
                    this.restartView();
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                    break;
                }
                catch (JuggleException juggleException) {
                    throw new JuggleExceptionInternal(juggleException.getMessage());
                }
            }
            case 6: {
                AnimatorPrefsDialog animatorPrefsDialog = new AnimatorPrefsDialog(this.parent);
                AnimatorPrefs animatorPrefs = animatorPrefsDialog.getPrefs(this.jc);
                if (animatorPrefs == this.jc) break;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.jc = animatorPrefs;
                try {
                    this.restartView(null, animatorPrefs);
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    new ErrorDialog(this, juggleExceptionUser.getMessage());
                    break;
                }
                catch (JuggleException juggleException) {
                    throw new JuggleExceptionInternal(juggleException.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    public void setViewMode(int n) throws JuggleExceptionUser, JuggleExceptionInternal {
        View view = null;
        boolean bl = false;
        if (this.subview != null) {
            this.animsize = this.subview.getAnimatorSize();
            this.pat = this.subview.getPattern();
            bl = this.subview.getPaused();
            this.remove(this.subview);
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                view = new NormalView(this.animsize);
                break;
            }
            case 2: {
                view = new EditView(this.animsize);
                break;
            }
            case 4: {
                view = new JMLView(this.animsize);
                break;
            }
            case 3: {
                view = new SelectionView(this.animsize);
            }
        }
        if (view == null) {
            return;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.add(view);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(view, gridBagConstraints);
        view.setParent(this.parent);
        view.setPaused(bl);
        if (this.subview != null) {
            this.subview.dispose();
        }
        this.subview = view;
    }

    protected int getViewMode() {
        if (this.subview == null) {
            return 0;
        }
        if (this.subview instanceof NormalView) {
            return 1;
        }
        if (this.subview instanceof EditView) {
            return 2;
        }
        if (this.subview instanceof JMLView) {
            return 4;
        }
        if (this.subview instanceof SelectionView) {
            return 3;
        }
        return 0;
    }
}

