
/*
 * typedefs.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_TYPEDEFS_H
#define DIALOGS_TYPEDEFS_H

#include <limits.h>		/* for INT_MAX */

/*
 * Colors
 */

#define BLACK	0
#define RED		1
#define GREEN	2
#define YELLOW	3
#define BLUE	4
#define MAGENTA	5
#define CYAN	6
#define WHITE	7

/*
 * Cursor modes
 */

#define CURSOR_INVISIBLE	0
#define CURSOR_NORMAL		1
#define CURSOR_LARGE		2

/*
 * Delay for Dialogs::Confirm()
 */

#define SLEEPTIME 100000

/*
 * EntryType file definitions
 */

#define FT_DIR	1
#define FT_FILE 2

/*
 * Entry sorting types
 */

#define SORT_EXT	1
#define SORT_NAME	2

/*
 * Side definitions for Windows::horzline() and Windows::vertline()
 */

#define SIDE_NORMAL		0
#define SIDE_TNORMAL	1
#define SIDE_LEFT		2
#define SIDE_RIGHT		3
#define SIDE_TLEFT		4
#define SIDE_TRIGHT		5
#define SIDE_CROSS		6
#define SIDE_UP			7		/* = SIDE_LEFT */
#define SIDE_DOWN		8		/* = SIDE_RIGHT */
#define SIDE_TUP		9		/* = SIDE_TLEFT */
#define SIDE_TDOWN		10		/* = SIDE_TRIGHT */

/*
 * Frame type definitions for Dialogs::scrollframe() and Dialogs::scrollbutton()
 */

#define FRAME_FILEDIR		0
#define FRAME_HELP			1
#define FRAME_MIDDLE		2
#define FRAME_SAVE			3

/*
 * Hotkey flag id
 */

#define HOTKEY_NONE INT_MAX		/* No hotkey pressed */

/*
 * Pattern matching definitions
 */

#define MATCH_VALID    1    /* valid match */
#define MATCH_END      2    /* premature end of pattern string */
#define MATCH_ABORT    3    /* premature end of text string */
#define MATCH_RANGE    4    /* match failure on [..] construct */
#define MATCH_LITERAL  5    /* match failure on literal match */
#define MATCH_PATTERN  6    /* bad pattern */

#define PATTERN_VALID  0    /* valid pattern */
#define PATTERN_ESC   -1    /* literal escape at end of pattern */
#define PATTERN_RANGE -2    /* malformed range in [..] construct */
#define PATTERN_CLOSE -3    /* no end bracket in [..] construct */
#define PATTERN_EMPTY -4    /* [..] contstruct is empty */

/*
 * Boolean definitions
 */

#ifndef bool
#define bool int
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/*
 * Hi Ascii related definitions
 */
#if defined(__i386__) && (A_ALTCHARSET)
	/* Double line characters */
	#define LCD_VERT	0xBA | A_ALTCHARSET		 /*  - Line char double vertical */
	#define LCD_RTEE	0xB9 | A_ALTCHARSET		 /*  - Line char double right tee */
	#define LCD_TR		0xBB | A_ALTCHARSET		 /*  - Line char double top right */
	#define LCD_BL		0xC8 | A_ALTCHARSET		 /*  - Line char double bottom left */
	#define LCD_BTEE	0xCA | A_ALTCHARSET		 /*  - Line char double bottom tee */
	#define LCD_TTEE	0xCB | A_ALTCHARSET		 /*  - Line char double top tee */
	#define LCD_LTEE	0xCC | A_ALTCHARSET		 /*  - Line char double left tee */
	#define LCD_HORZ	0xCD | A_ALTCHARSET		 /*  - Line char double horizontal */
	#define LCD_CROSS	0xCE | A_ALTCHARSET		 /*  - Line char double cross */
	#define LCD_BR		0xBC | A_ALTCHARSET		 /*  - Line char double bottom right */
	#define LCD_TL		0xC9 | A_ALTCHARSET		 /*  - Line char double top left */
	/* Single line characters */
	#define LCS_VERT	0xB3 | A_ALTCHARSET		 /*  - Line char single vertical */
	#define LCS_RTEE	0xB4 | A_ALTCHARSET		 /*  - Line char single right tee */
	#define LCS_TR		0xBF | A_ALTCHARSET		 /*  - Line char single top right */
	#define LCS_BL		0xC0 | A_ALTCHARSET		 /*  - Line char single bottom left */
	#define LCS_BTEE	0xC1 | A_ALTCHARSET		 /*  - Line char single bottom tee */
	#define LCS_TTEE	0xC2 | A_ALTCHARSET		 /*  - Line char single top tee */
	#define LCS_LTEE	0xC3 | A_ALTCHARSET		 /*  - Line char single left tee */
	#define LCS_HORZ	0xC4 | A_ALTCHARSET		 /*  - Line char single horizontal */
	#define LCS_CROSS	0xC5 | A_ALTCHARSET		 /*  - Line char single cross */
	#define LCS_BR		0xD9 | A_ALTCHARSET		 /*  - Line char single bottom right */
	#define LCS_TL		0xDA | A_ALTCHARSET		 /*  - Line char single top left */
	/* Special characters */
	#define SC_BRICK	0xB2 | A_ALTCHARSET		 /*  - Special char brick */
	#define SC_BUTTON	0xB1 | A_ALTCHARSET		 /*  - Special char button */
	#define SC_SCRLBUT	0xB0 | A_ALTCHARSET		 /*  - Special char scrollbutton */
	#define SC_DOT		0xF9 | A_ALTCHARSET		 /*  - Special char dot */
#else
	/* Double line characters */
	#define LCD_VERT	0xBA					 /*  - Line char double vertical */
	#define LCD_RTEE	0xB9					 /*  - Line char double right tee */
	#define LCD_TR		0xBB					 /*  - Line char double top right */
	#define LCD_BL		0xC8					 /*  - Line char double bottom left */
	#define LCD_BTEE	0xCA					 /*  - Line char double bottom tee */
	#define LCD_TTEE	0xCB					 /*  - Line char double top tee */
	#define LCD_LTEE	0xCC					 /*  - Line char double left tee */
	#define LCD_HORZ	0xCD					 /*  - Line char double horizontal */
	#define LCD_CROSS	0xCE					 /*  - Line char double cross */
	#define LCD_BR		0xBC					 /*  - Line char double bottom right */
	#define LCD_TL		0xC9					 /*  - Line char double top left */
	/* Single line characters */
	#define LCS_VERT	0xB3					 /*  - Line char single vertical */
	#define LCS_RTEE	0xB4					 /*  - Line char single right tee */
	#define LCS_TR		0xBF					 /*  - Line char single top right */
	#define LCS_BL		0xC0					 /*  - Line char single bottom left */
	#define LCS_BTEE	0xC1					 /*  - Line char single bottom tee */
	#define LCS_TTEE	0xC2					 /*  - Line char single top tee */
	#define LCS_LTEE	0xC3					 /*  - Line char single left tee */
	#define LCS_HORZ	0xC4					 /*  - Line char single horizontal */
	#define LCS_CROSS	0xC5					 /*  - Line char single cross */
	#define LCS_BR		0xD9					 /*  - Line char single bottom right */
	#define LCS_TL		0xDA				   	 /*  - Line char single top left */
	/* Special characters */
	#define SC_BRICK	0xB2					 /*  - Special char brick */
	#define SC_BUTTON	0xB1					 /*  - Special char button */
	#define SC_SCRLBUT	0xB0					 /*  - Special char scrollbutton */
	#define SC_DOT		0xF9					 /*  - Special char dot */
#endif

/* This enable the use of the G0 special chars & line set defined in the VT100 standard */
#ifdef WITHOUT_NCURSES
	/* Graphical line characters */
	#define G0_LC_VERT		0x78				 /* x - Graphical line char vertical */
	#define G0_LC_RTEE		0x75				 /* u - Graphical line char right tee */
	#define G0_LC_TR		0x6B				 /* k - Graphical line char top right */
	#define G0_LC_BL		0x6D				 /* m - Graphical line char bottom left */
	#define G0_LC_BTEE		0x76				 /* v - Graphical line char bottom tee */
	#define G0_LC_TTEE		0x77				 /* w - Graphical line char top tee */
	#define G0_LC_LTEE		0x74				 /* t - Graphical line char left tee */
	#define G0_LC_HORZ		0x71				 /* q - Graphical line char horizontal */
	#define G0_LC_CROSS		0x6E				 /* n - Graphical line char cross */
	#define G0_LC_BR		0x6A				 /* j - Graphical line char bottom right*/
	#define G0_LC_TL		0x6C				 /* l - Graphical line char top left */
	/* Graphical special characters */
	#define G0_SC_BRICK		0x61				 /* a - Graphical special char brick */
	#define G0_SC_BUTTON	0x61				 /* a - Graphical special char button */
	#define G0_SC_SCRLBUT	0x61				 /* a - Graphical special char scrollbutton */
	#define G0_SC_DIAMOND	0x60				 /* ` - Graphical special char diamond */
	#define G0_SC_DOT		0x7E
#else
	/* Graphical line characters */
	#define G0_LC_VERT		ACS_VLINE			 /* Graphical line char vertical */
	#define G0_LC_RTEE		ACS_RTEE			 /* Graphical line char right tee */
	#define G0_LC_TR		ACS_URCORNER		 /* Graphical line char top right */
	#define G0_LC_BL		ACS_LLCORNER		 /* Graphical line char bottom left */
	#define G0_LC_BTEE		ACS_BTEE			 /* Graphical line char bottom tee */
	#define G0_LC_TTEE		ACS_TTEE			 /* Graphical line char top tee */
	#define G0_LC_LTEE		ACS_LTEE			 /* Graphical line char left tee */
	#define G0_LC_HORZ		ACS_HLINE			 /* Graphical line char horizontal */
	#define G0_LC_CROSS		ACS_PLUS			 /* Graphical line char cross */
	#define G0_LC_BR		ACS_LRCORNER		 /* Graphical line char bottom right*/
	#define G0_LC_TL		ACS_ULCORNER		 /* Graphical line char top left */
	/* Graphical special characters */
	#define G0_SC_BRICK		ACS_CKBOARD			 /* Graphical special char brick */
	#define G0_SC_BUTTON	ACS_CKBOARD			 /* Graphical special char button */
	#define G0_SC_SCRLBUT	ACS_CKBOARD			 /* Graphical special char scrollbutton */
	#define G0_SC_DIAMOND	ACS_DIAMOND			 /* Graphical special char diamond */
	#define G0_SC_DOT		acs_map[0x7E]
#endif

/* This is for terminals that don't support hi-ascii at all */
#ifdef WITHOUT_NCURSES
	/* Dumb line characters */
	#define DT_LC_VERT		0x7C				 /* | - Dumb line char vertical */
	#define DT_LC_RTEE		0x7C				 /* | - Dumb line char right tee */
	#define DT_LC_TR		0x2B				 /* + - Dumb line char top right */
	#define DT_LC_BL		0x2B				 /* + - Dumb line char bottom left */
	#define DT_LC_BTEE		0x2D				 /* - - Dumb line char bottom tee */
	#define DT_LC_TTEE		0x2D				 /* - - Dumb line char top tee */
	#define DT_LC_LTEE		0x7C				 /* | - Dumb line char left tee */
	#define DT_LC_HORZ		0x2D				 /* - - Dumb line char horizontal */
	#define DT_LC_CROSS		0x2B				 /* + - Dumb line char cross */
	#define DT_LC_BR		0x2B				 /* + - Dumb line char bottom right */
	#define DT_LC_TL		0x2B				 /* + - Dumb line char top left */
	/* Dumb special characters */
	#define DT_SC_BRICK		0x20				 /*   - Dumb special char brick */
	#define DT_SC_BUTTON	0x23				 /* # - Dumb special char button */
	#define DT_SC_SCRLBUT	0x23				 /* # - Dumb special char scrollbutton */
	#define DT_SC_DOT		0x2B				 /* + - Dumb special char dot */
#endif

/*
 * Hotkey macros
 */

#define XCTRL(x) ((x) & 0x1F)
#define ALT(x) (0x200 | (x))

#endif
