
/*
 * windows.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_WINDOWS_C
#define DIALOGS_WINDOWS_C

#include <iostream>
#include <stdlib.h>
#include <curses.h>
#include <panel.h>
#include <string.h>

#include "typedefs.h"
#include "windows.h"

void Windows::Init ()
{
   char *terminal = getenv ("TERM");
   initscr ();									 /* Initialize screen */
   start_color ();								 /* Initialize curses color routines */
   curs_set (CURSOR_INVISIBLE);					 /* Set cursor to invisible */
   cbreak ();									 /* Disable character buffering */
   noecho ();									 /* Disable character echoing */
   window = NULL;								 /* Initialize window stack */
   if (!strcmp (terminal,"linux") || !strcmp (terminal,"eterm-vga") || !strcmp (terminal,"Eterm-vga"))
	 {
		lcd_vert = LCD_VERT;
		lcd_rtee = LCD_RTEE;
		lcd_tr = LCD_TR;
		lcd_bl = LCD_BL;
		lcd_btee = LCD_BTEE;
		lcd_ttee = LCD_TTEE;
		lcd_ltee = LCD_LTEE;
		lcd_horz = LCD_HORZ;
		lcd_cross = LCD_CROSS;
		lcd_br = LCD_BR;
		lcd_tl = LCD_TL;
		lcs_vert = LCS_VERT;
		lcs_rtee = LCS_RTEE;
		lcs_tr = LCS_TR;
		lcs_bl = LCS_BL;
		lcs_btee = LCS_BTEE;
		lcs_ttee = LCS_TTEE;
		lcs_ltee = LCS_LTEE;
		lcs_horz = LCS_HORZ;
		lcs_cross = LCS_CROSS;
		lcs_br = LCS_BR;
		lcs_tl = LCS_TL;
		sc_brick = SC_BRICK;
		sc_dot = SC_DOT;
		sc_button = SC_BUTTON;
		sc_scrlbut = SC_SCRLBUT;
	 }
   else
	 {
		lcd_vert = G0_LC_VERT;
		lcd_rtee = G0_LC_RTEE;
		lcd_tr = G0_LC_TR;
		lcd_bl = G0_LC_BL;
		lcd_btee = G0_LC_BTEE;
		lcd_ttee = G0_LC_TTEE;
		lcd_ltee = G0_LC_LTEE;
		lcd_horz = G0_LC_HORZ;
		lcd_cross = G0_LC_CROSS;
		lcd_br = G0_LC_BR;
		lcd_tl = G0_LC_TL;
		lcs_vert = G0_LC_VERT;
		lcs_rtee = G0_LC_RTEE;
		lcs_tr = G0_LC_TR;
		lcs_bl = G0_LC_BL;
		lcs_btee = G0_LC_BTEE;
		lcs_ttee = G0_LC_TTEE;
		lcs_ltee = G0_LC_LTEE;
		lcs_horz = G0_LC_HORZ;
		lcs_cross = G0_LC_CROSS;
		lcs_br = G0_LC_BR;
		lcs_tl = G0_LC_TL;
		sc_brick = G0_SC_BRICK;
		sc_dot = /*G0_SC_DIAMOND*/G0_SC_DOT;
		sc_button = G0_SC_BUTTON;
		sc_scrlbut = G0_SC_SCRLBUT;
	 }
}

void Windows::Close ()
{
   echo ();										/* Enable character echoing */
   attrset (A_NORMAL);							/* Set window attributes to normal display */
   clear ();									/* Clear the screen */
   curs_set (CURSOR_NORMAL);					/* Set cursor to normal */
   refresh ();									/* Update screen */
   endwin ();									/* Restore tty modes */
}

void Windows::operator = (const Windows &child)
{
   lcd_vert = child.lcd_vert;
   lcd_rtee = child.lcd_rtee;
   lcd_tr = child.lcd_tr;
   lcd_bl = child.lcd_bl;
   lcd_btee = child.lcd_btee;
   lcd_ttee = child.lcd_ttee;
   lcd_ltee = child.lcd_ltee;
   lcd_horz = child.lcd_horz;
   lcd_cross = child.lcd_cross;
   lcd_br = child.lcd_br;
   lcd_tl = child.lcd_tl;
   lcs_vert = child.lcs_vert;
   lcs_rtee = child.lcs_rtee;
   lcs_tr = child.lcs_tr;
   lcs_bl = child.lcs_bl;
   lcs_btee = child.lcs_btee;
   lcs_ttee = child.lcs_ttee;
   lcs_ltee = child.lcs_ltee;
   lcs_horz = child.lcs_horz;
   lcs_cross = child.lcs_cross;
   lcs_br = child.lcs_br;
   lcs_tl = child.lcs_tl;
   sc_brick = child.sc_brick;
   sc_dot = child.sc_dot;
   sc_button = child.sc_button;
   sc_scrlbut = child.sc_scrlbut;
   window = child.window;
}

void Windows::Update ()
{
   update_panels ();
   doupdate ();
}

void Windows::Refresh ()
{
   wrefresh (curscr);
}

PANEL *Windows::mkpanel (int cols, int rows, int tlx, int tly)
{
   WINDOW *win = newwin (rows,cols,tly,tlx);
   PANEL *pan;
   if (!win) return ((PANEL *) NULL);
   if ((pan = new_panel (win))) return (pan);
   delwin (win);
   return ((PANEL *) NULL);
}

void Windows::rmpanel (PANEL *pan)
{
   WINDOW *win = panel_window (pan);
   del_panel (pan);
   delwin (win);
}

void Windows::fillpanel (PANEL *pan,int attr,int fg,int bg)
{
   WINDOW *win = panel_window (pan);
   int i,x,y;
   setcolor (win,fg,bg,attr);
   getmaxyx (win,y,x);
   for (i = 0; i < x * y; i++) waddch (win,' ');
}

void Windows::doubleframe (PANEL *pan)
{
   WINDOW *win = panel_window (pan);
   wborder (win,lcd_vert,lcd_vert,lcd_horz,lcd_horz,lcd_tl,lcd_tr,lcd_bl,lcd_br);
}

void Windows::singleframe (PANEL *pan)
{
   WINDOW *win = panel_window (pan);
   wborder (win,lcs_vert,lcs_vert,lcs_horz,lcs_horz,lcs_tl,lcs_tr,lcs_bl,lcs_br);
}

void Windows::showtitle (PANEL *pan,const char *title)
{
   WINDOW *win = panel_window (pan);
   int x,y;
   if (strlen (title))
	 {
		getmaxyx (win,y,x);
		wmove (win,0,(x - strlen (title) - 2) >> 1);
		waddch (win,' ');
		waddstr (win,title);
		waddch (win,' ');
	 }
}

void Windows::horzline (PANEL *pan,int x1,int x2,int y,bool single,bool visible,int left,int right)
{
   WINDOW *curwin = panel_window (pan);
   chtype linetype;
   if (!visible)
	 for (int i = x1; i <= x2; i++) mvwaddch (curwin,y,i,' ');
   else
	 {
		linetype = single ? lcs_horz : lcd_horz;
		if (x1 == x2)
		  {
			 if (left == right == SIDE_NORMAL) mvwaddch (curwin,y,x1,linetype); else return;
		  }
		else
		  {
			 for (int i = x1 + 1; i < x2; i++) mvwaddch (curwin,y,i,linetype);
			 if (single)
			   {
				  switch (left)
					{
					 case SIDE_NORMAL:
					   linetype = lcs_horz; break;
					 case SIDE_TNORMAL:
					   linetype = lcs_ltee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcs_bl; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcs_tl; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcs_btee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcs_ttee; break;
					 case SIDE_CROSS:
					   linetype = lcs_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y,x1,linetype);
				  switch (right)
					{
					 case SIDE_NORMAL:
					   linetype = lcs_horz; break;
					 case SIDE_TNORMAL:
					   linetype = lcs_rtee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcs_br; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcs_tr; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcs_btee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcs_ttee; break;
					 case SIDE_CROSS:
					   linetype = lcs_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y,x2,linetype);
			   }
			 else
			   {
				  switch (left)
					{
					 case SIDE_NORMAL:
					   linetype = lcd_horz; break;
					 case SIDE_TNORMAL:
					   linetype = lcd_ltee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcd_bl; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcd_tl; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcd_btee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcd_ttee; break;
					 case SIDE_CROSS:
					   linetype = lcd_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y,x1,linetype);
				  switch (right)
					{
					 case SIDE_NORMAL:
					   linetype = lcd_horz; break;
					 case SIDE_TNORMAL:
					   linetype = lcd_rtee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcd_br; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcd_tr; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcd_btee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcd_ttee; break;
					 case SIDE_CROSS:
					   linetype = lcd_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y,x2,linetype);
			   }
		  }
	 }
}

void Windows::vertline (PANEL *pan,int x,int y1,int y2,bool single,bool visible,int top,int bottom)
{
   WINDOW *curwin = panel_window (pan);
   chtype linetype;
   if (!visible)
	 for (int i = y1; i <= y2; i++) mvwaddch (curwin,i,x,' ');
   else
	 {
		linetype = single ? lcs_vert : lcd_vert;
		if (y1 == y2)
		  {
			 if (top == bottom == SIDE_NORMAL) mvwaddch (curwin,y1,x,linetype); else return;
		  }
		else
		  {
			 for (int i = y1 + 1; i < y2; i++) mvwaddch (curwin,i,x,linetype);
			 if (single)
			   {
				  switch (top)
					{
					 case SIDE_NORMAL:
					   linetype = lcs_vert; break;
					 case SIDE_TNORMAL:
					   linetype = lcs_ttee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcs_tr; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcs_tl; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcs_rtee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcs_ltee; break;
					 case SIDE_CROSS:
					   linetype = lcs_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y1,x,linetype);
				  switch (bottom)
					{
					 case SIDE_NORMAL:
					   linetype = lcs_vert; break;
					 case SIDE_TNORMAL:
					   linetype = lcs_btee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcs_br; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcs_bl; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcs_rtee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcs_ltee; break;
					 case SIDE_CROSS:
					   linetype = lcs_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y2,x,linetype);
			   }
			 else
			   {
				  switch (top)
					{
					 case SIDE_NORMAL:
					   linetype = lcd_vert; break;
					 case SIDE_TNORMAL:
					   linetype = lcd_ttee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcd_tr; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcd_tl; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcd_rtee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcd_ltee; break;
					 case SIDE_CROSS:
					   linetype = lcd_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y1,x,linetype);
				  switch (bottom)
					{
					 case SIDE_NORMAL:
					   linetype = lcd_vert; break;
					 case SIDE_TNORMAL:
					   linetype = lcd_btee; break;
					 case SIDE_LEFT:
					 case SIDE_UP:
					   linetype = lcd_br; break;
					 case SIDE_RIGHT:
					 case SIDE_DOWN:
					   linetype = lcd_bl; break;
					 case SIDE_TLEFT:
					 case SIDE_TUP:
					   linetype = lcd_rtee; break;
					 case SIDE_TRIGHT:
					 case SIDE_TDOWN:
					   linetype = lcd_ltee; break;
					 case SIDE_CROSS:
					   linetype = lcd_cross; break;
					 default:
					   linetype = 0xDB;		/* This shouldn't happen!!! */
					}
				  mvwaddch (curwin,y2,x,linetype);
			   }
		  }
	 }
}

void Windows::setcolor (WINDOW *win,int fg,int bg,int attr)
{
   int color = (bg << 3) + fg;
   init_pair (color,fg,bg);
   wattrset (win,COLOR_PAIR (color) | attr);
}

void Windows::setcolor (WINDOW *win,int fg,int bg)
{
   int color = (bg << 3) + fg;
   init_pair (color,fg,bg);
   wattrset (win,COLOR_PAIR (color));
}

void Windows::setcolor (int fg,int bg,int attr)
{
   int color = (bg << 3) + fg;
   init_pair (color,fg,bg);
   attrset (COLOR_PAIR (color) | attr);
}

void Windows::setcolor (int fg,int bg)
{
   int color = (bg << 3) + fg;
   init_pair (color,fg,bg);
   attrset (COLOR_PAIR (color));
}

void Windows::Add (int cols,int rows,int tlx,int tly,const char *title,int attr,int fg,int bg)
{
   WinType *nw,*tmp;
   nw = (WinType *) malloc (sizeof (WinType));
   nw->next = NULL;
   nw->pan = mkpanel (cols + 2,rows + 2,tlx - 1,tly - 1);
   nw->title = (char *) malloc (strlen (title) + 1);
   nw->manual = FALSE;
   strcpy (nw->title,title);
   fillpanel (nw->pan,attr,fg,bg);
   doubleframe (nw->pan);
   showtitle (nw->pan,title);
   if (window == NULL)
     window = nw;
   else
     {
		tmp = window;
		while (tmp->next != NULL) tmp = tmp->next;
		if (!tmp->manual)
		  {
			 singleframe (tmp->pan);
			 showtitle (tmp->pan,tmp->title);
		  }
		tmp->next = nw;
	 }
}

void Windows::Remove ()
{
   WinType *tmp;
   if (window == NULL) return;
   if (window->next == NULL)
     {
		rmpanel (window->pan);
		free (window->title);
		free (window);
		window = NULL;
	 }
   else
     {
		tmp = window;
		while (tmp->next->next != NULL) tmp = tmp->next;
		rmpanel (tmp->next->pan);
		free (tmp->next->title);
		free (tmp->next);
		tmp->next = NULL;
		if (!tmp->manual)
		  {
			 doubleframe (tmp->pan);
			 showtitle (tmp->pan,tmp->title);
		  }
	 }
}

WINDOW *Windows::GetWindow ()
{
   WinType *tmp;
   update_panels ();
   tmp = window;
   while (tmp->next != NULL) tmp = tmp->next;
   return panel_window (tmp->pan);
}

PANEL *Windows::GetPanel ()
{
   WinType *tmp;
   update_panels ();
   tmp = window;
   while (tmp->next != NULL) tmp = tmp->next;
   return (tmp->pan);
}

void Windows::disableframes ()
{
   WinType *tmp;
   update_panels ();
   tmp = window;
   while (tmp->next != NULL) tmp = tmp->next;
   tmp->manual = TRUE;
}

#endif
