
/*
 * menus.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MENUS_C
#define MENUS_C

#include <stdlib.h>

#include "menus.h"

Menus::Menus ()
{
   idlist = NULL;
}

Menus::~Menus ()
{
   MenuIdList *tmp;
   while (idlist != NULL)
	 {
		if (idlist->next == NULL)
		  {
			 free (idlist);
			 idlist = NULL;
		  }
		else
		  {
			 tmp = idlist;
			 while (tmp->next->next != NULL) tmp = tmp->next;
			 free (tmp->next);
			 tmp->next = NULL;
		  }
	 }
}

void Menus::AddMenu (int type)
{
   MenuIdList *nw,*tmp;
   nw = (MenuIdList *) malloc (sizeof (MenuIdList));
   nw->id = type;
   nw->next = NULL;
   if (idlist == NULL)
	 idlist = nw;
   else
	 {
		tmp = idlist;
		while (tmp->next != NULL) tmp = tmp->next;
		tmp->next = nw;
	 }
}

void Menus::RemoveMenu (int type)
{
   MenuIdList *current,*previous;
   bool finished = FALSE;
   current = idlist;
   previous = NULL;
   while ((current != NULL) && (!finished))
     {
		if (current->id == type)
		  {
			 if ((previous != NULL) && (current->next != NULL)) previous->next = current->next;
			 else if (previous == NULL) idlist = current->next;
			 else previous->next = NULL;
			 free (current);
			 finished = TRUE;
		  }
		else
		  {
			 previous = current;
			 current = current->next;
		  }
	 }
}

int Menus::GetMenu ()
{
   MenuIdList *tmp;
   if (idlist == NULL) return -1;
   tmp = idlist;
   while (tmp->next != NULL) tmp = tmp->next;
   return tmp->id;
}

#endif
