from yaml import dump

from twisted.internet.defer import succeed

from juju.lib.testing import TestCase
from juju.providers.orchestra import MachineProvider


def get_provider():
    config = {"orchestra-server": "somewhe.re",
              "orchestra-user": "user",
              "orchestra-pass": "pass",
              "acquired-mgmt-class": "acquired",
              "available-mgmt-class": "available"}
    return MachineProvider("tetrascape", config)


class StateTest(TestCase):

    def test_save(self):
        state = {"foo": "blah blah"}
        getPage = self.mocker.replace("twisted.web.client.getPage")
        getPage("http://somewhe.re/webdav/provider-state",
                method="PUT", postdata=dump(state))
        self.mocker.result(succeed(None))
        self.mocker.replay()

        provider = get_provider()
        d = provider.save_state(state)

        def verify(result):
            self.assertEquals(result, True)
        d.addCallback(verify)
        return d

    def test_load(self):
        expect_state = {"foo": "blah blah"}
        getPage = self.mocker.replace("twisted.web.client.getPage")
        getPage("http://somewhe.re/webdav/provider-state")
        self.mocker.result(succeed(dump(expect_state)))
        self.mocker.replay()

        provider = get_provider()
        d = provider.load_state()

        def verify(state):
            self.assertEquals(state, expect_state)
        d.addCallback(verify)
        return d
