#ifndef K3DSDK_XML_UTILITY_H
#define K3DSDK_XML_UTILITY_H

#include <string>

// Forward declarations
namespace sdpxml { class Element; }

namespace k3d
{

namespace xml
{

/// Returns a reference to a child element with the given name, creating it from scratch if it doesn't already exist
sdpxml::Element& safe_element(sdpxml::Element& Parent, const std::string& Name);
/// Returns a reference to a child element that matches the Search element, creating it from the Search if it doesn't already exist
sdpxml::Element& safe_element(sdpxml::Element& Parent, const sdpxml::Element& Search);
/// Returns a reference to a child element that matches the Search element, creating it from the Prototype if it doesn't already exist
sdpxml::Element& safe_element(sdpxml::Element& Parent, const sdpxml::Element& Search, const sdpxml::Element& Prototype);

} // namespace xml

} // namespace k3d

#endif // !K3DSDK_XML_UTILITY_H

