#ifndef K3DSDK_IPRIVATE_USER_INTERFACE_H
#define K3DSDK_IPRIVATE_USER_INTERFACE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares k3d::iprivate_user_interface, an abstract interface implemented by objects that implement their own UI
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"

namespace k3d
{

/** \brief Abstract interface implemented by plugins that provide their own UI
	\deprecated This interface is temporary workaround for plugins with more-complicated-than-usual interfaces during our transition to a clean separation of user interface and implementation layers.  In general, plugins should never provide their own UI.
*/
class iprivate_user_interface :
	public virtual iunknown
{
public:
	/// Displays the user interface for this object
	virtual void show_user_interface() = 0;

protected:
	iprivate_user_interface() {}
	iprivate_user_interface(const iprivate_user_interface&) {}
	iprivate_user_interface& operator = (const iprivate_user_interface&) { return *this; }
	virtual ~iprivate_user_interface() {}
};

} // namespace k3d

#endif // K3DSDK_IPRIVATE_USER_INTERFACE_H


